//
//  XTFontUtils.m
//  XTads
//
//  Created by Rune Berg on 24/04/15.
//  Copyright (c) 2015 Rune Berg. All rights reserved.
//

#import "XTFontUtils.h"


@implementation XTFontUtils

static XTFontUtils *singletonInstance;

+ (void)initialize
{
	singletonInstance = [XTFontUtils new];
}

+ (id)fontUtils
{
	return singletonInstance;
}

- (NSFont *)boldVersionOfFont:(NSFont *)font
{
	// see http://www.cocoabuilder.com/archive/cocoa/133618-nsfont-bold.html
	
	NSFontManager *nsfontManager = [NSFontManager sharedFontManager];
	NSFont* boldFont = [nsfontManager convertFont:font toHaveTrait:NSBoldFontMask];
	if (boldFont == font) {
		// original font has no bold version, so try a different approach
		boldFont = [nsfontManager convertWeight:YES ofFont:font];
	}
	return boldFont;
}

@end
