//
//  XTGameRunnerProtocol.h
//  TadsTerp
//
//  Created by Rune Berg on 19/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//
//  ------------------------------------------------------
//  The methods used by osxtads.m to interact with
//  the user interface.
//  ------------------------------------------------------
//

#import <Foundation/Foundation.h>


typedef NS_ENUM(NSInteger, XTadsInputDialogIconId) {
	XTadsInputDialogIconIdNone,
	XTadsInputDialogIconIdWarning,
	XTadsInputDialogIconIdInfo,
	XTadsInputDialogIconIdQuestion,
	XTadsInputDialogIconIdError
};

typedef NS_ENUM(NSInteger, XTadsFileNameDialogFileType) {
	XTadsFileNameDialogFileTypeSavedGame,
	XTadsFileNameDialogFileTypeTranscript,
	XTadsFileNameDialogFileTypeCommandScript,
	XTadsFileNameDialogFileTypeGeneral
};

@protocol XTGameRunnerProtocol <NSObject>

@property BOOL htmlMode;
@property (nonatomic) NSInteger statusMode;
@property BOOL nonstopMode;
@property BOOL isSleeping;

- (void)setHiliteMode:(BOOL)hiliteMode;

- (BOOL)showTerpCopyrightAtGameStart;

- (void)setTads2InternalCharSet:(NSString*)charSet;

- (NSString *)makeString:(const char *)str;

- (NSString *)makeString:(const char *)str len:(size_t)len;

- (const char*)makeCStringInteractive:(NSString *)string;

- (const char*)makeCStringQuiet:(NSString *)string;

- (void)printOutput:(NSString *)s;

- (void)flushOutput;

- (void)showScore:(NSString *)scoreString;

- (NSUInteger)waitForKeyEvent:(NSInteger*)keyData;

- (NSUInteger)waitForAnyKeyPressed;

- (void)showMorePromptAndWaitForKeyPressed;

- (NSString *)waitForCommand;

- (void)sleepFor:(double)seconds;

- (void)clearScreen;

- (void)setGameTitle:(NSString *)title;

- (NSUInteger) inputDialogWithTitle:title
				standardButtonSetId:(NSUInteger)standardButtonSetId
				  customButtomSpecs:(NSArray *)customButtomSpecs
					   defaultIndex:(NSUInteger)defaultIndex
						cancelIndex:(NSUInteger)cancelIndex
							 iconId:(XTadsInputDialogIconId)iconId;

- (NSURL *)getFileNameForFor:(XTadsFileNameDialogFileType)fileType
				 dialogTitle:(NSString *)dialogTitle
		 fileTypeDescription:(NSString *)fileTypeDescription
		   allowedExtensions:(NSArray *)allowedExtensions
				existingFile:(BOOL)existingFile;

@end
