//
//  XTBaseTextHandler_private.h
//  XTads
//
//  Created by Rune Berg on 11/08/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTBaseTextHandler.h"


#define NO_CHILD_INDEX  (-1)


@interface XTBaseTextHandler ()

@property NSString *debugName;

@property (weak) XTBaseTextHandler *parentHandler;
@property NSMutableArray *childHandlers; // of XTBannerHandler

@property (weak) XTBannerTextHandler *siblingForWhere; // "other"

@property NSMutableArray *layoutViews;

@property XTPrefs *prefs;

@property NSMutableArray *formattingQueue;

@property NSAttributedString *attributedStringThatBrokePaginationLimit;
@property CGFloat maxTextViewHeightBeforePagination;

@property CGFloat visibleHeightBeforeLayoutOfViews;
@property CGFloat totalHeightBeforeLayoutOfViews;

@property NSRect visibleRectAtStartOfWindowResize;

@property BOOL nonstopModeState;


- (void)setBannerIndex:(NSUInteger) bannerIndex;

- (NSAttributedString *)appendAttributedStringToTextStorage:(NSAttributedString *)attrString;

- (void)addChildHandler:(XTBannerTextHandler *)childHandler;

- (NSInteger)indexOfChild:(XTBannerTextHandler*)childHandler;

- (void)tearDownLayoutViews;

- (void)teardownReceptionOfAppLevelNotifications;

- (NSView *)internalRebuildViewHierarchy;

- (void)noteStartOfLayoutOfViews;

- (void)noteEndOfLayoutOfViews;

- (void)clearPaginationState;

- (BOOL)shouldAutoScrollToBottom;

- (void)addEdgeConstraint:(NSLayoutAttribute)edge
				superview:(NSView *)superview
				  subview:(NSView *)subview;

- (void)recalcDynamicTabStops:(BOOL)changedMainOutputAreaSize;

- (void)newLayoutInParentView:(NSView *)parentView
				   childView1:(NSView *)childView1
				   childView2:(NSView *)childView2
		  childView2Alignment:(NSUInteger)childView2Alignment
			   childView2Size:(CGFloat)childView2Size
		 childView2IsAbsSized:(BOOL)childView2IsAbsSized;

- (BOOL)processFormattingQueue;

- (BOOL)formattingQueueNeedsFlushing;

- (void)restoreStringThatBrokePaginationLimit;

- (BOOL)checkIfHasReachedPaginationLimit:(NSAttributedString *)lastAttrStringAppended;

- (void)removeAttributedStringFromEndOfTextStorage:(NSAttributedString *)attrString;

- (void)removeFromTextStorage:(NSRange)range;

@end
