#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "structs.h"

#define VERSION	"0.1a"
#define PATH_SEP		0x5C		// unix==0x2F

unsigned short retShort(unsigned short);
unsigned long retLong(unsigned long);
void ischar(char *deststring, char *instring, char ch, char *addstring);

void main(short argc, char *argv[])
{
	FILE *fp;
	HEAD h;
	char	fn1[256];
	int	i;

	fprintf(stderr, "Magnetic Info v" VERSION "; by Dark Fiber <entropy@mpx.com.au>\n");
	if(argc>=2)
	{
		for(i=1; i<argc; i++)
		{
    		ischar(fn1, argv[i], '.', ".mag");
    		if((fp=fopen(fn1, "rb"))!=NULL)
    		{
    			fread(&h, 1, sizeof(HEAD), fp);
    			fclose(fp);
    			if(strncmp(h.magic, "MaSc", 4)==NULL)
    			{
    				printf("\nFile Name : %s\n", fn1);
    				printf("File Size : %li\n", retLong(h.file_size));
    				printf("Header Size : %li\n", retLong(h.header_size));
    				printf("Version : v%i.%i\n", retShort(h.version)&0xFF, retShort(h.version)>>8);
    				printf("Main Memory Size : %li\n", retLong(h.main_memory_size));
    				printf("String 1 Size : %li\n", retLong(h.string1_size));
    				printf("String 2 Size : %li\n", retLong(h.string2_size));
    				printf("Dictionary Size : %li\n", retLong(h.dictionary_size));
    				printf("Decoding Offset : %#lx\n", retLong(h.decoding_offset));
    				printf("Undo Size : %li\n", retLong(h.undo_size));
    				printf("Undo-PC Size : %li\n", retLong(h.undopc_size));
    			}
    			else
    				fprintf(stderr, "ERROR : Not a valid Magnetic game file.\n");
    		}
    		else
    			fprintf(stderr, "ERROR : Cannot open file \"%s\"\n", fn1);
    	}
	}
	else
		fprintf(stderr, "Syntax -:- MagInfo gamefile{.mag}\n");
}

unsigned long retLong(unsigned long i)
{
	unsigned long l;

	l =(i&0x000000FF)<<24;
	l+=(i&0x0000FF00)<<8;
	l+=(i&0x00FF0000)>>8;
	l+=(i&0xFF000000)>>24;
	return(l);
}

unsigned short retShort(unsigned short i)
{
	unsigned short l;

	l=(i&0xFF)<<8;
	l+=(i&0xFF00)>>8;
	return(l);
}

void ischar(char *deststring, char *instring, char ch, char *addstring)
{
    char *point, k;

    strcpy(deststring, instring);
    point=strchr(deststring, 0x0);
    do
    {
    	point--;
        k=*point;
    }while((point!=deststring)&&(k!=PATH_SEP));
    if((strchr(point, ch))==NULL)
    	strcat(deststring, addstring);
}
