#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "structs.h"

#define VERSION	"0.1b"
#define PATH_SEP	0x5C			// unix == 0x2F

unsigned short retShort(unsigned short);
unsigned long retLong(unsigned long);
void	ischar(char *deststring, char *instring, char ch, char *addstring);
void	vocabulary(char *s);

void main(short argc, char *argv[])
{
	fprintf(stderr, "Magnetic Vocabulary Decoder v" VERSION "; Dark Fiber <entropy@mpx.com.au>\n");
	if(argc>1)
	{
		vocabulary(argv[1]);
	}
	else
	{
		fprintf(stderr, "Syntax -:- gamefile{.mag}\n");
	}
}

void ischar(char *deststring, char *instring, char ch, char *addstring)
{
    char *point, k;

    strcpy(deststring, instring);
    point=strchr(deststring, 0x0);
    do
    {
    	point--;
        k=*point;
    }while((point!=deststring)&&(k!=PATH_SEP));
    if((strchr(point, ch))==NULL)
    	strcat(deststring, addstring);
}

unsigned long retLong(unsigned long i)
{
	unsigned long l;

	l =(i&0x000000FF)<<24;
	l+=(i&0x0000FF00)<<8;
	l+=(i&0x00FF0000)>>8;
	l+=(i&0xFF000000)>>24;
	return(l);
}

unsigned short retShort(unsigned short i)
{
	unsigned short l;

	l=(i&0xFF)<<8;
	l+=(i&0xFF00)>>8;
	return(l);
}


void vocabulary(char *s)
{
	char	fn1[256];
	FILE	*fp;
	HEAD	h;
	unsigned long i;
	char	*p;
	char	k, q;
	short	bank=0;

	ischar(fn1, s, '.', ".mag");
	if((fp=fopen(fn1, "rb"))!=NULL)
	{
		fread(&h, 1, sizeof(HEAD), fp);
		if(strncmp(h.magic, "MaSc", 4)==NULL)
		{
			i=0;
			if(retShort(h.version)>1)
			{
			    i=sizeof(HEAD);
				i+=retLong(h.main_memory_size);
				i+=retLong(h.string1_size);
				i+=retLong(h.string2_size);
			}
			else
			{
				if(retShort(h.version)==0)
					i=0x9a;
				else
					i=0x296;
			}

/*
			i=retLong(h.decoding_offset);
			if(i>=retLong(h.string1_size))
				i=i+(retLong(h.string2_size)) - (retLong(h.string1_size));
			else
				i=i+retLong(h.string1_size);
*/
			fprintf(stderr, "%#lx\n", i);
			fseek(fp, i, SEEK_SET);

			p=(signed char *)fn1;
			k=0;
			q=0;
			printf("Bank %02u\n=======\n", bank);
			bank++;
			while(i!=0)
			{
				*p=fgetc(fp);
				*(p+1)=0x0;
				if(*p==0x0)
				{
					//*p=fgetc(fp);
					//if(*p==0x0)
						i=0;
				}
				if(i!=0x0)
				{
					if(*p>=0x80)
					{
						*p-=0x80;
						q=1;
					}

					switch(*p)
					{
						case 0x01:
							printf("\n\nNext Section\n============\n");
							k=0;
							q=0;
							bank=0;
							printf("Bank %02u\n=======\n", bank);
							bank++;
							break;

						case 0x02:
							if(k>0)
								printf("\n");
							printf("\nBank %02u\n=======\n", bank);
							bank++;
							k=0;
							q=0;
							break;

						default:
							if(q==1)
							{
								q=0;
            					fprintf(stdout, "%-38s", fn1);
            					fflush(stdout);
            					p=fn1;
            					*p=0x0;
            					k++;
            					if(k==2)
            					{
            						k=0;
            						fprintf(stdout, "\n");
            					}
            				}
            				else
            					p++;
							break;
        			}
    			}
			}
			fprintf(stdout, "\n");
		}
		else
			fprintf(stderr, "Error : Not a valid MAGNETIC game file.\n");

		fclose(fp);
	}
	else
		fprintf(stderr, "Error : Cannot open \"%s\"\n", fn1);
}
