
/* advcom.h - adventure compiler definitions */
/*
	Copyright (c) 1986, by David Michael Betz
	All rights reserved
*/

#include <stdio.h>
#include <ctype.h>

/* limits */
#define TKNSIZE		(( int)50)	/* maximum token size */
#define OSIZE		(( int)104)	/* maximum object size (O_SIZE/2 + OPMAX*2) */
#define OPMAX		(( int)50)	/* maximum # properties/object */
#define WMAX		(( int)500)	/* maximum number of words */
#define OMAX		(( int)500)	/* maximum number of objects */
#define AMAX		(( int)200)	/* maximum number of actions */
#define DMAX		(( int)16384)	/* maximum data space */
#define CMAX		(( int)16384)	/* maximum code space */
#define FMAX		(( int)20)	/* file name maximum */

/* useful definitions */
#define TRUE		(( int)1)
#define FALSE		(( int)0)
#define EOS		'\0'            

/* token definitions */
#define T_OPEN		(( int)1)
#define T_CLOSE		(( int)2)
#define T_STRING	(( int)3)
#define T_IDENTIFIER	(( int)4)
#define T_NUMBER	(( int)5)
#define T_EOF		(( int)6)

/* symbol types */
#define ST_OBJECT	(( int)1)
#define ST_ACTION	(( int)2)
#define ST_VARIABLE	(( int)3)
#define ST_CONSTANT	(( int)4)
#define ST_PROPERTY	(( int)5)
                                        
/* symbol structure */
typedef struct symbol {
    char *s_name;		/* symbol name */
    MyInt s_type;			/* symbol type */
    MyInt s_value;		/* symbol value */
    struct symbol *s_next;	/* next symbol in table */
} SYMBOL;

/* function argument structure */
typedef struct argument {
    char *arg_name;		/* argument name */
    struct argument *arg_next;	/* next argument */
} ARGUMENT;
