/*

Mats 2.42
11 january 1998
Martin Tillenius (mrtn@rocketmail.com) (UIN: 1207958)

*/

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>

#define MAX_WORDLEN 128
#define MAX_LABELS 16
#define MAX_PARENTHESIS 16
#define MAX_BRACES 16
#define MAX_STRINGS 512
#define MAX_STRING_LENGTH 512
#define MAX_WORDS_TOK 2048
#define MAX_CHARS_WT 32
#define MAX_OBJECTS 64
#define MAX_DEFINES 128
#define MAX_DEFWORDS 128
#define MAX_FILES 20

// #define DEBUG

char *wstr[MAX_WORDS_TOK];                 // the word string
int  wnum[MAX_WORDS_TOK];                  // the word number
int  wctr = 0;                             // a counter for the words

int  labp[MAX_LABELS];                     // where the label was
char *lstr[MAX_LABELS];                    // the name of the label
int  lctr = 0;                             // a counter for the labels

int  gotop[MAX_LABELS];                    // where the goto was
char *gstr[MAX_LABELS];                    // whch label to go to
int  gctr = 0;                             // a counter for the gotos

char *ostr[MAX_OBJECTS];                   // the object string
int  octr = 0;                             // a counter for the objects

char *string[MAX_STRINGS];                 // for common strings
int  sctr = 0;                             // a counter for the strings

char *dname[MAX_DEFINES];                  // name of the define
char *dstr[MAX_DEFINES][MAX_DEFWORDS];     // what to define to
int  dtype[MAX_DEFINES][MAX_DEFWORDS];     // string or word
int  dwords[MAX_DEFWORDS];
int  dctr = 0;                             // a counter for the defines

char *fname[MAX_FILES];                    // stack for includes
fstream ffile[MAX_FILES];
int  fline[MAX_FILES];
int  fctr = 0;

int  idword = 0;
int  idnum;

#include "agicodes.h"  // by Lance Ewing



int mats_addstring(char *str) {
/*******************************************************************************
* mats_addstring(char *)
*
* This functions adds a string to the table of strings, and returns the number
* it got. If the string's already in the table, it's number will be returned.
*
*/

  int i;
  for(i = 1; i <= sctr; i++) {
    if(string[i] != NULL)
      if(strcmp(string[i], str) == 0)
        return i;
  }
  if(++sctr == MAX_STRINGS) {
    cout << "***STRING OVERFLOW" << "\n";
    return 0;
  }
  string[sctr] = new char[strlen(str) + 1];
  strcpy(string[sctr], str);
  return sctr;
}

int mats_readword(char *word) {
/*******************************************************************************
* int mats_readword(char *, ifstream)
*
* Reads a word from the infile. Returns:
*  0 = word returned
*  1 = string returned
* -1 = end of file
*
*/

  int  quotation = 0;
  int  spaceok = 1;
  int  ptr = 0;
  int  comment = 0;
  int  rempos;
  int  remline;
  int  i;
  char tmpchr;

  word[ptr] = '\x00';

  if(idword > 0) {
    if(idword > dwords[idnum])
      idword = 0;
    else {
      strcpy(word, dstr[idnum][idword]);
      return dtype[idnum][idword++];
    }
  }

  while(ffile[fctr].good()) {

    ffile[fctr].get(tmpchr);

    if(quotation == 1) {
      if(tmpchr == '\\') {
        ffile[fctr].get(tmpchr);
        if(tmpchr == '\n') {
          fline[fctr]++;
          quotation = 2;
          break;
        }
        if(tmpchr == 'n')
          word[ptr++] = '\x0a';
        if(tmpchr == '\\')
          word[ptr++] = '\\';
        if(tmpchr == '\"') {
          word[ptr++] = '\"';
        }
        continue;
      }
      if(tmpchr == '\"') {
        quotation = 2;
        remline = fline[fctr];
        rempos = ffile[fctr].tellg();
        spaceok = 1;
        continue;
      }
      if(tmpchr == '\n') {
        fline[fctr]++;
        quotation = 2;
        break;
      } else
        word[ptr++] = tmpchr;
      continue;
    }

    if((spaceok == 1)
       || (comment > 0)) {
      while(isspace(tmpchr)) {
        if(tmpchr == '\n')
          fline[fctr]++;
        ffile[fctr].get(tmpchr);
      }
      spaceok = 0;
    }

    if(isspace(tmpchr)) {
      ffile[fctr].putback(tmpchr);
      break;
    }

    if((comment == 0)
       && (tmpchr == '[')) {
      ffile[fctr].ignore(512, '\n');
      fline[fctr]++;
      if(ptr > 0)
        break;
      spaceok = 1;
      continue;
    }

    if(tmpchr == '/') {
      ffile[fctr].get(tmpchr);
      if((tmpchr == '/')
         && (comment == 0)) {
        ffile[fctr].ignore(512, '\n');
        fline[fctr]++;
        if(ptr > 0)
          break;
        spaceok = 1;
        continue;
      }
      if(tmpchr == '*') {
        comment++;
        continue;
      }
      ffile[fctr].putback(tmpchr);
      tmpchr = '/';
    }

    if(tmpchr == '*') {
      ffile[fctr].get(tmpchr);
      if(tmpchr == '/') {
        comment--;
        if((comment == 0)
           && (ptr > 0))
          break;
        if(comment < 0) {
          comment = 0;
          word[ptr++] = '*';
          word[ptr++] = '/';
          continue;
        }
        spaceok = 1;
        continue;
      }
      ffile[fctr].putback(tmpchr);
      tmpchr = '*';
    }

    if(comment > 0)
      continue;

    if(tmpchr == '\"') {
      if(quotation == 2) {
        quotation = 1;
        continue;
      }
      if(ptr > 0)
        break;
      quotation = 1;
      continue;
    }

    if(quotation == 2) {
      ffile[fctr].seekg(rempos);
      fline[fctr] = remline;
      break;
    }


    if((tmpchr == '{')
       || (tmpchr == '}')
       || (tmpchr == ',')
       || (tmpchr == '(')
       || (tmpchr == ')')
       || (tmpchr == ';')) {
      if(ptr == 0) {
        word[ptr++] = tmpchr;
        break;
      }
      ffile[fctr].putback(tmpchr);
      break;
    }

    if(tmpchr == '!') {
      ffile[fctr].get(tmpchr);
      if(tmpchr == '=') {
        word[ptr++] = '!';
        word[ptr++] = '=';
        break;
      }
      ffile[fctr].putback(tmpchr);
      if(ptr == 0) {
        word[ptr++] = '!';
        break;
      }
      ffile[fctr].putback('!');
      break;
    }

    if(ffile[fctr].good())
      word[ptr++] = tmpchr;
  }

  if(!ffile[fctr].good()) {
    if(fctr != 1) {
      delete fname[fctr];
      ffile[fctr--].close();
      if(ptr == 0)
        return mats_readword(word);
      else {
        word[ptr] = '\x00';
        if(quotation == 2)
          return 1;
        else
          return 0;
      }
    }
    if(ptr >= 1) {
      word[ptr] = '\x00';
      return 0;
    }
    return -1;
  }

  word[ptr] = '\x00';

  if(strcmp(word, "#include") == 0) {
    mats_readword(word);

    fname[++fctr] = new char[strlen(word) + 1];
    strcpy(fname[fctr], word);
    fline[fctr] = 1;

    ffile[fctr].open(fname[fctr], ios::in);
    if (ffile[fctr].fail()) {
      cout << fline[fctr] << "." << fname[fctr] << ": ";
      cout << "Couldn't open include '" << fname[fctr--]<< "'\n";
      return -2;
    }

    return mats_readword(word);
  }

  for(i = 1; i <= dctr; i++)
    if(strcmp(dname[i], word) == 0) {
      idnum = i;
      idword = 1;
      strcpy(word, dstr[idnum][idword]);
      return dtype[idnum][idword++];
    }

  if(quotation == 2)
    return 1;

  return 0;
}



int mats_if(fstream &fout) {
/*******************************************************************************
* int mats_if(ifstream, fstream);
*
* This function takes care of the if statement and the test commands.
*
*/

  char lastword[MAX_STRING_LENGTH];            // remember the last word
  char word[MAX_STRING_LENGTH];                // the word read in

  int  pbeg[MAX_PARENTHESIS];                // where the parenthesis starts
  int  ptype[MAX_PARENTHESIS];               // if there was an OR in the if statement
  int  pctr = 0;                             // a counter for the parenthesis

  char tmpstr[MAX_STRING_LENGTH];            // temporary storage of the strings

  char tmpchr;

  unsigned char *tmp;

  int  i;
  int  j;
  int  k;
  int  args;
  int  pos;
  int  ok;
  int  glue = 0;

  fout.put('\xff');

  mats_readword(word);

  if(strcmp(word, "(") != 0) {
    cout << fline[fctr] << "." << fname[fctr] << ": ";
    cout << "If statement missing (\n";
    return 0;
  };

  pbeg[++pctr] = fout.tellg();
  ptype[pctr] = 0;

  while((ffile[fctr].good()) && (pctr > 0)) {

    strcpy(lastword, word);
    mats_readword(word);

    if(strcmp(word, "||") == 0) {      // or
      if(glue == 0) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Misplaced OR\n";
        return 0;
      }
      ptype[pctr] = 1;
      glue = 0;
      continue;
    }

    if(strcmp(word, "&&") == 0) { 		// and
      if(glue == 0) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Misplaced AND\n";
        return 0;
      }
      glue = 0;
      continue;
    }

    if(strcmp(word, ")") == 0) {       // end parenthesis
      if(pctr == 0) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Unbalanced parenthesis\n";
        return 0;
      }
      if(ptype[pctr] == 1) {           // parenthesis around OR
        j = fout.tellg() - pbeg[pctr];
        tmp = new unsigned char[j + 1];
        fout.seekg(pbeg[pctr]);
        for(i = 0; i < j; i++)
          fout.get(tmp[i]);
        fout.seekg(pbeg[pctr]);
        fout.put('\xfc');
        for(i = 0; i < j; i++)
          fout.put(tmp[i]);
        delete tmp;
        fout.put('\xfc');
      }
      pctr--;
      if(pctr == 0)
        break;
      glue = 1;
      continue;
    }

    if(glue == 1) {
      cout << fline[fctr] << "." << fname[fctr] << ": ";
      cout << "AND or OR missing!\n";
      return 0;
    }

    if(strcmp(word, "!") == 0) {       // not (!)
      fout.put('\xfd');
      glue = 0;
      continue;
    }

    if(strcmp(word, "(") == 0) {       // start parenthesis
      pbeg[++pctr] = fout.tellg();
      ptype[pctr] = 0;
      glue = 0;
      continue;
    }

// Test commands:

    ok = 0;

    for(i = 1; (i < NUM_TEST_COMMANDS); i++) {
      if(strcmp(word, testCommands[i].commandName) == 0) {
        fout.put((unsigned char) i);
        mats_readword(word);
        if(strcmp(word, "(") != 0) {
          cout << fline[fctr] << "." << fname[fctr] << ": ";
          cout << "( missing after " << testCommands[i].commandName << " statement\n";
          return 0;
        }

        if(i == 9) {                            // has()
          ok = 1;
          k = 0;
          while((ok > 0)
                && (ffile[fctr].good())) {
            ffile[fctr].get(tmpchr);
            if(tmpchr == ')')
              ok--;
            if(tmpchr == '(')
              ok++;
            if(ok > 0)
              tmpstr[k++] = tmpchr;
          }
          tmpstr[k] = '\0';

          k = -1;
          for(j = 1; j <= octr; j++)
            if(strcmp(ostr[j], tmpstr) == 0) {
              k = j - 1;
              break;
            }
          if(k == -1) {
            cout << fline[fctr] << "." << fname[fctr] << ": ";
            cout << "Unknown object " << tmpstr << "\n";
            return 0;
          }
          fout.put((unsigned char) k);
          ok = 1;
          glue = 1;
          break;
        }

        if(i == 14) {                          // said()
          pos = fout.tellg();
          fout.put('\x00');                    // number of arguments
          args = 0;
          do {
            tmpstr[0] = '\0';
            do {
              mats_readword(word);
              if((strcmp(word, ")") != 0)
                 && (strcmp(word, ",") != 0)) {
                strcat(tmpstr, word);
                strcat(tmpstr, " ");
              }
            } while((strcmp(word, ")") != 0)
                    && (strcmp(word, ",") != 0)
                    && (ffile[fctr].good()));

            tmpstr[strlen(tmpstr) - 1] = '\0';
            k = -1;
            for(j = 1; j <= wctr; j++) {
              if(stricmp(tmpstr, wstr[j]) == 0) {
                k = wnum[j];
                break;
              }
            }
            if(k == -1) {
              cout << fline[fctr] << "." << fname[fctr] << ": ";
              cout << "Unknown word '" << tmpstr << "'\n";
              return 0;
            }
            fout.put((unsigned char) (k & 0xff));
            fout.put((unsigned char) ((k & 0xff00) >> 8));
            args++;
          } while(strcmp(word, ",") == 0);
          fout.seekg(pos);
          fout.put((unsigned char) args);
          fout.seekg(0, ios::end);
          ok = 1;
          glue = 1;
          break;
        }

        mats_readword(word);
        while((strcmp(word, ")") != 0) && (ffile[fctr].good())) {
          if(strcmp(word, ",") != 0) {
            if(word[0] == 'v')
              word[0] = ' ';
            fout.put((unsigned char) atoi(word));
          }
          mats_readword(word);
        }
        ok = 1;
        glue = 1;
        break;
      }
    }

    if(ok == 1)
      continue;

    if(word[0] == 'v') {
      strcpy(lastword, word);
      mats_readword(word);

      if((strcmp(word, "==") == 0)       // comparations (==, !=, <, >)
         || (strcmp(word, "!=") == 0)
         || (strcmp(word, "<") == 0)
         || (strcmp(word, ">") == 0)
         || (strcmp(word, "<=") == 0)
         || (strcmp(word, ">=") == 0)) {
        i = 1;
        switch(word[0]) {
          case '!':
            fout.put('\xfd');
            break;
          case '<':
            if(word[1] == '=') {
              i = 5;
              fout.put('\xfd');
            }
            else
              i = 3;
            break;
          case '>':
            if(word[1] == '=') {
              i = 3;
              fout.put('\xfd');
            }
            else
              i = 5;
            break;
        }
        mats_readword(word);
        if(word[0] != 'v')
          fout.put((unsigned char) i);
        else {
          word[0] = ' ';
          fout.put((unsigned char) (i + 1));
        }
        fout.put((unsigned char) atoi(lastword + 1));
        fout.put((unsigned char) atoi(word));
        glue = 1;
        continue;
      }
      else {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Syntax error! (" << word << ")\n";
        return 0;
      }
    }

    cout << fline[fctr] << "." << fname[fctr] << ": ";
    cout << "Syntax error (" << word << ")\n";
    return 0;

  }

  fout.put('\xff');             // end of IF statement
  mats_readword(word);
  if(strcmp(word, "{") != 0) {
    cout << fline[fctr] << "." << fname[fctr] << ": ";
    cout << "{ missing after if statement\n";
    return 0;
  }
  i = fout.tellg();
  fout.put('\x00').put('\x00');
  return i;
}

int mats_precompile() {
/*******************************************************************************
* void mats_precompile(fstream)
*
* Searches through the source for messages.
*
*/

  char word[MAX_STRING_LENGTH];
  int i;
  int j;

  for(j = mats_readword(word); j >= 0; j = mats_readword(word)) {
    if(stricmp(word, "#message") == 0) {
      mats_readword(word);
      i = atoi(word);
      if(string[i] != NULL) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Message #" << i << " defined more than once!\n";
        return 1;
      }
      if(i > sctr)
        sctr = i;
      if(mats_readword(word) != 1) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Message #" << i << " corrupt.\n";
        return 1;
      }

      string[sctr] = new char[strlen(word) + 1];
      strcpy(string[sctr], word);
    }
  }
  if(j == -2)
    j = 1;
  else
    j = 0;

  fline[fctr] = 1;
  ffile[fctr].seekg(0);
  ffile[fctr].clear();
  return j;
}

int mats_compile(fstream &fout, int volnr) {
/*******************************************************************************
* int mats_compile(fstream, fstream)
*
* Compiles almost everything
*
*/

  const char    *avis = "Avis Durgan";

  char word[MAX_STRING_LENGTH];              // the word read in

  int  bbeg[MAX_BRACES];                     // where the braces start
  int  bctr = 0;                             // a counter for the braces

  int  i;
  int  j;
  int  k;
  int  pos;
  int  ok;
  int  offset;
  int  startoffset;
  int  eof;
  int  elseallowed = 0;

  if(volnr != -1) {
    fout.put('\x12').put('\x34');                      // AGI header
    fout.put((unsigned char) volnr);                   // vol - file
    fout.put('\x00').put('\x00');                      // length of file
  }

  startoffset = fout.tellg();

  fout.put('\x00').put('\x00');                      // pointer to the strings


  do {

    eof = mats_readword(word);

    if(elseallowed == 1) {
      if(strcmp(word, "else") != 0) {
        pos = fout.tellg();
        fout.seekg(bbeg[bctr]);
        fout.put((char) ((pos - (bbeg[bctr] + 2)) & 0xff));
        fout.put((char) (((pos - (bbeg[bctr] + 2)) & 0xff00) >> 8));
        fout.seekg(0, ios::end);
        bctr--;
      } else {                                       // else
        mats_readword(word);
        if(strcmp(word, "{") != 0) {
          cout << fline[fctr] << "." << fname[fctr] << ": ";
          cout << "{ missing after else\n";
          return 1;
        }
        pos = fout.tellg() + 3;
        fout.seekg(bbeg[bctr]);
        fout.put((char) ((pos - (bbeg[bctr] + 2)) & 0xff));
        fout.put((char) (((pos - (bbeg[bctr] + 2)) & 0xff00) >> 8));
        fout.seekg(0, ios::end);

        fout.put('\xfe');
        bbeg[bctr] = fout.tellg();
        fout.put('\x00').put('\x00');
        elseallowed = 0;

        continue;
      }
      elseallowed = 0;
    }

#ifdef DEBUG
    cout << bctr << "." << fline[fctr] << "." << fname[fctr] << ".";
    cout << fout.tellg() << ": " << word << "\n";
#endif

    while(stricmp(word, "#define") == 0) {           // define

      k = dctr;
      dctr = 0;  // disable defines
      mats_readword(word);
      dctr = k;

      j = 0;

      for(i = 1; i <= dctr; i++) {
        if(strcmp(dname[i], word) == 0) {
          delete dname[i];
          while(dwords[i] > 0)
            delete dstr[i][dwords[dctr]--];
          j = i;
          break;
        }
      }

      if(j == 0)
        j = ++dctr;

      dwords[j] = 0;
      dname[j] = new char[strlen(word) + 1];
      strcpy(dname[j], word);

      i = fline[fctr];

      dtype[j][++dwords[j]] = mats_readword(word);

      while(i == fline[fctr]) {
        dstr[j][dwords[j]] = new char[strlen(word) + 1];
        strcpy(dstr[j][dwords[j]], word);
        dtype[j][++dwords[j]] = mats_readword(word);
      }
      dwords[j]--;
    }

    if(strcmp(word, "}") == 0) {                     // end brace
      elseallowed = 1;
      continue;
    }

    if(strcmp(word, "if") == 0) {                    // IF statement
      bbeg[++bctr] = mats_if(fout);
      if(bbeg[bctr] == 0)
        return 1;
      continue;
    }

// Action commands:

    ok = 0;
    for(i = 0; i < NUM_AGI_COMMANDS; i++) {
      if(strcmp(word, agiCommands[i].commandName) == 0) {
        fout.put((unsigned char) i);
        mats_readword(word);
        if(strcmp(word, "(") != 0) {
          cout << fline[fctr] << "." << fname[fctr] << ": ";
          cout << "( missing after " << agiCommands[i].commandName << " statement.\n";
          return 1;
        }

        j = mats_readword(word);

        while(strcmp(word, ")") != 0) {                      // Doesn't count the number of arguments. They can vary
                                                             // from different versions of AGI, so this one won't
                                                             // complain if you write crasy code.

          if(strcmp(word, ",") == 0)
            j = mats_readword(word);

          if(j == 1)
            fout.put((unsigned char) mats_addstring(word));
          else {
            if(word[0] == 'v')
              word[0] = ' ';
            fout.put((unsigned char) atoi(word));
          }
          j = mats_readword(word);
        }

        mats_readword(word);
        if(strcmp(word, ";") != 0) {
          cout << fline[fctr] << "." << fname[fctr] << ": ";
          cout << "; missing after " << agiCommands[i].commandName << " statement.\n";
          return 1;
        }
        ok = 1;
        break;
      }
    }

    if(ok == 1)
      continue;

    if(strcmp(word, "goto") == 0) {         // GOTO found
      fout.put('\xfe');
      gotop[++gctr] = fout.tellg();
      mats_readword(word);
      i = 0;
      if(strcmp(word, "(") == 0) {          // parenthesis around label
        i = 1;
        mats_readword(word);
      }
      gstr[gctr] = new char[strlen(word) + 1];
      strcpy(gstr[gctr], word);
      fout.put('\x00').put('\x00');
      mats_readword(word);
      if(i == 1) {
        if(strcmp(word, ")") != 0) {
          cout << fline[fctr] << "." << fname[fctr] << ": ";
          cout << "end parenthesis expected after GOTO (n), got " << word << "\n";
          return 1;
        }
        mats_readword(word);
      }
      if(strcmp(word, ";") != 0) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "; expected after GOTO (n), got " << word << "\n";
        return 1;
      }
      continue;
    }

    if(strlen(word) > 1)
      if(word[strlen(word) - 1] == ':') {     // LABEL found
        word[strlen(word) - 1] = '\0';
        labp[++lctr] = fout.tellg();
        lstr[lctr] = new char[strlen(word) + 1];
        strcpy(lstr[lctr], word);
        continue;
      }

    if(word[0] == '#') {
      ffile[fctr].ignore(512, '\n');
      continue;
    }

// Ok, no known meaning of the word. Assume it's a variable.

    if(word[0] == '*') {                    // indirection
      i = atoi(word + 2);
      mats_readword(word);
      if(strcmp(word, "=") != 0) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Unknown operator " << word << "\n";
        return 1;
      }
      mats_readword(word);

      if(word[0] == 'v') {
        j = atoi(word + 1);
        k = 0x09;
      } else {
        j = atoi(word);
        k = 0x0b;
      }
      fout.put((unsigned char) k);
      fout.put((unsigned char) i);
      fout.put((unsigned char) j);
      mats_readword(word);
      if(strcmp(word, ";") != 0) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "; expected after indirection, got " << word << "\n";
        return 1;
      }
      continue;
    }

    if(word[0] == 'v') {                    // probably some kind of variable manipulation
      if(strlen(word) >= 4)                       // v0++ and v0-- instructions
        if(((word[strlen(word) - 1] == '+')
           && (word[strlen(word) - 2] == '+'))
           || ((word[strlen(word) - 1] == '-')
           && (word[strlen(word) - 2] == '-'))) {
          i = 1;                                  // increment
          if(word[strlen(word) - 1] == '-')
            i = 2;                                // decrement
          word[strlen(word) - 2] = '\0';
          fout.put((unsigned char) i);
          fout.put((unsigned char) atoi(word + 1));
          mats_readword(word);
          if(strcmp(word, ";") != 0) {
            cout << fline[fctr] << "." << fname[fctr] << ": ";
            cout << "; missing after ++ or --\n";
            return 1;
          }
          continue;
        }

      i = atoi(word + 1);
      mats_readword(word);
      if((strcmp(word, "=") != 0)
         && (strcmp(word, "+=") != 0)
         && (strcmp(word, "-=") != 0)
         && (strcmp(word, "*=") != 0)
         && (strcmp(word, "/=") != 0)) {
        cout << fline[fctr] << "." << fname[fctr] << ": ";
        cout << "Unknown operator " << word << "\n";
        return 1;
      }

      if(strcmp(word, "=") == 0) {           // assignment
        mats_readword(word);
        if(word[0] == '*') {
          j = atoi(word + 2);
          mats_readword(word);
          if(strcmp(word, ";") != 0) {
            cout << fline[fctr] << "." << fname[fctr] << ": ";
            cout << "; expected after " << agiCommands[k].commandName << " (=) , got " << word << "\n";
            return 1;
          }
          fout.put('\x0a').put((unsigned char) i).put((unsigned char) j);
          continue;
        }
        if(word[0] == 'v') {                 // second argument variable
          j = atoi(word + 1);
          mats_readword(word);
          if((strcmp(word, "+") == 0)
             || (strcmp(word, "-") == 0)
             || (strcmp(word, "*") == 0)
             || (strcmp(word, "/") == 0)) {

            if(i != j) {
              cout << fline[fctr] << "." << fname[fctr] << ": ";
              cout << "Different variables not supported.\n";
              return 1;
            }

            switch(word[0]) {
              case '-':  k = 7;
                         break;
              case '*':  k = 165;
                         break;
              case '/':  k = 167;
                         break;
              default:   k = 5;
            }

            mats_readword(word);

            if(word[0] == 'v') {
              word[0] = ' ';
              k++;
            }
            j = atoi(word);
            fout.put((unsigned char) k);
            fout.put((unsigned char) i);
            fout.put((unsigned char) j);
            mats_readword(word);
            if(strcmp(word, ";") != 0) {
              cout << fline[fctr] << "." << fname[fctr] << ": ";
              cout << "; expected after " << agiCommands[k].commandName << " (=) , got " << word << "\n";
              return 1;
            }
            continue;
          }

          if(strcmp(word, ";") == 0) {       // assignv
            fout.put('\x04').put((unsigned char) i).put((unsigned char) j);
            continue;
          }
        }
        j = atoi(word);
        mats_readword(word);
        if(strcmp(word, ";") != 0) {
          cout << fline[fctr] << "." << fname[fctr] << ": ";
          cout << "; expected after assignment (n), got " << word << "\n";
          return 1;
        }
        fout.put('\x03').put((unsigned char) i).put((unsigned char) j);
        continue;
      }

      if((strcmp(word, "+=") == 0)                 // Those commands
         || (strcmp(word, "-=") == 0)
         || (strcmp(word, "*=") == 0)
         || (strcmp(word, "/=") == 0)) {

        switch(word[0]) {
          case '+':  k = 5;
                     break;
          case '-':  k = 7;
                     break;
          case '*':  k = 165;
                     break;
          case '/':  k = 167;
                     break;
        }

        mats_readword(word);
        if(word[0] == 'v') {
          word[0] = ' ';
          k++;
        }
        j = atoi(word);
        fout.put((unsigned char) k);
        fout.put((unsigned char) i);
        fout.put((unsigned char) j);

        mats_readword(word);
        if(strcmp(word, ";") != 0) {
          cout << fline[fctr] << "." << fname[fctr] << ": ";
          cout << "; expected after " << agiCommands[k].commandName << " (=) , got " << word << "\n";
          return 1;
        }
        continue;
      }
    }

    if(word[0] == '\x00')
      break;

    cout << fline[fctr] << "." << fname[fctr] << ": ";
    cout << "Unexpected: '" << word << "'\n";

    return 1;

  } while(eof != -1);

// finish it up
// ------------

// Add return(); to end of logic, if not already done.

  fout.seekg(-1, ios::end);
  if(fout.get() != 0)
    fout.put('\x00');

// Match GOTOs with labels

  for(i = 1; i <= gctr; i++) {
    ok = 0;
    for(j = 1; j <= lctr; j++)
      if(strcmp(gstr[i], lstr[j]) == 0) {
        fout.seekg(gotop[i]);
        fout.put((unsigned char) ((labp[j] - (gotop[i] + 2)) & 0xff));
        fout.put((unsigned char) (((labp[j] - (gotop[i] + 2)) & 0xff00) >> 8));
        fout.seekg(0, ios::end);
        ok = 1;
        break;
      }
    if(ok == 0) {
      cout << "Couldn't find label '" << gstr[i] << "'\n";
      return 1;
    }
  }

// write the pointer to the table of strings

  pos = fout.tellg() - 2 - startoffset;
  fout.seekg(startoffset);
  fout.put((unsigned char) (pos & 0xff));
  fout.put((unsigned char) ((pos & 0xff00) >> 8));
  fout.seekg(0, ios::end);

  fout.put((unsigned char) sctr); // number of strings
  pos = fout.tellg();
  fout.put('\x00');               // length of string block
  fout.put('\x00');

  offset = 2 * sctr + 2;          // first string after table of pointers


  for(i = 1; i <= sctr; i++) {    // write table
    if(string[i] != NULL) {
      fout.put((unsigned char) (offset & 0xff));
      fout.put((unsigned char) ((offset & 0xff00) >> 8));
      offset += strlen(string[i]) + 1;
    } else {
      fout.put('\x00');
      fout.put('\x00');
    }
  }

  fout.seekg(pos);                // write lenght of string block
  fout.put((unsigned char) (offset & 0xff));
  fout.put((unsigned char) ((offset & 0xff00) >> 8));
  fout.seekg(0, ios::end);

  k = 0;

  for(i = 1; i <= sctr; i++) {    // write the strings
    if(string[i] != NULL) {
      for(j = 0; string[i][j] != '\0'; j++) {
        fout.put(string[i][j] ^ avis[k++]);
        if(k == 11)
          k = 0;
      }
      fout.put(avis[k++]);          // this is a '\0x00' xored.
      if(k == 11)
        k = 0;
    }
  }

  if(volnr != -1) {
    pos = fout.tellg() - 5;
    fout.seekg(3);
    fout.put((unsigned char) (pos & 0xff));
    fout.put((unsigned char) ((pos & 0xff00) >> 8));
    fout.seekg(0, ios::end);
  }

  return 0;
}



void mats_readwords(ifstream &fin) {
/*******************************************************************************
* mats_readwords(ifstream);
*
* Decrypts and reads the vocabulary from the words.tok file.
*
*/

  int  i;
  int  same;
  int  w_nr;
  int  index[26];
  char letter;
  char w_name[MAX_CHARS_WT];

  for(i = 0; i < 26; i++) {
    index[i] = (((unsigned char) fin.get() << 8) + (unsigned char) fin.get());
  }

  for(i = 0; i < 26; i++) {
    if(index[i] != 0) {
      fin.seekg(index[i]);
      same = fin.get();
      do{
        do{
          fin.get(letter);
          w_name[same++] = (char) ((letter ^ 0x7f) & 0x7f);
        } while((fin.good())
                && ((letter & 0x80) == 0))
          ;
        w_name[same] = 0;
        w_nr = (fin.get() << 8) + fin.get();

        wstr[++wctr] = new char[strlen(w_name) + 1];
        strcpy(wstr[wctr], w_name);
        wnum[wctr] = w_nr;

        same = fin.get();
      } while((fin.good())
              && (same != 0))
        ;
    }
  }
}



void mats_readobject(ifstream &fin) {
/*******************************************************************************
* mats_readobject(ifstream);
*
* Reads the object file into memory.
*
*/

  const char    *avis = "Avis Durgan";
  unsigned char *data;
  char          str[64];
  char          chr;
  int           filelen;
  int           i;
  int           index;
  int           objects;
  int           pos = 0;
  int           xor = 0;

  fin.get(chr);
  fin.get(chr);
  if(chr >= 'v')            // Test if file is xored with "Avis Durgan". chr is the highest byte of the number of
    xor = 1;                // objects in the game. As long as there is less than 30208 (0x7600) objects, this test
                            // should work fine (i.e. quite often).

  fin.seekg(0, ios::end);
  filelen = fin.tellg();
  fin.seekg(0);

  data = new unsigned char[filelen + 1];

  fin.read(data, filelen);

  if(xor == 1) {                        // decrypt
    for(i = 0; i < filelen; i++) {
      data[i] ^= avis[pos++];
      if(pos > 10)
        pos = 0;
    }
  }

  objects = (data[0] + (data[1] << 8)) / 3;

  for(i = 0; i < objects; i++) {
    pos = 0;
    index = data[3 * (i + 1)] + (data[3 * (i + 1) + 1] << 8) + 3;
    while((str[pos++] = data[index++]) != 0)
      ;
    ostr[++octr] = new char[strlen(str) + 1];
    strcpy(ostr[octr], str);
  }

  delete data;
}


int main(int argc, char **argv) {
/*******************************************************************************
* int main(int argc, char **argv)
*
* The main. Takes care of the arguments, opens all the files and calls the rest
* of the functions.
*
*/

  char *wname = "words.tok";
  char *oname = "object";
  int volnr = -1;
  int i;

  ifstream ftmp;

  cout << "\nMats 2.42  (written by mrtn@rocketmail.com)\n\n";

  if((argc < 3)
     || (argc == 4)
     || (argc == 6)
     || (argc == 8)
     || (argc > 9)) {
    cout << "Usage:\n";
    cout << "    mats <source> <output> [options]\n\n";
    cout << "Options:\n";
    cout << "    -w <filename>     use another words.tok file\n";
    cout << "    -o <object>       use another object file\n";
    cout << "    -v <volnr>        volnr to use in header (default = no header)\n";
    return 0;
  }

  ffile[++fctr].open(argv[1], ios::in);
  if (ffile[fctr].fail()) {
    cout << "Couldn't open source file!\n";
    return 1;
  }

  fname[fctr] = new char[strlen(argv[1]) + 1];
  strcpy(fname[fctr], argv[1]);
  fline[fctr] = 1;

  for(i = 3; i < argc; i += 2) {
    if(stricmp(argv[i], "-w") == 0)
      wname = argv[i + 1];
    if(stricmp(argv[i], "-o") == 0)
      oname = argv[i + 1];
    if(stricmp(argv[i], "-v") == 0)
      volnr = atoi(argv[i + 1]);
  }

// read and decode the words.tok file

  ftmp.open(wname, ios::in | ios::binary);
  if (ftmp.fail())
    cout << "Warning: Couldn't open words.tok file!\n";
  else {
    mats_readwords(ftmp);
    ftmp.close();
  }

// read and decode the object file

  ftmp.open(oname, ios::in | ios::binary);
  if (ftmp.fail())
    cout << "Warning: Couldn't open object file!\n";
  else {
    mats_readobject(ftmp);
    ftmp.close();
  }

  fstream fout;
  fout.open(argv[2], ios::in | ios::out | ios::binary | ios::trunc);
  if (fout.fail()) {
    ffile[fctr].close();
    cout << "Couldn't open output file!\n";
    return 1;
  };


// precompile

  i = mats_precompile();

  if(i != 0) {

    while(fctr > 0) {
      ffile[fctr].close();
      delete fname[fctr--];
    }

    fout.close();
    return 1;
  }

// compile

  mats_compile(fout, volnr);

// close all files

  fout.close();

  while(fctr > 0) {
    ffile[fctr].close();
    delete fname[fctr--];
  }

// remove defines from memory

  while(dctr > 0) {
    delete dname[dctr];
    while(dwords[dctr] > 0)
      delete dstr[dctr][dwords[dctr]--];
    dctr--;
  }

// remove strings from memory

  while(sctr > 0)
    if(string[sctr] != NULL)
      delete string[sctr--];
    else
      sctr--;

// remove labels from memory

  while(lctr > 0)
    delete lstr[lctr--];

// remove gotos from memory

  while(gctr > 0)
    delete gstr[gctr--];

// remove objects from memory

  while(octr > 0)
    delete ostr[octr--];

// remove words.tok from memory

  while(wctr > 0)
    delete wstr[wctr--];

  return 0;
}
