/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.lang.reflect.Array;

public final class Global {
    public static final String TITLE = "Aiee!";
    public static final String VERSION = "Aiee! v0.2";
    public static final String NAME = "An Interactive Environment Engine";
    public static final String COPYRIGHT = "Copyright 2003 by Mark Hughes <kamikaze@kuoi.asui.uidaho.edu>";
    public static final String HOMEPAGE = "http://kuoi.asui.uidaho.edu/~kamikaze/Aiee/";
    public static final int North = 0;
    public static final int Northeast = 1;
    public static final int East = 2;
    public static final int Southeast = 3;
    public static final int South = 4;
    public static final int Southwest = 5;
    public static final int West = 6;
    public static final int Northwest = 7;
    public static final int Up = 8;
    public static final int Down = 9;
    public static final int NDIRS = 10;
    public static final String[] DIR_ABBV;
    public static final String[] DIR_NAME;
    public static final int DEFAULT_WEIGHT = 100;
    public static final int CARRY_WEIGHT = 1000;
    public static final int MAX_WEIGHT = 9999;
    public static final int ELEM_Physical = 0;
    public static final int ELEM_Air = 1;
    public static final int ELEM_Earth = 2;
    public static final int ELEM_Fire = 3;
    public static final int ELEM_Water = 4;
    public static final int NELEMENTS = 5;
    public static final String ELEM_CHARS = "paefw";
    public static final String[] ELEM_NAME;
    private static final int MIN_INT_VALUE = -256;
    private static final int MAX_INT_VALUE = 256;
    private static final Integer[] INTS_;
    private static final String[] CHAR_TEXT;

    public static int getDir(String s) {
        int i;
        for (i = 0; i < 10; ++i) {
            if (!DIR_ABBV[i].equals(s)) continue;
            return i;
        }
        for (i = 0; i < 10; ++i) {
            if (!DIR_NAME[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static int atoi(String s, int defvalue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defvalue;
        }
    }

    public static int indexOf(Object o, Object array) {
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            if (!(o == null ? o == Array.get(array, i) : o.equals(Array.get(array, i)))) continue;
            return i;
        }
        return -1;
    }

    public static Integer makeInt(int value) {
        if (value >= -256 && value <= 256) {
            return INTS_[value - -256];
        }
        return new Integer(value);
    }

    public static String first(String s) {
        int sp = s.indexOf(32);
        return sp < 0 ? s : s.substring(0, sp);
    }

    public static String rest(String s) {
        int sp = s.indexOf(32);
        return sp < 0 ? "" : s.substring(sp + 1);
    }

    public static String join(String a, String b) {
        if (a == null) {
            a = "null";
        }
        if (b == null) {
            b = "null";
        }
        StringBuffer sb = new StringBuffer(a.length() + b.length());
        sb.append(Global.title(a));
        sb.append(b);
        return sb.substring(0);
    }

    public static String join(String a, String b, String c) {
        if (a == null) {
            a = "null";
        }
        if (b == null) {
            b = "null";
        }
        if (c == null) {
            c = "null";
        }
        StringBuffer sb = new StringBuffer(a.length() + b.length() + c.length());
        sb.append(Global.title(a));
        sb.append(b);
        sb.append(c);
        return sb.substring(0);
    }

    public static String join(String[] a) {
        int totallen = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == null) {
                a[i] = "null";
            }
            totallen += a[i].length();
        }
        StringBuffer sb = new StringBuffer(totallen);
        int len2 = a.length;
        for (int i = 0; i < len2; ++i) {
            if (i == 0) {
                sb.append(Global.title(a[i]));
                continue;
            }
            sb.append(a[i]);
        }
        return sb.substring(0);
    }

    public static String title(String a) {
        if (a == null || !Character.isLowerCase(a.charAt(0))) {
            return a;
        }
        return Character.toUpperCase(a.charAt(0)) + a.substring(1);
    }

    public static boolean toBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Integer) {
            return (Integer)o != 0;
        }
        return o.toString().length() != 0;
    }

    public static Integer toInteger(Object o) {
        if (o == null) {
            return Global.makeInt(0);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        try {
            return Integer.valueOf(o.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String toString(char c) {
        if (c < '\u0080') {
            return CHAR_TEXT[c];
        }
        return String.valueOf(c);
    }

    public static String toString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private Global() {
    }

    static {
        int i;
        DIR_ABBV = new String[]{"n", "ne", "e", "se", "s", "sw", "w", "nw", "u", "d"};
        DIR_NAME = new String[]{"north", "northeast", "east", "southeast", "south", "southwest", "west", "northwest", "up", "down"};
        ELEM_NAME = new String[]{"physical", "air", "earth", "fire", "water"};
        INTS_ = new Integer[513];
        for (i = -256; i <= 256; ++i) {
            Global.INTS_[i - -256] = new Integer(i);
        }
        CHAR_TEXT = new String[128];
        for (i = 0; i < 128; ++i) {
            Global.CHAR_TEXT[i] = String.valueOf((char)i);
        }
    }
}

