/* Functions.c - built-in functions */
/*
	Copyright (c) 1993, by David Michael Betz
	All rights reserved
*/

#include "Drool.h"
#include "Execute.h"
#include "Objects.h"

/* prototypes */
static void EnterBuiltInFunction(char *name,void (*handler)(void));
static void BIFclone(void);
static void BIFprint(void);

/* function table */
FunctionTableEntry functionTable[] = {
{	"clone",	BIFclone	},
{	"print",	BIFprint	},
{0,0}
};

/* InitBuiltInFunctions - initialize the built-in functions */
void InitBuiltInFunctions(void)
{
    FunctionTableEntry *p;
    for (p = functionTable; p->name != 0; ++p)
	EnterBuiltInFunction(p->name,p->handler);
}

/* EnterBuiltInFunction - add a built-in function to the symbol table */
static void EnterBuiltInFunction(char *name,void (*handler)(void))
{
    cpush(InternCString(symbolPackage,name));
    SetSymbolValue(*sp,NewCMethodObject(name,handler));
    drop(1);
}

/* BIFclone - built-in function 'clone' */
static void BIFclone(void)
{
    long n = UnboxNumber(fp[1]);
    ObjectPtr *p = &fp[n + 2];
    ObjectPtr obj,tag,val;
    if (--n < 0)
	error("too few arguments");
    obj = *--p;
    if (!ObjectP(obj))
    	error("can only clone objects");
    obj = CloneObject(obj);
    for (; n >= 2; n -= 2) {
	tag = *--p;
	val = *--p;
	setp(obj,tag,val);
    }
    *sp = obj;
}

/* BIFprint - built-in function 'print' */
static void BIFprint(void)
{
    long n = UnboxNumber(fp[1]);
    ObjectPtr *p = &fp[n + 2];
    while (--n >= 0)
	PrintValue(*--p);
}
