unit Inf1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Tabs, ExtCtrls, Menus, TabNotBk, inf2,
  Smiley, inf3, Picklist, inf4, tm_str, debuggo, Rzlabel, IMFedit, Simage,
  Inifiles, Statbaru, Grids, Cus_Bas, Barsize, imfobjs;

Const
     version : string[20] = 'IMFORM v0.1';
     emailadr: string[35] = 'as544@torfree.net';

type

TInfConfig = Record
     InfDirectory : string;
     InfCompiler  : string;
     InfInterpreter: string;
     ExtTextViewer: string;
     ExtTextViewerC: boolean;
     Warnings     : boolean;
     BubbleHelp   : boolean;
     PageWidth    : integer;
     TabWidth     : integer;
     FSE_top      : integer;
     FSE_left     : integer;
     FSE_height   : integer;
     FSE_Width    : integer;
     FSE_State    : integer;
end;

  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    ImfNoteBook: TNotebook;
    ImfTabSet: TTabSet;
    CheckBox1: TCheckBox;
    RoomListL: TLabel;
    BitBtn24: TBitBtn;
    BitBtn25: TBitBtn;
    BitBtn26: TBitBtn;
    Options1: TMenuItem;
    Help1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Import1: TMenuItem;
    Export1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Configuration1: TMenuItem;
    LoadConfig1: TMenuItem;
    SaveSetup1: TMenuItem;
    N3: TMenuItem;
    MMBubbleHelp: TMenuItem;
    Contents1: TMenuItem;
    About1: TMenuItem;
    RoomNoteBook: TTabbedNotebook;
    Label8: TLabel;
    ListBox9: TListBox;
    TabbedNotebook3: TTabbedNotebook;
    BitBtn27: TBitBtn;
    BitBtn28: TBitBtn;
    BitBtn29: TBitBtn;
    Label9: TLabel;
    ListBox10: TListBox;
    TabbedNotebook4: TTabbedNotebook;
    BitBtn30: TBitBtn;
    BitBtn31: TBitBtn;
    BitBtn32: TBitBtn;
    Label10: TLabel;
    ListBox11: TListBox;
    TabbedNotebook5: TTabbedNotebook;
    BitBtn33: TBitBtn;
    BitBtn34: TBitBtn;
    BitBtn35: TBitBtn;
    Label11: TLabel;
    ListBox12: TListBox;
    BitBtn36: TBitBtn;
    BitBtn37: TBitBtn;
    BitBtn38: TBitBtn;
    Edit4: TEdit;
    Label12: TLabel;
    GroupBox2: TGroupBox;
    Memo1: TMemo;
    Tools1: TMenuItem;
    Compile1: TMenuItem;
    CompileRun1: TMenuItem;
    BitBtn39: TBitBtn;
    BitBtn40: TBitBtn;
    BitBtn41: TBitBtn;
    Memo2: TMemo;
    Label13: TLabel;
    Label15: TLabel;
    RoomObjL: TLabel;
    RoomShortNameL: TLabel;
    RoomBelongsToL: TLabel;
    RoomObjName: TEdit;
    RoomShortName: TEdit;
    RoomBelongsTo: TEdit;
    RoomListSys: TCheckBox;
    ObjPick1: TBitBtn;
    RoomNames: TEdit;
    RoomNamesL: TLabel;
    Edit9: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    Paste1: TMenuItem;
    Delete1: TMenuItem;
    N4: TMenuItem;
    View1: TMenuItem;
    Smiley2: TSmiley;
    Smiley3: TSmiley;
    RoomClasses: TEdit;
    RoomClasesL: TLabel;
    MMWarnings: TMenuItem;
    RoomComments: TMemo;
    RoomCommentsL: TLabel;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    SysNotebook: TTabbedNotebook;
    SysTitleL: TLabel;
    SysHeadLineL: TLabel;
    SysSwitchesL: TLabel;
    SysCommentL: TLabel;
    SysTitle: TEdit;
    SysHeadLine: TEdit;
    sysSwitches: TEdit;
    IncGroupBox: TGroupBox;
    IncParserL: TLabel;
    IncVerbLibL: TLabel;
    IncGrammarL: TLabel;
    IncParser: TListBox;
    IncVerbLib: TListBox;
    IncGrammar: TListBox;
    IncAdd: TBitBtn;
    IncEdit: TBitBtn;
    IncDelete: TBitBtn;
    SysDebugMode: TCheckBox;
    SysComment: TMemo;
    SysAttribGroup: TGroupBox;
    SysAttribAdd: TBitBtn;
    SysAttribDel: TBitBtn;
    SysAttribDn: TBitBtn;
    SysAttribUp: TBitBtn;
    SysAttribEdit: TBitBtn;
    SysConstAdd: TBitBtn;
    SysConstDelete: TBitBtn;
    SysConstEdit: TBitBtn;
    SysConstUp: TBitBtn;
    SysConstDn: TBitBtn;
    SysPropGroup: TGroupBox;
    SysPropAdd: TBitBtn;
    SysPropDel: TBitBtn;
    SysPropDn: TBitBtn;
    SysPropUp: TBitBtn;
    SysPropEdit: TBitBtn;
    Memo5: TMemo;
    Label22: TLabel;
    PickList1: TPickList;
    GramType: TRadioGroup;
    GramPos: TRadioGroup;
    GroupBox5: TGroupBox;
    ListBox14: TListBox;
    BitBtn47: TBitBtn;
    BitBtn48: TBitBtn;
    BitBtn49: TBitBtn;
    GramModGroup: TPanel;
    BitBtn54: TBitBtn;
    BitBtn55: TBitBtn;
    BitBtn56: TBitBtn;
    GramCmt: TMemo;
    GramCmtL: TLabel;
    Label24: TLabel;
    ImportDialog: TOpenDialog;
    SaveAsDialog: TSaveDialog;
    FontDialog1: TFontDialog;
    OpenDialog: TOpenDialog;
    ExportDialog: TSaveDialog;
    IncUp: TBitBtn;
    IncDown: TBitBtn;
    Edit11: TEdit;
    Label25: TLabel;
    SysAttribSort: TBitBtn;
    SysAttribList: TPickList;
    SysPropList: TPickList;
    SysPropSort: TBitBtn;
    SysConstList: TPickList;
    SysConstFS: TSpeedButton;
    Panel2: TPanel;
    Smiley1: TSmiley;
    IMFormL: TRzLabel;
    MainSplash: TSimage;
    SysAttribFS: TSpeedButton;
    SysPropFS: TSpeedButton;
    SysGlobAdd: TBitBtn;
    SysGlobDelete: TBitBtn;
    SysGlobEdit: TBitBtn;
    SysGlobUp: TBitBtn;
    SysGlobDn: TBitBtn;
    SysGlobFS: TSpeedButton;
    SysGlobList: TPickList;
    IncVerbLibR: TRadioButton;
    IncParserR: TRadioButton;
    IncGrammarR: TRadioButton;
    Debuggo1: TMenuItem;
    RoomList: TPickList;
    ConfigRestoreDlg: TOpenDialog;
    ConfigSaveDlg: TSaveDialog;
    Memo3: TMemo;
    PickList3: TPickList;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpeedButton2: TSpeedButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    GramSizer: TBarreResize;
    Panel3: TPanel;
    BitBtn51: TBitBtn;
    BitBtn52: TBitBtn;
    BitBtn53: TBitBtn;
    StringGrid1: TStringGrid;
    Header1: THeader;
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Configuration1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Import1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure IncParserEnter(Sender: TObject);
    procedure IncGrammarEnter(Sender: TObject);
    procedure IncVerbLibEnter(Sender: TObject);
    procedure IncAddClick(Sender: TObject);
    procedure IncEditClick(Sender: TObject);
    procedure IncDeleteClick(Sender: TObject);
    procedure IncUpClick(Sender: TObject);
    procedure IncDownClick(Sender: TObject);
    procedure IncParserKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure IncParserExit(Sender: TObject);
    procedure SysAttribAddClick(Sender: TObject);
    Procedure ImfBoxAdd(Sender : Tobject; List : TPickList; S : string);
    Procedure ImfBoxEdit(Sender : Tobject; List : TPickList; S : string);
    Procedure ImfBoxDelete(Sender : Tobject; List : TPickList);
    Procedure ImfBoxUp(Sender : Tobject; List : TPickList);
    Procedure ImfBoxDn(Sender : Tobject; List : TPickList);
    procedure MMWarningsClick(Sender: TObject);
    procedure SysAttribEditClick(Sender: TObject);
    procedure SysAttribDelClick(Sender: TObject);
    procedure SysAttribDnClick(Sender: TObject);
    procedure SysAttribUpClick(Sender: TObject);
    procedure SysAttribSortClick(Sender: TObject);
    procedure SysPropAddClick(Sender: TObject);
    procedure SysPropDelClick(Sender: TObject);
    procedure SysPropDnClick(Sender: TObject);
    procedure SysPropUpClick(Sender: TObject);
    procedure SysPropEditClick(Sender: TObject);
    procedure SysAttribListChange(Sender: TObject);
    procedure SysPropListChange(Sender: TObject);
    procedure SysPropListEnter(Sender: TObject);
    procedure SysAttribListEnter(Sender: TObject);
    procedure SysAttribListKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SysConstAddClick(Sender: TObject);
    procedure SysConstDeleteClick(Sender: TObject);
    procedure SysConstEditClick(Sender: TObject);
    procedure SysConstDnClick(Sender: TObject);
    procedure SysConstUpClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure SysConstListChange(Sender: TObject);
    procedure SysConstListDblClick(Sender: TObject);
    procedure CallFSedit(sender : Tobject; S : string);
    procedure SysPropFSClick(Sender: TObject);
    procedure SysAttribFSClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ImfTabSetChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure IncParserRClick(Sender: TObject);
    procedure IncVerbLibRClick(Sender: TObject);
    procedure IncGrammarRClick(Sender: TObject);
    procedure ImfTabSetClick(Sender: TObject);
    procedure SysTitleLClick(Sender: TObject);
    procedure SysHeadLineLClick(Sender: TObject);
    procedure SysSwitchesLClick(Sender: TObject);
    procedure IncParserLClick(Sender: TObject);
    procedure IncVerbLibLClick(Sender: TObject);
    procedure IncGrammarLClick(Sender: TObject);
    procedure IncGroupBoxClick(Sender: TObject);
    procedure SysGlobAddClick(Sender: TObject);
    procedure SysGlobDeleteClick(Sender: TObject);
    procedure SysGlobDnClick(Sender: TObject);
    procedure SysGlobEditClick(Sender: TObject);
    procedure SysGlobFSClick(Sender: TObject);
    procedure SysGlobUpClick(Sender: TObject);
    procedure SysGlobListChange(Sender: TObject);
    procedure SysGlobListDblClick(Sender: TObject);
    procedure Debuggo1Click(Sender: TObject);
    procedure GramTypeClick(Sender: TObject);
    Procedure SaveConfig(s : string);
    procedure RestoreConfig(s : string; check : boolean);
    procedure LoadConfig1Click(Sender: TObject);
    procedure SaveSetup1Click(Sender: TObject);
    procedure MMBubbleHelpClick(Sender: TObject);
    procedure SysAttribListDblClick(Sender: TObject);
    procedure SysPropListDblClick(Sender: TObject);
    procedure GramSizerSliding(Sender: TObject; X, Y: Integer);
    procedure GramSizerNewPosition(Sender: TObject);
    procedure SysConstFSClick(Sender: TObject);
  private
    { Private declarations }
    InfAttribute : TstringList;
    InfProperty  : TstringList;
    IncludeFocus : integer;
    Fini         : TiniFile;
    FNini        : String;
    InfConfig    : TinfConfig;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  pc   : Pchar;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     FNini:=PathOnlyBS(application.exename)+'IMFORM.INI';
     ConfigSaveDlg.Filename:=FnIni;
     ConfigRestoreDlg.Filename:=FnIni;
     RestoreConfig(FNini, FALSE);

     FIni:=Tinifile.create(FnIni);

     Fini.Free;


     IncludeFocus := 0;
     ImfTabSet.Tabs := ImfNoteBook.Pages;
     InfAttribute:=TStringList.Create;
     InfAttribute.add('absent');
     InfAttribute.add('animate');
     InfAttribute.add('clothing');
     InfAttribute.add('concealed');
     InfAttribute.add('container');
     InfAttribute.add('direction');
     InfAttribute.add('door');
     InfAttribute.add('edible');
     InfAttribute.add('enterable');
     InfAttribute.add('female');
     InfAttribute.add('general');
     InfAttribute.add('light');
     InfAttribute.add('lockable');
     InfAttribute.add('locked');
     InfAttribute.add('moved');
     InfAttribute.add('on');
     InfAttribute.add('open');
     InfAttribute.add('openable');
     InfAttribute.add('proper');
     InfAttribute.add('scenery');
     InfAttribute.add('scored');
     InfAttribute.add('static');
     InfAttribute.add('supporter');
     InfAttribute.add('switchable');
     InfAttribute.add('talkable');
     InfAttribute.add('transparent');
     InfAttribute.add('visited');
     InfAttribute.add('workflag');
     InfAttribute.add('worn');

     InfProperty:=TstringList.create;
     InfProperty.add('after');
     InfProperty.add('article');
     InfProperty.add('before');
     InfProperty.add('cant_go');
     InfProperty.add('capacity');
     InfProperty.add('d_to');
     InfProperty.add('daemon');
     InfProperty.add('describe');
     InfProperty.add('description');
     InfProperty.add('door_dir');
     InfProperty.add('door_to');
     InfProperty.add('e_to');
     InfProperty.add('each_turn');
     InfProperty.add('found_in');
     InfProperty.add('in_to');
     InfProperty.add('initial');
     InfProperty.add('invent');
     InfProperty.add('life');
     InfProperty.add('n_to');
     InfProperty.add('name');
     InfProperty.add('ne_to');
     InfProperty.add('number');
     InfProperty.add('nw_to');
     InfProperty.add('out_to');
     InfProperty.add('parse_name');
     InfProperty.add('plural');
     InfProperty.add('s_to');
     InfProperty.add('se_to');
     InfProperty.add('short_name');
     InfProperty.add('sw_to');
     InfProperty.add('time_left');
     InfProperty.add('time_out');
     InfProperty.add('u_to');
     InfProperty.add('w_to');
     InfProperty.add('when_closed');
     InfProperty.add('when_off');
     InfProperty.add('when_on');
     InfProperty.add('when_open');
     InfProperty.add('with_key');

     Application.OnIdle := AppIdle;
end;

procedure TForm1.AppIdle(Sender: TObject; var Done: Boolean);
begin
     DebugDlg.Label1.caption:='idx: '+inttoStr(IncParser.ItemIndex)+'  ttl:'+inttostr(IncParser.items.count);
     DebugDlg.Label2.caption:='idx: '+inttoStr(IncVerbLib.ItemIndex)+'  ttl:'+inttostr(IncVerbLib.items.count);
     DebugDlg.Label3.caption:='idx: '+inttoStr(IncGrammar.ItemIndex)+'  ttl:'+inttostr(IncGrammar.items.count);
     Done := True;
end;

procedure TForm1.RestoreConfig(s: string; check: boolean);
var v : string[20];
begin
     FIni:=Tinifile.create(s);
     v:=Fini.ReadString('SYSTEM','Version','');
     if (check=TRUE)and(copy(version,1,6)<>copy(v,1,6)) then begin
         MessageDlg('"'+S+'" is not an IMForm configuration file! ',
         mtError,[mbok],0);
     end else begin
     InfConfig.InfDirectory:=Fini.ReadString('SYSTEM','DefaultPath','');
     InfConfig.InfCompiler:=Fini.ReadString('SYSTEM','InformCompiler','');
     InfConfig.InfInterpreter:=Fini.ReadString('SYSTEM','InfocomInterpreter','');
     InfConfig.ExtTextViewer:=Fini.ReadString('SYSTEM','ExtTextViewer','');
     InfConfig.ExtTextViewerC:=Fini.ReadBool('SYSTEM','UserExtViewer',FALSE);
     InfConfig.Warnings:=Fini.ReadBool('SETTINGS','Warnings',TRUE);
     InfConfig.BubbleHelp:=Fini.ReadBool('SETTINGS','BubbleHelp',TRUE);
     InfConfig.PageWidth:=Fini.ReadInteger('SETTINGS','PageWidth',79);
     InfConfig.TabWidth:=Fini.ReadInteger('SETTINGS','TabWidth',4);
     InfConfig.FSE_state:=Fini.ReadInteger('MINI_EDITOR','State',integer(wsNormal));
     InfConfig.FSE_left:=Fini.ReadInteger('MINI_EDITOR','X_Pos',0);
     InfConfig.FSE_top:=Fini.ReadInteger('MINI_EDITOR','Y_Pos',0);
     InfConfig.FSE_width:=Fini.ReadInteger('MINI_EDITOR','Width',0);
     InfConfig.FSE_height:=Fini.ReadInteger('MINI_EDITOR','Height',0);
     end;
     Fini.Free;
     if (Check=False)and(not Fileexists(FnIni)) then SaveConfig(fnIni);
end;

procedure TForm1.SaveConfig(s: string);
begin
     FIni:=Tinifile.create(s);
     Fini.WriteString('SYSTEM','Version',version);
     Fini.WriteString('SYSTEM','Email',EmailAdr);
     Fini.WriteString('SYSTEM','DefaultPath',InfConfig.InfDirectory);
     Fini.WriteString('SYSTEM','InformCompiler',InfConfig.InfCompiler);
     Fini.WriteString('SYSTEM','InfocomInterpreter',InfConfig.InfInterpreter);
     Fini.WriteString('SYSTEM','ExtTextViewer',InfConfig.ExtTextViewer);
     Fini.WriteBool('SYSTEM','UserExtViewer',InfConfig.ExtTextViewerC);
     Fini.WriteBool('SETTINGS','Warnings',InfConfig.Warnings);
     Fini.WriteBool('SETTINGS','BubbleHelp',InfConfig.BubbleHelp);
     Fini.WriteInteger('SETTINGS','PageWidth',InfConfig.PageWidth);
     Fini.WriteInteger('SETTINGS','TabWidth',InfConfig.TabWidth);
     Fini.Free;
end;

procedure TForm1.ImfTabSetClick(Sender: TObject);
begin
     ImfNoteBook.PageIndex := ImfTabSet.TabIndex;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
     close;
end;

procedure TForm1.Configuration1Click(Sender: TObject);

begin
     Configuration.InfDirectory.Text:=InfConfig.InfDirectory;
     Configuration.InfCompiler.Text:=InfConfig.InfCompiler;
     Configuration.InfInterpreter.Text:=InfConfig.InfInterpreter;
     Configuration.ExtTextViewer.Text:=InfConfig.ExtTextViewer;
     Configuration.ExtTextViewerC.Checked:=InfConfig.ExtTextViewerC;
     Configuration.Warnings.Checked:=InfConfig.Warnings;
     Configuration.BubbleHelp.Checked:=InfConfig.BubbleHelp;
     Configuration.PageWidth.Text:=IntToStr(InfConfig.PageWidth);
     Configuration.PageWidth.Text:=IntToStr(InfConfig.TabWidth);

     configuration.showmodal;

     If (Configuration.ModalResult=mrYes)or(Configuration.ModalResult=mrOk)
        then begin
             InfConfig.InfDirectory:=Configuration.InfDirectory.Text;
             InfConfig.InfCompiler:=Configuration.InfCompiler.Text;
             InfConfig.InfInterpreter:=Configuration.InfInterpreter.Text;
             InfConfig.ExtTextViewer:=Configuration.ExtTextViewer.Text;
             InfConfig.ExtTextViewerC:=Configuration.ExtTextViewerC.Checked;
             InfConfig.Warnings:=Configuration.Warnings.Checked;
             MMWarnings.Checked:=Configuration.Warnings.Checked;
             InfConfig.BubbleHelp:=Configuration.BubbleHelp.Checked;
             MMBubbleHelp.Checked:=Configuration.BubbleHelp.Checked;
             InfConfig.PageWidth:=StrToInt(Configuration.PageWidth.Text);
             InfConfig.TabWidth:=StrToInt(Configuration.PageWidth.Text);
        end;
     if (Configuration.ModalResult=mrYes) then SaveSetup1click(sender);
end;

procedure TForm1.About1Click(Sender: TObject);
begin
     form2.showmodal;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     infProperty.Free;
     infAttribute.Free;
end;

procedure TForm1.Import1Click(Sender: TObject);
var F : textfile;
    s : string;
    inBlock : boolean;
    IncMode : integer;
begin
     inblock:=FALSE;
     IncMOde:=1;
     If ImportDialog.execute then begin
        AssignFile(f,ImportDialog.Filename);
        try
           reset(f);
           while Not Eof(f) do begin
                 readln(f,s);


           end;
           close(f);
        except
              ShowMessage('Error');
        end;

        ShowMessage('OK OK OK');
     end;
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
     SaveAsDialog.execute
end;

procedure TForm1.IncParserEnter(Sender: TObject);
begin
     DebugDlg.Label1.caption:='idx: '+inttoStr(IncParser.ItemIndex)+'  ttl:'+inttostr(IncParser.items.count);
     if IncVerbLib.ItemIndex>-1 then IncVerbLib.ItemIndex:=-1;
     if IncGrammar.ItemIndex>-1 then IncGrammar.ItemIndex:=-1;
     includeFocus:=1; IncParserR.checked:=TRUE;
     if (IncParser.Items.Count>1) then begin
        IncUp.Enabled:=True; IncDown.Enabled:=TRUE;
     end else begin
        IncUp.Enabled:=False; IncDown.Enabled:=False;
     end;
end;

procedure TForm1.IncVerbLibEnter(Sender: TObject);
var p : pchar;
    s : string;
begin
     DebugDlg.Label2.caption:='idx: '+inttoStr(IncVerbLib.ItemIndex)+'  ttl:'+inttostr(IncVerbLib.items.count);
     if IncParser.ItemIndex>-1 then IncParser.ItemIndex:=-1;
     if IncGrammar.ItemIndex>-1 then IncGrammar.ItemIndex:=-1;
     includeFocus:=2; IncVerbLibR.Checked:=TRUE;
     if (IncVerbLib.Items.count>1)and(IncVerbLib.Items.Count>1) then begin
        IncUp.Enabled:=True; IncDown.Enabled:=TRUE;
     end else begin
        IncUp.Enabled:=False; IncDown.Enabled:=False;
     end;
end;

procedure TForm1.IncGrammarEnter(Sender: TObject);
var p : pchar;
    s : string;
begin
     DebugDlg.Label3.caption:='idx: '+inttoStr(IncGrammar.ItemIndex)+'  ttl:'+inttostr(IncGrammar.items.count);
     if IncParser.ItemIndex>-1 then IncParser.ItemIndex:=-1;
     if IncVerbLib.ItemIndex>-1 then IncVerbLib.ItemIndex:=-1;
     includeFocus:=3; IncGrammarR.checked:=TRue;
     if (IncGrammar.Items.Count>1) then begin
        IncUp.Enabled:=True; IncDown.Enabled:=TRUE;
     end else begin
        IncUp.Enabled:=False; IncDown.Enabled:=False;
     end;
end;

procedure TForm1.IncAddClick(Sender: TObject);
var TmpList : TlistBox;
begin
     if IncludeFocus>0 then begin
        if IncludeFocus=3 then TmpList := IncGrammar
        else if IncludeFocus=2 then TmpList := IncVerbLib
        else TmpList:=IncParser;
        InputDialog.Edit1.text:='';
        InputDialog.Label1.caption:='Please input the name of the file to include:';
        if InputDialog.Showmodal<>mrCancel then begin
           InputDialog.Edit1.text:=Atrim(INputDialog.Edit1.text, ' ');
           if InputDialog.Edit1.Text<>'' then begin
              with TmpList do begin
                   items.insert(succ(itemindex),InputDialog.edit1.text);
                   itemindex:=(succ(itemindex));
              end;
              If IncludeFocus=3 then IncGrammarEnter(sender)
              else if IncludeFocus=2 then IncVerbLibEnter(sender)
              else IncParserEnter(sender);
           end;
        end;
     end else MessageDlg('Please select which INCLUDE group you would like to'+
         ' add an item to before pressing the ADD button.',
         mtwarning,[mbok,mbHelp],0);
end;

procedure TForm1.IncEditClick(Sender: TObject);
var TmpList : TlistBox;
begin
     if IncludeFocus>0 then begin
        if IncludeFocus=3 then TmpList := IncGrammar
        else if IncludeFocus=2 then TmpList := IncVerbLib
        else TmpList:=IncParser;
        with TmpList do begin
             if itemindex>-1 then begin
                InputDialog.Edit1.text:=Items[ItemIndex];
                InputDialog.Edit1.AutoSelect:=False;
                InputDialog.Label1.caption:='Please edit the name of the file to include:';
                if InputDialog.Showmodal<>mrCancel then begin
                   InputDialog.Edit1.text:=Atrim(INputDialog.Edit1.text, ' ');
                   if InputDialog.Edit1.Text='' then IncDeleteClick(sender)
                   else items[itemIndex]:=INputDialog.Edit1.Text;
                end;
             end else MessageDlg('You have not selected an INCLUDE file name to edit',
                 mtwarning,[mbok,mbHelp],0);
        end;
     end else MessageDlg('Please select which INCLUDE group you would like to'+
         ' edit an item in before pressing the EDIT button.',
         mtwarning,[mbok,mbHelp],0);
end;

procedure TForm1.IncDeleteClick(Sender: TObject);
var TmpList : TlistBox;
    i : integer;
begin
     if IncludeFocus>0 then begin
        if IncludeFocus=3 then TmpList := IncGrammar
        else if IncludeFocus=2 then TmpList := IncVerbLib
        else TmpList:=IncParser;
        with TmpList do begin
             if itemindex>-1 then begin
                I := ItemIndex;
                items.Delete(itemindex);
                If I=Items.count then ItemIndex:=Pred(i)
                   else itemindex:=i;
                items.Delete(itemindex);
                If IncludeFocus=3 then IncGrammarEnter(sender)
                else if IncludeFocus=2 then IncVerbLibEnter(sender)
                else IncParserEnter(sender);
             end;
        end;
     end else MessageDlg('Please select an item which you would like to DELETE'+
         ' from one of the INCLUDE groups before pressing the DELETE button.',
         mtwarning,[mbok,mbHelp],0);
end;

procedure TForm1.IncUpClick(Sender: TObject);
var TmpList : TlistBox;
    i       : integer;
begin
     if IncludeFocus>0 then begin
        if IncludeFocus=3 then TmpList := IncGrammar
        else if IncludeFocus=2 then TmpList := IncVerbLib
        else TmpList:=IncParser;
        with TmpList do begin
             i:=ItemIndex;
             if (ItemIndex>0) then begin
                items.Exchange(pred(ItemIndex),itemindex);
                ItemIndex:=Pred(I);
             end;
        end;
     end else begin
         IncUp.Enabled:=False;
         IncDown.Enabled:=False;
         MessageDlg('Please select an item which you would like to MOVE'+
         ' UP in one of the the INCLUDE groups before pressing the UP button.',
         mtwarning,[mbok,mbHelp],0);
     end;
     DebugDlg.Label1.caption:='idx: '+inttoStr(IncParser.ItemIndex)+'  ttl:'+inttostr(IncParser.items.count);
     DebugDlg.Label2.caption:='idx: '+inttoStr(IncVerbLib.ItemIndex)+'  ttl:'+inttostr(IncVerbLib.items.count);
     DebugDlg.Label3.caption:='idx: '+inttoStr(IncGrammar.ItemIndex)+'  ttl:'+inttostr(IncGrammar.items.count);
end;

procedure TForm1.IncDownClick(Sender: TObject);
var TmpList : TlistBox;
    i       : integer;
begin
     if includeFocus>0 then begin
        if IncludeFocus=3 then TmpList := IncGrammar
        else if IncludeFocus=2 then TmpList := IncVerbLib
        else TmpList:=IncParser;
        with TmpList do begin
             i:=Itemindex;
             if (ItemIndex<pred(Items.count))and(ItemIndex<>-1) then begin
                items.Exchange(ItemIndex,succ(itemindex));
                ItemIndex:=succ(i);
             end;
        end;
     end else begin
         IncUp.Enabled:=False;
         IncDown.Enabled:=False;
         MessageDlg('Please select an item which you would like to MOVE'+
         ' DOWN in one of the the INCLUDE groups before pressing the DOWN button.',
         mtwarning,[mbok,mbHelp],0);
     end;
     DebugDlg.Label1.caption:='idx: '+inttoStr(IncParser.ItemIndex)+'  ttl:'+inttostr(IncParser.items.count);
     DebugDlg.Label2.caption:='idx: '+inttoStr(IncVerbLib.ItemIndex)+'  ttl:'+inttostr(IncVerbLib.items.count);
     DebugDlg.Label3.caption:='idx: '+inttoStr(IncGrammar.ItemIndex)+'  ttl:'+inttostr(IncGrammar.items.count);
end;

procedure TForm1.IncParserKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     if (shift=[]) then begin
        if (key=vk_insert) then IncAddClick(sender);
        if (key=vk_delete) then IncDeleteClick(sender);
        if (key=vk_back) then IncDeleteClick(sender);
        if (key=vk_Return) then if TListBox(Sender).itemindex=-1 then IncAddClick(sender) else IncEditClick(Sender);
        if (key=vk_Right) then begin
           if activeControl=IncParser then Begin IncVerbLib.SetFocus; IncVerbLibEnter(sender); end else
           if activeControl=IncVerbLib then Begin IncGrammar.SetFocus; IncGrammarEnter(sender); end else
           if activeControl=IncGrammar then Begin IncParser.SetFocus; IncParserEnter(sender); end;
        end;
        if (key=vk_Left) then begin
           if activeControl=IncParser then Begin IncGrammar.SetFocus; IncGrammarEnter(sender); end else
           if activeControl=IncVerbLib then Begin IncParser.SetFocus; IncParserEnter(sender); end else
           if activeControl=IncGrammar then Begin IncVerbLib.SetFocus; IncVerbLibEnter(sender); end;
        end;
     end else
     if (shift=[ssshift]) then begin
        if (key=vk_up) then IncUpClick(sender);
        if (key=vk_down) then IncDownClick(sender);
     end;
end;

procedure TForm1.IncParserExit(Sender: TObject);
begin
     DebugDlg.Label1.caption:='idx: '+inttoStr(IncParser.ItemIndex)+'  ttl:'+inttostr(IncParser.items.count);
     DebugDlg.Label2.caption:='idx: '+inttoStr(IncVerbLib.ItemIndex)+'  ttl:'+inttostr(IncVerbLib.items.count);
     DebugDlg.Label3.caption:='idx: '+inttoStr(IncGrammar.ItemIndex)+'  ttl:'+inttostr(IncGrammar.items.count);
end;

procedure TForm1.SysAttribAddClick(Sender: TObject);
begin
     imfBoxAdd(sender, SysAttribList, 'Please input the constant to be added:');
end;

Procedure TForm1.ImfBoxAdd(Sender : Tobject; List : TPickList; S : string);
begin
     InputDialog.Edit1.text:='';
     InputDialog.Label1.caption:=s;
        if InputDialog.Showmodal<>mrCancel then begin
           InputDialog.Edit1.text:=Atrim(INputDialog.Edit1.text, ' ');
           if InputDialog.Edit1.Text<>'' then begin
              with List do begin
                   if ItemIndex=-1 then ItemIndex:=pred(Items.count);
                   items.insert(succ(itemindex),InputDialog.edit1.text);
                   itemindex:=(succ(itemindex));
              end;
           end;
        end;

end;

procedure TForm1.ImfBoxEdit(Sender: TObject; List : TPickList; S: string);
begin
        with List do begin
             if itemindex>-1 then begin
                InputDialog.Edit1.text:=Items[ItemIndex];
                InputDialog.Edit1.AutoSelect:=False;
                InputDialog.Label1.caption:='Go on, edit yourself silly:';
                if InputDialog.Showmodal<>mrCancel then begin
                   InputDialog.Edit1.text:=Atrim(INputDialog.Edit1.text, ' ');
                   if InputDialog.Edit1.Text='' then ImfBoxDelete(sender, List)
                   else items[itemIndex]:=INputDialog.Edit1.Text;
                end;
             end else MessageDlg('Please select an item to edit first.',
                 mtwarning,[mbok,mbHelp],0);
        end;
end;

procedure TForm1.ImfBoxDelete(Sender: TObject; List : TPickList);
var I : integer;
begin
        with List do begin
             if itemindex>-1 then begin
                I := ItemIndex;
                items.Delete(itemindex);
                If I=Items.count then ItemIndex:=Pred(i)
                   else itemindex:=i;
             end else MessageDlg('Please select an item to delete first.',
                 mtwarning,[mbok,mbHelp],0);
        end;
end;

procedure TForm1.ImfBoxUp(Sender: TObject; List : TPickList);
var i : integer;
begin
     if list.itemindex>-1 then begin
        if List.Items.Count>1 then begin
        with List do begin
             if (ItemIndex>0) then begin
                i:=ItemIndex;
                items.Exchange(itemindex,pred(ItemIndex));
                ItemIndex:=Pred(I);
             end;
        end;
        end;
     end else
         MessageDlg('No item in the list has been selected to move.',
         mtwarning,[mbok,mbHelp],0);
end;

procedure TForm1.ImfBoxDn(Sender: TObject; List : TPickList);
var i : integer;
begin
     if list.itemindex>-1 then begin
        if List.Items.Count>1 then begin
        with List do begin
             if (ItemIndex<pred(Items.count)) then begin
                i:=Itemindex;
                items.Exchange(ItemIndex,succ(itemindex));
                ItemIndex:=succ(i);
             end;
        end;
        end;
     end else
         MessageDlg('No item in the list has been selected to move.',
         mtwarning,[mbok,mbHelp],0);
end;

procedure TForm1.MMWarningsClick(Sender: TObject);
begin
     MMWarnings.checked := not(MMwarnings.checked);
     InfConfig.Warnings:=MMWarnings.Checked;
end;

procedure TForm1.SysAttribEditClick(Sender: TObject);
begin
     imfBoxEdit(sender, SysAttribList,'Edit to your heart''s content:');
end;

procedure TForm1.SysAttribDelClick(Sender: TObject);
begin
     imfBoxDelete(sender, SysAttribList);
end;

procedure TForm1.SysAttribDnClick(Sender: TObject);
begin
     imfBoxDn(sender, SysAttribList);
end;

procedure TForm1.SysAttribUpClick(Sender: TObject);
begin
     ImfBoxUP(sender, SysAttribList);
end;

procedure TForm1.SysAttribSortClick(Sender: TObject);
begin
     {SysAttribList.items.sort;}
end;
      {bridges of madison county}
procedure TForm1.SysPropAddClick(Sender: TObject);
begin
     imfboxAdd(sender, SysPropList, 'Please enter a global to the list');
end;

procedure TForm1.SysPropDelClick(Sender: TObject);
begin
     imfboxDelete(sender, SysPropList);
end;

procedure TForm1.SysPropDnClick(Sender: TObject);
begin
     imfboxDn(sender, SysPropList);
end;

procedure TForm1.SysPropUpClick(Sender: TObject);
begin
     imfboxUp(sender, SysPropList);
end;

procedure TForm1.SysPropEditClick(Sender: TObject);
begin
     imfboxEdit(sender, SysPropList, 'Edit away, McDuff!');
end;

procedure TForm1.SysAttribListChange(Sender: TObject);
begin
     if (SysAttribList.items.count<2) then begin
        SysAttribUp.Enabled:=False;
        SysAttribDn.Enabled:=False;
     end else begin
        SysAttribUp.Enabled:=TRUE;
        SysAttribDn.Enabled:=True;
     end;
end;

procedure TForm1.SysPropListChange(Sender: TObject);
begin
     if (SysPropList.items.count<2) then begin
        SysPropUp.Enabled:=False;
        SysPropDN.Enabled:=False;
     end else begin
        SysPropUp.Enabled:=TRUE;
        SysPropDn.Enabled:=True;
     end;
end;

procedure TForm1.SysPropListEnter(Sender: TObject);
begin
     if SysAttribList.itemindex>-1 then SysAttribList.ItemIndex:=-1;
end;

procedure TForm1.SysAttribListEnter(Sender: TObject);
begin
     if SysPropList.itemindex>-1 then SysPropList.ItemIndex:=-1;
end;

procedure TForm1.SysAttribListKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var s : string[20];
begin
     if activeControl=SysAttribList then s:='constant' else s:='global';
     if (shift=[]) then begin
        if (key=vk_insert) then ImfBoxAdd(sender, sender as TpickList,
           'Enter the '+s+' to add to the list:');
        if (key=vk_delete) then ImfBoxDelete(sender, sender as TpickList);
        if (key=vk_back) then ImfBoxDelete(sender, sender as TpickList);
        if (key=vk_Return) then ImfBoxEdit(sender, sender as TpickList,
           'Edit the '+s+' to your heart''t content:');
        if (key=vk_Right) then begin
           if activeControl=SysAttribList then SysPropList.SetFocus;
           if activeControl=SysPropList then SysAttribList.SetFocus;
        end;
        if (key=vk_Left) then begin
           if activeControl=SysPropList then SysAttribList.SetFocus;
           if activeControl=SysAttribList then SysPropList.SetFocus;
        end;
     end else
     if (shift=[ssshift]) then begin
        if (key=vk_up) then ImfBoxUp(sender, sender as TpickList);
        if (key=vk_down) then ImfBoxDn(sender, sender as TpickList);
     end;
end;

procedure TForm1.SysConstAddClick(Sender: TObject);
begin
     ImfBoxAdd(sender, SysConstList, 'Please enter the new constant to be added:');
     SysConstListChange(sender);
end;

procedure TForm1.SysConstDeleteClick(Sender: TObject);
begin
     ImfBoxDelete(sender, SysConstList);
     SysConstListChange(sender);
end;

procedure TForm1.SysConstEditClick(Sender: TObject);
begin
     ImfBoxEdit(sender, SysConstlist, 'Johnny cracks corn and I don''t care.');
end;


procedure TForm1.SysConstDnClick(Sender: TObject);
begin
      IMFboxDn(sender, Sysconstlist);
end;

procedure TForm1.SysConstUpClick(Sender: TObject);
begin
     imfboxup(sender, Sysconstlist);
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
     OpenDialog.execute;
end;

procedure TForm1.Export1Click(Sender: TObject);
begin
     ExportDialog.execute;
end;

procedure TForm1.SysConstListChange(Sender: TObject);
begin
     if (SysConstList.items.count<2) then begin
        SysConstUp.Enabled:=False;
        SysConstDN.Enabled:=False;
     end else begin
        SysConstUp.Enabled:=TRUE;
        SysConstDn.Enabled:=True;
     end;
end;

procedure TForm1.CallFSedit(sender : Tobject; s : string);
var tmpstate : TwindowState;
    tmpTop, tmpLeft, TmpWidth, tmpHeight : integer;
begin
     if (InfConfig.FSE_Top<>0) and
        (InfConfig.FSE_Left<>0) and
        (InfConfig.FSE_Height<>0) and
        (InfConfig.FSE_Width<>0)
        then begin
             Fsedit.top:=InfConfig.FSE_Top;
             Fsedit.Left:=InfConfig.FSE_Left;
             Fsedit.Height:=InfConfig.FSE_Height;
             Fsedit.Width:=InfConfig.FSE_Width;
             Fsedit.WIndowState:=TwindowState(InfConfig.FSE_State);
     end;

     FSedit.Memo.Clear;
     FSedit.Memo.Lines.AddStrings((sender as Tpicklist).Items);
     FSEdit.Caption:=s;
     If FSEdit.showmodal<>mrCancel then begin
        (sender as TPicklist).clear;
        (sender as TPicklist).Items.addstrings(FSedit.Memo.Lines);
     end;

     if (Fsedit.top<>InfConfig.FSE_Top) or
        (Fsedit.Left<>InfConfig.FSE_Left) or
        (Fsedit.Height<>InfConfig.FSE_Height) or
        (Fsedit.Width<>InfConfig.FSE_Width) or
        (Fsedit.WIndowState<>TwindowState(InfConfig.FSE_State))
        then begin
             InfConfig.FSE_Top:=Fsedit.top;
             InfConfig.FSE_Left:=Fsedit.Left;
             InfConfig.FSE_Height:=Fsedit.Height;
             InfConfig.FSE_Width:=Fsedit.Width;
             InfConfig.FSE_State:=integer(Fsedit.WIndowState);
             Fini:=TIniFile.Create(ConfigSaveDlg.FileName);
             Fini.WriteInteger('MINI_EDITOR','State',Integer(InfConfig.FSE_state));
             Fini.WriteInteger('MINI_EDITOR','X_Pos',InfConfig.FSE_left);
             Fini.WriteInteger('MINI_EDITOR','Y_Pos',InfConfig.FSE_top);
             Fini.WriteInteger('MINI_EDITOR','Width',InfConfig.FSE_Width);
             Fini.WriteInteger('MINI_EDITOR','Height',InfConfig.FSE_Height);
             Fini.Free;
     end;
end;

procedure TForm1.SysConstListDblClick(Sender: TObject);
begin
     CallFsEdit(Sender, 'Editing declared Constant list...');
end;

procedure TForm1.SysPropFSClick(Sender: TObject);
begin
     SysPropFS.Down:=TRUE;
     CallFsEdit(SysPropList, 'Editing declared Constant list...');
     SysPropFS.Down:=FALSE;
end;

procedure TForm1.SysAttribFSClick(Sender: TObject);
begin
     SysAttribFS.Down:=TRUE;
     CallFsEdit(SysAttribList, 'Editing defined Attibute list...');
     SysAttribFS.Down:=FALSE;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var tmpindex : integer;
begin
     if (shift=[ssCtrl]) then begin
        tmpindex:=-1;
        if (Key=byte('S')) then TmpIndex:=0 else
        if (key=byte('R')) then TmpIndex:=1 else
        if (key=byte('D')) then TmpIndex:=2 else
        if (key=byte('O')) then TmpIndex:=3 else
        if (key=byte('C')) then TmpIndex:=4 else
        if (key=byte('F')) then TmpIndex:=5 else
        if (key=byte('G')) then TmpIndex:=6 else
        if (key=byte('T')) then TmpIndex:=7;
        if tmpindex>-1 then begin
           ImfTabSet.TabIndex:=TmpIndex;
         {  ImfNoteBook.PageIndex:=TmpIndex;}
        end;
     end;
end;

procedure TForm1.ImfTabSetChange(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
{    ImfNoteBook.PageIndex := ImfTabSet.TabIndex;}
end;

procedure TForm1.IncParserRClick(Sender: TObject);
begin
     IncParserR.checked:=TRUE;
     IncParser.SetFocus;
end;

procedure TForm1.IncVerbLibRClick(Sender: TObject);
begin
     IncVerbLibR.Checked:=TRUE;
     IncVerbLib.SetFocus;
end;

procedure TForm1.IncGrammarRClick(Sender: TObject);
begin
     IncGrammarR.Checked:=TRUE;
     IncGrammarR.SetFocus;
end;

procedure TForm1.SysTitleLClick(Sender: TObject);
begin
     SysTitle.SetFocus;
end;

procedure TForm1.SysHeadLineLClick(Sender: TObject);
begin
     SysHeadline.SetFocus;
end;

procedure TForm1.SysSwitchesLClick(Sender: TObject);
begin
     SysSwitches.SetFocus;
end;

procedure TForm1.IncParserLClick(Sender: TObject);
begin
     IncParser.SetFocus;
end;

procedure TForm1.IncVerbLibLClick(Sender: TObject);
begin
     IncVerbLib.SetFocus;
end;

procedure TForm1.IncGrammarLClick(Sender: TObject);
begin
     IncGrammar.SetFocus;
end;

procedure TForm1.IncGroupBoxClick(Sender: TObject);
begin
     if IncludeFocus=3 then IncGrammar.Setfocus else
     if IncludeFocus=2 then IncVerbLib.SetFocus else
        IncParser.SetFocus;
end;

procedure TForm1.SysGlobAddClick(Sender: TObject);
begin
     ImfBoxAdd(sender, SysGlobList, 'Please enter the new global to be added:');
     SysGlobListChange(sender);
end;

procedure TForm1.SysGlobDeleteClick(Sender: TObject);
begin
     ImfBoxDelete(sender, SysGlobList);
     SysGlobListChange(sender);
end;

procedure TForm1.SysGlobDnClick(Sender: TObject);
begin
      IMFboxDn(sender, SysGlobList);
end;

procedure TForm1.SysGlobEditClick(Sender: TObject);
begin
     ImfBoxEdit(sender, SysGloblist, 'Globals can be wonderfulthings:');
end;

procedure TForm1.SysGlobFSClick(Sender: TObject);
begin
     SysConstFS.Down:=TRUE;
     CallFsEdit(SysGlobList, 'Editing declared Globals list...');
     SysConstFS.Down:=FALSE;
end;

procedure TForm1.SysGlobUpClick(Sender: TObject);
begin
     imfboxup(sender, SysGlobList);
end;

procedure TForm1.SysGlobListChange(Sender: TObject);
begin
     if (SysGlobList.items.count<2) then begin
        SysGlobUp.Enabled:=False;
        SysGlobDN.Enabled:=False;
     end else begin
        SysGlobUp.Enabled:=TRUE;
        SysGlobDn.Enabled:=True;
     end;
end;

procedure TForm1.SysGlobListDblClick(Sender: TObject);
begin
     CallFsEdit(Sender, 'Editing declacred Globals list...');
end;

procedure TForm1.Debuggo1Click(Sender: TObject);
begin
     DebugDlg.Visible:=not(DebugDlg.Visible);
end;

procedure TForm1.GramTypeClick(Sender: TObject);
begin
     If GramType.ItemIndex=0 then GramPos.Enabled:=FALSE;
     If GramType.ItemIndex=1 then GramPos.Enabled:=TRUE;
end;

procedure TForm1.LoadConfig1Click(Sender: TObject);
begin
     if ConfigRestoreDlg.Execute then begin
        RestoreConfig(ConfigRestoreDlg.Filename, TRUE);
     end;
end;

procedure TForm1.SaveSetup1Click(Sender: TObject);
begin
     ConfigRestoreDlg.FileName:=ConfigRestoreDlg.FileName;
     if ConfigSaveDlg.Execute then begin
        SaveConfig(ConfigSaveDlg.Filename);
     end;
end;

procedure TForm1.MMBubbleHelpClick(Sender: TObject);
begin
     MMBubbleHelp.Checked := Not(MMbubbleHelp.Checked);
     infConfig.BubbleHelp:=MMBubbleHelp.Checked;
end;

procedure TForm1.SysAttribListDblClick(Sender: TObject);
begin
     CallFsEdit(Sender, 'Editing declared Attibute list...');
end;

procedure TForm1.SysPropListDblClick(Sender: TObject);
begin
     CallFsEdit(Sender, 'Editing declared Property list...');
end;

procedure TForm1.GramSizerSliding(Sender: TObject; X, Y: Integer);
var dp : integer;
begin
     dp:=261;
     DebugDlg.Label4.Caption:=('x='+IntToStr(x)+'  y='+IntToStr(y));
     if y<150 then GramSizer.Top:=150 else
     if y>380 then GramSizer.Top:=380 else
     begin
          {GramModGroup}
     end;
end;

procedure TForm1.GramSizerNewPosition(Sender: TObject);
var dp, gh, cp, ch, lp, dif : integer;
begin
     dp:=261;
     gh:=216;
     cp:=291;
     ch:=96;
     lp:=271;
     if GramSizer.Top<150 then GramSizer.Top:=150;
     if GramSizer.Top>380 then GramSizer.Top:=380;
     dif:= dp - GramSizer.Top;
     GramModGroup.Height:=gh-dif;
     GramCmt.Height:=ch+dif;
     GramCmt.Top:=cp-dif;
     GramCmtL.Top:=lp-Dif;
end;

procedure TForm1.SysConstFSClick(Sender: TObject);
begin
     SysConstFS.Down:=TRUE;
     CallFsEdit(SysConstList, 'Editing declared Constant list...');
     SysConstFS.Down:=FALSE;
end;

end.

{
What shall we sell you today
what tillating toy
of snakeoil joy
can we induce you to play with
today

Can you complain now we've packaged your pain
Like girls just having fun
spitting off bridges
at cars
on the four o one.

We've set a new record
every day that you've lived
astonished what you'll give
your fetoeses, your limbs
your treasures for sins
your answers for question
your truth for suggestions
your youth appearance
your soul for adherance
your profit for shares
of human despair

It makes you happy
makes me happy
makes us happy
we're all happy
when you cry
or when you laugh
when someone dies
you didn't know
anyone
or
anything
in
retrospect
again

What shall we sell you today
what tillating toy
of forgetful joy
can we induce you to play yes-
terday







}
