
#include <stdio.h>
#include <stdlib.h>

#include "pickle.h"
#include "picklewr.h"

#ifdef __STDC__
void dump_file(char *filenm);
#else
void dump_file();
#endif

short dirformat = FALSE;

#ifdef __STDC__
main(int argc, char *argv[])
#else
main(argc, argv)
int argc;
char *argv[];
#endif
{
	int ix;
	
	if (argc == 1) {
		fprintf(stderr, "usage: piklist [ -m ] file [ file2 ...]\n");
		fprintf(stderr, "Prints out a list of all the chunks in a PICKLE file.\n");
		fprintf(stderr, " -m: Print the list in the format used by pikmake.\n");
		exit(-1);
	}
	
	ix = 1;
	if (argv[ix][0] == '-' && argv[ix][1] == 'm') {
		dirformat = TRUE;
		ix++;
	}
	
	for (; ix<argc; ix++) {
		fprintf(stderr, "\n%s:\n", argv[ix]);
		if (dirformat) 
			printf("\n# %s:\n", argv[ix]);
		dump_file(argv[ix]);
	}
}

#ifdef __STDC__
void dump_file(char *filenm)
#else
void dump_file(filenm)
char *filenm;
#endif
{
	FILE *file;
	char magicnumber[4];
	char typebuf[5];
	long count;
	pikMapPtr map;
	pikLong numchunks;
	pikErr perr;
	pikIndChunk chunk;
	
	file = fopen(filenm, "rb");
	if (!file) {
		fprintf(stderr, "Unable to open file.\n");
		return;
	}
	
	count = fread(magicnumber, 1, 4, file);
	if (count != 4) {
		fprintf(stderr, "Unable to read file.\n");
		fclose(file);
		return;
	}
	
	if (!pikIsPickleHeader(magicnumber)) {
		fprintf(stderr, "Not a PICKLE file.\n");
		fclose(file);
		return;
	}
	
	perr = pikCreateMap(file, &map);
	if (perr) {
		if (perr == pikerr_WrongEndian)
			fprintf(stderr, "The PICKLE library was compiled with the wrong endianness.\n");
		else if (perr == pikerr_WrongSizeInts)
			fprintf(stderr, "The PICKLE library was compiled with the wrong int size.\n");
		else
			fprintf(stderr, "Unable to read index map.\n");
		fclose(file);
		return;
	}
	
	perr = pikxGetChunkCount(map, &numchunks);
	if (perr) {
		fprintf(stderr, "Unable to count chunks.\n");
		fclose(file);
		return;
	}
	
	for (count=0; count<numchunks; count++) {
		perr = pikxFindIndChunk(map, count, &chunk);
		if (perr) {
			fprintf(stderr, "Unable to get info for chunk %ld.\n", count);
			continue;
		}
		if (!dirformat) {
			pikxTypeToString(chunk.use, typebuf);
			printf("%s %ld: ", typebuf, chunk.number);
			pikxTypeToString(chunk.format.name, typebuf);
			printf("(%s %ld) ", typebuf, chunk.format.version);
			printf("length %ld, start %ld", chunk.length, chunk.startpos);
			printf("\n");
		}
		else {
			pikxTypeToString(chunk.use, typebuf);
			printf("%s %ld ", typebuf, chunk.number);
			pikxTypeToString(chunk.format.name, typebuf);
			printf("%s %ld ", typebuf, chunk.format.version);
			printf("%s %ld %ld", filenm, chunk.startpos, chunk.length);
			printf("\n");
		}
	}
	
	fclose(file);
}
