/* macglk_startup.c: Macintosh-specific code for Floo.
    Designed by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/floo/index.html

    This sets a few Mac-specific options, and tells the library to open
    a TEXT file containing the Floo program to be executed.
*/

#include "glk.h"
#include "gi_dispa.h"

#include "macglk_startup.h" /* This comes with the MacGlk library. */

static OSType gamefile_type = 'TEXT';
extern strid_t gamefile; /* This is defined in main.c. */

Boolean macglk_startup_code(macglk_startup_t *data)
{
    data->app_creator = 'gFlo';
    data->startup_model = macglk_model_ChooseFile;
    data->gamefile_types = &gamefile_type;
    data->num_gamefile_types = 1;
    data->gamefile = &gamefile;
    
    return TRUE;
}
