/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef __win_h
#define __win_h

#include "glk.h"
#include "rect.h"
#include "list.h"

#define evrequest_None 0
#define evrequest_Char 1
#define evrequest_Line 2

typedef struct _win win;
struct _win {
	winid_t parent, child[2];
	rect bounds;

	glui32 type;
	glui32 rock;
	strid_t stream;
	glui32 split;
	glui32 split_size;
	
	int evrequest;
	char *linebuf;
	glui32 linebuf_max;
	glui32 linebuf_cur;
	glui32 linebuf_pos;
	
	unsigned char stylecolor[style_NUMSTYLES];
	
	int need_refresh;
	unsigned top_row;
	unsigned last_page;
	unsigned out_row;
	unsigned out_col;
	list *row;
	
	strid_t echo;
};

win *lglk_get_window(winid_t id);
winid_t lglk_get_focus();
void lglk_cycle_focus();
void lglk_window_sync(); 
void lglk_window_snap();
void lglk_window_snap_win(winid_t id);
void lglk_window_page_win(winid_t id);
void lglk_window_putch(winid_t id, char c, glui32 style);

#endif

