/* gtblorb.c: Blorb resource loader
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/
#include "glk.h"
#include "gi_blorb.h"
#include <stdio.h>
#include "cscr.h"
#include "glkdos.h"

static giblorb_map_t *blorbmap = 0; /* NULL */

giblorb_err_t giblorb_set_resource_map(strid_t file)
{
  giblorb_err_t err;
  
  err = giblorb_create_map(file, &blorbmap);
  if (err) {
    blorbmap = 0; /* NULL */
    return err;
  }
  
  return giblorb_err_None;
}

giblorb_map_t *giblorb_get_resource_map()
{
  return blorbmap;
}
void gtblorb_describe_error(giblorb_err_t error)
{
 switch(error)
 {
case giblorb_err_None: return;
break;
case giblorb_err_CompileTime: gli_msgline("Blorb Layer: compile-time error");
break;case giblorb_err_Alloc: gli_msgline("Blorb Layer: could not allocate memory");
break;
case giblorb_err_Read: gli_msgline("Blorb Layer: read error");
break;
case giblorb_err_NotAMap: gli_msgline("Blorb Layer: bad blorb map");
break;
case giblorb_err_Format: gli_msgline("Blorb Layer: invalid blorb file");
break;
case giblorb_err_NotFound: gli_msgline("Blorb Layer: chunk not found");
}
cscr_getch();
 return;
}
