/* mouse.c
    common DOS mouse control module for cscr (curses and dos)
    by L. Ross Raszewski
*/
#include <dos.h>

static union REGS regs;
static union REGS regs2;
int go_mouse(int x)
{
 regs.x.ax=x;
 int86(0x33,&regs,&regs);
 return regs.x.ax;
}
#define MOUSE_FUNC(y,z)         int y()\
                                { regs.x.ax=(z);\
                                  int86(0x33,&regs,&regs);\
                                  return regs.x.ax;\
                                }
MOUSE_FUNC(init_mouse,0)
MOUSE_FUNC(show_mouse,1)
MOUSE_FUNC(hide_mouse,2)

int get_mouse(int *x, int *y)
{
if (regs2.x.bx==0)
{
regs.x.ax=5;
regs.x.bx=0;
int86(0x33,&regs,&regs2);
}
*x=regs2.x.cx;
*y=regs2.x.dx;
if (regs2.x.bx == 0) return 0;
regs.x.ax=6;
regs.x.bx=0;
int86(0x33,&regs,&regs);
if (regs.x.bx == 0) return 0;
regs2.x.bx=0;
if (*x != regs.x.cx || *y != regs.x.dx) return 0;
return 1;
}

