
package org.ifarchive.glk;

import java.io.IOException;

/** If Blorb fails, this exception is thrown.
 * @author John Elliott
 * @version 1.0
 */
public class BlorbException extends IOException
{
	/** The actual error code returned from the library */
	public int error; 

	private BlorbException() { super(); }
	private BlorbException(String s) { super(s); }

	/** Construct and throw a Blorb exception.
	 * @param err The error returned from the library 
	 */ 
	public static void doThrow(int err) throws BlorbException
	{
		String s = stringify(err);
		throw new BlorbException(s);
	}

	static String stringify(int err)
	{
		String s = "Blorb error: ";
		switch(err)
		{
			case 0: s += "No error"; break;
			case 1: s += "Compile time error"; break;
			case 2: s += "Could not allocate memory"; break;
			case 3: s += "Could not read from the file"; break;
			case 4: s += "The map parameter is invalid"; break;
			case 5: s += "The Blorb file is corrupted or invalid"; break;
			case 6: s += "The requested data could not be found"; break;
			default: s += "Unknown error " + Integer.toString(err);
		}
		return s;
	}	
}
