
package org.ifarchive.glk;

/** A Glk dispatch function description.
 *  Note that the function pointer doesn't percolate up to the Java
 *  layer; only C sees it.
 * 
 * @author John Elliott
 * @version 1.0 */

public class Function
{
	/** The name of this function. */
	public String name;
	/** The function's dispatch ID. */
	public int id;

        Function(String n, int i)
        {
                name = n; id = i;
        }

	/** Get prototype string for a function.
	 * See the Glk specification for full details.
	 * @return The prototype string; null if the function can't be invoked through Glk.dispatchCall() 
	 * @see Glk#dispatchCall */
	public String prototype()
	{
		return Glk.jnigidispatch_prototype(id);
	}

	/** Return count of Glk functions. 
	 * @return number of functions in this Glk library. */
        public static int count()
        {
                return Glk.jnigidispatch_count_functions();
        }
	/** Get a Glk function by its index
	 * @param index The number of the function, 0 - count()
	 * @return The corresponding Function, or null if there isn't one. 
	 * @see #count() */
        public static Function get(int index)
        {
                return Glk.jnigidispatch_get_function(index);
        }
	/** Get a Glk function by its ID.
	 * @param id The ID number for the function.
	 * @return The corresponding Function, or null if there isn't one. */
	public static Function getByID(int id)
	{
		return Glk.jnigidispatch_get_function_by_id(id);
	}
  
	/** Get prototype string for a function.
	 * See the Glk specification for full details.
	 * @return The prototype string; null if the function can't be invoked through Glk.dispatchCall() 
	 * @see Glk#dispatchCall */
	public static String prototype(int func)
	{
		return Glk.jnigidispatch_prototype(func);
	}

	/** Parse the prototype string for a function and display it.
	 * See the Glk specification for full details.
	 * @return A human-readable dump of the parsed data.
	 * @see Glk#dispatchCall */
	public String parsedPrototype()
	{
		return parsedPrototype(id);
	}
	
	/** Parse the prototype string for a function and display it.
	 * See the Glk specification for full details.
	 * @param func The Glk ID of the function.
	 * @return A human-readable dump of the parsed data.
	 * @see Glk#dispatchCall */
	public static String parsedPrototype(int func)
	{
		String pr = prototype(func);
		if (pr == null) return "Cannot be invoked by dispatch layer";
		String s = "Raw prototype = " + pr;
		Prototype p[] = Prototype.parseString(pr);
		if (p == null) return "No parameters or results";
		for (int n = 0; n < p.length; n++)
		{
			s += "\n  " + p[n].toString();
		}
		return s;
	}

}
