

package org.ifarchive.glk;

/** The opaque object registry allows a user program to be called when 
 * opaque objects are created or destroyed.
 * 
 * <p>In Java, do this by implementing the ObjectRegistry interface, and
 * calling OpaqueObject.setRegistry().
 *
 * @see OpaqueObject#setRegistry
 * @author John Elliott
 * @version 1.0 */

public interface ObjectRegistry
{
	/** Register an opaque object.
	 * @param obj The object to register.
	 * @param objclass Its Glk class
	 * @return A dispatch rock that will be associated with this object.
	 */  
	public Object reg(OpaqueObject obj, int objclass);
	/** Unregister an opaque object.
	 * @param obj The object to unregister.
	 * @param objclass Its Glk class
	 * @param rock The object's dispatch rock.
	 */  
	public void unreg(OpaqueObject obj, int objclass, Object rock);
}
