
package org.ifarchive.glk;

import java.io.Writer;

/** This is a Writer that works on a Glk stream. 
 * The GLK stream must be open for output.
 * @author John Elliott
 * @version 1.0
 */

public class StreamWriter extends Writer
{
	Stream m_s;

	/** Create a stream writer. The underlying stream must have been
	 * opened in write or append mode. */
	public StreamWriter(Stream s)
	{
		m_s = s;
	}

	/** Returns the GLK stream associated with this StreamReader */
	public Stream getStream()
	{
		return m_s;
	}

	/** Close the stream. */
	public void close()
	{
		m_s.close();
	}


	/** Flush bytes written to this stream. Does nothing.
	 *  @see java.io.Writer#flush()  */	
	public void flush()
	{

	}


	/** Write bytes to this stream. 
	 * @param cbuf Array of characters
	 * @param off Offset from which to start writing characters
	 * @param len Number of characters to write
	 *  @see java.io.Writer#write(char[],off,len) */
	public void write(char cbuf[], int off, int len)
	{
		m_s.putBuffer(cbuf, off, len); 
	}

	/** Write a single character to this stream. 
	 * @param ch The character to output
	 */
	public void write(char ch)
	{
		m_s.putChar(ch);
	}
}
