! Custom routines. These are routines that can be provided by the programmer to do certain
! things. Unless you have a VERY good reason, NEVER allow a routine that replaces a stubbed one
! to contain nothing. It MUST contain a rfalse!

! AfterLife
! Allows the player to be given a second chance before death.
! Only called if deadflag is not 0 (normal) or 2 (winning).
! i.e. 1 (death) or 3 and above (exotic death).
[ AfterLife;
 rfalse;
];

! AfterPrompt
! Just after the prompt is displayed.
! Whereas GamePostRoutine is like a super-after rule, AfterPrompt should be used for system
! manipulation (as opposed to game manipulation).
[ AfterPrompt;
 rfalse;
];

! Amusing
! Providing the AMUSING_PROVIDED default is set to 0, shows amusing things to do.
! So long as you die (method 2, i.e. winning).
[ Amusing;
 rfalse;
];

! BeforeParsing
! Just before the prompt is displayed.
! Whereas GamePreRoutine is like a super-before rule, BeforeParsing should be used for system
! manipulation (as opposed to game manipulation).
[ BeforeParsing;
 rfalse;
];

! DarkToDark
! To quote Graham Nelson:
! "Called when a player goes from one dark room into another one; a splendid excuse to kill the
!  player off."
[ DarkToDark;
 rfalse;
];

! DeathMessage
! What to do in the likely event of death.
! Use of deadflag (the variable which controls your death):
! 0 - Normal (playing).
! 1 - Dead (standard message).
! 2 - Won (standard message).
! 3 and above - Custom messages.
! Setting this variable to any non-zero value will end the game.
! Despite the name, 'deadflag' can (and must) also refer to winning and losing.
[ DeathMessage;
 switch (deadflag)
 {
  default: ;			! Do nothing.
 }
 rfalse;
];

! GamePostRoutine
! Allows you to do things after the player has done something.
[ GamePostRoutine;
 rfalse;
];

! GamePreRoutine
! Allows you to do things before the player can do anything.
[ GamePreRoutine;
 rfalse;
];

! TimePasses
! What happens with the passing of time. This is called after every turn.
[ TimePasses;
 rfalse;
];

! PrintRank
! Displays a rank based on your current score.
[ PrintRank;
 print ". ";	! As typing 'score' both displays your score and rank.
 switch (score)
 {
  default: ;	! Do nothing by default.
 }
 NewLine (1);	! As typing 'score' both displays your score and rank.
 rfalse;
];

! ParserError
! Prints an error message dependent upon what you tell it.
[ ParserError TheError;
 switch (TheError)
 {
  default: rfalse;	! Carry on, print whatever you were going to print. THIS MUST BE LAST!
 }
 rfalse;	! Should NEVER get here! Use "xxx" or print_ret "xxx", NEVER just print "xxx".
];

[PrintTaskName ach;
 switch (ach)
 {
 }
];

! NewLine
! Prints 'NewLines' number of new_lines.
[ NewLine NewLines Count;
 for (Count=0: Count<NewLines: Count++)
 {
  new_line;
 }
 rfalse;
];

! clrscr
! Clears the screen.
[ clrscr;
 @erase_window $ffff;
 rfalse;
];

! FormatText
! Syntax: FormatText (string);
! To quote Allen Garvin, the author of this routine:
! "I added the printf from the designer's manual, but didn't find it very useful, so I changed
! it into this :)"
! Note that this routine uses the global table 'printed_text'.
! You may need to increase $MAX_STATIC_DATA should you make this table larger.
[ FormatText format j k;
 @output_stream 3 printed_text;	! Most cunning. Re-route textual output to this array.
 print (string) format;		! Just print it out (to an array and not the screen).
 @output_stream -3;		! And resume normal service.
 j = printed_text-->0;		! Determine (less 2) the string length.
 for (k=2: k<j+2: k++)		! Then get to work.
 {
  if (printed_text->k == '%')	! A '%' symbol is used to control formatting.
  {
   switch (printed_text-> (++k))
   {
    '%': print "%";		! To get a % mark, use '%%'.
    ' ': spaces 1;		! To get a single space, '% '. Not sure why this may be of use.
    'B': style bold;		! i.e. use the sequence '%B' for bold text.
    'F': style fixed;		! i.e. use the sequence '%F' for fixed-point text.
    'P': style roman;		! i.e. use the sequence '%P' to return to normal.
    'R': style reverse;		! i.e. use the sequence '%R' for reverse-video text.
    'U': style underline;	! i.e. use the sequence '%U' for underlined text.
   }
  } else			! Just print the character out.
  {
   print (char) printed_text->k;
  }
 }
];