"Gotomomi 2.0" by "Arno von Borries"

Book 1 - Setup

Part 1 - General

Chapter 1 - Included Extensions

Include Custom Library Messages by Ron Newcomb.
Include Far Away by Jon Ingold.
Include Lost Items by Mike Ciul.
Include Quip-Based Conversation by Michael Martin.
Include Touchy Feely by Quantum Games.
Include Basic Help Menu by Emily Short.
Include Locksmith by Emily Short.

Chapter 2 - Global settings

Use no scoring.
Use full-length room descriptions.

The story tense is past tense.
The story viewpoint is first person.
The time of day is 10:30 PM.

Rule for deciding whether all includes scenery: it does not.
Rule for deciding whether all includes backdrop: it does not.
Rule for deciding whether all includes people: it does not.
[The describe what’s on scenery supporters in room descriptions rule is not listed in any rulebook.]

Before doing something when QBC is active (this is the QBC force conversation rule):
	if the current action is not QBC responding with:
		say "[bracket]Only talk options and REPEAT allowed[close bracket][paragraph break]" instead.

The QBC force conversation rule is listed first in the before rules.

[Before going: terminate the conversation.]

Table of Basic Help Options (continued)
title			description
"Credits"	"Gotomomi version 1[paragraph break]by Arno von Borries for the Interactive Fiction Competition 2015,[paragraph break]written in Inform 7, using Extensions by Michael Callaghan, Mike Ciul, Quantum Games, John Ingold, Michael Martin, Ron Newcomb and Emily Short.[paragraph break]Beta testing by Christina Rietz and Christopher Scharlau.[paragraph break]I would like to thank my friends and family for extensive alpha testing and the resulting suggestions, many of which found their way into the final version.[paragraph break]The author can be contacted via email: arno.v.borries@web.de[line break]".

Understand "credits" and "about" as asking for help.

Chapter 3 - Map indexing

Index map with L0_pawnshop mapped east of L0_streets_hub_4.
Index map with L-1_sewer_deadend_1 mapped west of L-1_sewer_junction_5.
Index map with L0_streets_hub_1 mapped west of L0_bordello_gallery.
Index map with L1_mall_hub mapped east of L1_station_gates.
Index map with L-1_clothes mapped east of L-1_canal_pier_2.
Index map with Lift mapped east of L0_mall_hub.
Index map with Generic Floor mapped north of Lift.

Chapter 4 - New actions

Section 1 - Taking

The taking action has an object called previous locale (matched as "from").

Setting action variables for taking: 
    now previous locale is the holder of the noun.
Report taking something from the location: 
    say "I picked up [the noun] from the ground." instead.
Report taking something: 
    say "I took [the noun] from [the previous locale]." instead.

Section 2 - Dancing

Dancing is an action applying to nothing.
Understand "dance" and "rave" and "swirl" and "dance around" and "rave around" and "swirl around" as dancing.

Check dancing:
	if the player is raving:
		say "I increased my efforts." instead.

Check dancing:
	if the location is L-1_danceclub_dancefloor:
		now the player is raving;
		say "I started to dance, [one of]trying to move with the flow of the others.[or]moving deeper into the thicket of bodies.[or]trying to flow with the movements of the others.[or]hoping to not stand out too much.[at random]" instead.

Report dancing:
	say "As much as I would have liked to, this was hardly the place for it."

Every turn when the player is raving:
	If a random chance of 1 in 2 succeeds:
		say "[one of]A circle of middle aged men formed around me, their eyes all over.[or]A few girls fell in with my movements, looking for safety in the group.[or]Someones sweaty back was rubbing against mine.[or]Suddenly a pair of hands were on my hips.[or]The floor was so packed with people now, there was not much difference to riding the subway.[or]A young man in an inscrutable Hawaii shirt began to start feeling me up from behind, his hands moving upwards rather quickly.[or]A couple of guys were watching me, desperately holding on to their drinks so they wouldn't have to move so much.[at random]".

Stopping to dance is an action applying to nothing.
Understand "stop dancing" and "stop swirling" and "stop raving" and "stop" and "flee" as stopping to dance when the location is L-1_danceclub_dancefloor.

Check stopping to dance:
	if the player is raving:
		now the player is not raving;
		say "[one of]I stopped the silliness, having had enough for the moment.[or]I needed some space to breathe, so I made my way out of the crowd.[or]I stopped moving with the music, ending all the unwanted attention.[at random]" instead.
		
		Report stopping to dance:
	say "I hadn't even started yet."
	
Section 3 - Cutting

Understand the command "cut" as something new.

Cutting it with is an action applying to two things.
Understand "cut [something] with [something]" and "clip [something] with [something]" as cutting it with.

Check cutting it with:
	if the noun is not the barbed wire:
		say "Better to leave that intact." instead.

Check cutting it with:
	if the second noun is not a cutter:
		say "[the second noun] was hardly suited to cut [the noun]." instead.

Check cutting it with:
	if the noun is cut:
		say "[the noun] had been cut already." instead.

Carry out cutting it with:
	now the noun is cut.
	
Report cutting it with:
	say "I cut [the noun] with [the second noun]."
	
Section 4 - Fanning

fanning is an action applying to nothing.
Understand "fan" and "fan air" as fanning.
Check fanning:
	if the player is not carrying a fan:
		say "I had no fan." instead.
Report fanning:
	say "I fanned myself with [the random fan carried by the player]."
		
fanning it with is an action applying to one thing.
Understand "fan with [something]" and "fan air with [something]" as fanning it with.
Understand "wave [something]" as fanning it with.
Check fanning it with:
	if the noun is not a fan:
		say "That was not something I could fan myself with." instead.
Check fanning it with:
	if the noun is not carried by the player:
		say "I didn't have [the noun] on me." instead.
Report fanning it with:
	say "I fanned myself with [the noun]."

Section 5 - Attacking

Understand the commands "attack" and "punch" and "destroy" and "kill" and "murder" and "hit" and "thump" and "break" and "smash" and "torture" and "wreck" as something new.
	
Attacking it with is an action applying to one visible thing and one carried thing. Understand "attack [someone] with [something preferably held]" as attacking it with.

Understand the commands "punch" and "destroy" and "kill" and "murder" and "hit" and "thump" and "break" and "smash" and "torture" and "wreck" and "stab" and "slash" and "bludgeon" and "slit" as "attack".

Check an actor attacking something with something (this is the can't attack with something that isn't a weapon rule):
	if the second noun is not a weapon:
		if the actor is the player, say "[The second noun] was unsuitable as a weapon.";
		stop the action.

Check an actor attacking something with something (this is the can't attack a non-person rule):
	if the noun is not a person:
		if the actor is the player, say "I was not going to vandalise [the noun].";
		stop the action.

Carry out an actor attacking something with something (this is the standard attacking it with a weapon rule):
	do nothing.

Report attacking someone with something (this is the normal attacking report rule):
	say "I wouldn't turn to violence so easily." instead.

Report attacking the player with something (this is the standard report attacking the player with rule):
	say "I wasn't quite that desperate." instead.

Section 6 - Climbing and descending

Understand "go up [something]" as  climbing.
Instead of climbing a staircase: 
	try entering the noun.

Instead of climbing a supporter:
	try entering the noun.

Descending is an action applying to one thing. Understand "go down [something]" as descending. 
Instead of descending a staircase:
	try entering the noun.

Instead of descending a supporter:
	try getting off the noun. 

Understand "ascend", "above" and "upwards" as up.
Understand "descend", "below" and "downwards" as down.

Part 2 - Kinds of things

Chapter 1 - Clothing, Hats and Footwear

Some clothing is a kind of thing. The plural of clothing is articles of clothing. Clothing is wearable.

A sash is a kind of thing. A sash is wearable. The plural of sash is sashes.
A sash has a text called the knot.
The knot of a sash is usually "bunko-musubi". 

Table of Obi Musubi
name
"bunko-musubi"
"yanoji-musubi"
"washikusa-musubi"

Check wearing a sash:
	if the player is wearing a sash that is not the noun:
		say "I was already wearing an obi." instead.

Check wearing a sash:
	if the player is not wearing wafuku:
		say "That would hardly have constituted appropriate attire." instead.

Check wearing a sash (called X):
	choose a random row in the Table of Obi Musubi;
	now the knot of X is the name entry;
	continue the action.

Report wearing a sash (called X):
	say "I tied the obi in a [italic type][knot of X][roman type]." instead.
	
Understand "tie [sash]" as wearing.
Understand "untie [sash]" as taking off.

A wafuku is a kind of clothing. The plural of wafuku is wafuku.

Before taking off wafuku when the player is wearing a sash:
	say "I would first have had to take off the obi." instead.

Before going or exiting or getting off when the player is wearing wafuku and the player is not wearing a sash:
	say "I would have had to finish dressing before I would have been ready to head out into the world." instead.

A Hat is a kind of thing. A Hat is wearable.

The plural of Footwear is pairs of footwear. Some footwear is a kind of thing. Some footwear is wearable. Footwear is usually plural-named. The indefinite article of footwear is usually "a pair of".

Sandals are a kind of footwear. Sandals are plural-named.

Before exiting from a changing room when the player is wearing wafuku and the player is not wearing sandals:
	say "The shoes I wore hardly fit my clothing."
	
Clothing can be fitting. Clothing is usually not fitting.
A Hat can be fitting. A Hat is usually not fitting.
Footwear can be fitting. Footwear is usually not fitting. 
A sash can be fitting. A sash is usually not fitting.

Understand "clothing/clothes/attire/apparel" as clothing.
Understand "wafuku" as wafuku.
Understand "hat/cap" as a hat.
Understand "shoe/shoes/footwear" as footwear.
Understand "sandals" as sandals.
Understand "sash" as a sash.
Understand "knot/musubi" as a sash.
Understand "bunko-musubi", "janoji-musubi",  "washikusa-musubi", "bunko", "janoji" and "washikusa" as a sash.

Check wearing clothing:
	if the player is wearing clothing that is not the noun:
		say "I was wearing something else already." instead.

Check wearing A hat:
	if the player is wearing a hat that is not the noun:
		say "I was wearing something else on my head already." instead.
		
Check wearing footwear:
	if the player is wearing footwear that is not the noun:
		say "I was wearing some other footwear already." instead.

Check wearing clothing:
	if the noun is not fitting:
		say "[the noun] wouldn't fit me." instead.
		

Check wearing a hat:
	if the noun is not fitting:
		say "[the noun] wouldn't fit me." instead.
		
Check wearing footwear:
	if the noun is not fitting:
		say "[the noun] wouldn't fit me." instead.

Before going or exiting or getting off when the player is not wearing clothing:
	say "There was no way I would leave here stark naked." instead.

Before going or exiting or getting off when the player is not wearing footwear:
	say "I was not going anywhere without shoes on my feet." instead.

Chapter 2 - Fans

A fan is a kind of thing.

Understand "fan" as a fan.

Chapter 3 - Containers and Supporters

A container can be undressing. A container is usually not undressing.
A container can be stashing. A container is usually not stashing.
A supporter can be undressing. A supporter is usually not undressing.
A supporter can be stashing. A supporter is usually not stashing.

A changing room is a kind of container. A changing room is usually scenery. A changing room is enterable. A changing room is undressing.
Understand "changing cubicle/cabin" and "cubicle/cabin" as a changing room.

A curtain is a kind of thing.
A curtain can be drawn. A curtain is usually not drawn.
A part of every changing room is a curtain. 

Instead of going inside in the presence of a changing room (called X):
	try entering X instead.
	
Instead of doing anything with something that is not enclosed by a changing room when the player is in a changing room:
	say "I would have had to leave the changing room for that.";

Check pulling a curtain (called X):
	if X is drawn:
		now X is not drawn;
		say "I opened the curtain." instead.

Check pulling a curtain (called X):
	if X is not drawn:
		now X is drawn;
		say "I closed the curtain." instead.

Before pushing or opening or closing a curtain (called X):
	try pulling X instead.

Chapter 4 - Mirror

A mirror is a kind of thing. A mirror is usually scenery. The description of a mirror is usually "My freckles were really quite visible."

Understand "mirror" as a mirror.

Chapter 5 - Parcels

A parcel is a kind of container. A parcel is usually closed and not openable.

Understand "parcel/packet/package/delivery" as a parcel.
Before opening a parcel:
	say "That would not have been such a good idea, I'm afraid." instead.
	
Chapter 6 - Weapons

A weapon is a kind of thing. Understand "weapon" as a weapon.
A firearm is a kind of weapon. Understand "firearm" as a pistol.
A knife is a kind of weapon. Understand "knife" as a knife.

Chapter 6 - Fish

A species is a kind of value. The plural of species is species. The species are Bristlemouth, Rattail, Barreleye, and Ridgehead.

A fish is a kind of thing. The plural of fish is fish. A fish has a species. The species of a fish is usually Bristlemouth. The description of a fish is usually "A [species], [one of]disfigured[or]crippled[or]killed[or]visibly affected[at random] by [one of]cadmium[or]mercury[or]radioactive iodine[or]grey water[or]industrial sewage[at random] contamination."
Understand the species property as describing a fish.

Before listing contents: group fish together.

Rule for printing the name of a fish:
	say "[species]".

Rule for printing the plural name of a fish while grouping together:
	say "[species]s".

Rule for printing the name of a fish while grouping together:
	say "a [species]".

Rule for printing a number of fish (called the target): 
	if the listing group size is less than 4:
		say "a few "; 
	else if the listing group size is less than 6:
		say "some ";
	else if the listing group size is less than 8:
		say "a bunch of ";
	else:
		 say "many ";
	carry out the printing the plural name activity with the target.

Instead of the player taking a fish:
	say "Luckily enough, actually touching these wasn't my job."


Chapter 7 - Buckets

A colour is a kind of value. The plural of colour is colours. The colours are black, red, blue and green.

A bucket is a kind of container. A bucket is usually open. A bucket has a colour. The colour of a bucket is usually black. Understand "bucket" as a bucket.
Understand the colour property as describing a bucket. 

Before printing the name of a bucket while not grouping together: say "[colour] ". 

Before printing the plural name of a bucket while not grouping together: say "[colour] ".

The carrying capacity of a bucket is usually 10.

Rule for printing the name of a bucket while not inserting, or removing or grouping together: 
	say "bucket";
	omit contents in listing.

Rule for printing the plural name of a bucket while not inserting or removing or grouping together: 
	say "buckets";
	omit contents in listing.
	
	
Rule for printing the name of a bucket (called X) while grouping together: 
	say "a [colour of X]";
	omit contents in listing.

Rule for printing the plural name of a bucket (called X) while grouping together: 
	say "some [colour of X]";
	omit contents in listing.

Before listing contents: group buckets together.

After listing contents of a bucket (called X):
	if the number of things contained by X is 10:
		say ", it was thus filled to the brim with fish";
	else if the number of things contained by X is greater than 8:
		say ", it was thus almost full";
	else if the number of things contained by X is greater than 6 and the number of things contained by X is less than 9:
		say ", it was thus more than half full";
	else if the number of things contained by X is greater than 3 and the number of things contained by X is less than 7:
		say ", it was thus about half full";
	else if the number of things contained by X is greater than 1 and the number of things contained by X is less than 4:
		say ", it was thus not even half full".

After grouping together buckets:
	say  " bucket".
	
Instead of the player taking something from a bucket:
	say "That was luckily not my job."

Instead of the player inserting something that is not a fish into a bucket:
	say "That didn't belong in there."

Instead of putting a bucket on something:
	say "These buckets were meant to be placed on the floor."

Instead of inserting a bucket into something:
	say "For some reason, that didn't work."

Chapter 8 - Drugs

A dose is a kind of thing. The plural of a dose is doses. Understand "doses/accella/drug/drugs/pill/machine" as a dose. The description of a dose is usually "A translucent pill with a tiny machine inside." A dose is usually edible.

Instead of eating a dose:
	say "Over my dead body. Alcohol in moderation was to remain the only poison for me."


Chapter 9 - Cutters

A cutter is a kind of thing.

Part 3 - Money

Chapter 1 - Price and Wealth

Price is a kind of value. 100 yen specifies a price.

A person has a price called wealth.

Chapter 2 - Barter

A thing can be sell-able. A thing is usually not sell-able.

The buy_item is a thing that varies.
The sell_item is a thing that varies.
The last_offered_item is a thing that varies.
The last_wanted_item is a thing that varies.

The ask value is a price that varies.
The bid value is a price that varies.
The insult value is a price that varies.

A thing has a price called minimum value. The minimum value of a thing is usually 50 yen.
A thing has a price called desired value. The desired value of a thing is usually 500 yen.

Part 4 - The player character

Chapter 1 - Name and properties

Ayako is a woman.
The player is Ayako.

The scent of Ayako is "I smelled a faint whiff of sweat from under my armpits."
The feel of Ayako is "I tried tickling myself, but it wouldn't work."
The sound of Ayako is "I tried listening to my heartbeat for a while, but it wasn't loud enough to reach the unaided ear."
The taste of Ayako is "Slightly salty."

The Description of the player is "A girl of almost 16, freckled all over."
The greeting of the player is selftalk.
The wealth of the player is 150560 yen.

A promille is a kind of value. 1.4 pm specifies a promille.
Ayako can be raving. Ayako is not raving.
Ayako can be caught. Ayako is not caught.
Ayako can be arrested. Ayako is not arrested.
Ayako can be hired. Ayako is not hired.
Ayako can be payed. Ayako is payed.
Ayako can be pissed or calm. Ayako is not pissed.
Ayako can be aware. Ayako is not aware.
Ayako can be vaccinated. Ayako is not vaccinated.
Ayako can be cured. Ayako is not cured.
Ayako can be ill. Ayako is not ill.
Ayako can be boated. Ayako is not boated.
Ayako can be drunk. Ayako is not drunk.
Ayako can be rich. Ayako is not rich.
Ayako has promille. The promille of Ayako is usually 0.0 pm.

The money is backdrop. The money is everywhere. The description of the money is "I had [wealth of the player]."
Understand "yen/cash/dough/funds/gravy/riches/capital" as the money.

The player is in L-1_station_subway.

Chapter 2 - The players possessions

The player wears wafuku called a yukata. The printed name of the yukata is "linen [italic type]yukata[roman type]". The yukata is fitting. The yukata is sell-able. The minimum value of the yukata is 3000 yen. The desired value of the yukata is 9500 yen. The description of the yukata is "My summerwear was decorated with a bold composition of plum blossoms on a light yellow base. [If the player wears a sash]It was closed by [a random sash worn by the player]."

The player wears a sash called a hanhaba obi. The printed name of the hanhaba obi is "[italic type]hanhaba obi[roman type]". The hanhaba obi is fitting. The description of the hanhaba obi is "My sash was marine blue on one side and black on the other. [if the player wears the hanhaba obi]It was currently tied in a [italic type][knot of a random sash worn by the player][roman type]." The hanhaba obi is sell-able. The minimum value of the hanhaba obi is 5500 yen. The desired value of the hanhaba obi is 17500 yen.

The player wears sandals called some takai geta. The printed name of the takai geta is "[italic type]takai geta[roman type]". The takai geta are fitting. The takai geta are sell-able. The minimum value of the takai geta is 500 yen. The desired value of the takai geta is 1600 yen. The description of the takai geta is "[italic type]karankoron[roman type] made the high wooden sandals."

The player carries a wallet. The wallet is losable. The description of the wallet is "My wallet was embroidered with my [italic type]kamon[roman type]." 
A part of the wallet is the kamon. The description of the kamon is "My family crest."
Understand "purse" as the wallet.
Understand "crest/embroidery" and "family crest" as the kamon.

Instead of inserting the money into the wallet:
	say "It was already in the wallet."

Instead of taking the money:
	say "The money was were it belonged."
	
Instead of inserting something that is not an ID card into the wallet :
	say "That wouldn't fit in there."
	
Instead of inserting the wallet into the wallet:
	say "What a ridiculous idea."
	
Instead of inserting the kamon into the wallet:
	say "What a ridiculous idea."

After listing contents of the wallet:
	say " and [the wealth of the player]."
Understand "mon/kamon" as the kamon.

An ID card is a kind of thing.
Understand "identification" as an ID card.

In the wallet is an ID card called my ID. The description of my ID is "My personal identification card."

The player carries a fan called an uchiwa. The printed name of the uchiwa is "[italic type]uchiwa[roman type]". The uchiwa is sell-able. The minimum value of the uchiwa is 6500 yen. The desired value of the uchiwa is 9500 yen. The description of the uchiwa is "A large rigid fan decorated with a summer-themed [italic type]yamato-e[roman type]. It even had a silver moon."

Understand "yamato-e", "silver/moon" and "silver moon" as the uchiwa. 

[The player carries a pocket watch. The pocket watch is sell-able. The minimum value of the pocket watch is 5000 yen. The desired value of the pocket watch is 15000 yen. The description of the pocket watch is "An ancient automatic lady's watch."]

The player carries a knife called a kaiken. The printed name of the kaiken is "[italic type]kaiken[roman type]". The kaiken is sell-able. The minimum value of the kaiken is 7000 yen. The desired value of the kaiken is 10500 yen. The description of the kaiken is "A dagger, mainly to pierce ones cartoid artery in a desperate situation. This particular one was a family heirloom from the [italic type]taisho[roman type]-period, when such accessories were [italic type]en vouge[roman type]."
Understand "sheath/saya/scabbard/hilt/blade/dagger" as the kaiken.

After taking inventory, say "I had [the wealth of the player] in cash."

Part 5 - Areas and Rooms

Chapter 1 - Rooms

A room has a text called the walltext. The walltext is usually "".
A room has a text called the ceilingtext. The ceilingtext is usually "".
A room has a text called the floortext. The floortext is usually "".
A room can be detailed. A room is usually not detailed. 
A room can be undressing. A room is usually not undressing.
A room can be stashing. A room is usually not stashing.

to say walldetail for (X - a room):
	say "[walltext of X]".
	
to say floordetail for (X - a room):
	say "[floortext of X]".
	
to say ceilingdetail for (X - a room):
	say "[ceilingtext of X]".
	
A shop is a kind of room.
A storageroom is a kind of room.
A canal is a kind of room.
A pier is a kind of room.
A sewer is kind of room. A sewer is usually dark.
A sewerpier is a kind of room. A sewerpier is usually dark.

A room can be wet. A room is usually not wet.
A sewerpier is always wet.
A sewer is always wet.
A pier is always wet.
A canal is always wet.

The scent of a sewer is usually "[one of]As one would expect, the sewers smelled disgusting.[or]The stench of the sewers was nauseating.[or]The grim smell of excrement.[at random]".
The sound of a sewer is usually "[one of]An eerie silence filled the sewers.[or]There was a dripping noise from somewhere.[or]I heard a faint recurring scratching noise.[or]A leaden silence filled the tunnels.[at random]".
The scent of a sewerpier is usually "[one of]As one would expect, the sewers smelled disgusting.[or]The stench of the sewers was nauseating.[or]The grim smell of excrement.[at random]".
The sound of a sewerpier is usually "[one of]An eerie silence filled the sewers.[or]There was a dripping noise from somewhere.[or]I heard a faint recurring scratching noise.[or]A leaden silence filled the tunnels.[at random]".

Before taking off clothing when the location is not undressing and the player is not contained by a container and the player is not supported by a supporter:
	say "Here? surely not." instead.

Before taking off clothing when the location is not undressing and the container that contains the player is not undressing:
	say "Here? surely not." instead.

Before taking off clothing when the location is not undressing and the supporter that supports the player is not undressing:
	say "Here? surely not." instead.

Before taking off a sash when the location is not undressing and the player is not contained by a container and the player is not supported by a supporter:
	say "Here? surely not." instead.

Before taking off a sash when the location is not undressing and the container that contains the player is not undressing:
	say "Here? surely not." instead.

Before taking off a sash when the location is not undressing and the supporter that supports the player is not undressing:
	say "Here? surely not." instead.

Before taking off footwear when the location is not undressing and the player is not contained by a container and the player is not supported by a supporter:
	say "I'd rather not have done that in such a location." instead.
	
Before taking off footwear when the location is not undressing and the container that contains the player is not undressing:
	say "I'd rather not have done that in such a location." instead.
	
Before taking off footwear when the location is not undressing and the supporter that supports the player is not undressing:
	say "I'd rather not have done that in such a location." instead.
	
Before dropping something that is not a bucket when the location is not stashing and the player is not contained by a container and the player is not supported by a supporter:
	say "'Better hold onto [if the noun is plural-named]these[else]it[end if].' I thought to myself. 'If I leave [the noun] in this location, I won't ever see [if the noun is plural-named]them[else]it[end if] again.'" instead.

Before dropping something that is not a bucket when the location is not stashing and the container that contains the player is not stashing:
	say "'Better hold onto [if the noun is plural-named]these[else]it[end if].' I thought to myself. 'If I leave [the noun] in this location, I won't ever see [if the noun is plural-named]them[else]it[end if] again.'" instead.

Before dropping something that is not a bucket when the location is not stashing and the supporter that supports the player is not stashing:
	say "'Better hold onto [if the noun is plural-named]these[else]it[end if].' I thought to myself. 'If I leave [the noun] in this location, I won't ever see [if the noun is plural-named]them[else]it[end if] again.'" instead.	

Before putting something that is not a bucket on a supporter that is not stashing:
	say "'Better hold onto [if the noun is plural-named]these[else]it[end if].' I thought to myself. 'If I leave [the noun] in this location, I won't ever see [if the noun is plural-named]them[else]it[end if] again.'" instead.

Before inserting something that is not a bucket into a supporter that is not stashing:
	say "'Better hold onto [if the noun is plural-named]these[else]it[end if].' I thought to myself. 'If I leave [the noun] in this location, I won't ever see [if the noun is plural-named]them[else]it[end if] again.'" instead.
	

Chapter 2 - Areas

Section 1 - Area properties

An area is a kind of region.

A stratum is a kind of value. The plural of stratum is strata. The strata are upper class, lower class and deserted.
Association relates a stratum to various areas. The verb to be associated with implies the association relation.

Section 2 - The different areas

The station is an area. Lower class is associated with the station.
L-1_station_subway, L0_station_main, L1_station_gates and L2_station_platform are in the station.

The mall is an area. Upper class is associated with the mall.
L0_mall_hub is in the mall.

The streets are an area. Lower class is associated with the streets.
L0_streets_hub_1, L0_streets_hub_3, L0_streets_hub_4, L0_streets_hub_6, and L1_streets_hub_7 are in the streets.

The channels are an area. Deserted is associated with the channels.
L-1_canal_pier_1, L-1_canal_bridge, L-1_canal_pier_2 and L-1_canal_lock are in the channels.

The warrens are an area. Deserted is associated with the warrens.
L-1_sewer_junction_1, L-1_sewer_junction_2, L-1_sewer_junction_3, L-1_sewer_junction_4, L-1_sewer_junction_5, L-1_sewer_junction_6, L-1_sewer_deadend_1, L-1_sewerpier_1 and L-1_sewer_deadend_2 are in the warrens.

The service is an area. Deserted is associated with the service.
All shops are in the service. All storagerooms are in the service.

Part 6 - Backdrops

Chapter 1 - Walls

The walls are plural-named backdrop. The Description of the walls is "[if the location is detailed][walldetail for the location][else if in the station]Ugly, stained tiles.[else if in the mall]Dry dry walls.[else if in the streets]Dirty concrete covered in graffiti.[else if in the channels]Concrete walls rose several meters above the water level.[else if in the warrens]Moldy concrete.[else if in the service]Painted white and rather utilitarian.[Else]The walls."

The walls are everywhere.

Understand "wall" as the walls.
Understand "tiles" as the walls when the location is in the service or in the station.
Understand "concrete" as the walls when the location is in the streets or in the channels or in the warrens.

Chapter 2 - Floor

The floor is backdrop. The description of the floor is "[if the location is detailed][floordetail for the location][else if in the station]Large stone tiles.[else if in the mall]Continuous carpeting.[else if in the streets]Cracked asphalt.[else if in the channels]None was visible beneath the water.[else if in the warrens]None was visible beneath the sewage.[else if in the service]The usual tiles.[else]The floor."

The floor is everywhere.

Understand "tiles" as the floor when the location is in the service or in the station. 
Understand "carpet" as the floor when the location is in the mall.
Understand "ground/asphalt/street/streets/asphalt" as the floor when the location is in the streets or the location is L0_transport_yard.

Chapter 3 - Ceiling

The ceiling is backdrop. The ceiling is distant. The description of the ceiling is "[if the location is detailed][ceilingdetail for the location][else if in the station]Concrete paneling.[else if in the mall]Lightweight paneling.[else if in the streets or in L0_transport_yard]The sky was the colour of television, tuned to a dead channel.[else if in the channels]The sky was the colour of television, tuned to a dead channel.[else if in the warrens]The ceiling was barely visible beyond several layers of piping and cables.[else if in the service]Painted white.[else]The ceiling."

The ceiling is everywhere. 

Understand "paneling" as the ceiling when the location is in the station or in the mall.
Understand "concrete/pipe/pipes/piping/cable/cables" as the ceiling when the location is in the warrens. 

Chapter 4 - Sky

The sky is backdrop. The sky is distant. The description of the sky is "The starry night sky stretched from one end of the bay to the other, low-hanging grey clouds moving across it at speed."
	
The sky is in the streets and the channels.

Understand "cloud/clouds" as the sky.

Chapter 5 - Buildings

The buildings are plural-named backdrop. The description of the buildings is "[if the location is in the streets]Crammed between the giant glass facades of the high-rises was a mingle-mangle of smaller structures, many of which adorned with giant billboards higher than the buildings themselves.[else if the location is in the channels]Almost all the buildings on either side of the canal had makeshift extensions of scaffolding and corrugated sheet metal that clung to the walls like wasps' nests. This was obviously illegal and dangerous, but the rent that could be collected from the ever-increasing population of the docklands seemed to justify even the most outrageous construction project.[else if the Location is L0_transport_yard]Dirty Brick walls with blind windows."

The buildings are in the streets, in the channels, in L0_streets_hub_2  and in L0_transport_yard.

Understand "building/high-rise/high-rises/skyscraper/skyscrapers/construction/constructions/extension/extensions/structure/structures/facade/facades" as the buildings when the location is in the streets or in the channels or the location is L0_transport_yard.

Understand "mouth/gaping", "huge gaping mouth" and "gaping mouth" as the buildings when the location is  L0_streets_hub_4.

Chapter 6 - Graffiti

The graffiti is backdrop. The description of the graffiti is "Right next to me [one of]an unreadable name tag[or]a giant acronym for something or someone I didn't know[or]some unspeakable obscenity[or]a political message that didn't seem at all recent or even recognizable[or]a rather funny caricature of a rabbit devouring a policeman[or]a mural so old it was faded beyond recognition[at random] was painted on the wall."

The graffiti is in the streets and in L0_streets_hub_2.

Understand "mural/murals" as the graffiti when in the streets. 

Chapter 7 - Advertising

The advertising is backdrop. The description of the advertising is "[one of]'Ono-sendai electronics' said a giant billboard.[or]The sentence 'Visit Soapland massage parlour' rolled endlessly over a display panel.[or]'High standard' was the name of an escort service advertised by a poster taking up all of a buildings facade.[or]'Tachibana General Laboratories' said one advert.[or]One of the billboards was promoting the 'Shimazu-Dominguez corporation'.[or]'Tesshier-Ashpool corporation' said one advert.[or]'Theme Date Love Hotel - cheapest rates guaranteed' was flashing aggressively of a giant display panel.[or]Some 'Pedophilia maid café' was soliciting customers.[or]'More human than human' was the slogan of the 'Tyrell Corporation'.[or]A lolicon bar was promoting its staff as 'tantalisingly young'.[or]'www.schoolgirladultery.jp' had rented a particularly large bilbard.[at random]".

The advertising is in the streets.

Understand "billboard/billboards/ad/ads/advert/adverts/display/displays/panel/panels/poster/posters" and "display panel/panels" as the advertising when the location is in the streets.

Chapter 8 - Crowd

The crowd is backdrop. The description of the crowd is "[if the location is L-1_station_subway]Many tired people were queuing to catch a train.[else if the location is in the streets]A sad procession of low-lives that moved slowly through the filthy streets.[else if the location is in the station]People from all walks of life were traversing the corridors of the station hastily in every direction, trying to constrain their stay to the shortest possible duration.[else if the location is in the mall]Some obviously affluent customers strolled through the shops of the mall, stopping here and there to inspect the merchandise."

The crowd is in the station, the mall, L0_streets_hub_1, L0_streets_hub_3, L0_streets_hub_4, L0_streets_hub_6 and L1_streets_hub_7.

Understand "crowds/people/traffic/activity/life/pedestrians/pedestrian" as the crowd when the location is in the streets or in the station or in the mall.
Understand "poor/folk/poor-folk/battered/low-lives/low-life/homeless/traffic/pedestrians/pedestrian" and "battered poor-folk" as the crowd when the location is in the streets.

Chapter 9 - Railway viaduct

The railway viaduct is backdrop. The railway viaduct is distant. The description of the railway viaduct is "The Odakyû railway viaduct was a towering monument of once-red brick, now covered in graffiti. [if the location is L1_streets_hub_7]From up here I had a nice view of the cardboard shacks under the arcs of the viaduct.[else]Hundreds of little shops and dwellings in various states of decay had been build underneath its tall arcs."
The railway viaduct is in L0_streets_hub_3, L0_streets_hub_4 and L1_streets_hub_7.

Understand "rail/line/arc/arcs/brick/bricks/track/tracks" and "rail/railway line" as the railway viaduct when the location is L0_streets_hub_3 or the location is L0_streets_hub_4 or the location is L1_streets_hub_7.  

Chapter 10 - Rail bridge

The rail bridge is backdrop. The rail bridge is distant. The description of the rail bridge is "A positively ancient construction of riveted iron. Underneath the railroad bed ran a foot lane, which was always congested beyond hope."

The rail bridge is in L0_streets_hub_3, L0_streets_hub_6 and L-1_canal_bridge.

Understand "foot/railroad/railway/rail/pedestrian bridge/lane", "walkway", "foot lane" and "pedestrian walkway" as the rail bridge when the location is L0_streets_hub_3 or the location is L0_streets_hub_6 or the location is L-1_canal_bridge.

Chapter 11 - Bay

The bay is backdrop. The bay is distant. The description of the bay is "Dark and silent lay the bay."

The bay is in L0_streets_hub_3, L0_streets_hub_6 and L-1_canal_bridge.

The scent of the bay is "The waters were so polluted near the shore, their smell is better left undescribed."

Understand "sea/ocean/waterfront/light/lights" as the bay when the location is L0_streets_hub_3 or the location is L0_streets_hub_6 or the location is L-1_canal_bridge.

Chapter 12 - Water

The water is backdrop. The description of the water is "The murky waters had a rather discomforting colouring of light grey in the daytime. Now, however, they were pitch black. The smell emanating from this sewage was made all the more unpleasant by the intense heat."

The water is in L0_streets_hub_3, L0_streets_hub_6, the warrens and the channels. 

The scent of the water is "The foul, sweet smell of an overtaxed sewer system."

Understand "canal/canals/waters/contents/revolting/sewage" as the water when the map region of the location is the channels or in the warrens or the location is L0_streets_hub_3 or the location is L0_streets_hub_6.

Chapter 13 - Quay

The quay is backdrop. The Description of the quay is "This steep wall to fasten boats and ships to descended right down into the waters of the canal."

The quay is in L0_streets_hub_3, L0_streets_hub_6 and L-1_canal_pier_1.

Chapter 14 - Fishing boats

The fishing boats are plural-named backdrop. The Description of the fishing boats is "These rundown fishing boats were a sorry sight indeed."

The fishing boats are in L0_streets_hub_6 and L-1_canal_pier_1.

The scent of the fishing boats is "Fishy."

Understand "mast/masts/net/nets/flotilla/boat" as the fishing boats when the location is L0_streets_hub_6 or the location is L-1_canal_pier_1.

Chapter 15 - Shops

The _shops are backdrop. The _shops are plural-named. The _shops are privately-named. The printed name is "shops". The description of _shops is "[if the location is L0_streets_hub_4]Dozens of small cardboard shacks that housed the homeless were cramped in with the shops between the pillars of the viaduct. Among them was a particularly decrepit one - advertising for itself with a flickering neon sign that said 'Tanaka used goods'.[else]Dozens of small cardboard shacks housing the homeless were cramped in between the pillars of the railway viaduct."
The _shops are in L0_streets_hub_3, L0_streets_hub_4 and L1_streets_hub_7.
Understand "shops/shacks/shack/booth/booths/shed/sheds/dwelling/dwellings" as the _shops when the location is L0_streets_hub_3 or the location is L0_streets_hub_4.
Instead of entering the _shops when the location is L0_streets_hub_4:
	say "Which one exactly? There were so many."


Chapter 16 - Walkway

The walkway is backdrop. The description is "The walkway connected the high-rise buildings around the station."
The walkway is in L1_streets_hub_7.
Understand "pedestrian/elevated walkway", "elevated platform" and "platform" as the walkway when the location is L1_streets_hub_7.

Chapter 17 - Columns

The columns are plural-named backdrop. The description is "Silently but menacing, the fantastic statues held the tunnel ceiling."
The columns are in the warrens.
Understand "column/statue/statues/guardian/guardians" and "stone column/statue/statues/guardian/guardians" as the columns when the location is in the warrens.

Chapter 18 - Tunnels

The tunnel is backdrop. The description is "A sewer tunnel, the darkness covering all its secrets."
The tunnel is in the warrens. Understand "tunnels" as the tunnel when the location is in the warrens.

Chapter 19 - Conveyor belt

The conveyor belt is backdrop. The description is "It wasn't much, but it did its job." The conveyor belt is in L0_fish_packing and L0_fish_tinning.

Chapter 20 - Tins

The tins are plural-named backdrop. The description is "'Sardines in olive oil' said the label in Vietnamese." The tins are in L0_fish_packing and L0_fish_tinning.
Understand "tin can/cans" and "can/cans" as the tins when the location is L0_fish_packing or the location is L0_fish_tinning.

Chapter 21 - The Gallery

The gallery is backdrop. The description is "A tall bamboo construction that ran around the whole hall, allowing access to several rooms." The gallery is in L-1_bordello_bar and L1_bordello_gallery.

Understand "bamboo" as the gallery when the location is L-1_bordello_bar.


Part 7 - Stairs, tollgates, windows and doors

Chapter 1 - Stair, tollgate and door properties

Section 1 - Staircases

A staircase is a kind of door. A staircase is usually scenery. A staircase is usually open. A staircase is seldom openable.

Section 2 - Tollgates

Tollgates are a kind of staircase. Tollgates are openable and lockable. The description of tollgates is usually "These barriers were of the type that couldn't be bypassed or jumped over. To get through, one had to insert a ticket into the slot."

Section 3 - Windows

A window is a kind of door. A window is usually scenery.
Understand "look out [a window]","look out of [a window]" and "look through [a window]" as examining.

Climbing through is an action applying to one thing. Understand "climb through [something]", "climb in 
[something]", "climb out [something]", "climb out of [something]", "jump out of [something]" as climbing through.
Check climbing through:
	if the noun is not a window, say "I couldn't climb through [a noun]!" instead.
Carry out climbing through:
	try entering the noun instead.


Chapter 2 - The different staircases,tollgates and doors

Section 1 - subway_gates

The subway_gates are privately-named tollgates. The subway_gates are plural-named. The printed name is "toll gates". The Description is "[if the location is L-1_station_subway]The stairs led up.[else]These barriers were of the type that couldn't be bypassed or jumped over. To get through, one had to insert a ticket into the slot.".

The subway_gates are above L-1_station_subway and below L0_station_main.

Understand "stairs/stair/staircase/steps" as subway_gates when the location is L-1_station_subway.
Understand "barrier/barriers/gate/gates/toll" and "toll gates" as subway_gates when the location is L0_station_main.

Section 2 - platform_gates

The platform_gates are privately-named tollgates. The platform_gates are plural-named. The printed name is "toll gates". The Description is "[if the location is L2_station_platform]The stairs led down.[else]These barriers were of the type that couldn't be bypassed or jumped over. To get through, one had to insert a ticket into the slot.". 

The platform_gates are above L1_station_gates and below L2_station_platform.
The platform_gates are closed and locked.

Understand "stairs/stair/staircase/steps" as platform_gates when the location is L2_station_platform.
Understand "barrier/barriers/gate/gates/toll" and "toll gates" as platform_gates when the location is L1_station_gates.

Section 3 - huge stairs

The huge stairs are a plural-named staircase. The description of the huge stairs is "People rushed up and down the main staircase of the station in an infinite stream."

The huge stairs are above L0_station_main and below L1_station_gates.

Understand "staircase" and "gigantomanian staircase/stairs" as the huge stairs when the location is L0_station_main or the location is L1_station_gates.

Section 4 - rusty rungs

The rusty rungs are a plural-named staircase. The description of the rusty rungs is "This sure was a practical and sturdy ladder."

The rusty rungs are below L0_streets_hub_6 and above L-1_canal_pier_1.

Understand "ladder" and "rusty ladder" as the rusty rungs when the location is L-1_canal_pier_1 or the location is L0_streets_hub_6.

Section 5 - backalley_stairway

The backalley_stairway is a privately-named staircase. The printed name of the backalley_stairway is "stairway". 
The description of the backalley_stairway is "A simple concrete stairway with a metal railing."
The backalley_stairway is above L0_streets_hub_2 and below L1_streets_hub_7.

Understand "stair/stairs/staircase/stairway/step/steps/rail/railing" as the backalley_stairway when the location is L1_streets_hub_7 or the location is L0_streets_hub_2.

Section 6 - The sewer lock

The sewer lock is a lockable door and scenery. The description of the sewer lock is "The lock consisted of a very large, very rusty double gate. The gate was currently [if the sewer lock is open]open.[else]closed."
The sewer lock is north of L-1_canal_lock and south of L-1_sewer_junction_1.

Understand "gate/gates" as the sewer lock when the location is L-1_canal_lock or the location is L-1_sewer_junction_1.

The sewer lock is closed and locked.

Section 7 - The metal gate

The metal gate is a door and scenery. The description of the metal gate is "I'd say this gate was between two and three meters high. The top was adorned with sharp spikes.[if the location is L0_streets_hub_1]'Yano & Chou Import-Export' was painted on the gate[end if]."

The metal gate is north of L0_streets_hub_1 and south of L0_transport_yard.
Understand "gate/gates", "spike/spikes/sharp", "sharp spike/spikes" and "steel gate/gates" as the metal gate when the location is L0_streets_hub_1 or the location is L0_transport_yard.

The metal gate is closed and locked.

Section 8 - The Office door

The office door is a door and scenery. The description of the office door is "[if the location is L0_transport_yard]A rusty metal door, the word 'Office' crudely stenciled onto[else if the location is L0_transport_office]A rusty metal door[end if]."

The office door is east of L0_transport_yard and west of L0_transport_office.

Section 9 - The club stairs

The club stairs are a plural-named staircase and scenery. The club stairs are closed. The club stairs are not openable. The description of the club stairs is "These stairs connected the entrails of the dance club with the rest of the world."

The club stairs are below L0_danceclub_frontdesk and above L-1_danceclub_dancefloor.
Understand "neon light/lights/lighting" and "neon/stair/staircase/steps/step" as the club stairs when the location is L0_danceclub_frontdesk or the location is L-1_danceclub_dancefloor.

Section 10 - The sewer door

The sewer door is a door and scenery. The description of the sewer door is "A rusty metal door."
The sewer door is north of L-1_sewerpier_1 and south of L-1_blackmarket.

Section 11 - The passageway

The passageway is a door and scenery. The description of the passageway is "A heavy leather curtain to keep out the draft and any prying eyes covered the passageway." The printed name of the passageway is "leather curtain".
The passageway can be clear. The passageway is not clear.
The passageway is east of L-1_bordello_reception and west of L-1_bordello_bar.

Understand "curtain/leather/passage/entrance" as the passageway when the location is L-1_bordello_reception or the location is L-1_bordello_bar.

Report opening the passageway:
	say "I pushed aside the leather curtain."

After exiting from the passageway:
	now the passageway is closed;
	continue the action.

Section 12 - The factory door

The factory door is a door and scenery. The description of the factory door is "A standard metal door."
The factory door is east of L0_fish_packing and west of L0_fish_tinning.

The factory door is closed.

Section 13 - The praxis door

The praxis door is a door and scenery. The description of the praxis door is "A white door."
The praxis door is west of L1_clinic_reception and east of L1_clinic_treatment.
The praxis door is lockable. The praxis door is not locked.
The praxis door is closed.

Section 14 - The spiral stairs

Some spiral stairs are a staircase. The description of the spiral stairs is "Like the gallery, this open staircase was made of bamboo." The spiral stairs are above L-1_bordello_bar and below L0_bordello_gallery. 

Section 15 - The loo window

The loo window is a window. The loo window is closed. The description of the loo window is "This window consisted of a small frosted glass pane in a plastic frame[if the loo window is closed], currently canted ajar[end if]. Someone had criss-crossed it over with a roll of barbed wire." The loo window is west of L0_streets_hub_2 and east of L0_bordello_loo.
Some barbed wire is part of the loo window. The barbed wire can be cut or uncut. The barbed wire is uncut.
Understand "wires" as the barbed wire.

Instead of opening the loo window when the barbed wire is uncut:
	say "The barbed wire prevented that very effectively."
	
Instead of cutting the barbed wire with a cutter when the Location is L0_bordello_loo:
	say "I couldn't reach the wire from the inside."

Understand "windows" as the loo window when the location is L0_streets_hub_2.

Instead of doing anything with the loo window when the location is L0_streets_hub_2 and the player is not on the fire escape ladder:
	say "The window was too high up for me to even take a proper look at it."

Instead of doing anything with the barbed wire when the location is L0_streets_hub_2 and the player is not on the fire escape ladder:
	say "The window was too high up for me to even take a proper look at it."
	
[Instead of entering the loo window when the location is L0_streets_hub_2 and the player is not on the fire escape ladder:
	say "How should I have accomplished that?"

Instead of going west in L0_streets_hub_2:
	try entering the loo window instead.]

Part 8 - Scenery

A counter is a kind of supporter. A counter is usually scenery.

Understand "counter" as a counter.

A platform is a kind of thing. A platform is usually scenery.

Tracks are a kind of thing. Tracks are scenery. Tracks are plural-named. Tracks are usually distant.

Instead of taking scenery, say "I couldn't lug that around with me."
Instead of pulling or pushing scenery, say "A rather futile exercise."

Part 9 - Passers-bye

Chapter 1 - The Every-turn rule for passer-byes

Every turn when the stratum that is associated with the area that is the map region of the location is not deserted and a random chance of 1 in 5 succeeds: 
	if the stratum that is associated with the area that is the map region of the location is upper class:
		if a random chance of 1 in 2 succeeds:
			reset upper Female;
			choose a random row in the Table of Female Upper Class Encounters; 	
		else:
			reset upper Male;		
			choose a random row in the Table of Male Upper Class Encounters; 
	else:
		if a random chance of 1 in 2 succeeds:
			reset lower Female;
			choose a random row in the Table of Female Lower Class Encounters; 
		else:
			reset lower Male;
			choose a random row in the Table of Male Lower Class Encounters; 
	say "[event entry][paragraph break]".	
		
Chapter 2 - The tables of Encounters

Table of Female Upper Class Encounters 
event 
"[A _woman] stopped to inspect her [one of]black[or]red[or]yellow[at random] leather gloves."
"[The _woman] beside me waved to someone else."
"[A _woman] left one of the shops with some large paper bags."

Table of Male Upper Class Encounters 
event 
"Some [_man] turned around on the spot, probably remembering something." 
"[A _man] politely made way for me." 
"[The _man] a few meters away was absent-mindedly looking at his watch." 

Table of Female Lower Class Encounters 
event 
"[A _woman] dropped her purse, and hurriedly retrieved it."
"[The _woman] beside me seemed amused by something." 
"Some [_woman] stopped in her tracks, holding up a few others."
"[A _woman] hurried past me, obviously suffering from withdrawal syndromes."
"Right in front of me, [a _woman] careened into the wall, seemingly drunk."
"[The _woman] walking towards me seemed like she had not had any sleep for a few nights."

Table of Male Lower Class Encounters 
event 
"Slowly [a _man] strolled by, turning to look at me as he passed." 
"[A _man] nearly bumped into me, not bothering to apologise."
"[A _man] tried to make his way quickly through the crowd."
"[A _man] slouched past me, his stomach growling audibly."
"[The _man] a few paces in front of me was swearing violently at someone else." 
"Right next to me [a _man]'s legs gave in, but he got up again."

Chapter 2 - The Description of the passer-byes

Height is a kind of value. The _man has Height. The heights are tall and short.
Complexion is a kind of value. The plural of complexion is complexions. The _man has complexion. The complexions are tanned, sunburned and pale.  
Ethnicity is a kind of value. The _woman has ethnicity. The ethnicities are far-eastern, Caucasian, Filipino and Korean.
Age is a kind of value. The plural of age is ages. The _woman has age. The ages are young and once-young.

Understand the height property as describing the _man when the stratum that is associated with the area that is the map region of the location is not deserted.
Understand the complexion property as describing the _man when the stratum that is associated with the area that is the map region of the location is not deserted.
Understand the ethnicity property as describing the _woman when the stratum that is associated with the area that is the map region of the location is not deserted.
Understand the age property as describing the _woman when the stratum that is associated with the area that is the map region of the location is not deserted.

Chapter 3 - To reset phrases

To reset upper Female:
	now the ethnicity of the _woman is a random ethnicity;
	now the age of the _woman is a random age;
	choose a random row in the Table of Upper Class Women; 
	now the nickname of the _woman is "[name entry]";
	now the _woman is not doped;
	now the _woman is in the location.

To reset upper Male:
	now the height of the _man is a random height; 
	now the complexion of the _man is a random complexion;
	choose a random row in the Table of Upper Class Men; 
	now the nickname of the _man is "[name entry]";
	now the _man is not doped;
	now the _man is in the location.
	
To reset lower Female:
	now the ethnicity of the _woman is a random ethnicity;
	now the age of the _woman is a random age;
	choose a random row in the Table of Lower Class Women; 
	now the nickname of the _woman is "[name entry]";
	now the _woman is not doped;
	now the _woman is in the location.

To reset lower Male:
	now the height of the _man is a random height; 
	now the complexion of the _man is a random complexion;
	choose a random row in the Table of Lower Class Men; 
	now the nickname of the _man is "[name entry]";
	now the _man is not doped;
	now the _man is in the location.
	
Chapter 5 - Table of men and women

Table of Upper Class Men
name
"man"
"gentleman"
"jock"

Table of Upper Class Women
name
"woman"
"girl"
"lady"

Table of Lower Class Women
name
"woman"
"girl"
"chick"

Table of Lower Class Men
name
"man"
"poor slob"
"guy"

Chapter 6 - _man and _woman
  
The _man is a man. The _man is privately-named. The _man is undescribed. The printed name of _man is "man".
The _man has some indexed text called nickname.
The _man can be doped. The _man is not doped.
The _man can be worked. The _man is worked.
The _man can be clothed. The _man is clothed.
The _man can be sewered. The _man is sewered.

Rule for printing the name of _man:
	if a random chance of 1 in 3 succeeds:
		say "[height] ";
	if a random chance of 1 in 3 succeeds:
		say "[complexion] ";
	say "[nickname]".
	 
Understand "man/boy/gentleman/jock" as the _man when the stratum that is associated with the area that is the map region of the location is upper class.
Understand "man/boy/poor/slob/shadow/guy/salary", "salary man" and "poor slob" as the _man when the stratum that is associated with the area that is the map region of the location is lower class.

The _woman is a woman. The _woman is privately-named. The _woman is undescribed. The printed name of _woman is "woman".
The _woman has some indexed text called nickname.
The _woman can be doped. The _woman is not doped.
The _woman  can be worked. The _woman  is worked.
The _woman  can be clothed. The _woman  is clothed.
The _woman  can be sewered. The _woman  is sewered.

Rule for printing the name of _woman:
	if a random chance of 1 in 3 succeeds:
		say "[age] ";
	if a random chance of 1 in 3 succeeds:
		say "[ethnicity] ";
	say "[nickname]".
	
Understand "woman/girl/lady/courtesan"  as the _woman when the stratum that is associated with the area that is the map region of the location is upper class.
Understand "woman/girl/chick" as the _woman when the stratum that is associated with the area that is the map region of the location is lower class.

Chapter 4 - The Conversations

The litany of the _man is the Table of Male Conversation.

The greeting of the _man is Male_greeting

Table of Quip Texts (continued)
quip		quiptext
Male_greeting	"[if the stratum that is associated with the area that is the map region of the location is upper class]'Yes, what can I do for you?'[else][The _man] stopped and gave me a skeptical look.[end if]"
Male_what_time	"[if the stratum that is associated with the area that is the map region of the location is upper class]'I wish I had a watch on me, sorry.'[else][One of]'Sorry, haven't got a clue.'[or]'Don't you have a phone on you?'[at random][end if]"
Male_deal	"[one of]'I don't know what you're talking about.'[or]'But only if it's good quality stuff.'[or]'Show me what you've got.'[or]'I might be.'[or]'Maybe'[at random]"
Male_accept	"He handed me the money, I gave him a pill."	
Male_reject	"He made off with empty hands."
Male_work	"[one of]'No Idea.'[or]'Sorry, can't help you there.'[or]'I'd be glad to know that myself.'[or]'There's a fish factory in the docklands, you could try your luck there.'[or]'Work I don't know, but you could sell some of your stuff to raise money.'[at random]"
Male_clothes	"[one of]'No Idea.'[or]'Sorry, can't help you there.'[or]'I don't know, sorry.'[or]'I'm sure you'll find what you're looking for in the Arisaka mall.'[or]'If you don't need anything fancy, there is always the floating market in the canal. You'll need a boat to get there, of course.'[at random]"
Male_sewers	"[one of]'No Idea.'[or]'I don't know, sorry.'[or]'Shhht! Not so loud! it's hidden in the sewers.' whispered the [_man].[at random]"

Table of Male Conversation
prompt					response	enabled
"'Could you tell me the time please?'"	Male_what_time	1
"'[one of]Would you like to buy something substantial?[or]Are you interested in some acceleration?[or]We are looking for volunteers in a nanotech experiment.[at random]'"	Male_deal	0
"'Alright, [ask value * 500] for [one of]this utter craziness.[or]death by a thousand cuts.[or]your metamorphosis into grey goo.[or]a short dream of a better life.[at random]'"	Male_accept	0 
"[one of]'What? I take more than that to the [italic type]combini[roman type] on a weekday afternoon.'[or]'Pathetic. You couldn't even get Heroin for that kind of change.'[or]'This is a joke, right?'[or]'If I was with the Macao Triads, you wouldn't survive this respect-less offer.'[at random]"	Male_reject	0
"'You wouldn't know where I could find work around here by any chance?'"	Male_work	0
"'Could you tell me where I can find a shop to buy clothes around here?'"	Male_clothes	0
"'I'm looking for a place called 'the burrow'. Do you know where to find it?'"	Male_sewers	0

Before quipping when the current quip is Male_greeting:
	if the player carries at least one dose and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Male_deal quip for _man;
	if the _man is not worked and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Male_work quip for _man;
	if the _man is not clothed and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Male_clothes quip for _man;
	if the _man is not sewered and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Male_sewers quip for _man;
	say "I said [italic type]'sumimasen'[roman type] to the passer-by.[paragraph break]".

After quipping when the current quip is Male_what_time:
	say "I said 'That's too bad. Thank you very much anyway.'";
	enable the Male_what_time quip;
	terminate the conversation.

After quipping when the current quip is Male_deal:
	disable the Male_what_time quip;
	disable the Male_work quip;
	disable the Male_clothes quip;
	disable the Male_sewers quip;
	say "I showed him the merchandise.[paragraph break]";
	if the _man is doped:
		say "'But you just sold me one of those!'";
		enable the Male_what_time quip;
		terminate the conversation;
	else if a random chance of 2 in 5 succeeds:
		if the police patrol is in the location:
			deactivate the police patrol;
		now the ask value is a random price from 8 yen to 12 yen;
		say "'I'd give you [ask value * 500] for [one of]such a pill[or]one of those little babies[or]one pop[at random].'";
		enable the Male_accept quip;
		enable the Male_reject quip;
	else:
		say "[One of]'Accella? Do you want to poison me?'[or]'No, I'm not interested.'[or]'Sorry, but I'm too young to die.'[or]'I'd like to, but I'm totally broke.'[or]'If only I had the money for that!'[at random]";
		enable the Male_what_time quip;
		terminate the conversation.

After quipping when the current quip is Male_accept:
	disable the Male_reject quip;
	increase the wealth of the player by (ask value * 500);
	increase the wealth of the quick fox by (ask value * 500);
	move a random dose carried by the player to _man;
	now the _man is doped;
	enable the Male_what_time quip;
	terminate the conversation;
	if the police patrol is in the location:
		now the player is arrested.

After quipping when the current quip is Male_reject:
	disable the Male_accept quip;
	enable the Male_what_time quip;
	terminate the conversation.
	
After quipping when the current quip is Male_work:
	enable the Male_what_time quip;
	terminate the conversation.

After quipping when the current quip is Male_clothes:
	enable the Male_what_time quip;
	terminate the conversation.
	
After quipping when the current quip is Male_sewers:
	enable the Male_what_time quip;
	terminate the conversation.

The litany of the _woman is the Table of Female Conversation.

The greeting of the _woman is Female_greeting

Table of Quip Texts (continued)
quip			quiptext
Female_greeting		"[if the stratum that is associated with the area that is the map region of the location is upper class]'Yes?'[else][one of]The woman gave me a nasty look.[or]'Do I know you, girl?'[at random][end if]"
Female_what_time	"[if the stratum that is associated with the area that is the map region of the location is upper class]'I'm sorry I don't know either'[else][one of]'No, sorry, I haven't got a phone on me.' the woman lied.[or]'How would I know?'[at random][end if]"
Female_deal	"[one of]'I don't know what you're talking about.'[or]'But only if it's good quality stuff.'[or]'Show me what you've got.'[or]'I might be.'[or]'Maybe'[at random]"
Female_accept	"She handed me the money, I gave her a pill."	
Female_reject	"She made off with empty hands."
Female_work	"[one of]'No Idea.'[or]'Sorry, can't help you there.'[or]'I'd be glad to know that myself.'[or]'There's a courier service on the walkway near the station, you could try your luck there.'[or]'Work I don't know, but you could sell some of your stuff to raise money.'[at random]"
Female_clothes	"[one of]'No Idea.'[or]'Sorry, can't help you there.'[or]'I don't know, sorry.'[or]'I'm sure you'll find what you're looking for in the Arisaka mall.'[or]'If you don't need anything fancy, there is always the floating market in the canal. You'll need a boat to get there, of course.'[at random]"
Female_sewers	"[one of]'No Idea.'[or]'I don't know, sorry.'[or]'Shhht! Not so loud! it's hidden in the sewers.' whispered the [_woman].[at random]"


Table of Female Conversation
prompt					response		enabled
"'Could you tell me the time please?'"	Female_what_time	1
"'[one of]Would you like to buy something substantial?[or]Are you interested in some acceleration?[or]We are looking for volunteers in a nanotech experiment.[at random]'"	Female_deal	0
"'Alright, [ask value * 500] for [one of]this utter craziness.[or]death by a thousand cuts.[or]your metamorphosis into grey goo.[or]a short dream of a better life.[at random]'"	Female_accept	0
"[one of]'What? I take more than that to the [italic type]combini[roman type] on a weekday afternoon.'[or]'Pathetic. You couldn't even get Heroin for that kind of change.'[or]'This is a joke, right?'[or]'If I was with the Macao Triads, you wouldn't survive this respect-less offer.'[at random]"	Female_reject	0
"'You wouldn't know where I could find work around here by any chance?'"	Female_work	0
"'Could you tell me where I can find a shop to buy clothes around here?'"	Female_clothes	0
"'I'm looking for a place called 'the burrow'. Do you know where to find it?'"	Female_sewers	0

Before quipping when the current quip is Female_greeting:
	if the player carries at least one dose and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Female_deal quip for _woman;
	if the _woman is not worked and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Female_work quip for _woman;
	if the _woman is not clothed and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Female_clothes quip for _woman;
	if the _woman is not sewered and the stratum that is associated with the area that is the map region of the location is lower class:
		enable the Female_sewers quip for _woman;
	say "I said [italic type]'sumimasen'[roman type] to the passer-by.[paragraph break]".

After quipping when the current quip is Female_what_time:
	say "I said 'That's too bad. Thank you very much anyway.'";
	enable the Female_what_time quip;
	terminate the conversation.

After quipping when the current quip is Female_deal:
	disable the Female_what_time quip;
	disable the Female_work quip;
	disable the Female_clothes quip;
	disable the Female_sewers quip;
	say "I showed her the merchandise.[paragraph break]";
	if the _woman is doped:
		say "'But you just sold me one of those!'";
		enable the Female_what_time quip;
		terminate the conversation;
	else if a random chance of 1 in 3 succeeds:
		if the police patrol is in the location:
			deactivate the police patrol;
		now the ask value is a random price from 8 yen to 12 yen;
		say "'I'd give you [ask value * 500] for [one of]such a pill[or]one of those little babies[or]one pop[at random].'";
		enable the Female_accept quip;
		enable the Female_reject quip;
	else:
		say "[One of]'Accella? Do you want to poison me?'[or]'No, I'm not interested.'[or]'Sorry, but I'm too young to die.'[or]'I'd like to, but I'm totally broke.'[or]'If only I had the money for that!'[at random]";
		enable the Female_what_time quip;
		terminate the conversation.

After quipping when the current quip is Female_accept:
	disable the Female_reject quip;
	increase the wealth of the player by (ask value * 500);
	increase the wealth of the quick fox by (ask value * 500);
	move a random dose carried by the player to _woman;
	enable the Female_what_time quip;
	now the _woman is doped;
	terminate the conversation;
	if the police patrol is in the location:
		now the player is arrested.

After quipping when the current quip is Female_reject:
	disable the Female_accept quip;
	enable the Female_what_time quip;
	terminate the conversation;
	if the police patrol is in the location:
		activate the police patrol.

After quipping when the current quip is Female_work:
	enable the Female_what_time quip;
	terminate the conversation.

After quipping when the current quip is Female_clothes:
	enable the Female_what_time quip;
	terminate the conversation.
	
After quipping when the current quip is Female_sewers:
	enable the Female_what_time quip;
	terminate the conversation.
	


Part 10 - Police and Security

To report arrival of (Bod - a patroller) up from (place - a room): say "[The Bod] arrived from below.[line break]".
To report arrival of (Bod - a patroller) down from (place - a room): say "[The Bod] arrived from above.[line break]".
To report arrival of (Bod - a patroller) coming (way - a direction) from (place - a room): say "[The Bod] arrived from [the way].[line break]".
To report departure of (Bod - a patroller) going (way - a direction) to (place - a room): say "[The Bod] went [way].[line break]".
To report seen opening of (item - a door) by (Bod - a patroller): say "[The Bod] opened [the item].[line break]".
To report seen unlocking and opening of (item - a door) by (Bod - a patroller): say "[The Bod] unlocked and opened [the item].[line break]".
To report unseen opening of (item - a door): say "I heard the sound of someone opening [the item].[line break]".
To report unseen unlocking and opening of (item - a door): say "I heard the sound of someone unlocking and opening [the item].[line break]".
To report closing of (item - a door) by (Bod - a patroller): say "[The Bod] closed [the item].[line break]".
To report closing and locking of (item - a door) by (Bod - a patroller): say "[The Bod] closed and locked [the item].[line break]".

The police patrol is a patroller.
The police patrol is in L1_station_gates.
The initial appearance of the police patrol is "[if Busted is happening]The watchful officers made sure I couldn't escape.[else]A police patrol was watching the crowd."
The description of the police patrol is "Four Enforcement Solutions officers wearing body armour and toting sub-machineguns, each with a radio. One held a working dog tightly on a lash. They slowly and silently made their way through the crowd, spread out in a square about five meters wide."

The dog is a part of the police patrol. The description of the dog is "A vigilant-looking German shepherd dog of proportions demanding respect. Passers-bye duly made way for it."
Understand "working dog" and "german shepherd" as the dog.

Understand "officer/officers/policeman/policemen" as the police patrol.

A sub-machinegun is a kind of firearm. The description of a sub-machinegun is "A little lead-hose meant to boost its owner's self-image. It looked as ugly as its cowardly purpose."
Understand "sub-machinegun/sub-machineguns", "submachinegun/submachineguns" and "gun/guns" as a sub-machinegun. 

The police patrol carries four sub-machineguns. 

The police patrol wears body armour. The description of the body armour is "Bulky synthetic garments reinforced with bulletproof ceramic plates to increase the distance between their wearers and the rest of the population."
Understand "bulletproof/vest", "bulletproof vest" and "body armour" as the armour.

A radio is a kind of thing. The description of a radio is "These radios meant even the most primitive brute could be sent out on patrol. If a situation couldn't immediately be resolved by undue violence, he could always call for reinforcements."

The police patrol carries four radios. 

The drive of the police patrol is 75.
Turn frequency of the police patrol is 2.
The police patrol is RoomLed.
The police patrol is circular.
The OpeningCapability of the police patrol is WithKey.
The ReclosingCapability of the police patrol is Reinstate.
The RoomTable of the police patrol is the Table of Patrol Route.

Table of Patrol Route
TargetRoom
L1_station_gates
L1_streets_hub_7
L1_station_gates
L0_station_main
L0_streets_hub_3
L0_streets_hub_4
L0_streets_hub_1
L0_streets_hub_4
L0_streets_hub_3
L0_streets_hub_6
L0_streets_hub_3
L0_station_main

The greeting of the police patrol is Police_greeting

Table of Quip Texts (continued)
quip				quiptext
Police_greeting			"I tried to approach one of the officers but he just slowly shook his head in silence without breaking his stride."


Part 11 - Scenes

Chapter 1 - When play begins

When play begins: 
	now right hand status line is "My funds: [wealth of the player]";
	now the thing without feel value is "I felt nothing unexpected.";
	now the thing without scent value is "I smelt nothing unexpected.";
	now the thing without sound value is "I heard nothing unexpected.";
	now the thing without taste value is "I'd rather not taste that."; 
	activate the police patrol;
	choose row 1 in Table of Basic Help Options;
     	now description entry is "In terms of game design, this story is largely an exploration of the possibilities of choice-based conversation. Owing to this, character interaction plays an important part in the game and is generally facilitated by [italic type]TALK TO (whomever)[roman type] or even just [italic type]TALK[roman type] in most circumstances.[paragraph break]There are a few challenges to be overcome and some have alternative solutions. Outright puzzles, however, are rare. I therefore felt entitled to introduce a bit of the dreaded labyrinth and clothing fare into the mix. I hope to have made this a bit more convincing and appealing than it is generally thought of.[paragraph break]Some may find this work a bit wordy. As a remedy, obvious exits are printed in [bold type]bold type[roman type]. [italic type]Further exploration is, nevertheless, encouraged and necessary to achieve a standard ending.[roman type] No nuisance is intended and nothing of importance is hidden in any serious way.[paragraph break]For the sake of user friendliness, this game uses only the cardinal directions north, east, south and west as well as up, down, in and out. There are a few new commands implemented. They are for the most part synonymous (and functionally equivalent) with the standard ones and probably best left for the reader to discover.[paragraph break]If you ever find you don't know where to go in the game, ask around. Maybe someone will know the answer.[paragraph break]A number of unattributed quotes are contained in this work. They are all set in [italic type]italic type[roman type]. All credits for these quotes of course go to their respective authors, who should be easy enough to find out.[paragraph break]Lastly, it is possible to put this story into a non-winnable state. This is a non-trivial, yet tedious exercise. Certain game mechanics have prevented me from removing this possibility. It is also possible to end the story early in a variety of ways. Whether this constitutes sabotage of the protagonist is left for the reader to decide.";
	say "[italic type]'An unfamiliar city is a fine thing. That's the time and place when you can suppose that all the people you meet are nice. It's dream time.'[paragraph break]- Louis-Ferdinand Céline, Journey to the End of the Night[paragraph break][line break]Gatan-gatan[roman type] made the subway train every time it passed over a rail joint as it raced through the tunnel towards freedom. Squashed between commuters in the suffocating heat of the mid-summer night, I was already totally drenched in sweat - theirs and mine. I had opportunely lost my mobile phone half an hour ago in a trash can at Shinjuku station, so my father's men wouldn't have quite such an easy time tracking me. Gotomomi was the next stop and all I needed now to make my get-away was a change of trains and clothing.[paragraph break]".

Chapter 2 - Down and out

Down_and_out is a scene.
Down_and_out begins when the player is in L0_station_main for the first time.
Down_and_out ends when the player is in the shinkansen for the first time.
When Down_and_out begins:
	now the subway_gates are closed;
	now the subway_gates are locked;
	now the wealth of the player is 0 yen;
	remove the wallet from play;
	now the _man is not worked;
	now the _man is not clothed;
	now the _woman is not worked;
	now the _woman is not clothed.

When Down_and_out ends:
	say "Before I had even found a seat, the train was already moving. Slowly and very deliberately it drove out of the station. Then it began gathering speed.";
	if the player wears the yukata:
		end the story saying "While this was a change of trains, I still wore my easily recognisable yukata.";
	else if the player wears the furisode and the player wears the zouri and the player wears the fukoro obi:
		end the story finally saying "Just as I had planned, I managed to change trains at Gotomomi, wearing a fine new outfit that suited my tastes.";
	else:
		end the story finally saying "I managed to get out of Gotomomi in a different outfit from when I arrived. That was at least something."

Chapter 3 - Pickup_1

Pickup_1 is a scene.
Pickup_1 begins when the player carries the signpad.
Pickup_1 ends when Delivery_1 begins.

Chapter 4 - Delivery_1

Delivery_1 is a scene.
Delivery_1 begins when the player carries parcel_1.
Delivery_1 ends when JJ has parcel_1.

Chapter 5 - Pickup_2

Pickup_2 is a scene.
Pickup_2 begins when Delivery_1 ends.
Pickup_2 ends when Delivery_2 begins.

Chapter 6 - Delivery_2

Delivery_2 is a scene.
Delivery_2 begins when the player carries parcel_2.
Delivery_2 ends when Agnieszka has parcel_2.

Chapter 7 - Dealing

Dealing is a scene.
Dealing begins when the player carries a dose.
Dealing ends when the quick fox is payed.

Chapter 8 - Pickup_3

Pickup_3 is a scene.
Pickup_3 begins when Delivery_2 ends.
Pickup_3 ends when Delivery_3 begins.

Chapter 9 - Stripping

Stripping is a scene.
Stripping begins when Yamaguchi is painting.

Instead of going north during Stripping:
	deliver the Yamaguchi_no_escape quip.

When Stripping begins:
	now L3_studio is undressing.
Stripping ends when the player wears nothing.

Table of Artistic Preparations
title
"squeezed some paint from a tube onto his palette."
"seemed undecided which canvas to use."
"set up the easel under a different incandescent light."
"adjusted the height of his easel."
"rummaged through his utensils."
"selected a canvas, then shook his head and put it away again."
"picked up a brush and inspected it."

Every turn during Stripping:
	if a random chance of 1 in 3 succeeds:
		choose a random row in the Table of Artistic Preparations;
		say "[One of]Yamaguchi[or]The painter[or]The artist[at random] [title entry]".

Instead of talking to Yamaguchi during Stripping:
	deliver the Yamaguchi_no_talk quip.

Chapter 10 - Posing

Posing is a scene.
Posing begins when stripping ends.
Posing ends when Yamaguchi is not painting.

When Posing begins:
	enable the Yamaguchi_lets_see quip for Yamaguchi;
	deliver the Yamaguchi_start quip;
	run a conversation on the Table of Yamaguchi Conversation.

Instead of doing something other than examining or waiting or looking or talking to or QBC responding with during Posing:
	deliver the Yamaguchi_dont_move quip.

Table of Artistic Actions
title
"took a step back to get a better look at the whole canvas."
"mixed some paint on his palette."
"measured a distance by holding out his brush at arms lengths."
"applied some paint to the canvas with regular strokes."
"added a detail to the painting with the tip of his brush."
"picked up a smaller brush."
"picked up a bigger brush."

Every turn during posing:
	if a random chance of 1 in 3 succeeds:
		choose a random row in the Table of Artistic Actions;
		say "[One of]Yamaguchi[or]The painter[or]The artist[at random] [title entry]".

Chapter 11 - Delivery_3

Delivery_3 is a scene.
Delivery_3 begins when the player carries parcel_3.
Delivery_3 ends when Tanaka has parcel_3.

Chapter 12 - Pickup_4

Pickup_4 is a scene.
Pickup_4 begins when Delivery_3 ends.
Pickup_4 ends when Delivery_4 begins.

Chapter 13 - Phonecall

ChittyChatty is a number that varies.
ChittyChatty is 1.

Phonecall is a scene.
Phonecall begins when Kei is phoning.
Phonecall ends when ChittyChatty is 10.

When Phonecall begins:
	now ChittyChatty is 1.

Table of Chitter Chatter
title
"Kei picked up the phone and after a while she got through.[line break]I waited in silence."
"'...Yes, we've had a few sick calls tonight.'"
"'...It must be going around, I agree.'"
"'...No, they were all vaccinated.'"
"'...Yes, she looks underage. But I assure you, her papers are in order.'"
"'...Well, you know how it is, getting reliable staff with valid documents is very difficult.'"
"'...I wasn't admitting anything. And I'm not suggesting anything either. She has been doing fine until now.'"
"'...I'm not sure if she's vaccinated.'"
"'...I'll make sure for you, yes.'[paragraph break]"
"'Madame Liao?...Don't worry, she has all the necessary vaccinations.'"
"'...Oh, yes, of course, I personally checked all her credentials.'"
"'...It's only for tonight, I promise.'"
"'...Certainly. We will deliver your parcel tonight.'"
"'...Thank you, we are very grateful to have you as our customer.'[paragraph break]"
"She put down the phone.[paragraph break]"
	
Every turn during Phonecall:
	choose row ChittyChatty in the Table of Chitter Chatter;
	say "[title entry]";
	increase ChittyChatty by 1.

Instead of doing something other than examining or waiting or listening or looking or QBC responding with during Phonecall:
	deliver the Kei_dont_move quip.
	
Instead of listening during Phonecall:
	do nothing.

when phonecall ends:
	deliver the Kei_vaccinated quip;
	enable the Kei_shot quip for Kei;
	run a conversation on the Table of Kei Conversation.

Chapter 14 - Calling

Calling is a scene.
Calling begins when Phonecall ends.
Calling ends when ChittyChatty is 16.

Every turn during Calling:
	if Kei is not phoning:
		choose row ChittyChatty in the Table of Chitter Chatter;
		say "[title entry]";
		increase ChittyChatty by 1.

Instead of doing something other than examining or waiting or listening or looking or QBC responding with during Calling:
	deliver the Kei_dont_move quip.

Instead of listening during Calling:
	do nothing.

When Calling ends:
	deliver the Kei_go_now quip;
	enable the Kei_try_again quip for Kei;
	run a conversation on the Table of Kei Conversation.

Chapter 15 - Breaking and Entering

Chapter 16 - Waking him up

Waking him up is a scene.
Waking him up begins when the nurse is satisfied.
Waking him up ends when the doctor is awake.

When waking him up begins:
	try the nurse going west;
	try the nurse closing the praxis door;
	try the nurse locking the praxis door with the praxis key;
	the doctor wakes in three turns from now.

At the time when the doctor wakes:
	now the doctor is awake.
	
When waking him up ends:
	try the nurse unlocking the praxis door with the praxis key;
	try the nurse going east;
	deliver the Nurse_come_in quip.

Chapter 17 - Consultation

Consultation is a scene.
Consultation begins when waking him up ends.
Consultation ends when the doctor is jabby.

Chapter 18 - Vaccination

Vaccination is a scene.
Vaccination begins when Consultation ends.
Vaccination ends when ChittyChatty is 6.

When Vaccination begins:
	now ChittyChatty is 1.
	
Table of Immunisation
title
"Dr. Cutter prepared a rather large syringe from a few different medicine bottles."
"The doctor squeezed out the excess air from his syringe."
"'Now just be very relaxed, please' said the doctor as I began to tense up."
"'Hold still, this won't hurt a bit' He said, my triceps now totally cramped up."  
"He pushed the syringe deeply into my upper arm muscle. I had to avert my eyes so I wouldn't faint."
"My arm began to burn like fire as he squeezed out the syringe."

Every turn during Vaccination:
	choose row ChittyChatty in the Table of Immunisation;
	say "[title entry]";
	increase ChittyChatty by 1.

Instead of doing something other than examining or waiting or listening or looking during Vaccination:
	deliver the Doctor_hold_still quip.

When Vaccination ends:
	hangover starts in 10 minutes from now;
	deliver the Doctor_terrible quip;
	enable the Doctor_it_burns quip for the doctor;
	enable the Doctor_nothing quip for the doctor;
	run a conversation on the Table of Doctor Conversation.
	
Chapter 19 - Paperwork

Paperwork is a scene.
Paperwork begins when Vaccination ends.
Paperwork ends when the player carries the immunisation record.

Chapter 20 - Effects

Effects is a scene.

Effects begins when Vaccination ends.
Effects ends when the player is cured.

At the time when hangover starts:
	now the player is ill.

When Effects begins:
	hangover stops in 40 turns from now.

Every turn during Effects:
	if the player is ill and a random chance of 2 in 5 succeeds:
		say "[one of]The ground seemed a little shaky underneath my feet, even though I wasn't aboard a ship.[or]The colours of my surroundings seemed off, but maybe I was just getting tired.[or]My arm was still burning with every heartbeat.[or]My pulse was now racing, my breathing was hectic.[or]This sure had been a warm night. But right now I felt positively feverish.[or]I felt as drunk as I'd been at the sports camp two years ago.[or]My forehead was suddenly covered in cold sweat.[or]This was midsummer, and yet I was shivering heavily.[at random]";

At the time when hangover stops:
	say "I began to feel better again.";
	now the player is not ill;
	now the player is cured.

Chapter 21 - Manual labour

Manual labour is a recurring scene.
Manual labour begins when the player is hired.

When manual labour begins:
	now the player is not payed;
	now the production of the tinning machine is 0;
	if there is no bucket in L0_fish_tinning:
		move a random bucket in L0_fish_gutting to L0_fish_tinning;
	if there is no bucket in L0_fish_gutting:
		move a random bucket in L0_fish_tinning to L0_fish_gutting;
	repeat with Y running through fish in L0_fish_tinning:
		move Y to a random bucket in L0_fish_tinning;
		if a random chance of 2 in 3 succeeds:
			now the species of Y is a random species;
	repeat with Z running through fish on the gutting table:
		if a random chance of 2 in 3 succeeds:
			now the species of Z is a random species;
	activate the foreman;

Every turn during manual labour:
	if a random chance of 2 in 3 succeeds:
		now the gutters are unhappy;
		if there is at least one bucket in L0_fish_gutting:
			repeat with X running through buckets in L0_fish_gutting:
				if X contains less than 10 fish:
					if the gutting table supports at least one fish:
						let Y be a random fish supported by the gutting table;
						try silently the gutters inserting Y into X;
						if the player is in L0_fish_gutting:
							say "[one of]A[or]A gutted[or]A disemboweled[at random] [one of]fish[or][species of Y][at random] [one of]found its way[or]flew[or]was flung[or]was thrown[at random] into the [X].";
						now the gutters are happy;
						break;
		now the tinners are unhappy;
		if there is at least one bucket in L0_fish_tinning:
			repeat with X running through buckets in L0_fish_tinning:
				if X contains at least 1 fish:
					let Y be a random fish contained by X;
					move Y to the gutting table;
					if the player is in L0_fish_tinning:
						say "A [one of]fish[or][species of Y][at random] from the [X] [one of]was packed[or]was squeezed[or]found its way[at random] into a tin can.";
					now the tinners are happy;
					increase the production of the tinning machine by 1;
					break;
		if the gutters are unhappy and the foreman is in the location:
			deliver the Foreman_gutters quip;
		if the tinners are unhappy and the foreman is in the location:
			deliver the Foreman_tinners quip;

Manual labour ends when the production of the tinning machine is 50.
When manual labour ends:
	deactivate the foreman;
	let the way be the best route from the location of the foreman to the location of the player, using doors;
	try the foreman going the way;
	now the player is not hired.

Chapter 22 - Payment

Payment is a recurring scene.
Payment begins when the player is not hired and the foreman is in the location of the player.

when Payment begins:
	now Taniguchi is not fished;
	deliver the Foreman_end quip.

Payment ends when the player is payed and the player is in L0_streets_hub_6.
when Payment ends:
	if there is at least one bucket in L0_fish_office:
		repeat with X running through buckets in L0_fish_office:
			move  X to L0_fish_gutting;
	if there is at least one bucket in L0_fish_packing:
		repeat with Y running through buckets in L0_fish_packing:
			move Y to L0_fish_tinning.

Chapter 23 - Found out

Found out is a scene.
Found out begins when the player is caught.
Found out ends when the player is caught and the player is in L0_danceclub_frontdesk.

When Found out begins:
say "She began pushing me towards the stairs."

Instead of doing something other than going or examining or looking or listening or smelling during Found out:
	say "The girl's grip on my shoulder tightened as she shoved me closer to the stairs."

When Found out ends:
		move Risa to L0_danceclub_frontdesk;
		now the club stairs are closed;
		now Risa is not acquainted.

Chapter 24 - Thrown out

Thrown out is a scene.
Thrown out begins when Found out ends.
Thrown out ends when the player is caught and the location is L0_streets_hub_4.

When Thrown out begins:
		deliver the Risa_caught quip;
		run a conversation on the Table of Risa Conversation.
		
Chapter 25 - Busted

Busted is a scene.
Busted begins when the player is arrested.
Busted ends when the player is arrested and the player is in L0_police_reception.

When Busted begins:
	deactivate the police patrol;
	say "The police patrol had watched our trade and arrested me.";
	
Instead of doing something other than looking or examining or smelling or listening during Busted: 
	say "The policemen wouldn't let me do that.";

Every turn during Busted:
	let the way be the best route from the location to L0_police_reception, using doors;
	try silently the police patrol going the way;
	say "The policemen dragged me along.";
	move the player to the location of the police patrol.
			
When Busted ends:
	say "Without much fuss, they left me at the police station.[line break]Then they went to take up their patrol again, leaving me alone with the officer on duty.";
	activate the police patrol.

Chapter 26 - Interrogation

Interrogation is a scene.
Interrogation begins when Busted ends.
Interrogation ends when the player is not arrested.

When Interrogation begins:
	repeat with N running through things carried by the player:
		if N is a dose:
			move N to Taniguchi;
	deliver the Taniguchi_arrested quip;
	disable the Taniguchi_just_looking quip for Taniguchi;
	disable the Taniguchi_report_crime quip for Taniguchi;
	disable the Taniguchi_people quip for Taniguchi;
	enable the Taniguchi_contraband quip for Taniguchi;
	enable the Taniguchi_need quip for Taniguchi;
	run a conversation on the Table of Taniguchi Conversation.

Chapter 27 - Delivery_4

Delivery_4 is a scene.
Delivery_4 begins when the player carries parcel_4.
Delivery_4 ends when Wanja has parcel_4.

Chapter 28 - Drunkyard

Drunkyard is a scene.
Drunkyard begins when the cocktail is drunk.

At the time when intoxication starts:
	now the player is drunk.
	
When Drunkyard begins:
	intoxication starts in 15 minutes from now;
	
Every turn during Drunkyard:
	if the player is drunk and a random chance of 1 in 5 succeeds:
		say "[one of]Suddently I felt like giggling.[or]I felt a little tipsy.[or]Was I getting tired?[or]Maybe I did have a little too much alkohol that night.[or]The noises of my surroundings seemed to come from afar and were barely registering with me.[or]My face felt terribly hot.[at random]".


Chapter 29 - Endgame

Endgame is a scene.
Endgame begins when Rachel is rescued.
When Endgame begins:
	let the way be the best route from the location of Rachel to L0_streets_hub_2, using doors;
	try Rachel going the way;
	teleportation starts in 1 minute from now;
	
At the time when teleportation starts:
	now Rachel is in L0_Rental.
	
Endgame ends when the player is rich.


Part 12 - Vehicles

Chapter 1 - The shinkansen

In L2_station_platform is an enterable container called the shinkansen.

The initial appearance of the shinkansen is "A shinkansen-train was currently halted at the platform." The description of the shinkansen is "A sleek white bullet-train."
Understand "train" and "bullet-train" as the shinkansen.

Instead of taking the shinkansen:
	try entering the shinkansen.

Chapter 2 - The boat

Section 1 - The boat

In L-1_canal_pier_1 is a vehicle called the motor boat. The initial appearance of the motor boat is "[if the location is L-1_canal_pier_1]An old motor boat was moored to the pier.[else if the location is L-1_canal_pier_2]The motor boat was fastened to the raft.[else]The motor boat was moored to the pier." The description of the motor boat is "This boat was probably held together by nothing more than the scarce traces of paint left in the gaps between the planks. It was driven by an old outboard engine and its name - 'Rachel' - was painted on the bow."

The motor boat can be rented. The boat is not rented.
Does the player mean doing something with the motor boat: it is likely.

After examining the motor boat for the first time: 
	now the player is boated.

Section 2 - The engine

The outboard engine is part of the motor boat. The outboard engine is a device. The description of the engine is "An outboard engine so oil-fouled its operation was doubtful. It was easy enough to use if it started, which was facilitated by a simple ignition.[unless the boat key is in the ignition] The ignition key however, was missing." The outboard engine is switched off. 

Understand "motor" as the outboard engine.
Does the player mean doing something with the outboard engine: it is very likely.
	
The ignition is part of the outboard engine. The ignition is a container. The description of The ignition is "[if the boat key is not in The ignition]A scratched keyhole, no key in it."

Understand "keyhole" as The ignition.

Check turning the boat key:
	if the boat key is in the ignition and the outboard engine is switched off:
		try silently switching on the outboard engine;
		say "I turned the key, and the engine sprung to life." instead.

Check turning the boat key:
	if the boat key is in the ignition and the outboard engine is switched on:
		try silently switching off the outboard engine;
		say "I turned the key, and the engine stopped running." instead.

Report turning the boat key:
	say "I turned the key in my hand." instead.
	
Before inserting something that is not the boat key into the ignition:
	say "That didn't belong in there." instead.

Understand "stick [something] into [something]" as inserting it into.

Before switching on the outboard engine when the boat key is not in the ignition:
	say "I would need to put the key into the ignition first." instead.

Report switching on the outboard engine:
	say "Stuttering noisily, the engine came to life." instead.

Understand "start [something]" as switching on.
Understand "stop [something]" as switching off.

Before taking the boat key when the boat key is in the ignition and the outboard engine is switched on:
	say "The engine was still running." instead.

Starting it with is an action applying to two things.

Understand "start [something] with [something]" as starting it with.
Understand "turn on [something] with [something]" as starting it with. 

Check starting it with:
	if the noun is the outboard engine or the noun is the motor boat:
		if the second noun is the boat key:
			now the boat key is in the ignition;
			say "I started the engine with the boat key.";
			try switching on the outboard engine instead;
		else:
			say "That would hardly be able to start the engine." instead;
	else:
		say "That made little sense to me." instead;
		
Report starting it with:
	say "That made little sense to me."

Instead of switching on the motor boat:
	try switching on the outboard engine.

Instead of switching off the motor boat:
	try switching off the outboard engine.

Section 3 - Rules for movement

Instead of going inside in the presence of the motor boat when the location is not L-1_canal_pier_2:
	try entering the motor boat.

Instead of going by the motor boat when the outboard engine is switched off:
	say "The engine wasn't running at the moment." instead.
	
Instead of going by the motor to a room that is not wet:
	say "The motor boat would only float on water. I couldn't go anywhere else with it." instead.

Instead of exiting when the player is in the motor boat:
	if the location is a pier or the location is a sewerpier:
		continue the action;
	else:
		say "Yuk, I was not going to ruin my health by swimming in sewage."

Instead of going to a room (called X) that is wet:
	if the player is in the motor boat:
		continue the action;
	else if X is not a pier and X is not a sewerpier:
		say "Yuk, I was not going to ruin my health by swimming in sewage.";
	else:
		continue the action.
		
[Rule for implicitly exiting the motor boat:
	Do nothing.

Before implicitly exiting the motor boat:
	Do nothing.]

Understand "board [motor boat]" as entering.

Chapter 3 - The elevator

The Lift is a room. The printed name is "Inside the elevator of the Arisaka mall". The description is "The elevator sported a numbered button panel to select which floor to go to. The illuminated number above the button panel said [current level of the Lift]."
L0_mall_hub is outside from the Lift.

The button panel is scenery in the Lift. The description is "There were 137 buttons in all."

Table of Floors 
level	floor   
0  		L0_mall_hub   
31		L1_mall_hub
104   	L3_mall_hub  

The elevator exterior is a backdrop. It is not scenery. The initial appearance of the elevator exterior is "The elevator on this landing connected all the many floors of the building." It is in Generic Floor, L0_mall_hub, L1_mall_hub and L3_mall_hub.

Before entering the elevator exterior:
	try going inside instead.
	
Before going inside in the presence of the elevator exterior:
	if there is a level corresponding to a floor of the location in the Table of Floors: 
		let the present level be the level corresponding to a floor of the location in the Table of Floors; 
		now the current level of the Lift is the present level; 
	otherwise:
		now the current level of the Lift is the current level of Generic Floor; 
	move the player to the Lift instead.

The Lift has a number called current level. The current level of the Lift is 1.

Before going up in the Lift: say "I'd have to select a specific floor; my options ranged from 0 to 137." instead.

Before going down in the Lift: try going up instead. 

Before going outside in the Lift:
	if there is a floor corresponding to a level of the current level of the Lift in the Table of Floors:
		let the other place be the floor corresponding to a level of the current level of the Lift in the Table of Floors; 
		move the player to the other place instead; 
	otherwise: 
		now the current level of the Generic Floor is the current level of the Lift; 
		move the player to the Generic Floor instead.

The Generic Floor is a room. The Generic Floor has a number called current level. The printed name of the Generic Floor is "Floor [current level of the Generic Floor]". "[One of]This floor contained a number of offices.[or]There were lots of small offices on this floor.[or]Several medium-sized offices were housed on this floor.[or]This floor provided office space to various renters.[at random] A number of businesses tried to improve their reputation by having an address in this building. At this time of the night, the corridors were dark and empty."

Before doing anything other than looking, entering or exiting when the location is the Generic Floor:
	say "I was quite sure I had no business on this floor." instead.

Pressing button is an action applying to one number.
Understand "push [number]", "type [number]", "select [number]" and "press [number]" as pressing button. Understand "push [number] button" , "type [number] button", "select [number] button" and "press [number] button"as pressing button. Understand "push button [number]", "type button [number]", "select button [number]" and "press button [number]" as pressing button.

Check pressing button:
	if the player is not in the Lift:
		say "I couldn't control the elevator unless I was myself inside." instead;
	if the number understood is the current level of the Lift:
		say "Nothing happened, since the elevator was already on floor [number understood]." instead;
	if the number understood is greater than 137:
		say "There were only 137 floors." instead;
	if the number understood is less than 0:
		say "I couldn't go below the ground-floor in this elevator." instead.

Carry out pressing button:
	now the current level of the Lift is the number understood;
	say "I pressed the button numbered [number understood]. The doors closed and the elevator began to move.[paragraph break]After a while it stopped and reopened its doors."

Part 13 - Release settings

The story genre is "Fiction".
The story headline is "A railway interchange between the subway and the long-distance lines. A really simple story unlike some of the classic post-modern fairy tales of our childhood and youth".
The story description is "Gatan-gatan made the subway train every time it passed over a rail joint as it raced through the tunnel towards freedom. Squashed between commuters in the suffocating heat of the mid-summer night, I was already totally drenched in sweat - theirs and mine. I had opportunely lost my mobile phone half an hour ago in a trash can at shinjuku station, so my father's men wouldn't have quite such an easy time tracking me. Gotomomi was the next stop and all I needed now to make my get-away was a change of trains and clothing."
The release number is 1.
The story creation year is 2015.


Book 2 - The Game World

Part 1 - The station

Chapter 1 - The Station proper

Section 1 - L-1_station_subway

L-1_station_subway is a room. The printed name is "Hamano line platform". The Description is "[if unvisited]The train stopped and the doors flew open with a sharp pneumatic hiss. A wave of passengers rolled onto the station's platform, carrying me along. While the train sucked in a healthy portion of the waiting crowd with the back draft and ran on, the current pulled me towards the only staircase that led [bold type]upwards[roman type].[paragraph break][italic type](New players may want to type HELP)[roman type][else]The platform was packed with people. I had no business here and wanted to get to away as quickly as possible. Conveniently, there was only one flight of stairs I could take to get [bold type]up[roman type] to the long-distance lines."

Rule for printing the name of a room when L-1_station_subway is unvisited: do nothing.

The tunnels are plural-named scenery.
The tunnels are in L-1_station_subway. The tunnels are distant. The description is "The subway tunnels were gaping black holes."
Understand "tunnel" as the tunnels when in L-1_station_subway.

Some privately-named tracks called the sub_tracks are in L-1_station_subway. The description is "The tracks of the Hamano-line."
Understand "track/tracks" as the sub_tracks when the location is L-1_station_subway.

A privately-named platform called sub_platform is in L-1_station_subway. The printed name is "subway platform". The description is "A typical, if slightly curving, subway platform."
Understand "platform/platforms" as sub_platform when the location is L-1_station_subway.

Instead of waiting when the location is L-1_station_subway:
	say "I didn't have any time to loiter here."

Section 2 - L0_station_main

L0_station_main is a room. The printed name is "Gotomomi central station". The Description is "[if unvisited]I passed through the toll gates and stood in the main corridor of the station, which was bustling with life.[else]This was the main aisle of Gotomomi station from where one could reach the subway platforms [bold type]downstairs[roman type] - after passing through a set of toll gates. The never ending stream of people about at this time of the night was nigh unbelievable.[end if] To the [bold type]south[roman type] was the entrance to the railway police station. To the [bold type]west[roman type] was the main exit to the street. There was also a flight of stairs the size of the Victoria Falls [bold type]ascending[roman type] towards the long-distance lines."

The koban is scenery in L0_station_main. The description of the koban is "An Enforcement Solutions police box."
Understand "police" and  "police box/station" as the koban when the location is L0_station_main.

Instead of entering the koban:
	try going south. 

The vending machines are plural-named scenery in L0_station_main. The description of the vending machines is "One could buy tickets for the subway here."
Understand "machine", "ticket vending machine/machines", "ticket machine/machines" and "vending machine" as the vending machines when the location is L0_station_main.

Before going east when the location is L0_station_main:
	try talking to the security guards instead.

Instead of going inside when the location is L0_station_main:
	try going south.

Section 3 - L1_station_gates

L1_station_gates is a room. The printed name is "Long-distance lines station". The Description is "The Odakyû-shinkansen, the fastest way to travel - the ticket office was to the [bold type]south[roman type]. The high-speed trains departed from the platform, which was [bold type]upstairs[roman type] from here, but in order to get there, one had to pass the toll gates. To the [bold type]north[roman type] was an exit which would bring me to the elevated pedestrian walkways that connected the high rises around the station. A gigantomanian flight of stairs, covered from one end to the other by a waterfall of people, connected this level of the station to the one [bold type]below[roman type]."

Instead of going inside when the location is L1_station_gates:
	try going south.

Section 4 - L1_station_tickets

L1_station_tickets is a shop. The printed name is "Shinkansen ticket office". The Description is "Here one could buy tickets to reach even the most remote regions of the country, some of which were advertised as locations for fabulous vacations by posters on the wall. Almost invisible between the advertising were some comparably sober timetables. Going [bold type]north[roman type] would bring me to the main hall of the station."
L1_station_tickets is detailed.
The walltext of L1_station_tickets is "The walls were covered with posters and timetables."
The ceilingtext of L1_station_tickets is "The usual ceiling tiles."
The floortext of L1_station_tickets is "The carpet had a particularly ugly checkered pattern of blue and grey."
L1_station_tickets is south from L1_station_gates.

The posters are plural-named scenery. The posters are in L1_station_tickets. The description of the posters is "Advertised were cherry blossoms, hot springs, all-inclusive hotels and all the other common dreams of common people. All for under 70.000 yen."
Understand "ad/ads/advert/adverts/poster/advertising/advertisings/advertisements/vacation/holiday/location/locations" and "holiday/vacation locations" as the posters when the location is L1_station_tickets.

After examining the posters for the first time:
	now the Odakyu Employee is vacated.

The timetable is scenery. The timetable is in L1_station_tickets. The description of the timetable is "The timetable showed the train times."
Understand "timetables" and "train times" as the timetable when the location is L1_station_tickets.

In L1_station_tickets is a counter.

Section 5 - L2_station_platform

L2_station_platform is a room. The printed name is "High-speed-line tracks". The Description is "A giant glass ceiling span across the platforms of the Odakyû-shinkansen. A staircase led [bold type]down[roman type] to the stations entrails." 
L2_station_platform is detailed. 
The ceilingtext of L2_station_platform is "Triangular glass panes."

A privately-named platform called shinkansen_platform is in L2_station_platform. The description is "The platform was marked at regular intervals to show where the doors of the trains would open."
Understand "platform/platforms" as shinkansen_platform when the location is L2_station_platform.

Some privately-named tracks called shinkansen_tracks are in L2_station_platform. The description is "The Shinkansen tracks."
Understand "track/tracks" as shinkansen_tracks when the location is L2_station_platform.

Chapter 2 - The police station

L0_police_reception is a room. L0_police_reception is detailed. The printed name is "Police box". The description of L0_police_reception is "The sparseness of this 
Enforcement Solutions [italic type]koban[roman type] was very sobering. There was no decoration to speak of unless one counted the official notices and wanted posters pinned to the counter. The main corridor of the railway station was to the [bold type]north[roman type]." L0_police_reception is south of L0_station_main.
The walltext of L0_police_reception is "Dry walls."
The ceilingtext of L0_police_reception is "Light-weight paneling."
The floortext of L0_police_reception is "Stained linoleum."

The official notices are plural-named scenery in L0_police_reception. The description of the official notices is "Lots and lots of text, I had no intention to read it all."
Understand "official notice" and "notice/notices" as the official notices when the location in L0_police_reception.

The wanted posters are plural-named scenery in L0_police_reception. The description of the wanted posters is "Arrest warrant had been issues for two burglars, a few robbers and a drug dealer. There were also a few missing person notices. Mine was not amongst them."
Understand "wanted poster" and "poster/warrant/warrants" as the wanted posters when the location is L0_police_reception.

In L0_police_reception is a counter.

Part 2 - The Mall

Chapter 1 - L0_mall_hub

L0_mall_hub is a room.  The printed name is "Ground floor of the Arisaka mall". The description of L0_mall_hub is "Amongst the many larger and smaller shops on the ground-floor of the mall that sold tasteless clothing, jewelry, toiletries and the like to the [italic type]nouveau rich[roman type], a precious little clothing boutique called 'Utsunomiya Agnieszka' caught my eye. It was just to the [bold type]south[roman type] from where I stood. To the [bold type]west[roman type] a passage led to the subway station." 
L0_mall_hub is down from L1_mall_hub and east of L0_station_main.

The boutique is scenery in L0_mall_hub. The description of the boutique is "It was a clothing shop. As it is with theses, one had to enter it to get a better picture."

Understand "shop" and "clothing shop" as the boutique when the location in L0_mall_hub.

The stores are scenery in L0_mall_hub. The printed name of the stores is "shops". The description of the stores is "Most sold make-believe."

Understand "shops/businesses" as the stores when the location is L0_mall_hub.


Chapter 2 - L1_mall_hub

L1_mall_hub is a room. The printed name is "Floor 17". The description of L1_mall_hub is "Much of the floorspace on this level was taken up by the medical praxis of 'Dr. Edward Cutter'. The entrance was to the [bold type]south[roman type]."

The medical praxis is scenery in L1_mall_hub. The description of the medical praxis is "A sign on the door said it was open 24 hours."
Understand "sign/door" as the medical praxis when the location is L1_mall_hub.


Chapter 3 - L3_mall_hub

L3_mall_hub is a room. The printed name is "Floor 104". The description is "It appeared as if all the offices on this level were rented to lawyers and real estate agents. No one was around at this late hour and the landing lay silent and dark. A single door to the [bold type]south[roman type] seemed different, however. The sign on the doorbell just said 'Studio Yamaguchi'." L3_mall_hub is up from L1_mall_hub.

Before going up when the location is L0_mall_hub or the location is L1_mall_hub or the location is L3_mall_hub:
	say "No staircase was in sight. There was an elevator, however." instead.

Before going down when the location is L1_mall_hub or the location is L3_mall_hub:
	say "No staircase was in sight. There was an elevator, however." instead.

Part 3 - The Streets

Chapter 1 - L0_streets_hub_1

L0_streets_hub_1 is a room. The printed name is "Narrow passage". The Description is "This was the grand shitamachi-dôri. The little passage saw considerably less traffic than the glittering main street beside the rail line to the [bold type]south[roman type]. Nevertheless there were still quite a few people coming and going. A few steps, dimly lit by a red lantern led [bold type]down[roman type] to a place called 'The Little China Girl'. To the [bold type]north[roman type] was a steel gate belonging to a business going by the name of 'Yano & Chou Import-Export'."
L0_streets_hub_1 is north of L0_streets_hub_4.

The bordello is scenery in L0_streets_hub_1. The printed name of the bordello is "'The Little China Girl'". The description of the bordello is "This place was infamous even beyond Gotomomi city."
Understand "Little china girl" and "china" as the bordello when the location is L0_streets_hub_1. 

Instead of entering the bordello: try going down.

Instead of going east when the location is L0_streets_hub_1: try going down.

The red lantern is scenery in L0_streets_hub_1. The description is "The cheap imitation of an antique Chinese lantern."
Understand "light/chinese/antique" and "red light" as the red lantern when in L0_streets_hub_1.

Chapter 2 - L0_streets_hub_2

L0_streets_hub_2 is a room. The printed name is "Back alley". The description is "Garbage was piling up in the corners of this narrow alley and, judging by the broken syringes left on the floor, it was considered a worthwhile place to stay by junkies. The vents of a dozen or so air conditioners filled the air with a constant, sonorous humming. A dilapidated fire escape ladder clung precariously to the walls of the building to the west. A stairway led [bold type]upwards[roman type] toward the pedestrian walkway on the other side of the tracks."

The fire escape ladder is an enterable supporter and scenery in L0_streets_hub_2. The description is "In case of fire, the inhabitants of the building were meant to evacuate through the windows with the help of this ladder."
Understand "fire ladder" as the fire escape ladder when in L0_streets_hub_2.

The air conditioners are plural-named scenery in L0_streets_hub_2.
The description is "The air conditioners came in all shapes and sizes. They protruded from the buildings like the hives of wild bees."

The garbage is scenery in L0_streets_hub_2. The description is "Black bags full of refuse with some loose, wet items of rubbish strewn in. I had no desire to investigate that any further."
Understand "refuse" and "garbage bags" as the garbage when the location is L0_streets_hub_2.

The syringes are plural-named scenery in L0_streets_hub_2. The description is "Broken glassware and other discarded gear were strewn on the ground."
Understand "syringe/glass/glassware/gear/discarded" as the syringes when the location is L0_streets_hub_2.

Chapter 3 - L0_streets_hub_3

L0_streets_hub_3 is a room. The printed name is "In front of the train station". The Description is "The square in front of Gotomomi central station doubled as the city's primary waterfront. In the [bold type]south[roman type] a railway bridge spanned the width of a canal that discharged its revolting contents into the bay at this point and in the [bold type]north[roman type] the Odakyû line extended towards a wall of sky-high buildings, the street beside it bustling with activity. The main entrance to the station was to the [bold type]east[roman type], and the sheer amount of traffic going in and out of it every second was staggering. To the west stretched the black waters of the sea, intermittently coloured by the position lights of ships far out in the bay."
L0_streets_hub_3 is west of L0_station_main.

[On the other hand, the pedestrian walkway under the railway bridge was so crammed there seemed to be almost no movement in any direction on it.]

The main entrance is scenery in L0_streets_hub_3. The description is "The main entrance to Gotomomi central station spew out people just as fast as it was sucking them in."
Understand "station/gotomomi", "rail/railway/gotomomi/central station", "gotomomi central station", "station/gotomomi entrance" and "rail/railway/gotomomi/central station entrance" as the main entrance when the location is L0_streets_hub_3.

Instead of entering the main entrance: try going east.

Chapter 4 - L0_streets_hub_4

L0_streets_hub_4 is a room. The printed name is "Beside the railway viaduct". The Description is "Here, the Odakyû railway viaduct was seemingly swallowed by a huge gaping mouth in one of the skyscrapers. Far below it, a steady stream of battered poor-folk ensured good business for the shabby shops under the railway line. To the [bold type]west[roman type] was the entrance to 'Martyrium'[if L0_danceclub_frontdesk is visited], a dance club[end if]. To the [bold type]south[roman type] was the station. A small passage vanished between the buildings to the [bold type]north[roman type]."
L0_streets_hub_4 is north of L0_streets_hub_3.

Tanakas booth is scenery in L0_streets_hub_4. The description of Tanakas booth is "It seemed to be a small pawnshop."
Understand "Tanaka/used/goods/pawnshop/shop" and "Tanakas used goods" as Tanakas booth when the location is L0_streets_hub_4.

Instead of entering Tanakas booth: try going inside.

The martyrium is scenery. The martyrium is in L0_streets_hub_4. The description of the martyrium is "'Martyrium' was apparently the name of the place, if one was to judge by the multi-coloured neon sign above the entrance."
Understand "sign/entrance" and "neon sign" as the martyrium when the location is L0_streets_hub_4.

Instead of entering the martyrium: try going west.

Instead of going east in L0_streets_hub_4:
	try going inside.

Chapter 5 - L0_streets_hub_6

L0_streets_hub_6 is a room. The printed name is "Docklands". The Description is "This artificial island was home to a flotilla of small fishing boats whose masts could be seen extending over the quay wall and whose nets could be smelled even against the general olfactory background of the nearby canal. A collection of ramshackle booths of various size and construction had been erected on the quay. To the [bold type]east[roman type] the 'Seng Heng fish packing co. ltd.' occupied the ground floors of several adjacent buildings. The overcrowded bridge to the [bold type]north[roman type] connected the island to the rest of the city. A ladder of rusty rungs cemented into the quay wall [bold type]descended[roman type] to the pier below."
L0_streets_hub_6 is south of L0_streets_hub_3.

The booths are plural-named scenery in L0_streets_hub_6. The description is "Amongst the various booths on the quay was one with a battered sign on its roof that said 'Boat rental'."

Understand "booth/shed/sheds/shack/shacks/sign/hut/huts/ramshackle/rental", "boat rental", "rental booth" and "ramshackle booth/booths" as the booths when the location is L0_streets_hub_6.

Instead of entering the booths: try going inside.

The fish factory is scenery in L0_streets_hub_6. The description of the fish factory is "This business had apparently bought up many of the storefronts around here and boarded them up to keep out curious eyes. It made for a rather hap-hazard setup."
Understand "seng heng" and "packing" as the fish factory when the location is L0_streets_hub_6.


Chapter 6 - L1_streets_hub_7

L1_streets_hub_7 is a room. The printed name is "On the walkway In front of the station". The Description is "The elevated platform I was standing on ran the length of the railway viaduct. It was meant to ensure no pedestrian would disturb the motor traffic underneath, which produced a constant, ear-battering level of noise. A flight of stairs led [bold type]down[roman type] underneath one of the arcs of the railway viaduct. To the [bold type]east[roman type] was the entrance to 'CityTrafficking',[if L1_delivery is unvisited] probably[end if] a courier service. To the [bold type]south[roman type] was the entrance to Gotomomi station."
L1_streets_hub_7 is north of L1_station_gates.

The motor traffic is scenery in L1_streets_hub_7. The motor traffic is distant. The description of the motor traffic is "I couldn't see the motor traffic from here."
A distant objects rule for the motor traffic while Listening to: rule succeeds.
The sound of the motor traffic is "A cacophony of engine noise, sirens and honking."

CityTrafficking is scenery in L1_streets_hub_7. The description is "It didn't seem like the biggest operation this side of the pacific."
Understand "courier/service" and "courier service" as CityTrafficking when the location is L1_streets_hub_7.

Instead of entering CityTrafficking: try going east.

Part 4 - Canals and Sewers

Chapter 1 - The canals

Section 1 -1_canal_pier_1

L-1_canal_pier_1 is a pier. The printed name is "[If the player is in the motor boat]In the canal, at the pier near the bridge.[else]On the Pier near the bridge." The Description is "A few fishing boats in various states of seaworthiness were based at this pier. A rusty ladder [bold type]ascended[roman type] the quay wall. To the [bold type]east[roman type] lay the mouth of the canal."

Section 2 -1_canal_bridge

L-1_canal_bridge is a canal. The printed name is "In the canal, under the rail bridge". The description is "The canal was quite wide where it met the sea, but that had not stopped the builders of the Odakyû-line to construct the old bridge right here. The canal continued to the [bold type]east[roman type]. To the [bold type]west[roman type] was the fishing boat pier."
L-1_canal_bridge is east of L-1_canal_pier_1.

Section 3 -1_canal_pier_2

L-1_canal_pier_2 is a pier. The printed name is "[if the player is in the motor boat]Within the floating market.[else]On the large raft in the floating market." The description is "The canal was home to a floating market formed by about a hundred vessels of different sizes at this point. Some of the larger ones were permanently anchored to another, the smaller ones maneuvered in the narrow waterways between them. A large raft near me seemed to house a second-hand clothing shop. The canal entered the basin from the [bold type]west[roman type]. I could not make out any other way out of the labyrinthine market." L-1_canal_pier_2 is east of L-1_canal_lock.

The vessels are plural-named scenery in L-1_canal_pier_2. The description of the vessels is "Groceries, stationary, wholesale, it was all available here."
Understand "vessel/groceries/stationary/wholesale/rafts/boats" as the vessels when the location is L-1_canal_pier_2.

The waterways are plural-named scenery in L-1_canal_pier_2. The description of the waterways is "The passages between the large vessels formed a formidable labyrinth." 
Understand "labyrinth/waterway" as the waterways when the location is L-1_canal_pier_2.

Affordable Apparel is scenery in L-1_canal_pier_2. The printed name of Affordable Apparel is "large raft". The description of Affordable apparel is "The raft consisted of several rows of plastic barrels wired together and planked over to form a floating platform for the shop. A sign on the raft said 'Affordable Apparel'."
Understand "second-hand/clothing/shop/raft/large/platform/barrels/plastic", "second-hand/clothing shop", "large raft", "plastic barrels" and "second-hand clothing shop" as Affordable Apparel when the location is L-1_canal_pier_2.

Instead of entering Affordable Apparel: try going inside.

After exiting from the motor boat when the location is L-1_canal_pier_2:
	say "I got out of my boat and boarded the raft.";
	try going inside.

Before entering Affordable Apparel when the player is in the motor boat:
	try exiting;

Understand "board [something]" as entering when the noun is Affordable Apparel.

Section 4 -1_canal_lock

L-1_canal_lock is a canal. The printed name is "In the canal, in front of the lock.". The description is "Here, the canal was so narrow the buildings on both sides seemed to close in on me with their bizarrely entangled extensions. To the [bold type]west[roman type] was the railway bridge, to the [bold type]east[roman type] lay a large basin. A large lock to the [bold type]north[roman type] restricted access to the underground sections of the canal system." 
L-1_canal_lock is east of L-1_canal_bridge.

["A sign on the wall beside it detailed its opening mechanism."]

[The sign is scenery in L-1_canal_lock. The description is "'Municipal sewer lock - access prohibited. The lock will open for five minutes every 15 minutes. Boats are advised to stay clear at the time of opening.'".]

Chapter 2 - The sewers

Section 1 - L-1_sewer_junction_1

L-1_sewer_junction_1 is a sewer. The printed name is "In the sewers, in front of the lock.". The description is "The sewer system was filled by an eerie silence. [if the sewer lock is open] Dimly lit by what little light reached in from the entrance[else if the player carries a lit flashlight]Caught in the beam of my flashlight[end if] was a series of columns that lined the walls of the canal, each in the form of a silent guardian carrying the ceiling on the palms of his hands. Tunnels disappeared into the darkness to the [bold type]north[roman type] and [bold type]west[roman type]. The great rusty gates which separated this netherworld from the light of day were to the [bold type]south[roman type]."

Section 2 - L-1_sewer_junction_2

L-1_sewer_junction_2 is a sewer. The printed name is "In the sewers, at a junction.". The description is "Four statues held the vault above the junction I was at. Three tunnels, each as dark as the other, went out towards the [bold type]north[roman type], [bold type]west[roman type] and [bold type]south[roman type]. Another, even darker, smaller and winding one, went [bold type]east[roman type]." L-1_sewer_junction_2 is north of L-1_sewer_junction_1.
Understand "vault" as the ceiling when the location is L-1_sewer_junction_2.

Section 3 - L-1_sewer_junction_3

L-1_sewer_junction_3 is a sewer. The printed name is "In the sewers, at a junction.".
The description is "A wide dome spanned across this part of the sewers. Canals branched off towards the [bold type]south[roman type], [bold type]east[roman type] and [bold type]west[roman type]. Each corner was flanked by a stone guardian." L-1_sewer_junction_3 is north of L-1_sewer_junction_2.
Understand "dome" as the ceiling when the location is L-1_sewer_junction_3.

Section 4 - L-1_sewer_junction_4

L-1_sewer_junction_4 is a sewer. The printed name is "In the sewers, at a junction.". The description is "There were three ways to go from here: [bold type]north[roman type], [bold type]east[roman type] and [bold type]west[roman type]. All seemed the same kind of dark, foreboding, subterranean canal." L-1_sewer_junction_4 is west of L-1_sewer_junction_1.

Section 5 - L-1_sewer_junction_5

L-1_sewer_junction_5 is a sewer. The printed name is "In the sewers, in the middle of the accumulation reservoir.". The description is "I didn't notice at first, but it soon became apparent that the walls had gone. My boat was floating through a forest of regularly spaced columns that held the ceiling of a huge accumulation reservoir. Canals entered it from [bold type]all the cardinal directions[roman type]." L-1_sewer_junction_5 is west of L-1_sewer_junction_2 and north of L-1_sewer_junction_4.

Section 6 - L-1_sewer_junction_6

L-1_sewer_junction_6 is a sewer. The printed name is "In the sewers, beneath the giant ventilation fan.". The description is "The huge fan in the ceiling at this bend in the canal produced a recurring, unsettling noise. The tunnel continued towards the [bold type]east[roman type] and [bold type]south[roman type]." 
L-1_sewer_junction_6 is west of L-1_sewer_junction_3 and north of L-1_sewer_junction_5.

The sound of L-1_sewer_junction_6 is "There was a clearly audible, recurring sound from above."

The ventilator is scenery in L-1_sewer_junction_6. The printed name is "ventilation fan". The description is "Two meters wide, it rotated incessantly."
Understand "fan" and "ventilation fan" as the ventilator when the location is L-1_sewer_junction_6.

The sound of the ventilator is "A recurring sound came from the ventilation fan."

Section 7 - L-1_sewer_deadend_1

L-1_sewer_deadend_1 is a sewer. The printed name is "In the sewers, below a wall.". The description is "The basin my boat was in now ended abruptly in front of a bare wall to the south, at least 20 meters high. One canal lead out of the basin towards the [bold type]east[roman type], one to the [bold type]north[roman type]. A smaller, very dark and winding tunnel went [bold type]west[roman type]." 
L-1_sewer_deadend_1 is west of L-1_sewer_junction_5 and east of L-1_sewer_junction_2.

Section 8 - L-1_sewerpier_1

L-1_sewerpier_1 is a sewerpier. The printed name is "In the sewers, in front of a door in the wall". The description of L-1_sewerpier_1 is "A Rusty metal door with a small pier in front of it was set into the [bold type]northern[roman type] wall of the sewer. The tunnel continued to the [bold type]south[roman type]." L-1_sewerpier_1 is north of L-1_sewer_deadend_1.

Section 9 - L-1_sewer_deadend_2

L-1_sewer_deadend_2 is a sewer. The printed name is "In the sewers, in a long winding tunnel". The description is "This underground canal seemed to go on and on forever as it wound its way from [bold type]east[roman type] to [bold type]west[roman type]." L-1_sewer_deadend_2 is east of L-1_sewer_junction_3 and west of L-1_sewer_junction_4.

Part 5 - The locations

Chapter 1 - The pawnshop

L0_pawnshop is a shop. The printed name is "Tanaka's used-goods shop". The description is "The entrails of Tanaka's shop were in no way better than its outsides. The cave-like structure was made all the more claustrophobic by the dim light of the lone kerosene lantern. Odd objects of every nature hung off the walls. The only way [bold type]out[roman type] was the way I had gotten in."
L0_pawnshop is detailed.
The walltext of L0_pawnshop is "Cheap plywood."
The ceilingtext of L0_pawnshop is "Cheap plywood."
The floortext of L0_pawnshop is "The streets cobblestone surface."
L0_pawnshop is inside of L0_streets_hub_4. 

The kerosene lantern is scenery in L0_pawnshop. The description is "The lantern hanging from the ceiling gave but little light."
Understand "light" and "kerosene light" as the kerosene lantern when the location is L0_pawnshop.

The odd objects are plural-named scenery in L0_pawnshop. The description is "Apparently Tanaka had everything from abacus to zebra. From what I could see in the twilight, it was all legal merchandise, though."
Understand "object" as the odd objects when the location is L0_pawnshop.

Instead of going west when the location is L0_pawnshop:
	try going outside.

Chapter 2 - The boat rental service

L0_rental is a shop. The printed name is "Inside the Boat rental booth". The Description of L0_rental is "Little could be distinguished through the breath-taking tobacco smoke inside the booth. The only thing of interest was probably the coffee machine anyway, and its location was clearly audible. There was only the single way [bold type]out[roman type] I had already used to get in."
L0_rental is inside from L0_streets_hub_6.

The coffee machine is scenery in L0_rental. The Description is "An old apparatus in urgent need of repair with a filthy, non-matching glass pot into which the coffee trickled incessantly."
Understand "pot/glass" and "glass/coffee pot" as the coffee machine when the location is L0_rental.

Chapter 3 - The second-hand clothes shop

L-1_clothes is a shop. The printed name is "Inside 'Affordable apparel'". The description is "The business on this raft was dealing in second-hand clothes, and the variety was interesting enough. From working boots to carnival masks everything seemed to be available. They even had a changing cubicle. My boat lay alongside the raft, [bold type]outside[roman type] the shop." 
L-1_clothes is inside from L-1_canal_pier_2.

In L-1_clothes is a changing room called the cubicle. The description of the cubicle is "It was really just a small cubicle with a makeshift curtain. Inside there was a mirror."

In the cubicle is a mirror.

The merchandise is plural-named scenery in L-1_clothes. The description is "The variety of the merchandise on offer was staggering."
Understand "shoe/shoes/boot/boots/clothing/clothes/mask/masks/carnival" and "carnival masks" as the merchandise when the location is L-1_clothes.

The motor_boat is privately-named scenery in L-1_clothes. The printed name of motor_boat is "motor boat". The description of motor_boat is "The boat I had rented."
Understand "motor boat" and "boat" as the motor_boat when the Location is L-1_clothes.

The _raft is privately-named scenery in L-1_clothes. The printed name of _raft is "raft". The description of the raft is "The raft consisted of several rows of plastic barrels wired together and planked over to form a floating platform."
    
Instead of entering the motor_boat: try going outside.

Does the player mean doing something with the merchandise: it is very unlikely.

After going outside from L-1_clothes:
	say "I climbed back into my boat.";
	try entering the motor boat;
	rule succeeds.
	
After going to L-1_clothes for the first time:
	now the _man is clothed;
	now the _woman is clothed;
	continue the action.


Chapter 4 - The bordello

Section 1 - The reception

L-1_bordello_reception is a room. The printed name is "Inside 'The Little China Girl'". The description of L-1_bordello_reception is "Textile wallpapers covered the walls of this small lobby and a carpet covered the floor. The whole decoration was of the most tasteless Asian-erotica type. Cigarette smoke as thick as fog emanated from behind the curtain that covered the passageway to the [bold type]east[roman type]. The exit to the street was to the [bold type]west[roman type]."
L-1_bordello_reception is detailed.
The walltext of L-1_bordello_reception is "False brocade."
The floortext of L-1_bordello_reception is "A worn red carpet."
The ceilingtext of L-1_bordello_reception is "A kitschy abomination."

The decoration is scenery in L-1_bordello_reception. The description of the decoration is "The decoration consisted manly of fake [italic type]ming[roman type] erotica."
Understand "deco/Asia-kitsch/kitsch/tasteless/erotica/ming" and "ming erotica" as the decoration when the location is L-1_bordello_reception.
Understand "wallpaper/wallpapers" as the walls when the location is L-1_bordello_reception.
Understand "carpet" as the floor when the location is L-1_bordello_reception.

The baroque table is scenery in L-1_bordello_reception. The description is "A clumsy attempt to copy the most obvious elements of the style."

L-1_bordello_reception is down from L0_streets_hub_1.

Instead of going west when the location is L-1_bordello_reception: 
	try going up.

Before going east when the location is L-1_bordello_reception:
	try entering the passageway instead.

Before entering the passageway when the location is L-1_bordello_reception and the passageway is not clear:	
	deliver the Liao_stop quip;
	run a conversation on the Table of Liao Conversation instead.

After going when the room gone from is L-1_bordello_bar and the room gone to is L-1_bordello_reception and the passageway is not clear:
	deliver the Liao_surprise quip;
	continue the action;

Section 2 - The bar

L-1_bordello_bar is a room. The printed name is "At the bar of 'The Little China Girl'". The description of L-1_bordello_bar is "This windowless hall was two stories high and sported a gallery at the level of the first floor. One could get [bold type]up[roman type] there via a spiral staircase. A few sofas around a low table were the only furnishings except, of course, for the bar itself. The passageway to the [bold type]west[roman type] was covered by a leather curtain."
L-1_bordello_bar is detailed.
The walltext of L-1_bordello_bar is "Bricks glazed in a multicoloured pattern."
The floortext of L-1_bordello_bar is "A once-polished wooden floor."
The ceilingtext of L-1_bordello_bar is "The ceiling was wooden, with traces of paint left."

Understand "brick/bricks/multicoloured/pattern" as the walls when the location is L-1_bordello_bar.
Understand "wood/wooden/polished" as the floor when the location is L-1_bordello_bar.
Understand "paint/traces" as the ceiling when the location is L-1_bordello_bar.

Some sofas are supporters and scenery in L-1_bordello_bar. The description is "Faux-leather monstrosities, red like lipstick."
The low table is a supporter and scenery in L-1_bordello_bar. The description is "The kind with a glass pane for a table plate."
The bar is a counter and scenery in L-1_bordello_bar. The description is "The bamboo construction served two purposes: to excite oriental fantasies and to store the various fuels so essential for the operation of this business."
Understand "bamboo" as the bar when the location is L-1_bordello_bar.

Before going up when the location is L-1_bordello_bar:
	try entering the spiral stairs instead.

Before entering the spiral stairs when the location is L-1_bordello_bar:	
	deliver the bartender_no_way quip instead.
	

Section 3 - The gallery

L0_bordello_gallery is a room. The printed name is "On the gallery within 'The Little China Girl'". The description of L0_bordello_gallery is "The gallery I was standing on ran around the hall at the level of the first floor. Rooms to the [bold type]east[roman type] and [bold type]north[roman type] could be accessed from it. A spiral staircase led [bold type]down[roman type] to the bar area."

L0_bordello_gallery is detailed.
The walltext of L0_bordello_gallery is "Bricks glazed in a multicoloured pattern."
The floortext of L0_bordello_gallery is "A red carpet ran the length of the gallery."
The ceilingtext of L0_bordello_gallery is "The ceiling was wooden, with traces of paint left."

Understand "brick/bricks/multicoloured/pattern" as the walls when the location is L0_bordello_gallery.
Understand "red carpet" and "red/carpet" as the floor when the location is L0_bordello_gallery.
Understand "paint/traces" as the ceiling when the location is L0_bordello_gallery.
 
Before going down when the location is L0_bordello_gallery:
	try entering the spiral stairs instead.

Section 4 - The loo

L0_bordello_loo is a room. The printed name of L0_bordello_loo is "The loo of 'The Little China Girl'". The description of L0_bordello_loo is "This was a basic rest room. It included all the usual conveniences. A little frozen-glass window let in some light. The exit was to the [bold type]west[roman type]."
L0_bordello_loo is in the service.
L0_bordello_loo is east of L0_bordello_gallery.

Some usual conveniences are scenery in L0_bordello_loo. The description is "I had no use for all the practical appliances of this room."
Understand "loo/lavatory/toilet/basin/flush", "toilet/flush tank" and "wash/washing basin" as the usual conveniences when the location is L0_bordello_loo.

In L0_bordello_loo is a mirror.


Section 5 - Rachels Room

L0_bordello_rachel is a room. The printed name of L0_bordello_rachel is "Inside an upstairs room at 'The Little China Girl'". The description of L0_bordello_rachel is "The insufferable decoration of this room included brocade wallpapers, false stucco and a flocati carpet. The only furniture was a heart-shaped bed. The exit was to the [bold type]south[roman type]."
L0_bordello_rachel is north of L0_bordello_gallery.
L0_bordello_rachel is detailed.
The walltext of L0_bordello_rachel is "Red brocade wallpapers."
The floortext of L0_bordello_rachel is "A long-haired monstrosity."
The ceilingtext of L0_bordello_rachel is "False stucco elements."

Understand "red brocade", "brocade wallpaper" and "brocade/wallpaper" as the walls when the location is L0_bordello_rachel.
Understand "flocati carpet" and "flocati/carpet/monstrosity" as the floor when the location is L0_bordello_rachel.
Understand "stucco" and "false stucco" as the ceiling when the location is L0_bordello_rachel.

The heart-shaped bed is an enterable supporter and scenery in L0_bordello_rachel. The description of the heart-shaped bed is "It featured a quilt day cover and if I wasn't mistaken, had some mechanism to rotate the whole affair." 
A part of the heart-shaped bed is the quilt day cover. 

Chapter 5 - The transport business

Section 1 - The yard

L0_transport_yard is a room. The printed name is "Yard of 'Yano & Chou'". The description is "This was the tiniest yard that could - with a little imagination - still be used to park a lorry. 'Office' was painted on the little door in the brick wall beside the barred loading ramp to the [bold type]east[roman type]. The massive metal gate to the [bold type]south[roman type] marked the end of the property. Otherwise, there were buildings all around, so tall almost no light reached the street level."

The loading ramp is scenery in L0_transport_yard. The description is "The loading ramp was closed by a rolling shutter that didn't look like it was opened all too often."
Understand "rolling shutter" and "shutter" as the loading ramp when the location is L0_transport_yard.

Instead of going inside when the location is L0_transport_yard:
	try going east.

Section 2 - The office

L0_transport_office is a storageroom. The printed name is "Office of Yano & Chou". The Description is "No wallpaper had been wasted in the decoration of this place: the brick walls were painted white. The door to the [bold type]west[roman type] was the only exit. Otherwise The room was practically bare except for a computer terminal."

The terminal is scenery in L0_transport_office. The description is "Just your regular terminal."
Understand "computer/PC/monitor/screen/keyboard" as the terminal when the location is L0_transport_office.
The papers are plural-named scenery in L0_transport_office. The description is "Just some papers."
Understand "paper" as the papers when the location is L0_transport_office.

Understand "brick/bricks/window/windows" as the buildings when the location is L0_transport_yard.

Chapter 6 - The delivery service

L1_delivery is a shop. The printed name is "Inside 'CityTrafficking'". The Description is "This delivery service consisted of a single office with several desks with workstations on top. Though this late in the evening, only one was manned. The exit was to the [bold type]west[roman type]." L1_delivery is detailed.

L1_delivery is east of L1_streets_hub_7.

The walltext of L1_delivery is "Dry walls."
The floortext of L1_delivery is "A grey carpet."
The ceilingtext of L1_delivery is "Lightweight paneling."

The desk is a supporter and scenery. The desk is in L1_delivery. The description is "Each desk was fitted with a workstation, which included two screens."
Understand "desks/table/tables" as the desk when the location is L1_delivery.

The Navi are plural-named scenery. The Navi are in L1_delivery. The description is "'Copland OS' was the name of the operating system used on these, judging by the screen-saver. Why in the world would anyone use a screen-saver on an LCD?"
Understand "Navis/workstation/workstations/PC/PCs/Computer/Computers/screen/screens/screen-saver/OS/Copland" and "Copland OS" as the Navi when the location is L1_delivery.

Chapter 7 - The dance club

Section 1 - The front desk

L0_danceclub_frontdesk is a room. The printed name of L0_danceclub_frontdesk is "At the frontdesk of the 'Martyrium'". The description of L0_danceclub_frontdesk is "This was a rather humble reception area, decorated with a bunch of old film posters instead of a wallpaper. A steep staircase lighted by a violet neon tube in every step disappeared [bold type]down[roman type] into the darkness. To the [bold type]east[roman type] was the exit to the street. Muted bass beats emerged from the underground.".

L0_danceclub_frontdesk is west of L0_streets_hub_4.

Table of Film Titles
topic				Title				description
"À bout de souffle"		"À bout de souffle"		"A 1960 film by Jean-Luc Godard."
"Down by Law"			"Down by Law"			"A 1986 film by Jim Jarmusch."
"A brighter summer day"		"A brighter summer day"		"A 1994 film by Edward Yang."
"Tetsuo the Ironman"		"Tetsuo the Ironman"		"A 1989 film by Tsukamoto Shinya."
"Riri Shûshû no subete"		"Riri Shûshû no subete"		"A 2001 film by Iwai Shunji."
"Die dritte Generation"		"Die dritte Generation"		"A 1979 film by Reiner Werner Fassbinder."
"La Règle du jeu"		"La Règle du jeu"		"A 1939 film by Jean Renoir."
"Metropolis"			"Metropolis"			"A 1927 film by Fritz Lang."
"The Draughtman's Contract"	"The Draughtman's Contract"	"A 1982 film by Peter Greenway."
"Le Samouraï"			"Le Samouraï"			"A 1967 Film by Jean-Pierre Melville."
"Tirez Sur Le Pianiste"		"Tirez Sur Le Pianiste"		"A 1960 Film by François Truffaut."
"Tôkyô Monogatari"		"Tôkyô Monogatari"		"A 1953 Film by Ozu Yasujirô."
"2001 A Space Odyssey"		"2001: A Space Odyssey"		"A 1968 Film by Stanley Kubrick."
"Andrey Rublyov"		"Andrey Rublyov"		"A 1966 Film by Andrei Tarkovsky"		


The front desk is a counter and scenery in L0_danceclub_frontdesk. The description is "The reception desk was equally plastered with posters."
Understand "desk/reception" and "reception/frontdesk" as the front desk when the location is L0_danceclub_frontdesk.

To say list the titles:
	sort the Table of film Titles in random order;
	repeat with N running from 1 to 3:
		choose row N in the Table of Film titles;
		say "[Title entry], ".

The old posters are scenery in L0_danceclub_frontdesk. The description of the old posters is "These were all from the long-gone days of cinema...[italic type][list the titles][roman type]the posters looked genuine enough. It had surely cost a fortune to achieve that kind of retro-chic."
Understand "poster/film/films/movie/movies", "old film/movie poster/posters" and "film/movie poster/posters" as the old posters when the location is L0_danceclub_frontdesk.

Examining as a film is an action applying to one topic.
Understand "examine [text]" and "look up [text]" as examining as a film when in L0_danceclub_frontdesk.
Carry out examining as a film:
	try examining the noun. 

Before examining as a film a topic listed in the Table of Film Titles when in L0_danceclub_frontdesk:
	say "[description entry]" instead.

Before going down when the location is L0_danceclub_frontdesk:
	try entering the club stairs instead.

After entering the club stairs for the first time:
	disable the Risa_what_place quip for Risa.
	
Before entering the club stairs when the location is L0_danceclub_frontdesk and the club stairs are closed:	
	deliver the Risa_show_id quip;
	if Delivery_1 is happening:
		enable the Risa_delivery quip for Risa;
	run a conversation on the Table of Risa Conversation instead.
	
Section 2 - The dance floor

To say beatvariety:
	say "[one of]rapid[or]hysterical[or]dis-harmonic[or]apocalyptic[or]hyperactive[or]nightmarish[at random] [one of]post-industrial[or]pseudo-midi[or]robotic-voiced[or]garage-style[or]hard-core[at random] [one of]trip-hop[or]cypher-funk[or]retro-techno[or]neon-kink[or]andro-pop[at random]".

L-1_danceclub_dancefloor is a room. The printed name is "Dance floor of the 'Martyrium'". The description is "[If unvisited]I descended the stairs into the crypt-like catacombs of the Martyrium. [end if]The dance floor was packed with people engaging in rhythmic convulsions to the [beatvariety] music that played at [One of]health-wrecking[or]mind-wiping[or]deafness-inducing[or]human-repellent[at random] volume. A neon-lit staircase led [bold type]upwards[roman type] towards civilisation."

L-1_danceclub_dancefloor is detailed.
The walltext of L-1_danceclub_dancefloor is "The walls were painted black."
The floortext of L-1_danceclub_dancefloor is "A well-worn wooden dance floor."
The ceilingtext of L-1_danceclub_dancefloor is "The ceiling was home to an impressive array of lighting devices."

Understand "dance floor" as the floor when the location is L-1_danceclub_dancefloor.

Every turn when the location is L-1_danceclub_dancefloor:
	if a random chance of 3 in 7 succeeds:
		say "[One of]The whole scene was suddenly framed in erratic jump-cuts by the use of epilepsy-inducting levels of stroboscope lighting.[or]Some dancers with white lipstick were currently especially highlighted by the black light.[or]The hugely overpowered traffic light at the other end of the room flooded the dance floor in one colour at a time, alternating between pink, orange and magenta.[or]Myriads of tiny light spots in all the colours of the rainbow rotated slowly over everyone present.[or]The firework-like light battery glittered in the eyes of the night birds like all the stars of the firmament.[or]Suddenly The floor was shaking in tune with the sound of a subway train roaring past underneath.[at random]".

The music is scenery in L-1_danceclub_dancefloor. The description of the music is "Due to the conspicuous absence of any talented dancer, the music could only be heard, never seen."
The sound of the music is "The music was insufferable, certainly to my tastes and surely to my ears as well."
Understand "sound/beat/sounds/beats/trip-hop/cypherfunk/retro-techno" as the music when the location is L-1_danceclub_dancefloor.

The lighting is scenery in L-1_danceclub_dancefloor. The description of the lighting is "The usual array of coloured disco lighting."
Understand "light/lights/stroboscope/device/devices", "traffic light" and "lighting devices" as the lighting when the location is L-1_danceclub_dancefloor.

The loud-speakers are plural-named scenery in L-1_danceclub_dancefloor. The description of the loud-speakers is "Several were scattered throughout the room."
Understand "speaker/loud-speaker/speakers" and "loud speaker/speakers" as the loud-speakers when the location is L-1_danceclub_dancefloor.

The turntables are plural-named scenery in L-1_danceclub_dancefloor. The description of the turntables is "The epitome of the notion of old-school."
Understand "turntable" as the turntables when the location is L-1_danceclub_dancefloor.

The LP is scenery in L-1_danceclub_dancefloor. The description of the LP is "Vinyl? In this time and age?"
Understand "vinyl" and "vinyl LP" as the LP when the location is L-1_danceclub_dancefloor.

Before going up in L-1_danceclub_dancefloor:
	now the player is not raving. 

Chapter 8 - The black market

L-1_blackmarket is a shop. The printed name is "Inside the 'Burrow'". The description of L-1_blackmarket is "I was standing in a small vaulted room with bare brick walls and no windows, its floor littered with all sorts of things. The door to the [bold type]south[roman type] led into the sewer system."
L-1_blackmarket is detailed.
The floortext of L-1_blackmarket is "Underneath all the contraband was a surprisingly clean concrete floor."
The walltext of L-1_blackmarket is "Red brick."
The ceilingtext of L-1_blackmarket is "A vaulted brick ceiling."

The contraband is scenery in L-1_blackmarket. The description of the contraband is "I was sure I had, until now, never seen the majority of the kinds of things strewn on the floor. Some of them seemed useful, some frivolous, some outright strange."

Understand "thing/things/floor/stuff" as the contraband when the location is L-1_blackmarket.

Does the player mean examining the contraband when the location is L-1_blackmarket: it is likely.

The useful is scenery in L-1_blackmarket. The description of the useful is "Electronics, medical supplies, weapons and the like."
Understand "electronics/medical/supplies/weapons" and "medical supplies" as the useful when the location is L-1_blackmarket.

The frivolous is scenery in L-1_blackmarket. The description of the frivolous is "Pornography, sex toys, the hides of foreign animals, antiques...that kind of thing."
Understand "pornography/porn/porno/hide/hides/foreign/animals/toys/sex/antique/antiques", "foreign animal/animals/hide/hides" and "sex toys" as the frivolous when the location is L-1_blackmarket.

The strange is scenery in L-1_blackmarket. The description of the strange is "Jars full of mysterious ingredients for Chinese medicine, voodoo dolls and whatnot."

Understand "Jars/mysterious/ingredient/ingredients/medicine/voodoo/doll/dolls/whatnot", "voodoo doll/dolls", "mysterious jars" and "Chinese Medicine" as the strange when in L-1_blackmarket.

The qing chair is a supporter and scenery in L-1_blackmarket. The description of the qing chair is "A horseshoe-shaped [italic type]qienlong[roman type]-period chair made of [italic type]zhitan[roman type]."
Understand "early qing chair", "zhitan chair", "horseshoe" and "zhitan" as the qing chair when the location is L-1_blackmarket.

After going to L-1_blackmarket for the first time:
	now the _man is sewered;
	now the _woman is sewered;
	continue the action.


Chapter 9 - The boutique

L0_boutique is a shop. The printed name is "Inside 'Utsunomiya Agnieszka'". The description of L0_boutique is "It was evident from the few dresses, kimonos, shoes and hats on display that this boutique sold lady's casual and formal clothing of reasonable quality. A changing cubicle allowed customers to try on the merchandise. The exit was to the [bold type]north[roman type]."

L0_boutique is south of L0_mall_hub.

The styles are scenery in L0_boutique. The description is "I could have bought a sensible outfit for many an occasion in this shop."
Understand "merchandise/shoe/shoes/hat/hats/dress/dresses" as the styles when in L0_boutique.

The displays are scenery in L0_boutique. The description is "The display windows displayed the merchandise."
Understand "window/windows" as the displays when the location is L0_boutique.

A changing room called the cabin is in L0_boutique. The description of the cabin is "This changing room was clean and comfortable. It had a curtain and a mirror."

In the cabin is a mirror.

Chapter 10 - The medical clinic

Section 1 - The reception

L1_clinic_reception is a room. The printed name is "Inside the Dr. Cutter's clinic". The description of L1_clinic_reception is "The perfect whiteness of this reception area was broken only in the slightest possible way by the shining chrome-plated legs of the white chairs in the waiting area. And of course by a few, rather recent, advertising posters for pseudo-scientifically named medicine products and public health information campaigns. There seemed to be another room to the [bold type]west[roman type] and the elevator landing was to the [bold type]north[roman type]."
L1_clinic_reception is south of L1_mall_hub.
L1_clinic_reception is detailed.
The floortext of L1_clinic_reception is "Grey linoleum."
The walltext of L1_clinic_reception is "As white as the north pole."
The ceilingtext of L1_clinic_reception is "Entirely white."

A counter called the white counter is in L1_clinic reception. The description of the white counter is "White."

The white chairs are plural-named scenery in L1_clinic_reception. The description of the white chairs is "White, with chrome-plated legs."
Understand "chair/chairs/chrome", "chrome legs", "chrome-plated", "chrome-plated legs", "chrome-plated chair/chairs" and "chrome chair/chairs" as the white chairs when the location is L1_clinic_reception.

The medical ads are plural-named scenery in L1_clinic_reception. The description of the medical ads is "One of the posters was advertising the pecuniary benefits of becoming an organ donor."
Understand "poster/posters/advertising/ads/ad/medicine/public/information/campaign/campaigns", "public health information campaign/campaigns"and "medicine products" as the medical ads when the location is L1_clinic_reception.

Instead of going west when the location is L1_clinic_reception:
	try entering the praxis door.

Instead of entering the praxis door in the presence of the nurse when the nurse is not satisfied:
	deliver the Nurse_stop quip.

Instead of entering the praxis door in the presence of the nurse when Vaccination has happened:
	deliver the Nurse_stop quip.

Section 2 - The treatment room

L1_clinic_treatment is a room. The printed name is "In the treatment room". The description of L1_clinic_treatment is "The walls, the ceiling and the blinds in front of the windows, all white like freshly fallen snow, contrasted noticeably with the yellow-tinted plastic casings of the arcane medical machinery that occupied much of the room. The reception and waiting area was to the [bold type]east[roman type]."

The examination table is a supporter in L1_clinic_treatment. The examination table is scenery. The description of the examination table is "A padded rest protected by a sheet of paper."

The blinds are plural-named scenery in L1_clinic_treatment. The description of the blinds is "The windows were covered by blinds so effective, the room might just as well have been under ground."
Understand "window/blind/windows" as the blinds when the location is L1_clinic_treatment.

The medical machinery is scenery in L1_clinic_treatment. The description of the medical machinery is "God knows what purpose these served."
Understand "arcane/casing/case/cases/machine" and "arcane machine/machinery" as the medical machinery when the location is L1_clinic_treatment.

Chapter 11 - The artists studio

L3_studio is a shop. The printed name is "Inside 'Studio Yamaguchi'". L3_studio is south of L3_mall_hub. The description of L3_studio is "The place had the appearance of an artist's atelier of an earlier time period: a cultivated untidiness that betrayed the unsteady nature of the creative mind hard at work. Paints, brushes and other artistic utensils crowded a soiled oaken desk. Canvases of every size leaned to the wall. Various objects that reappeared on some of the paintings were crammed into the corners of the room, which was opened along its entire southern side from floor to ceiling by a panoramic window offering a splendid view of the city. In the midst of it all, an easel was set up. The only exit was to the [bold type]north[roman type]."

The soiled desk is a supporter and scenery in L3_studio. The description of the soiled desk is "This had once been a good piece of furniture, perhaps a map table or a conference desk. Now, however, it was covered by the remnants of a dozen or so accidents with oil colours."
Understand "furniture/table" as the soiled desk when the location is L3_studio.

The paints are plural-named scenery. The description of the paints is "Not just the basic hues and tones were available, but many of the other colours of the rainbow as well."
Understand "hue/hues/tone/tones/colour/colours/paint" as the paints when the location is L3_studio.
The paints are on the soiled desk.

The easel is a supporter and scenery in L3_studio. The description of the easel is "The typical scaffolding one uses to place the canvas on when painting, so as to have an appropriate working height."

The brushes are plural-named scenery. The description of the brushes is "While the large selection of brushes looked untidy to the uninformed eye, it was obvious to the knowledgeable observer that they were all properly cared for."
Understand "brush/sable" as the brushes when the location is L3_studio.
The brushes are on the soiled desk.
  
The utensils are plural-named scenery. The description of the utensils is "Everything the artist needed for his work."
Understand "utensil/tool/tools" as the utensils when the location is L3_studio.
The utensils are on the soiled desk.

The canvases are plural-named scenery in L3_studio. The description of the canvases is "Some were still unused while others had already been turned into paintings."
Understand "canvas" as the canvases when the location is L3_studio.

The paintings are plural-named scenery in L3_studio. The description of the paintings is "Amongst the many still lives, portraits and nudes there were also a few abstract works."
Understand "pictures" as the paintings when the location is L3_studio.

The still lives are plural-named scenery in L3_studio. The description of the still lives is "A wide range of sujets was covered. From flowers to foodstuffs to innate objects, a connoisseur of still lives would surely have found something worthy of his attention." 
Understand "flowers/foodstuffs/flower/innate" and "still live" as the still lives when the location is L3_studio.

The portraits are plural-named scenery in L3_studio. The description of the portraits is "These seemed to be intended for ancestral worship or possibly company boardrooms."
Understand "portrait" as the portraits when the location is L3_studio.

The abstract works are plural-named scenery in L3_studio. The description of the abstract works is "Colours and lines, regular and erratic, organic and mechanical, empty and meaningless."
Understand "abstract work/painting/paintings/works" as the abstract works when the location is L3_studio.

The picture is scenery. The picture is on the easel. The description of the picture is "The one on the easel was still no more than a blank canvas."
Understand "painting/portrait" as the picture when the location is L3_studio.
Does the player mean examining the picture when the location is L3_studio: it is likely.

Table of Curious Objects
topic		title
"mask/ritual/dance"		"a frighteningly manrayish ritual dance mask of northern Ethiopian origin"
"candle/candles/stick/sticks/silver"	"a pair of silver candle sticks, decorated in manierist fashion"
"shell/mortar/rusty/bent"		"a mortar shell from some forgotten battle field, all bent and rusty"
"ballet/shoe/lone"	"a lone ballet shoe, European size 34"
"fruit/pomegranate/dried"		"an opened pomegranate fruit, long since dried"
"vessel/glass/lalique/chipped/face/faces"	"a chipped Lalique glass vessel with faces on all sides"
"ship/bottle"		"a bottle ship, the work of a true master, detailed down to the interiors of the aft quarters"

Examining as a curiosity is an action applying to one topic.
Understand "examine [text]" and "look up [text]" as examining as a curiosity when in L3_studio.

Carry out examining as a curiosity:
	try examining the noun. 

Before examining as a curiosity a topic listed in the Table of Curious Objects when in L3_studio:
	say "It really was [title entry]." instead.

To say list the curiosities:
	sort the Table of Curious Objects in random order;
	choose row 1 in the Table of Curious Objects;
	say "[title entry], ";
	choose row 2 in the Table of Curious Objects;
	say "[title entry] and ";
	choose row 3 in the Table of Curious Objects;
	say "[title entry]". 

The curious objects are plural-named scenery in L3_studio. The description of the curious objects is "The collection included such interesting items as [list the curiosities]. But none of all that seemed worthy of further investigation to me at the time."
Understand "curious object/item", "item/object/curiosity/corner/curiosities/corners/collection" as the curious objects when the location is L3_studio.

The nudes are plural-named scenery in L3_studio. The description of the nudes is "A series of well executed acts of young girls."
Understand "nude/act/acts/girl/girls" as the nudes when the location is L3_studio.

The panorama windows are plural-named scenery in L3_studio. The description of the panorama windows is "A dazzling display of enormous matrices of lit, yet uninhabited windows, cascades of neon advertising vanishing in the distance and the pulsating red landing aids of the helicopter pads that crowned many of the skyscrapers."
Understand "windows/window/city/buildings/building/skyscraper/helicopter/lights/light/advertising/cascade/cascades/pad/pads/pulsating" as the panorama windows when the location is L3_studio.

Chapter 12 - The fish factory

Section 1 - The packing room

L0_fish_packing is a privately-named room. The printed name is "Packing room of 'Seng Heng fish packing co. ltd.'". The description of L0_fish_packing is "This hall seemed to be the end of the production line of the factory. It consisted primarily of a large and empty concrete floor, which was probably better lit in daytime as the ceiling was almost all glass. A steady flow of tin cans came down a conveyor belt that entered the room through an opening in the [bold type]eastern[roman type] wall, the door beside it presumably leading to the previous step of the production process. The room to the [bold type]south[roman type] seemed to be the office and the exit was to the [bold type]west[roman type]."
L0_fish_packing is east of L0_streets_hub_6.

L0_fish_packing is detailed.
The floortext of L0_fish_packing is "Reasonably clean concrete."
The walltext of L0_fish_packing is "The usual tiles."
The ceilingtext of L0_fish_packing is "It had many skylights."

The cardboard boxes are plural-named scenery in L0_fish_packing. The description of the cardboard boxes is "Corrugated cardboard packaging. 'Gourmet fish delicacies' was printed onto the outside."

[In L0_fish_packing is the packing tape. The indefinite article of the packing tape is "a roll of". The description of the packing tape is "Just your usual adhesive tape."]

Instead of going east in L0_fish_packing:
	try entering the factory door.

Instead of entering the factory door when the player is not hired and the location is L0_fish_packing:
	deliver the Packers_no_way quip.

Instead of going west in L0_fish_packing when the player is hired:
	deliver the Packers_no_escape quip.

Instead of going west in L0_fish_packing when the player carries at least one bucket:
	deliver the Packers_no_stealing quip.

Section 2 - The tinning room

L0_fish_tinning is a privately-named room. The printed name is "Tinning room of the fish factory". The description of L0_fish_tinning is "One half of this room was taken up by a machine that had seen better days. It was fed with tin cans still open, which were being filled with fish in the other half of the room. The machine spew out the cans again - this time soldered shut - onto a conveyor belt that carried them into the room to the [bold type]west[roman type]. To the [bold type]east[roman type] was another, even smellier room."

L0_fish_tinning is detailed.
The floortext of L0_fish_tinning is "Stained concrete."
The walltext of L0_fish_tinning is "Bare brick walls."
The ceilingtext of L0_fish_tinning is "Painted white."

The tinning machine is scenery in L0_fish_tinning. The description is "A rattly apparatus of unknown provenience and age, in serious need of maintenance."
The tinning machine has a number called production. The production is 0.

The preparation table is a supporter and scenery in L0_fish_tinning. The description is "The table had a tiled surface. The gaps between the tiles were a little moldy here and there."

On the preparation table is an oil bottle. The oil bottle is scenery. The description of the oil bottle is "A five-liter bottle of machine oil." 

In L0_fish_tinning are 10 fish.

Section 3 - The gutting room

L0_fish_gutting is a privately-named room. The printed name is "Gutting room of the fish factory". The description of L0_fish_gutting is "It was tropically hot in here. This room was so crammed, claustrophobia was bound to set in almost immediately. Not that it mattered much, because the nauseating stench of putrefication would sure enough have turned away any accidental visitor much earlier. The overworked fan in the ceiling was little more than a nuisance to the hundreds of flies that circled the room, while the floor was slippery with blood. The exit was to the [bold type]west[roman type]."
L0_fish_gutting is east of L0_fish_tinning.

L0_fish_gutting is detailed.
The floortext of L0_fish_gutting is "Soiled concrete."
The walltext of L0_fish_gutting is "Wet with condensation."
The ceilingtext of L0_fish_gutting is "Black with mold."

The gutting table is a supporter and scenery in L0_fish_gutting. The description is "An old workbench, caked with rust."

The blood is scenery in L0_fish_gutting. The description is "It wasn't just the blood, but also the many fish entrails that made the floor so slippery."
Understand "entrails" as the blood when the location is L0_fish_gutting.

The overworked fan is scenery in L0_fish_gutting. The description of the overworked fan is "A noisy little air mover, entirely insufficient for whatever its installation was trying to achieve."

The stench is scenery in L0_fish_gutting. The stench is distant. The description of the stench is "That was a little too immaterial to look at."
A distant objects rule for the stench while Smelling: rule succeeds.
The sound of the stench is "Sickening."

The flies are scenery in L0_fish_gutting.

In L0_fish_gutting is a black bucket.
In L0_fish_gutting is a red bucket.
In L0_fish_gutting is a green bucket.

On the gutting table are 25 fish.

Section 4 - The office

L0_fish_office is a privately-named room. The printed name is "Office of the fish factory". The description of L0_fish_office is "The writing desks and swivel chairs in here looked like they saw more use during the day. To the [bold type]north[roman type] was the rest of the factory."
L0_fish_office is south of L0_fish_packing.

The writing desks are plural-named scenery in L0_fish_office. The description of the writing desks is "An abomination of plywood and chrome-coloured plastic."
Understand "desk" and "writing desk" as the writing desks when the location is L0_fish_office.

The swivel chairs are plural-named scenery in L0_fish_office. The description of the swivel chairs is "Each of them tried in vain to look like a respectable piece of furniture."
Understand "swivel chair" and "chair" as the swivel chairs when the location is L0_fish_office.

Book 3 - Characters

Part 1 - General

Understand "man" as a man.
Understand "woman" as a woman.

A person can be acquainted. A person is usually not acquainted.

Part 2 - The Odakyu employee

Chapter 1 - The Character

The Odakyu employee is a man.
The Odakyu employee is in L1_station_tickets.
The initial appearance of the Odakyu employee is "Behind the ticket counter sat an Odakyû-line employee." The description of the Odakyu employee is "A uniformed station attendant."

The Odakyu employee can be peopled. The Odakyu employee is not peopled.
The Odakyu employee can be vacated. The Odakyu employee is not vacated.

Chapter 2 - The employees possessions

The Odakyu employee carries a ticket. The description of the ticket is "An open ticket for the Rail network! I could have gone anywhere with this."
The ticket unlocks the platform_gates.

Chapter 3 - The Conversation

The litany of the Odakyu employee is the Table of Odakyu Conversation.

The greeting of the Odakyu employee is Odakyu_greeting

Table of Quip Texts (continued)
quip		quiptext
selftalk		"Talking to myself was not particularly interesting."
Odakyu_greeting		"'Good evening, Miss, how can I be of service?'"
Odakyu_where_to		"'Certainly, where would you like to go?'"
Odakyu_which_train	"'Which train, Miss? Where do you want to go?'"
Odakyu_open_ticket	"'In that case I can offer you an open ticket, which you can use to get off wherever you like.'"
Odakyu_price_in_yen	"'That will be 70395 yen, please pay in cash.'"
Odakyu_come_back_later	"'Please come back anytime when you have. The ticket office is open 24 hours.'" 
Odakyu_your_welcome	"'Well, you're welcome to come back anytime, the ticket office is open 24 hours.'"
Odakyu_here_you_go	"'Thank you very much, here is your ticket, have a pleasant journey.'"
Odakyu_take_your_time	"'Well, take your time, the ticket office is open 24 hours a day.'"
Odakyu_people		"'Gotomomi is a somewhat important rail hub, many people change trains here. There is also the Arisaka mall, it has customers even at this hour. Although, to be honest, I have no idea why anyone would want to be seen here at any hour. Is there anything else I can do for you?'"
Odakyu_vacation	"'Sorry, I can't help you there, they're all way out of my league financially. I wouldn't be allowed to make any recommendations to you anyway. That'd be an unfair advertising advantage. Can I help you in any other way?'"

Table of Odakyu Conversation
prompt						response		enabled
"'I would like to buy a ticket.'"		Odakyu_where_to		1
"'When would the next train be?'"		Odakyu_which_train	1
"'Away from here.'"		Odakyu_open_ticket	0
"[italic type]'Deeper and deeper into the heart of darkness.'[roman type]"	Odakyu_open_ticket	0
"'I would like such a ticket, please.'"		Odakyu_price_in_yen	0
"'I don't have that much cash on me.'"		Odakyu_come_back_later	0
"'On second thought, I'd rather not.'"		Odakyu_your_welcome	0
"'Here you go, 70345 yen for the ticket.'"	Odakyu_here_you_go	0
"'Thanks, but I'm just looking.'"		Odakyu_take_your_time	1
"'Do you know why there are so many people about at this time of the night?'"	Odakyu_people	1
"'Do you know any of those holiday locations?'"	Odakyu_vacation	0

Before quipping when the current quip is Odakyu_greeting:
	if the Odakyu employee is peopled:
		disable the Odakyu_people quip for the Odakyu employee;
	if the Odakyu employee is vacated:
		enable the Odakyu_vacation quip for the Odakyu employee;
	say "I walked up to the ticket counter and said [italic type]'konbanwa'[roman type].[paragraph break]".

After quipping when the current quip is Odakyu_where_to:
	enable the Odakyu_open_ticket quip;
	disable the Odakyu_people quip;
	disable the Odakyu_vacation quip;
	disable the Odakyu_take_your_time quip;
	disable the Odakyu_which_train quip.

After quipping when the current quip is Odakyu_which_train:
	enable the Odakyu_open_ticket quip;
	disable the Odakyu_people quip;
	disable the Odakyu_vacation quip;
	disable the Odakyu_take_your_time quip;
	disable the Odakyu_where_to quip.

After quipping when the current quip is Odakyu_open_ticket:
	enable the Odakyu_price_in_yen quip;
	disable the Odakyu_open_ticket quip.

After quipping when the current quip is Odakyu_price_in_yen:
	if the wealth of the player >= 70395 yen:
		enable the Odakyu_here_you_go quip;
	else:
		enable the Odakyu_come_back_later quip; 
	enable the Odakyu_your_welcome quip.

After quipping when the current quip is Odakyu_here_you_go:
	enable the Odakyu_take_your_time quip;
	disable the Odakyu_your_welcome quip;
	disable the Odakyu_come_back_later quip;
	disable the Odakyu_where_to quip;
	disable the Odakyu_which_train quip;
	enable the Odakyu_people quip;
	decrease the wealth of the player by 70345 yen;
	move the ticket to the player;
	say "The employee handed me the ticket over the counter.";
	terminate the conversation.

After quipping when the current quip is Odakyu_come_back_later:
	enable the Odakyu_where_to quip;
	enable the Odakyu_which_train quip;
	enable the Odakyu_take_your_time quip;
	disable the Odakyu_your_welcome quip;
	disable the Odakyu_here_you_go quip;
	enable the Odakyu_people quip;
	terminate the conversation.

After quipping when the current quip is Odakyu_your_welcome:
	enable the Odakyu_where_to quip;
	enable the Odakyu_which_train quip;
	enable the Odakyu_take_your_time quip;
	disable the Odakyu_come_back_later quip;
	disable the Odakyu_here_you_go quip;
	enable the Odakyu_people quip;
	terminate the conversation.

After quipping when the current quip is Odakyu_take_your_time:
	enable the Odakyu_take_your_time quip;
	enable the Odakyu_people quip;
	terminate the conversation.

After quipping when the current quip is Odakyu_people:
	now the Odakyu employee is peopled.
	
After quipping when the current quip is Odakyu_vacation:
	now the Odakyu employee is not vacated.

Part 3 - Tanaka

Chapter 1 - The Character

Tanaka is a man.
Tanaka is in L0_pawnshop. The initial appearance of Tanaka is "The shadow of the proprietor was barely visible behind the lantern." The Description of Tanaka is "Tanaka (if it was him) was but a pair of eyes in the lowlight."
Understand "proprietor/shadow/eyes/pair" and "pair of eyes" as Tanaka when the location is L0_pawnshop.

Tanaka can be peopled. Tanaka is not peopled.
Tanaka can be worked. Tanaka is not worked.

Chapter 2 - Tanakas possessions

Tanaka carries a flashlight. The flashlight is a device. The flashlight is not lit. The description of the flashlight is "A powerful flashlight." The flashlight is sell-able. The minimum value of the flashlight is 300 yen. The desired value of the flashlight is 900 yen.

Understand "torch/light" as the flashlight.

Tanaka carries some pliers. The pliers are plural-named. The pliers are a cutter. The description of the pliers is "A pair of heavy duty wire cutters." The indefinite article of the pliers is "a pair of". The pliers are not sell-able. The minimum value of the pliers is 400 yen. The desired value of the pliers is 1000 yen.

Understand "wire cutter/cutters" as the pliers.

After switching on the flashlight:
	say "I switched on the flashlight.";
	now the flashlight is lit.
After switching off the flashlight:
	say "I switched off the flashlight.";
	now the flashlight is unlit.
	
After going from L-1_sewer_junction_1 to L-1_canal_lock:
	if the player carries the lit flashlight:
		now the flashlight is switched off;
		now the flashlight is unlit;
		say "I switched off the flashlight as I left the sewers.";
	continue the action.

Check switching on the flashlight: 
	if the location is not in the warrens:
		say "What for? I could see perfectly well." instead.

Chapter 3 - The Conversation

The litany of Tanaka is the Table of Tanaka Conversation.

The greeting of Tanaka is Tanaka_greeting

Table of Quip Texts (continued)
quip			quiptext
Tanaka_greeting		"'Hello, honey, what can I do for you?'"
Tanaka_just_looking	"'Always looking, never buying...please come around another time, I get interesting new things all the time.'"
Tanaka_buy_something	"[one of]Tanaka rubbed his chin.[or]Tanaka smiled to himself.[or]Tanaka scratched his ear.[at random]"
Tanaka_not_interested	"'Thats too bad. Something else I can do for you?'"
Tanaka_insulted		"[one of]Tanaka rubbed his chin.[or]Tanaka smiled to himself.[or]Tanaka scratched his ear.[at random]"
Tanaka_barter_up	"[one of]Tanaka rubbed his chin.[or]Tanaka smiled to himself.[or]Tanaka scratched his ear.[at random]"
Tanaka_accept_buy	"'OK, that sounds like a fair deal to me.'"
Tanaka_dont_want_it	"'Pity that. Maybe something else?'"
Tanaka_here_you_go	"'Thank you very much, anything else?'"
Tanaka_sell_something	"[one of]Tanaka rubbed his chin.[or]Tanaka smiled to himself.[or]Tanaka scratched his ear.[at random]"
Tanaka_not_selling	"'What a pity. Anything else?'"
Tanaka_barter_down	"[one of]Tanaka rubbed his chin.[or]Tanaka smiled to himself.[or]Tanaka scratched his ear.[at random]"
Tanaka_not_selling_it	"'Thats too bad, but maybe you want something else?'"
Tanaka_accept_sell	"'Here you go, [ask value]. Can I do anything else for you?'"
Tanaka_people		"'Some will be on their way home from work, you know, businessmen. As for the rest: I guess they are all here for their entertainment. Gambling, drugs, prostitution, the black market: there are so many distractions. Anything else?'"
Tanaka_work		"'I'm sure Madame Liao will pimp you out. But wait, you smell too nice for that place. Maybe you can find some part-time work. What else can I do for you?'"
Tanaka_delivery		"'Aha. Finally the man is starting to pay off his debt.'"
Tanaka_sign		"'Since you said pretty please...here you go.'"

Table of Tanaka Conversation
prompt								response		enabled
"'Nothing, thanks. I'm just looking'"				Tanaka_just_looking	1
"'I would like to buy something.'"				Tanaka_buy_something	1
"'I would like to sell something.'"				Tanaka_sell_something	1
"'No, thanks. I'm not interested.'"				Tanaka_not_interested	0
"'I'd give you [insult value] for it.'"				Tanaka_insulted		0
"'I'd give you [bid value] for it.'"				Tanaka_barter_up	0
"'I'll give you [ask value] for it.'"				Tanaka_accept_buy	0
"'On second thought, I don't want it after all.'"		Tanaka_dont_want_it	0
"'Here you go, [ask value].'"					Tanaka_here_you_go	0
"'No, I'm not selling that.'"					Tanaka_not_selling	0
"'I'd want [ask value] for that.'"				Tanaka_barter_down	0
"'On second thought, I'm not selling it after all.'"		Tanaka_not_selling_it	0
"'OK, deal, [ask value] for [the sell_item].'"			Tanaka_accept_sell	0
"'Do you know why there are so many people about at this time of the night?'"	Tanaka_people	1
"'Do you know where I could find some work around here?'"	Tanaka_work	1
"'I have a delivery for you from Yamaguchi-san.'"		Tanaka_delivery		0
"'Would you sign here please.'"					Tanaka_sign		0

Before quipping when the current quip is Tanaka_greeting:
	if Tanaka is peopled:
		disable the Tanaka_people quip for Tanaka;
	if Tanaka is worked: 
		disable the Tanaka_work quip for Tanaka;
	if Delivery_3 is happening:
		enable the Tanaka_delivery quip for Tanaka;
	say "I said [italic type]'konbanwa'[roman type] to the pair of eyes glittering in the shadow.[paragraph break]".

After quipping when the current quip is Tanaka_just_looking:
	enable the Tanaka_buy_something quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_just_looking quip;
	enable the Tanaka_people quip;
	enable the Tanaka_work quip;
	terminate the conversation.

After quipping when the current quip is Tanaka_buy_something:
	let X be the last_offered_item;
	if the number of sell-able not wearable things carried by the Tanaka > 1:
		while X is the last_offered_item:
			now X is a random sell-able not wearable thing carried by Tanaka;
		now buy_item is X;
	else:
		now buy_item is a random sell-able not wearable thing carried by Tanaka;
	if buy_item is nothing:
		say "'I don't think I have anything on sale you'd be interested in. Do you want to sell anything?'[paragraph break]";
	else:
		now ask value is ((the desired value of buy_item / 70) * a random number between 80 and 100) to the nearest 100 yen;
		now bid value is ((the desired value of buy_item / 70) * a random number between 40 and 60) to the nearest 100 yen;
		now insult value is ((the minimum value of buy_item / 70) * a random number between 70 and 90) to the nearest 10 yen;
		disable the Tanaka_buy_something quip;
		disable the Tanaka_sell_something quip;
		disable the Tanaka_just_looking quip;
		disable the Tanaka_people quip;
		disable the Tanaka_work quip;
		enable the Tanaka_not_interested quip;
		enable the Tanaka_insulted quip;
		enable the Tanaka_barter_up quip;
		enable the Tanaka_accept_buy quip;
		say "'You might be interested in [the buy_item] I have here.'[paragraph break]".
		
After quipping when the current quip is Tanaka_sell_something:
	let Y be the last_wanted_item;
	if the number of sell-able not wearable things carried by the player > 1:
		while Y is the last_wanted_item:
			now Y is a random sell-able not wearable thing carried by the player;
		now sell_item is Y;
	else:
		now sell_item is a random sell-able not wearable thing carried by the player;
	if sell_item is nothing:
		say "'I don't think you have anything on you that I'd be interested in. Do you want to buy anything?'[paragraph break]";
	else:
		now ask value is ((the desired value of sell_item / 100) * a random number between 100 and 120) to the nearest 100 yen;
		disable the Tanaka_buy_something quip;
		disable the Tanaka_sell_something quip;
		disable the Tanaka_just_looking quip;
		disable the Tanaka_people quip;
		disable the Tanaka_work quip;
		enable the Tanaka_not_selling quip;
		enable the Tanaka_barter_down quip;
		say "'I might be interested in [the sell_item] you are carrying.'[paragraph break]";

After quipping when the current quip is Tanaka_not_interested:
	now the last_offered_item is the buy_item;
	disable the Tanaka_insulted quip;
	disable the Tanaka_barter_up quip;
	disable the Tanaka_accept_buy quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_just_looking quip.
	
After quipping when the current quip is Tanaka_not_selling:
	now the last_wanted_item is the sell_item;
	disable the Tanaka_barter_down quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_just_looking quip.
	
After quipping when the current quip is Tanaka_insulted:
	if a random chance of 4 in 5 succeeds:
		now the last_offered_item is the buy_item;
		disable the Tanaka_not_interested quip;
		disable the Tanaka_barter_up quip;
		disable the Tanaka_accept_buy quip;
		enable the Tanaka_buy_something quip;
		enable the Tanaka_sell_something quip;
		enable the Tanaka_just_looking quip;
		say "'No deal. Anything else?'[paragraph break]";
	else:
		disable the Tanaka_not_interested quip;
		disable the Tanaka_barter_up quip;
		disable the Tanaka_accept_buy quip;
		now the ask value is the insult value;
		enable the Tanaka_here_you_go quip;
		enable the Tanaka_dont_want_it quip;
		say "'Yeah, that sounds about right.'[paragraph break]".
		
Before quipping when the current quip is Tanaka_barter_up:
	now ask value is (((ask value / 100) * a random number between 80 and 95) to the nearest 10 yen);
	now bid value is (((bid value / 100) * a random number between 105 and 120) to the nearest 10 yen);
	if ask value <= bid value:
		now the last_wanted_item is the sell_item;
		disable the Tanaka_not_interested quip;
		disable the Tanaka_barter_up quip;
		disable the Tanaka_accept_buy quip;
		enable the Tanaka_buy_something quip;
		enable the Tanaka_sell_something quip;
		enable the Tanaka_just_looking quip;
		say "'I see, we won't be agreeing on a price. Anything else I can do for you?'[paragraph break]";
	else:
		disable the Tanaka_insulted quip;
		enable the Tanaka_barter_up quip;
		say "'I think [ask value] would be a fairer price.'[paragraph break]".
		

After quipping when the current quip is Tanaka_barter_down:
	now ask value is (((ask value / 100) * a random number between 60 and 80) to the nearest 10 yen);
	if ask value < ((the desired value of sell_item / 100) * 67):
		disable the Tanaka_not_selling quip;
		enable the Tanaka_not_selling_it quip;
		enable the Tanaka_accept_sell quip;
		say "'Tell you what: I'll give you [ask value] for [the sell_item].'[paragraph break]";
	else:
		disable the Tanaka_not_selling quip;
		enable the Tanaka_barter_down quip;
		enable the Tanaka_not_selling_it quip;
		say "'Thats asking too much, cut it down for me a bit, will you?'[paragraph break]".
		
After quipping when the current quip is Tanaka_accept_buy:
	now the last_wanted_item is the buy_item;
	disable the Tanaka_not_interested quip;
	disable the Tanaka_insulted quip;
	disable the Tanaka_barter_up quip;
	if bid value <= the wealth of the player:
		enable the Tanaka_here_you_go quip;
	enable the Tanaka_dont_want_it quip.
	
After quipping when the current quip is Tanaka_accept_sell:
	now the last_offered_item is the sell_item;
	disable the Tanaka_not_selling_it quip;
	disable the Tanaka_not_selling quip;
	increase the wealth of the player by ask value;
	now the desired value of sell_item is ask value;
	move sell_item to Tanaka;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_just_looking quip;
	say "I handed over [the sell_item].[paragraph break]".
	
After quipping when the current quip is Tanaka_dont_want_it:
	now the last_offered_item is the buy_item;
	disable the Tanaka_not_interested quip;
	disable the Tanaka_insulted quip;
	disable the Tanaka_barter_up quip;
	disable the Tanaka_accept_buy quip;
	disable the Tanaka_here_you_go quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_just_looking quip.
	
After quipping when the current quip is Tanaka_not_selling_it:
	now the last_wanted_item is the sell_item;
	disable the Tanaka_not_selling quip;
	disable the Tanaka_not_selling_it quip;
	disable the Tanaka_barter_down quip;
	disable the Tanaka_here_you_go quip;
	disable the Tanaka_accept_sell quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_just_looking quip.
	
After quipping when the current quip is Tanaka_here_you_go:
	now the last_wanted_item is the buy_item;
	decrease the wealth of the player by bid value;
	now the desired value of buy_item is ask value;
	move buy_item to the player;
	disable the Tanaka_dont_want_it quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_just_looking quip;
	say "Tanaka handed me [the buy_item].[paragraph break]".
	
After quipping when the current quip is Tanaka_people:
	now Tanaka is peopled;
	if Tanaka is not worked:
		enable the Tanaka_work quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_just_looking quip.
	
After quipping when the current quip is Tanaka_work:
	now Tanaka is worked;
	if Tanaka is not peopled:
		enable the Tanaka_people quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_just_looking quip.

After quipping when the current quip is Tanaka_delivery:
	say "I handed him the painting.[paragraph break]";
	move parcel_3 to Tanaka;
	disable the Tanaka_buy_something quip;
	disable the Tanaka_sell_something quip;
	disable the Tanaka_work quip;
	disable the Tanaka_people quip;
	disable the Tanaka_just_looking quip;
	enable the Tanaka_sign quip.

After quipping when the current quip is Tanaka_sign:
	say "He signed on the signing pad.[paragraph break]";
	now the address of the signpad is "Pickup at:[line break]The Little China Girl[line break]Shitamachi-dôri 5GX-CVL.";
	enable the Liao_pickup quip for Madame Liao;
	disable the Liao_work quip for Madame Liao;
	if Tanaka is not worked:
		enable the Tanaka_work quip;
	if Tanaka is not peopled:
		enable the Tanaka_people quip;
	enable the Tanaka_buy_something quip;
	enable the Tanaka_sell_something quip;
	enable the Tanaka_just_looking quip;
	terminate the conversation.


Part 4 - Jiahui

Chapter 1 - The Character

Jiahui is a woman. Jiahui is in L-1_clothes. The printed name of Jiahui is "the chinese woman". The initial appearance is "The staff consisted of a lone Chinese woman, already in her sixties." The description of Jiahui is 
"Her hair was nearly all white."

Understand "staff/chinese" and "chinese woman" as Jiahui when the location is L-1_clothes.

Jiahui can be peopled. Jiahui is not peopled.
Jiahui can be worked. Jiahui is not worked.

Chapter 2 - Jiahuis possessions

Jiahui carries clothing called an overall. The printed name of the overall is "boiler suit". The overall is sell-able. The overall is fitting. The minimum value of the overall is 1800 yen. The desired value of the overall is 3500 yen. The description of the overall is "An orange working coverall."
Understand "coverall/jumpsuit/boiler/suit" and "boiler/jump suit" as the overall.

Jiahui carries footwear called some working boots. The working boots are sell-able. The working boots are fitting. The minimum value of the working boots is 1400 yen. The desired value of the working boots is 2200 yen. The description is "Solid ankle-high boots."

Understand "boot/boots" as the working boots.

Chapter 3 - The conversation

The litany of Jiahui is the Table of Jiahui Conversation.

The greeting of Jiahui is Jiahui_greeting

Table of Quip Texts (continued)
quip			quiptext
Jiahui_greeting		"'Good evening, Miss. Can I help you?'"
Jiahui_just_looking	"'Just tell me when you want something. By the way, even if you couldn't find what all you were looking for this time, it'll be worth to come again. I get new merchandise every day.'"
Jiahui_buy_something	"The Woman ruffled through some clothes."
Jiahui_sell_something	"The Woman corrected a crease in some textile."
Jiahui_want_buy		"'[The buy_item] costs [ask value].'"
Jiahui_not_buying	"'Thats too bad for you. Anything else?'"
Jiahui_insulted		"The Woman corrected a crease in some textile."
Jiahui_barter_up	"The Woman inspected an article of clothing."
Jiahui_barter_down	"The Woman ruffled through some clothes."
Jiahui_accept_sell	"'Thank you. Anything else you want?'"
Jiahui_not_selling	"'Such a pity. Anyhow, is there anything else you want?'"
Jiahui_here_you_go	"'Thank you for your patronage. Anything else?'"
Jiahui_work		"'Hmmm...maybe you could try the courier service next to the train station. Anything else?'"
Jiahui_people		"'They've all come here to find something.'"
Jiahui_find		"'They certainly don't.'"	
Jiahui_look		"'No. It cannot be found here.'"
Jiahui_where		"'Who am I to know? Can I help you in any other way?'"

Table of Jiahui Conversation
prompt								response		enabled
"'No, thanks. I'm just looking'"				Jiahui_just_looking	1
"'I would like to buy some clothing.'"				Jiahui_buy_something	1
"'I would like to sell some clothing.'"				Jiahui_sell_something	1
"'How much for the [buy_item]?'"				Jiahui_want_buy		0
"'I'm not interested in the [buy_item].'"			Jiahui_not_buying	0
"'How about I give you [insult value] for it.'"			Jiahui_insulted		0
"'[bid value] seems like a fairer price.'"			Jiahui_barter_up	0
"'OK, here you go: [ask value] for [the buy_item].'"		Jiahui_here_you_go	0
"'On second thought, I'm not selling.'"				Jiahui_not_selling	0
"'No way, I want more money for that.'"				Jiahui_barter_down	0 
"'Fine, thats a deal.'"						Jiahui_accept_sell	0
"'Do you know where I could find some work around here?'"	Jiahui_work		1
"'Do you know why there are so many people about at this time of the night?'"	Jiahui_people	1
"'Do you know what they're looking for?'"		Jiahui_find	0		
"'Do they find what they are looking for?'"	Jiahui_look	0
"'Where can it be found?'"	Jiahui_where	0

Before quipping when the current quip is Jiahui_greeting:
	if Jiahui is peopled:
		disable the Jiahui_people quip for Jiahui;
	if Jiahui is worked:
		disable the Jiahui_work quip for Jiahui;
	say "I said [italic type]'nihao'[roman type] to the Chinese woman.[paragraph break]".

After quipping when the current quip is Jiahui_buy_something:
	disable the Jiahui_work quip;
	disable the Jiahui_people quip;
	disable the Jiahui_sell_something quip;
	disable the Jiahui_just_looking quip;
	let X be the last_offered_item;
	if the number of wearable sell-able things carried by Jiahui > 1:
		while X is the last_offered_item:
			now X is a random sell-able wearable fitting thing carried by Jiahui;
		now buy_item is X;
	else:
		now buy_item is a random wearable sell-able fitting thing carried by Jiahui;
	if buy_item is nothing:
		say "'I'm sorry, I don't think I have anything fitting your size at the moment. Maybe something else?'[paragraph break]";
		enable the Jiahui_sell_something quip;
		enable the Jiahui_just_looking quip;
	else:
		now ask value is ((the desired value of buy_item / 70) * a random number between 85 and 100) to the nearest 100 yen;
		now bid value is ((the desired value of buy_item / 70) * a random number between 50 and 65) to the nearest 100 yen;
		now insult value is ((the minimum value of buy_item / 70) * a random number between 75 and 90) to the nearest 100 yen;
		say "'How about this [buy_item]? It might fit you.'[paragraph break]";
		enable the Jiahui_want_buy quip;
		enable the Jiahui_not_buying quip.

After quipping when the current quip is Jiahui_sell_something:
	disable the Jiahui_work quip;
	disable the Jiahui_people quip;
	disable the Jiahui_buy_something quip;
	disable the Jiahui_just_looking quip;
	let Y be the last_wanted_item;
	if the number of wearable sell-able things carried by the player > 1:
		while Y is the last_wanted_item:
			now Y is a random sell-able wearable thing carried by the player;
		now sell_item is Y;
	else:
		now sell_item is a random wearable sell-able thing carried by the player;
	if sell_item is nothing:
		say "'I can't let you leave my shop naked, now can I?'[paragraph break]";
		enable the Jiahui_buy_something quip;
		enable the Jiahui_just_looking quip;
	else:
		now bid value is ((the minimum value of sell_item / 100) * a random number between 105 and 120) to the nearest 100 yen;
		now the last_wanted_item is sell_item;
		enable the Jiahui_not_selling quip;
		enable the Jiahui_barter_down quip;
		enable the Jiahui_accept_sell quip;
		say "'I could give you [bid value] for [the sell_item] you are carrying.'[paragraph break]".
		

After quipping when the current quip is Jiahui_barter_down:
	now bid value is (((bid value / 100) * a random number between 115 and 130) to the nearest 100 yen);
	if bid value < ((the desired value of sell_item / 100) * 67):
		enable the Jiahui_barter_down quip;
		say "'OK, I'll give you [bid value] for [the sell_item].'[paragraph break]";
	else:
		disable the Jiahui_not_selling quip;
		disable the Jiahui_accept_sell quip;
		enable the Jiahui_buy_something quip;
		enable the Jiahui_sell_something quip;
		enable the Jiahui_just_looking quip;
		say "'Really now, thats asking too much. But maybe I can do something else for you?'[paragraph break]".

After quipping when the current quip is Jiahui_accept_sell:
	now the last_wanted_item is sell_item;
	move sell_item to Jiahui;
	increase the wealth of the player by bid value;
	disable the Jiahui_barter_down quip;
	disable the Jiahui_not_selling quip;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_sell_something quip;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_just_looking quip.
	
After quipping when the current quip is Jiahui_not_selling:
	now the last_wanted_item is sell_item;
	disable the Jiahui_barter_down quip;
	disable the Jiahui_accept_sell quip;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_sell_something quip;
	enable the Jiahui_just_looking quip.

After quipping when the current quip is Jiahui_want_buy:
	enable the Jiahui_insulted quip;
	enable the Jiahui_barter_up quip;
	if bid value <= the wealth of the player:
		enable the Jiahui_here_you_go quip;
	enable the Jiahui_not_buying quip.
				
After quipping when the current quip is Jiahui_insulted:
	if a random chance of 4 in 5 succeeds and insult value <= the wealth of the player:
		now the last_offered_item is buy_item;
		disable the Jiahui_not_buying quip;
		disable the Jiahui_barter_up quip;
		disable the Jiahui_here_you_go quip;
		enable the Jiahui_buy_something quip;
		enable the Jiahui_sell_something quip;
		enable the Jiahui_just_looking quip;
		say "'Do you want to insult me? Anything else you want?'[paragraph break]";
	else:
		disable the Jiahui_barter_up quip;
		now the ask value is the insult value;
		enable the Jiahui_not_buying quip;
		if ask value <= the wealth of the player:
			enable the Jiahui_here_you_go quip;
		say "'Yeah, that sounds about right.'[paragraph break]".
		
After quipping when the current quip is Jiahui_barter_up:
	now ask value is (((ask value / 100) * a random number between 80 and 95) to the nearest 10 yen);
	now bid value is (((bid value / 100) * a random number between 105 and 120) to the nearest 10 yen);
	if ask value <= bid value:
		now the last_offered_item is buy_item;
		disable the Jiahui_not_buying quip;
		disable the Jiahui_barter_up quip;
		disable the Jiahui_here_you_go quip;
		disable the Jiahui_insulted quip;
		enable the Jiahui_buy_something quip;
		enable the Jiahui_sell_something quip;
		enable the Jiahui_just_looking quip;
		say "'This way we won't get anywhere. Is there anything else I can do for you?'[paragraph break]";
	else:
		disable the Jiahui_insulted quip;
		enable the Jiahui_barter_up quip;
		if ask value <= the wealth of the player:
			enable the Jiahui_here_you_go quip;
		say "'I want [ask value] for it.'[paragraph break]".

After quipping when the current quip is Jiahui_here_you_go:
	now the last_offered_item is buy_item;
	decrease the wealth of the player by ask value;
	now the desired value of buy_item is ask value;
	move buy_item to the player;
	disable the Jiahui_not_buying quip;
	disable the Jiahui_insulted quip;
	disable the Jiahui_barter_up quip;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_sell_something quip;
	enable the Jiahui_just_looking quip;
	say "The woman handed me [the buy_item].[paragraph break]".

After quipping when the current quip is Jiahui_not_buying:
	now the last_offered_item is buy_item;
	disable the Jiahui_want_buy quip;
	disable the Jiahui_insulted quip;
	disable the Jiahui_barter_up quip;
	disable the Jiahui_here_you_go quip;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_sell_something quip;
	enable the Jiahui_just_looking quip.

After quipping when the current quip is Jiahui_just_looking:
	enable the Jiahui_work quip;
	enable the Jiahui_people quip;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_sell_something quip;
	enable the Jiahui_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Jiahui_work:
	now Jiahui is worked;
	if Jiahui is not peopled:
		enable the Jiahui_people quip for Jiahui;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_sell_something quip;
	enable the Jiahui_just_looking quip.

After quipping when the current quip is Jiahui_people:
	now Jiahui is peopled;
	disable the Jiahui_work quip;
	disable the Jiahui_buy_something quip;
	disable the Jiahui_sell_something quip;
	disable the Jiahui_just_looking quip;
	enable the Jiahui_find quip;
	enable the Jiahui_look quip.
	
After quipping when the current quip is Jiahui_look:
	enable the Jiahui_where quip;
	
After quipping when the current quip is Jiahui_where:
	disable the Jiahui_find quip;
	if Jiahui is not worked:
		enable the Jiahui_work quip for Jiahui;
	enable the Jiahui_buy_something quip;
	enable the Jiahui_sell_something quip;
	enable the Jiahui_just_looking quip.

Part 5 - Marlow

Chapter 1 - The Character

Marlow is a man.
Marlow is in L0_rental. The printed name of Marlow is "the sea bear". The initial appearance of Marlow is "A pipe-smoking old sea-bear manned the bridge of the rental service." The description of Marlow is "He was wearing a little captain's cap and a navy blue sweater."

Understand "sea-bear/seaman" and "sea bear" as Marlow.

Marlow can be worked. Marlow is not worked.
Marlow can be peopled. Marlow is not peopled.

Chapter 2 - Marlows possessions

Marlow wears a hat called the captain's cap.
Marlow wears clothing called the navy blue sweater.

Marlow carries a pipe.
Marlow carries a boat key. The description of the boat key is "A common ignition key."

Does the player mean doing something with the boat key: it is very unlikely.

Chapter 3 - The conversation

The litany of Marlow is the Table of Marlow Conversation.

The greeting of Marlow is Marlow_greeting

Table of Quip Texts (continued)
quip			quiptext
Marlow_greeting		"[If Endgame is happening]'Thank you for bringing back my daughter. I would like to express my gratitude in some way. What can I do for you?'[else]'And good evening to you, young lady. What can I do for you?'[end if] [if Marlow is acquainted]Marlow[else]the man greeted me."
Marlow_just_looking	"'Well, it was a pleasure to meet you, anyway.'"
Marlow_rent_boat	"'You have certainly come to the right place. I happen to have a motor boat available.'"
Marlow_tell_price	"'The boat is 950 yen per day. But you'll have to leave a deposit for the keys as well.'"
Marlow_what_deposit	"The sea-bear puffed some smoke from his pipe."
Marlow_what_else	"He took a quick look at my possessions."
Marlow_not_interested	"'What a shame. Come back whenever you really want to rent a boat.'" 
Marlow_here_you_go	"'Thank you very much, here is the key. Bring it back to me to get your deposit back. The boat is down at the pier.'"
Marlow_key_return	"'Thank you. Here is your deposit back. Come back any time you need a boat.'"
Marlow_work	"'You could try the fish factory across the street for a start. What else can I do for you?'"
Marlow_people	"'They are seduced by the glittering neon lights, by the overt luxury, by the scandalous offer on a silver plate of a life that was until then mere conjecture to them.'"
Marlow_they	"'The shadows of men you see in the streets. Mind you, they, too, were once human beings like you and me.'"
Marlow_stay	"'By the time they realise the scam, it's too late, because the shame of failure and the fear of rejection will soon destroy a man's impetus. Eaten by remorse, they believe they can no longer go anywhere else. And that, not the money, or the obscenity, or even the addiction is the reason they stay.'"
Marlow_everyone	"'No, not everyone. There are those who eventually come to accept they have to make up for their initial losses and choose to make the best out of the situation.'"
Marlow_self	"'Of course. It's not something I'm proud of. But on the other hand, I'm only running a boat rental here. That's as honest as it gets around these shores. The vain feeling of being a better man for it: I hold onto it like a straw. Others aren't quite as scrupulous.'"
Marlow_living	"'By doing whatever it takes, I'm afraid. Many of these types aren't burdened by a conscience any more.'"
Marlow_example 	"'It's better if I say no more on this - [Italic type]'it was written I should remain loyal to the nightmare of my choice.'[roman type] What else can I do for you?'"
Marlow_Rachel	"'I used to have half a dozen more. But they are all gone now. This is the only one left.'"
Marlow_tough_times	"'Not in the way you mean. I didn't have time to keep up with the maintenance recently, so I sold them to someone who does.'"
Marlow_single_boat		"'No, not really. I may have to quit soon. But what does it matter? I won't sell this boat anyway. All the others, but not this one.'"
Marlow_this_boat	"'Because it doesn't belong to me. It belongs to my daughter.'"
Marlow_reasons	"'Unfortunately, I won't be able to ask her about that.'"
Marlow_daughter	"'She ran away from home.'"
Marlow_where		"'The world is a big place. Not just for a 13-year-old girl but apparently also for an old man. I looked for six weeks every day and couldn't find her. I don't know where else I should look. Now I am just waiting for her to come back.'"
Marlow_why		"'Why do young girls run away from home? I guess I didn't offer her the kind of life she would have liked. This is not a glamorous palace, as you can see. In the eyes of a 13-year old that's quite unacceptable. Or maybe I'm wrong and it was just her general feeling of all-encompassing ennui.'"
Marlow_how_long	"'Nine month. You see why I cannot sell my last boat now. What else can I do for you?'"
Marlow_money	"'I don't have much, but I'll gladly give it to you. Will 550000 yen be enough?'"
Marlow_cannot_accept	"'But you should. It's really too little for my daughter's safe return.'"
Marlow_enough	"'Here you go. Treat yourself to something nice.'"

Table of Marlow Conversation
prompt								response		enabled
"'Oh, nothing really, thanks.'"					Marlow_just_looking	1
"'I would like to rent a boat.'"				Marlow_rent_boat	1
"'How much for the motor boat?'"				Marlow_tell_price	0
"'What will you accept as a deposit?'"				Marlow_what_deposit	0
"'I'd like to keep that. How about something else?'"		Marlow_what_else	0
"'I'm not interested in renting the boat after all.'"		Marlow_not_interested	0
"'Okay, here you go: 950 yen and [the sell_item].'"		Marlow_here_you_go	0
"'I brought back the key.'"					Marlow_key_return	0
"'Do you know where I could find some work around here?'"	Marlow_work		1
"'Do you know why there are so many people about at this time of the night?'"	Marlow_people	1
"'Who are they?'"	Marlow_they	0	
"'Why do they stay?'"	Marlow_stay	0
"'Surely not everyone falls for the allures of Gotomomi city?'"	Marlow_everyone	0	
"'Would you include yourself there?'"	Marlow_self	0
"'How do they make a living?'"	Marlow_living	0
"'Like, for example, who?'"	Marlow_example	0
"'Is the 'Rachel' your only boat?'"	Marlow_rachel	0
"'Tough times?'"	Marlow_tough_times	0
"'And you can make a living renting out a single boat?'"	Marlow_single_boat	0
"'Why would you keep just this boat?'"	Marlow_this_boat	0
"'I'm sure she'd agree to sell if you told her your reasons.'"	Marlow_reasons	0
"'Have you asked her what she thinks about it?'"	Marlow_reasons	0
"'I see. What happened?'"		Marlow_daughter	0
"'Do you know where she might have gone?'"	Marlow_where		0
"'Why? Why did she run away?'"	Marlow_why	0
"'How long have you been waiting?'"	Marlow_how_long	0
"'Pardon me for saying it so bluntly, but money would help.'"	Marlow_money	0
"'Then I shall accept your gratitude gladly.'"		Marlow_enough	0
"'I cannot accept that much.'"		Marlow_cannot_accept	0

Before quipping when the current quip is Marlow_greeting:
	if Endgame is happening:
		disable the Marlow_just_looking quip for Marlow;
		disable the Marlow_key_return quip for Marlow;
		disable the Marlow_work quip for Marlow;
		disable the Marlow_people quip for Marlow;
		disable the Marlow_rent_boat quip for Marlow;
		enable the Marlow_money quip for Marlow;
	if Marlow is worked:
		disable the Marlow_work quip for Marlow;
	if Marlow is peopled:
		disable the Marlow_people quip for Marlow;
	if the player is not carrying the boat key:
		disable the Marlow_key_return quip for Marlow;
	else if the motor boat is rented:
		disable the Marlow_rent_boat quip for Marlow;
	say "I said [italic type]'good evening'[roman type] to the sea-bear.[paragraph break]".
	
After quipping when the current quip is Marlow_rent_boat:
	disable the Marlow_work quip;
	disable the Marlow_people quip;
	disable the Marlow_rachel quip;
	disable the Marlow_just_looking quip;
	enable the Marlow_tell_price quip;
	enable the Marlow_not_interested quip.

After quipping when the current quip is Marlow_tell_price:
	enable the Marlow_what_deposit quip;

After quipping when the current quip is Marlow_what_deposit:
	let Y be the last_wanted_item;
	if the number of sell-able things carried by the player > 1:
		while Y is the last_wanted_item:
			now Y is a random sell-able thing carried by the player;
		now sell_item is Y;
	else:
		now sell_item is a random sell-able thing carried by the player;
	if sell_item is nothing:
		say "'I don't think you have anything on you I would accept, I'm sorry'[paragraph break]";
		disable the Marlow_not_interested quip;
		disable the Marlow_what_else quip;
		enable the Marlow_just_looking quip;
		enable the Marlow_people quip;
		enable the Marlow_work quip;		
		enable the Marlow_rent_boat quip;
		enable the Marlow_just_looking quip;
		enable the Marlow_key_return quip;
		if the player is boated:
			enable the Marlow_rachel quip for Marlow;
		terminate the conversation;
	else: 
		say "'Lets see, how about [the sell_item] you are carrying?'[paragraph break]";
	if the player is carrying something that is not sell_item:
		now the last_wanted_item is sell_item;
		enable the Marlow_what_else quip;
	if the wealth of the player >= 950 yen:
		enable the Marlow_here_you_go quip.

After quipping when the current quip is Marlow_what_else:
	let Y be the last_wanted_item;
	if the number of sell-able things carried by the player > 1:
		while Y is the last_wanted_item:
			now Y is a random sell-able thing carried by the player;
		now sell_item is Y;
	else:
		now sell_item is a random sell-able thing carried by the player;
	if sell_item is nothing:
		say "'I don't think you have anything else on you I would accept, I'm sorry'[paragraph break]";
		disable the Marlow_not_interested quip;
		disable the Marlow_what_else quip;
		enable the Marlow_just_looking quip;
		enable the Marlow_people quip;
		enable the Marlow_work quip;		
		enable the Marlow_rent_boat quip;
		enable the Marlow_just_looking quip;
		enable the Marlow_key_return quip;
		if the player is boated:
			enable the Marlow_rachel quip for Marlow;
		terminate the conversation;
	else: 
		say "'Hmmm...O.K., how about [the sell_item]?'[paragraph break]";
	if the player is carrying something that is not sell_item:
		now the last_wanted_item is sell_item;
		enable the Marlow_what_else quip;
	if the wealth of the player >= 950 yen:
		enable the Marlow_here_you_go quip.
		
After quipping when the current quip is Marlow_here_you_go:
	decrease the wealth of the player by 950 yen;
	surreptitiously move the sell_item to Marlow;
	surreptitiously move the boat key to the player;
	say "[If Marlow is acquainted]Marlow[else]The sea-bear[end if] handed me the boat key.";
	now the motor boat is rented;
	disable the Marlow_rent_boat quip;
	disable the Marlow_not_interested quip;
	disable the Marlow_what_else quip;
	enable the Marlow_people quip;
	enable the Marlow_work quip;		
	enable the Marlow_just_looking quip;
	enable the Marlow_key_return quip;
	if the player is boated:
		enable the Marlow_rachel quip for Marlow;
	terminate the conversation.

After quipping when the current quip is Marlow_key_return:
	now sell_item is a random sell-able thing carried by Marlow;
	surreptitiously move the sell_item to the player;
	surreptitiously move the boat key to Marlow;
	say "[If Marlow is acquainted]Marlow[else]The sea-bear[end if] handed me [the sell_item].";
	now the motor boat is not rented;
	enable the Marlow_just_looking quip;
	enable the Marlow_rent_boat quip;
	enable the Marlow_work quip;
	enable the Marlow_people quip;
	if the player is boated:
		enable the Marlow_rachel quip for Marlow;
	terminate the conversation.
	
After quipping when the current quip is Marlow_not_interested:
	now last_wanted_item is sell_item;
	disable the Marlow_what_deposit quip;
	disable the Marlow_tell_price quip;
	disable the Marlow_here_you_go quip;
	disable the Marlow_what_else quip;
	enable the Marlow_just_looking quip;
	enable the Marlow_rent_boat quip;
	enable the Marlow_work quip;
	enable the Marlow_people quip;
	if the player is boated:
		enable the Marlow_rachel quip for Marlow;
	terminate the conversation.
	
After quipping when the current quip is Marlow_just_looking:
	enable the Marlow_just_looking quip;
	enable the Marlow_work quip;
	enable the Marlow_people quip;
	enable the Marlow_key_return quip;
	terminate the conversation.
	
After quipping when the current quip is Marlow_work:
	now Marlow is worked;
	if Marlow is not peopled:
		enable the Marlow_people quip;
	if the player is boated:
		enable the Marlow_rachel quip;
	enable the Marlow_just_looking quip;
	if the player is carrying the boat key:
		enable the Marlow_key_return quip;
	else if the motor boat is not rented:
		enable the Marlow_rent_boat quip.


After quipping when the current quip is Marlow_people:
	now Marlow is peopled;
	disable the Marlow_rachel quip;
	disable the Marlow_key_return quip;
	disable the Marlow_work quip;
	disable the Marlow_rent_boat quip;
	disable the Marlow_just_looking quip;
	enable the Marlow_they quip;
	enable the Marlow_stay quip.

After quipping when the current quip is Marlow_stay:
	disable the Marlow_they quip;
	enable the Marlow_everyone quip.

After quipping when the current quip is Marlow_everyone:
	enable the Marlow_self quip;
	enable the Marlow_living quip.

After quipping when the current quip is Marlow_self:
	disable the Marlow_living quip;
	enable the Marlow_example quip.

After quipping when the current quip is Marlow_living:
	disable the Marlow_self quip;
	enable the Marlow_example quip.

After quipping when the current quip is Marlow_example:
	if Marlow is not worked:
		enable the Marlow_work quip;
	if the player is boated:
		enable the Marlow_rachel quip;
	enable the Marlow_just_looking quip;
	if the player is carrying the boat key:
		enable the Marlow_key_return quip;
	else if the motor boat is not rented:
		enable the Marlow_rent_boat quip.
		
After quipping when the current quip is Marlow_rachel:
	disable the Marlow_just_looking quip;
	disable the Marlow_work quip;
	disable the Marlow_people quip;
	disable the Marlow_rent_boat quip;
	disable the Marlow_key_return quip;
	enable the Marlow_tough_times quip;
	enable the Marlow_single_boat quip.

After quipping when the current quip is Marlow_single_boat:
	disable the Marlow_tough_times quip;
	enable the Marlow_this_boat quip.

After quipping when the current quip is Marlow_this_boat:
	enable the Marlow_reasons quip.

After quipping when the current quip is Marlow_reasons:
	disable the Marlow_reasons quip;
	enable the Marlow_daughter quip.

After quipping when the current quip is Marlow_daughter:
	enable the Marlow_why quip;
	enable the Marlow_where quip.
	
After quipping when the current quip is Marlow_where:
	disable the Marlow_why quip;
	enable the Marlow_how_long quip.

After quipping when the current quip is Marlow_how_long:
	now the player is not boated;
	now the player is aware;
	if Marlow is not peopled:
		enable the Marlow_people quip;
	enable the Marlow_just_looking quip;
	if the player is carrying the boat key:
		enable the Marlow_key_return quip;
	else if the motor boat is not rented:
		enable the Marlow_rent_boat quip.

After quipping when the current quip is Marlow_money:
	enable the Marlow_enough quip;
	enable the Marlow_cannot_accept quip;

After quipping when the current quip is Marlow_enough:
	disable the Marlow_cannot_accept quip;
	say "He handed me a roll of money.";
	increase the wealth of the player by 550000 yen;
	now the player is rich;
	enable the Marlow_just_looking quip;
	enable the Marlow_key_return quip;
	enable the Marlow_work quip;
	enable the Marlow_people quip;
	enable the Marlow_rent_boat quip;
	terminate the conversation;


Part 6 - Taniguchi

Chapter 1 - The Character

Taniguchi is a man.
Taniguchi is in L0_police_reception. The printed name is "the police officer". The initial appearance is "A single officer manned the police box." The description is "Not exactly the fittest policeman I'd seen."
Understand "police officer/man" and "officer" as Taniguchi when the location is L0_police_reception. 

Taniguchi can be snatched. Taniguchi is not snatched.
Taniguchi can be painted. Taniguchi is not painted.
Taniguchi can be smuggled. Taniguchi is not smuggled.
Taniguchi can be peopled. Taniguchi is not peopled.
Taniguchi can be pimped. Taniguchi is pimped.
Taniguchi can be fished. Taniguchi is fished.

Chapter 2 - Taniguchis possessions

Taniguchi wears a uniform.
Taniguchi carries a firearm called a pistol.

Chapter 3 - The Conversation

The litany of Taniguchi is the Table of Taniguchi Conversation.

The greeting of Taniguchi is Taniguchi_greeting

Table of Quip Texts (continued)
quip		quiptext
Taniguchi_greeting		"'Good evening, young Miss, can I help you?'"
Taniguchi_just_looking		"'Well, this is a police station, as you can see.'"
Taniguchi_report_crime		"'Is that so? What happened?'"
Taniguchi_forget_it		"'Well, O.K., if you say so.' He said looking a little disappointed."
Taniguchi_something_snatched	"'Are you sure it was stolen? You may just have lost it.'"
Taniguchi_maybe_lost		"'Mhmm...OK' He entered something into his computer. 'What is your name?'"
Taniguchi_real_name		"'Oh, I see, I should have noticed earlier. I was already informed. Let me just quickly contact your father so someone can come pick you up.'"
Taniguchi_fake_name		"'OK. If you'd sign here please, I'll file a report.'"
Taniguchi_chinaman		"'Have you seen that with your own eyes? That'd be very surprising, since entering the sewers is of course, strictly prohibited.'"
Taniguchi_location		"'But you're still so young! What if the chinaman was to hear of your accusations? You see, Miss, we wouldn't want anything to happen to you. I couldn't possibly bear the though.'" 
Taniguchi_thought		"'Surely you understand that I can't possibly open an investigation based purely on conjecture?'"
Taniguchi_yamaguchi		"'Yes, so?'"
Taniguchi_underage		"'I see. Did you know it is also against the law for a minor to still be out unsupervised at this time of the night?'"
Taniguchi_enforced		"'Just like many other things. For example: taking advantage of a minor is seldom persecuted.'" 
Taniguchi_inexperience		"'You don't look all that naive. Rather, I'd say you can take care of yourself, being around town at this hour.'"
Taniguchi_prostitution		"'Now that would be a serious crime. How come you know about it?'"
Taniguchi_obvious		"'I can assure you, all the girls at the 'Little China Girl are of legal age. We regularly check the place. If anyone tells you otherwise, he or she must be mistaken.'"
Taniguchi_papers	"'You don't say. Thats really frightening. What if someone actually acquired such a forgery? There would be no end to the trouble.'"
Taniguchi_fishy	"'Is that so? You understand we have to be careful, these kind of denunciations can ruin a company's reputation.'"
Taniguchi_hellhole	"'And what makes you think such practices are in breach of regulation? This factory has all the necessary certificates.'"
Taniguchi_no_help		"'Terribly sorry, Miss, but we've got bigger issues to deal with here.'"
Taniguchi_investigation		"'Well, if you insist, we can go through the procedure. What's your name?'"
Taniguchi_people	"'Why are you about at this time of the night yourself?'"
Taniguchi_arrested	"'I'm afraid I won't let you prowl the streets with this.' He waved the accella in front of me. 'These are confiscated.'"
Taniguchi_contraband	"'You know full well this is destroying the community. It's a dangerous drug, no matter it's legal status.'"
Taniguchi_genuine	"'Yes. But so what? I'll find something I can pin on you in any case.'"
Taniguchi_need	"'We hear that a lot these days. As an EnforcementSolutions officer I have learned to steel myself against any and all feelings of compassion for dangerous criminals.'"
Taniguchi_now_what	"'I'll file a report, of course. What's your name?'"


Table of Taniguchi Conversation
prompt						response			enabled
"'I was just looking.'"				Taniguchi_just_looking		1
"'Actually, forget about the crime.'"		Taniguchi_forget_it		0
"'I think my wallet got snatched.'"		Taniguchi_something_snatched	0
"'I think my phone got snatched.'"		Taniguchi_something_snatched	0
"'I'm pretty sure it was stolen.'"		Taniguchi_maybe_lost		0
"'On second thought, I may have lost it.'"	Taniguchi_maybe_lost		0
"Tell him my real name."			Taniguchi_real_name		0
"Tell him a fake name."				Taniguchi_fake_name		0
"'I'd like to report a crime.'"			Taniguchi_report_crime		1
"'There is a man in the sewers selling all sorts of contraband.'"	Taniguchi_chinaman	0
"'I was there. I could tell you the exact location.'"		Taniguchi_location	0
"'On second thought, I might not have been there after all.'"	Taniguchi_thought	0
"'A painter in the arisaka mall building tried to pay me money so he could paint me when I was naked.'"	Taniguchi_yamaguchi	0
"'Well, since I'm underage, I believe that is against the law.'"	Taniguchi_underage	0
"'Theoretically, yes. But I've never heard of it being enforced.'"	Taniguchi_enforced	0
"'Maybe. But that hardly makes it any better to take advantage of my youthful naivety.'"	Taniguchi_inexperience	0
"'I believe there is underage prostitution going on at a place called 'The Little China Girl'."		Taniguchi_prostitution	0
"'One of the staff dropped a comment to that effect.'"	Taniguchi_obvious		0
"'Come on now, it's totally obvious if you look at the girls.'"	Taniguchi_obvious	0
"'You do know it's possible to get false papers quite easily in Gotomomi, don't you?'"	Taniguchi_papers	0
"'I think the Heng Seng fish factory needs to be inspected for hygiene compliance.'"	Taniguchi_fishy	0
"'None of their tin cans contains what it says on the outside. It's all just rotten fish in machine oil!'"	Taniguchi_hellhole	0
"'The place is a hellhole! I saw workers being treated like slaves by the management.'"	Taniguchi_hellhole	0
"'I understand. It was foolish of me to expect anything of the police.'"	Taniguchi_no_help	0
"'I would still like you to open an investigation.'"	Taniguchi_investigation		0
"'Do you know why there are so many people about at this time of the night?'"	Taniguchi_people	1
"'As far as I know, it's not contraband.'"	Taniguchi_contraband	0
"'I'm so sorry, it was pure need that drove me to do it.'"	Taniguchi_need	0
"'Your concern can't be genuine. As if there ever was a community to start with."	Taniguchi_genuine	0
"'OK. So now what?'"	Taniguchi_now_what	0
 
Before quipping when the current quip is Taniguchi_greeting:
	if Taniguchi is peopled:
		disable the Taniguchi_people quip for Taniguchi;
	say "I said [italic type]'konbanwa'[roman type] to the officer on duty.[paragraph break]".

After quipping when the current quip is Taniguchi_just_looking:
	enable the Taniguchi_report_crime quip;
	enable the Taniguchi_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Taniguchi_report_crime:
	unless Taniguchi is snatched:
		enable the Taniguchi_something_snatched quip;
	unless Taniguchi is painted:
		if Pickup_3 has ended: 
			enable the Taniguchi_yamaguchi quip;
	unless Taniguchi is smuggled:
		if Pickup_2 has ended:
			enable the Taniguchi_chinaman quip;
	unless Taniguchi is pimped:
		enable the Taniguchi_prostitution quip;
	unless Taniguchi is fished:
		enable the Taniguchi_fishy quip;
	disable the Taniguchi_just_looking quip;
	disable the Taniguchi_people quip;
	enable the Taniguchi_forget_it quip.
	
After quipping when the current quip is Taniguchi_forget_it:
	disable the Taniguchi_something_snatched quip;
	disable the Taniguchi_chinaman quip;
	disable the Taniguchi_yamaguchi quip;
	disable the Taniguchi_prostitution quip;
	disable the Taniguchi_fishy quip;
	enable the Taniguchi_people quip;
	enable the Taniguchi_report_crime quip;
	enable the Taniguchi_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Taniguchi_something_snatched:
	now Taniguchi is snatched;
	disable the Taniguchi_forget_it quip;
	disable the Taniguchi_something_snatched quip;
	disable the Taniguchi_chinaman quip;
	disable the Taniguchi_yamaguchi quip;
	disable the Taniguchi_prostitution quip;
	disable the Taniguchi_fishy quip;
	enable the Taniguchi_maybe_lost quip.

After quipping when the current quip is Taniguchi_maybe_lost:
	disable the Taniguchi_maybe_lost quip;
	disable the Taniguchi_forget_it quip;
	enable the Taniguchi_real_name quip;
	enable the Taniguchi_fake_name quip.

After quipping when the current quip is Taniguchi_real_name:
	terminate the conversation;
	end the story saying "And that was how my father knew where to find me."

After quipping when the current quip is Taniguchi_fake_name:
	disable the Taniguchi_real_name quip;
	disable the Taniguchi_forget_it quip;
	disable the Taniguchi_maybe_lost quip;
	enable the Taniguchi_report_crime quip;
	enable the Taniguchi_just_looking quip;
	enable the Taniguchi_people quip;
	terminate the conversation;
	say "I signed the report, knowing the investigation, if it was ever even started, would lead nowhere.[paragraph break]".

After quipping when the current quip is Taniguchi_chinaman:
	now Taniguchi is smuggled;
	disable the Taniguchi_forget_it quip;
	disable the Taniguchi_something_snatched quip;
	disable the Taniguchi_yamaguchi quip;
	disable the Taniguchi_prostitution quip;
	disable the Taniguchi_fishy quip;
	enable the Taniguchi_location quip;
	enable the Taniguchi_thought quip.

After quipping when the current quip is Taniguchi_location:
	disable the Taniguchi_thought quip;
	enable the Taniguchi_no_help quip;
	enable the Taniguchi_investigation quip.

After quipping when the current quip is Taniguchi_thought:
	disable the Taniguchi_location quip;
	enable the Taniguchi_no_help quip;
	enable the Taniguchi_investigation quip.

After quipping when the current quip is Taniguchi_yamaguchi:
	now Taniguchi is painted;
	disable the Taniguchi_forget_it quip;
	disable the Taniguchi_something_snatched quip;
	disable the Taniguchi_chinaman quip;
	disable the Taniguchi_prostitution quip;
	disable the Taniguchi_fishy quip;
	enable the Taniguchi_underage quip.
	
After quipping when the current quip is Taniguchi_underage:
	enable the Taniguchi_enforced quip;
	enable the Taniguchi_inexperience quip.
	
After quipping when the current quip is Taniguchi_enforced:
	disable the Taniguchi_inexperience quip;
	enable the Taniguchi_no_help quip;
	enable the Taniguchi_investigation quip.

After quipping when the current quip is Taniguchi_inexperience:
	disable the Taniguchi_enforced quip;
	enable the Taniguchi_no_help quip;
	enable the Taniguchi_investigation quip.
	
After quipping when the current quip is Taniguchi_prostitution:
	now Taniguchi is pimped;
	disable the Taniguchi_chinaman quip;
	disable the Taniguchi_forget_it quip;
	disable the Taniguchi_something_snatched quip;
	disable the Taniguchi_yamaguchi quip;
	disable the Taniguchi_fishy quip;
	enable the Taniguchi_obvious quip.

After quipping when the current quip is Taniguchi_obvious:
	disable the Taniguchi_obvious quip;
	enable the Taniguchi_papers quip.

After quipping when the current quip is Taniguchi_papers:
	enable the Taniguchi_no_help quip;
	enable the Taniguchi_investigation quip. 

After quipping when the current quip is Taniguchi_fishy:
	now Taniguchi is fished;
	disable the Taniguchi_chinaman quip;
	disable the Taniguchi_forget_it quip;
	disable the Taniguchi_something_snatched quip;
	disable the Taniguchi_yamaguchi quip;
	disable the Taniguchi_prostitution quip;
	enable the Taniguchi_hellhole quip;

After quipping when the current quip is Taniguchi_hellhole:
	disable the Taniguchi_hellhole quip;
	enable the Taniguchi_no_help quip;
	enable the Taniguchi_investigation quip. 

After quipping when the current quip is Taniguchi_no_help:
	enable the Taniguchi_just_looking quip;
	enable the Taniguchi_people quip;
	enable the Taniguchi_report_crime quip;
	disable the Taniguchi_investigation quip;
	terminate the conversation.

After quipping when the current quip is Taniguchi_investigation:
	disable the Taniguchi_no_help quip;
	enable the Taniguchi_real_name quip;
	enable the Taniguchi_fake_name quip.

After quipping when the current quip is Taniguchi_people:
	now Taniguchi is peopled.

After quipping when the current quip is Taniguchi_contraband:
	now the player is not arrested;
	disable the Taniguchi_need quip;
	enable the Taniguchi_genuine quip.
	
After quipping when the current quip is Taniguchi_genuine:
	enable the Taniguchi_now_what quip.

After quipping when the current quip is Taniguchi_need:
	disable the Taniguchi_contraband quip;
	enable the Taniguchi_now_what quip.

After quipping when the current quip is Taniguchi_now_what:
	enable the Taniguchi_real_name quip;
	enable the Taniguchi_fake_name quip.


Part 7 - The security guards

Chapter 1 - The Character

The security guards is a plural-named man.
The security guards is in L0_station_main.
The initial appearance of the security guards is "Eight security guards stood in front of the Arisaka mall to the [bold type]east[roman type], controlling everyone entering."
The description of the security guards is "Sunglasses, cargo pants, combat boots, whistles, batons, pepper-spray, tasers and handcuffs: these guards were much more menacing than their mundane job of chasing away beggars would have suggested."
Understand "guard/watchman/watchmen" and "security guard" as the security guards when the location is L0_station_main.

Does the player mean doing something with the security guards when the location is L0_station_main: it is unlikely.

Chapter 2 - The security Guards possessions

The security guards wear the sunglasses.
The security guards wear clothing called the cargo pants.
The security guards wear footwear called the combat boots.

The security guards carry the whistles, the batons, the pepper-spray, the tasers and the handcuffs. 

Chapter 3 - The Conversation

The litany of the security guards is the Table of Guards Conversation.

The greeting of the security guards is Guards_greeting

Table of Quip Texts (continued)
quip				quiptext
Guards_greeting			"[one of]'Security check, papers please.'[or]'Excuse me, Miss, can I see some ID please.'[at random] said one of the guards."
Guards_just_looking		"'Well, get moving then.'"
Guards_ID_stolen		"'Better report it to the police. Can't enter the mall without an ID.'"
Guards_show_ID			"'Thank you very much, have a good day in the Arisaka mall.'"

Table of Guards Conversation
prompt							response			enabled
"'Er, sorry, I'm already gone.'"			Guards_just_looking		1
"'My Wallet was stolen with my ID-card in it.'"		Guards_ID_stolen		1
"'Here you go: my ID.'"					Guards_show_ID			0

Before quipping when the current quip is Guards_greeting:
	if the player carries at least one ID card:
		enable the Guards_show_ID quip for the security guards.

After quipping when the current quip is Guards_just_looking:
	enable the Guards_ID_stolen quip;
	enable the Guards_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Guards_ID_stolen:
	enable the Guards_ID_stolen quip;
	enable the Guards_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Guards_show_ID: 
	enable the Guards_ID_stolen quip;
	enable the Guards_just_looking quip;
	enable the Guards_show_ID quip;
	terminate the conversation;
	move the player to L0_mall_hub.

Part 8 - Kei

Chapter 1 - The Character

Kei is a woman. Kei is in L1_delivery. The initial appearance of Kei is "[if Kei is acquainted]Kei[else]An [italic type]oneesan[roman type] in her twenties[end if] was sitting behind one of the desks."
The printed name of Kei is "[if Kei is acquainted]Kei[else]the young woman".

Understand "girl/tween/oneesan" as Kei when the location is L1_delivery.

Kei can be phoning. Kei is not phoning.
Kei can be broke. Kei is not broke.

Chapter 2 - Keis Possessions

Kei carries the signpad. The signpad has a text called the address. The description of the signpad is "It displayed a message:[paragraph break][address]".
Understand "pad/signing" and "signing pad" as the signpad.

Kei carries the letter. The description of the letter is "A simple brown paper envelope, sealed shut."
Instead of opening the letter, say "Better not."

Kei carries a standard key. The standard key unlocks the metal gate.

To say key-refusal for (locked-thing - the metal gate):
     say "The metal gate was firmly locked. I would have to find the key to unlock it."

Chapter 3 - The Conversation

The litany of Kei is the Table of Kei Conversation.

The greeting of Kei is Kei_greeting.

Table of Quip Texts (continued)
quip			quiptext
Kei_greeting		"[If Kei is not acquainted]'Hello there, it sure is unusual to have someone new come in here at this hour. How can I help you?'[else]'Hello, Ayako. What can I do for you?'"
Kei_just_looking	"'Don't sweat it.'"
Kei_hows_business	"'To be honest, I don't know what to do anymore. Kimiko and Sonja are both ill and I can't seem to reach Eri. The backlog is getting longer and longer and I have no-one to do the deliveries. But anyways, who are you, if I may ask?"
Kei_tell_name		"'I'm Kei, [italic type]yoroshiku[roman type]. Would you be willing to work for me just for tonight, by any chance?'"
Kei_not_interested	"'Funny, that. Anyway, I have lots of work to offer, so come back if you change your mind.'"
Kei_great_help		"'You would? That's awesome. The night shift gets 32000 yen by the way, they'd be yours as well. [unless the player wears the overall and the player wears the working boots]To tell you right away though: you're useless in that get-up. Find something more practical to wear first.'"
Kei_get_dressed		"'You do that. Come back when you've changed into something more appropriate. Don't forget to get proper footwear as well.'"
Kei_now_dressed		"'Yeah, It'll do. Let's get started then.'"
Kei_start_employment	"'You take this signing pad. It shows you the address you have to go to to pick up the delivery. Have the customer sign it when you get there. It will then switch to showing you the address of the place you deliver it to. Have them sign it there again, and the next pick-up address will show. Child's play.'"
Kei_get_going		"'Thanks a lot. When you've finished all the deliveries, give the signing pad back to me and you'll get your money. Oh, and here is the key for the first address.'"
Kei_what_about_it	"'Yes, I believe so. What about it?'"
Kei_underage		"'Yeah...but It doesn't matter if you're underage, they'll let you in as long as you show some ID."
Kei_take_care		"'You do that. Take care.'"
Kei_no_ID		"'Oh. That's a problem, you know. They won't let you in without a valid ID.'"
Kei_wallet_stolen	"'Yeah right. Of course you could have just gone to the police now, couldn't you? But, you know, we have these kinds of girls here all the time. Don't you stateless guys realise you won't be going anywhere in this place except the Little China Girl?'"
Kei_truth		"'Oh, I see. Sorry about the rant just know. We've had our own troubles with the authorities about this ID thing a few times already. Threatened to shut us down and so on. Luckily enough for you this has led to a very favourable arrangement with the chinaman. I'll give you a letter, and he'll be able to give you a discount on one of his imported forgeries.'"
Kei_lie			"'Yeah, you'd better do that. The deliveries don't wait.'"
Kei_thanks		"'Don't mention it.'"
Kei_china		"'Why wouldn't they let you in?'"
Kei_watchdog		"'That's not even funny. If they want their stuff delivered, they are going to have to let you in. Maybe you can put that a little more diplomatically when you go there again.'"
Kei_cancel		"'Great. We can't afford to lose them as a customer. I'll call them. Wait a moment.'"  
Kei_vaccinated		"She turned to me, covering the phone with her hand: 'Are you vaccinated?'"
Kei_shot		"'I suppose that'll have to do.' said Kei, raising her left eyebrow.[paragraph break]She got back on the phone."
Kei_try_again		"'Please also try not to anger her. We really need them as a customer.'"
Kei_dont_move		"Kei signaled me to remain silent."
Kei_go_now		"'You can go down there now. She should let you in this time.'"
Kei_failure		"'No, I'm sorry. I'm afraid I put that idea into her head when I told her we had a few sick calls.'"
Kei_bullying		"'Frankly, the way I see it: It might be best to try and sneak in and get the package behind her back.'"
Kei_workable		"'Don't worry. It'll be the bartender's usual delivery. He'll sign your pad alright.'"
Kei_immunisation	"'That shouldn't be too difficult. Just go and get all the vaccination shots tonight. There is a 24-hour emergency clinic in the Arisaka mall.'"
Kei_crazy		"'It's on the 31st. floor.'"
Kei_package		"'You will. I'm sure.'"
Kei_finished		"'So you've managed to get that box of champagne bottles after all. Here is your money.'"
Kei_great			"'You've worked hard for it, haven't you? Oh, and would you give me the signpad back, and the key,  please?'"
Kei_signpad		"'Actually, I could have use for you again now or then. How about it?'" 
Kei_farewell		"'Well, if you must. It's been nice to meet you. [italic type]sayonara[roman type], Ayako.'"

Table of Kei Conversation
prompt							response		enabled
"'Oh, sorry, I forgot what I wanted to say.'"		Kei_just_looking	1
"'How is business?'"					Kei_hows_business	1
"'I'm Ayako.'"						Kei_tell_name		0
"'I'm not really interested in working for you.'"	Kei_not_interested	0
"'I could do the deliveries for you.'"			Kei_great_help		0
"'OK, I will see what I can do about that."		Kei_get_dressed		0
"'I got this outfit. Will it do for this job?'"		Kei_now_dressed		0
"'OK, what do I do?'"					Kei_start_employment	0
"'I'll get going then.'"				Kei_get_going		0
"'I have to do a delivery in the Arisaka mall.'"	Kei_what_about_it	0
"'I need an ID to get in.'"				Kei_underage		0
"'OK then, thanks, that's what I wanted to know. I'll get going again.'"	Kei_take_care	0
"'I don't have an ID."					Kei_no_ID		0
"'My wallet was stolen.'"				Kei_wallet_stolen	0
"'My wallet really was stolen. I can't go to the police because I ran away from my old man, and he's well enough connected to have the police actually look for me.'"	Kei_truth	0
"'My wallet really was stolen. I'll go to the police to try and get it back.'"	Kei_lie	0
"'Thank you Kei, that's swell of you.'"			Kei_thanks		0
"'I tried to pick up a delivery at 'the Little China Girl' but they wouldn't even let me in.'"	Kei_china	0 
"'The watchdog at the door told me she wouldn't let in anyone underage. I am to tell you to send someone else.'"		Kei_watchdog	0
"'They sent me away again at 'the little China Girl'. They say they don't want us to do the delivery if it has to be me.'"	Kei_cancel	0
"'Not really. I think I was vaccinated for polio when I was little. And not much more.'"	Kei_shot	0
"'Maybe. I'm not keeping track of what shots exactly I get.'"	Kei_shot	0
"'Reasonably well, I guess. I think the last one was Hepatitis B, if I remember correctly.'"	Kei_shot	0
"'Of course. I always get all the recommended vaccinations if I legally can, and sometimes even if I can't.'"	Kei_shot	0
"'Hell, yes! I'm shot full of all kinds of medicine with side effects so terrible they'd make sulfonamides seem like mineral water by comparison.'"	Kei_shot	0
"'I'll try my luck once again.'"	Kei_try_again	0
"'Sorry to bother you again with this. Now she wants to see my immunisation record.'"	Kei_failure	0
"'This is bullying! She enjoys to have me run back and forth. She isn't even ashamed to admit it!'"	Kei_bullying	0
"'She likes to play little games with me. But I assure you, I'm better at that than she'll ever be.'"	Kei_bullying	0
"'Burglary sounds workable. But who'll sign the pad?'"	Kei_workable	0
"'How about we try to get an immunisation record for me? I'd like to keep up the punishing game with her.'"	Kei_immunisation	0
"'That sounds crazy, I might try it.'"		Kei_crazy	0
"'I'll find a way to get that package, and if it's the last thing I do.'"	Kei_package	0
"'I'm through with the deliveries."	Kei_finished	0
"'That's great, I can really use this.'"		Kei_great		0
"'Oh, sure, here you go.'"	Kei_signpad	0
"'I'm afraid I can't. I have to get going and won't be around. [italic type]sayonara[roman type], Kei.'"	Kei_farewell	0


Before quipping when the current quip is Kei_greeting:
	if Delivery_4 has ended and Kei is not broke:
		enable the Kei_finished quip for Kei;
	say "I said [italic type]'konbanwa'[roman type] to [if Kei is acquainted]Kei[else]the oneesan[end if].[paragraph break]".

After quipping when the current quip is Kei_just_looking:
	enable the Kei_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Kei_hows_business:
	now Tanaka is worked;
	now Jiahui is worked;
	now Marlow is worked;
	disable the Tanaka_work quip for Tanaka;
	disable the Jiahui_work quip for Jiahui;
	disable the Marlow_work quip for Marlow;
	now the _woman is worked;
	disable the Kei_just_looking quip;
	enable the Kei_tell_name quip.

After quipping when the current quip is Kei_tell_name:
	now Kei is acquainted;
	enable the Kei_not_interested quip;
	enable the Kei_great_help quip.

After quipping when the current quip is Kei_not_interested:
	disable the Kei_start_employment quip;
	enable the Kei_great_help quip;
	enable the Kei_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Kei_get_dressed:
	disable the Kei_hows_business quip;
	disable the Kei_not_interested quip;
	enable the Kei_just_looking quip;
	enable the Kei_great_help quip;
	terminate the conversation.

After quipping when the current quip is Kei_now_dressed:
	disable the Kei_just_looking quip;
	enable the Kei_not_interested quip;
	enable the Kei_start_employment quip.

After quipping when the current quip is Kei_great_help:
	disable the Kei_just_looking quip;
	if the player wears the overall and the player wears the working boots:
		enable the Kei_now_dressed quip;
	else:
		enable the Kei_get_dressed quip.

After quipping when the current quip is Kei_start_employment:
	say "Kei handed me the signing pad.";
	move the signpad to the player;
	now the address of the signpad is "Pick up at:[line break]Yano & Chou Import-Export[line break]shitamachi-doori H25 C7.";
	disable the Kei_not_interested quip;
	enable the Kei_get_going quip.

After quipping when the current quip is Kei_get_going:
	say "She handed me a perfectly normal-looking key.";
	move the standard key to the player;
	enable the Kei_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Kei_what_about_it:
	disable the Kei_just_looking quip;
	enable the Kei_underage quip.

After quipping when the current quip is Kei_underage:
	enable the Kei_take_care quip;
	enable the Kei_no_ID quip.

After quipping when the current quip is Kei_take_care:
	disable the Kei_no_ID quip;
	enable the Kei_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Kei_no_ID:
	disable the Kei_take_care quip;
	enable the Kei_wallet_stolen quip.
	
After quipping when the current quip is Kei_wallet_stolen:
	enable the Kei_lie quip;
	enable the Kei_truth quip.

After quipping when the current quip is Kei_lie:
	disable the Kei_truth quip;
	enable the Kei_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Kei_truth:
	disable the Kei_lie quip;
	enable the Kei_thanks quip;
	say "Kei quickly wrote a few lines by hand and sealed them in an envelope.";
	say "She then gave me the letter.";
	move the letter to the player.
	
After quipping when the current quip is Kei_thanks:
	enable the Kei_just_looking quip;
	disable the QF_tell_again quip for the quick fox;
	disable the QF_need_ID quip for the quick fox;
	terminate the conversation.

After quipping when the current quip is Kei_china:
	disable the Kei_just_looking quip;
	enable the Kei_watchdog quip.
	
After quipping when the current quip is Kei_watchdog:
	enable the Liao_once_again quip for Madame Liao;
	enable the Kei_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is Kei_cancel:
	disable the Kei_just_looking quip;
	now Kei is phoning;
	terminate the conversation.

After quipping when the current quip is Kei_vaccinated:
	disable the Kei_just_looking quip;
	enable the Kei_shot quip;
	
After quipping when the current quip is Kei_shot:
	disable the Kei_shot quip;
	now Kei is not phoning;
	terminate the conversation.

After quipping when the current quip is Kei_go_now:
	enable the Kei_try_again quip.

After quipping when the current quip is Kei_try_again:
	enable the Kei_just_looking quip;
	enable the Liao_employer quip for Madame Liao;
	terminate the conversation.

After quipping when the current quip is Kei_failure:
	disable the Kei_just_looking quip;
	enable the Kei_bullying quip.

After quipping when the current quip is Kei_bullying:
	disable the Kei_bullying quip;
	enable the Kei_workable quip;
	enable the Kei_immunisation quip.

After quipping when the current quip is Kei_workable:
	enable the Kei_package quip;

After quipping when the current quip is Kei_immunisation:
	disable the Kei_workable quip;
	disable the Kei_package quip;
	enable the Kei_crazy quip.

After quipping when the current quip is Kei_crazy:
	now the player is pissed;
	enable the Kei_package quip;
	
After quipping when the current quip is Kei_package:
	disable the Kei_workable quip;
	disable the Kei_immunisation quip;
	now the pliers are sell-able;
	enable the Kei_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Kei_finished:
	disable the Kei_just_looking quip;
	say "She handed me 32.000 yen in cash.";
	increase the wealth of the player by 32000 yen;
	now Kei is broke;
	enable the Kei_great quip.

After quipping when the current quip is Kei_great:
	say "I gave her the signing pad and the key.";
	move the signpad to Kei;
	move the standard key to Kei;
	enable the Kei_signpad quip.

After quipping when the current quip is Kei_signpad:
	enable the Kei_farewell quip.
	
After quipping when the current quip is Kei_farewell:
	enable the Kei_just_looking quip;
	now the metal gate is closed;
	now the metal gate is locked;
	terminate the conversation.

Part 9 - Wanja

Chapter 1 - The Character

Wanja is a man. Wanja is in L0_transport_office. The printed name of Wanja is "[if Wanja is acquainted]Wanja[else]the lanky guy". The initial appearance of Wanja is "[if Wanja is acquainted]Wanja[else]A lanky guy with very Slavic features[end if] was [One of]hacking away at a keyboard[or]sorting some papers[or]going about his business[in random order]." The description of Wanja is "A Russian maybe?"

Understand "guy/russian/slav/slavic/ivan" as Wanja when the location is L0_transport_office.

Chapter 2 - Wanjas possessions

Wanja carries a privately-named parcel called parcel_1. The printed name of parcel_1 is "a parcel". The description of parcel_1 is "An unmarked brown cardboard box with a customs seal stuck on top."
A part of parcel_1 is a customs seal. The description of the customs seal is "Duty had been payed for 15 vinyl records."
 
Understand "brown cardboard box", "cardboard/brown/unmarked box" and "unmarked/brown/cardboard/box" as parcel_1.
Understand "customs sticker" and "sticker" as the customs seal.

Chapter 3 - The conversation

The litany of Wanja is the Table of Wanja Conversation.

The greeting of Wanja is Wanja_greeting.

Table of Quip Texts (continued)
quip			quiptext
Wanja_greeting		"[If Wanja is not acquainted]'Welcome, customer! How can I help you.'[else]'Hello Ayako, what is it this time?'"
Wanja_just_looking	"[If Wanja is not acquainted]'That happens from time to time, don't worry about it.'[else]'That's nice of you, see you!'"
Wanja_pickup		"'Ah yes, of course! Here it is.'"
Wanja_sign_1		"[If Wanja is not acquainted]'Well, OK...'"
Wanja_new_girl		"'Never mind, I like to meet new people. My Name is Ivan, but my friends call me Wanja.'"
Wanja_ayako		"'Nice to meet you! And how is your first day at your new job?'"
Wanja_honest		"'That's good. I like to work with my own hands, too.'"
Wanja_money		"'That's too bad. Maybe it will grow on you yet.'"
Wanja_rely		"'That's the state of the world we live in, right? How come we are both working at this time of the night?'"
Wanja_gotomomi		"'I had an entirely different conception of the place before I came here. Let's leave it at that. How about yourself?'"
Wanja_fun		"'That's not so far from the truth, at least for me. I enjoy working. After all, what else would I be doing? Then again that's probably just another attempt to justify this job to myself. How about you? Any rationalising you would like to share?'"
Wanja_reasons		"'Of course there are. In Gotomomi, there always are.'"
Wanja_conditions	"'I'm sorry. Of course there would be.'"
Wanja_sign_2		"'Sure, here you go.'"
Wanja_delivery	"[If Wanja is acquainted]'Ah, I see, it's today's return shipment from 'the Little China Girl', isn't it? Now, what do we have here, Louis Roederer, not bad.[else]'OK. Thank you very much.'"
Wanja_sign_3		"[If Wanja is acquainted]'Sure thing.'[else]'Yes, of course.'"
Wanja_goodbye	"[If Wanja is acquainted]'Goodbye, Ayako, take care, alright?'[else]'Goodbye.'"
Wanja_champagne	"Yes. Every day a full box of expensive champagne leaves that place. Would you like to know why?"
Wanja_no		"'Well, if you feel that way, so be it.' said Wanja, taken aback."
Wanja_yes	"'Don't you think the box would be a little light if those bottles were full? After a little Investigation, here is what I suspect: that Macao company this box is returned to re-fills and re-corks them. No Louis Roederer for the customers of the Little China Girl, I'm sure."
Wanja_outrageous	"'I agree, it fits.'"

Table of Wanja Conversation
prompt							response		enabled
"[If Wanja is not acquainted]'Not at all, I'm afraid. I think I had the wrong door.'[else]'Just came to say hello, and I'm already gone again.'"	Wanja_just_looking	1
"'CityTrafficking courier service, I came to pick something up'"	Wanja_pickup		0
"'Would you sign here please?'"				Wanja_sign_1		0
"'I'm just helping out for today.'"			Wanja_new_girl		0
"'I'm Ayako.'"						Wanja_ayako		0
"'I like it. Seems to be honest work.'"			Wanja_honest		0
"'I'm only doing it for the money.'"			Wanja_money		0
"'Working can be very satisfactory, I agree. But it seems overly optimistic to expect it to provide for ones monetary needs.'"			Wanja_rely	0
"'No-one will ever gain financial independence by his own hands' work.'"	Wanja_rely	0
"'How come indeed. If you understand this so well, why would you even be in Gotomomi? What about all the awful [italic type]poshlost[roman type]?'"	Wanja_gotomomi	0
"'Maybe we're both doing it because it gives us some eccentric kind of pleasure?'"		Wanja_fun	0
"'There are reasons.'"	 Wanja_reasons	0
"'There were certain unfortunate circumstances.'"	 Wanja_conditions	0
"'It's been nice talking to you, but I should really get going now. Would you sign here please?'"		Wanja_sign_2	0
"[If Wanja is acquainted]'I've got this parcel for you.'[else]'Courier Service, I'm supposed to drop of this delivery here.'"	Wanja_delivery	0
"[if Wanja is acquainted]'Could you sign this for me, please?'[else]'If you'd sign here, please.'"	Wanja_sign_3		0
"[If Wanja is acquainted]'Good bye, Wanja, it's been nice meeting you.'[else]'Thank you very much, good bye.'"	Wanja_goodbye	0
"'Today's? Do you get one of these everyday?'"	Wanja_champagne	0
"'No, thank you, I can live quite well without the knowledge.'"	Wanja_no		0
"'Yes, Why indeed?"	Wanja_yes	0
"In a way this shouldn't surprise me.'"		Wanja_outrageous	0

Before quipping when the current quip is Wanja_greeting:
	if Pickup_1 is happening:	
		enable the Wanja_pickup quip for Wanja;
	else if Delivery_4 is happening:
		enable the Wanja_delivery quip for Wanja;
	say "I said [italic type]'Previet'[roman type] to [if Wanja is acquainted]Wanja[else]the lanky guy[end if].[paragraph break]".

After quipping when the current quip is Wanja_just_looking:
	enable the Wanja_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is Wanja_pickup:
	disable the Wanja_just_looking quip;
	say "The Russian handed me a parcel.";
	move parcel_1 to the player;
	say "'I haven't seen you before. Are you new?'[paragraph break]";
	enable the Wanja_sign_1 quip;
	enable the Wanja_new_girl quip.

After quipping when the current quip is Wanja_sign_1:
	disable the Wanja_new_girl quip;
	disable the Wanja_ayako quip;
	enable the Wanja_just_looking quip;
	say "He signed the signpad looking a little hurt.";
	now the address of the signpad is "Delivery to:[line break]The Martyrium[line break]Tachibana General Laboratories Plaza Building.[line break]";
	terminate the conversation.

After quipping when the current quip is Wanja_new_girl:
	enable the Wanja_ayako quip;

After quipping when the current quip is Wanja_ayako:
	disable the Wanja_sign_1 quip;
	enable the Wanja_honest quip;
	enable the Wanja_money quip.

After quipping when the current quip is Wanja_honest:
	disable the Wanja_money quip;
	enable the Wanja_rely quip.

After quipping when the current quip is Wanja_money:
	disable the Wanja_honest quip;
	enable the Wanja_rely quip.

After quipping when the current quip is Wanja_rely:
	disable the Wanja_rely quip;
	enable the Wanja_gotomomi quip;
	enable the Wanja_fun quip.

After quipping when the current quip is Wanja_gotomomi:
	disable the Wanja_fun quip;
	enable the Wanja_reasons quip;
	enable the Wanja_sign_2 quip.
		
After quipping when the current quip is Wanja_fun:
	disable the Wanja_gotomomi quip;
	enable the Wanja_conditions quip;
	enable the Wanja_sign_2 quip.

After quipping when the current quip is Wanja_sign_2:
	disable the Wanja_reasons quip;
	disable the Wanja_conditions quip;
	enable the Wanja_just_looking quip;
	now Wanja is acquainted;
	say "Wanja signed the signpad happily.";
	now the address of the signpad is "Delivery to:[line break]The Martyrium[line break]Tachibana General Laboratories Plaza Building.[line break]";
	terminate the conversation.

After quipping when the current quip is Wanja_delivery:
	say "I gave him the box.";
	move parcel_4 to Wanja;
	if Wanja is acquainted:
		enable the Wanja_champagne quip;
	disable the Wanja_just_looking quip;
	enable the Wanja_sign_3 quip.

After quipping when the current quip is Wanja_sign_3:
	disable the Wanja_champagne quip;
	now the address of the signpad is "That's all for tonight. Come back to me to get your Payment.[line break]Kei[line break]";
	enable the Wanja_goodbye quip.

After quipping when the current quip is Wanja_goodbye:
	enable the Wanja_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Wanja_champagne:
	disable the Wanja_sign_3 quip;
	enable the Wanja_yes quip;
	enable the Wanja_no quip.

After quipping when the current quip is Wanja_no:
	disable the Wanja_yes quip;
	enable the Wanja_sign_3 quip.

After quipping when the current quip is Wanja_yes:
	disable the Wanja_no quip;
	now the bartender is exposed;
	enable the Wanja_outrageous quip.

After quipping when the current quip is Wanja_outrageous:
	enable the Wanja_sign_3 quip.


Part 10 - Risa

Chapter 1 - The Character

Risa is a woman. Risa is in L0_danceclub_frontdesk. The printed name of Risa is "the redhead". The description of Risa is "Her hair was surely coloured." The initial appearance of Risa is "[if the player is caught]The redhead gave me a disapproving look.[else if Risa is acquainted]The redhead looked somewhat bored behind the reception desk.[else]The artificial red-head behind the reception desk looked rather bored."

Understand "redhead/girl/artificial/red-head" and "artificial redhead/red-head" as Risa.

Chapter 2 - Risas possessions

Risa wears clothing called a tank top.

Chapter 3 - The conversation

The litany of Risa is the Table of Risa Conversation.

The greeting of Risa is Risa_greeting.

Table of Quip Texts (continued)
quip			quiptext
Risa_greeting		"[If the player is caught]'You know I won't let you in.'[else if Risa is not acquainted]'Hi there, what can I do for you?'[else]'Hello again, what's the matter?'"
Risa_just_looking	"[If the player is caught]'Get going, then.'[else if Risa is not acquainted]'Well, since you're underage, I guess this is as far as you'll get. Goodbye.'[else]'That's awfully nice of you. Have a nice evening.'"
Risa_delivery		"'That's for JJ. He is behind the turntables downstairs.'"
Risa_what_place		"'You haven't heard of the Martyrium? Girl, you must have been living under a rock the last few weeks. This is currently [italic type]the[roman type] dance club in town. Does that help you in any way?'"
Risa_show_id	"The redhead stopped me in my tracks: [if the player is caught]'You are no longer welcome here, girl. Go home.'[else]'May I see some ID please? Sorry but you seem underage.'"
Risa_people	"'If they're not here for the Martyrium, they're here for some other cheap thrill, I guess. Is that all?'"
Risa_caught	"'You will not set another foot into this club and you know why.' said the redhead matter-of-factly."

Table of Risa Conversation
prompt			response		enabled
"[If the player is caught]'All right, all right, I'm already gone.'[else if Risa is not acquainted]'I was just curious what this place looks like inside.'[else]'Just came to say hello.'"	Risa_just_looking	1
"'CityTrafficking courier service. I'm bringing a parcel.'"	Risa_delivery	0
"'Would you mind telling me what kind of business this is?'"	Risa_what_place	0
"'Do you know why there are so many people about at this time of the night?'"	Risa_people	1

Before quipping when the current quip is Risa_greeting:
	if Delivery_1 is happening:	
		enable the Risa_delivery quip for Risa;
	else if Delivery_1 has ended:
		disable the Risa_people quip for Risa;
	say "I said [italic type]'konbanwa'[roman type] to the redhead.[paragraph break]".

After quipping when the current quip is Risa_just_looking:
	enable the Risa_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Risa_delivery:
	enable the Risa_just_looking quip;
	now the club stairs are open;
	now Risa is acquainted;		
	terminate the conversation.

After quipping when the current quip is Risa_people:
	disable the Risa_just_looking quip;
	disable the Risa_delivery quip;
	enable the Risa_what_place quip;

After quipping when the current quip is Risa_what_place:
	enable the Risa_just_looking quip;
	if Delivery_1 is happening:	
		enable the Risa_delivery quip for Risa.

Part 11 - The Dancers

Chapter 1 - The Character

The dancers are a plural-named woman. 
The dancers are in L-1_danceclub_dancefloor.

The initial appearance of the dancers is "[one of]Sharp silhouettes danced in ecstatic gestures across the walls.[or]Shadows of ritual-like movements criss-crossed over the floor.[or]Dark figures danced themselves into trance-like states, their eyes glittering in the dark.[or]The dancers were flowing around the central light battery in a grotesque maelstrom.[or]The dance floor was thundering beneath me with the rhythmic stomping of a hundred pairs of feet.[or]The dancers looked as if they were partaking in a strangely cruel initiation ritual.[or]The participants in tonight's dance went to great lengths to reach the excesses they had come to experience here.[at random]".

The description of the dancers is "[one of]The dancers were a uniform black mass of intertwined limbs.[or]No two of the shadows seemed discrete.[or]It seemed impossible to initiate eye contact with any single individual.[at random]"

Understand "dancer/customer/man/woman/shadow/participant/shadows/figure/figures/maelstrom/people/silhouettes/silhouette/girl/girls/guy/guys/man/men" as the dancers when the location is L-1_danceclub_dancefloor.

Chapter 2 - The conversation

The litany of the dancers is the Table of Dancer Conversation.

The greeting of the dancers is dancer_greeting.

Table of Quip Texts (continued)
quip			quiptext
dancer_greeting		"[if the player is not raving]The [one of]dancers[or]shadows[at random] ignored me altogether.[else if the player carries at least one dose]I seemed to have approached the right person.[else]My efforts were appreciated by even more body contact."
dancer_deal		"The [one of]dancer[or]shadow[at random] took a look at what I had on offer."
dancer_accept		"We quickly exchanged money and merchandise."
dancer_reject		"The [one of]dancer[or]shadow[at random] shrugged."

Table of Dancer Conversation
prompt			response		enabled
"Show the drugs."	dancer_deal		0
"Accept the deal."	dancer_accept		0
"Reject the deal."	dancer_reject		0

Before quipping when the current quip is dancer_greeting:
	if Delivery_2 is happening and the player carries at least one dose and the player is raving:
		enable the dancer_deal quip for the dancers;
		say "[one of]I cautiously approached one of the dancers.[or]I succeeded at initiating eye contact with one of the shadows.[or]I danced closer to someone who looked interested.[at random]";
	else if the player is not raving:
		say "I tried to talk to someone, but it was difficult to approach anyone while standing at the sidelines.";
	else:
		say "Talking to anyone was very difficult in this situation, so I tried to make myself known [one of]via body language.[or]by shaking my hips a bit more.[or]by shaking my shoulders a bit more.[at random]".

After quipping when the current quip is dancer_deal:
	now the player is not raving;
	if a random chance of 5 in 7 succeeds:
		now the ask value is a random price from 10 yen to 16 yen;
		say "[one of]He[or]She[at random] showed me a few notes worth [ask value * 500].";
		enable the dancer_accept quip;
		enable the dancer_reject quip;
	else:
		say "The dancer just shook [one of]his[or]her[at random] head.[line break]I had the wrong person after all.";
		now the player is raving;
		terminate the conversation.

After quipping when the current quip is dancer_accept:
	disable the dancer_reject quip;
	increase the wealth of the player by (ask value * 500);
	increase the wealth of the quick fox by (ask value * 500);
	move a random dose carried by the player to the dancers;
	terminate the conversation;
	now the player is raving;
	If a random chance of 1 in 3 succeeds:
		say "I suddenly felt a hand on my shoulder.[line break]Turning around, I was looking at the artificial redhead, who just slowly shook her head.";
		now the player is not raving;
		move Risa to L-1_danceclub_dancefloor;
		now the player is caught.

After quipping when the current quip is dancer_reject:
	now the player is raving;
	disable the dancer_accept quip;
	terminate the conversation.

Part 12 - JJ

Chapter 1 - The Character

JJ is a man. JJ is in L-1_danceclub_dancefloor. The description of JJ is "A live DJ, something rather old-fashioned." The initial appearance of JJ is "JJ was [one of]putting a vinyl LP back into its envelope.[or]scratching away at the turntable.[or]deciding on the next song to play.[at random]"

Understand "DJ" and "disc jockey" as JJ when the location is L-1_danceclub_dancefloor.

Chapter 2 - JJs possessions

JJ wears earphones.

Chapter 3 - The conversation

The litany of JJ is the Table of JJ Conversation.

The greeting of JJ is JJ_greeting.

Table of Quip Texts (continued)
quip			quiptext
JJ_greeting		"'HI...T...IS...!'"
JJ_just_looking		"'T...EA...G!'"
JJ_Delivery_1		"'TH...OU!'"
JJ_sign_1		"He signed on the pad and waved goodbye."

Table of JJ Conversation
prompt			response		enabled
"'I CAN'T UNDERSTAND A THING, I'M GOING AGAIN!'"	JJ_just_looking		1
"Wave the packet at him."	JJ_Delivery_1		0
"Wave the signing pad at him."	JJ_sign_1		0

Before quipping when the current quip is JJ_greeting:
	if Delivery_1 is happening:
		enable the JJ_Delivery_1 quip for JJ;	
	if the player is raving:
		now the player is not raving;
	say "I made my way to the turntables and waved hello to the DJ.[paragraph break]"

After quipping when the current quip is JJ_just_looking:
	enable the JJ_just_looking quip;
	terminate the conversation.

After quipping when the current quip is JJ_Delivery_1:
	disable the JJ_just_looking quip;
	move parcel_1 to JJ;
	enable the JJ_sign_1 quip.

After quipping when the current quip is JJ_sign_1:
	enable the JJ_just_looking quip;
	now the address of the signpad is "Pickup at:[line break]The Burrow[line break]You know where to find it.[line break]Remember: The albatross has landed.";
	now the _man is not sewered;
	now the _woman is not sewered;
	now sewer lock is open; 
	now sewer lock is locked;
	enable the QF_Pickup_2 quip for the quick fox;
	terminate the conversation.

Part 13 - The quick fox

Chapter 1 - The character

The quick fox is a man. The printed name of the quick fox is "the chinaman".
The quick fox is in L-1_blackmarket. The description of the quick fox is "He looked Chinese." The initial appearance of the quick fox is "In the middle of it all, a man in a wrinkled suit sat on an early qing chair and smiled." 

The quick fox can be payed. The quick fox is not payed.

The quick fox has a number called proliferation. The proliferation is 0.

The wealth of the quick fox is 0 yen.

Understand "chinaman" as the quick fox.

Chapter 2 - The quick foxes possessions

The quick fox wears clothing called a wrinkled suit. The description of the wrinkled suit is "A grey, somewhat faded, three-part suit."

The quick fox carries a privately-named parcel called parcel_2. The printed name of parcel_2 is "a large bundle". The description of parcel_2 is "A large soft bundle wrapped in packing paper."
The feel of parcel_2 is "It had good tactile qualities."

[The quick fox carries a knife called a bayonet. The description of the bayonet is "A kind of bowie knife with a cheap-looking plastic handle. It could be used as a wire cutter in conjunction with its scabbard."

Understand "scabbard/bowie/kalashnikov/ak/ak-47/akm", "kalashnikov/ak/ak-47/akm bayonet", "wire cutter" and "bowie knife" as the bayonet.]

Understand "large soft bundle", "packing/soft/packet/bundle/wrapping", "soft/large bundle" and "packing paper" as parcel_2.

The quick fox carries an ID card called the fake ID. The description of the fake ID is "A well-made forgery of an ID card issued by a licensed supplier. Incidentally I was now of legal drinking age."

The quick fox carries five doses.

Chapter 3 - The conversation

The litany of The quick fox is the Table of QF Conversation.

The greeting of the quick fox is QF_greeting.

Table of Quip Texts (continued)
quip			quiptext
QF_greeting		"[Unless Pickup_2 has ended]'Has Papageno caught the bird?'[else]'Yes?'"
QF_wrong_1		"'I will wait until he does.'[paragraph break]His smile was unwavering."
QF_wrong_2		"'Has he really? I can hardly believe that.'[paragraph break]His smile was unwavering."
QF_Pickup_2		"'That is most timely. Take good care of it.'"
QF_sign_1		"'Certainly.'"
QF_need_ID		"'Yes.'"
QF_no_ID		"'How unfortunate. I might be able to help, though.'"
QF_depends		"'That depends on your willingness to carry an ID that doesn't display your real name and to pay the price it will cost.'"
QF_name_price		"'17000 yen.'"
QF_thanks_come_again	"'Thank you very much. Come again.'"
QF_not_joking		"'Unfortunately I am not joking at all. That is the price. I might be able to help, though.'"
QF_good_luck		"'I can assure you of my merchandise's quality, but by all means, try your luck elsewhere first. Please make sure the delivery isn't delayed.'"
QF_drug_courier		"'That depends on your willingness to sell a certain product at a certain place and to accept the risk this entails.'"
QF_accella_details	"'There is a certain club in the vicinity of Gotomomi station by the name of 'Martyrium'. I would give you a good rate if you manage to sell a small quantity of accella there.'"
QF_whats_accella	"'Because it is a nano-mechanism, rather than a substance, it can not be found on the list of controlled substances. A convenient situation for me. Nevertheless the authorities tend to confiscate all they can get their hands on.'"
QF_cut_rate		"'That depends on your success as a seller. But you don't need to leave any relative as a hostage while you're gone with my merchandise, because I know you will come back.'"
QF_dirty_deed		"'I have come to expect very little of youth as far as morals are concerned.'"
QF_confucius		"'The price on the street is about 5000 yen per dose. Maybe you can make more in the club.'"
QF_tell_again		"'Of course.'"
QF_maybe		"'That depends on your ability to provide some kind of proof of such a claim and your willingness to pay for the necessary expenses.'"
QF_prove_it		"After reading the Letter, the man said:'Yes, I should be able to give you a special price in these circumstances. But a good forgery never comes cheap. It will still cost you 5000 yen.'"
QF_get_cheap		"'Thank you very much, give my regards to your employer.'"
QF_later		"'Please come back when you do.'"
QF_done			"'Very good. How much did you make?'"
QF_true			"'That sounds good. You may keep [wealth of the quick fox / 2].'"
QF_just_looking		"'Not exactly window shopping, is it?'"

Table of QF Conversation
prompt							response		enabled
"'Yes.'"						QF_wrong_2		1
"'No.'"							QF_wrong_1		1
"'The albatross has landed.'"				QF_Pickup_2		0
"'Would you sign here please.'"				QF_sign_1		0
"'I will need an ID to get into the mall.'"		QF_need_ID		0
"'I don't have an ID.'"					QF_no_ID		0
"'How can you help?'"					QF_depends		0
"'How much for a fake ID?"				QF_name_price		0
"'Surely you must be joking. I can not afford that much.'"	QF_not_joking		0
"'I see. Maybe I should look somewhere else first.'"	QF_good_luck		0
"'OK. Here you go: 17.000 yen for the fake ID.'"	QF_thanks_come_again	0
"'How can you help?'"					QF_drug_courier		0
"'What exactly do I have to do?'"			QF_accella_details	0
"'What's accella?'"					QF_whats_accella	0
"'What's my cut?'"					QF_cut_rate		0
"'I'll do your dirty deed for you.'"			QF_dirty_deed		0
"[italic type]'The superior man understands what is right. The inferior man understands what will sell.'[roman type]"				QF_confucius		0
"[italic type]'The good do not need laws to tell them to act responsibly, while the wicked will find a way around the laws.'[roman type]"		QF_confucius		0
"'Can we talk again about the forgery you were offering?'"	QF_tell_again		0
"'My employer says I can get a fake ID from you at a discount.'"	QF_maybe	0
"'I have this letter.'"					QF_prove_it		0
"'Here you go: 5.000 yen for the fake ID.'"		QF_get_cheap		0
"'I don't have the necessary cash on hand right now.'"	QF_later		0
"'The deed's done.'"					QF_done			0
"'[The wealth of the quick fox].'"			QF_true			0
"'I just came to take a look at the place.'"		QF_just_looking		0

Before quipping when the current quip is QF_greeting:
	if Pickup_2 is happening:
		enable the QF_Pickup_2 quip for the quick fox;
	else if Dealing is happening:
		disable the QF_tell_again quip for the quick fox;
		if the player carries no dose:
			if the wealth of the player is greater than the wealth of the quick fox:
				enable the QF_done quip for the quick fox;
	else if Delivery_2 is happening and the player carries the letter:
		enable the QF_maybe quip for the quick fox;
	else if Dealing has ended and the player is not carrying the fake ID and the wealth of the player is greater than 16999 yen:
		enable the QF_thanks_come_again quip for the quick fox;
	say "I said [italic type]'nihao'[roman type] to the man."
	
After quipping when the current quip is QF_wrong_1:
	enable the QF_wrong_1 quip;
	terminate the conversation.

After quipping when the current quip is QF_wrong_2:
	enable the QF_wrong_2 quip;
	terminate the conversation.

After quipping when the current quip is QF_Pickup_2:
	disable the QF_wrong_1 quip;
	disable the QF_wrong_2 quip;
	say "The man in the wrinkled suit handed me a large bundle.";
	move parcel_2 to the player;
	enable the QF_sign_1 quip;

After quipping when the current quip is QF_sign_1:
	say "He signed on the signing pad.";
	now the address of the signpad is "Delivery to:[line break]Utsunomiya Agnieska[line break]The Arisaka mall building, ground floor.";
	if the player carries no ID card:
		enable the QF_need_ID quip;
		enable the Kei_what_about_it quip for Kei;
	enable the QF_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is QF_need_ID:
	disable the QF_just_looking quip;
	enable the QF_no_ID quip.
	
After quipping when the current quip is QF_no_ID:
	enable the QF_depends quip.

After quipping when the current quip is QF_depends:
	enable the QF_good_luck quip;
	enable the QF_name_price quip.

After quipping when the current quip is QF_name_price:
	enable the QF_not_joking quip;
	enable the QF_good_luck quip;
	if the wealth of the player is greater than 16999 yen:
		enable the QF_thanks_come_again quip.

After quipping when the current quip is QF_not_joking:
	disable the QF_thanks_come_again quip;
	enable the QF_drug_courier quip.

After quipping when the current quip is QF_drug_courier:
	enable the QF_accella_details quip.
	
After quipping when the current quip is QF_accella_details:
	enable the QF_whats_accella quip;
	enable the QF_cut_rate quip.
	
After quipping when the current quip is QF_cut_rate:
	disable the QF_whats_accella quip;
	enable the QF_dirty_deed quip.

After quipping when the current quip is QF_dirty_deed:
	disable the QF_good_luck quip;
	enable the QF_confucius quip.

After quipping when the current quip is QF_confucius:
	say "With a nod of recognition he handed me five doses of accella.";
	repeat with X running through all things carried by the quick fox:
		if X is a dose:
			move X to the player;
	disable the QF_confucius quip;
	[disable the Kei_what_about_it quip for Kei;]
	enable the QF_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is QF_tell_again:
	enable the QF_name_price quip.

After quipping when the current quip is QF_good_luck:
	disable the QF_not_joking quip;
	disable the QF_name_price quip;
	disable the QF_drug_courier quip;
	disable the QF_accella_details quip;
	disable the QF_whats_accella quip;
	disable the QF_cut_rate quip;
	disable the QF_dirty_deed quip;
	enable the QF_tell_again quip;
	terminate the conversation.

After quipping when the current quip is QF_thanks_come_again:
	disable the QF_good_luck quip;
	disable the QF_not_joking quip;
	disable the QF_name_price quip;
	decrease the wealth of the player by 17000 yen;
	move the fake ID to the player;
	say "The man handed me an ID card.";
	disable the Kei_what_about_it quip for Kei;
	enable the QF_just_looking quip;
	terminate the conversation.

After quipping when the current quip is QF_maybe:
	disable the QF_just_looking quip;
	enable the QF_prove_it quip.

After quipping when the current quip is QF_prove_it:
	move the letter to the quick fox;
	if the wealth of the player is greater than 4999 yen:
		enable the QF_get_cheap quip;
	enable the QF_later quip.

After quipping when the current quip is QF_get_cheap:
	decrease the wealth of the player by 5000 yen;
	move the fake ID to the player;
	say "The chinaman handed me an ID card.";
	disable the QF_later quip;
	enable the QF_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is QF_later:
	disable the QF_get_cheap quip;
	say "He handed me back the letter.";
	move the letter to the player;
	enable the QF_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is QF_done:
	disable the QF_just_looking quip;
	enable the QF_true quip.

After quipping when the current quip is QF_true:
	decrease the wealth of the player by the wealth of the quick fox;
	increase the wealth of the player by the wealth of the quick fox / 2;
	now the quick fox is payed;
	disable the QF_tell_again quip;
	enable the QF_just_looking quip;
	terminate the conversation.

After quipping when the current quip is QF_just_looking:
	enable the QF_just_looking quip;
	terminate the conversation.


Part 14 - Agnieszka

Chapter 1 - The Character

Agnieszka is a woman. Agnieszka is in L0_boutique. The printed name of Agnieszka is "the well-dressed woman". The description of Agnieszka is "She seemed ageless in her grey costume." The initial appearance of Agnieszka is "A well-dressed woman [one of]was doing some paperwork[or]was hanging some clothes[at random]."

Understand "well-dressed/woman" as Agnieszka when the location is L0_boutique.

Agnieszka can be peopled. Agnieszka is not peopled.

Chapter 2 - Agniezkas possessions

Agnieszka wears clothing called a costume. The description of the costume is "A well-tailored grey costume."

Agnieska carries wafuku called a furisode. The printed name of the furisode is "[italic type]furisode[roman type]".
The furisode is fitting. The furisode is sell-able. The minimum value of the furisode is 30000 yen. The desired value of the furisode is 100000 yen. The description of the furisode is "A splendid [italic type]kakitsubata kimono[roman type]."
Understand "kimono/kakitsubata" as the furisode.

Agnieszka carries a  sash called a fukoro obi. The printed name of the fukoro obi is "[italic type]fukoro obi[roman type]". The fukoro obi is fitting. The description of the fukoro obi is "This  was a full-length embroidered masterpiece of a sash. [if the player wears the fukoro obi]It was currently tied in a [italic type][knot of a random sash worn by the player][roman type]." The fokoro obi is sell-able. The minimum value of the fukoro obi is 50000 yen. The desired value of the fukoro obi is 150000 yen.

Agnieszka carries sandals called some zouri. The printed name of the zouri is "[italic type]zôri[roman type]". The zouri are fitting. The zouri are sell-able. The minimum value of the zouri is 6000 yen. The desired value of the zouri is 18000 yen. The description of the zouri is "A pair of straw sandals. It came with a pair of [italic type]tabi[roman type] socks."
Understand "tabi/zori/sandals" as the zouri.

Chapter 3 - The conversation

The litany of Agnieszka is the Table of Agnieszka Conversation.

The greeting of Agnieszka is Agnieszka_greeting.

Table of Quip Texts (continued)
quip			quiptext
Agnieszka_greeting	"'[italic type]konbanwa[roman type]. Is there anything I can help you with?'"
Agnieszka_just_looking	"'Just tell me if you need anything.'"
Agnieszka_delivery	"'Ah yes, I've been waiting for this. Thank you very much.'"
Agnieszka_sign		"'Of course, here you go. Do you need anything else?'"
Agnieszka_offer		"'Thank you, all dresses are of our own manufacture.'"
Agnieszka_self		"'Only the textiles. The rest are commissions from other artisans. But I only offer quality products throughout.'"
Agnieszka_handcrafted	"'Reasonably well, yes, why do you ask?'"
Agnieszka_mall		"'Yes, just here. This is the only store where you can get a genuine Utsunomiya dress.'"
Agnieszka_gotomomi	"'I have some customers who come out here specifically to buy my products. Also, you'll be surprised to hear I have a number of local patrons. Say, what else can I do for you?'"
Agnieszka_buy		"'Certainly. Do you need [italic type]wafuku[roman type] or [italic type]yôfuku[roman type]?'"
Agnieszka_wafuku	"'Then may I suggest this [italic type]furisode[roman type]? The colour scheme would suit you perfectly.'"
Agnieszka_price_furisode		"'Yes, of course. I'll make you a special offer of just 180000 yen. Please don't tell anyone I gave it up for such a trivial sum, though. I think it's perfect for you, and it'd be a waste not to dress you in it.'"
Agnieszka_no_furisode		"'Please come back if you change your mind. It would look splendid on you.'"
Agnieszka_again_furisode		"'The one that would fit you so well? The price was 180000 yen for you.'"
Agnieszka_yes_furisode		"'An excellent choice.'"
Agnieszka_price_obi			"'For you, it's just 320000 yen. But only because I really cannot let you off without a fitting [italic type]obi[roman type].'"
Agnieszka_no_obi		"'Please come back if you change your mind. It would look splendid on you.'"
Agnieszka_again_obi		"'The one that would go so well with your [italic type]kimono[roman type]? The price was 320000 yen for you.'"
Agnieszka_yes_obi		"'You will look breathtaking in it.'"
Agnieszka_price_zouri	"'They're yours for 25.000 yen and I will also include a pair of [italic type]tabi[roman type].'"
Agnieszka_no_zouri		"'Please come back if you change your mind. You will really need them to complete the outfit.'"
Agnieszka_again_zouri		"'Yes, I remember. The price for you was 25000 yen.'"
Agnieszka_yes_zouri		"'These complete a fine outfit.'"

Table of Agnieszka Conversation
prompt					response		enabled
"'Nothing right now, thank you. I'm just looking.'"	Agnieszka_just_looking	1
"'CityTrafficking courier service. I'm bringing you this package."	 Agnieszka_delivery	0
"'You sure have some nice things on offer here.'"	Agnieszka_offer	0
"'So you've made all these yourself?'"	Agnieszka_self		0
"'If you don't mind me asking: do such handcrafted things sell well here?'"	Agnieszka_handcrafted	0
"'And you sell your handywork in this mall only?'"	Agnieszka_mall	0
"'It sure seems unusual to sell such nice things in Gotomomi of all places. Everyone I've talked to hates it here.'"	Agnieszka_gotomomi	0
"'If you'd sign here, please.'"		Agnieszka_sign		0
"'I'd like to buy something to wear for tonight.'"	Agnieszka_buy		0
"'I like japanese style better.'"		Agnieszka_wafuku		0
"'I think I like it. May I ask how much it is?'"		Agnieszka_price_furisode		0
"'That's very considerate, thank you very much. I'll take your offer.'"		Agnieszka_yes_furisode		0
"'I think I'll have to pass this opportunity.'"		Agnieszka_no_furisode	0
"'I have been thinking about the [italic type]furisode[roman type] you had on offer.'"	Agnieszka_again_furisode		0
"'It really is very nice. A fantastic work of art, I should say. How much would you want for it?'"	Agnieszka_price_obi	0
"'I would like to take up you offer.'" 	Agnieszka_yes_obi		0
"'As much as I'd like to, I can't take up your offer.'"		Agnieszka_no_obi	0
"'I have been thinking about the [italic type]fukoro obi[roman type] you had on offer.'"	Agnieszka_again_obi		0
"'Yes, of course. I shall need those.'"	Agnieszka_price_zouri	0
"'I would like to buy them.'" 	Agnieszka_yes_zouri		0
"'I don't want them after all.'"		Agnieszka_no_zouri	0
"'I have been thinking about the [italic type]zôri[roman type] you had on offer.'"	Agnieszka_again_zouri		0

Before quipping when the current quip is Agnieszka_greeting:
	if Delivery_2 is happening:	
		enable the Agnieszka_delivery quip for Agnieszka;
	if Agnieszka is not peopled:
		enable the Agnieszka_offer quip;
	say "I said [italic type]'konbanwa'[roman type] to the woman.[paragraph break]".

After quipping when the current quip is Agnieszka_just_looking:
	enable the Agnieszka_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is Agnieszka_delivery:
	move parcel_2 to Agnieszka;
	say "I handed her the package.";
	disable the Agnieszka_just_looking quip;
	disable the Agnieszka_offer quip;
	enable the Agnieszka_sign quip.
	
After quipping when the current quip is Agnieszka_sign:
	say "The woman signed on the signing pad.";
	now the address of the signpad is "Pickup at:[line break]Studio Yamaguchi[line break]Arisaka mall building, floor 104.";
	now the sewer lock is closed;
	now the sewer lock is locked;
	enable the Agnieszka_just_looking quip;
	if Agnieszka is not peopled:
		enable the Agnieszka_offer quip;
	
After quipping when the current quip is Agnieszka_offer:
	disable the Agnieszka_just_looking quip;
	disable the Agnieszka_delivery quip;
	enable the Agnieszka_self quip.

After quipping when the current quip is Agnieszka_self:
	enable the Agnieszka_handcrafted quip;
	enable the Agnieszka_mall quip;

After quipping when the current quip is Agnieszka_handcrafted:
	disable the Agnieszka_mall quip;
	enable the Agnieszka_gotomomi quip.

After quipping when the current quip is Agnieszka_mall:
	disable the Agnieszka_handcrafted quip;
	enable the Agnieszka_gotomomi quip.
	
After quipping when the current quip is Agnieszka_gotomomi:
	now Agnieszka is peopled;
	if Delivery_2 is happening:	
		enable the Agnieszka_delivery quip for Agnieszka;
	enable the Agnieszka_just_looking quip;
	enable the Agnieszka_buy quip.
	
After quipping when the current quip is Agnieszka_buy:
	disable the Agnieszka_just_looking quip;
	enable the Agnieszka_wafuku quip.
	
After quipping when the current quip is Agnieszka_wafuku:
	enable the Agnieszka_price_furisode quip.

After quipping when the current quip is Agnieszka_price_furisode:
	enable the Agnieszka_no_furisode quip;
	if the wealth of the player >= 180000 yen:
		enable the Agnieszka_yes_furisode quip;

After quipping when the current quip is Agnieszka_no_furisode:
	disable the Agnieszka_yes_furisode quip;
	enable the Agnieszka_just_looking quip;
	enable the Agnieszka_again_furisode quip;
	terminate the conversation.

After quipping when the current quip is Agnieszka_again_furisode:
	disable the Agnieszka_just_looking quip;
	enable the Agnieszka_no_furisode quip;
	if the wealth of the player >= 180000 yen:
		enable the Agnieszka_yes_furisode quip;

After quipping when the current quip is Agnieszka_yes_furisode:
	disable the Agnieszka_no_furisode quip;
	decrease the wealth of the player by 180000 yen;
	say "I handed her a load of cash.[paragraph break]";
	move the furisode to the player;
	say "She handed me the neatly folded [italic type]kimono[roman type].[paragraph break]";
	say "'I would suggest you combine it with this very nice [italic type]obi[roman type].'[paragraph break]";
	enable the Agnieszka_price_obi quip;
	
After quipping when the current quip is Agnieszka_price_obi:
	enable the Agnieszka_no_obi quip;
	if the wealth of the player >= 320000 yen:
		enable the Agnieszka_yes_obi quip;

After quipping when the current quip is Agnieszka_no_obi:
	disable the Agnieszka_yes_obi quip;
	enable the Agnieszka_just_looking quip;
	enable the Agnieszka_again_obi quip;
	terminate the conversation.

After quipping when the current quip is Agnieszka_again_obi:
	disable the Agnieszka_just_looking quip;
	enable the Agnieszka_no_obi quip;
	if the wealth of the player >= 320000 yen:
		enable the Agnieszka_yes_obi quip;

After quipping when the current quip is Agnieszka_yes_obi:
	disable the Agnieszka_no_obi quip;
	decrease the wealth of the player by 320000 yen;
	say "I handed her a wheelbarrow of money.[paragraph break]";
	move the fukoro obi to the player;
	say "She handed me the neatly folded [italic type]fukoro obi[roman type].[paragraph break]";
	say "'To complete the outfit, you should wear these [italic type]zôri[roman type].'[paragraph break]";
	enable the Agnieszka_price_zouri quip;

After quipping when the current quip is Agnieszka_price_zouri:
	enable the Agnieszka_no_zouri quip;
	if the wealth of the player >= 25000 yen:
		enable the Agnieszka_yes_zouri quip;

After quipping when the current quip is Agnieszka_no_zouri:
	disable the Agnieszka_yes_zouri quip;
	enable the Agnieszka_just_looking quip;
	enable the Agnieszka_again_zouri quip;
	terminate the conversation.

After quipping when the current quip is Agnieszka_again_zouri:
	disable the Agnieszka_just_looking quip;
	enable the Agnieszka_no_zouri quip;
	if the wealth of the player >= 25000 yen:
		enable the Agnieszka_yes_zouri quip;

After quipping when the current quip is Agnieszka_yes_zouri:
	disable the Agnieszka_no_zouri quip;
	decrease the wealth of the player by 25000 yen;
	say "I handed her some change, really.[paragraph break]";
	move the zouri to the player;
	say "She handed me the [italic type]zôri[roman type] and the [italic type]tabi[roman type].[paragraph break]";
	say "'Thank you very much. Have a nice evening with your new clothes.'[paragraph break]";
	enable the Agnieszka_just_looking quip;
	terminate the conversation.


Part 15 - Yamaguchi

Chapter 1 - The Character

Yamaguchi is a man. Yamaguchi is in L3_studio. The printed name of Yamaguchi is "[if Yamaguchi is acquainted]Yamaguchi[else]the painter". The description of Yamaguchi is "His smock was splattered in paint and he needed a haircut." The initial appearance of Yamaguchi is "[if Yamaguchi is acquainted]Yamaguchi[else]The painter[end if] [one of]eyed me through his spectacles[or]stood beside the easel, his hands in the pockets of his smock[at random]."

Yamaguchi can be painting. Yamaguchi is not painting.
Yamaguchi can be honored. Yamaguchi is not honored.

Understand "painter/man/artist" as Yamaguchi when the location is L3_studio.

Chapter 2 - Yamaguchis possessions

Yamaguchi wears clothing called a smock. The description of the smock is "It was stained with colour specks."
Understand "speck/specks" as the smock when the location is L3_studio.
Yamaguchi wears spectacles. The spectacles are plural-named. The description of the spectacles is "Round lenses, brass frame."
Understand "glasses/lens/lenses/brass/frame" as the spectacles when the location is L3_studio.

Yamaguchi carries a parcel called parcel_3. The printed name of parcel_3 is "wrapped painting". The description of parcel_3 is "It was obviously one of Yamaguchi's paintings wrapped in brown packing paper."

Understand "wrapped painting" and "wrapped/painting/packing/brown/paper/package" as parcel_3.


Chapter 3 - The conversation

The litany of Yamaguchi is the Table of Yamaguchi Conversation.

The greeting of Yamaguchi is Yamaguchi_greeting.

Table of Quip Texts (continued)
quip			quiptext
Yamaguchi_greeting	"[if Posing is happening]'Not at all. What would you like to talk about?'[else if Pickup_3 is happening]'Hello there. Have you come because of the advert?'[else if Yamaguchi is acquainted]'Hello Ayako, what can I do for you?'[else]'Hello there. What can I do for you?'"
Yamaguchi_just_looking	"'Well then, have a nice evening.'"
Yamaguchi_aha		"After a while he spoke up:[paragraph break]'Although it would have been utter perfection, if you allow me to say so.'"
Yamaguchi_pickup	"'Ah yes, of course. Here it is. Please be careful with it.'"
Yamaguchi_sign	"'And...here you go.'"
Yamaguchi_perfect	"'Everything. The night that is yet young and your tender age. The white nothingness of this studio and your porcelain complexion. The starless sky outside the window and your endless raven hair. The many neon lights in the streets, promising yet unvaryingly ruinous and your many freckles, which show not only above your collar, but also below your cuffs. The soulless building we are in, all but abandoned for the night and the abandonment I see in your eyes, dark and bottomless, like the despair we feel when we look into a mountain lake at night, and just as cold. It all seems like a strangely contorted mirror image to me.'"
Yamaguchi_true		"'Yes, but the reverse is also true: there can never be true beauty without it being for one moment alone. If I am not mistaken, though, this petal has only just detached and still has a long way to fall. Also, there are ways to preserve at least a vivid memory of such a moment. Which brings us straight to the point: will you or won't you?'"
Yamaguchi_false		"'Thomas Aquinas wouldn't have minded, I'm sure. Being a man of his times, he would have preferred the flawless, but virtual over the real, but marred.'"
Yamaguchi_thomas	"'Petrach did, as did Erasmus later on and of course a few more of the well known circle. Others held him in high esteem, just like they did with the thinkers of antiquity. It took more than a couple of clerks of the Florence chancellery and certainly more than a few decades of intellectual restoration to come up with the reply you so easily assume to be common sense. I for one won't entirely dismiss his kind of idealism.'"
Yamaguchi_benjamin	"'Very funny. [italic type]'For the first time in world history, mechanical reproduction emancipates the work of art from its parasitical dependence on ritual.'[roman type] I see it hasn't escaped your wits that I am a painter of oil paintings after all. You may call me old-fashioned if you want.'"
Yamaguchi_baudrillard	"'In some way, I should hope. [italic type]'Disneyland is presented as imaginary in order to make us believe that the rest is real.'[roman type] A little idealism can't hurt even in these times of semantic poverty. You may call me old-fashioned if you want.'"
Yamaguchi_compliment	"'Thank you, I will take that as a compliment. Old-fashioned young ladies would have simply said 'thank you' when they were complimented, by the way.'"
Yamaguchi_butterfly	"'Great thinkers have always wanted to believe this quality existed. Plato, Descartes, Kant...but even Zhuang Zhou was hard pressed to pinpoint it, having put the problem so nicely. Do you think this is a direction worth going very far? I am not much of a believer as far as religion is concerned, but that doesn't stop me from following an artistic ideal.'"
Yamaguchi_choice	"'I understand completely, of course, being in much the same predicament. Which incidentally brings us back to the original point: will you or won't you?'"
Yamaguchi_monetary	"'I should add that I am of course willing to pay some compensation for your time.'"
Yamaguchi_please	"'Quite the contrary, I'd say. You not accepting anything in return would take away a vital element of the moment we are trying to convey. By agreeing voluntarily you would be adding an element of [italic type]l'art pour l'art[roman type] that is contrary to the sad reality of monetary need and the picturesque moral bankruptcy this entails.'"
Yamaguchi_objections	"'Yes, I understood that much. But you see, painting a severely underage girl who can be easily bought is not in my interest at all. I could just as well get some common girl down in the streets to model for me. But I won't, because the result would not be convincing. It is precisely the violation of your sense of decency that I wish to portrait. I'm sure you agree this kind of objectification is a much more refined artistic undertaking than merely producing a copy of your physical attractiveness.'"
Yamaguchi_no_means_no	"'You're certainly right. Perhaps it is for the best. I must confess, it does leave me a little sad. Of course, this studio is always open for you if you ever change your mind.'"
Yamaguchi_antiquity	"'Don't play naive. I'm sure you know full well only a certain minority of the existent sculptures is shown to the public. Not to mention, the reception of what [italic type]is[roman type] shown was not always as asexual as it is meant to be today.'"
Yamaguchi_japan		"'I see this as an exercise in a kind of aestheticism not unknown to other times and places. Consider some of the European genre painting of the 19th or even of earlier centuries. Or look at impressionism. Or expressionism. Don't we look at a work of Otto Dix, who certainly considered his subject matter obscene, with a feeling of aesthetic satisfaction? To put it even more radically, isn't anything that pleases our senses essentially [italic type]Kitsch[roman type]? But I am obviously working for a specific market, and in that regard, there may be some truth to what you said. Yet, does that have to concern us? It is the viewers fantasy that commits the crime.'"
Yamaguchi_answer	"'I'm trying my best. Just like you are trying your best at beating around the bush.'"
Yamaguchi_how_much	"'I will give you 15.000 yen, and there will be a portrait in oil of you. How does that sound to you?'"
Yamaguchi_agree	"'Thank you, you don't know how happy this makes me. I had almost given up on you. If you'd be so kind to undress while I get my stuff ready.'"
Yamaguchi_disagree	"'Perhaps it's for the best this way. My studio is, of course, open to you any time if you change your mind.'"
Yamaguchi_thought	"'Did you come to a conclusion?'"
Yamaguchi_start	"'Shall we start then?' asked the painter."
Yamaguchi_no_escape	"'If you didn't want to do this, you could have told me earlier. There can be no chickening out now, I'm afraid. It would haunt your conscience forever.' said the painter as I tried to sneak away."
Yamaguchi_no_talk	"'You'd better get ready. We can continue our fascinating conversation when we are all set up.' said Yamaguchi and continued his preparations."
Yamaguchi_lets_see	"'Sit down over there, in front of the window. That should work.'"
Yamaguchi_yes_good	"'Yes. Cross your legs...like that, exactly. Now, please don't move anymore until I tell you.'"
Yamaguchi_dont_move	"Yamaguchi stopped me in my tracks: '[One of]Now, please don't move even a little. It's impossible to get the proportions correct if you do[or]Please, you have to stay as motionless as possible right now[or]Would you be so kind and stay still for a little longer? It won't take long[at random].'"
Yamaguchi_concentrate	"'I'm sorry, I can't talk right now. The first sketch takes a lot of concentration. I will get back to you in a minute.'"
Yamaguchi_work		"'Only since I came here. I used to do different things, but they wouldn't sell.'"
Yamaguchi_came		"'It was an economic decision. Far more rational than the deliberations I imagine all those poor devils down in the streets took before they were swallowed whole by this place.'"
Yamaguchi_place		"'It is not necessarily the city of my dreams, to put it diplomatically. The architecture is not conductive to idealistic imagination and its population won't offset that in the least. But then again, I can make a living here, unlike many less fortunate inhabitants. I'd be interested in your opinion on this, though. Tell me, what is it that you dislike most about this place?'"
Yamaguchi_sell		"'No, they are not really mine anymore for the most part. I am not in a position to paint what I like anymore. The tastes of this city are very different from my own. At least those of my patrons. I doubt much can be said about the tastes of its less fortunate inhabitants. But I am sure you must reject the locale in much the same way. Tell me, what is it that you dislike most about this place?'"
Yamaguchi_art		"'As I'm sure you are aware, there are no art schools nowadays anywhere that still teach oil painting, it's all CGI now. Drawing was, however, until recently still on the syllabus. So that's where I started. Shortly after my graduation, I had the opportunity to go abroad and study painting with a foreign connoisseur.'"
Yamaguchi_connoisseur	"'It was indeed an interesting experience. I was still so young at the time. My Patron provided for the expenses and created many opportunities for me. He was an amateur, to be sure, but his interest in painting was genuine. He taught me the technique. I lived at his place, which was beautiful - a country home by Frank Lloyd Wright himself - but I divagate. It is not just in this city that everything comes at a price.'"
Yamaguchi_different	"'What he did was in some ways much worse, if that is what you wanted to hear. But truthfully, you don't think of it like that at all, don't you? Suffering can be an art as well, can it not? It's all a question of [italic type]niveau[roman type] for you, isn't it?'"
Yamaguchi_niveau	"'I should say I seem to have hit the nail on the head, but [italic type]ex post facto[roman type] that's a little unfair. Let's see...at the very least you're sitting here and I'm painting you. I think I'm not even too far off the mark when I say I have found a kindred spirit. Although I have to admit you had to take the abysmal competition into consideration. So, tell me - since you're clearly from somewhere else - what do you detest most about this place? I'd like to hear it from your mouth.'"
Yamaguchi_decay		"'The physical or the moral?'"
Yamaguchi_physical	"'Don't you think it has a certain aesthetic quality? I for one can't help myself to feel that way. Anyway, on a more serious note, I don't see it as the most pressing problem we're facing here. Isn't the physical decay just a symptom of the moral after all?'"
Yamaguchi_worthless	"'In my eye, it all seems like the never ending effect of rural exodus. I'm sure you can follow me in this. But how can you still blame anyone for that today?'"
Yamaguchi_moral	"'I would tend to agree. Of course that doesn't mean much because you haven't told me whos. Who do you think contributes most to the moral decay?'"
Yamaguchi_degenerates	"'They are a sorry sight indeed. As a last straw I allow myself to sometimes entertain doubts about their standards - or even, when I am at my most generous - that of their socialisation, [italic type]before[roman type] they chose to come here. The way down may not have been so long after all. That may be very different for others who [italic type]had[roman type] to degenerate quite a bit to become what they are now, though perhaps in less visible ways.'"
Yamaguchi_debauchery	"'It's exquisite, isn't it? Everyone's, if you ask me, even though there are certainly many ways to Rome.'"
Yamaguchi_newcomers	"'You may be right about their failings. But I trust you will change your opinion about their impact on the state of this city if you ever meet any of my patrons. I could arrange a meeting if you like.'"
Yamaguchi_establishment	"'It's interesting you are saying that, even though I trust you haven't had the opportunity to meet any of my patrons. I could arrange a meeting if you like.'"
Yamaguchi_sheep		"'You may be right about their failings. But I trust you will change your opinion about their impact on the state of this city if you ever meet any of my patrons. I could arrange a meeting if you like.'"
Yamaguchi_wolves	"'It's interesting you are saying that, even though I trust you haven't had the opportunity to meet any of my patrons. I could arrange a meeting if you like.'"
Yamaguchi_meet		"'You've seen it happen before. I suspected it the moment I looked in your eyes, of which I have already told you. This is, by the way, precisely the reason why I'd like to introduce you to some of my patrons. You will most likely despise them. And contempt from someone like you is what these people need. Would you like me to arrange a meeting?'"
Yamaguchi_interested	"'Well, maybe you should think about that on your own for a little. More importantly, we're finished here for the moment. You may put on your clothes. Also, here is your money.'"
Yamaguchi_name		"'There have been people who modeled for me and wanted to stay anonymous, so I thought it wouldn't be appropriate to ask. But I'd be honored to learn your name. Be warned though, it might end up as the title of this painting.'"
Yamaguchi_ayako		"'That's a very appropriate handle for the enigma you are. I'm Yamaguchi, [italic type]dôzô yoroshiku[roman type]. It has been a pleasure painting you, Ayako.'"
Yamaguchi_thanks	"'It's nothing, you're very welcome. I trust we'll meet again.'"
Yamaguchi_patron	"'Well, perhaps, technically speaking. But I need to finish this painting first so he can decide if he wants to meet you. Come back in a while when I've had a chance to show him the finished work.'"

Table of Yamaguchi Conversation
prompt	response	enabled
"'Oh, sorry. Wrong door.'"	Yamaguchi_just_looking	1
"'No. I've come to pick something up.'"	Yamaguchi_pickup	0
"'Please sign here.'"	Yamaguchi_sign		0
"Take a long look at him."	Yamaguchi_aha	0
"Turn the face sideways, blushing."	Yamaguchi_aha	0	
"'Perfection? What do you mean?'"	Yamaguchi_perfect	0
"'Thank you, but like all true beauty, this moment is but fleeting and cannot last.'"	Yamaguchi_true	0
"'Unfortunately, theoretical perfection cannot be forced on reality, though some maintain that was once different, on some island.'"	Yamaguchi_false	0
"'Which, come to think of it, may be the reason why many a Renaissance humanist would reject his line of thinking.'"	Yamaguchi_thomas	0
"'Walter Benjamin would surely have agreed with you.'"	Yamaguchi_benjamin	0
"'Jean Baudrillard would surely have agreed with you.'"	Yamaguchi_baudrillard	0
"'Which, come to think of it, assumes some quality of reality that allows us to recognize it as such.'"	Yamaguchi_butterfly	0
"'You're old-fashioned.'"	Yamaguchi_compliment	0
"'I wouldn't put it that way.'"	Yamaguchi_compliment	0
"'I'm awfully sorry, but I just couldn't resist.'"	Yamaguchi_choice	0 
"'I'm not always old-fashioned.'"	Yamaguchi_choice	0
"'I've always wanted to do this.'"	Yamaguchi_monetary	0
"'I wouldn't dare.'"	Yamaguchi_monetary	0
"'I'm not sure if I can accept this. It doesn't feel appropriate.'"	Yamaguchi_please	0
"'How much will you pay me?'"	Yamaguchi_how_much	0
"'My objections are more principal in nature.'"	Yamaguchi_objections	0
"'What happened to the innocent idealisation of the human body we have been holding so dear since antiquity?'"	Yamaguchi_antiquity	0
"'I had forgotten for a moment we are still in Japan, where perversion is considered a form of art.'"	Yamaguchi_japan	0
"'You do seem to have a rather long answer to everything.'"	Yamaguchi_answer	0
"'No means no.'"	Yamaguchi_no_means_no	0
"'It sounds like a reasonable arrangement to me.'"	Yamaguchi_agree		0
"'I could not possibly sell my image so cheaply.'"	Yamaguchi_disagree		0
"'I have thought about your proposition.'"		Yamaguchi_thought	0
"'What do I do?'"	Yamaguchi_lets_see	0
"'Is this good?'"	Yamaguchi_yes_good	0
"'Do you often do this kind of painting?'"	Yamaguchi_work	0
"'It sure is unusual to see anyone do a colour picture by hand. Where did you learn how to paint?'"	Yamaguchi_art	0
"'Is that the reason why you came here?'"	Yamaguchi_came	0
"'And your paintings sell here?'"	Yamaguchi_sell	0
"'Don't you like Gotomomi?'"	Yamaguchi_place	0
"'That sounds interesting. What kind of person was he?'"		Yamaguchi_connoisseur	0
"'Seems like quite the adventure. How were you able to go there?'"	Yamaguchi_connoisseur	0
"'I see. How is that different from what you are doing right now?'"	Yamaguchi_different	0
"'How can you say that so condescendingly? Aren't the good and the beautiful just two sides of the same coin?'"	Yamaguchi_niveau	0
"'I could give that right back to you. Willingly suffering this depravity because of its superficial likeness to certain aesthetic traditions of the 19th century.'"	Yamaguchi_niveau	0
"'Countenance in the face of hardships is one of the nobler aims of a proper education, not a fault in character.'"		Yamaguchi_niveau	0
"'The decay.'"	Yamaguchi_decay	0
"'The physical. It cannot escape scrutiny'"	Yamaguchi_physical	0
"'There isn't a worthless place without someone around to make it even more worthless.'"	Yamaguchi_worthless	0
"'Sure, but that doesn't make it any more appealing to me.'"	Yamaguchi_worthless	0
"'It seems to me those who flock to this place like moth to light never come to do honest business. How can there be a real community with such people?'"	Yamaguchi_newcomers	0
"'I think those who have been here for some time and survived could easily improve the situation by sharing their experience with those about to fall into the traps they have been through. They always choose to prey on the newcomers instead.'"	Yamaguchi_establishment	0
"'The moral. It's much more visible.'"	Yamaguchi_moral	0
"'The degenerates.'"	Yamaguchi_degenerates	0
"'I already had ample opportunity to get to know the latter in many different ways.'"	Yamaguchi_meet	0
"'Sure, it's a respite to see people rotten to the core [italic type]and[roman type] on the outside for a change.'"	Yamaguchi_meet	0
"'The depravity.'"	Yamaguchi_debauchery	0
"'Everything those in the rat race ever desire is in some way pornographic. The way those low-lives wallow in their twisted fantasies, without ever getting close to anything resembling a real life is making me sick.'"	Yamaguchi_sheep	0
"'I can only see those who should know better but feed the sheep their daily dose of stultification as common opportunists.'"	Yamaguchi_wolves	0
"'I've had my share of those types.'"	Yamaguchi_interested	0
"'I might be interested in that.'"	Yamaguchi_interested	0
"'All this time, you haven't asked me for my name at all.'"	Yamaguchi_name	0
"'Thank you very much.'"	Yamaguchi_thanks	0
"'It's Ayako. [italic type]hajimemashite, yoroshiku onegai shimasu.[roman type]'"	Yamaguchi_ayako		0
"'You said you could arrange a meeting with some patron of yours.'"	Yamaguchi_patron	0

Before quipping when the current quip is Yamaguchi_greeting:
	say "[if Posing is happening]Since I could do little else, I tried to strike up a conversation: 'Do you mind if I talk?'[line break][line break][else]I said [italic type]'konbanwa'[roman type] to the painter.[paragraph break][end if]";
	if Pickup_3 is happening:
		enable the Yamaguchi_pickup quip for Yamaguchi;
	if Yamaguchi is honored:
		enable the Yamaguchi_patron quip for Yamaguchi.

After quipping when the current quip is Yamaguchi_just_looking:
	enable the Yamaguchi_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is Yamaguchi_pickup:
	disable the Yamaguchi_just_looking quip;
	say "The painter handed me a package.[paragraph break]";
	move parcel_3 to the player;
	enable the Yamaguchi_sign quip.
	
After quipping when the current quip is Yamaguchi_sign:
	say "The painter signed the signing pad.[line break]He then took a long look at me.[paragraph break]";
	now the address of the signpad is "Delivery to:[line break]Tanaka used goods[line break]Under the Odakyû-sen viaduct.";
	enable the Yamaguchi_aha quip.

After quipping when the current quip is Yamaguchi_aha:
	disable the Yamaguchi_aha quip;
	enable the Yamaguchi_perfect quip.

After quipping when the current quip is Yamaguchi_perfect:
	enable the Yamaguchi_true quip;
	enable the Yamaguchi_false quip.

After quipping when the current quip is Yamaguchi_true:
	disable the Yamaguchi_false quip;
	enable the Yamaguchi_monetary quip;

After quipping when the current quip is Yamaguchi_false:
	disable the Yamaguchi_true quip;
	enable the Yamaguchi_thomas quip;
	enable the Yamaguchi_butterfly quip.
	
After quipping when the current quip is Yamaguchi_thomas:
	disable the Yamaguchi_butterfly quip;
	enable the Yamaguchi_benjamin quip;
	enable the Yamaguchi_baudrillard quip.
	
After quipping when the current quip is Yamaguchi_butterfly:
	disable the Yamaguchi_thomas quip;
	enable the Yamaguchi_benjamin quip;
	enable the Yamaguchi_baudrillard quip.

After quipping when the current quip is Yamaguchi_benjamin:
	disable the Yamaguchi_baudrillard quip;
	enable the Yamaguchi_compliment quip.

After quipping when the current quip is Yamaguchi_baudrillard:
	disable the Yamaguchi_benjamin quip;
	enable the Yamaguchi_compliment quip.

After quipping when the current quip is Yamaguchi_compliment:
	disable the Yamaguchi_compliment quip;
	enable the Yamaguchi_choice quip.

After quipping when the current quip is Yamaguchi_choice:
	disable the Yamaguchi_choice quip;
	enable the Yamaguchi_monetary quip.

After quipping when the current quip is Yamaguchi_monetary:
	disable the Yamaguchi_monetary quip;
	enable the Yamaguchi_please quip.

After quipping when the current quip is Yamaguchi_please:
	enable the Yamaguchi_objections quip;
	enable the Yamaguchi_how_much quip;
	
After quipping when the current quip is Yamaguchi_no_means_no:
	disable the Yamaguchi_please quip;
	disable the Yamaguchi_objections quip;
	disable the Yamaguchi_how_much quip;
	disable the Yamaguchi_antiquity quip;
	disable the Yamaguchi_japan quip;
	enable the Yamaguchi_just_looking quip;
	enable the Yamaguchi_thought quip;
	terminate the conversation.

After quipping when the current quip is Yamaguchi_objections:
	enable the Yamaguchi_antiquity quip;
	enable the Yamaguchi_japan quip;

After quipping when the current quip is Yamaguchi_antiquity:
	disable the Yamaguchi_japan quip;
	disable the Yamaguchi_no_means_no quip;
	enable the Yamaguchi_answer quip.

After quipping when the current quip is Yamaguchi_japan:
	disable the Yamaguchi_antiquity quip;
	disable the Yamaguchi_no_means_no quip;
	enable the Yamaguchi_answer quip.

After quipping when the current quip is Yamaguchi_how_much:
	disable the Yamaguchi_please quip;
	disable the Yamaguchi_no_means_no quip;
	disable the Yamaguchi_objections quip;
	disable the Yamaguchi_antiquity quip;
	disable the Yamaguchi_japan quip;
	enable the Yamaguchi_agree quip;
	enable the Yamaguchi_disagree quip.

After quipping when the current quip is Yamaguchi_disagree:
	disable the Yamaguchi_agree quip;
	enable the Yamaguchi_thought quip;
	terminate the conversation.

After quipping when the current quip is Yamaguchi_thought:
	enable the Yamaguchi_agree quip;
	enable the Yamaguchi_disagree quip.

After quipping when the current quip is Yamaguchi_agree:
	disable the Yamaguchi_disagree quip;
	now Yamaguchi is painting;
	terminate the conversation.

After quipping when the current quip is Yamaguchi_start:
	say "I felt myself going bright red.[paragraph break]";
	enable the Yamaguchi_lets_see quip.

Before quipping when the current quip is Yamaguchi_lets_see:
	say "The artist looked at me from head to feet.";	
	say "Unable to withstand his gaze, I lowered my eyes.[paragraph break]".

After quipping when the current quip is Yamaguchi_lets_see: 
	enable the Yamaguchi_yes_good quip.

After quipping when the current quip is Yamaguchi_yes_good:
	enable the Yamaguchi_art quip;
	enable the Yamaguchi_work quip;
	terminate the conversation.

After quipping when the current quip is Yamaguchi_work:
	disable the Yamaguchi_art quip;
	enable the Yamaguchi_came quip.

After quipping when the current quip is Yamaguchi_came:
	enable the Yamaguchi_sell quip;
	enable the Yamaguchi_place quip.

After quipping when the current quip is Yamaguchi_sell:
	disable the Yamaguchi_place quip;
	enable the Yamaguchi_decay quip;
	enable the Yamaguchi_degenerates quip;
	enable the Yamaguchi_debauchery quip.

After quipping when the current quip is Yamaguchi_place:
	disable the Yamaguchi_sell quip;
	disable the Yamaguchi_different quip;
	enable the Yamaguchi_decay quip;
	enable the Yamaguchi_degenerates quip;
	enable the Yamaguchi_debauchery quip.

After quipping when the current quip is Yamaguchi_art:
	disable the Yamaguchi_work quip;
	enable the Yamaguchi_connoisseur quip.

After quipping when the current quip is Yamaguchi_connoisseur:
	disable the Yamaguchi_connoisseur quip;
	enable the Yamaguchi_place quip;
	enable the Yamaguchi_different quip.

After quipping when the current quip is Yamaguchi_different:
	disable the Yamaguchi_place quip;
	enable the Yamaguchi_niveau quip.
	
After quipping when the current quip is Yamaguchi_niveau:
	disable the Yamaguchi_niveau quip;
	enable the Yamaguchi_decay quip;
	enable the Yamaguchi_degenerates quip;
	enable the Yamaguchi_debauchery quip.

After quipping when the current quip is Yamaguchi_decay:
	disable the Yamaguchi_degenerates quip;
	disable the Yamaguchi_debauchery quip;
	enable the Yamaguchi_physical quip;
	enable the Yamaguchi_moral quip.

After quipping when the current quip is Yamaguchi_physical:
	disable the Yamaguchi_moral quip;
	enable the Yamaguchi_worthless quip.

After quipping when the current quip is Yamaguchi_moral:
	disable the Yamaguchi_physical quip;
	enable the Yamaguchi_newcomers quip;
	enable the Yamaguchi_establishment quip.

After quipping when the current quip is Yamaguchi_worthless:
	disable the Yamaguchi_worthless quip;
	enable the Yamaguchi_newcomers quip;
	enable the Yamaguchi_establishment quip.
	
After quipping when the current quip is Yamaguchi_degenerates:
	disable the Yamaguchi_decay quip;
	disable the Yamaguchi_debauchery quip;
	enable the Yamaguchi_meet quip.

After quipping when the current quip is Yamaguchi_debauchery:
	disable the Yamaguchi_degenerates quip;
	disable the Yamaguchi_decay quip;
	enable the Yamaguchi_sheep quip;
	enable the Yamaguchi_wolves quip.

After quipping when the current quip is Yamaguchi_newcomers:
	disable the Yamaguchi_establishment quip;
	enable the Yamaguchi_interested quip. 

After quipping when the current quip is Yamaguchi_establishment:
	disable the Yamaguchi_newcomers quip;
	enable the Yamaguchi_interested quip. 

After quipping when the current quip is Yamaguchi_meet:
	disable the Yamaguchi_meet quip;
	enable the Yamaguchi_interested quip. 

After quipping when the current quip is Yamaguchi_sheep:
	disable the Yamaguchi_wolves quip;
	enable the Yamaguchi_interested quip. 
			
After quipping when the current quip is Yamaguchi_wolves:
	disable the Yamaguchi_sheep quip;
	enable the Yamaguchi_interested quip. 
	
After quipping when the current quip is Yamaguchi_interested:
	disable the Yamaguchi_interested quip;
	now the description of the picture is "Most of it was still only a sketch, apart from my face, which was already finished, and quite well captured.";
	now Yamaguchi is not painting;
	say "He handed me 15.000 yen.[paragraph break]"; 
	increase the wealth of the player by 15000 yen;
	enable the Yamaguchi_name quip;
	enable the Yamaguchi_thanks quip.

After quipping when the current quip is Yamaguchi_name:
	disable the Yamaguchi_thanks quip;
	enable the Yamaguchi_ayako quip.
	
After quipping when the current quip is Yamaguchi_thanks:
	disable the Yamaguchi_name quip;
	enable the Yamaguchi_just_looking quip;
	now Yamaguchi is honored;
	terminate the conversation.
		
After quipping when the current quip is Yamaguchi_ayako:
	enable the Yamaguchi_just_looking quip;
	now Yamaguchi is acquainted;
	now Yamaguchi is honored;
	terminate the conversation.

After quipping when the current quip is Yamaguchi_patron:
	enable the Yamaguchi_just_looking quip;
	enable the Yamaguchi_patron quip;
	terminate the conversation.

Part 16 - Madame Liao

Chapter 1 - The Character

Madame Liao is a woman. Madame Liao is in L-1_bordello_reception. The description of Madame Liao is "She looked chinese, though that may have been more due to her garment than anything else." The printed name of Madame Liao is "the procuress". The initial appearance of Madame Liao is "[if Madame Liao is acquainted]Madame Liao[else]A middle-aged woman in a [italic type]qipao[roman type][end if] was sitting at a small baroque table."

Understand "procuress/pimp/watchdog" as Madame Liao when the location is L-1_bordello_reception.

Chapter 2 - Madame Liaos possessions

Madame Liao wears clothing called a qipao. The description of the qipao is "A closely fitting chinese garment."
Understand "chinese garment" as the qipao when the location is L-1_bordello_reception.

Chapter 3 - The conversation

The litany of Madame Liao is the Table of Liao Conversation.

The greeting of Madame Liao is Liao_greeting.

Table of Quip Texts (continued)
quip			quiptext
Liao_greeting		"'I'm afraid you've got the wrong door here, honey.'"
Liao_just_looking	"'There is nothing for you here, I'm afraid. Time to go home.'"
Liao_stop			"The watchdog stopped me in my tracks: 'Nothing for you in there, honey. This place is for adults only.'"
Liao_work		"'Look, girl, you won't be getting any work in this place. You're certainly too old.[If the player wears a sash] And much too well off, I should think.'"
Liao_too_old		"'You're what? 15? 16? Like I said, at least two years too old for our customers.'"
Liao_where_else		"'[If the player wears a sash]You could try selling some of your pretty possessions in one of the pawnshops below the railway line. That's just a temporary measure, to be sure. Now get out of here.[else]Why don't you try some honest work? It won't hurt you. Now get out of here.'"
Liao_fine			"'Why are you asking me then? Now get out of here.'"
Liao_pickup		"'Now that can't be true. They wouldn't willingly send an underage girl to me.'"
Liao_shortage		"'That's not my problem. Tell your boss to send someone else.'"
Liao_underage		"'Of course you can. You probably have a splendid Macao forgery of an ID. Now listen, girl. Firstly: I'm not an idiot and I know where to get papers for young girls real easy. Secondly: I'm not blind and I do see quite a few such girls in need of false documents. And Thirdly: I'm not amused and I will prevent you from getting into this cabaret.'"
Liao_once_again		"'I can see that. And you haven't even gotten older one single day since we last met.'"
Liao_stuff		"'Well, if that's what she says, so be it. I will have to get someone else to do it. You can tell her that.'"
Liao_employer		"'Yes, I know. She told me you were vaccinated. Can you prove it?'"
Liao_vaccination	"'I can't risk everyone inside just because some underage girl without the necessary precautions engages in risky behaviour in shady nightclubs.'"
Liao_explanation	"'Many of our customers have a syringe fetish, it's true. But that has nothing to do with this. Do you have your immunisation record or not?'"
Liao_job			"'It would be far too easy a job if I let you through like this. Do you have your immunisation record or not?'"
Liao_bullying		"'In fact, I don't like your type. Luckily enough, I can indulge in harassing you some more. Do you have your immunisation record or not?'" 
Liao_back		"'Don't forget to bring your immunisation record.'"
Liao_record		"'Took you long enough. We've been waiting for ages! Go in and ask the bartender for it.'"
Liao_surprise		"'When did you get in here?' asked the startled watchdog as I emerged from under the curtain."

Table of Liao Conversation
prompt				response		enabled
"'I was just taking a look.'"	Liao_just_looking	1
"'Would you know how I can make some money around here, by any chance?'"	Liao_work	1
"'Too old?'"			Liao_too_old	0
"'Where else should I look?'"	Liao_where_else		0
"'Fine, I didn't exactly look for the kind of work you're offering anyway.'"	Liao_fine	0
"'CityTrafficking courier service. I'm supposed to pick up some delivery here.'"	Liao_pickup	0
"'Sorry, but we're a little short on the manpower side tonight.'"	Liao_shortage	0	
"'I'm not underage, and I can prove it!'"	Liao_underage	0
"'It's me again.'"	Liao_once_again		0
"'My boss says you won't get your stuff delivered if you won't let me in.'"	Liao_stuff	0
"'I've come to pick up your delivery. My employer just called you.'"	Liao_employer	0	
"'What's with this vaccination business?'"	Liao_vaccination	0
"'Look, I'm just trying to do my job here. Just let me pick up the delivery and I'll be gone.'"		Liao_job	0
"'What have I done to you to deserve this bullying?'"	Liao_bullying	0
"'This must be some strange fetish, there is no other explanation.'" 	Liao_explanation	0
"'I'll be back.'"		Liao_back	0
"'I'm here to pick up your delivery. And I've brought my immunisation record.'"	Liao_record	0

Before quipping when the current quip is Liao_greeting:
	say "I said [italic type]'nihao'[roman type] to the watchdog.[paragraph break]".

After quipping when the current quip is Liao_just_looking:
	enable the Liao_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Liao_work:
	disable the Liao_just_looking quip;
	now Taniguchi is not pimped;
	enable the Liao_too_old quip.

After quipping when the current quip is Liao_too_old:
	enable the Liao_where_else quip;
	enable the Liao_fine quip;
	
After quipping when the current quip is Liao_where_else:
	disable the Liao_fine quip;
	enable the Liao_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Liao_fine:
	disable the Liao_where_else quip;
	enable the Liao_just_looking quip;
	terminate the conversation.

Before quipping when the current quip is Liao_stop:
	if the player carries the fake ID:
		enable the Liao_underage quip for Madame Liao.

After quipping when the current quip is Liao_pickup:
	disable the Liao_work quip;
	disable the Liao_just_looking quip;
	enable the Kei_china quip for Kei;
	enable the Liao_shortage quip.

After quipping when the current quip is Liao_shortage:
	enable the Liao_underage quip.
	
After quipping	when the current quip is Liao_underage:
	disable the Liao_shortage quip;
	enable the Liao_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Liao_once_again:
	disable the Liao_just_looking quip;
	enable the Liao_stuff quip;
	
After quipping when the current quip is Liao_stuff:
	enable the Kei_cancel quip for Kei;
	enable the Liao_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Liao_employer:
	disable the Liao_just_looking quip;
	disable the Liao_underage quip;
	enable the Liao_vaccination quip.

After quipping when the current quip is Liao_vaccination:
	enable the Liao_job quip;
	enable the Liao_bullying quip;
	enable the Liao_explanation quip.

After quipping when the current quip is Liao_job:
	disable the Liao_bullying quip;
	disable the Liao_explanation quip;
	enable the Liao_back quip.

After quipping when the current quip is Liao_bullying:
	disable the Liao_job quip;
	disable the Liao_explanation quip;
	enable the Liao_back quip.
	
After quipping when the current quip is Liao_explanation:
	disable the Liao_bullying quip;
	disable the Liao_job quip;
	enable the Liao_back quip.

After quipping when the current quip is Liao_back:
	enable the Liao_just_looking quip;
	enable the Kei_failure quip for Kei;
	terminate the conversation.

After quipping when the current quip is Liao_record:
	now the passageway is clear;
	terminate the conversation.

After quipping when the current quip is Liao_surprise:
	say "But I just snubbed her.[paragraph break]";
	terminate the conversation.


Part 17 - The nurse

Chapter 1 - The Character

The nurse is a woman in L1_clinic_reception. The initial appearance of the nurse is "A white-clad nurse was bathing in the bright white light of the neon tubes in the ceiling."
The description of the nurse is "She wore a white polo shirt."

The nurse can be satisfied. The nurse is not satisfied.

Chapter 2 - The nurse's possessions

The nurse wears a white polo shirt.

The nurse carries the praxis key. The praxis key unlocks the praxis door.
The nurse carries the immunisation record. The description of the immunisation record is "It said I was vaccinated against Cholera, Meningitis, Hepatitis A and B, Pertussis, yellow fever, Tuberculosis, Poliomyelitis, Tick-born encephalitis, Rubella and Tetanus. It had signatures, stickers and all."
Understand "signature/signatures" and "sticker/stickers" as the immunisation record.

Chapter 3 - The conversation

The litany of the nurse is the Table of Nurse Conversation.

The greeting of the nurse is Nurse_greeting.

Table of Quip Texts (continued)
quip			quiptext
Nurse_greeting		"[If paperwork is happening]'Yes?'[else if consultation is happening]She just smiled.[else]'Good evening. What can we do for you, Miss?'"
Nurse_just_looking	"'Maybe you have. It happens.'"
Nurse_vaccination	"'And why would you need immunisation against all that at once?'"
Nurse_reason		"'Fair enough. Do you have your immunisation record on you?'"
Nurse_cost		"'Nobody ever has it. Funny that. I'll give you a new one. That would be 12000 yen. Please pay in advance.'"
Nurse_stop		"'Excuse me, you can't enter there until you're called in.' said the nurse as I made for the treatment room."
Nurse_come_in	"'Please come in, the Doctor is ready for you now.' said the nurse."
Nurse_pay		"'Thank you very much. If you'd wait here for a moment, I'll wake the Doctor.'"
Nurse_reject		"'Please do. Tell me when you've come to a conclusion.'"
Nurse_paperwork	"'Yes. Do you have an ID on you?'"
Nurse_ID	"'Here you go, your new immunisation record. Keep hold of it this time, will you?'"

Table of Nurse Conversation
prompt							response		enabled
"'Nothing, thank you. You see, I think I must have entered the wrong door.'"	Nurse_just_looking	1
"'I need a vaccination for Cholera, Meningitis, Hepatitis A and B, Pertussis, yellow fever, Tuberculosis, Poliomyelitis, Tick-born encephalitis, Rubella and Tetanus.'"	Nurse_vaccination	0
"'I'm taking part in a canoe-expedition to the upper Orinoco with the institute of experimental archeology.'"	Nurse_reason	0
"'I am to become the subject of a secret government experiment, involving exposure to biological weapons.'"	Nurse_reason	0
"'This is part of a twisted game of punishment to satisfy a strange sadistic sentiment in one of my employer's clients.'"	Nurse_reason	0
"'I'm starting an internship at a local kindergarten.'"	Nurse_reason	0
"'I was going to take it, but then I left it on my desk when I was in a hurry. Stupid me.'"	Nurse_cost	0
"'It should have been in my drawer. I searched and searched but I couldn't find it.'"	Nurse_cost	0
"'It was there before I moved last year. It must have gotten lost at that time.'"	Nurse_cost	0
"'I had it on me this morning. But then someone stole my wallet.'"	Nurse_cost	0
"'OK, here you go, 12.000 yen"	Nurse_pay	0
"'In that case I'll have to think about it.'"	Nurse_reject	0
"'The doctor said you had some paperwork for me.'"	Nurse_paperwork	0
"'Yes, here it is.'"	Nurse_ID		0

Before quipping when the current quip is Nurse_greeting:
	if consultation is happening:
		disable the nurse_just_looking quip for the nurse;
	else if Paperwork is happening:
		enable the Nurse_paperwork quip for the nurse;
	else if the player is pissed:
		enable the Nurse_vaccination quip for the nurse;
	say "[if Consultation is happening]I didn't know what to talk about.[else if Paperwork is happening]I said [italic type]'sumimasen'[roman type] to the nurse.[paragraph break][else]I said [italic type]'konbanwa'[roman type] to the nurse.[paragraph break]".

After quipping when the current quip is Nurse_just_looking:
	enable the Nurse_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Nurse_vaccination:
	disable the Nurse_just_looking quip;
	enable the Nurse_reason quip.

After quipping when the current quip is Nurse_reason:
	disable the Nurse_reason quip;
	enable the Nurse_cost quip.

After quipping when the current quip is Nurse_cost:
	disable the Nurse_cost quip;
	if the wealth of the player >= 12000 yen:
		enable the Nurse_pay quip;
	enable the Nurse_reject quip.

After quipping when the current quip is Nurse_pay:
	disable the Nurse_reject quip;
	enable the Nurse_just_looking quip;
	now the wealth of the player is the wealth of the player - 12000 yen;
	now the nurse is satisfied;
	terminate the conversation.

After quipping when the current quip is Nurse_reject:
	disable the Nurse_pay quip;
	enable the Nurse_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Nurse_paperwork:
	disable the Nurse_just_looking quip;
	enable the Nurse_ID quip;

After quipping when the current quip is Nurse_ID:
	say "She wrote down my name and date of birth from the ID, and handed it back to me.";
	say "Then she handed me the immunisation record.";
	move the immunisation record to the player;
	enable the Liao_record quip for Madame Liao;
	enable the Nurse_just_looking quip;
	terminate the conversation.


Part 18 - The doctor

Chapter 1 - The Character

The doctor is a man in L1_clinic_treatment. The initial appearance of the doctor is "Dr. Cutter was standing beside his examination table." The description of the doctor is "A middle-aged man in a lab coat."
Understand "dr/cutter/man/gp" and "dr cutter" as the doctor.

The doctor can be awake or asleep. The doctor is asleep.
The doctor can be jabby. The doctor is not jabby.

Chapter 2 - The doctor's possessions

The doctor wears a lab coat.
The doctor carries a syringe.

Chapter 3 - The conversation

The litany of the doctor is the Table of Doctor Conversation.

The greeting of the doctor is Doctor_greeting.

Table of Quip Texts (continued)
quip			quiptext
Doctor_greeting	"[if Paperwork is happening]'The nurse will take care of the paperwork.'[else]'Good Evening. It seems the night never sleeps in Gotomomi.'"
Doctor_youth		"'You sure sound very young. And look it. Congratulations. Youth is wasted on the young, by the way.'"
Doctor_drugs		"'That depends on your definition of consciousness.'"
Doctor_dreams		"'A wise decision. Plenty of nightmarish things in the daylight already.'"
Doctor_jab		"'As the bishop said to the chorus girl. I take it you are aware of the risks of this vaccination?'"
Doctor_yes		"'Good. I don't want to hear any complains afterwards. Please expose your left upper arm.'"
Doctor_no		"'All right, I'll repeat them for you: you'll most likely get a fever, possibly hallucinations, maybe a headache and you might collapse on the spot, dead and finished. Don't blame me for any of it. Now, will you please expose your left upper arm?'"
Doctor_terrible		"'See, that wasn't so terrible now, was it?'"
Doctor_it_burns	"'That'll go away in a few days, I think.'"
Doctor_nothing		"'You do look a little pale though. Maybe you should sit down for a bit.'"
Doctor_thank_you	"'It was my pleasure. The nurse will hand you the paperwork outside.'"
Doctor_hold_still	"'Please keep calm. There is no need to panic.' The doctor reassured me." 

Table of Doctor Conversation
prompt	response	enabled
"'I'm young only once. I can still sleep plenty when I'm dead one day.'"	Doctor_youth	1
"'Gotomomi has a lot on offer to keep you awake.'"	Doctor_drugs	1
"'Sleep brings dreams. All my dreams have turned into nightmares. So I try to avoid sleep.'"	Doctor_dreams	1
"'Yes, Doctor. But, actually, I've not come to discuss this. I need a jab.'"	Doctor_jab	0
"'I'm sure you're right, Doctor. But I think it's time to put your syringe to use now.'"	Doctor_jab	0
"'Please Doctor, let's not waste any more words. I want to get right to the act.'"	Doctor_jab	0
"'Yes, obviously.'"	Doctor_yes	0
"'No, obviously not.'"	Doctor_no	0
"'It burns like fire, my arm is going numb.'"	Doctor_it_burns	0
"'It was nothing.'"	Doctor_nothing		0
"'I think I'll be fine, thank you.'"	Doctor_thank_you	0

Before quipping when the current quip is Doctor_greeting:
	say "[If Paperwork is happening]'ahem...'[else]I said [italic type]'good evening'[roman type] to the Doctor.[paragraph break]".

After quipping when the current quip is Doctor_youth:
	disable the Doctor_drugs quip;
	disable the Doctor_dreams quip;
	enable the Doctor_jab quip.

After quipping when the current quip is Doctor_drugs:
	disable the Doctor_youth quip;
	disable the Doctor_dreams quip;
	enable the Doctor_jab quip.

After quipping when the current quip is Doctor_dreams:
	disable the Doctor_youth quip;
	disable the Doctor_drugs quip;
	enable the Doctor_jab quip.

After quipping when the current quip is Doctor_jab:
	disable the Doctor_jab quip;
	enable the Doctor_yes quip;
	enable the Doctor_no quip.
	
After quipping when the current quip is Doctor_yes:
	disable the Doctor_no quip;
	say "I did as he told me.";
	now the doctor is jabby;
	terminate the conversation.	
	
After quipping when the current quip is Doctor_no:
	disable the Doctor_yes quip;
	say "I did as he told me.";
	now the doctor is jabby;
	terminate the conversation.
	
After quipping when the current quip is Doctor_nothing:
	disable the Doctor_it_burns quip;
	enable the Doctor_thank_you quip;
	
After quipping when the current quip is Doctor_it_burns:
	disable the Doctor_nothing quip;
	enable the Doctor_thank_you quip;
	
After quipping when the current quip is Doctor_thank_you:
	terminate the conversation;

Part 19 - The gutters

Chapter 1 - The Character

The gutters are a plural-named person in L0_fish_gutting. The printed name is "workers". The initial appearance of the gutters is "A dozen or so people were silently slaving away to reduce the enormous pile of dead fish that covered the rusty table in the middle of the room. They seemed entirely occupied by their gutting routine." The description of the gutters is "It was impossible to make out any of their faces in the twilight. Not that they seemed interested in me, either. They just went on with their job of filling one bucket with gutted fish after the other."

Understand "workers/worker/man/woman/people" as the gutters when the location is L0_fish_gutting.

The gutters can be happy or unhappy. The gutters are happy.

Chapter 2 - The gutters' possessions

Chapter 3 - The conversation

The greeting of the gutters is Gutters_greeting.

Table of Quip Texts (continued)
quip			quiptext
Gutters_greeting	"'[if the foreman is in the location][one of]You crazy? Foreman hear everything![or]No talk! Boss no like talk.[or]No talk. Forbidden![or]Shhht! You want end up tin can?[or]Quiet! No want loose job.[at random][else][one of]Boss never pay up![or]Fish all illegal catch![or]Better find other work, if can![at random][end if]' [one of]He[or]She[at random] whispered back."

Before quipping when the current quip is Gutters_greeting:
	say "I said 'Hey' to one of the workers.[paragraph break]".

Part 20 - The tinners

The tinners are a plural-named person in L0_fish_tinning. The printed name is "workers". The initial appearance of the tinners is "The large preparation table next to the machine was surrounded by a cohort of workers. They squeezed one fish after the other into tin cans they then filled up from an oil bottle." The description of the tinners is "The whole bunch of them seemed very concentrated on their work."

Understand "workers/worker/man/woman/people" as the tinners when the location is L0_fish_tinning.

The tinners can be happy or unhappy. The tinners are happy.

Chapter 1 - The gutters' possessions

Chapter 2 - The conversation

The greeting of the tinners is Tinners_greeting.

Table of Quip Texts (continued)
quip			quiptext
Tinners_greeting	"'[if the foreman is in the location][one of]Are you mad? The Foreman hears everything![or]No talking! The Boss doesn't like talking.[or]No talking. It's forbidden![or]Shhht! Do you want to end up in a tin can?[or]Quiet! I don't want to loose my job.[at random][else][one of]We're planning to pack the foreman into a tin can![or]You will never get your full pay in this place![or]The girls at the packing station are snitching to the boss![at random][end if]' [one of]He[or]She[at random] whispered back."

Before quipping when the current quip is Tinners_greeting:
	say "I said 'Hey' to one of the workers.[paragraph break]".

Part 21 - The foreman

Chapter 1 - The Character

The foreman is a male patroller.
The foreman is in L0_fish_tinning.
The initial appearance of the foreman is "A foreman was standing around, looking for someone to tear strips off."
The description of the foreman is "This fellow would have made a terrific death-camp guard."

The drive of the foreman is 66.
Turn frequency of the foreman is 2.
The foreman is RoomLed.
The foreman is circular.
The OpeningCapability of the foreman is WithKey.
The ReclosingCapability of the foreman is Reinstate.
The RoomTable of the foreman is the Table of Foreman Route.

Table of Foreman Route
TargetRoom
L0_fish_tinning
L0_fish_gutting

[To report arrival of the foreman coming (way - a direction) from (place - a room): say "The foreman entered the room. Everyone's efforts increased tremendously.[line break]".
To report departure of the foreman going (way - a direction) to (place - a room): say "The foreman left the room. Everyone relaxed visibly.".]

Chapter 2 - The foreman's possessions

Chapter 3 - The conversation 

The greeting of the foreman is Foreman_greeting.

Table of Quip Texts (continued)
quip			quiptext
Foreman_greeting	"[if the player is hired]'Shut your face! Get back to work before I tear out your cheeky tongue!' the foreman yelled[one of] at the top of his voice[or], his head a ripe tomato[at random].[else]'If you want to talk to someone, try the manager.'"
Foreman_tinners	"'[One of]What the hell are you doing?[or]What's this?[or]What's going on in here?[at random] The machine can't be allowed to stop! Haul some fish to the tinning room this instant, [one of]you lazy bum[or]before I rip the skin off your back[at random]!' the foreman was raging at me."
Foreman_gutters	"'[one of]Why are you so slow in hauling these buckets?[or]It can't be so difficult to get the buckets in and out in time![at random] The gutters have nowhere to put the fish! [one of]Move it before I spank your lazy bum[or]Get a move on, you sloppy snail[at random]!' The foreman was fuming."
Foreman_end	"'Hey you! Your shift is over. The manager wants to see you in the office.' The foreman informed me."

Before quipping when the current quip is Foreman_greeting:
	say "I wanted to say 'excuse me' to the foreman, but didn't get to finish saying the words.[paragraph break]".
	

Part 22 - The packers

Chapter 1 - The Character

The packers are a plural-named person in L0_fish_packing. The printed name is "girls". The initial appearance of the packers is "A few girls in neatly kept smocks were packing cardboard boxes with tin cans." The description of the packers is "They looked straight out of some 1980s employer advertising brochure."

Understand "workers/worker/girl/woman/people/women/girls" as the packers when the location is L0_fish_packing.

Chapter 2 - The packers' possessions

The packers are wearing some smocks. The description of the smocks is "Light blue, without pockets." 

Chapter 3 - The conversation

The greeting of the packers is Packers_greeting.

Table of Quip Texts (continued)
quip			quiptext
Packers_greeting	"[if the player is hired]'Your work station is through that door to the east.'[else]'[italic type]Konbanwa[roman type]. If you have any questions, please talk to the management. The office is over there.' She pointed to the south."
Packers_no_way	"'Excuse me, I'm afraid that door is out of bounds for visitors.' said one of the girls, stopping me."
Packers_no_escape	"'You can't just leave on your shift. I'll tell the manager if you do.' said one of the girls at the conveyor belt as I tried to leave the factory."
Packers_no_stealing	"'I can see you. Don't try to steal factory property.' I heard one of the girls say as I made my way for the door."

Before quipping when the current quip is Packers_greeting:
	say "I said [italic type]'konbanwa'[roman type] to one of the girls.[paragraph break]".

Part 23 - The boss

Chapter 1 - The Character

The boss is a man in L0_fish_office. The initial appearance of the boss is "Only one person was in the office at that time." The description of the boss is "A Middle-aged Vietnamese man in a tasteless shirt."
Understand "man/person/vietnamese/manager" as the boss.

The boss can be rejected. The boss is not rejected.

Chapter 2 - The Boss's possessions

The boss wears a tasteless shirt.

Chapter 3 - The conversation

The litany of the boss is the Table of Boss Conversation.

The greeting of the boss is Boss_greeting.

Table of Quip Texts (continued)
quip			quiptext
Boss_greeting	"[If the boss is rejected]'Hello there. Changed your mind?'[else if the player is hired]'Better stop the smalltalk now. Get to work.'[else if the player is payed and payment is happening]'I don't think we've got anything else to talk about, or do we?'[otherwise]'Hello there. Anything you want?'"
Boss_just_looking	"'Please do not disturb the workers.'"
Boss_any_work	"He looked very pleased with himself."
Boss_what_kind	"'The easy kind. Just some hauling, nothing too heavy. And the pay is not bad either.'"
Boss_how_much	"'8000 yen for one shift. A shift ends when we are through with one delivery of fish. How fast that'll be depends on you, though. Are you in?'"
Boss_no	"'Your loss. There is easy money to be made here.'"
Boss_yes	"'Great. here's what you have to do: You carry the fish buckets between the gutting room and the tinning room. Make sure the tinning machine doesn't stop. Go there now.'"
Boss_pay	"'Ah, yes. Of course. Thank you for helping out. Here's your 4000 yen.'"
Boss_fraud	"'4000 is more than enough for you. In fact, now that I think about it, you'll get no more than 2000.'"
Boss_full		"'Do you have any proof we agreed on anything at all? Now get out before I get angry.'"
Boss_thanks	"'You're welcome.'"

Table of Boss Conversation
prompt							response		enabled
"'No. Not really.'"	Boss_just_looking	1
"'I was wondering if there was any work for me in this factory."	Boss_any_work	0
"'What kind of work would I have to do?'"	Boss_what_kind	0
"'How much?'"	Boss_how_much	0
"'Yes.'"	Boss_yes	0
"'No.'"	Boss_no	0
"'I've come to get my payment.'"	Boss_pay	0
"'Oh, well. [bid value] it'll be.'"	Boss_thanks	0
"'We had agreed on 8000.'"	Boss_fraud	0
"'I insist on getting my payment in full.'"	Boss_full	0

Before quipping when the current quip is Boss_greeting:
	if the boss is rejected:
		disable the Boss_just_looking quip for the boss;
		enable the Boss_yes quip for the boss;
		enable the Boss_no quip for the boss;
	else if the player is hired:
		disable the Boss_just_looking quip for the boss;
	else if the player is not payed:
		now the bid value is 4000 yen;
		disable the Boss_just_looking quip for the boss;
		enable the Boss_pay quip for the boss;
	else if payment is not happening:
		enable the Boss_any_work quip for the boss;
	say "I said [italic type]'Chào buổi tối'[roman type] to the [if the boss is acquainted]boss[else]man.[paragraph break]".
	

After quipping when the current quip is Boss_just_looking:
	enable the Boss_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Boss_any_work:
	disable the Boss_just_looking quip;
	if the wealth of the player is less than 4000 yen:
		say "'You're in luck, we've had a little accident today, so there is currently one vacant position.'[paragraph break]";
		enable the Boss_what_kind quip;
		now the _man is worked;
	else:
		say "'No, I have no work for you at the moment.'[paragraph break]";
		enable the Boss_just_looking quip;
		terminate the conversation.

After quipping when the current quip is Boss_what_kind:
	enable the Boss_how_much quip;

After quipping when the current quip is Boss_how_much:
	enable the Boss_yes quip;
	enable the Boss_no quip;
	
After quipping when the current quip is Boss_no:
	now the boss is rejected;
	disable the Boss_yes quip;
	terminate the conversation.
	
After quipping when the current quip is Boss_yes:
	now the boss is not rejected;
	now the player is hired;
	disable the Boss_no quip;
	enable the boss_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Boss_pay:
	enable the Boss_thanks quip;
	enable the Boss_fraud quip;

After quipping when the current quip is Boss_thanks:
	say "He handed me [bid value].";
	increase the wealth of the player by bid value;
	disable the Boss_fraud quip;
	disable the Boss_full quip;
	enable the Boss_just_looking quip;
	now the player is payed;
	terminate the conversation.

After quipping when the current quip is Boss_fraud:
	disable the Boss_thanks quip;
	now the bid value is 2000 yen;
	enable the Boss_thanks quip;
	enable the Boss_full quip.

After quipping when the current quip is Boss_full:
	disable the Boss_thanks quip;
	enable the Boss_just_looking quip;
	now the player is payed;
	terminate the conversation.


Part 24 - The bartender

Chapter 1 - The Character

The bartender is a man in L-1_bordello_bar. The description of the bartender is "A South-East-Asian in his late 20s, I'd have guessed." The initial appearance of the bartender is "The bartender tended to his bar."

Understand "barkeeper/man/barman" as the bartender when the location is L-1_bordello_bar.

The bartender can be exposed. The bartender is not exposed.

Chapter 2 - The bartender's possessions

The bartender wears a bow-tie.

The bartender carries a privately-named parcel called parcel_4. The printed name of parcel_4 is "a box of champagne". The description of parcel_4 is "Judging by the cover, this box contained six bottles of Louis Roederer 2018 Demi-Sec Rosé. A return sticker was attached."
The return sticker is part of parcel_4. The description of the return sticker is "This parcel was to go back to its supplier in Macao."

Understand "box/champagne/rose/rosé", "champagne box", "Louis Roederer", "Demi-sec Rose/Rosé" as parcel_4. 

After examining parcel_4 for the first time: 
	enable the bartender_champagne quip for the bartender.

The bartender carries the cocktail. The printed name of the cocktail is "bloody mary".
The description of the cocktail is "A very alcoholic long drink."
Understand "drink/alcohol" and "long drink" as the cocktail.
The cocktail can be drunk. The cocktail is not drunk.

Instead of drinking a cocktail:
	try silently taking the cocktail;
	if the player carries the cocktail:
		if the cocktail is not drunk:
			increase the promille of the player by 0.3 pm;
			now the cocktail is drunk;
			say "I emptied my drink.";
		else:
			say "The drink was already finished.";
	else:
		say "What drink?"

Before putting the cocktail on the bar:
	if the cocktail is drunk:
		say "I placed the empty glass back onto the counter.";
		say "The bartender took the empty glass from the counter.";
		move the cocktail to the bartender instead.

Before putting the cocktail on the bar:
	if the cocktail is not drunk:
		say "I put the cocktail back onto the counter.";
		move the cocktail to the bar instead.

The bartender has a price called drinkprice. The drinkprice of the bartender is 1000 yen.

Chapter 3 - The Conversation

Table of Decadent Drinks
title					clarification	known
"A 'Wet Wipe'"			""			1
"An 'Ashtray'"			""			1
"A 'Singapore Noose'"	""			1
"A 'Texas Burial'"		""			1
"A 'Discovery Channel'"	""			1
"A 'Cherry Popper'"		""			1
"A 'Robber Baron'"		""			1
"A 'Barbary Pirate'"		"It's similar to a 'Triangle Trader', but with white rum instead of chocolate liqueur."	0
"An 'Emperor Maximilian'"	"It's a 'Firing Squad' with tequila added."						0
"A 'Vicomte de Valmont'"	"Basically it's a 'Maiden's Menace' with citrus liquor."				0
"A 'Countess Cosel'"		"That's the same as a 'Pompadour', but with Pilsener instead of champagne."	0
"A 'Piet Hein'"			"If you add some Antigua rum, you get a 'Bancrupt King', if that helps."	0

to say drink1:
	choose row 1 in the Table of Decadent Drinks;
	say "[title entry]".

to say drink2:
	choose row 2 in the Table of Decadent Drinks;
	say "[title entry]".

to say drink3:
	choose row 3 in the Table of Decadent Drinks;
	say "[title entry]". 

to say clarification:
	choose a row with title of the printed name of the cocktail in the Table of Decadent Drinks;
	say "[clarification entry]".

The litany of the bartender is the Table of Bartender Conversation.

The greeting of the bartender is bartender_greeting.

Table of Quip Texts (continued)
quip					quiptext
bartender_greeting		"The bartender smiled. '[italic type]Chào buổi tối[roman type]. What can I do for you, young lady?'"
bartender_just_looking	"'I'd suggest you don't look into it too deeply.' the bartender advised me."
bartender_no_way		"'Sorry, but I don't think I can let you wander around upstairs.' said the bartender behind me."
bartender_pickup		"'So Kei managed to send someone tonight after all. She is, as always, very dependable. Here is the parcel for you.'"
bartender_sign			"'Certainly. Here you go.'"	
bartender_goodbye		"'Goodbye, and have a nice evening.'"
bartender_champagne	"'I don't mind your curiosity but I'm afraid the answer to that will have to remain my business secret. Anything else I can do for you?'"
bartender_blackmail		"'Congratulations. What else did you expect in a place like this?'"
bartender_threaten		"'Wait. How about you keep that a secret and all your drinks are half price tonight?'"
bartender_barter		"'Come on, you're not even interested in really busting me. You'll get every cocktail at quarter price, that's my last word. So, what would you like?'"
bartender_drink		"[if the promille of the player is greater than 1.0 pm]'I think you've had quite enough for tonight.'[else if the bartender carries the cocktail]'The price is [drinkprice of the bartender]. What exactly can I offer you?'[else]'Why don't you finish the one you have first?'"
bartender_cocktail1		"The bartender raised an eyebrow."
bartender_cocktail2		"The bartender raised an eyebrow."
bartender_cocktail3		"The bartender raised an eyebrow."
bartender_clarify		"'Here you go. [drinkprice of the bartender] please.'"
bartender_ice			"'Here you go. [drinkprice of the bartender] please.'"
bartender_back			"'Thank you for bringing it back. Can I do anything for you?'"

Table of Bartender Conversation
prompt										response				enabled
"'Nothing, really, I'm just curious about this place.'"	Bartender_just_looking	1
"'I'm from the courier service.'"					Bartender_pickup		0
"'If you'd sign here please.'"						Bartender_sign			0
"'Thank you very much. Goodbye.'"				Bartender_goodbye		0
"'If you don't mind my curiosity: how come you are sending the champagne back?'"	Bartender_champagne	0
"'I found out your little secret. You have your champagne bottles refilled in Macao.'"	Bartender_blackmail		0
"'I'm sure those gentlemen over there on the sofas would love to hear about it.'"		Bartender_threaten		0
"'An excellent idea. Let's say they're on the house though.'"	Bartender_barter	0
"'I'd like a drink.'"		Bartender_drink	1
"'[drink1], please.'"	Bartender_cocktail1		0
"'[drink2], please.'"	Bartender_cocktail2		0
"'[drink3], please'"	Bartender_cocktail3		0
"'[clarification]'"	Bartender_clarify	0
"'Just with crushed ice, please.'"	Bartender_ice	0
"'Here's your glass back, I finished it.'"		Bartender_back	0

Before quipping when the current quip is bartender_greeting:
	if Pickup_4 is happening:
		enable the Bartender_pickup quip for the bartender;
	if the bartender is exposed:
		disable the Bartender_champagne quip for the bartender;
		enable the Bartender_blackmail quip for the bartender;
	if the player carries a drunk cocktail:
		enable the Bartender_back quip for the bartender;
	say "I said [italic type]'Chào buổi tối'[roman type] to the bartender.[paragraph break]".

After quipping when the current quip is bartender_just_looking:
	enable the bartender_just_looking quip;
	terminate the conversation.

After quipping when the current quip is bartender_pickup:
	say "The bartender handed me a box of champagne.";
	move parcel_4 to the player;
	disable the bartender_just_looking quip;
	disable the bartender_drink quip;
	enable the bartender_sign quip.
	
After quipping when the current quip is bartender_sign:
	say "He signed on the pad.";
	now the address of the signpad is "Delivery to:[line break]Yano & Chou Import-Export[line break]shitamachi-doori H25 C7.";
	enable the bartender_goodbye quip.

After quipping when the current quip is bartender_goodbye:
	enable the bartender_just_looking quip;
	enable the bartender_drink quip;
	terminate the conversation.

After quipping when the current quip is bartender_champagne:
	enable the bartender_just_looking quip;
	enable the bartender_drink quip.

After quipping when the current quip is bartender_blackmail:
	disable the bartender_just_looking quip;
	disable the bartender_drink quip;
	enable the bartender_threaten quip;

After quipping when the current quip is bartender_threaten:
	enable the bartender_barter quip;

After quipping when the current quip is bartender_barter:
	now the drinkprice of the bartender is 250 yen;
	now the bartender is not exposed;
	enable the bartender_just_looking quip;
	enable the bartender_drink quip.
	
After quipping when the current quip is bartender_drink:
	If the promille of the player is greater than 1.0 pm:
		enable the bartender_drink quip;
		terminate the conversation;
	else if the wealth of the player < the drinkprice of the bartender:
		say "I said 'too bad I haven't got the money for that.'[paragraph break]";
		enable the bartender_drink quip;
		terminate the conversation; 
	else if the bartender carries the cocktail:
		disable the bartender_just_looking quip;
		disable the bartender_champagne quip;
		disable the bartender_blackmail quip;
		disable the bartender_pickup quip;	
		sort the Table of Decadent Drinks in random order;	
		enable the bartender_cocktail1 quip;
		enable the bartender_cocktail2 quip;
		enable the bartender_cocktail3 quip;
	else:
		enable the bartender_drink quip;
		terminate the conversation.		
		
After quipping when the current quip is bartender_cocktail1:
	disable the bartender_cocktail2 quip;
	disable the bartender_cocktail3 quip;
	choose row 1 in the Table of Decadent Drinks;
	now the printed name of the cocktail is the title entry;
	if the known entry is 0:
		say "'I think I've heard that name somewhere. Could you perhaps tell me how it's made?'[paragraph break]";
		enable the bartender_clarify quip;
	else:
		say "'Would you like it with [one of]lemon[or]orange[or]lime[or]papaya[or]ground cherry[at random] or [one of ]chocolate beans[or]coffee beans[or]honeycomb[or]kiwi[or]rhubarb[at random]?'[paragraph break]";
		enable  the bartender_ice quip;
		
After quipping when the current quip is bartender_cocktail2:
	disable the bartender_cocktail1 quip;
	disable the bartender_cocktail3 quip;
	choose row 2 in the Table of Decadent Drinks;
	now the printed name of the cocktail is the title entry;
	if the known entry is 0:
		say "I think I've heard that name somewhere.  Could you perhaps tell me how it's made?'[paragraph break]";
		enable the bartender_clarify quip;
	else:
		say "'Would you like it with [one of]lemon[or]orange[or]lime[or]papaya[or]ground cherry[at random] or [one of ]chocolate beans[or]coffee beans[or]honeycomb[or]kiwi[or]rhubarb[at random]?'[paragraph break]";
		enable  the bartender_ice quip;
	
After quipping when the current quip is bartender_cocktail3:
	disable the bartender_cocktail1 quip;
	disable the bartender_cocktail2 quip;
	choose row 3 in the Table of Decadent Drinks;
	now the printed name of the cocktail is the title entry;
	if the known entry is 0:
		say "'I think I've heard that name somewhere.  Could you perhaps tell me how it's made?'[paragraph break]";
		enable the bartender_clarify quip;
	else:
		say "'Would you like it with [one of]lemon[or]orange[or]lime[or]papaya[or]ground cherry[at random] or [one of ]chocolate beans[or]coffee beans[or]honeycomb[or]kiwi[or]rhubarb[at random]?'[paragraph break]";
		enable  the bartender_ice quip;

After quipping when the current quip is bartender_clarify:
	choose row with a title of the printed name of the cocktail in the Table of Decadent Drinks; 
	now the known entry is 1;
	enable the bartender_just_looking quip;
	enable the bartender_drink quip;
	say "I handed him the money.";
	decrease the wealth of the player by the drinkprice of the bartender;
	say "He placed the cocktail in front of me.";
	now the printed name of the cocktail is "cocktail";
	move the cocktail to the bar;
	terminate the conversation.

After quipping when the current quip is bartender_ice:
	enable the bartender_just_looking quip;
	enable the bartender_drink quip;
	say "I handed him the money.";
	decrease the wealth of the player by the drinkprice of the bartender;
	say "He placed the cocktail in front of me.";
	now the printed name of the cocktail is "cocktail";
	move the cocktail to the bar;
	terminate the conversation.
	
After quipping when the current quip is bartender_back:
	say "I handed him the empty glass.[paragraph break]";
	move the cocktail to the bartender;
	now the cocktail is not drunk.

Part 25 - The Customers

Chapter 1 - The Character

The Customers are a plural-named man in L-1_bordello_bar. The initial appearance of the Customers is "A group of middle-aged men in ill-fitting suits were lounging on the sofas." The description of the Customers is "A typical group of salary men on another of those compulsory-voluntary office outings they have almost every night before they go home to their wifes and children."

Understand "men/johns/john/customer" as the Customers when the location is L-1_bordello_bar.

Chapter 2 - The Customer's possessions

The customers wear some suits.

Chapter 3 - The Conversation

The greeting of the Customers is Customers_greeting.

Table of Quip Texts (continued)
quip			quiptext
Customers_greeting	"Better to leave them alone, drunk as they were."

Part 26 - The girls

Chapter 1 - The Character

The girls are a plural-named woman in L-1_bordello_bar. The initial appearance of the girls is "A few young girls in much too short skirts attended to the customers." The description of the girls is "Some held drinks the customers had bought for them. Most smoked cigarettes. All seemed younger than the age of consent, which in this country was 13, incidentally."

Understand "girl/whore/hooker/whores/hookers" as the girls when the location is L-1_bordello_bar.

Chapter 2 - The Girl's posessions

The girls wear some skirts.
The girls carry some cigarettes.
The girls carry some drinks. The description of the drinks is "Candy-coloured tropical dreams come true."

Chapter 3 - The Conversation

The greeting of the girls is Girls_greeting.

Table of Quip Texts (continued)
quip			quiptext
Girls_greeting	"What would I have had to say to them?"


Part 27 - Rachel

Chapter 1 - The Character

Rachel is a woman in L0_bordello_rachel. The printed name of Rachel is "the girl". The initial appearance of Rachel is "[if Rachel is acquainted]Rachel was here.[else]A scantily-clad girl, a few years younger than me, was sitting on the bed." The description of Rachel is "A blonde, all she wore was some lace underwear."
Understand "girl/blonde" as Rachel.

Rachel can be rescued. Rachel is not rescued.

Chapter 2 - Rachel's possessions

Rachel wears some lace underwear. The description of the lace underwear is "Plenty risky for a girl her age."
Understand "underpants/pants/bra" as the lace underwear.

Chapter 3 - The Conversation

The litany of Rachel is the Table of Rachel Conversation.
The greeting of Rachel is Rachel_greeting.

Table of Quip Texts (continued)
quip				quiptext
Rachel_greeting	"[if Rachel is rescued]'Hello, and thank you. I think my father wants to thank you as well.'[else if Rachel is acquainted]'Hi there.'[else]'Hello there.'"
Rachel_just_looking	"'OK. I didn't see anything.'"
Rachel_delivery	"'Then you'll want to talk to the barman downstairs.'"
Rachel_thanks		"'You're welcome.'"
Rachel_young		"'I was looking for adventure and found more than I wanted.'"
Rachel_sorry		"'Thank you, but nothing is going to change my fate now.'"
Rachel_rachel		"'Yes! But how do you know?'"
Rachel_intuition	"'I find that hard to believe.'"
Rachel_father		"'How do you know my father?'"
Rachel_home		"'I can't get out of here, they keep us locked up.'"
Rachel_locked		"'You did? Great! But they took my clothes so now I have nothing to wear outside.'"
Rachel_do_about	"'Okay, I'll wait.'"
Rachel_back		"'Anything new?'"
Rachel_clothes		"'That's so nice of you. How can I thank you for your help?'"
Rachel_go_now	"'OK. I'll be waiting there for you.'"

Table of Rachel Conversation
prompt		response				enabled
"'Never mind me, I'm already gone.'"			Rachel_just_looking		1
"'I'm with the delivery service'"	Rachel_delivery	1
"'Thanks a bunch, I'll be going there, then.'"		Rachel_thanks		0
"'How come you are in this place?'"		Rachel_young		0
"'I'm sorry to hear that.'"	Rachel_sorry	0
"'Could it be your name is Rachel by any chance?'"	Rachel_rachel		0
"'Your father told me about you.'"		Rachel_father		0
"'Oh, it was just a guess.'"	Rachel_intuition	0
"'That bears little consequence. He misses you. Why don't you come back home?'"	Rachel_home	0	
"'I cut the barbed wire in front of the loo window.'"	Rachel_locked		0
"'I brought another outfit with me. Aren't you lucky today?'"	Rachel_clothes		0
"'I'll see what I can do about that clothing problem of yours. You stay here.'"		Rachel_do_about	0
"'I'm back.'"		Rachel_back	0
"'We'll get to that later. Go back to your father for now. Make sure no one sees you.'"		Rachel_go_now	0

Before quipping when the current quip is Rachel_greeting:
	say "I said [if Rachel is acquainted][italic type]'Hello'[roman type] to Rachel.[else][italic type]'Good evening'[roman type] to the girl.[end if][paragraph break]".

After quipping when the current quip is Rachel_delivery:
	disable the Rachel_just_looking quip;
	enable the Rachel_thanks quip;
	enable the Rachel_young quip;

After quipping when the current quip is Rachel_just_looking:
	enable the Rachel_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Rachel_thanks:
	enable the Rachel_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Rachel_young:
	disable the Rachel_just_looking quip;
	disable the Rachel_thanks quip;
	if the player is aware:
		enable the Rachel_rachel quip;
	else:
		enable the Rachel_sorry quip.

After quipping when the current quip is Rachel_sorry:
	enable the Rachel_just_looking quip;
	enable the Rachel_young quip;
	terminate the conversation.

After quipping when the current quip is Rachel_rachel:
	now Rachel is acquainted;
	now the printed name of Rachel is "Rachel";
	enable the Rachel_father quip;
	enable the Rachel_intuition quip.

After quipping when the current quip is Rachel_father:
	disable the Rachel_intuition quip;
	enable the Rachel_home quip.

After quipping when the current quip is Rachel_home:
	enable the Rachel_locked quip.

After quipping when the current quip is Rachel_locked:
	if the player carries at least one clothing and the player carries at least one footwear:
		if the clothing carried by the player is wafuku and the player carries no sash:
			enable the Rachel_do_about quip;
		else:
			enable the Rachel_do_about quip;
			enable the Rachel_clothes quip;
	else:
		enable the Rachel_do_about quip;

After quipping when the current quip is Rachel_do_about:
	disable the Rachel_clothes quip;
	enable the Rachel_back quip;
	terminate the conversation;
	
After quipping when the current quip is Rachel_back:
	if the player carries at least one clothing and the player carries at least one footwear:
		if the clothing carried by the player is wafuku and the player carries no sash:
			enable the Rachel_do_about quip;
		else:
			enable the Rachel_do_about quip;
			enable the Rachel_clothes quip;
	else:
		enable the Rachel_do_about quip;

After quipping when the current quip is Rachel_clothes:
	disable the Rachel_do_about quip;
	now Rachel wears a random clothing carried by the player;
	now Rachel wears a random footwear carried by the player;
	if the clothing worn by Rachel is wafuku:
		now Rachel wears a random sash carried by the player;
		now the description of Rachel is "A redhead in [a random clothing worn by Rachel].";
	say "Rachel put on the clothes I had brought.[paragraph break]";
	enable the Rachel_go_now quip.

After quipping when the current quip is Rachel_go_now:
	now Rachel is rescued;
	terminate the conversation.

