!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.10.19 ORDispensor	[Z, GLULX]
! An object which dispenses a seemingly endless supply of other objects, like a pot
! of gold.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep:	none
!--------------------------------------------------------------------------------------
! This is an object that is designed to dispense quantities of a specific object.  It is useful 
! for things like a pot of gold coins, where the pot may contain numerous gold coins, but the 
! developer does not want to actually create all coins at once.  The class of the items that
! the derived object dispenses must be defined as the property "itemclass".  When the Dispensor
! object is initialised (automatically), a number of objects of the itemclass type are created.
! This number is stored in the "initial_count" property.  When the items are removed, more are 
! generated to replace them, when the items are returned to the dispensor, they are destroyed.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORDispensor";					!Constant USE_ORDispensor; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORDispensor; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.01.04	Initial Creation (not really but this is the earliest date I could find
!				without searching my code archive)
! 2002.02.26	fit to new template.
! 2002.04.03	modified faulty WORDSIZE definition.
! 2002.05.12	Added check to verify that player is present before 
!				printing messages. 
! 2002.10.19	Added autodep for ObjectInitialise 
!--------------------------------------------------------------------------------------
#ifdef USE_ORDispensor;message "          Processing library extension ORDispensor...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 

!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORDispensor_DONEREPLACE; constant ORDispensor_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORDispensor_DONEMESSAGE; constant ORDispensor_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORDispensor requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORDispensor_DONECODE;constant ORDispensor_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	#ifndef CanPlayerWitness;[CanPlayerWitness; rtrue; ]; #endif;
	class ORDispensor
		with	itemclass
		,		itemobj 0
		,		conceal_dispensing_items false
		,		accept_alternate_items true
		,		object_initialise[t;for(t=0:t<self.initial_count:t++)self.newitem();]
		,		initial_count 1
		,		initial 
				[;
					Locale(self);
				]
		,		newitem
				[numb o t;
					if(numb<1) numb=1;
					for(t=0:t<numb:t++)
					{
						o=(self.itemclass).create();
						move o to self;
						if(self.conceal_dispensing_items==true) give o concealed;
					}
					self.itemobj=o; !make sure that we have a real object reference
				]
		,		before
				[;
					LetGo: !create another object to replace the released one
						if(noun ofclass self.itemclass) {
							give noun ~concealed;
							self.newitem();
						}
					receive: !destroy a received itemobj if it is one of our items
						if(noun ofclass self.itemclass)
						{
							printorrun(self,receive_item_msg);
							self.itemclass.destroy(noun);
							return true;
						}
						if(self.accept_alternate_items==false){
							printorrun(self,cannot_receive_item_msg);
							return true;
						}
				]
		,		receive_item_msg[;  
					if(CanPlayerWitness()==false)rtrue;
					print (ig)CIVerb(actor,"put","put")," ",(the) noun," into ", (the) self, " with the rest.^";
				]
		,		cannot_receive_item_msg[;  
					if(CanPlayerWitness()==false)rtrue;
					print (ig)CICant(actor)," put ",(the) noun," into ", (the) self, ",.^";
				]
		has		container
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORDispensor_DONEGRAMMAR; constant ORDispensor_DONEGRAMMAR; #ifdef ORDispensor_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;