! Wearable.h
! begun 03 by she's long gone
!
! #Include between "Parser" and "Verblib".

Replace WearSub;
Replace DisrobeSub;

[ DisrobeSub obj person i j k;
  if (obj && person) { noun = obj; actor = person; <<Disrobe>>; }
  if (ObjectIsUntouchable(noun)) return;
  if (~~(noun ofclass Wearable)) return L__M(##Disrobe, 6, noun);
  if (noun.worn_by ~= actor) return L__M(##Disrobe, 1, noun);
  if (noun has locked && noun.manipulable_when_locked == 0) return L__M(##Disrobe, 3, noun);

    i = noun.covered_by;

    if (i && i.skirtlike ~= noun.clothing_type) return L__M(##Disrobe, 4, noun.covered_by);

    if (children(actor) >= actor.capacity) return L__M(##Disrobe, 5);

    if (i && i.skirtlike == noun.clothing_type)
	{ IncreaseLayers(actor, i.layer, noun.clothing_type, -1);
	  i.covering = noun.covering;
	}

    if (noun.clothing_type == 10)
	{ objectloop (j ofclass Wearable && j.covered_by == noun)
		j.covered_by = 0;
	}

  k = noun.covering;

  noun.worn_by = 0; noun.covering = 0;
  noun.layer = 0; noun.covered_by = 0;

  if (k) k.covered_by = i;
  give noun ~worn;
  if (AfterRoutines() == 1) rtrue;
  if (keep_silent == 1) rtrue;
  L__M(##Disrobe, 2, noun);
];

[ WearSub obj person i j k m n skirtflag;
  if (obj && person) { noun = obj; actor = person; <<Wear>>; }
  if (ObjectIsUntouchable(noun)) return;
  if (~~(noun ofclass Wearable))    return L__M(##Wear, 1, noun);
  if (parent(noun) ~= actor)		return L__M(##Wear, 2, noun);
  if (noun.worn_by == actor)		return L__M(##Wear, 3, noun);
  if (noun.gendered==female && actor hasnt female)           return L__M(##Wear, 5, noun);
  if (noun.gendered==male && actor hasnt male)               return L__M(##Wear, 6, noun);
  if (noun.gendered==neuter && actor hasnt neuter)           return L__M(##Wear, 7, noun);
  if (noun has locked && noun.manipulable_when_locked==0) return L__M(##Disrobe, 3, noun);

  skirtflag = 0; ! This will work for now, but it really needs to be able to handle more
		     ! complex situations.
    objectloop (m ofclass Wearable && m.worn_by == actor && m.skirtlike == noun.clothing_type)
			skirtflag = 1;

    i=CheckArea(actor, noun.clothing_type, skirtflag);

    if (i > 0) {

! Return the appropriate message if the maximum layer
! for that clothing type has been reached.
! This still needs to be tweaked for same_layer articles of clothing.
	 if (i.layer >= noun.max_layer)
	     return L__M(##Wear, 9, noun);

! Minimum layer test. The item to be worn must be able to be
! at at least its min_layer.
! This test should be simpler.
	 if ( i.layer < noun.min_layer-1 || i==0 && noun.min_layer > 0)
	     return L__M(##Wear, 10);

! Return the appropriate message if the actor is trying to put something on
! under a skirtlike, but the skirtlike is already at its max_layer.
	 if (skirtflag) {
       j=CheckAreaLow(actor, noun.clothing_type, 1);
       if (j.layer==j.max_layer or j.skirt_maxlayer) return L__M(##Wear, 11, j);
		}

! Return the appropriate message if it won't fit over
! a bulky piece of clothing being worn.
	 if (i.bulky > 0) return L__M(##Wear, 12, i);
	}

! Now sort through the mess of deciding which items
! of clothing get what layer, etc.
       if (i > 0) {
		if (skirtflag)
		{ if (j.skirtlike == j.clothing_type)
			{ n = j.covering; if(n) n.covered_by = noun;
			  noun.layer=j.layer; noun.covering=j.covering; j.covering=noun; noun.covered_by=j;
		  	  IncreaseLayers(actor, j.layer, noun.clothing_type, 1);
			}
		  else
			{ noun.layer=j.skirt_layer; noun.covering=j.skirt_covering; j.skirt_covering=noun;
			  noun.covered_by=j;
			  IncreaseLayers(actor, j.skirt_layer, noun.clothing_type, 1);
			}
		}
    		else
		{ if (noun.clothing_type == 10)
		  { objectloop (k ofclass Wearable && k.covered_by == 0)
			k.covered_by = noun;
		  }
		  else if (noun.same_layer == 1 && i.same_layer == 1) noun.layer = i.layer;
		  else { noun.layer = i.layer + 1; noun.covering = i; i.covered_by = noun; }
		}
	}
      else if (noun.skirtlike ~= noun.clothing_type or 0)
			{ j = CheckArea(actor, noun.skirtlike);
			  if (j) { noun.skirt_layer = j.layer + 1;
				     noun.skirt_covering = j;
				     j.covered_by = noun;
				   }
			  noun.layer = 1;
			}
		else noun.layer = 1;

  noun.worn_by = actor; give noun worn;

  if (AfterRoutines() == 1) rtrue;
  if (keep_silent == 1) rtrue;
  if (skirtflag == 1) return L__M(##Wear, 13, noun.covered_by);
  if (noun.covering ~= 0) return L__M(##Wear, 14, noun.covering);
  L__M(##Wear, 4, noun);
];

System_file;

Object LibraryMessages
 with	before
	[;
	  Disrobe: if ( ~~TestScope(actor, player) ) rtrue;
		switch (lm_n)
		{ 1:  if (actor == player) "You're not wearing ", (thatorthose) lm_o, ".";
			else print_ret (The) actor, " isn't wearing ", (thatorthose) lm_o, ".";
		  2:  if (actor == player) "You take off ", (the) lm_o, ".";
			else print_ret (The) actor, " takes off ", (the) lm_o, ".";
		  	if (lookmode==2) DescribeClothes(actor);
	  	  3:  print_ret (The) actor, " can't, because ", (the) lm_o, (IsorAre) lm_o, " locked.";
	  	  4:  print_ret (The) actor, " can't, because ", (the) lm_o, " ", (IsorAre) lm_o, " in the way.";
	  	  5:  "You can't, because your hands are too full.";
	  	  6:  print_ret (CThatorThose) lm_o, " ", (IsntorArent) lm_o, " something ", (the) actor, " can put on, much less take off.";
		}
	   Wear: if ( ~~TestScope(actor, player) ) rtrue;
		switch (lm_n)
		{ 1:  print_ret (The) actor, " can't wear ", (thatorthose) lm_o, "!";
        	  2:  print_ret (The) actor, " isn't holding ", (thatorthose) lm_o, "!";
        	  3:  print_ret (The) actor, " is already wearing ", (thatorthose) lm_o, "!";
		  4:  if (actor == player) print "You put on ", (the) lm_o, ".";
			else print_ret (The) actor, " puts on ", (the) lm_o, ".";
		  	if (lookmode == 2) DescribeClothes(actor);
	  	  5:  print_ret (CTheyreorThats) lm_o, " for girls.";
	  	  6:  print_ret (CTheyreorThats) lm_o, " for boys.";
	  	  7:  print_ret (CTheyreorThats) lm_o, " for eunuchs.";
	  	  9:  if (actor == player) print_ret (CThatorThose) lm_o, " won't fit over all that you're wearing.";
			else print_ret (CThatorThose) lm_o, " won't fit over all that ", (the) actor, " is wearing.";
	  	  10: if (actor == player) "You're not wearing enough yet.";
			else print_ret (The) actor, " isn't wearing enough yet.";
	  	  11: if (actor == player) "You can't, because you're wearing too much underneath ", (the) lm_o, ".";
			else print_ret (The) actor, " can't, because ", (the) actor, " is wearing too much underneath ", (the) lm_o, ".";
	  	  12: print_ret (The) actor, " can't, because ", (the) lm_o, " ", (IsorAre) lm_o, " too bulky.";
	  	  13: if (actor == player) "You slip ", (the) noun, " on underneath ", (the) lm_o, ".";
			else print_ret (The) actor, " slips ", (the) noun, " on underneath ", (the) lm_o, ".";
	  	  14: if (actor == player) "You put ", (the) noun, " on over ", (the) lm_o, ".";
			else print_ret (The) actor, " puts ", (the) noun, " on underneath ", (the) lm_o, ".";
		}
	];

Class Wearable,
 with area_covered 0,
      clothing_size 0,
      clothing_type 0,

	covered_by 0,
	covering 0,

	gendered false,

	bulky 0,
	manipulable_when_locked 0,

      layer 0,
	max_layer 5,
	min_layer 1,
      same_layer 0,

      worn_by 0,

	skirtlike 0,
	skirt_covering 0,
	skirt_layer 0,
	skirt_maxlayer 3,

	zippable false,
	zipped false,

	buttonable false,
	buttoned false,

	bucklable false,
	buckled false,

	tuckable false,
	tucked false,

 has	clothing;

! DescribeClothes(subject) : Generates a list of the clothing being worn by the
! specified actor.

[ DescribeClothes subject n m;
  m=0;
  if(subject==player) print "You are now wearing ";
  else print "You can now see that ", (TheyAreorThatIs) subject, " wearing ";
  objectloop(n in subject&&n ofclass Wearable)
    { if(n.worn_by~=0) { give n workflag; m++; } else give n ~workflag;
      if(action==##Disrobe) give self ~workflag;
    }
    if(m==0) print_ret "nothing.";
    else
     { WriteListFrom(child(parent(self)),
       ENGLISH_BIT + RECURSE_BIT + WORKFLAG_BIT);
        ".";
     }
];

! CheckArea(subject, test_type, skirt_test): Returns the item with the highest layer of
! the selected (clothing_type) on the subject. If skirt_test == 1, it
! searches for the highest-layered skirtlike.

[ CheckArea subject test_type skirt_test flag i;
  flag=0;
  if (skirt_test == 1)
  objectloop (i ofclass Wearable && i.worn_by==subject && i.skirtlike==test_type)
	{ if (flag==0) flag=i;
	  else if (flag.layer < i.layer) flag=i;
	}
  else
  objectloop (i ofclass Wearable && i.worn_by==subject && i.clothing_type==test_type)
     { if (flag==0) flag=i;
	 else if (flag.layer < i.layer) flag=i;
     }
  return flag;
];

! CheckAreaLow(subject, test_type, skirt_test): Returns the item with the lowest layer of
! the selected (clothing_type) on the subject. If skirt_test == 1, it searches for the
! lowest-layered skirtlike not being covered by a non-skirtlike.

[ CheckAreaLow subject test_type skirt_test flag i j;
  flag=0;
  if (skirt_test == 1)
  objectloop (i ofclass Wearable && i.worn_by==subject && i.skirtlike==test_type)
	{ if (flag==0) flag=i;
	  else { j=i.covered_by; if (i.layer < flag.layer && j == 0 || j.skirtlike ~= 0) flag=i; }
	}
  else
  objectloop (i ofclass Wearable && i.worn_by==subject && i.clothing_type==test_type)
     { if (flag==0) flag=i;
	 else if (i.layer >= flag.layer) flag=i;
     }
  return flag;
];

! CheckLayer(subject, test_layer): Returns the first article of clothing worn
! at the selected (layer) in the subject's inventory.

[ CheckLayer subject test_layer flag i;
  flag=0;
  objectloop (i ofclass Wearable && i.worn_by==subject && i.layer==test_layer) { flag=i; }
  return flag;
];

! IncreaseLayers(subject, min, type, amount): Every Wearable on the subject,
! if it's relevant layer property is >= min, has that property is increased by amount.

[ IncreaseLayers subject min type amount i;
  objectloop (i ofclass Wearable && i.worn_by==subject && (i.layer >= min || i.skirt_layer >= min))
    { if (i==0) rtrue;
	if (i.skirtlike == type && i.skirtlike ~= i.clothing_type) i.skirt_layer = i.skirt_layer + amount;
	else if (i.clothing_type == type) i.layer = i.layer + amount;
    }
];

[ IsntorArent obj;
  if (obj == player || obj has pluralname) print "aren't";
	else print "isn't";
];

[ TheyAreorThatIs obj;
  if (obj == player)			{ print "you are"; return; }
  if (obj has pluralname)		{ print "they are"; return; }
  if (obj has animate) {
  if (obj has female)			{ print "she is"; return; }
	else if (obj hasnt neuter)	print "he is";
  }
];