/*
	HDMSVC.C

	Non-portable functions specific to Win32

	Copyright (c) 1997-2006 by Kent Tessman
*/


#include <windows.h>
#undef GetProp

#include "heheader.h"
#include "hdheader.h"
#include "hdwinext.h"


/* If we're replacing main() in he.c */
#if defined (FRONT_END)
int he_main(int argc, char **argv);     /* from he.c */
void Banner(void);
#endif


int debug_fcolor, debug_bgcolor;
int debug_cursorx = 1, debug_cursory = 1;


/* from hdwin.c */
extern HINSTANCE AppInstance;
extern HWND wndDebug;
extern HWND wndStatus;
extern HWND wndMDIClient;
extern HACCEL accelDebug;

extern debug_childwindow_struct debug_childwindow[];

extern HWND wndHelpText;
extern int help_text_len;
extern char help_text_buffer[];

/* from hewin.c */
extern HWND wndMain;
extern HACCEL accelMain;

/* from hdupdate.c */
extern int currently_updating;


/* debug_getevent 

	This is where the actual Windows API message loop is.
	As well, there are a couple of window-management checks
	here because they need to be done repeatedly.
*/

extern int current_windex_update;	// from hdwin.c

void debug_getevent(void)
{
	MSG msg;

	/* Since hd.c will otherwise continually reset it to "help" */
	context_help = debug_childwindow[WhichWindow(active_window)].name;

	/* If there's a window waiting to be updated */
	if (current_windex_update!=-1)
		RedrawDebuggerChild(current_windex_update);
	current_windex_update = -1;

	event.action = 0;

	if (GetMessage(&msg, NULL, 0, 0)>0)
	{
		/* Have to check two different sets of accelerators
		   depending on the current window, so might as well
		   do it this way
		*/
		
		/* Output/game window */
		if (GetForegroundWindow()==wndMain)
		{
			if (!TranslateAccelerator(wndMain, accelMain, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}

		/* Debugger window(s) */
		else
		{
			if (!TranslateMDISysAccel(wndMDIClient, &msg) &&
				!TranslateAccelerator(wndDebug, accelDebug, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
	else
		exit(msg.wParam);
}


/* debug_input

	Called by InputBox to get an input of maxlen characters.  Must
	return an empty string ("") if the input is cancelled by pressing
	Escape.
*/

/* Win32 - not needed; see InputBox() in hdnewwin.c */

char *debug_input(int x, int y, int maxlen, char *def)
{
	return 0;
}


/* debug_getinvocationpath

	Systems for which main()'s argv[0] does not contain the full
	path of the debugger executable will have to add the current
	path here.
*/

void debug_getinvocationpath(char *argv)
{
	strcpy(invocation_path, argv);
}


/* debug_print

	Prints the supplied string at the current cursor position
	on the debugger screen in the current color.
*/

// For text-borderless Win32:
#define X_OFFSET 2
#define Y_OFFSET 1

void debug_print(char *a)
{
	size_t i;
	debug_childwindow_struct *dbc;

	/* The Help window is a simple edit control; just pass
	   text to it
	*/
	if (currently_updating==VIEW_HELP)
	{
		/* See left-margin offset in hdmisc.c:SearchHelp() */
		if (a[0]==' ') a = &a[26];

		for (i=0; i<strlen(a); i++)
		{
			if (help_text_len>=MAX_HELP_TEXT-2)
				return;
			help_text_buffer[help_text_len++] = a[i];
		}
		help_text_buffer[--help_text_len] = '\r';
		help_text_buffer[++help_text_len] = '\n';
		help_text_buffer[++help_text_len] = '\0';
		SetWindowText(wndHelpText, help_text_buffer);

		return;
	}

	/* Otherwise, normal windows get printed to like this: */

	dbc = &debug_childwindow[WhichWindow(currently_updating)];

	for (i=0; i<strlen(a); i++)
	{
		if (debug_cursorx>=CHILD_TEXT_WIDTH || debug_cursorx<X_OFFSET)
			break;

		/* (1, 1) becomes (0, 0) since the debugger output
		   was originally designed for a character-based
		   display complete with text borders
		*/
		if (debug_cursorx>=X_OFFSET && debug_cursory>=Y_OFFSET)
		{
			dbc->textgrid[debug_cursorx-X_OFFSET][debug_cursory-Y_OFFSET].chr = a[i];
			dbc->textgrid[debug_cursorx-X_OFFSET][debug_cursory-Y_OFFSET].fcolor = debug_fcolor;
			dbc->textgrid[debug_cursorx-X_OFFSET][debug_cursory-Y_OFFSET].bgcolor = debug_bgcolor;
		}

		debug_cursorx++;
	}
}


/* debug_settextcolor and debug_setbackcolor */

void debug_settextcolor(int c)
{
	debug_fcolor = c;
}

void debug_setbackcolor(int c)
{
	debug_bgcolor = c;
}


/* debug_hardcopy

	Sends the supplied string to the printer as a single line.
	The string does not end with a newline character.
*/

/* Figure out a decent way to do this for Win32 */

void debug_hardcopy(FILE *printer, char *a)
{
	if (fprintf(printer, a)<0) device_error = true;
	if (fprintf(printer, "\n")<0) device_error = true;
}


/* hugo_init_screen */

void hugo_init_screen(void)
{
	int i;

	D_SCREENHEIGHT = CHILD_TEXT_HEIGHT;
	D_SCREENWIDTH =  CHILD_TEXT_WIDTH;

	/* All windows are the same height and width in terms of
	   the text grid size */
	for (i=CODE_WINDOW; i<WINDOW_COUNT; i++)
	{
		window[i].top = 1;
// UpdateDebuggerChildHeight() will do this properly
//		window[i].height = D_SCREENHEIGHT;
		window[i].width = D_SCREENWIDTH;
	}
}


/* debug_switchscreen

	Switches the text display/output to either DEBUGGER, GAME, 
	HELP, or AUXILIARY, as supplied.  The cursor should also 
	be switched off or on (if applicable).
*/

extern int current_text_color, current_back_color;	/* hemsvc.c */

void debug_switchscreen(int a)
{
	static int game_fcolor, game_bgcolor;

	if (active_screen==GAME)
	{
		game_fcolor = current_text_color;
		game_bgcolor = current_back_color;
	}

	switch (active_screen = a)
	{
                case DEBUGGER:
		{
			ShowWindow(wndDebug, SW_SHOW);
			SetForegroundWindow(wndDebug);
			break;
		}
		case GAME:
		{
			ShowWindow(wndMain, SW_SHOW);
			SetForegroundWindow(wndMain);
			hugo_settextcolor(game_fcolor);
			hugo_setbackcolor(game_bgcolor);
			break;
		}
		case HELP:
		case AUXILIARY:
		{
			break;
		}
	}
}


/* debug_cursor

	Turns the cursor on (1) or off (0)--if necessary.
*/

/* Win32 - not needed */

void debug_cursor(int n)
{}


/* debug_settextpos

	Different from hugo_settextpos() in that it doesn't do any
	accounting for proportional printing.
*/

void debug_settextpos(int x, int y)
{
	debug_cursorx = x;
	debug_cursory = y;
}


/* debug_windowsave and debug_windowrestore */

/* Win32 - Neither of these is needed, since menuing is taken care 
   of by the Windows API.
*/

void *debug_windowsave(int left, int top, int right, int bottom)
{
	return NULL;
}

void debug_windowrestore(void *b, int xpos, int ypos)	/* note:  (x, y) */
{}


/* debug_windowshadow */

/* Win32 - not needed */

void debug_windowshadow(int left, int top, int right, int bottom)
{}


/* debug_windowbottomrow */

void debug_windowbottomrow(char *caption)
{
	char oldcaption[MAXPATH];

	GetWindowText(wndStatus, oldcaption, MAXPATH-1);
	
	/* Only set the statusbar text if it's changed in order to
	   prevent flickering
	*/
	if (strcmp(caption, oldcaption))
		SendMessage(wndStatus, WM_SETTEXT, 0, (LPARAM)caption);
}


/* debug_windowscroll

	Scrolls the defined window in a direction given by the param
	constant.
*/

void debug_windowscroll(int left, int top, int right, int bottom, int param, int lines)
{
	int x, y;
	int windex;
	
	windex = WhichWindow(currently_updating);

	debug_settextcolor(color[NORMAL_TEXT]);
	debug_setbackcolor(color[NORMAL_BACK]);

	while (lines--)
	{
		switch (param)
		{
			case UP:
			{
				for (y=1; y<CHILD_TEXT_HEIGHT; y++)
				for (x=0; x<CHILD_TEXT_WIDTH; x++)
				{
					debug_childwindow[windex].textgrid[x][y-1] =
						debug_childwindow[windex].textgrid[x][y];
				}

				/* blank line */
				for (x=0; x<CHILD_TEXT_WIDTH; x++)
				{
					debug_childwindow[windex].textgrid[x][CHILD_TEXT_HEIGHT-1].chr = 0;
					debug_childwindow[windex].textgrid[x][CHILD_TEXT_HEIGHT-1].fcolor = debug_fcolor;
					debug_childwindow[windex].textgrid[x][CHILD_TEXT_HEIGHT-1].bgcolor = debug_bgcolor;
				}
				break;
			}

			case DOWN:
			{
				for (y=CHILD_TEXT_HEIGHT-1; y>=1;  y--)
				for (x=0; x<CHILD_TEXT_WIDTH; x++)
				{
					debug_childwindow[windex].textgrid[x][y] =
						debug_childwindow[windex].textgrid[x][y-1];
				}

				/* blank line */
				for (x=0; x<CHILD_TEXT_WIDTH; x++)
				{
					debug_childwindow[windex].textgrid[x][0].chr = 0;
					debug_childwindow[windex].textgrid[x][0].fcolor = debug_fcolor;
					debug_childwindow[windex].textgrid[x][0].bgcolor = debug_bgcolor;
				}
				break;
			}
		}
	}
}


/* debug_clearview

        Clears the selected window given by n.
*/

void debug_clearview(int n)
{
	int x, y;

	/* Because the Help window is actually an Edit control */
	if (n==VIEW_HELP)
	{
		strcpy(help_text_buffer, "");
		help_text_len = 0;
		return;
	}
	else if (WhichWindow(n)==-1)
		return;

	debug_settextcolor(color[NORMAL_TEXT]);
	debug_setbackcolor(color[NORMAL_BACK]);
	debug_settextpos(1, 1);

	for (x=0; x<CHILD_TEXT_WIDTH; x++)
	for (y=0; y<CHILD_TEXT_HEIGHT; y++)
	{
		debug_childwindow[WhichWindow(n)].textgrid[x][y].chr = ' ';
		debug_childwindow[WhichWindow(n)].textgrid[x][y].fcolor = debug_fcolor;
		debug_childwindow[WhichWindow(n)].textgrid[x][y].bgcolor = debug_bgcolor;
	}
}


/* debug_shortcutkeys

	Switches to the Auxiliary window/page and prints the shortcut
	keys available to this port/system.
*/

/* Win32 - not needed */

void debug_shortcutkeys(void)
{}
