/*
 * Decompiled with CFR 0.152.
 */
package iageserver;

import iageserver.Server;
import iageserver.data;
import iageserver.mainframe_AboutBox;
import iageserver.mainframe_btnKillPlayer_actionAdapter;
import iageserver.player;
import iageserver.startupclass;
import iageserver.vdu;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class mainframe
extends Frame {
    private Panel contentPane;
    private BorderLayout borderLayout1 = new BorderLayout();
    private MenuBar jMenuBar1 = new MenuBar();
    private Menu jMenuFile = new Menu();
    private MenuItem jMenuFileOpen = new MenuItem();
    private MenuItem jMenuFileExit = new MenuItem();
    private Menu jMenuServer = new Menu();
    private MenuItem jMenuServerStartServer = new MenuItem();
    private MenuItem jMenuServerStopServer = new MenuItem();
    private Menu jMenuHelp = new Menu();
    private MenuItem jMenuHelpAbout = new MenuItem();
    private TextArea txtout = new TextArea();
    private List lstp = new List();
    private Panel pnlplay = new Panel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Button btnKillPlayer = new Button();
    private Label lblConn = new Label();
    private String curdir = "";
    private Server theServer = null;

    public mainframe(Server s) {
        try {
            this.enableEvents(64L);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.theServer = s;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(640, 480));
        this.setTitle("Server - IAGE");
        this.jMenuFile.setLabel("File");
        this.jMenuFileOpen.setLabel("Load IAGE Game File");
        this.jMenuFileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainframe.this.jMenuFileOpen_actionPerformed(e);
            }
        });
        this.jMenuFileExit.setLabel("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainframe.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuServer.setLabel("Server");
        this.jMenuServerStartServer.setLabel("Start Server");
        this.jMenuServerStartServer.setEnabled(false);
        this.jMenuServerStartServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainframe.this.jMenuServerStartServer_actionPerformed(e);
            }
        });
        this.jMenuServerStopServer.setLabel("Stop Server");
        this.jMenuServerStopServer.setEnabled(false);
        this.jMenuServerStopServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainframe.this.jMenuServerStopServer_actionPerformed(e);
            }
        });
        this.jMenuHelp.setLabel("Help");
        this.jMenuHelpAbout.setLabel("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mainframe.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jMenuFile.add(this.jMenuFileOpen);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuServer.add(this.jMenuServerStartServer);
        this.jMenuServer.add(this.jMenuServerStopServer);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuServer);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setMenuBar(this.jMenuBar1);
        this.txtout.setForeground(Color.blue);
        this.txtout.setBackground(Color.white);
        this.txtout.setEditable(false);
        this.add((Component)this.txtout, "Center");
        this.lblConn.setText("Connections:");
        this.btnKillPlayer.setLabel("Kill Player");
        this.btnKillPlayer.addActionListener(new mainframe_btnKillPlayer_actionAdapter(this));
        this.pnlplay.setLayout(this.borderLayout2);
        this.pnlplay.add((Component)this.lstp, "Center");
        this.pnlplay.add((Component)this.btnKillPlayer, "South");
        this.pnlplay.add((Component)this.lblConn, "North");
        this.add((Component)this.pnlplay, "East");
        vdu.out = this.txtout;
        vdu.connectionlist = this.lstp;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jMenuFileOpen_actionPerformed(ActionEvent e) {
        String loadpath = new File("").getAbsolutePath() + File.separator + "lastpath.ini";
        try {
            File ourpath = new File(loadpath);
            FileInputStream in = new FileInputStream(ourpath);
            this.curdir = this.readline(in);
            in.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        FileDialog chooser = new FileDialog((Frame)this, this.curdir);
        chooser.setTitle("Select an IAGE game file to load");
        chooser.show();
        if (chooser.getFile().equals("") || chooser.getFile().equals(null)) {
            return;
        }
        this.curdir = chooser.getDirectory();
        String savepath = new File("").getAbsolutePath() + File.separator + "lastpath.ini";
        try {
            File lastpath = new File(savepath);
            FileOutputStream out = new FileOutputStream(lastpath);
            this.writeline(out, this.curdir);
            out.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        startupclass.startup(chooser.getDirectory() + chooser.getFile());
        this.jMenuServerStartServer.setEnabled(true);
        this.jMenuServerStopServer.setEnabled(false);
    }

    public void loadGameFile(String filename) {
        startupclass.startup(new File("").getAbsolutePath() + File.separator + filename);
        this.jMenuServerStartServer.setEnabled(true);
        this.jMenuServerStopServer.setEnabled(false);
    }

    public void jMenuServerStartServer_actionPerformed(ActionEvent e) {
        this.jMenuServerStartServer.setEnabled(false);
        this.jMenuServerStopServer.setEnabled(true);
        this.jMenuFileOpen.setEnabled(false);
        this.theServer.startServer();
    }

    public void jMenuServerStopServer_actionPerformed(ActionEvent e) {
        this.jMenuServerStartServer.setEnabled(true);
        this.jMenuServerStopServer.setEnabled(false);
        this.jMenuFileOpen.setEnabled(true);
        this.theServer.stopServer();
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        mainframe_AboutBox dlg = new mainframe_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    public void btnKillPlayer_actionPerformed(ActionEvent e) {
        if (this.lstp.getSelectedIndex() == -1) {
            return;
        }
        String si = this.lstp.getItem(this.lstp.getSelectedIndex());
        si = si.substring(0, si.indexOf(":"));
        int idx = Integer.parseInt(si);
        int i = 1;
        player p = null;
        while (i <= data.oplayers.getCount()) {
            p = (player)data.oplayers.get(i);
            if (p.Index == idx) {
                vdu.Transmit("Your socket was deliberately killed by the server operative.", p);
                p.quit(true);
                return;
            }
            ++i;
        }
    }

    private void writeline(FileOutputStream out, String s) {
        byte[] ba = s.getBytes();
        try {
            out.write(ba);
            byte[] bb = new byte[]{13, 10};
            out.write(bb);
        }
        catch (Exception e) {
            e.printStackTrace();
            vdu.println("Error writing to file - " + e.getMessage());
        }
    }

    private String readline(FileInputStream fs) {
        StringBuffer sb = new StringBuffer("");
        int nb = -1;
        while (true) {
            try {
                nb = fs.read();
            }
            catch (Exception e) {
                vdu.println("Error reading from file - " + e.getMessage());
                return sb.toString();
            }
            if (nb == 13) {
                try {
                    nb = fs.read();
                }
                catch (Exception e) {
                    vdu.println("Error reading from file - " + e.getMessage());
                    return sb.toString();
                }
                return sb.toString();
            }
            if (nb == -1) {
                return sb.toString();
            }
            Integer iob = new Integer(nb);
            byte[] by = new byte[]{iob.byteValue()};
            sb.append(new String(by));
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.theServer.killAdminThread();
            if (this.theServer.serverisrunning) {
                this.jMenuServerStopServer_actionPerformed(null);
            }
            this.jMenuFileExit_actionPerformed(null);
        }
    }
}

