package iageclient;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;

/**Separate threaded class which listens for stuff coming down
   the network pipe*/
public class listenthread extends Thread {

  private Socket Con;
  private DataInputStream in;
  private PrintWriter out;
  private iageconnector ic; // Held so we can call output routines
  private Thread TRef;
  
  /*** State property which tells the loop to wind up */
  public boolean isFinished = false;

  /**
   *  Constructor - requires open IP Socket, open Input and output streams
   *  and a valid IAGEconnector object.
   */
  public listenthread(Socket S, DataInputStream B, PrintWriter P, iageconnector iagecon) {

    Con = S;
    in = B;
    out = P;
    ic = iagecon;

    TRef = this;
    this.start();

  }

  /*** Monitors socket connection and sends all incoming data to iageconnector */
  public void run() {

      int i;
      byte[] ba = new byte[8192];
      String buf;

      // Start monitoring
      isFinished = false;

      try {

        while ( !isFinished ) {

	      i = in.read(ba);
	
	      if (i > 0) {
	      	// Convert byte array to string
	        buf = new String(ba);
	        // Chop string to correct length
	        buf = buf.substring(0, i);
	        // Preprocess it and output
	      	ic.PreProcessAndOutput(buf);
	      }
	      try {
          	TRef.sleep(20);
          }
          catch (InterruptedException e) {}
        }
      }
      catch(Exception e) {
        e.printStackTrace();
      }
      finally {
      	try {
	      	// Clear up after ourselves
	        out.close();
	        in.close();
	        Con.close();
    	}
    	catch (Exception e) {
    		e.printStackTrace();	
    	}
        
      	ic.OutputText(" \nSocket closed.");
      }

  }
}
