
import java.awt.*;

public class PreOutput extends Thread {
	
	/** The buffered text, waiting to be output */
	private String outbuffer = "";
	private Displayer thedisplay = null;
	private boolean stillrunning = false;
	private boolean needsupdate = false;
	private Label statuslabel = null;
	
	public PreOutput(Displayer td, Label statusbar) {
		thedisplay = td;	
		statuslabel = statusbar;
	}
	
	public synchronized Displayer getDisplayer() {
		return thedisplay;	
	}
	
	public synchronized void setDisplayer(Displayer d) {
		thedisplay = d;	
	}
	
	/** Just keeps the thread going */
	public void run() {	
	
		stillrunning = true;
		while (stillrunning) {
			
			this.yield();
			
			// See if we have anything to do
			if (outbuffer.length() > 0 && thedisplay.getIsReady()) {
			
				// Check to see if the display is busy - if it is,
			    // wait for it to become free again and yield in the meantime
				while (thedisplay.getIsBusy()) {
					
					try {
						this.sleep(500);
					}
					catch (Exception e) {e.printStackTrace();}
					
					if (needsupdate) {
						needsupdate = false;
						thedisplay.repaint();
					}
				}
				
				// Tell user we are parsing
				showProcessing();
				
				// Going to need an update once finished
				needsupdate = true;
				    
				// Pre-parsing - batch convert any HTML tags which
				//   can be expressed as chars right now 
				
				// Spaces
				outbuffer = PreOutput.replace(outbuffer, "&nbsp;", " ");
				
				// If our buffer begins with a line break, throw it away
				// now, since we are about to start on a separate line anyway.
				if (outbuffer.length() > 4)  {
					if (outbuffer.substring(0, 4).equalsIgnoreCase("<br>")) {
						outbuffer = outbuffer.substring(4, outbuffer.length());
					}
				}   
				    
				// Grab the next line of text from the buffer, ignoring
				//    HTML tags counting up until we run out of room. Then
				//    count backwards until we find a space
				    
				int iter = 0;        // current char in buffer
				int colscounted = 0; // valid chars counted
				String curchar = ""; // current character
				String nextline = ""; // the next line
				String linebuffnoformatting = ""; // the current line without tags
				boolean returnfound; // Flag for later on - says that
											 // we broke at a <br> tag instead
											 // of doing a complete line
				
				returnfound = false;
				
				while (0 == 0) {
				
					try {
						
						// Measure our line so far to see if we have gone
						// over the line limit and break out if we have.
						if (thedisplay.getStringWidth(linebuffnoformatting))
							break;
						
						curchar = outbuffer.substring(iter, iter + 1);
						
						// if we have an HTML tag, skip right past and ignore it
						// unless it is a BR tag, in which case, use that as the
						// next line
						if (curchar.equals("<")) {
							
							if (outbuffer.length() >= iter + 4) {
								if (outbuffer.substring(iter, iter + 4).equalsIgnoreCase("<br>")) {
									returnfound = true;
									break;
								}
							}		
							
							while (!curchar.equals(">")) {
								iter++;
								curchar = outbuffer.substring(iter, iter + 1);
							}
						}
						else 
						{
							// It's valid, add it on
							colscounted++;	
							linebuffnoformatting += curchar;
						}
						
						// See if we have reached the end of the output buffer
						if (iter == outbuffer.length() - 1) {
							// We have - stop this right now
							break;
						}
					}
					catch (Exception e) {
						e.printStackTrace();
					}
					
					iter++;
					
				}
				
				try {
				
					// If we broke on a <br>, take the buffer up to that
					// and remove the tag as well as the text from the buffer
					if (returnfound) {
						nextline = outbuffer.substring(0, iter + 4);
						outbuffer = outbuffer.substring(iter + 4, outbuffer.length());
					}
					else
					{
						// If we reached the end of the output buffer, the whole thing
						// is applicable and should be removed
						if (iter == outbuffer.length() - 1) {
							nextline = outbuffer.substring(0, iter + 1);
							outbuffer = "";
						}
						else
						{
						
							// Otherwise, hunt backwards now to find a space or a
							// hyphen.
							int i = iter;
							while (i > 0) {
							
								curchar = outbuffer.substring(i, i + 1);	
								if (curchar.equals(" ") || curchar.equals("-")) {
								
									// Break the line here instead
									nextline = outbuffer.substring(0, i + 1);
									
									// Strip this line from the buffer
									outbuffer = outbuffer.substring(i + 1, outbuffer.length());	
				
									break;
				
								}
								i--;
							}
						}
					}
				}
				catch (Exception e) {
					e.printStackTrace();
				}
			    
				// Send the line to the displayer 
				thedisplay.renderLine(nextline, statuslabel);
				
			}
			else
			{
				// No rendering required - force update
				if (needsupdate) {
					needsupdate = false;
					thedisplay.repaint();
				
					// No longer need to show user we are processing
					hideProcessing();
				}
				
				// Yield thread
				try {
					this.sleep(500);
				}
				catch (Exception e) {e.printStackTrace();}
			}
		}
	}
	
	public static synchronized String replace(String findin, String find, String replacewith) {
	
		String sb = findin;
		int i = 0;
			
		while (i <= sb.length() - find.length()) {
			if (sb.substring(i, i + find.length()).equalsIgnoreCase(find)) {
				
				StringBuffer nsb = new StringBuffer(sb);
				sb = PreOutput.stringbuffreplace(nsb, i, i + find.length(), replacewith).toString();
				
			}
			i++;
		}
		return sb.toString();
	}
	
	/** Because the string buffer replace method does not exist in 1.1 (which
	  * most browsers support, I have had to implement my own version of it). */
	public static synchronized StringBuffer stringbuffreplace(StringBuffer sb, int start, int end, String replacewith) {
	
		String thebuff = sb.toString(); // convert buff to string
		String firstchunk = thebuff.substring(0, start); // get left side before replace
		String secondchunk = thebuff.substring(end, sb.length()); // get right side after replace
		String output = firstchunk + replacewith + secondchunk; // build new string
		sb = new StringBuffer(output); // return it
		return sb;
		
	}
	
	/** Stops this thread running */
	public synchronized void stopThread() {
		stillrunning = false;
	}
	
	/** Puts text in the buffer for master thread to take over */
	public synchronized void Output(String s) {
		
		/** Paste new text onto our existing buffer */
		outbuffer = outbuffer + s;	
		
	}
	
	public synchronized void showProcessing() {
		if (statuslabel == null) return;
		statuslabel.setText("[Processing...]");
		statuslabel.repaint();
	}
	
	public synchronized void hideProcessing() {
		if (statuslabel == null) return;
		statuslabel.setText("");	
		statuslabel.repaint();
	}
		
}