package iagecompiler;

/**
 * Abstract class containing constants for dictionary and messages.
 */
public abstract class constant {

    public static long VERB_GO = 1;
    public static long VERB_LOOK = 2;
    public static long VERB_VERSION = 3;
    public static long VERB_HELP = 4;
    public static long VERB_GET = 5;
    public static long VERB_DROP = 6;
    public static long VERB_PUT = 7;
    public static long VERB_REMOVE = 8;
    public static long VERB_LIGHT = 9;
    public static long VERB_EXTINGUISH = 10;
    public static long VERB_SWITCH = 11;
    public static long VERB_INVENTORY = 12;
    public static long VERB_EXAMINE = 13;
    public static long VERB_SAY = 14;
    public static long VERB_SHOUT = 15;
    public static long VERB_WEAR = 16;
    public static long VERB_OPEN = 18;
    public static long VERB_CLOSE = 19;
    public static long VERB_READ = 20;
    public static long VERB_BREAK = 21;
    public static long VERB_EAT = 22;
    public static long VERB_DRINK = 23;
    public static long VERB_LOCK = 24;
    public static long VERB_UNLOCK = 25;
    public static long VERB_KILL = 26;
    public static long VERB_THROW = 27;
    public static long VERB_PUSH = 28;
    public static long VERB_PULL = 29;
    public static long VERB_FIGHT = 30;
    public static long VERB_WHAT = 31;
    public static long VERB_WHERE = 32;
    public static long VERB_WHO = 33;
    public static long VERB_HOW = 34;
    public static long VERB_WHY = 35;
    public static long VERB_SWIM = 36;
    public static long VERB_FLY = 37;
    public static long VERB_YES = 38;
    public static long VERB_NO = 39;
    public static long VERB_CLIMB = 40;
    public static long VERB_SCORE = 41;
    public static long VERB_JUMP = 42;
    public static long VERB_SMELL = 43;
    public static long VERB_LISTEN = 44;
    public static long VERB_PREPROCESS_SENTENCEBREAKER = 45;
    public static long VERB_SC_SETALIAS = 46;
    public static long VERB_SC_LISTPLAYERS = 47;
    public static long VERB_SC_GETSCORE = 48;
    public static long VERB_SC_SAY = 49;
    public static long VERB_SC_SHOUT = 50;
    public static long VERB_SC_QUIT = 51;
    public static long VERB_SC_RUN_ON_START = 52;
    public static long VERB_SC_VERBOSE = 53;
    public static long VERB_SC_BRIEF = 54;
    public static long VERB_SC_AGAIN = 55;
    public static long VERB_LIE = 56;
    public static long VERB_SIT = 57;
    public static long VERB_STAND = 58;
    public static long VERB_STATUS = 59;

    public static long NOUN_IT = 1;
    public static long NOUN_ALL = 2;
    public static long NOUN_EXCEPT = 3;
    public static long NOUN_MYSELF = 4;

    public static long ADVB_NORTH = 1;
    public static long ADVB_SOUTH = 2;
    public static long ADVB_EAST = 3;
    public static long ADVB_WEST = 4;
    public static long ADVB_UP = 5;
    public static long ADVB_DOWN = 6;
    public static long ADVB_NORTHEAST = 7;
    public static long ADVB_NORTHWEST = 8;
    public static long ADVB_SOUTHEAST = 9;
    public static long ADVB_SOUTHWEST = 10;
    public static long ADVB_ON = 11;
    public static long ADVB_OFF = 12;
    public static long ADVB_IN = 13;
    public static long ADVB_OUT = 14;
    public static long ADVB_FROM = 15;
    public static long ADVB_AND = 16;
    public static long ADVB_THE = 17;
    public static long ADVB_TO = 18;
    public static long ADVB_WITH = 19;
    public static long ADVB_AT = 20;
    public static long ADVB_UNDER = 21;

    public static long MSG_VERSION = 1;
    public static long MSG_CARRYINGTOOMANYITEMS = 2;
    public static long MSG_CARRYINGTOOMUCHWEIGHT = 3;
    public static long MSG_CANTSEEITEMHERE = 4;
    public static long MSG_VERBNEEDSNOUN = 5;
    public static long MSG_TAKEN = 6;
    public static long MSG_INVENTORY = 7;
    public static long MSG_NOTHING = 8;
    public static long MSG_WHEREWANTTOGO = 9;
    public static long MSG_CANTGOTHATWAY = 10;
    public static long MSG_DROPPED = 11;
    public static long MSG_NOTCARRYINGTHAT = 12;
    public static long MSG_DARKLOCATION = 13;
    public static long MSG_CANTVERBTHAT = 14;
    public static long MSG_WORN = 15;
    public static long MSG_MUSTSUPPLYVERB = 16;
    public static long MSG_DONTUNDERSTAND = 17;
    public static long MSG_WHATDOYOUWANTTOPUTINTO = 18;
    public static long MSG_DONE = 19;
    public static long MSG_DOESNTFIT = 20;
    public static long MSG_CANTPUTOBJECTINSIDEITSELF = 21;
    public static long MSG_WHATDOYOUWANTTOREMOVEFROM = 22;
    public static long MSG_TRAP_SWIM = 23;
    public static long MSG_TRAP_FLY = 24;
    public static long MSG_FORWARDSLASH = 25;
    public static long MSG_YOUHAVESCORED = 26;
    public static long MSG_OUTOFAPOSSIBLE = 27;
    public static long MSG_TURNS = 28;
    public static long MSG_SCOREBUILDBUFFER = 29;
    public static long MSG_TRAP_YES = 30;
    public static long MSG_TRAP_NO = 31;
    public static long MSG_TRAP_HELP = 32;
    public static long MSG_TRAP_EXAMINE_MYSELF = 33;
    public static long MSG_PLAYERENTEREDTHEGAME = 34;
    public static long MSG_PLAYERXISNOWKNOWNAS = 35;
    public static long MSG_INVALIDALIAS = 36;
    public static long MSG_VERBOSE_ON = 37;
    public static long MSG_VERBOSE_OFF = 38;
    public static long MSG_WORDNOTUNDERSTOOD = 39;
    public static long MSG_DARK = 40;
    public static long MSG_EXITSLEAD = 41;
    public static long MSG_NORTH = 42;
    public static long MSG_SOUTH = 43;
    public static long MSG_EAST = 44;
    public static long MSG_WEST = 45;
    public static long MSG_UP = 46;
    public static long MSG_DOWN = 47;
    public static long MSG_NORTHEAST = 48;
    public static long MSG_NORTHWEST = 49;
    public static long MSG_SOUTHEAST = 50;
    public static long MSG_SOUTHWEST = 51;
    public static long MSG_NOWHERE = 52;
    public static long MSG_AND = 53;
    public static long MSG_THEREIS = 54;
    public static long MSG_HERE = 55;
    public static long MSG_MODLIT = 56;
    public static long MSG_ISHERE = 57;
    public static long MSG_FOLLOWS = 58;
    public static long MSG_ENTERS = 59;
    public static long MSG_THEXCONTAINS = 60;
    public static long MSG_GOES = 61;
    public static long MSG_THATSNOTAWEAPON = 62;
    public static long MSG_PLAYERATTACKSANDMISSES = 63;
    public static long MSG_PLAYERATTACKSXFORXPOINTSOFDAMAGE = 64;
    public static long MSG_PLAYERISDEAD = 65;
    public static long MSG_PLAYERDROPSTHEIROBJECTS = 66;
    public static long MSG_PLAYERAPPEARS = 67;
    public static long MSG_PLAYERQUIT = 68;
    public static long MSG_YOUHAVEBEENKILLED = 69;
    public static long MSG_YOUNOWHAVEPLAYER = 70;
    public static long MSG_OPENED = 71;
    public static long MSG_ITSALREADYOPEN = 72;
    public static long MSG_CLOSED = 73;
    public static long MSG_ITSALREADYCLOSED = 74;
    public static long MSG_THEXISOPEN = 75;
    public static long MSG_THEXISCLOSED = 76;
    public static long MSG_TAKES = 77;
    public static long MSG_MODWORN = 78;
    public static long MSG_MODOPEN = 79;
    public static long MSG_MODCLOSED = 80;
    public static long MSG_CANTPUTTHINGSINX = 81;
    public static long MSG_CANTPUTTHINGSONX = 82;
    public static long MSG_BADPUTSYNTAX = 83;
    public static long MSG_ONTHEXIS = 84;
    public static long MSG_YOUNOWLAIDONTHEX = 85;
    public static long MSG_XLAYSONTHEX = 86;
    public static long MSG_YOUNOWSATONTHEX = 87;
    public static long MSG_XNOWSATONTHEX = 88;
    public static long MSG_YOUNOWSTOODONTHEX = 89;
    public static long MSG_XSTANDSONTHEX = 90;
    public static long MSG_XSTANDSUP = 91;
    public static long MSG_YOUSTANDUP = 92;
    public static long MSG_YOUCANTXONTHAT = 93;
    public static long MSG_SATONTHEX = 94;
    public static long MSG_STOODONTHEX = 95;
    public static long MSG_LAIDONTHEX = 96;
    public static long MSG_YOUHAVEBEENHITFORXPOINTSBYX = 97;
    public static long MSG_STATUS = 98;
    public static long MSG_YOUHAVEMONEY = 99;
    public static long MSG_WEAPONDAMAGE = 100;
    public static long MSG_HMTASTY = 101;
}