package iageserver;

/**
 * Item class. Contains information about one IAGE item.
 */
public class item {

  /** Item's ID */
  public long ID = 0;
  /** Item's display name. Note that you should use the singular or plural 
    * within the name - if the item is a box of matches, then your name should
    * be "a box of matches". If your item is "some matches" then your name should
    * also be "some matches".
    */
  public String Name = "";
  /** Item's current location. See location class for more information. */
  public long CurrentLocation = 0;
  /** Item's relative weight in user-defined scale. */
  public long Weight = 0;
  /** Item's relative size */
  public long Size = 0;
  /** Initial description of item before it is moved.*/
  public String Description = "";
  /** ID of noun that refers to item */
  public long NounID = 0;
  /** Determines if item is lightsource and can light a location.*/
  public boolean IsLightSource = false;
  /** Determines if item is giving out light.*/
  public boolean IsLit = false;
  /** Determines if the item is being worn by a player */
  public boolean IsWorn = false;
  /** Determines if the item can contain other items.
    * NB: IAGE allows unlimited levels of item nesting
    */
  public boolean IsContainer = false;
  public boolean IsReadable = false;
  public String ReadableText = "";
  public boolean IsEdible = false;
  public long EdibleHitPoints = 0;
  public boolean IsWearable = false;
  /** Set if the item is a weapon */
  public boolean IsWeapon = false;
  /** Set if the item has a surface, which other objects can be put on */
  public boolean HasSurface = false;
  /** Determines if the object can be open or closed */
  public boolean CanOpenClose = false;
  /** Object's open/closed state */
  public boolean OpenCloseState = false;
  /** Weight contained by item (system maintained for containers) */
  public long ContainedWeight = 0;
  /** Size contained by item (system maintained for containers) */
  public long ContainedSize = 0;
  /** Maximum amount of damage the weapon can do */
  public long DamageIndicator = 0;
  /** Set if object can be laid on */
  public boolean CanBeLaidOn = false;
  /** Set if object can be stood on */
  public boolean CanBeStoodOn = false;
  /** Set if object can be sat on */
  public boolean CanBeSatOn = false;
  /** Set if object can be got in */
  public boolean CanBeGotIn = false;
  /** Default message when item is examined */
  public String DefaultExamine = "";
  /** Determines if the item is invisible (not displayed to the player) */
  public boolean Invisible = false;
  /** Determines if the item is transparent */
  public boolean Transparent = false;
  /** Determines if the item is fixed to it's current location */
  public boolean IsFixed = false;
  /** Default message if a player attempts to take a fixed item. You could
    * also write your own trap with the OnGet event 
    */
  public String FixedMessage = "";
  /** Determines if the item is a subitem (a component of another item and therefore
    * moves with it).
    */
  public boolean IsSubItem = false;
  /** Item that this item is a subitem of */
  public long SubItemOf = 0;
  /** Custom properties for this item. Custom properties are used to tie flags and objects together. */
  public String CustomProperties = "";
  /** User booleans. Allows custom yes/no questions about an object */
  public String UserBooleans = "";
  /** Name value pairs */
  public iagecollection NameValues = new iagecollection();
  /** Determines if the item has been moved from where it started */
  public boolean MovedFromOriginalLocation = false;
  /** Code collection, fires when the item is referenced.*/
  public iagecode OnAction = new iagecode();
  
	/*** Moves all items in the location specifed to the second location specified */
	public static void MoveAll(long MoveFrom, long MoveTo) {

		int i = 1;
		item im = null;
		
		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.CurrentLocation == MoveFrom) {
				im.CurrentLocation = MoveTo;	
			}
			i++;	
		}
	}
	
	/*** Returns an item object from an item ID */
	public static item getitemfromid(long IID) {
		
		int i = 1;
		item im = null;
		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.ID == IID) {
				return im;
			}	
			i++;
		}
		return null;
	}
	
	/*** returns a string of modifiers for the given item. Modifiers are text strings
	   * which provide helpful info about the state of an item. */
	public static String getModifiers(item im) {

		String IName = "";		
	    // Lit
        if (im.IsLit) {IName = IName + " " + message.getMessage(constant.MSG_MODLIT);}
        // Worn
        if (im.IsWorn) {IName = IName + " " + message.getMessage(constant.MSG_MODWORN);}
        // Open
        if (im.CanOpenClose && im.OpenCloseState) {IName = IName + " " + message.getMessage(constant.MSG_MODOPEN);}
        // Closed
        if (im.CanOpenClose && !im.OpenCloseState) {IName = IName + " " + message.getMessage(constant.MSG_MODCLOSED);}
        // Weapon
        if (im.IsWeapon && data.ogame.UsingIAGECombat) {IName = IName + " " + processor.smake(message.getMessage(constant.MSG_WEAPONDAMAGE), Long.toString(im.DamageIndicator));}
		
		return IName;
	}
	
  	public String getNameValue(String valname) {
	
		 // Find value of this name
		 int ic = 1;
		 namevaluepair nv = null;
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	// Found it - return the value
		 	 	return nv.Value;
		 	 }
		     ic++;	 	
		 }	
		 return "0";
	}
	
	public void setNameValue(String valname, String newval) {
	
		// Hunt through to see if we already have a value with
		// this name:
		 int ic = 1;
		 namevaluepair nv = null;
		 
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	
		 	 	// We have one, replace the value
		 	 	nv.Value = newval;
		 	 	return;
		 	 }
		     ic++;	 	
		 }
		 
	 	// Add it
	 	nv = new namevaluepair();
	 	nv.Name = valname;
	 	nv.Value = newval;
	 	this.NameValues.add(nv);
		
	}
	
	
}
