package iageserver;

/**
 * Player class - holds information about an IAGE human player.
 */
public class player {

	/** Player's selected alias. */
	public String Name = "";
	/** Display name */
	public String DisplayName = "";
	/** Player score.*/
	public long Score = 0;
	/** Player turns taken */
	public long Turns = 0;
	/** Player current location */
	public long CurrentLocation = 0;
	/** Player IP Address */
	public String IPAddress = "";
	/** Player unique index */
	public int Index = 0;
	/** Player's current state */
	public byte State = player.ST_NORMAL;
	/** Object item player's state is affecting (lying, sitting or stood on) */
	public item StateItem = null;
	/** Total weight carried by this player. */
	public long WeightCarried = 0;
	/** Total number of items carried by this player */
	public long ItemsCarried = 0;
	/** Total size of items carried by this player */
	public long SizeCarried = 0;
	/** Last noun ID player used (used for "it" in parser). */
	public long LastNoun = 0;
	public String LastNounText = "";
	/** Player can see? Not in dark location with no lightsource? */
	public boolean CanSee = true;
	/** Last input from player (used for "again" in parser). */
	public String LastCommand = "";
	/** Combined list of location IDs this player has visited. */
	public iagecollection LocationsSeen = new iagecollection();
	/** Whether room descriptions should be repeated to this player for locations the have already visited */
	public boolean VerboseMode = true;
	/** Flag used to determine whether the player has been transmitted something recently */
	public boolean OutputToPlayer = false;
	/** Number of hit points the player has */
	public long HitPoints = 0;
	/** Maximum number of hit points player can take without a weapon */
	public long DamageIndicator = 0;
	/** Money carried by the player */
	public long Money = 0;
	/** Chance of hitting a target in an attack expressed as a percentage */
	public long ChanceOfHitting = 60;
	/** Name value pairs */
  	public iagecollection NameValues = new iagecollection();
	/** Custom player properties - can be persisted */
	public String CP1 = "";
	public String CP2 = "";
	public String CP3 = "";
	public String CP4 = "";
	public String CP5 = "";
	public String CP6 = "";
	public String CP7 = "";
	public String CP8 = "";
	public String CP9 = "";
	public String CP10 = "";
	public String CP11 = "";
	public String CP12 = "";
	public String CP13 = "";
	public String CP14 = "";
	public String CP15 = "";
	public String CP16 = "";
	public String CP17 = "";
	public String CP18 = "";
	public String CP19 = "";
	public String CP20 = "";
	public String CP21 = "";
	public String CP22 = "";
	public String CP23 = "";
	public String CP24 = "";
	public String CP25 = "";
	public String CP26 = "";
	public String CP27 = "";
	public String CP28 = "";
	public String CP29 = "";
	public String CP30 = "";
	
	/*** Variables used by ask command */
	public int AskProgramCounter = 0;
	public String UserResponseToAsk = "";
	public boolean WaitingForAskResponse = false;
	public iagecode AskCode = null;
	public String AskCodeSource = "";
	public interpreter AskInterpreter = null;
	
	/*** Variables used by parser questions to player */
	public boolean LastParserAskedQuestion = false;
	public parsestring LastParser = null;
	/*** Number of noun to be replaced when answering question -
	     1, 2 or 3 */
	public int LastQReplacesNoun = 0;
	
	/*** Constants for player states */
	public static byte ST_NORMAL = 1;
	public static byte ST_SITTING = 2;
	public static byte ST_LYING = 3;
	public static byte ST_STOODON = 4;
	public static byte ST_INSIDE = 5;
	
	/**
	 *  Whether we are operating in text only mode.
	 */
	public boolean TextOnly = false;
	
	public void quit(boolean doitquietly) {
		
		// Run the game.onquit code
		interpreter ti = new interpreter(this, null);
		ti.runcode(data.ogame.OnQuit, "Game.OnQuit");
		
		// Inform the other players if this player had a name
		// other than the default name held in data.defaultplayername.
		if (!doitquietly) vdu.TransmitAll(processor.smake(message.getMessage(constant.MSG_PLAYERQUIT), Name));
		
		// Output to the server console that the connection has been freed.
		vdu.println("Connection " + Integer.toString(this.Index) + " - " + this.Name + " (" + this.IPAddress + ") has quit.");
		
		// Tell the player's client that it should stop it right now
		vdu.Transmit("QUIT: DIE|", this);
		
		// Make this player drop all the objects they were carrying into
		// the location they were last in.
		item.MoveAll(Index + location.PLAYERBASE, CurrentLocation);
		
		// Tell everyone
		if (!doitquietly) vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERDROPSTHEIROBJECTS), Name), this, this.CurrentLocation);
		
		// Remove this player from the players collection.
		int i = 1;
		player p = null;
		while (i <= data.oplayers.getCount()) {
			p = (player) data.oplayers.get(i);
			if (p.Index == this.Index) {
				// Found the player - remove it
				data.oplayers.remove(i);
				break;
			}
			i++;
		}
		
		// Update the console
		vdu.updateconnectionlist();
	}
	
	/*** Marks a location as visited by this player */
	public void MarkLocationAsSeen(long locid) {
		LocationsSeen.add(new Long(locid));
	}
  
	/*** Returns true if this player has seen the passed in location */
	public boolean HasSeenLocation(long locid) {
		int i = 1;
		Long id;
		while (i <= LocationsSeen.getCount()) {
			id = (Long) LocationsSeen.get(i);
			if (id.longValue() == locid) {
				return true;	
			}
			i++;
		}
		return false;
	}
	
	/**
	*  Displays the player's score to them.
	*/
	public void showscore() {
		interpreter ti = new interpreter(this, null);
		ti.runcode(data.ogame.OnScore, "Player(" + Integer.toString(Index) + ").OnScore");
	}

	/**
	 *  Display battle status to player
	 */
	public void showstatus() {
		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_STATUS), Long.toString(this.HitPoints), Long.toString(this.DamageIndicator), Long.toString(this.ChanceOfHitting)), this);
	}

	/** Handles saving of player state */
	public void SaveState(String password, String identifier) {
		vdu.Transmit("You cannot save your position in this single player, text only version of IAGE.", this);
	}
	
	/** Handles restoring of player state */
	public boolean RestoreState(String password, String identifier) {
		vdu.Transmit("You cannot restore positions in this single player, text only version of IAGE.", this);
		return false;
	}
  
  	public String getNameValue(String valname) {
	
		 // Find value of this name
		 int ic = 1;
		 namevaluepair nv = null;
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	// Found it - return the value
		 	 	return nv.Value;
		 	 }
		     ic++;	 	
		 }	
		 return "0";
	}
	
	public void setNameValue(String valname, String newval) {
	
		// Hunt through to see if we already have a value with
		// this name:
		 int ic = 1;
		 namevaluepair nv = null;
		 
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	
		 	 	// We have one, replace the value
		 	 	nv.Value = newval;
		 	 	return;
		 	 }
		     ic++;	 	
		 }
		 
	 	// Add it
	 	nv = new namevaluepair();
	 	nv.Name = valname;
	 	nv.Value = newval;
	 	this.NameValues.add(nv);
		
	}
	
	/*** Marks this player as having been asked a question by the
 	     parser, so it can respond on their next input appropriately */
	public void askParserQuestion(parsestring p, int nounToReplace) {
		this.LastParser = p;
		this.LastQReplacesNoun = nounToReplace;
		this.LastParserAskedQuestion = true;		
	}
  
}
