package iageserver;
import java.io.*;
import java.net.*;

/***
 * Handles listening out for admin connections
 * and allowing remote access
 **/
 
 public class AdminListen extends Thread {
 
 	// Server socket used for admin requests
 	ServerSocket SS = null;
 	
 	// The parent server object, used for commanding the server
 	Server parent = null;
 	
 	// The IP port to listen for admin requests on
 	final int adminport = 1118;
 	
 	// Determines whether we are listening
 	// for connections.
 	boolean isListening = true;
 	
 	public AdminListen(Server tp) {
 		parent = tp;
 		// Start running in a new thread on
 		// instantiation
 		this.start();
 	}
 	
 	public void run() {
		try {
		  SS = new ServerSocket(adminport);
		} 
		catch (Exception e) {
		  vdu.println("Could not initialise admin server on port: " + adminport);
		  return;
		}
		
		while (isListening) {
			try {
			  new AdminListenThread(SS.accept(), parent).start();
			  this.yield();
			}
			catch(IOException e) {
				// Do nothing - always generates an error when socket closed
				// because SS.accept blocks until connection received.
			}
		}
		
		try {
			SS.close();
		}
		catch(IOException e) {
			vdu.println("Error closing admin server socket - " + e.getMessage());
		}
	}

	/** Stops the object listening */
	public void killThread() {
    
		isListening = false;
		
		try {
			SS.close();   	
		}
		catch(Exception e) {
			e.printStackTrace();
			vdu.println("Unable to close admin server socket: " + e.getMessage());	
		}
	}
 	
 	
}