package iageserver;

import java.io.*;
import java.net.*;

	/***
	 * Actually services admin commands and
	 * connections.
	 */

public class AdminListenThread extends Thread {
	
	/** Determines if we are listening for client input on the socket. */
	private boolean isFinished = false;
	
	/** Determines if we are waiting for a password from the client */
	private boolean isAuthenticated = false;
	
	/** IP socket and streams. */
	private Socket thesocket = null;
	private PrintWriter out = null;
	private DataInputStream in = null;
	private Server parent = null;
	
	/** Creates a new thread on the passed client socket. */
	public AdminListenThread(Socket socket, Server tp) {

		thesocket = socket;
		parent = tp;
		
		vdu.println("Received admin connection from " + thesocket.getInetAddress().getHostAddress() + ":" + Integer.toString(thesocket.getLocalPort()) + ")");
		
		// Create streams on socket
		try {
			out = new PrintWriter(thesocket.getOutputStream(), true);
			in = new DataInputStream(thesocket.getInputStream());
		}      
		catch(IOException e) {
			vdu.println("Error creating socket streams: " + e.getMessage());
			e.printStackTrace();
			return;
		}
		
		// Send acknowledgement and request authorisation
		transmit(data.internalversion + "\n\nPlease enter your password to continue:");
	}

	/** Main routine. Listens for client input and responds. */
	public void run() {

		byte[] ba = new byte[1024];
		String inbuffer;
		int i;
		
		try {
		
		  while ( !isFinished ) {
		
		    i = in.read(ba);
		
		    if (i > 0) {
		
		      inbuffer = new String(ba);
		      inbuffer = inbuffer.substring(0, i);
		
		      if (inbuffer.length() > 0) {
		        // Act on it
		        process(inbuffer);
		      }
		    }
		    try {
		    	this.sleep(100);
		    }
		    catch (InterruptedException e) {}
		  }
		
		} 
		catch (IOException e) {
		    e.printStackTrace();
		}
		finally {
			try {
		  		in.close();
		  		out.close();
		  		thesocket.close();	
		  	}
		  	catch (Exception e) {}
		}
  	}		
  	
  	/** Kills off this thread */
  	public void killThread() {
  		isFinished = true;
  	}
  	
  	
  	/** Processes client admin input */
  	public void process(String s) {
  		
  		// If we haven't given a password yet,
  		// assume this is one and check it
  		if (!isAuthenticated) {
  			
  			if (s.trim().equals(parent.spassword)) {
  				isAuthenticated = true;
  				transmit("Authentication sucessful.\nList - shows all players on server\nKill <player index> - kills a player's connection\nLoad <filename> - Loads a new game\nStart - Starts the server running\nStop - Stops the current server running\nExit - Ends this session");
  			}
  			else
  			{
  				// Tell them it's bad
  				transmit("Bad password.");
  				return;	
  			}
  		}
  		
  		
  		// LIST command
  		if (s.trim().toLowerCase().startsWith("list")) {
  			// Output list of players on the server to admin with
  			// their indexes, which they can be killed by
			String PBanner = "";
			String tonly = "";
			int i = 1;
			player p = null;
			interpreter banint = null;
			while (i <= data.oplayers.getCount()) {
				p = (player) data.oplayers.get(i);
				// Get the player's banner
				banint = new interpreter(p, new parsestring("x", p, "|"));
				banint.runcode(data.ogame.OnDisplayBanner, "Game.OnDisplayBanner");
				PBanner = banint.returnvalue;
				tonly = tonly + Integer.toString(p.Index) + ": " + p.Name + " (" + p.IPAddress + ":" + Integer.toString(p.Index) + ") (" + PBanner + ")\n";
				i++;
			}
			
			if (tonly.equals("")) {
				tonly = "There are no players currently on the server.\n";
			}
			
			transmit(tonly);
  		}
  		
  		// START command
  		if (s.trim().toLowerCase().startsWith("start")) {
	  		if (parent.serverisrunning) {
	  			transmit("A server is already running.");
  			}
  			else
  			{
  				// Start that server
  				parent.startServer();	
  				transmit("Server started.");
  			}
  		}
  		
  		// STOP command
  		// START command
  		if (s.trim().toLowerCase().startsWith("stop")) {
	  		if (!parent.serverisrunning) {
	  			transmit("No server is currently running.");
  			}
  			else
  			{
  				// Stop that server
  				parent.stopServer();	
  				transmit("Server stopped.");
  			}
  		}
  		
  		// KILL <player index> command
  		if (s.trim().toLowerCase().startsWith("kill")) {
  			int sp = s.indexOf(" ");
  			if (sp == -1) {
  				transmit("Usage: kill <playerindex>");
  			}
  			else
  			{
  				int index = Integer.parseInt(s.substring(sp + 1, s.length()));
  				int i = 1;
  				player tp = null;
  				while (i <= data.oplayers.getCount()) {
  					tp = (player) data.oplayers.get(i);
  					if (tp.Index == index) {
  						tp.quit(true);
  						transmit("Player " + Integer.toString(index) + " killed.");
  						break;
  					}
  					i++;	
  				}
  			}
  		}
  		
  		// LOAD <filename> command
  		if (s.trim().toLowerCase().startsWith("load")) {
  			int sp = s.indexOf(" ");
  			if (sp == -1) {
  				transmit("Usage: load <filename>");
  			}
  			else
  			{
  				// Make sure there isn't a server already running
  				if (parent.serverisrunning) {
  					transmit("A server is currently running - you must stop it first.");
  				}
  				else
  				{
  					// Load that file. Assume it is in
  					// the same directory as the server.			
  					parent.loadGameFile(s.substring(sp + 1, s.length()));
  					if (data.canstartenginenow) {
  						transmit("Game file " + s.substring(sp + 1, s.length()) + " successfully loaded.");
  					}
  					else
  					{
  						transmit("An error occurred and game file " + s.substring(sp + 1, s.length()) + " was not loaded -- " + data.lasterror);
  					}
  				}
  			}
  		}
  				
  		
  		// EXIT command
  		if (s.trim().toLowerCase().startsWith("exit")) {
  			// close the session
  			isFinished = true;
  		}
  		
  	}
  	
  	/** Transmits the text to this socket */
  	public void transmit(String s) {
  		out.write(s);
  		out.flush();
  	}
  	
}