package iageserver;

/**
 * Parser class, used for deconstructing user input and
 * dictionary matching. Also holds IAGE internal code and
 * facilities for noun referencing.
 */
public class parsestring {
	
	private player thisplayer = null;
	public String originalstring = "";
	public boolean isnpcaddress = false;
	public long npcarrayaddressid = 0;
	
	/*** Contains the list of broken words */
	public iagecollection vwords = new iagecollection();
	
	public long Verb = 0;
	public String SVerb = "";
	public long Verb2 = 0;
	public String SVerb2 = "";
	public long Verb3 = 0;
	public String SVerb3 = "";
	
	public long Adverb = 0;
	public String SAdverb = "";
	public long Adverb2 = 0;
	public String SAdverb2 = "";
	public long Adverb3 = 0;
	public String SAdverb3 = "";
	
	public long Noun = 0;
	public String SNoun = "";
	public long Noun2 = 0;
	public String SNoun2 = "";
	public long Noun3 = 0;
	public String SNoun3 = "";
	
	/**
     *  Constructor - creates a new parser object from the text
     *  and player specified. The string is immediately broken up
     *  into a group of words according to the separator char supplied.
     */
	public parsestring(String s, player tp, String sepchar) {
		
		thisplayer = tp;
		originalstring = s;
		
		// Break by spaces and fill vwords
		int i = 0;
		int spos = 0;
		i = s.indexOf(sepchar);
		while (i != -1) {
			// Add the word
			vwords.add(s.substring(spos, i));
			spos = i + 1;
			i = s.indexOf(sepchar, spos);
		}
		// Add the final word
		vwords.add(s.substring(spos, s.length()));
		
	}
	
	/**
     *  Checks parsed words against dictionary and builds a list
	 *	of matches. Any misunderstood words are spat back as an error
	 *	to the player.
     */
	public boolean scanformatches() {
		
		int i = 1;
		int x = 1;
		int z = 1;
		String curword = "";
		verb cv = null;
		noun cn = null;
		adverb ca = null;
		character cc = null;
		player cp = null;
		boolean foundmatch = false;	
		
		if (originalstring.equals(" ")) {return false;}
		
		// Enumerate each word.
		while (i <= vwords.getCount()) {
			
			// Get the current word in a string
			curword = (String) vwords.get(i);
			
			// Remove commas and question marks if they are on the end
			if (curword.endsWith("?") || curword.endsWith(",")) {
				curword = curword.substring(0, curword.length() - 1);	
			}
			
			// Set match indicator
			foundmatch = false;
			
			// Scan the verbs now
			if (! foundmatch) {
				z = 1;
				while (z <= data.overbs.getCount()) {
					// get the verb
					cv = (verb) data.overbs.get(z);
					// compare the current verb and our word
					if (curword.toLowerCase().equals(cv.Text.toLowerCase())) {
						// we have a match!
						foundmatch = true;
						// This bit of logic determines whether it is the
						// first, second or third verb we've seen (by looking
						// at the public member variables Verb, Verb2 and Verb3.
						if (Verb != 0) {
							if (Verb2 != 0) {
								Verb3 = cv.ID;
								SVerb3 = cv.Text;
							}	
							else
							{
								Verb2 = cv.ID;
								SVerb2 = cv.Text;	
							}
						}
						else
						{
							Verb = cv.ID;
							SVerb = cv.Text;	
						}
						break;
					}
					z++;	
				}
			}
			
			// Let's scan the nouns now
			if (! foundmatch) {
				z = 1;
				while (z <= data.onouns.getCount()) {
					// get the noun
					cn = (noun) data.onouns.get(z);
					// compare the current noun and our word
					if (curword.toLowerCase().equals(cn.Text.toLowerCase())) {
						
						// If this is the first word, we are going to do a special check
	                    // to see if this noun is an NPC noun - if it is, we set the flag
	                    // to state for internal code later on that it is a talk to NPC
	                    // type command.
	                    
	                    if (i == 1) {
	                    	x = 1;
	                    	while (x <= data.ocharacters.getCount()) {
	                      		cc = (character) data.ocharacters.get(x);                      
	                      		if (cc.NounID == cn.ID) {
	                                isnpcaddress = true;
	                                npcarrayaddressid = x;
	                                break;
	                        	}
	                        x++;
	                    	}
	                	}
	                    
	                    // If this noun is the second one, check to see if it
	                    // *could* be evaluated to the same ID as the first one.
	                    // If it could, we should just ignore it, but flag it as
	                    // a found match, since it can be safely discarded.
	                    if ((Noun != 0) && (Noun2 == 0)) {
	                    	noun tn = null;
	                    	x = 1;
	                    	while (x <= data.onouns.getCount()) {
	                    		tn = (noun) data.onouns.get(x);
	                    		if (tn.Text.toLowerCase().equals(curword.toLowerCase()) && tn.ID == Noun) {
	                    			// It can! mark us as finding a match
	                    			foundmatch = true;                    			
	                    		}
	                    		x++;
	                    	}	
	                    }
	                    
	                    // If this noun is the third one, check to see if it
	                    // *could* be evaluated to the same ID as the second one.
	                    // If it could, we should just ignore it, but flag it as
	                    // a found match, since it can be safely discarded.
	                    if ((Noun2 != 0) && (Noun3 == 0)) {
	                    	noun tn = null;
	                    	x = 1;
	                    	while (x <= data.onouns.getCount()) {
	                    		tn = (noun) data.onouns.get(x);
	                    		if (tn.Text.toLowerCase().equals(curword.toLowerCase()) && tn.ID == Noun2) {
	                    			// It can! mark us as finding a match
	                    			foundmatch = true;                    			
	                    		}
	                    		x++;
	                    	}	
	                    }
	                    
	                    // This noun is not an extension of one, so
	                    // store it.
	                    if (!foundmatch) {
	                    
		                    // we have a match!
							foundmatch = true;
		                    
							// This bit of logic determines whether it is the
							// first, second or third noun we've seen (by looking
							// at the public member variables noun, noun2 and noun3.
							if (Noun != 0) {
								if (Noun2 != 0) {
									Noun3 = cn.ID;
									SNoun3 = cn.Text;
								}	
								else
								{
									Noun2 = cn.ID;
									SNoun2 = cn.Text;	
								}
							}
							else
							{
								Noun = cn.ID;
								SNoun = cn.Text;
								
							}
							break;
						}
					}
					z++;	
				}
			}
			
			// Scan the adverbs now
			if (! foundmatch) {
				z = 1;
				while (z <= data.oadverbs.getCount()) {
					// get the adverb
					ca = (adverb) data.oadverbs.get(z);
					// compare the current adverb and our word
					if (curword.toLowerCase().equals(ca.Text.toLowerCase())) {
						// we have a match!
						foundmatch = true;
						// This bit of logic determines whether it is the
						// first, second or third adverb we've seen (by looking
						// at the public member variables adverb, adverb2 and adverb3.
						if (Adverb != 0) {
							if (Adverb2 != 0) {
								Adverb3 = ca.ID;
								SAdverb3 = ca.Text;
							}	
							else
							{
								Adverb2 = ca.ID;
								SAdverb2 = ca.Text;	
							}
						}
						else
						{
							Adverb = ca.ID;
							SAdverb = ca.Text;	
						}
						break;
					}
					z++;	
				}			
			}
			
		    // Determine if the word could be one of our "special"
	        // nouns. These represent game players and are treated
	        // as noun.PLAYERNOUNBASE (1000000) + player index. Game coders can then use
	        // noun - 1000000 with player collection.
	        
	        if (! foundmatch) {
				z = 1;
				while (z <= data.oplayers.getCount()) {
					// get the player
					cp = (player) data.oplayers.get(z);
					// compare the player name and our word
					if (curword.toLowerCase().equals(cp.Name.toLowerCase())) {
						// we have a match!
						foundmatch = true;
						// This bit of logic determines whether it is the
						// first, second or third player we've seen (by looking
						// at the public member variables noun, noun2 and noun3
						if (Noun != 0) {
							if (Noun2 != 0) {
								Noun3 = cp.Index + noun.PLAYERNOUNBASE;
								SNoun3 = cp.Name;
							}	
							else
							{
								Noun2 = cp.Index + noun.PLAYERNOUNBASE;
								SNoun2 = cp.Name;	
							}
						}
						else
						{
							Noun = cp.Index + noun.PLAYERNOUNBASE;
							SNoun = cp.Name;	
						}
						break;
					}
					z++;	
				}
			}
			
			// We have an error if no matches are still found.
			if (! foundmatch) {
				vdu.Transmit(processor.smake(message.getMessage(constant.MSG_WORDNOTUNDERSTOOD), curword), thisplayer);
				return false;
			}
			i ++;
		}
		
        // Determine if our primary noun is the special
        // "it" noun. If it is, substitute it for
        // the last noun we saw for this player
        if (Noun == constant.NOUN_IT) {
        	// If we don't have a noun for IT, give an error
        	if (thisplayer.LastNoun == 0) {
        		vdu.Transmit("(There is no \"it\" noun)", thisplayer);
        		return false;
        	}
            Noun = thisplayer.LastNoun;
            SNoun = thisplayer.LastNounText;
            
			item im = null;
			i = 1;
			while (i <= data.oitems.getCount()) {
				im = (item) data.oitems.get(i);	
				// Only use the item name if it's noun matches
				// AND it is available.
				if (im.NounID == thisplayer.LastNoun && isnounitemavailable(im.ID)) {
					break;
				}
				else
				{
					// Reset the item back to null so when we drop out
					// we can just use the noun text instead because
					// this item was not valid
					im = null;
				}
				i++;
			}
			
			String outname = "";
			if (im != null) outname = im.Name;
			if (outname.equals("")) outname = thisplayer.LastNounText;
			thisplayer.OutputToPlayer = false;
			vdu.Transmit("(" + outname + ")", thisplayer);
        }
        else
        {
            // Otherwise, store this noun as the last one if it is not 0
            if (Noun != 0) {
	            thisplayer.LastNoun = Noun;
	            thisplayer.LastNounText = SNoun;
	        }
    	}
    	// Substitute other nouns
    	if (Noun2 == constant.NOUN_IT) {
    		// If we don't have a noun for IT, give an error
        	if (thisplayer.LastNoun == 0) {
        		vdu.Transmit("(There is no \"it\" noun)", thisplayer);
        		return false;
        	}
			Noun2 = thisplayer.LastNoun;
			SNoun2= thisplayer.LastNounText;

			item im = null;
			i = 1;
			while (i <= data.oitems.getCount()) {
				im = (item) data.oitems.get(i);	
				// Only use the item name if it's noun matches
				// AND it is available.
				if (im.NounID == thisplayer.LastNoun && isnounitemavailable(im.ID)) {
					break;
				}
				else
				{
					// Reset the item back to null so when we drop out
					// we can just use the noun text instead because
					// this item was not valid
					im = null;
				}
				i++;
			}
			
			String outname = "";
			if (im != null) outname = im.Name;
			if (outname.equals("")) outname = thisplayer.LastNounText;
			if (!thisplayer.OutputToPlayer) vdu.Transmit("(" + outname + ")", thisplayer);
        }
        if (Noun3 == constant.NOUN_IT) {
        	// If we don't have a noun for IT, give an error
        	if (thisplayer.LastNoun == 0) {
        		vdu.Transmit("(There is no \"it\" noun)", thisplayer);
        		return false;
        	}
			Noun3 = thisplayer.LastNoun;
			SNoun3= thisplayer.LastNounText;
			
			item im = null;
			i = 1;
			while (i <= data.oitems.getCount()) {
				im = (item) data.oitems.get(i);	
				// Only use the item name if it's noun matches
				// AND it is available.
				if (im.NounID == thisplayer.LastNoun && isnounitemavailable(im.ID)) {
					break;
				}
				else
				{
					// Reset the item back to null so when we drop out
					// we can just use the noun text instead because
					// this item was not valid
					im = null;
				}
				i++;
			}
			
			String outname = "";
			if (im != null) outname = im.Name;
			if (outname.equals("")) outname = thisplayer.LastNounText;
			if (!thisplayer.OutputToPlayer) vdu.Transmit("(" + outname + ")", thisplayer);
        }
		
		// Successful if we got here.
		thisplayer.OutputToPlayer = false;
		return true;
	}
	
	/**
     *  Makes sure that no nouns entered refer to objects not:
     *
     *  a) in the current location
     *  b) carried by the current player
     *  c) carried by another player in the same location
     *  d) contained by or on another object in the current location
     *  e) contained by or on another object the player is carrying
     *  f) a subitem of an item in the location
     *  g) a subitem of an item the player is carrying
     *  h) an NPC who is not in the location
     *  i) another player who is not in the location
     *  It also clarifies if a noun is used which could
     *  refer to two or more objects, as well as selecting the
     *  right one in given circumstances.
     */
	public boolean checknouns() {
	
		int i = 1;
		int z = 1;
		byte nono = 1;
		String errstring = "";
		byte noavail = 0;
		String nountext = "";
		Long ol = null;
		item ci = null;
		Boolean ob = null;
		noun n = null;
		iagecollection foundnouns = new iagecollection();
		iagecollection nounitemsavailable = new iagecollection();
		long nounid = 0;
    
    	// It is quite possible for this routine to be called
    	// without any nouns being entered at all!
    	// Check for no nouns.
    	if (Noun == 0 && Noun2 == 0 && Noun3 == 0) return true;
    	
    	
    	// This is a rather special lump of code - if this is an npc address
    	// then, make sure the NPC is valid, but that's it
    	if (this.isnpcaddress) {
    		if (isnounitemavailable(Noun)) {
    			// The NPC is available.
    			return true;	
    		}
    		else
    		{
    			// Tell the user you can't see that NPC
    			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTSEEITEMHERE), SNoun) , thisplayer);
    			return false;
    		}
    	}
    	
    
    	while (nono <= 3) {
    	
    		if (nono == 1) {nountext = SNoun; nounid = Noun;}
    		
    		
    		// If we are overriding secondary noun checks on certain verbs,
    		// check if we have one of those verbs and drop out if we do.
    		if (nono == 2) {
    			if (!data.ogame.OverrideSecondaryNouns.equals("")) {
    				String sverbid = Long.toString(this.Verb);
    				parsestring brkvrb = new parsestring(data.ogame.OverrideSecondaryNouns, thisplayer, " ");
    				int bi = 1;
    				while (bi <= brkvrb.vwords.getCount()) {
    					if (sverbid.equalsIgnoreCase((String) brkvrb.vwords.get(bi))) {
    						// We have a match - we can safely drop out
    						return true;
    					}	
    					bi++;
    				}
    			}
    		}
    		
    		if (nono == 2) {nountext = SNoun2; nounid = Noun2;}
    		if (nono == 3) {nountext = SNoun3; nounid = Noun3;}
    		
    		// If we have a blank noun, then we have run out of nouns
    		// so everything must be ok.
    		if (nountext.equals("")) return true;
    		
    		// See how many nouns the text of each noun could equate to
    		foundnouns = new iagecollection();
    		nounitemsavailable = new iagecollection();
    		
    		i = 1;
    		while (i <= data.onouns.getCount()) {
    		
    			n = (noun) data.onouns.get(i);
    			if (n.Text.toLowerCase().equals(nountext.toLowerCase())) {
    				foundnouns.add(new Long(n.ID));	
    			}
    			i++;	
    		}
    		
    		// Check to see if our noun refers to a player
    		if (nounid > noun.PLAYERNOUNBASE) {
    			foundnouns.add(new Long(nounid));
    		}
    		
    		// Those nouns translate to individual items
    		// so check how many of those items are available
    		noavail = 0;
    		i = 1;
    		while (i <= foundnouns.getCount()) {
    			ol = (Long) foundnouns.get(i);
    			if (isnounitemavailable(ol.longValue())) {
    				// If the item is available, add the tally of
    				// available nouns up
    				noavail++;
    				// remember the id
    				nounid = ol.longValue();
    				// flag the item as available
    				nounitemsavailable.add(new Boolean(true));
    			}
    			else
    			{
    				// flag the item as not available
    				nounitemsavailable.add(new Boolean(false));	
    			}
    			i++;	
    		}
    		
    		if (foundnouns.getCount() > 0 && noavail > 1) {
    			
	            // We have more than one item and they are available.
	            // Determine actually how many nouns the user has given
	            // us - if it's only one noun then we have to ask.
	            
	            if (Noun != 0 && Noun2 == 0 && Noun3 == 0) {
	            	
	                errstring = "[ Which " + nountext + " do you mean - ";
	                
	                // find the names of them all and make a string
	                z = 1;
	                while (z <= foundnouns.getCount()) {
	 
	                    // Only show items which we could be talking about in this location
	                    ob = (Boolean) nounitemsavailable.get(z);
	                    if (ob.booleanValue() == true) {
	       					i = 1;
	                        while (i <= data.oitems.getCount()) {
	                        	ci = (item) data.oitems.get(i);
	                        	ol = (Long) foundnouns.get(z);
	                        	if (ci.NounID == ol.longValue()) {
	                                if (z > 1) {errstring = errstring + " or ";}
	                                errstring = errstring + "the " + ci.Name.substring(ci.Name.indexOf(" ") + 1, ci.Name.length());
	                                break;
	                        	}
	                        	i++;
	                    	}
	                	}
	                	z++;
	            	}	
	            	
	                errstring = errstring + "? ]";
	                vdu.Transmit(errstring, thisplayer);
	                
	                // Mark the player as having been asked the disambiguation
	                // question by the parser
	                thisplayer.askParserQuestion(this, 1);
	                
	                // Break out with a false (error) value
	                return false;
	            }
	            else
	            {
	                // Otherwise, shuffle the nouns down a place if
	                // this is the first.
	                if (nono == 1) {
	                    Noun = Noun2;
	                    Noun2 = Noun3;
	                    // We found ok
	                    return true;
	             	}
	        	}
    		}
    	
    		if (noavail == 0) {
      			// The item the noun is referring to cannot be seen
      			// so tell the player
           		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTSEEITEMHERE), nountext) , thisplayer);
           		return false;
        	}
        	
        	// Pass the Noun ID back
        	if (nono == 1) {Noun = nounid;}
        	if (nono == 2) {Noun2 = nounid;}
        	if (nono == 3) {Noun3 = nounid;}
        
			nono++;
    	}
	
		// no errors found - return true.
		return true;	
	}
	
	/**
     *  Returns true if the item referred to by the passed in
     *  noun id is available to this player.
     */
	public boolean isnounitemavailable(long nid) {
		int i = 1;
	    int z = 0;
	    item im = null;
	    item zm = null;
	    character c = null;
	    player p = null;
	
		while (i <= data.oitems.getCount()) {
			
			im = (item) data.oitems.get(i);
			if (im.NounID == nid) {
	        
	            // Found a match, check it!
	            
	            // Current Player's Location
	            if (im.CurrentLocation == thisplayer.CurrentLocation) {
	            	return true;
	            }
	            
	            // Carried by current player
	            if (im.CurrentLocation == (location.PLAYERBASE + thisplayer.Index)) {
	            	return true;
	            }
	            
	            // Determine if it is carried by another player and if they
	            // are in the same location.
	            
	            // Not used any more because it would let you take another player's
	            // object with internal code!
	            
	            // Is present in a container in the current location or carried by the player already:
	            z = 1;
	            while (z <= data.oitems.getCount()) {
	            	// Determine if in or on a container
	            	zm = (item) data.oitems.get(z);
	            	if (im.CurrentLocation == location.CONTAINERBASE + zm.ID || im.CurrentLocation == location.SURFACEBASE + zm.ID) {
	                
	                    // It is! See if that container is in the current location
	                    if (zm.CurrentLocation == thisplayer.CurrentLocation || zm.CurrentLocation == (location.PLAYERBASE + thisplayer.Index)) {
							return true;
						}
						else break;
	                 }
	                 z++;
	           }
	                  	            
	            // Is a sub-item of an object the player is carrying or
	            // in the current location
	            im = (item) data.oitems.get(i);
	            if (im.IsSubItem) {
	            	z = 1;
	            	while (z <= data.oitems.getCount()) {
	                	zm = (item) data.oitems.get(z);
	                	if (im.SubItemOf == zm.ID) { 
	                    	if (zm.CurrentLocation == thisplayer.CurrentLocation || zm.CurrentLocation == (location.PLAYERBASE + thisplayer.Index)) {
	                            return true;
	                        }
	                        else break;
	                 	}
	                 	z++;
	             	}
	         	}
	         	// If we got here - the noun was matched to an object, but
	         	// not available.
	         	return false;
	     	}
	   		i++;
	 	}
	    
	    // Enumerate NPCs
	    i = 1;
	    while (i <= data.ocharacters.getCount()) {
	    	c = (character) data.ocharacters.get(i);
	    	if (c.NounID == nid) {
	    		// Check NPC whereabouts
	    		if (c.CurrentLocation == thisplayer.CurrentLocation) {
	    			return true;	
	    		}
	    		// Matched to NPC ok, but they aren't visible
	    		else return false;
	    	}
	    	i++;	
	 	}
	    
	    // Check players in game
	    if (nid > noun.PLAYERNOUNBASE) {
	        // Test the player in question to see if they are in
	        // the same location
	        z = 1;
	        while (z <= data.oplayers.getCount()) {
	        	p = (player) data.oplayers.get(z);
	        	if (p.Index == (nid - noun.PLAYERNOUNBASE)) {
	        		if (p.CurrentLocation == thisplayer.CurrentLocation) {
	        			return true;
	        		}
	        		// Matched to player ok, but they aren't here
	        		else return false;
	        	}
	        	z++;
	        }
	     }
	     
	     // If we made it to the end, then no match was found so the
	     // noun does not refer to an object, NPC or player - it's just
	     // an abstract noun - so let it through.
	     return true;   
	}
	
	/**
     *  Internal code - this is the main body of code which handles
     *  events if nothing else is available. This code also is reponsible
     *  for displaying error messages to players.
     */
	public boolean internalcode() {
		
		// Internal verb handling
		if (Verb == constant.VERB_LOOK)		{if (Noun > 0) {vExamine();} else {data.ogame.displaylocation(thisplayer);} if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_VERSION)	{vdu.Transmit(message.getMessage(constant.MSG_VERSION), thisplayer); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_GET)		{if (Adverb == constant.ADVB_IN) {vGetInside(); if (thisplayer.OutputToPlayer) return true;}}
		if (Verb == 0)						{if (Adverb == constant.ADVB_IN) {vGetInside(); if (thisplayer.OutputToPlayer) return true;}}
		if (Verb == constant.VERB_GET)		{if (Adverb == constant.ADVB_OUT) {vGetOut(); if (thisplayer.OutputToPlayer) return true;}}
		if (Verb == 0)						{if (Adverb == constant.ADVB_OUT) {vGetOut(); if (thisplayer.OutputToPlayer) return true;}}
		if (Verb == constant.VERB_GET)      {if (Adverb == constant.ADVB_UP || Adverb == constant.ADVB_DOWN) {vStand(); if (thisplayer.OutputToPlayer) return true;}}
		if (Verb == constant.VERB_GET)		{if (Adverb != constant.ADVB_UP && Adverb != constant.ADVB_DOWN) {vGet(true); if (thisplayer.OutputToPlayer) return true;}}
		if (Verb == constant.VERB_DROP)	    {vDrop(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_INVENTORY) {vInventory(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_GO)		{vGo(false); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == 0)						if (Adverb <= 10 && Adverb > 0) {vGo(false); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_LIGHT)	{vLight(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_SWITCH)	if (Adverb == constant.ADVB_ON) {vLight(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_EXTINGUISH) {vExtinguish(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_SWITCH)  	if (Adverb == constant.ADVB_OFF) {vExtinguish(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_EXAMINE) 	{vExamine(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_PUT)		if (Adverb == constant.ADVB_ON && Noun2 == 0) {vWear(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_PUT)		{if (Noun2 != 0) vPut(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_GET)      if (Adverb == constant.ADVB_OFF && Noun2 == 0) {vUnwear(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_REMOVE)   if (Noun2 == 0) {vUnwear(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_GET)      if (Noun2 == 0 && Adverb == constant.ADVB_OFF) {vUnwear(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_REMOVE)	{vRemove(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_SCORE)	{thisplayer.showscore(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_KILL)		{vAttack(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_OPEN)		{vOpen(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_CLOSE)	{vClose(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_LIE) 		{vLie(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_SIT)		{vSit(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_STAND)	{vStand(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_CLIMB)    {vStand(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_STATUS)   {thisplayer.showstatus(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_READ)		{vRead(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_WEAR)		{vWear(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_UNWEAR)	{vUnwear(); if (thisplayer.OutputToPlayer) return true;}
		if (Verb == constant.VERB_EAT)		{vEat(); if (thisplayer.OutputToPlayer) return true;}
	
		// We know that our internal code was a washout if nothing
		// appeared on the player's screen, so choose an appropriate
		// error message:
		if (!thisplayer.OutputToPlayer) {
			if (Verb > 0 && Noun > 0) {
				vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
				return false;
			}				
			if (Adverb > 0 && Verb == 0 && Noun == 0) {
				vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SAdverb), thisplayer);
				thisplayer.askParserQuestion(this, 1);
				return false;
			}	
			if (Verb > 0 && Noun == 0) {
				vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
				thisplayer.askParserQuestion(this, 1);
				return false;
			}				
			if (Verb == 0) {
				vdu.Transmit(message.getMessage(constant.MSG_MUSTSUPPLYVERB), thisplayer);
				return false;
			}		
			// We have no idea what they've done, but they've bust it, so
			// just say we have no fucking clue.
			vdu.Transmit(message.getMessage(constant.MSG_DONTUNDERSTAND), thisplayer);
			return false;
			
		}

		return true;		
	}
	
	/**
     *  Internal code for player movement around the map.
     */
	public void vGo(boolean quiet) {
	
		long NewLocation = 0;
		long CurLocAy = 0;
		String Direction = "";
		location l = null;
		int i = 1;
			
	    // If we have a verb and no adverb then error
	    if (Verb == constant.VERB_GO && Adverb == 0) {
	    	if (!quiet) vdu.Transmit(message.getMessage(constant.MSG_WHEREWANTTOGO), thisplayer);
	    	thisplayer.askParserQuestion(this, 4);
	    	return;
	 	}
	    
	    // Find our location
	    while (i <= data.olocations.getCount()) {
	    	l = (location) data.olocations.get(i);
	    	if (l.ID == thisplayer.CurrentLocation) {
	    		CurLocAy = i;
	    		break;	
	    	}
	    	i++;	
	    }
	
	    // Decide which way we are trying to go.
	    if (Adverb == constant.ADVB_NORTH)  {NewLocation = l.N; Direction = "north";}
	    if (Adverb == constant.ADVB_SOUTH)  {NewLocation = l.S; Direction = "south";}
	    if (Adverb == constant.ADVB_EAST)  {NewLocation = l.E; Direction = "east";}
	    if (Adverb == constant.ADVB_WEST)  {NewLocation = l.W; Direction = "west";}
	    if (Adverb == constant.ADVB_UP)  {NewLocation = l.U; Direction = "up";}
	    if (Adverb == constant.ADVB_DOWN)  {NewLocation = l.D; Direction = "down";}
	    if (Adverb == constant.ADVB_NORTHEAST)  {NewLocation = l.NE; Direction = "northeast";}
	    if (Adverb == constant.ADVB_NORTHWEST)  {NewLocation = l.NW; Direction = "northwest";}
	    if (Adverb == constant.ADVB_SOUTHEAST)  {NewLocation = l.SE; Direction = "southeast";}
	    if (Adverb == constant.ADVB_SOUTHWEST)  {NewLocation = l.SW; Direction = "southwest";}
	
		if (NewLocation == 0) {
			if (!quiet) vdu.Transmit(message.getMessage(constant.MSG_CANTGOTHATWAY), thisplayer);
			return;
		}
	    
	    // If the player is sat, stood or laid on something, get them off it
	    thisplayer.State = player.ST_NORMAL;
	    thisplayer.StateItem = null;
	    
	    // Inform players in current location that the character is leaving.
	    vdu.TransmitAllInLocation(thisplayer.Name + " " + message.getMessage(constant.MSG_GOES) + " " + Direction + ".", thisplayer, thisplayer.CurrentLocation);
	    
	    // Move locations
	    thisplayer.CurrentLocation = NewLocation;
	    
	    // Inform players in new location of entering.
	    vdu.TransmitAllInLocation(thisplayer.Name + " " + message.getMessage(constant.MSG_ENTERS) + ".", thisplayer, thisplayer.CurrentLocation);
	
	    // Display new location to player.
	    if (!quiet) data.ogame.displaylocation(thisplayer);
	
	}
	
	/**
     *  Code for handling examining of objects and firing correct events.
     */
	public void vExamine() {
		
		// Handles object examines.
	    
	    int i = 1;
	    interpreter ti = new interpreter(thisplayer, this);
	    item im = null;
	    character cc = null;
	    player p = null;
	    
	    // Check if we have a noun:
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}
	    
	    // See if we are dealing with a player and combat is switched on:
	    if (Noun > location.PLAYERBASE && data.ogame.UsingIAGECombat) {
	    	while (i <= data.oplayers.getCount()) {
	    		p = (player) data.oplayers.get(i);
	    		if (p.Index == Noun - noun.PLAYERNOUNBASE) {
	    			// Output their name
	    			vdu.Transmit(p.Name + ":", thisplayer);
	    			// Show their status
	    			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_OTHERPLAYERSTATUS), Long.toString(p.HitPoints), Long.toString(p.DamageIndicator), Long.toString(p.ChanceOfHitting)), thisplayer);
	    			// Show what they are carrying
	    			vdu.Transmit("", thisplayer);
	    			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_XISCARRYING), p.Name), thisplayer);
	    			vdu.Transmit(game.getinventory(p.Index + location.PLAYERBASE), thisplayer);
	    			// Break out
	    			return;
	    		}
	    		i++;	
	    	}
	    }
	    
	    // Find the object (if it is an object we are dealing with)
	    i = 1;
	    while (i <= data.oitems.getCount()) {
	    	im = (item) data.oitems.get(i);
	    	if (im.NounID == Noun) {
	        
	        	// Display default examine message if it has one
	        	if (!im.DefaultExamine.trim().equals("")) {
	            	vdu.Transmit(im.DefaultExamine, thisplayer);
	            }
	         	
	         	// get just name
	         	String onam = im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length());
	         	
	         	// If the object can be open, then show it's open/closed state
	         	if (im.CanOpenClose) {
	         		if (im.OpenCloseState) {
	         			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_THEXISOPEN), onam), thisplayer);
	         		}
	         		else
	         		{
	         			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_THEXISCLOSED), onam), thisplayer);	
	         		}
	         	}
	         	
	         	// If it's a container, show what's in it, but only if it can open and
	         	// is, or if it can't open and isn't.
	         	if (im.OpenCloseState && im.CanOpenClose || !im.CanOpenClose) {
	         		game.displaycontainerinventory(im, thisplayer, 1);
	         	}
	         	
	         	// If nothing has still been displayed, just say there isn't anything
	         	// interesting about the object.
	         	if (!thisplayer.OutputToPlayer) {
	         		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_NOTHINGSPECIALABOUTX), onam), thisplayer);
	         	}
	            
	     	}
	     	i++;
	 	}
	    
	    // If we got this far, it is not an object, so try the list of NPCs to see if they
	    // are examining one of them.
	    i = 1;
	    while (i <= data.ocharacters.getCount()) {
	    	cc = (character) data.ocharacters.get(i);
	    	if (cc.NounID == Noun) {
	            
				// Display default examine message if it has one
	        	if (!cc.DefaultExamine.trim().equals("")) {
	            	vdu.Transmit(cc.DefaultExamine, thisplayer);
	            }
	            else
	            // Otherwise say there isn't anything interesting
	            {
	            	// get just name
	         		String onam = cc.Name.substring(cc.Name.indexOf(" ") + 1, cc.Name.length());
	         		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_NOTHINGSPECIALABOUTX), onam), thisplayer);	
	            }
	            return;
	     	}
	     	i++;
	 	}
	}
	
	/**
     *  Code for handling putting objects into containers.
     *  Noun1 will be the item we are putting in the container and
     *  Noun2 will be the item we are putting the first one into.
     */
	public void vPut() {
	    
	    int i = 1;
	    item im = null;
	    
	    // Check if we have an item to put:
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}
	    
	    // Check we have an item to put the first one into
	    if (Noun2 == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_WHATDOYOUWANTTOPUTINTO), SNoun), thisplayer);
	        thisplayer.askParserQuestion(this, 2);
	        return;
	 	}
	    
	    // Check for all and do put on all the player is carrying.
	    if (Noun == constant.NOUN_ALL) {
	    	while (i <= data.oitems.getCount()) {
	        	im = (item) data.oitems.get(i);
	        	if (im.CurrentLocation == location.PLAYERBASE + thisplayer.Index) {
	                // Don't include the container itself!
	                if (im.NounID != Noun2 && !im.Invisible) {
	                    vXPut(im, true);
	             	}
	         	}
	        	i++;
	        }
	        return;
	 	}
	    
	    // Find the object
	    i = 1;
	    while (i <= data.oitems.getCount()) {
	    	im = (item) data.oitems.get(i);
	    	if (im.NounID == Noun && !im.Invisible) {
	    		vXPut(im, false);
	    		break;
	     	}
	    	i++;
	    }
	}
	
	/**
     *  Actually does the put for vPut
     */
	private void vXPut(item im, boolean IsListPut) {
		
		int z = 1;
	    item sim = null;
	    boolean putOK = false;
	    boolean putCancelled = false;
	
	    // Find the storage item
	    while (z <= data.oitems.getCount()) {
	    	sim = (item) data.oitems.get(z);
	    	if (sim.NounID == Noun2) {
	    		break;	
	    	}
	    	z++;
	    }
	    
	    // If the two are the same, then we really don't want to put something inside itself.
	    // This is a bit of an overkill check, but you can never be too careful
	    if (sim.ID == im.ID) {
	        vdu.Transmit(im.Name + ": " + message.getMessage(constant.MSG_CANTPUTOBJECTINSIDEITSELF), thisplayer);
	        return;
	 	}
	    
	    // Check if the container is open/closeable and don't allow it
	    // if the container is closed
	    if (sim.CanOpenClose && !sim.OpenCloseState) {
	    	vdu.Transmit(processor.smake(message.getMessage(constant.MSG_THEXISCLOSED), sim.Name.substring(sim.Name.indexOf(" ") + 1, sim.Name.length())), thisplayer);	
	    	return;
	    }
	    
	    // Check they aren't carrying stuff that's too big to insert
	    if ((im.Size + sim.ContainedSize) < sim.Size) {
	    
            // Run any before_insert procedure if we have one for this item
         	interpreter befins = new interpreter(thisplayer, this);
	        befins.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "before_insert", new String[4], 0, "Internal.Put", 0, 0);

			// Do it if it wasn't cancelled
			if (!befins.cancelled) {
	    
		        // Check the adverb, if it's "in" then we put it inside the container
		        // if it's "on", we put it on the container (if it has a surface).
		        
		        // Check for "in"
		        if (Adverb == constant.ADVB_IN || Adverb2 == constant.ADVB_IN) {
		        	// Make sure we actually have a container
		        	if (sim.IsContainer) {
		        		
		        		// Update player inventory if player was carrying it
	  		            if (im.CurrentLocation == (thisplayer.Index + location.PLAYERBASE)) {
						    thisplayer.ItemsCarried--;
					        thisplayer.WeightCarried -= im.Weight;
					        thisplayer.SizeCarried -= im.Size;
					    }
		        		
		        		// We do! Do it!
		        		im.CurrentLocation = sim.ID + location.CONTAINERBASE;
		        		putOK = true;
		        	}
		        	else
		        	{
		        		// Tell player that's not a container
		        		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTPUTTHINGSINX), SNoun2), thisplayer);
		        		return;
		        	}
		        }
		        
		        // Check for "on"
		        if (Adverb == constant.ADVB_ON || Adverb2 == constant.ADVB_ON) {
		        	// Make sure it has a surface.
		        	if (sim.HasSurface) {
	  		            
	  		            // Update player inventory if player was carrying it
	  		            if (im.CurrentLocation == (thisplayer.Index + location.PLAYERBASE)) {
						    thisplayer.ItemsCarried--;
					        thisplayer.WeightCarried -= im.Weight;
					        thisplayer.SizeCarried -= im.Size;
					    }
				        
				        // It does - do it!
		        		im.CurrentLocation = sim.ID + location.SURFACEBASE;
		        		putOK = true;
		        	}
		        	else
		        	{
		        		// Tell player it doesn't have a surface	
		        		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTPUTTHINGSONX), SNoun2), thisplayer);
		        		return;
		        	}
		        }
		    }
	        
	        // Update contained sizes etc if it went in/on ok.
	        if (putOK) {
		        sim.ContainedSize += im.Size;
		        sim.ContainedWeight += im.Weight;
		    }
		    else
		    {
		    	// Tell the user that was wrong	if it wasn't a cancelled
		    	// event:
		    	if (!befins.cancelled) {
		    		vdu.Transmit(message.getMessage(constant.MSG_BADPUTSYNTAX), thisplayer);
		    		return;
		    	}
		    }

			// Get item name
			String IName = im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length());
	        
	        // Say we did it if we don't have an alternative message
	        if (!befins.returnvalue.equals(""))
	        	{
	        		if (IsListPut) 
	        			vdu.Transmit(IName + ": " + befins.returnvalue, thisplayer); 
	        		else
	        			vdu.Transmit(befins.returnvalue, thisplayer);
	        			
	        	// Inform other players in location
		        vdu.TransmitAllInLocation(thisplayer.Name + " puts " + im.Name + " in the " + sim.Name.substring(sim.Name.indexOf(" ")+1, sim.Name.length()) + ".", thisplayer, thisplayer.CurrentLocation);
	        }
	        else
	        	{
	        		if (IsListPut)
	        		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_DONE), IName), thisplayer);
	        	else
	        		vdu.Transmit(message.getMessage(constant.MSG_DONEONLY), thisplayer);
	        		
	        	// Inform other players in location
		        vdu.TransmitAllInLocation(thisplayer.Name + " puts " + im.Name + " on the " + sim.Name.substring(sim.Name.indexOf(" ")+1, sim.Name.length()) + ".", thisplayer, thisplayer.CurrentLocation);
	        }
	        
	        // Run any after_insert code for the object
	        befins.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "after_insert", new String[4], 0, "Internal.Put", 0, 0);
	        
	        // The item can't be worn if it was just put in something else
	        im.IsWorn = false;
	 	}
	    else
	    {
	        // It doesn't fit.
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_DOESNTFIT), im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length())), thisplayer);
	 	}
	}
	
	/**
     *  Handles removing objects from containers. Noun1 should be the object
     *  and Noun2 the container.
     */
	public void vRemove() {
		
		int i = 1;
	    item sim = null;
	    item im = null;
	    boolean foundcontainer = false;
	
	    // This is actually the same as get, so just pass it straight through.
	    // It is only passthrough though if we have both as nouns. Remove all
	    // has to be dealt with specially:
	    if (Noun != constant.NOUN_ALL) {
	    	while (i <= data.oitems.getCount()) {
	    		im = (item) data.oitems.get(i);
	    		if (im.NounID == Noun) {
	    			vXGet(im, false, false);
	    			return;	
	    		}
	    		i++;
	    	}	
	    }
	    
	    // Make sure we have a container noun
	    if (Noun2 == 0) {
	        vdu.Transmit(message.getMessage(constant.MSG_WHATDOYOUWANTTOREMOVEFROM), thisplayer);
	        thisplayer.askParserQuestion(this, 2);
	        return;
	 	}
	    
	    // Find container
	    i = 1;
	    while (i <= data.oitems.getCount()) {
	    	sim = (item) data.oitems.get(i);
	    	if (sim.NounID == Noun2) {
	    		foundcontainer = true;
	    		break;
	    	}
	    	i++;        
	 	}
	    
	    // Make sure we have a container!
	    if (!foundcontainer) {
	        vdu.Transmit(message.getMessage(constant.MSG_WHATDOYOUWANTTOREMOVEFROM), thisplayer);
	        return;
	 	}
	    
	    // Enumerate all items actually within this container and
	    // get them individually.
	    i = 1;
	    while (i <= data.oitems.getCount()) {
	    	im = (item) data.oitems.get(i);
	    	if (im.CurrentLocation == (sim.ID + location.CONTAINERBASE) || 
	    	    im.CurrentLocation == (sim.ID + location.SURFACEBASE)) {
	    		vXGet(im, false, true);
	    	}
	        i++;
	 	}
	}
	
	/**
     *  Handles object gets (and container removes)
     */
	public void vGet(boolean UseTakenMessage) {
		
	    int i = 1;
	    item im = null;
	    
	    // Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}
	    
	    // Check for all and do get on all. Check for except
	    // as well.
	    if (Noun == constant.NOUN_ALL) {
	    	while (i <= data.oitems.getCount()) {
	        	im = (item) data.oitems.get(i);
	        	if (im.CurrentLocation == thisplayer.CurrentLocation && !im.Invisible) {
					if (Noun2 != constant.NOUN_EXCEPT || (Noun2 == constant.NOUN_EXCEPT && Noun3 != im.NounID)) {
	                    vXGet(im, UseTakenMessage, true);
	             	}
	         	}
	        	i++;
			}	        	
	        return;
	 	}
	    
	    // Find the object(s)
	    i = 1;
	    while (i <= data.oitems.getCount()) {
	    	im = (item) data.oitems.get(i);
	    	if (im.NounID == Noun && !im.Invisible) {if (Noun2 != 0) vXGet(im, UseTakenMessage, true); else vXGet(im, UseTakenMessage, false);}
	    	if (im.NounID == Noun2 && !im.Invisible) vXGet(im, UseTakenMessage, true);
	    	if (im.NounID == Noun3 && !im.Invisible) vXGet(im, UseTakenMessage, true);
	    	i++;	
	    }
	}
	
	/**
     *  Actually performs the get or remove
     */
	private void vXGet(item im, boolean UseTakenMessage, boolean IsListTake) {
		
		int z = 1;
		item sim = null;
		interpreter ti = new interpreter(thisplayer, this);
	
		// Check it isn't already carried
		if (im.CurrentLocation == thisplayer.Index + location.PLAYERBASE) {
			vdu.Transmit("You're already carrying that!", thisplayer);
			return;
		}
	
	    // Check it isn't a fixed item
	    if(!im.IsFixed) {
	
	        // Check it isn't too heavy
	        if ((im.Weight + thisplayer.WeightCarried) < data.ogame.MaxWeightCanCarry) {
	            // Check they aren't carrying too many items
	            if (thisplayer.ItemsCarried < data.ogame.MaxItemsCanCarry) {
	                // Check they aren't carrying stuff that's too big to pick this up
	                if ((im.Size + thisplayer.SizeCarried) < data.ogame.MaxSizeCanCarry) {
	                	
	                	// Run any before_get procedure if we have one for this item
	                	// and it is a take, otherwise run the remove procedure
	                	interpreter befget = new interpreter(thisplayer, this);
	                	if (UseTakenMessage)
	                		befget.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "before_get", new String[4], 0, "Internal.Get", 0, 0);
	                	else
	                		befget.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "before_remove", new String[4], 0, "Internal.Remove", 0, 0);
	                	
	                	// If the event wasn't cancelled, do the get
	                	if (!befget.cancelled) {
	                	
		                    // If it was in/on a container, remove the size and weight from that
		                    // container:
		                    if ((im.CurrentLocation > location.CONTAINERBASE && im.CurrentLocation < location.NPCBASE) || (im.CurrentLocation > location.SURFACEBASE)) {
		                    	while (z <= data.oitems.getCount()) {
		                        	sim = (item) data.oitems.get(z);
		                        	if (sim.ID == (im.CurrentLocation - location.CONTAINERBASE)) {
		                                sim.ContainedSize -= im.Size;
		                                sim.ContainedWeight -= im.Weight;
		                         	}
		                        	z++;
		                        }
		                 	}
		                
		                    // Get it!
		                    im.CurrentLocation = location.PLAYERBASE + thisplayer.Index;
		                    // The item can't be worn if it was just picked up
		                    im.IsWorn = false;
		                    // Inform the player
		                    String mess = "";
		                    if (UseTakenMessage) {
		                    	if (IsListTake) 
		                    		mess = message.getMessage(constant.MSG_TAKEN);
		                    	else
		                    		mess = message.getMessage(constant.MSG_TAKENONLY);
		                    }
		                    else
		                    {
		                    	if (IsListTake)
		                    		mess = message.getMessage(constant.MSG_DONE);
		                    	else
		                    		mess = message.getMessage(constant.MSG_DONEONLY);
		                    }
		                    
		                    String objname = im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length());
		                    
		                    // If we had a return value from the get, but it wasn't
		                    // cancelled, over-ride the message with the new one.
		                    if (!befget.returnvalue.equals("")) {
		                    	if (IsListTake)
		                    		vdu.Transmit(objname + ": " + befget.returnvalue, thisplayer);
		                    	else
		                    		vdu.Transmit(befget.returnvalue, thisplayer);
		                    		
		                    }
		                    else {
		                    	if (IsListTake)
		                    		vdu.Transmit(processor.smake(mess, objname), thisplayer);
		                    	else
		                    		vdu.Transmit(mess, thisplayer);}
		                    
		                    // Inform other players in location
  		                    vdu.TransmitAllInLocation(thisplayer.Name + " " + message.getMessage(constant.MSG_TAKES) + " " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
		                    
		                    thisplayer.ItemsCarried++;
		                    thisplayer.WeightCarried += im.Weight;
		                    thisplayer.SizeCarried += im.Size;
		                    im.MovedFromOriginalLocation = true;
		                    
    	                	// Run any after_get procedure if we have one for this item
		                	// and it is a take, otherwise run the after_remove procedure
		                	if (UseTakenMessage)
		                		befget.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "after_get", new String[4], 0, "Internal.Get", 0, 0);
		                	else
		                		befget.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "after_remove", new String[4], 0, "Internal.Remove", 0, 0);
		                    
		                }
		                else
		                {
		                	// The code ran and the event was cancelled, tell the user
		                	// why with the string in the return value.
		                	String objname = im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length());
		                	vdu.Transmit(objname + ": " + befget.returnvalue, thisplayer);
		                }
		            }
	                else
	                {
	                    vdu.Transmit(im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length()) + ": " + message.getMessage(constant.MSG_CARRYINGTOOMANYITEMS), thisplayer);
	             	}
	            }
	            else
	            {
	                vdu.Transmit(im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length()) + ": " + message.getMessage(constant.MSG_CARRYINGTOOMANYITEMS), thisplayer);
	         	}
	        }
	        else
	        {
	            vdu.Transmit(im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length()) + ": " + message.getMessage(constant.MSG_CARRYINGTOOMUCHWEIGHT), thisplayer);
	     	}
	    }
	    else
	    {
	        vdu.Transmit(im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length()) + ": " + im.FixedMessage, thisplayer);
	 	}
		
	}
	
	/**
     *  Handles object drops
     */
	public void vDrop() {
	
	    int i = 1;
	    item im = null;
	    
	    // Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}
	    
	    // Check for all and do drop on all. Allow except as well.
	    if (Noun == constant.NOUN_ALL) {
	    	while (i <= data.oitems.getCount()) {
	    		im = (item) data.oitems.get(i);
	    		if (im.CurrentLocation == (location.PLAYERBASE + thisplayer.Index)) {
	    			if (Noun2 != constant.NOUN_EXCEPT || (Noun2 == constant.NOUN_EXCEPT && Noun3 != im.NounID)) {
	                    vXDrop(im, true);
	             	}
	         	}
	        	i++;
	        }
	        return;
	 	}
	    
	    // Find the object
	    while (i <= data.oitems.getCount()) {
	    	im = (item) data.oitems.get(i);
	    	if (im.NounID == Noun) {
	    		vXDrop(im, false);
	    		break;
	    	}
	    	i++;
	    }
	}
	
	/**
     *  Actually performs the object drop
     */
	private void vXDrop(item im, boolean IsListDrop) {
		
		if (im.CurrentLocation == (location.PLAYERBASE + thisplayer.Index)) {
	    
	    	// Run any before_drop procedure if we have one for this item
        	interpreter befdrop = new interpreter(thisplayer, this);
        	befdrop.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "before_drop", new String[4], 0, "Internal.Drop", 0, 0);
	    
	    	if (!befdrop.cancelled) {
	    
		        // Drop it!
		        im.CurrentLocation = thisplayer.CurrentLocation;
		        // Inform the player
		        
		        // If we had a return value from the get, but it wasn't
                // cancelled, override the message with the new one.
                if (!befdrop.returnvalue.equals("")) {
                	if (IsListDrop)
                		vdu.Transmit((im.Name.substring(im.Name.indexOf(" ") + 1)) + ": " + befdrop.returnvalue, thisplayer);
                	else
                		vdu.Transmit(befdrop.returnvalue, thisplayer);
                	}
                else {
                	if (IsListDrop)
                		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_DROPPED), im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length())), thisplayer);
                	else
                		vdu.Transmit(message.getMessage(constant.MSG_DROPPEDONLY), thisplayer);}
		        
		        // Inform other players in location
		        vdu.TransmitAllInLocation(thisplayer.Name + " drops " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
		        
		        // The item can't be worn if it was just dropped
		        im.IsWorn = false;
		        
		        thisplayer.ItemsCarried--;
		        thisplayer.WeightCarried -= im.Weight;
		        thisplayer.SizeCarried -= im.Size;
		        
		        // Run the after_drop code
		        befdrop.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "after_drop", new String[4], 0, "Internal.Drop", 0, 0);
		        
		    }
            else
	        {
            	// The code ran and the event was cancelled, tell the user
            	// why with the string in the return value.
            	String objname = im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length());
            	vdu.Transmit(objname + ": " + befdrop.returnvalue, thisplayer);
            }
	    }
	    else
	    {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_NOTCARRYINGTHAT), im.Name), thisplayer);
	 	}
	}
	
	/**
     *  Handles lightsource objects being lit
     */
	public void vLight() {
		
	    int i = 1;
	    item im = null;
	    
	    // Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}
	    
	    // Find the object
	    while (i <= data.oitems.getCount()) {
	    	im = (item) data.oitems.get(i);
	    	if (im.NounID == Noun) {
	                // Determine if the object is a light source
	                if (im.IsLightSource) {
	                    // Light it
	                    im.IsLit = true;
	                    // Tell the user
	                    vdu.Transmit(im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length()) + ": Lit.", thisplayer);
	                    // Tell other users
	                    vdu.TransmitAllInLocation(thisplayer.Name + " lights " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
	                    // If the player currently can't see, force a look
	                    if (!thisplayer.CanSee) {
	                    	game.displaylocation(thisplayer);	
	                    }
	                }
	                else
	                {
	                    vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
	             	}
	     	}
	    	i++;
	    }
		
	}
	
	/**
     *  Handles lightsource object extinguishes.
     */
	public void vExtinguish() {
		
	    int i = 1;
	    item im = null;
	    
	    // Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}
	    
	    // Find the object
	    while (i <= data.oitems.getCount()) {
	    	im = (item) data.oitems.get(i);
	    	if (im.NounID == Noun) {
	                // Determine if the object is a light source
	                if (im.IsLightSource) {
	                    // Extinguish it
	                    im.IsLit = false;
	                    // Tell the user
	                    vdu.Transmit(im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length()) + ": Extinguished.", thisplayer);
	                    // Tell other users
	                    vdu.TransmitAllInLocation(thisplayer.Name + " extinguishes " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
	                }
	                else
	                {
	                    vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
	             	}
	     	}
	    	i++;
	    }
		
	}
	
	/** Displays a player's inventory */
	public void vInventory() {
		game.displayplayerinventory(thisplayer);
	}
	
	/*** Handles attacks for IAGE combat */
	public void vAttack() {
		
		int i = 1;
		item im = null;
		long damageind = 0;
		long damagedone = 0;
		boolean missed = false;
		player p = null;
		
		// Bomb if combat is not being handled internally
		if (!data.ogame.UsingIAGECombat) return;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}
	 	
	 	// See if a weapon noun was supplied
	 	if (Noun2 != 0) {
	 		while (i <= data.oitems.getCount()) {
	 			im = (item) data.oitems.get(i);
	 			if (im.NounID == Noun2) {
	 				// Check to see if it's a weapon
	 				if (!im.IsWeapon) {
	 					// It isn't a weapon! Drop out!
	 					vdu.Transmit(processor.smake(message.getMessage(constant.MSG_THATSNOTAWEAPON), im.Name), thisplayer);
	 					return;
	 				}
	 				// Get it's damage indicator
	 				damageind = im.DamageIndicator;
	 			}
	 			i++;
	 		}
	 	}
	 	else
	 	{
	 		// Assume player is barefist fighting
	 		damageind = thisplayer.DamageIndicator;	
	 	}
	 	
	 	// Calculate damage from attack as an integer
	 	damagedone = Math.round((Math.random() * damageind) + 1);
	 	
	 	// Now determine whether they hit or missed
	 	missed = ((Math.abs(Math.random() * 100) + 1) > thisplayer.ChanceOfHitting);
	 	
	 	// If they missed, tell everyone and bomb out now
	 	if (missed) {
	 		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSANDMISSES), thisplayer.Name, SNoun), thisplayer, thisplayer.CurrentLocation);
	 		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSANDMISSES), thisplayer.Name, SNoun), thisplayer);
	 		return;
	 	}
	 		 	
	 	// Attacking another player
	 	if (Noun > noun.PLAYERNOUNBASE) {
	 		
	 		// Find the player
	 		i = 1;
	 		while (i <= data.oplayers.getCount()) {
	 			p = (player) data.oplayers.get(i);
	 			if (p.Index == (Noun - noun.PLAYERNOUNBASE)) {
	 				break;	
	 			}
	 			i++;	
	 		}
	 		
	 		// Take off the damage
	 		p.HitPoints -= damagedone;
	 		
	 		// Tell everyone
	 		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSXFORXPOINTSOFDAMAGE), thisplayer.Name, p.Name, Long.toString(damagedone)), thisplayer, thisplayer.CurrentLocation);
	 		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSXFORXPOINTSOFDAMAGE), thisplayer.Name, p.Name, Long.toString(damagedone)), thisplayer);
	 		// Tell the person who got slapped
	 		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUHAVEBEENHITFORXPOINTSBYX), Long.toString(damagedone), thisplayer.Name), p);	 		
	 		// See if they are dead		
	 		if (p.HitPoints < 1) {
	 			// They are!
	 			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERISDEAD), p.Name), p, p.CurrentLocation);
	 			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERISDEAD), SNoun), thisplayer);
	 			// Tell them they have been killed
	 			vdu.Transmit(message.getMessage(constant.MSG_YOUHAVEBEENKILLED), p);
	 			// Drop all their objects and tell everyone
	 			item.MoveAll(thisplayer.Index + location.PLAYERBASE, thisplayer.CurrentLocation);
		  		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERDROPSTHEIROBJECTS), p.Name), p, p.CurrentLocation);
		  		if (data.ogame.UsingIAGEMoney) {
		 			// Award the killer the player's money
		 			thisplayer.Money += p.Money;
		 			// Tell them about it
		 			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUNOWHAVEPLAYER), p.Name), thisplayer);
		 		}
	 			// Increment their damage indicator
	 			thisplayer.DamageIndicator += data.ogame.DamageIndicatorIncrementForKill;
	 			// Increment their chance of hitting next time
	 			thisplayer.ChanceOfHitting += data.ogame.ChanceOfHittingIncrementForKill;
	 			thisplayer.showstatus();
	 			// See what our policy is for dead people
	 			if (data.ogame.PlayersStayDead) {
	 				// If they stay dead, close their connection - it's all over!
	 				p.quit(true);
	 			}
	 			else
	 			{
	 				// Reset their attributes
				    p.HitPoints = data.ogame.DefaultHitPoints;
				    p.Money = data.ogame.DefaultMoney;
				    p.DamageIndicator = data.ogame.DefaultDamage;
				    p.ChanceOfHitting = data.ogame.DefaultChanceOfHitting;
				    
				    // Resurrect them
	 				if (data.ogame.StartingLocation == -1) {
				    	p.CurrentLocation = data.ogame.getRandomLocation();
				    }
				    else
				    {
				      	p.CurrentLocation = data.ogame.StartingLocation;
				    }
				    // Tell everyone they're here
				    vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERAPPEARS), p.Name), p, p.CurrentLocation);
	 			}
	 		}
	 		
	 	}
	 	else
	 		// Attacking an NPC
	 	{
	 		// Find the NPC
	 		character cc = getnpcfromnoun(Noun);
	 		
	 		// If it's not an NPC, bomb
	 		if (cc == null) return;
	 			 		
	 		// Take off the damage
	 		cc.HitPoints -= damagedone;
	 		
	 		// If the NPC attacks when attacked, get them into that frame of mind now
	 		if (cc.AttackWhenAttacked) {
	 			cc.AIMode = character.ATTACKING;
	 			cc.AttackingWho = thisplayer.Index;
	 		}
	 		
	 		// Tell everyone
	 		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSXFORXPOINTSOFDAMAGE), thisplayer.Name, cc.Name, Long.toString(damagedone)), thisplayer, thisplayer.CurrentLocation);
	 		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSXFORXPOINTSOFDAMAGE), thisplayer.Name, cc.Name, Long.toString(damagedone)), thisplayer);
	 		// See if NPC is dead		
	 		if (cc.HitPoints < 1) {
	 			// They are!
	 			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERISDEAD), cc.Name), thisplayer, thisplayer.CurrentLocation);
	 			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERISDEAD), SNoun), thisplayer);
	 			// Drop all their objects and tell everyone
	 			item.MoveAll(cc.ID + location.NPCBASE, thisplayer.CurrentLocation);
		  		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERDROPSTHEIROBJECTS), cc.Name), thisplayer, thisplayer.CurrentLocation);
		  		if (data.ogame.UsingIAGEMoney) {
		 			// Award the killer the player's money
		 			thisplayer.Money += cc.Money;
		 			// Tell them about it
		 			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUNOWHAVEPLAYER), cc.Name), thisplayer);
		 		}
	 			// Increment their damage indicator
	 			thisplayer.DamageIndicator += data.ogame.DamageIndicatorIncrementForKill;
	 			// Increment their chance of hitting next time
	 			thisplayer.ChanceOfHitting += data.ogame.ChanceOfHittingIncrementForKill;
	 			thisplayer.showstatus();
	 			// See what our policy is for dead NPCs
	 			if (data.ogame.NPCsStayDead) {
	 				// If they stay dead, - it's all over!
	 				cc.CurrentLocation = 0;
	 			}
	 			else
	 			{
	 				// Reset their attributes
				    cc.HitPoints = data.ogame.DefaultHitPoints;
				    cc.Money = data.ogame.DefaultMoney;
				    cc.DamageIndicator = data.ogame.DefaultDamage;
				    
				    // Resurrect them to a random location
				    cc.CurrentLocation = data.ogame.getRandomLocation();
				    // Tell everyone they're here
				    vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERAPPEARS), cc.Name), thisplayer, cc.CurrentLocation);
	 			}
	 		}
	 	}
				
	}
	
	/*** Handles openable objects */
	public void vOpen() {
		
		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it's openable
		if (im.CanOpenClose) {
			// Make sure it isn't already open
			if (!im.OpenCloseState) {
				// Open it
				im.OpenCloseState = true;
				// Say we did it
				vdu.Transmit(message.getMessage(constant.MSG_OPENED), thisplayer);
				vdu.TransmitAllInLocation(thisplayer.Name + " opens " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
				// Reveal contents
				data.ogame.displaycontainerinventory(im, thisplayer, 1);
			}
			else
			{
				// say it's already open
				vdu.Transmit(message.getMessage(constant.MSG_ITSALREADYOPEN), thisplayer);
			}
		}
		else
		{
			// Tell the user they can't open that
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
		}

	}
	
	/*** Handles closeable objects */
	public void vClose() {
		
		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it's closeable
		if (im.CanOpenClose) {
			// Make sure it isn't already closed
			if (im.OpenCloseState) {
				// Close it
				im.OpenCloseState = false;
				vdu.Transmit(message.getMessage(constant.MSG_CLOSED), thisplayer);
				vdu.TransmitAllInLocation(thisplayer.Name + " closes " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
			}
			else
			{
				// say it's already open
				vdu.Transmit(message.getMessage(constant.MSG_ITSALREADYCLOSED), thisplayer);
			}
		}
		else
		{
			// Tell the user they can't open that
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
		}

	}
	
	public void vLie() {
	
		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb + " on"), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it can be laid on
		if (im.CanBeLaidOn) {
			// Lie on it
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUNOWLAIDONTHEX), SNoun), thisplayer);
			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_XLAYSONTHEX), thisplayer.Name, SNoun), thisplayer, thisplayer.CurrentLocation);
			thisplayer.State = player.ST_LYING;
			thisplayer.StateItem = im;
			data.ogame.displaylocation(thisplayer);
		}
		else
		{
			// Tell them they can't
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUCANTXONTHAT), "lie"), thisplayer);				
		}
	}
	
	public void vStand() {
		
		int i = 1;
		item im = null;
		
		// Check if this is a stand up request.
		if (Adverb == constant.ADVB_UP) {
			// hokay!
			thisplayer.StateItem = null;
			thisplayer.State = player.ST_NORMAL;
			vdu.Transmit(message.getMessage(constant.MSG_YOUSTANDUP), thisplayer);
			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_XSTANDSUP), thisplayer.Name), thisplayer, thisplayer.CurrentLocation);
			data.ogame.displaylocation(thisplayer);
			return;
		}
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it can be stood on
		if (im.CanBeStoodOn) {
			// Stand on it
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUNOWSTOODONTHEX), SNoun), thisplayer);
			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_XSTANDSONTHEX), thisplayer.Name, SNoun), thisplayer, thisplayer.CurrentLocation);
			thisplayer.State = player.ST_STOODON;
			thisplayer.StateItem = im;
			data.ogame.displaylocation(thisplayer);
		}
		else
		{
			// Tell them they can't
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUCANTXONTHAT), "stand"), thisplayer);				
		}
		
	}
	
	public void vSit() {

		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb + " on"), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it can be laid on
		if (im.CanBeSatOn) {
			// Sit on it
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUNOWSATONTHEX), SNoun), thisplayer);
			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_XNOWSATONTHEX), thisplayer.Name, SNoun), thisplayer, thisplayer.CurrentLocation);
			thisplayer.State = player.ST_SITTING;
			thisplayer.StateItem = im;
			data.ogame.displaylocation(thisplayer);
		}
		else
		{
			// Tell them they can't
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUCANTXONTHAT), "sit"), thisplayer);				
		}
		
	}
	
	public void vGetInside() {

		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb + " in"), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it can be got inside
		if (im.CanBeGotIn) {
			// Enter it
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUNOWINSIDETHEX), SNoun), thisplayer);
			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_XNOWINTHEX), thisplayer.Name, SNoun), thisplayer, thisplayer.CurrentLocation);
			thisplayer.State = player.ST_INSIDE;
			thisplayer.StateItem = im;
			data.ogame.displaylocation(thisplayer);
		}
		else
		{
			// Tell them they can't
			vdu.Transmit(message.getMessage(constant.MSG_YOUCANGETINSIDETHAT), thisplayer);				
		}
		
	}
	
	public void vGetOut() {

		if (thisplayer.StateItem == null) {
			
			// The player isn't inside anything	
			vdu.Transmit(message.getMessage(constant.MSG_YOUARENTINANYTHING), thisplayer);
			return;			
		}
	
			
		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUGETOUTOFX), thisplayer.StateItem.Name), thisplayer);
		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_XGETSOUTOFX), thisplayer.Name, thisplayer.StateItem.Name), thisplayer, thisplayer.CurrentLocation);
		
		thisplayer.StateItem = null;
		thisplayer.State = player.ST_NORMAL;
		
		data.ogame.displaylocation(thisplayer);
		
		return;
		
	}
	
	/*** Handles readable objects */
	public void vRead() {
		
		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it is readable
		if (im.IsReadable) {
			vdu.Transmit(im.ReadableText, thisplayer);
		}
		else
		{
			// Tell the user they can't read that
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);			
		}
		
	}
	
	/*** Handles wearable objects */
	public void vWear() {
		
		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it is wearable
		if (im.IsWearable) {
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_WORN), im.Name), thisplayer);
			vdu.TransmitAllInLocation(thisplayer.Name + " puts on " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
			im.IsWorn = true;
		}
		else
		{
			// Tell the user they can't wear that
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
		}
		
	}
	
	/*** Handles removing worn items */
	public void vUnwear() {
		
		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it is wearable
		if (im.IsWearable) {
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_DONE), im.Name), thisplayer);
			vdu.TransmitAllInLocation(thisplayer.Name + " takes off " + im.Name + ".", thisplayer, thisplayer.CurrentLocation);
			im.IsWorn = false;
		}
		else
		{
			// Tell the user they can't remove that
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
		}
	}
	
	/*** Handles edible objects */
	public void vEat() {
		
		int i = 1;
		item im = null;
		
		// Make sure we have a noun
	    if (Noun == 0) {
	        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_VERBNEEDSNOUN), SVerb), thisplayer);
	        thisplayer.askParserQuestion(this, 1);
	        return;
	 	}

		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == Noun) {
				break;	
			}
			i++;
		}
		
		// Make sure it is edible
		if (im.IsEdible) {
			vdu.Transmit(message.getMessage(constant.MSG_HMTASTY), thisplayer);
			thisplayer.HitPoints += im.EdibleHitPoints;
			im.CurrentLocation = location.LIMBO;
		}
		else
		{
			// Tell the user they can't eat that
			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_CANTVERBTHAT), SVerb), thisplayer);
		}
	}
	
	/*** Runs OnAction events for referenced nouns */
	public void runactioncode() {
	
		item im = null;
		character cc = null;
		interpreter ti = new interpreter(thisplayer, this);
	
		// Quit immediately if we have no nouns
		if (Noun==0 && Noun2==0 && Noun3==0) return;
		
		// Noun 1
		im = getitemfromnoun(Noun);
		if (im != null) {
			ti.runcode(im.OnAction, "Item(" + Long.toString(im.ID) + ").OnAction");
		}
		else
		{
			cc = getnpcfromnoun(Noun);
			if (cc !=null) {
				ti.runcode(cc.OnAction, "NPC("+ Long.toString(cc.ID) + ").OnAction");
			}	
		}
		
		// Noun 2
		im = getitemfromnoun(Noun2);
		if (im != null) {
			ti.runcode(im.OnAction, "Item(" + Long.toString(im.ID) + ").OnAction");
		}
		else
		{
			cc = getnpcfromnoun(Noun2);
			if (cc !=null) {
				ti.runcode(cc.OnAction, "NPC("+ Long.toString(cc.ID) + ").OnAction");
			}	
		}
		
		// Noun 3
		im = getitemfromnoun(Noun3);
		if (im != null) {
			ti.runcode(im.OnAction, "Item(" + Long.toString(im.ID) + ").OnAction");
		}
		else
		{
			cc = getnpcfromnoun(Noun3);
			if (cc !=null) {
				ti.runcode(cc.OnAction, "NPC("+ Long.toString(cc.ID) + ").OnAction");
			}	
		}
		
	}
	
	/*** Returns the Item ID from a noun */
	public item getitemfromnoun(long NID) {
		int i = 1;
		item im = null;
		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.NounID == NID) {
				// Found our matching item - return it.
				return im;
			}
			i++;	
		}
		return null;
	}
	
	/*** Returns the Noun ID from an Item ID */
	public long getnounfromitemid(long IID) {
		int i = 1;
		item im = null;	
		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.ID == IID) {
				// Found our matching item - return it
				return im.NounID;
			}
			i++;
		}
		return 0;
	}
	
	/*** Returns the Noun ID from an Character ID */
	public long getnounfromcharacterid(long CID) {
		int i = 1;
		character cc = null;	
		while (i <= data.ocharacters.getCount()) {
			cc = (character) data.ocharacters.get(i);
			if (cc.ID == CID) {
				// Found our matching item - return it
				return cc.NounID;
			}
			i++;
		}
		return 0;
	}
	
	/*** Returns the NPC ID from a noun */
	public character getnpcfromnoun(long NID) {
		int i = 1;
		character cc = null;
		while (i <= data.ocharacters.getCount()) {
			cc = (character) data.ocharacters.get(i);
			if (cc.NounID == NID) {
				// Found our matching npc - return it.
				return cc;
			}
			i++;	
		}
		return null;
	}
}