#charset "us-ascii"

/* 
 *   Copyright (c) 1999, 2000 by Michael J. Roberts
 *   
 *   This file is part of TADS 3 
 */

/*
 *   TADS basic data manipulation intrinsic function set 
 */

#ifndef TADSGEN_H
#define TADSGEN_H

/*
 *   define the TADS function set 
 */
intrinsic 'tads-gen/030004'
{
    dataType(val);
    getArg(idx);
    firstObj(cls?, flags?);
    nextObj(obj, cls?, flags?);
    randomize();
    rand(x, ...);
    toString(val, radix?);
    toInteger(str, radix?);
    getTime(timeType?);
    rexMatch(pat, str);
    rexSearch(pat, str);
    rexGroup(groupNum);
    rexReplace(pat, str, replacement, flags);
    savepoint();
    undo();
    saveGame(filename);
    restoreGame(filename, retval);
    restartGame(func, arg);
    max(val1, ...);
    min(val1, ...);
    makeString(val, repeatCount?);
    getFuncParams(func);
    getMethodDefiner();
}

/*
 *   flags for firstObj() and nextObj()
 */
#define OBJ_INSTANCES  0x0001
#define OBJ_CLASSES    0x0002
#define OBJ_ALL        (OBJ_INSTANCES | OBJ_CLASSES)

/*
 *   rexReplace() flags 
 */
#define REPLACE_ONCE  0x0000
#define REPLACE_ALL   0x0001

/*
 *   getTime() flags 
 */
#define GETTIME_DATE_AND_TIME  1
#define GETTIME_TICKS          2


#endif /* TADSGEN_H */

