/*----------------------------------------------------------------------*\

				NAM.C
			    Names handling

\*----------------------------------------------------------------------*/

#include "nam_x.h"

#include "alan.h"
#include "msg.h"
#include "stm_x.h"
#include "lst_x.h"
#include "emit.h"
#include "util.h"


/*----------------------------------------------------------------------*/
static int saveName(List *names, IdNode *id)
{
  List *nameList;
  char *buf = NULL;
  int len = 0;

  if (names != NULL) {
    for (nameList = names->element.lst; nameList != NULL; nameList = nameList->next) {
      buf = allocate(strlen(nameList->element.id->string)+2);
      toIso(buf, nameList->element.id->string, charset);
      if (nameList->next)
	strcat(buf, " ");
      generateText(buf);
      len = len + strlen(buf);
      free(buf);
    }
  } else {
    buf = allocate(strlen(id->string)+1);
    toIso(buf, id->string, charset);
    generateText(buf);
    len = strlen(buf);
    free(buf);
  }
  return(len);
}


/*======================================================================*/
void analyzeNames(Properties *props) {
  Statement *stm;

  /* Create a PRINT statement for the first name */
  stm = newStatement(&nulsrcp, PRINT_STATEMENT);
  stm->fields.print.fpos = ftell(txtfil);
  stm->fields.print.len = saveName(props->names, props->id);
  props->nameStatement = concat(NULL, stm, LIST_STATEMENT);
}
