"For a Place by the Putrid Sea" by "Arno von Borries"

The story headline is "An interactive apartment hunt".

Include Quip-Based Conversation by Michael Martin.
Include Epistemology by Eric Eve.
Include Basic Screen Effects by Emily Short.
Include Locksmith by Emily Short.
[Include Consolidated Multiple Actions by John Clemens.]
Use no scoring and no deprecated features.
Use MAX_STATIC_DATA of 220000.
Use MAX_NUM_STATIC_STRINGS of 210000.
Use MAX_SYMBOLS of 22000

Volume - Setup

Book - General settings

Rule for deciding whether all includes scenery: it does not.
Rule for deciding whether all includes backdrop: it does not.
Rule for deciding whether all includes people: it does not.

The viable room directions list is a list of objects that varies. The viable room directions list is { north, east, south, west, up, down }.

Book - Actions rerouting

The can't search unless container or supporter rule is not listed in any rulebook.

Check searching something:
	if the noun is not a container and the noun is not a supporter and the noun is not a corpse:
		try examining the noun;
		stop the action.
		
can't take scenery rule response (A) is "[regarding the noun][They're] not something I needed to carry around with me.".
block saying yes rule response (A) is "(Use TALK TO to interact with people)".
block saying no rule response (A) is "(Use TALK TO to interact with people)".
block burning rule response (A) is "As much as I would have liked to, it was inappropriate in this case.".
block thinking rule response (A) is "(Use HINT for a little nudge on what to think about, or REMEMBER for things past)".
report smelling rule response (A) is "I knew all too well what happens to nosy people. Better to not be one of them.".
report listening rule response (A) is "I really heard nothing unexpected there, I'm afraid.".
block cutting rule response (A) is "This was not the time and place to cut [the noun]".
block tying rule response (A) is "I was not going to tie [the noun] to [the second noun]. What good would that have served, anyway?".
report tasting rule response (B) is "I'd rather not if I could help it.".
block saying sorry rule response (A) is "(Use TALK TO to interact with people)".
block swinging rule response (A) is "Just for the record: I was not into swinging, cruising or anything similar.".
can't rub another person rule response (A) is "I was afraid that might rub [the noun] the wrong way.".
block setting it to rule response (A) is "Such fine-grained interaction with [the noun] was beyond me.".
block buying rule response (A) is "(Use TALK TO to interact with people)".
block sleeping rule response (A) is "There was still plenty to do before bedtime.".
kissing yourself rule response (A) is "Tempting. In fact almost irresistible, but generally frowned upon. Composure now.".
block kissing rule response (A) is "I didn't think this would have hit the right tone with [the noun].".
innuendo about squeezing people rule response (A) is "Surely not.".
report squeezing rule response (A) is "Unnecessary and futile.".

Understand "xyzzy" as a mistake ("I seriously didn't understand that sentence, whatsoever.").
Understand "yes you did" and "oh yes you did" as a mistake ("No, I didn't.").

Understand "leave" as exiting.

exiting something is an action applying to one thing.
Understand "exit [something]" as exiting something.
Understand "leave [something]" as exiting something.

Carry out exiting something:
	try exiting;

Understand "place [something] on [something]" and "place [something] onto [something]" as putting it on.

Book - map indexing

Index map with Princess_space mapped south of Filleting_space.

Book - Settings for conversation

Before doing something when QBC is active (this is the QBC force conversation rule):
	if the current action is not QBC responding with:
		say "[bracket]Only talk options and REPEAT allowed[close bracket][paragraph break]" instead.

The QBC force conversation rule is listed first in the before rules.

Book - Settings for darkness

Rule for printing a refusal to act in the dark: if we are examining something, say "It was not totally dark, perhaps, but certainly too dim for close-up examination of anything." instead.
 
Rule for printing a refusal to act in the dark: if we are searching something, say "It was not totally dark, perhaps, but certainly too dim for close-up examination of anything." instead.

Rule for printing the description of a dark room: 
	say "[The Description of the location][paragraph break]" instead. 
	
After deciding the scope of the player while in darkness: place the location in scope. 

The examine devices rule is not listed in the carry out examining rules.

Book - Out-of-World Actions

hinting is an action out of world applying to nothing.
Understand "hint" and "stuck" as hinting.

The current hint is a text that varies.
The previous hint is a text that varies.

Table of Hints
goal				hint
"initial_goal"		"You should look for a place to stay."
"clean_room"		"Clean up the room on the first floor of the tenement."
"open_window"	"How do you bring light into a dark room, when the windows are closed?"
"need_money"		"You need money. Try to find work."
"need_jeton"		"The washing machine can only be started with a jeton. Where might you be able to acquire one?"
"hide_body"		"You need to get rid of the body. Perhaps that is possible in the fish factory somehow."
"wash_clothes"		"The soiled clothes need to be washed. Where do you usually find a washing machine?"
"tape_boxes"		"To tape a box shut, you wait until its full, then rip a strip off the tape and stick it to the box."
"find_tape"			"You need to get the tape from the back room of the factory. It's beyond the machinery space."
"escape_mechanic"	"To escape the mechanic, you have to make sure he is occupied with something else. What is his job?"
"gate_closed"		"The gate can be opened from the other side. The way around leads through the fish factory."
"climb_window"	"What ways are there to open a window that is out of reach right now?"
"body_disposed"	"Now that you've disposed of the body, you should return to the office of the neighbourhood association."
"clothing_washed"	"You need to find a way to clean the bloodstained clothes."
"get_paid"			"Where do you go to get paid for your work?"
"get_to_leave"		"You should try to get the tenants on the second floor to leave their apartment."
"memories_hint"	"You are reliving the protagonist's memories."
"equip_revolutionaries"	"You should find a means of leaving the country and some destructive device for the second-floor tenants."
"sunk_ship"		"Hanazono told you a ship had sunk in the harbour."
"call_help"			"Where can you contact emergency services?"
"no_insurance"		"The emergency services need an insurance number. You should ask the chief engineer for it."
"get_bottle"		"The chief engineer wants you to get him a bottle of brandy from the pantry."
"find_tickets"		"The chief engineer was talking about a vacation he had booked, already."
"transport_tickets"	"The tickets can be kept dry inside a watertight container."
"molotov_fuel"		"Napalm can be made by dissolving Polystyrene in Petrol."
"mix_molotov"		"Where could you make a molotov cocktail?"
"back_to_revolutionaries"	"You should bring the tickets and the molotov cocktail to the tenants on the second floor."
"back_to_caretaker"	"You should report back to the caretaker."
"third_floor"		"The caretaker has asked you to somehow get rid of the third-floor tenant."
"invited"			"You've been invited to a place called 'Mahagonny'. Look for it."
"clothes"			"You've already come across something you could wear.'"
"geta"				"Where might someone keep a spare pair of sandals?"
"bet"				"It doesn't matter which bet you put your money on in Trente et Quarante, they are all equal."
"exchange"		"Maybe you should cash your winnings."
"duel"				"Unless you let your opponent come close to you, you will never defeat her."
"precious_little"	"There is precious little to be done now."

Carry out hinting:
	choose row with a goal column of the current hint in the Table of Hints;
	say "[hint entry][line break]".

Command-listing is an action out of world applying to nothing.
Understand "commands" as command-listing.

Carry out command-listing:
	say "Important commands: CLIMB, CLOSE, CUT, DANCE, DIAL, DODGE, DOWN, DROP, EAST, ENTER, EXAMINE, EXIT, FAN, HANG, HELP, HINT, IN, INVENTORY, JUMP, LOCK, LOOK, NORTH, OPEN, OUT, PUT ON, REMEMBER, RETREAT, RIP, SEARCH, STICK, SOUTH, SWITCH OFF, SWIM, SWITCH ON, TAKE, TAKE OFF, TALK, TAPE, TEAR, THROW, UNDRESS, UNLOCK, UP, WEAR, WEST."

Getting help is an action out of world applying to nothing.
Understand "help" and "about" as getting help.

Report getting help:
	say "In this game, character interaction plays an important part and is generally facilitated by [italic type]TALK TO (whomever)[roman type] or even just [italic type]TALK[roman type] in most circumstances. Obvious exits are printed in [bold type]bold type[roman type]. Further exploration is, nevertheless, encouraged but not necessary to achieve a standard ending.[line break]For the sake of user friendliness, this game uses only the cardinal directions [italic type]NORTH, EAST, SOUTH[roman type] and [italic type]WEST[roman type] as well as [italic type]UP, DOWN, IN[roman type] and [italic type]OUT[roman type]. There are some non-standard commands implemented. For a partial list of available commands type [italic type]COMMANDS[roman type]. If you ever find you don't know where to go, ask the other characters in the game. Maybe someone will know the answer or point you in the right direction. If you are still stuck, it might be worth trying the [italic type]HINT[roman type] command before surrendering to the temptation of the walkthrough.[line break]A number of unattributed quotes are contained in this work. They are all set in [italic type]italic type[roman type]. All credits for these quotes of course go to their respective authors, who should be easy enough to find out.[line break]Lastly, it is possible to put this story into a non-winnable state, though it will be made abundantly clear that this has happened. It is also possible to end the story early in a variety of ways. Whether this constitutes sabotage of the protagonist is left for the reader to decide."

Book - When play begins

When play begins:
	now the story tense is past tense;
	now the story viewpoint is first person singular;

Book - Time

The time of day is 2:00 PM.

Volume - Kinds

Book - general

A thing can be watertight. A thing is usually not watertight.
A thing can be heavy. A thing is usually not heavy.
A thing can be valuable. A thing is usually not valuable.
A thing can be sliceable. A thing is usually not sliceable. 

Book - machine

A machine is a kind of device. A machine is usually scenery. A machine is usually switched on.
Understand "machine/machinery/apparatus" as a machine when the location is in the factory.
Understand "start [something]" as switching on.
Understand "stop [something]" as switching off.

Check the player switching on a machine when the player is in the hall:
	say "Heaven knew how to get [the noun] back into running condition. Not my job.";
	stop the action.

After examining a machine:
	if the noun is switched on:
		say "[The noun] was currently switched on.";
	else:
		say "[The noun] was currently switched off.";
	continue the action.

Book - Money

The coin is a thing. The printed name of the coin is "100 yen coin". The coin is improper-named. The description of the coin is "A 100 yen coin. They have a hole in the middle, so you can string up a bunch of them and wear them around your neck."
The coin is watertight.
Understand "yen/cash/dough/funds/gravy/riches/capital/hole/money" as the coin.

Check dropping the coin:
	say "Better to hold onto that for now.";
	stop the action.

Check inserting the coin into something:
	if the second noun is not a slot:
		say "Better to hold onto that for now.";
		stop the action.

Check putting the coin on something:
	say "Better to hold onto that for now.";
	stop the action.
		
Book - Boxes

A cardboard box is a kind of container. A cardboard box is usually closed. The plural of cardboard box is cardboard boxes.
The description of a cardboard box is usually "A corrugated cardboard box. 'Gourmet fish delicacies' had been printed onto it."

Understand "parcel/package/corrugated" as a cardboard box.
A cardboard box can be sealed or unsealed. A cardboard box is usually unsealed.
Fullness is a kind of value. The plural of fullness is fullnesses. The fullnesses are unfilled, somewhat filled, almost filled and filled.
A cardboard box has fullness. A cardboard box is usually unfilled.

Understand "empty" as unfilled.
Understand "full" as filled.
Understand "almost full" as almost filled.
Understand "somewhat full" as somewhat filled.

Understand the fullness property as describing a cardboard box.
Check the player inserting something into a cardboard box:
	say "The only thing going into these boxes were tin cans.";
	stop the action.
	
Check the player opening a filled sealed cardboard box:
	say "I had no reason to rip this box open.";
	stop the action.
	
Check the player opening a filled cardboard box:
	say "The box was open, so to speak, and needed to be sealed.";
	stop the action.
	
Check the player opening a cardboard box:
	say "The box was already open.";
	stop the action.

Check the player closing a filled sealed cardboard box:
	say "The box was closed already.";
	stop the action.
	
Check the player closing a filled cardboard box:
	say "The box needed to be filled to be considered properly closed.";
	stop the action.

Check the player closing a cardboard box:
	say "The box needed to be filled first.";
	stop the action.

Check the player taking something from a cardboard box:
	say "Better to leave that in there.";
	stop the action.
	
Check the player taking a cardboard box:
	if the location is the packing room:
		deliver the Packers_put_down quip;
	else:
		say "I was not going to steal something I didn't even know what to do with.";
	stop the action.

Before printing the name of a cardboard box (called X):
	if X is unfilled or X is almost filled:
		now the indefinite article of X is "an";
	else:
		now the indefinite article of X is "a";
	say "[fullness] ".

Before printing the plural name of a cardboard box (called X) while not listing contents: say "[fullness] ".
Before listing contents: group cardboard boxes together.

For printing a locale paragraph about a cardboard box (called the item) (this is the don't mention boxes in room descriptions rule):
	set the locale priority of the item to 0; 
	continue the activity.

Rule for printing a number of cardboard boxes (called the target): 
	if the listing group size is less than 3:
		say "a few "; 
	else if the listing group size is less than 4:
		say "some ";
	else if the listing group size is less than 7:
		say "a bunch of ";
	else:
		 say "many ";
	carry out the printing the plural name activity with the target.

Does the player mean doing something other than talking to with a filled cardboard box: it is very likely.
Does the player mean doing something other than talking to with an almost filled cardboard box: it is likely.
Does the player mean doing something other than talking to with a somewhat filled cardboard box: it is likely.
Does the player mean doing something other than talking to with an unfilled cardboard box: it is unlikely.

Report an actor inserting a cardboard box into something:
	say "[The actor] put a cardboard box into [the second noun]." instead;

Report an actor taking a cardboard box:
	say "[The actor] picked up [the noun]." instead;
	
Report examining an unsealed cardboard box:
	say "This box was [fullness of the noun] with tin cans." instead.
	
Report searching an unsealed cardboard box:
	say "This box was [fullness of the noun] with tin cans." instead.

Book - Tape

A thickness is a kind of value. The plural of thickness is thicknesses. The thicknesses are thick, thin and out. 
Some tape is a kind of thing. The indefinite article of a tape is usually "a roll of". The description of tape is usually "A roll of adhesive tape.[if out] It had been used up."
Understand "sellotape", "parcel tape", "gaffer tape", "adhesive", "adhesive tape" and "adhesive film" as tape.
Tape has thickness. The thickness of a tape is usually thick.
A tape has a number called length. The length of a tape is usually 3.
Understand the thickness property as describing a tape.

Before printing the name of a tape (called the target):
	if the length of the target is greater than 2:
		now the thickness of the target is thick;
		now the indefinite article of the target is "a thick roll of";
	else if the length of the target is greater than 1:
		now the indefinite article of the target is "a roll of";
	else if the length of the target is greater than 0:
		now the thickness of the target is thin;
		now the indefinite article of the target is "a thin roll of";
	else:
		now the thickness of the target is out;
		now the indefinite article of the target is "an empty roll of";	
	continue the action.

Understand "roll", "tape roll" and "roll of tape" as tape.

Report the player dropping the tape when the location is the packing room:
	say "I laid down my work.";
	deliver the Packers_pick_up_tape quip instead.

Check opening tape:
	say "Better to leave it rolled up.";
	stop the action.

Understand "unwrap [tape]", "unpack [tape]" and "unroll [tape]" as opening. 

Tearing it off is an action applying to two visible things.
Understand "tear [something] off [something]", "tear off [something] off [something]", "tear [something] from [something]", "tear off [something] from [something]", "rip [something] off [something]", "rip off [something] off [something]", "rip [something] from [something]", "rip off [something] from [something]" as tearing it off.

Check tearing it off:
	if the second noun is tape and the noun is a strip:
		try tearing the second noun instead; 
	else:
		say "I didn't understand that sentence.";
		stop the action;


Tearing is an action applying to one visible thing.
Understand "tear [something]", "rip [something]", "tear off [something]", "rip off [something]", "tear strip off [something]", "rip strip off [something]", "tear piece off [something]", and "rip piece off [something]" as tearing.

Check an actor tearing:
	if the noun is not held by the actor:
		try silently taking the noun;
		if the noun is not held:
			say "[The actor] wasn't holding [the noun].";
			stop the action;
		else:
			say "(first taking [the noun])".

Report tearing:
	say "Tear [the noun]? I'd rather not."

Check the player tearing tape:
	if the player carries a strip:
		say "I had already torn off a strip of it. That would suffice for now.";
		stop the action;

Check an actor tearing tape:
	if the actor carries a strip:
		stop the action;

Check the player tearing tape:
	if the length of the noun is 0:
		say "The tape had been used up. No more strips would come off it.";
		stop the action.

Carry out an actor tearing tape:
	let X be a random strip;
	Now the actor carries X.

Carry out the player tearing tape:
	decrease the length of the noun by 1;
	let X be a random strip;
	Now the player carries X.

Report an actor tearing tape:
	say "[The actor] tore a strip off [the noun]." instead.
	
Report the player tearing tape:
	if the length of the noun is 0:
		say "I tore off the last strip on the tape. The tape had now been used up entirely." instead;
	else:
		say "I tore a strip off [the noun]." instead.

Report the packers tearing tape:
	say "One of the girls tore a strip off the roll of tape she was holding." instead.

A strip is a kind of thing. The plural of strip is strips. The printed name of a strip is "strip of tape". The description of a strip is "About 20cm of adhesive tape." Understand "tape", "tape strip" and "strip of tape" and "piece of tape" as a strip.
There is one strip.
Does the player mean tearing a strip: it is unlikely.
Does the player mean tearing the tape: it is very likely.

Sticking it onto is an action applying to two things.
Understand "stick [something] on/to/onto [something]", "glue [something] on/to/onto [something]", "paste [something] on/to/onto [something]", "apply [something] on/to/onto [something]" as sticking it onto.

Rule for supplying a missing noun while sticking something onto a cardboard box:
	if the player carries at least one strip:
		now the noun is a random strip carried by the player;
	else if the player carries tape:
		now the noun is a random tape carried by the player;

Rule for supplying a missing second noun while sticking a strip onto something:
	let x be a random filled unsealed cardboard box in the location;
	unless x is nothing:
		now the second noun is x;
	else:
		let y be a random cardboard box in the location;
		unless y is nothing:
			now the second noun is y.  

Check dropping a strip:
	say "I tried to drop the strip of tape, but try as i might, it wouldn't come off my hand.";
	stop the action.

Check putting a strip on something:
	say "I tried to get rid of the strip of tape, but try as i might, it wouldn't come off my hand.";
	stop the action.

Check inserting a strip into something:
	say "I tried to get rid of the strip of tape, but try as i might, it wouldn't come off my hand.";
	stop the action.

Check sticking a strip onto tape:
	say "No use sticking [the noun] onto [the second noun].";
	stop the action;

Check sticking a strip onto a strip:
	say "No use sticking [the noun] onto [the second noun].";
	stop the action;

Check sticking tape onto something:
	say "I would have to tear a strip off the tape first.";
	stop the action. 

Check an actor sticking something onto something:
	if the noun is not a strip:
		say "[The noun] would hardly stick to [the second noun].";
		stop the action;

Check an actor sticking something onto something:
	if the second noun is not a cardboard box:
		say "What purpose would that have served?";
		stop the action;

Check sticking a strip onto a cardboard box:
	if the second noun is not filled:
		say "Better to wait until the box was filled up with cans.";
		stop the action;

Check sticking a strip onto a sealed cardboard box:
	if the second noun is sealed:
		say "That box had already been taped shut.";
		stop the action.

Carry out an actor sticking a strip onto a cardboard box:
	now the second noun is sealed;
	now the noun is nowhere;

Report an actor sticking something onto something:
	say "[The actor] applied [the noun] to [the second noun]."

Report an actor sticking a strip onto a cardboard box:
	say "[The actor] taped [the second noun] shut with [a noun]." instead.

[Taping it with is an action applying to two things.]
Understand "tape [something] with [something]", "tape [something] shut with [something]", "tape shut [something] with [something]", "shut [something] with [something]", "close [something] with [something]", "glue [something] with [something]", "seal [something] with [something]", "tape [something] up with [something]" and "tape up [something] with [something]" as sticking it onto (with nouns reversed).
	
[Check taping something with tape:
	say "I would have to tear a strip off the tape first.";
	stop the action. 

Check an actor taping something with something:
	if the second noun is not a strip:
		say "[The noun] would hardly stick to [the second noun].";
		stop the action.

Check an actor taping something with something:
	if the noun is not a cardboard box:
		say "What purpose would that have served?";
		stop the action.

Check taping a cardboard box with something that is not a strip:
	unless the second noun is tape:
		say "That must have been a mistake: boxes cannot be taped shut with [a second noun].";
		stop the action;
	
Check taping tape with something:
	say "That must have been a mistake: tape cannot be taped with [a second noun].";
	stop the action;
	
Check taping a cardboard box with tape:
	say "I would have to rip a strip off the tape first.";
	stop the action.

Check taping a cardboard box with a strip:
	if the noun is not filled and the noun is not sealed:
		say "Better to wait until the box was filled up with cans.";
		stop the action.

Check taping a sealed cardboard box with a strip:
	if the noun is sealed:
		say "That box had already been taped shut.";
		stop the action.

Carry out an actor taping a cardboard box with a strip:
	now the noun is sealed;
	now the second noun is nowhere.

Report an actor taping something with something:
	say "[The actor] applied [the noun] to [the second noun]."

Report an actor taping a cardboard box with a strip:
	say "[The actor] taped [noun] shut with [the second noun]." instead.

Taping is an action applying to one thing.
Understand "tape [something]", "tape shut [something]", "tape [something] shut", "tape up [something]", "tape [something] up", "glue [something]" and "glue [something] shut" as taping.

Check taping a cardboard box:
	if the player carries a strip (called X):
		try sticking X onto the noun;
		stop the action.

Report the player taping something:
	say "I didn't need to tape [the noun]."

Report the player taping a cardboard box:
	say "I needed something to tape [the noun] shut. What could I use for this?" instead.]

Check closing a cardboard box:
	if the player carries a strip (called X):
		try sticking X onto the noun instead;
	else:
		say "I needed something to tape [the noun] shut. What could I use for this?" instead.

Check putting a strip on a cardboard box:
	try sticking the noun onto the second noun.

Does the player mean sticking tape onto something: it is unlikely.
Does the player mean sticking a cardboard box onto something: it is very unlikely.
[Does the player mean taping something with tape: it is very unlikely.]
Does the player mean sticking something onto a cardboard box that is not filled: it is very unlikely.
[Does the player mean taping a cardboard box that is not filled with something: it is very unlikely.]
Does the player mean sticking a strip onto something: it is unlikely.
[Does the player mean taping something with a strip: it is unlikely.]
Does the player mean sticking something onto a filled cardboard box: it is unlikely.
[Does the player mean taping a filled cardboard box with something: it is unlikely.
Does the player mean taping a filled cardboard box with a strip: it is unlikely.
Does the player mean taping a cardboard box that is not filled: it is unlikely.
Does the player mean taping a filled sealed cardboard box: it is unlikely.
Does the player mean taping a filled sealed cardboard box with a strip: it is unlikely.]
Does the player mean sticking a strip onto a filled sealed cardboard box: it is unlikely.
Does the player mean sticking a strip onto a cardboard box: it is likely.
[Does the player mean taping a cardboard box with a strip: it is likely.]
Does the player mean putting a strip on a cardboard box: it is likely.
Does the player mean putting a strip on a filled unsealed cardboard box: it is very likely.
[Does the player mean taping a filled unsealed cardboard box: it is very likely.]
Does the player mean sticking a strip onto a filled unsealed cardboard box: it is very likely.

Book - Containers and Supporters

Printing the description of something is an activity.

[Rule for printing the description of something (called item): 
	if the description of the item is not "": 
		say "[description of item][paragraph break]";
	otherwise:
		say "You see nothing special about [the item].".

The activity-based examining rule is listed instead of the standard examining rule in the carry out examining rules.
This is the activity-based examining rule:
	carry out the printing the description activity with the noun;
	rule succeeds.]

Rule for printing the name of an openable fluid container (called x):
	say "[printed name of x]";
	omit contents in listing.

Rule for printing the description of a fluid container (called x):
	let y be a random thing contained by x;
	unless y is nothing:
		say "[description of x] It contained [a list of things contained by x][paragraph break]" instead;
	else if x is full:
		say "[description of x] It was filled with petrol.[paragraph break]" instead;
	else:
		say "[description of x] It was currently empty.[paragraph break]" instead;

definition: a container (called X) is empty if the number of things contained by X is 0.

A closet is a kind of openable container. A closet is usually scenery. A closet is usually closed.

A drawer is a kind of openable container. A drawer is usually scenery. A drawer is usually closed.

Book - Weapons

A knife is a kind of thing. Understand "knife/blade/weapon" as a knife.

Book - Body parts

A member is a kind of thing. A leg is a kind of member. An arm is a kind of member. A head is a kind of member. A torso is a kind of member.
Understand "member/part" as a member.
The description of a head is "The head was attached to the torso at the neck. ".
The description of a leg is "The leg was attached to the torso at the hip.".
The description of a arm is "The arm was attached to the torso at the shoulder.".
The description of a torso is "The torso was the part that all the other members were attached to.".
Understand "finger/fingers/hand/hands/elbow/elbows/biceps/triceps/shoulder/shoulders", "left arm/hand/elbow/shoulder" and "right arm/hand/elbow/shoulder" as an arm.
Understand "toe/toes/foot/feet/knee/knees/calf/shin/shins/thigh/thighs/hip/hips/behind", "left leg/foot/knee/calf/thigh" and "right leg/foot/knee/calf/thigh" as a leg.
Understand "face/chin/cheek/cheeks/forehead/eye/eyes/nose/mouth/ear/ears/hair/neck/throat" as a head.
Understand "back/front/tummy/belly/chest/breast" as a torso.
 
[Two legs, two arms, a head and a torso are part of every person.]

Does the player mean doing something with a member that is part of the player: it is unlikely.

Book - Staircases, Windows and Doors

A bulkhead is a kind of plural-named door. A bulkhead is usually scenery. A bulkhead is usually openable. A bulkhead is usually closed. The description of a bulkhead is usually "The usual watertight door one sees aboard ships, with rounded corners and a raised sill."

A staircase is a kind of door. A staircase is usually scenery. A staircase is usually open. A staircase is seldom openable. The description of a staircase is usually "A flight of stairs allows locomotion on the z-axis while maintaining an angle of ascent of approximately 45 degrees."
Understand "staircase", "flight of stairs", "flight", " stair case" and "stairs" as a staircase.

Understand "go up [something]" and "ascend [something]" as climbing.
Carry out climbing a staircase: 
	try entering the noun. 

Descending is an action applying to one thing. Understand "descend [something]" and "go down [something]" as descending. 
Carry out descending a staircase:
	Try entering the noun.

A window is a kind of door. 
Understand "windowsill" as a window.
Understand "look out [a window]", "look out of [a window]" and "look through [a window]" as examining.

Check entering a window:
	unless the noun is the back window:
		say "I was not going to climb through this window.";
		stop the action.

Check going through a window (called X):
	unless X is the back window:
		say "I was not going to climb through this window.";
		stop the action.

Climbing through is an action applying to one thing. Understand "climb through [something]", "climb in 
[something]", "climb out [something]", "climb out of [something]", "jump out of [something]" as climbing through.
Check climbing through:
	if the noun is not a door:
		say "I couldn't climb through [a noun]!";
		stop the action.
Carry out climbing through:
	try entering the noun instead.
	
Check climbing something:
	if the noun is a door:
		try climbing through the noun instead;
	else if the noun is a supporter:
		try entering the noun instead.

Understand "ascend", "above" and "upwards" as up.
Understand "descend", "below" and "downwards" as down.

Knocking on is an action applying to one thing.Understand "knock against [something]", "tap against [something]", "bang against [something]", "knock on [something]", "knock [something]", "tap on [something]", "tap [something]", "bang on [something]" as knocking on.

Check knocking on:
	unless the noun is a door:
		say "I tapped [the noun] ever so slightly with my finger, but that didn't help with anything.";
		stop the action.
		
Report knocking on:
	say "I knocked against [the noun] a few times."
	
Book - Clothing

Some clothing is a kind of thing. The plural of clothing is articles of clothing. Clothing is wearable.
Cleanliness is a kind of value. The cleanlinesses are soiled, wet and dry.
Clothing has cleanliness. The cleanliness of clothing is usually dry.
Understand the cleanliness property as describing clothing.

		
Check wearing clothing:
	unless the cleanliness of the noun is dry:
		if the cleanliness of the noun is soiled:
			say "I wasn't going to wear a soiled piece of clothing.";
		else if the cleanliness of the noun is wet:
			say "But [the noun] was still wet!";
		stop the action.

A wafuku is a kind of clothing. The plural of wafuku is wafuku.
yofuku is a kind of clothing. The plural of yofuku is yofuku.
A furisode is a kind of wafuku. The plural of furisode is furisode.
Understand "kimono" as a furisode. 


A hat is a kind of thing. A hat is wearable.
The plural of Footwear is pairs of footwear. Some footwear is a kind of thing. Some footwear is wearable. Footwear is usually plural-named. The indefinite article of footwear is usually "a pair of".

Check an actor wearing footwear:
	if the actor is wearing footwear that is not the noun:
		say "[The actor] [are] wearing some other footwear already." instead.

[Underwear is a kind of thing. Underwear is wearable.]

Understand "wear [things preferably held]", "don [things preferably held]" and "put on [things preferably held]" as wearing.
Understand "take off [things]", "take [things] off", "strip off [things]", "strip [things] off" and "doff [things]" as taking off.

Check wearing something:
	if the noun is not wearable:
		say "That was hardly wearable." instead;
		stop the action;

Check taking off something:
	if the noun is not worn by the player:
		say "I wasn't wearing that.";
		stop the action;

Undressing is an action applying to one visible thing.
Understand "undress [someone]" and "strip [someone]" as undressing.
Understand "undress [something]" and "strip [something]" as undressing.

Rule for supplying a missing noun while undressing: 
    now the noun is the player.

Does the player mean undressing a corpse: it is very likely.

Does the player mean undressing the player: it is likely.

Does the player mean undressing a person that is not the player: it is unlikely.

Does the player mean undressing (a thing that is not a person): it is very unlikely.

Check undressing:
	if the noun is not a person and the noun is not a corpse:
		say "[The noun] was not something I could undress.";
		stop the action;
	else if the noun is not the player and the noun is not a corpse:
		say "I wasn't on such intimate terms with [the noun].";
		stop the action.

Carry out undressing a person:
	repeat with X running through sashes worn by the noun:
		unless X is nothing:
			try taking off X;
	repeat with X running through things worn by the noun:
		unless X is nothing or X is clothing:
			try taking off X;
	repeat with X running through clothing worn by the noun:
		unless X is nothing:
			try taking off X.
			
Carry out undressing a corpse:
	repeat with X running through sashes that are part of the noun:
		unless X is nothing:
			try taking off X;
	repeat with X running through things that are part of the noun:
		unless X is nothing or X is clothing or X is a member:
			try taking off X;
	repeat with X running through clothing that is part of the noun:
		unless X is nothing:
			try taking off X.

A sash is a kind of thing. A sash is wearable. The plural of sash is sashes.
A sash has a text called the knot.
The knot of a sash is usually "bunko-musubi". 

Table of Obi Musubi
name
"bunko-musubi"
"bunko-gaeshi musubi"
"yanoji-musubi"
"washikusa-musubi"

Understand "clothing/clothes/attire/apparel" as clothing.
Understand "wafuku" as wafuku.
Understand "shoe/shoes/footwear/pair" as footwear.
Understand "sandals" as sandals.
Understand "hat/headwear" as a hat.
Understand "sash" as a sash.
Understand "knot/musubi" as a sash.
Understand "bunko-musubi", "bunko-gaeshi musubi", "janoji-musubi", "washikusa-musubi", "bunko", "bunko-gaeshi", "janoji" and "washikusa" as a sash.

[Check wearing underwear:
	if the player is wearing clothing:
		say "Oh, sure, on top of [the random clothing worn by the player].";
		stop the action.

Check taking off underwear:
	if the player is wearing clothing:
		say "I would have had to take [the random clothing worn by the player] off, first.";
		stop the action.

Check wearing wafuku:
	if the player is not wearing underwear:
		say "I would first have had to put on a [italic type]juban[roman type].";]

Check wearing a sash:
	if the player is wearing a sash that is not the noun:
		say "I was already wearing an obi." instead.

Check wearing a sash:
	if the player is not wearing wafuku:
		say "That would hardly have constituted appropriate attire." instead.

Check wearing a sash (called X):
	choose a random row in the Table of Obi Musubi;
	now the knot of X is the name entry;
	continue the action.

Report wearing a sash (called X):
	say "I tied the obi in a [italic type][knot of X][roman type]." instead.
	
Understand "tie [sash]" as wearing.
Understand "untie [sash]" as taking off.

The plural of Footwear is pairs of footwear. Some footwear is a kind of thing. Some footwear is wearable. Footwear is usually plural-named. The indefinite article of footwear is usually "a pair of".

Sandals are a kind of footwear. Sandals are plural-named.

Check exiting from a changing room when the player is wearing wafuku and the player is not wearing sandals:
	say "The shoes I wore hardly fit my clothing. I would have to put on some other footwear first";
	now the previous hint is the current hint;
	now the current hint is "geta";
	stop the action.

Check exiting from a changing room when the player is wearing wafuku and the player is wearing the jipijapa:
	say "The hat I wore hardly fit my clothing. I would have to take it off before going out. ";
	stop the action.

Check taking off wafuku when the player is wearing a sash:
	say "I would first have to take off the obi.";
	stop the action.		

Check going:
	unless the player is in subsurface:
		if the player is wearing wafuku and the player is not wearing a sash:
			say "I would have had to finish dressing before I would have been ready to head out into the world.";
			stop the action;
		else if the player is wearing wafuku and the player is not wearing sandals:
			say "I was not going to leave without footwear that fit my outfit.'";
			stop the action;
		else if the player is not wearing clothing:
			say "There was no way I would leave here stark naked.";
			stop the action;
		else if the player is not wearing footwear:
			say "I was not going anywhere without shoes on my feet.";	
			stop the action;
		else if the player is wearing wafuku and the player is wearing the jipijapa:
			say "The hat I wore hardly fit my clothing. I would have to take it off before going out. ";
			stop the action.
Check exiting:
	unless the player is in subsurface:
		if the player is wearing wafuku and the player is not wearing a sash:
			say "I would have had to finish dressing before I would have been ready to head out into the world.";
			stop the action;
		else if the player is wearing wafuku and the player is not wearing sandals:
			say "I was not going to leave without footwear that fit my outfit.'";
			stop the action;
		else if the player is not wearing clothing:
			say "There was no way I would leave here stark naked.";
			stop the action;
		else if the player is not wearing footwear:
			say "I was not going anywhere without shoes on my feet.";	
			stop the action;
		else if the player is wearing wafuku and the player is wearing the jipijapa:
			say "The hat I wore hardly fit my clothing. I would have to take it off before going out. ";
			stop the action.
Check getting off:
	unless the player is in subsurface:
		if the player is wearing wafuku and the player is not wearing a sash:
			say "I would have had to finish dressing before I would have been ready to head out into the world.";
			stop the action;
		else if the player is wearing wafuku and the player is not wearing sandals:
			say "I was not going to leave without footwear that fit my outfit.'";
			stop the action;
		else if the player is not wearing clothing:
			say "There was no way I would leave here stark naked.";
			stop the action;
		else if the player is not wearing footwear:
			say "I was not going anywhere without shoes on my feet.";	
			stop the action;
		else if the player is wearing wafuku and the player is wearing the jipijapa:
			say "The hat I wore hardly fit my clothing. I would have to take it off before going out. ";
			stop the action.

Check an actor wearing clothing:
	if the actor is wearing clothing that is not the noun:
		say "What a silly thing to suggest! [The actor] [are] already wearing another outfit.";
		stop the action.

Check taking off something that is not a hat when the location is not a changing room:
	if the noun is footwear and the location is School_lockers:
		continue the action;
	else if the noun is worn by the actor:
		say "Here? Surely not.";
		stop the action.

Book - Fans

A fan is a kind of thing.
Understand "fan" as a fan.

Book - Corpses

A corpse is a kind of thing. Understand "body" as a corpse. 

Book - Fluid Containers

A fluid container is a kind of container. A fluid container can be full. A fluid container is usually not full.

A jerrycan is a kind of  fluid container. A jerrycan is watertight and openable. The description of a jerrycan is usually "A petrol canister."
Understand "petrol canister", "petrol", "canister", "gasoline canister", "gasoline", "fuel", "can" and "fuel canister" as a jerrycan.

Check opening a full jerrycan:
	if the location is in subsurface and the location is not an air bubble:
		say "I was not going to cause an oil spill.";
		stop the action.

Check opening a not full jerrycan:
	if the location is in subsurface and the location is not an air bubble:
		say "I didn't intend to fill the jerrycan with sea water.";
		stop the action.
		
Check inserting something into a jerrycan:
	say "The jerrycan was meant for petrol only.";
	stop the action.

Check swimming when the player carries a jerrycan (called x):
	if x is open:
		say "(first closing the jerrycan)";
		try silently closing x;
		if x is open:
			say "I wasn't going to spoil the contents of the jerrycan with sea water.";
			stop the action;
	else if x is not full:
		say "It was impossible to dive with an empty jerrycan.";
		stop the action;
	else:
		continue the action.
		
Check going to a room in subsurface when the player carries a jerrycan (called x):
	if x is open:
		say "(first closing the jerrycan)";
		try silently closing x;
		if x is open:
			say "I wasn't going to spoil the contents of the jerrycan with sea water.";
			stop the action;
	else if x is not full:
		say "It was impossible to dive with an empty jerrycan.";
		stop the action;
	else:
		continue the action.

Understand the command "fill" as something new.

Pouring it into is an action applying to two things.

Understand "pour [fluid container] in/into/on/onto [something]" as pouring it into. Understand "pour out [fluid container] in/into/on/onto [something]" as pouring it into. Understand "empty [fluid container] into [something]" as pouring it into. Understand "fill [something] with/from [fluid container]" as pouring it into (with nouns reversed).
Understand "pour [something] in/into/on/onto [something]" as pouring it into. Understand "pour out [something] in/into/on/onto [something]" as pouring it into. Understand "empty [something] into [something]" as pouring it into. Understand "fill [something] with/from [something]" as pouring it into (with nouns reversed).

Check pouring it into: 
    if the noun is not a fluid container, say "I couldn't pour [the noun]." instead; 
    if the second noun is not a fluid container, say "I wasn't going to pour that onto [the second noun]." instead; 
    if the noun is the second noun, say "I could hardly pour [the noun] into itself." instead; 
    if the noun is not full, say "There was nothing left in [the noun] to pour." instead; 
    if the second noun is full, say "[The second noun] had already been filled sufficiently" instead.

Carry out pouring it into:
	now the noun is not full;
	now the second noun is full;

Report pouring it into:
	say "I poured the contents of [the noun] into [the second noun]."
	
Check pouring something into a jerrycan:
	if the second noun is closed:
		say "(first opening  [the second noun]";
		try opening the second noun;
		if the second noun is closed:	
			say "I would have to open the jerrycan first.";
			stop the action;

Check pouring a jerrycan into something:
	if the second noun is closed:
		say "(first opening  [the second noun]";
		try opening the second noun;
		if the second noun is closed:	
			say "I would have to open the jerrycan first.";
			stop the action;

Volume - Things

Book - The Boat

Part 1 - The Boat

In Boatpier is a vehicle called the motor boat. The initial appearance of the motor boat is "[if the location is Boatpier and Vanya is not in the motor boat]An old motor boat was moored to the pier.[else]Vanya was at the helm of the motor boat nearby." The description of the motor boat is "This boat was probably held together by nothing more than the scarce traces of paint left in the gaps between the planks. It was driven by an old outboard engine and its name - 'Rachel' - was painted on the bow."
Understand "plank/planks/Rachel/paint/traces" as the motor boat.

In the motor boat are four filled sealed cardboard boxes.

Part 2 - The engine

The outboard engine is part of the motor boat. The outboard engine is a device. The description of the engine is "An outboard engine so oil-fouled its operation was doubtful. It was easy enough to use if it started, which was facilitated by a simple ignition.[unless the boat key is in the ignition] The ignition key however, was missing." The outboard engine is switched off. 

Understand "motor" as the outboard engine.
[Does the player mean doing something with the outboard engine: it is very likely.]
	
The ignition is part of the outboard engine. The ignition is a container. The description of The ignition is "[if the boat key is not in The ignition]A scratched keyhole, no key in it."

Understand "keyhole" as The ignition.	

Check an actor turning the boat key:
	if the boat key is in the ignition and the outboard engine is switched off:
		try the actor switching on the outboard engine instead;

Check an actor turning the boat key:
	if the boat key is in the ignition and the outboard engine is switched on:
		try the actor switching off the outboard engine instead;

Check the player switching off the outboard engine:
	if the outboard engine is switched on and the boat key is in the ignition:
		say "I was not at the helm.";
		stop the action;

Report an actor turning the boat key:
	say "[The actor] turned the key in [their] hand." instead.
	
Check the player inserting something that is not the boat key into the ignition:
	say "That didn't belong in there.";
	stop the action.

Understand "stick [something] into [something]" as inserting it into.

Before the player switching on the outboard engine when the boat key is not in the ignition:
	say "I would need to put the key into the ignition first." instead.

Report an actor switching on the outboard engine:
	say "[The actor] started the engine. Stuttering noisily, it came to life." instead.

Understand "start [something]" as switching on.
Understand "stop [something]" as switching off.

Before the player taking the boat key when the boat key is in the ignition and the outboard engine is switched on:
	say "The engine was still running.";
	stop the action.

Starting it with is an action applying to two things.

Understand "start [something] with [something]" as starting it with.
Understand "turn on [something] with [something]" as starting it with. 

Check an actor starting something with something:
	if the noun is the outboard engine or the noun is the motor boat:
		if the second noun is the boat key:
			now the boat key is in the ignition;
			try the actor switching on the outboard engine instead;
		else if the actor is the player:
			say "That would hardly be able to start the engine." instead;
	else if the actor is the player:
		say "That made little sense to me." instead;
		
Report the player starting something with something:
	say "That made little sense to me." instead.

Instead of switching on the motor boat:
	try switching on the outboard engine.

Instead of switching off the motor boat:
	try switching off the outboard engine.

Part 3 - Rules for movement

Check going inside in the presence of the motor boat:
	try entering the motor boat instead.

Check going by the motor boat to a room that is not watery:
	say "The motor boat would only float on water. To go anywhere else, I would have had to get off it, first.";
	stop the action.

Check going by the motor boat when the outboard engine is switched off:
	say "The engine wasn't running at the moment.";
	stop the action.
	
Check going to a room (called X) that is watery:
	if the player is in the motor boat:
		say "I was not at the helm.";
		stop the action;
	else if X is not a pier and the player is wearing something:
		say "That would have involved swimming, and I wouldn[']t have wanted to get [the random thing worn by the player] wet.";
		stop the action.

Instead of getting off the motor boat:
	try exiting.



Part 4 - Refusals

Check taking the boat key when Vanya is in the location:
	say "It wasn't mine to take.";
	stop the action.
	
Check turning the boat key when Vanya is in the location:
	say "I wasn't at the helm of this boat.";
	stop the action.
	
Check switching off the outboard engine when Vanya is in the location:
	say "I wasn't at the helm of this boat.";
	stop the action.

Check exiting from the motor boat:
	unless the location is a pier:
		try swimming instead;

Volume - Globally relevant Actions

Book - Remembering

The return room is a room that varies.
The _wornRoom is a privately-named room.
The _carriedRoom is a privately-named room.

Remembering is an action applying to one topic.
Understand "remember [text]", "ponder [text]", "recall [text]" and "think about [text]" as remembering.

Table of memorable Topics
topic																											remember_room	return_room 		age 	enabled	
"school" or "institution" or "gakou"																				school_lockers		the ground floor		15		1
"boarding house" or "forbidden staircase" or "forbidden" or "staircase" or "stairs" or "stair case" or "boarding"	servants_stairs		the second floor		13		1


Table of ponderable Topics
topic												enabled 	text
"fish factory" or "factory" or "Seng Heng"				0			"A fish factory. Last time I saw it, it was not exactly deserving of the title."
"Vanya" or "guy" or "Ivan" or "lanky" or "lanky guy" or "Wanja" or "Russian"		0			"I had called him Vanya in those earlier days. Of course his proper name was Ivan, but who'd call a guy like him by it, anyway?"
"Gotomomi" or "city" or "Tokyo"						0			"To have visited before, what does that even mean in Tokyo?"
"Manila" or "Philippines"								0			"Food for the imagination. But not something I remembered too fondly."
"Man'yôshû" or "manyoushuu" or "manyoshu"			0			"Gotanda-sensei had surely been right that learning poetry by heart helped with writing your own." 
"Kokinshû" or "Kokin wakashû" or "kokinshuu" or "kokinshu"	0			"At the very least a stylistic reference."
"Gotanda" or "Gotanda-sensei" or "sensei" or "teacher" or "school mistress" or "mistress"			0	"Ideally, what comes to mind when thinking of a school mistress is what she taught you."
"Family" or "aunt" or "uncle" or "grand-parent" or "grand-parents" or "grandfather" or "grandmother" or "great-uncle" or "sibling" or "siblings" or "brothers" or "brother" or "parent" or "parents" or "mother" or "father"	0	"There are a million ways your family members will show their love, even if they hate you."
"Great-aunt"											0			"I never learned what it was she did in Latin America. But the lurid stories of the jungle she told me were surely better than the truth, anyway."
"Cousin" or "love" or "lover"							0			"I was not in the mood for crying."
"White-handed maiden" or "maiden with the white hands" or "smiling face" or "smile" or "senpai"	0	"[italic type]She[roman type] was all too easy to remember."
"PT-92" or "phone" or "telephone"						0			"There were two main models of the PT-92: the PT-92A-T7 and the PT-92B-TX12, which looked identical from the outside."
"PT-92A" or "PT-92A-T7" or "A-Series" or "B-series"		0 			"Many of the details about the A -series were not very well known. But they were not in production for very long."
"PT-92B" or "PT-92B-TX12" or "B-Series" or "B-series"	0			"From the PT-92B-T9, T10, TX11 and TX12 series operator's manual: [italic type]To put the PT-92 into  programming mode, enter your personal four-digit service code with the receiver down. If the correct code was entered. The display will change to 'PROG'[roman type]."
"four-digit service code" or "service code" or "personal service code" or "personal code" or "personal four-digit service code"		0	"From the PT-92B-T9, T10, TX11 and TX12 series operator's manual: [italic type]When initially setting up a phone for operation, use the factory default service code. To reset the phone to the factory default code, open the casing and disconnect the battery for at least five minutes. Reconnect the battery and close the case. The factory default service code is now reset[roman type]."
"factory default service code" or "factory default code" or "default code" or "four-digit service code" or "factory default"		0		"If I remembered correctly, the factory default code for the PT-92B-series started with a 4 and ended in a 1, there was also a 7 somewhere in the middle."
"programming mode" or "phone programming"		0	"From the PT-92B-T9, T10, TX11 and TX12 series operator's manual: [italic type]When the PT_92B-series apparatus is in programming mode, Phone calls can be made free of charge[roman type]."
"Childhood" or "home"									0			"Except for my very early years, I lived my life in institutions."
"dead girl" or "dead body" or "body"					0		"I seemed to remember her face from somewhere. School, perhaps? What was her name again?"
"name" or "girl's name" or "name of girl" or "her name"	0		"It just didn't seem to click. Maybe it'd come back some other time."
"Eskrima" or "Kali" or "Knife fight"						0		"A knife fight is usually won by whomever manages to 'defang the snake' first."
"Trente et Quarente" or "Gambling"					0		"A game with four chances, all equally likely."
"barman" or "barkeeper"								0		"He used to work at at different venue."
"judo"													0		"I remembered the many hours I had spent on the mat."
"diving" or "apnoea" or "apnoea diving" or "free diving"	0	"That old hobby of mine. I could hold my breath for ten minutes."
"letter"													0		"I wish I had had the chance to read it." 


Report remembering a topic listed in the Table of ponderable Topics:
	say "[text entry][line break]". 

Check remembering:
	if the topic understood is not a topic listed in the Table of ponderable Topics and the topic understood is not a topic listed in the Table of memorable Topics:
		say "I couldn't remember anything of interest about that.";
		stop the action.

Check remembering a topic listed in the Table of memorable Topics:
	if the location is not the return_room entry:
		say "This wasn't the place to remember that.";
		stop the action;
	else if the enabled entry is 0:
		say "I didn't want to remember that right now.";
		stop the action.

Carry out remembering a topic listed in the Table of memorable Topics:
	clear the screen;
	now the return room is the return_room entry;
	move the player to the remember_room entry;
	now the age of Ayako is the age entry;
	repeat with x running through things worn by the player:
		now x is in the _wornRoom;
	repeat with x running through things carried by the player:
		now x is in the _carriedRoom;
	now Ayako wears the school uniform;
	now Ayako wears the slippers;
	now Ayako carries the handkerchief;
	if the Age of Ayako is 15:
		now Ayako wears the badge;
	now the scar is nowhere;
	now the enabled entry is 0;
	now the previous hint is the current hint;
	now the current hint is "memories_hint".

Book - Dying

The shroud is clothing. The description of the shroud is "A long white garment."

To kill the player:
	clear the screen;
	repeat with x running through things worn by the player:
		now x is in the _wornRoom;
	repeat with x running through things carried by the player:
		unless x is the coin:
			now x is in the _carriedRoom;
	now Ayako wears the shroud;
	now Ayako is in the river shore;
	now the current hint is "precious_little";

Book - Taking

The taking action has an object called previous locale (matched as "from").

Setting action variables for taking:
	now previous locale is the holder of the noun.

Report taking something from the location:
	say "I picked up [the noun] from the ground." instead.
Report taking something:
	say "I took [the noun] from [the previous locale]." instead.

Book - Fanning

fanning is an action applying to nothing.
Understand "fan" and "fan air" as fanning.
Check fanning:
	if the player is not carrying a fan:
		say "I had no fan." instead.
Report fanning:
	say "I fanned myself with [the random fan carried by the player]."
		
fanning it with is an action applying to one thing.
Understand "fan with [something]" and "fan air with [something]" as fanning it with.
Understand "wave [something]" as fanning it with.
Check fanning it with:
	if the noun is not a fan:
		say "That was not something I could fan myself with." instead.
Check fanning it with:
	if the noun is not carried by the player:
		say "I didn't have [the noun] on me." instead.
Report fanning it with:
	say "I fanned myself with [the noun]."
	
Check waving a fan:
	try fanning instead.
	
Check opening a fan:
	try fanning instead.

Book - Dancing

A room can be inspiring. A room is usually not inspiring.

Table of Dances
topic		text
"Walz" 		"That would have been nice! Alas, it's a pair dance and I was on my own with my desire to dance."
"Foxtrot"	"Oh, please! Spare me the foxtrot."
"Salsa"		"This wasn't Rio!"
"Rumba"	"That would have been nice! Alas, it's a pair dance and I was on my own with my desire to dance."
"Chacha"	"That would have been nice! Alas, it's a pair dance and I was on my own with my desire to dance."
"Lindyhop"	"That would have been nice! Alas, it's a pair dance and I was on my own with my desire to dance."

Table of Ballet Solos
topic	piece	title		choreographer	date		
"Pas de trois des odalisques" or "odalisques" or "Corsaire" or "Le Corsaire" 	"Pas de trois des odalisques"	"Le Corsaire"	"Marius Pepita"	"1899"
"Le Jardin animé" or "Le Jardin anime" or "Jardin anime" or "Jardin animé" or "Corsaire" or "Le Corsaire"		"Le Jardin animé"	"Le Corsaire"	"Alexander Gorsky"	"1912"
"Kitri as Dulcinea" or "Don Quixote"	"Kitri as Dulcinea"	"Don Quixote"	"Marius Pepita"	"1871"
"Kitri with the fan" or "Don Quixote"	"Kitri with the fan"	"Don Quixote"	"Alexander Gorsky"		"1902"
"L'apparition de la Bonne fée" or "L'apparition de la bonne fee" or "Les Millions d'Arlequin" or "Les Millions d'Arléquin" or "harlequinade" or "arlequinade"	"L'apparition de la Bonne fée"	"Les Millions d'Arléquin"	"Marius Pepita"	"1900"		
"L'aurore" or "Coppélia"or "Coppelia"	"L'aurore"	"Coppélia"	"Marius Pepita"	"1884"		
"La Priere" or "Coppélia" or "Coppelia"	"La Priere"	"Coppélia"	"Marius Pepita"	"1884"		
"Grand pas des papillons" or "Papillon"	"Grand pas des papillons"	"Papillon"	"Marius Pepita"	"1874"
"Variation de Giselle" or "Giselle"		"Variation de Giselle"	"Giselle"	"Sergei Diaghilev"	"1911"

Dancing is an action applying to one topic.
Understand "dance [text]" as dancing.

The Solo is a text that varies.

Before dancing:
	Choose a random row from the Table of Ballet Solos;
	now the Solo is the piece entry.

Check Dancing when the location is not inspiring:
	say "This was hardly the right place to dance. It might have been a better idea elsewhere.";
	stop the action.

Check Dancing when the player is wearing wafuku:
	say "A difficult proposition in a kimono.";
	stop the action;

Check Dancing:
	if the topic understood matches "Ballet/ballet":
		try dancing "[Solo]";
		stop the action;
	else unless the topic understood is a topic listed in the Table of Dances or the topic understood is a topic listed in the Table of Ballet Solos:
		say "That was not a dance I knew.";
		stop the action;

Check Dancing a topic listed in the Table of Dances:
	say "[text entry][line break]";
	stop the action;

Carry out dancing a topic listed in the Table of Ballet Solos:
	repeat with N running from 1 to the number of rows in the Table of Ballet Solos:
		if the topic understood matches the topic in row N of the Table of Ballet Solos:
			now the Solo is the piece in row N of the Table of Ballet Solos.

Report dancing a topic listed in the Table of Ballet Solos:
	say "I danced a solo piece from [choreographer entry][']s [date entry] [one of]version[or]revival[at random] of [italic type][title entry][roman type]." instead;

After dancing a topic listed in the Table of Ballet Solos:
	if Vanya is in the location:
		deliver the Vanya_watched quip;
		enable the Vanya_ballet quip for Vanya;
		enable the Vanya_mistake quip for Vanya;
		disable the Vanya_been_while quip for Vanya;
		disable the Vanya_just_looking quip for Vanya;
		run a conversation on the Table of Vanya conversation;
	continue the action.

Swirling is an action applying to nothing.
Understand "dance" as swirling.

Check swirling when the location is not inspiring:
	say "This was hardly the right place to dance. Elsewhere, perhaps a little more spacious, it would have been a better idea.";
	stop the action.

Check Swirling when the location is inspiring:
	say "A fantastic idea. But what dance exactly?";
	stop the action.


Book - Swimming

Diving is an action applying to one thing.
Understand "dive into [something]", "swim in [something]" and "jump into [something]" as diving.

Check diving:
	if the noun is not the sea:
		say "I didn't want to dive into that.";
		stop the action;

Carry out diving:
	try swimming instead;

Swimming is an action applying to nothing.
Understand "swim" and "dive" as swimming. 

Check swimming:
	unless the location is in subsurface:
		if the location is not watery:
			say "Swim in what? There was no water body here.";
			stop the action.

Check swimming:
	if the room down from the location is nothing:
		say "The water was too shallow to swim in.";
		stop the action.
	
[Check swimming:
	if the player wears at least one thing:
		say "(first taking of clothes)";
		try undressing the player;
	if the player carries at least one thing:
		say "(first dropping non-watertight inventory)";
		repeat with X running through things carried by the player:
			unless X is watertight:
				try silently dropping X;]

Check swimming:
	if the player is wearing something:
		let x be a random thing worn by the player;
		say "I wouldn't have wanted to get [the x] wet. Maybe I should have taken [regarding x][them] off first.";
		stop the action.

Check swimming:
	let x be a random not watertight thing carried by the player ;
	unless x is nothing:
		say "I wouldn't have wanted to get [the x] wet. Maybe I should have dropped [regarding x][them] first. ";
		stop the action.

Carry out swimming:
	let x be the room down from the location;
	unless x is nothing:
		if the player carries at least one heavy thing:
			say "[The random heavy thing carried by the player] pulled me down quickly.";
		else:
			say "Gaining depth took some effort.";
			decrease the oxygen of Ayako by 1;
		move the player to x.

Check taking something not watertight when the room down from the location is in subsurface:
	unless the player is in the motor boat:
		say "I wouldn't have wanted to get [the noun] wet. Better to leave [regarding the noun][them] where [regarding the noun][they][are].";
		stop the action;

Check going down:
	 if the room down from the location is in subsurface:
		unless the room down from the location is nothing:
			try swimming instead;

Check going up when the location is in subsurface:
	if the player carries at least one heavy thing:
		say "Ascending with [the random heavy thing carried by the player] required serious effort.";
		decrease the oxygen of Ayako by 2;
	else:
		say "I swam upwards.";
	continue the action.

Check going to a room in subsurface:
	unless the room gone to is an air bubble:
		let x be a random not watertight thing carried by the player;
		unless x is nothing:
			say "I wouldn't have wanted to get [the x] wet. I'd have to let go of [regarding the noun][them] before going that way.";
			stop the action;

Check waiting when the location is watery:
	if the location is not a pier and the player is not in a vehicle:
		try swimming instead;

After dropping something when the location is watery:
	unless the player is contained by a vehicle:
		unless the room down from the location is nothing:
			move the noun to the room down from the location;
	continue the action.

A person has a number called oxygen. The oxygen of a person is 10.

An air bubble is a kind of room.

After going to an air bubble:
	now the oxygen of Ayako is 10;
	continue the action.

Every turn when the location is in subsurface and the location is not an air bubble:
	if the oxygen of Ayako < 1:
		kill the player;
	else if the oxygen of Ayako is 1:
		say "My vision was getting blurry.";
	else if the oxygen of Ayako is 2:
		say "Time to surface, I thought by myself.";
	else if the oxygen of Ayako is 4:
		say "My thought processes were getting slower. ";
	else if the oxygen of Ayako is 5:
		say "Half-time for this dive, I thought by myself. ";
	else if oxygen of Ayako is 6:
		say "Overcoming the first wave of agony is always the hardest part when diving.";
	else if oxygen of Ayako is 7:
		say "Most people would have had to come up for air now.";
	else if oxygen of Ayako is 8:
		say "At this point, most people would have wanted to surface again.";
	decrease the oxygen of Ayako by 1;
	repeat with X running through rooms in subsurface:
		unless the room down from X is nothing:
			repeat with Z running through things in X:
				unless Z is scenery or Z is backdrop or Z is a person:
					move Z to the room down from X.

Volume - Locations

Chapter - General settings

A changing room is a kind of room.
A pier is a kind of room.
A room can be watery. A room is usually not watery. A pier is usually watery.

A room can be detailed. A room is usually not detailed.
A room has a text called ceilingtext. The ceilingtext is usually "".
A room has a text called walltext. The walltext is usually "".
A room has a text called floortext. The floortext is usually "".

to say walldetail for (X - a room):
	say "[walltext of X]".
	
to say floordetail for (X - a room):
	say "[floortext of X]".
	
to say ceilingdetail for (X - a room):
	say "[ceilingtext of X]".

The bay is a region.
The streets are a region.
The factory is a region.
The school is a region.
The tenement is a region.
Subsurface is a region.
The shipwreck is a region.
The cruise ship is a region.

Book - Bay

The sea is backdrop in the bay and in the Docklands and in the bookies and in the glass house. The description of the sea is "[if the third act is happening]The sea refracted the fading sunlight into many shades of red and blue. Soon, it would just be black.[else]The mid-day sun reflected in the calm waters of the bay so brilliantly, I had to avert my eyes.". Understand "bay/water/harbour/harbor/depth/depths/waters" as the sea.

Chapter - The Pier

Boatpier is a pier in the bay. Boatpier is inspiring. The printed name of Boatpier is "[If the player is in the motor boat]At the pier[else]On the pier". The Description of Boatpier is "A series of pontoons had been cobbled together to construct this pier. It had once been home to a flotilla of fishing vessels. Nowadays, however, there was no longer anything to be caught in Tokyo bay, which extended towards the [bold type]west[roman type]. A rusty ladder [bold type]ascended[roman type] the quay wall.[if unvisited][paragraph break][italic type](New players may want to type HELP)[roman type][end if]"

The pontoons are plural-named scenery in Boatpier. The Description of the pontoons is "The materials used to construct this had probably been scavenged from some depot after the end of the cold war." Understand "pier", "pontoon", "mooring", "material", "materials", "jetty", "floor", "ground" and "series" as the pontoons when the location is the Boatpier.

The rusty rungs are a plural-named staircase. The description of the rusty rungs is "This sure was a practical and sturdy ladder."
The rusty rungs are below the Docklands and above Boatpier.
Understand "ladder" and "rusty ladder" as the rusty rungs when the location is Docklands or the location is Boatpier.
Check going east in the Boatpier:
	try going up instead.

The quay is backdrop in Boatpier and in the streets. The Description of the quay is "A promenade atop a stone wall that rose from the water almost vertically.". Understand "quay wall", "promenade", "stone wall", "stone" and "wall" as the quay when the location is Boatpier or the location is the docklands.

Chapter - Out in the bay

_bay is a privately-named changing room in the bay. The printed name of _bay is "Out in the bay". The description of _bay is "[If the player is in the motor boat]We were floating in the middle of the bay, the boat[']s engine hammering away like a sewing machine.[else]I was now treading water in the middle of Tokyo bay.[end if][if Hanazono is interrogated] The depth loomed from [bold type]below[roman type].".
_bay is watery.
_bay is west of Boatpier.

After going up to a watery room:
	now the oxygen of Ayako is 10;
	continue the action;

Chapter - The waste dump

_dump_stash is a room.
[A circuit board is a valuable undescribed thing in _dump_stash. The description of the circuit board is "An old  piece of PCB with a couple of chips, some switches and a bunch of sockets.".
Understand "pcb/chip/chip/switch/switches/sockets/socket" as the circuit board.]
An umbrella is a valuable watertight undescribed thing in _dump_stash. The description of the umbrella is "A torn and broken umbrella.".
Understand "torn/broken" as the umbrella.
The umbrella can be opened. The umbrella is not opened.
Before opening the umbrella:
	if the umbrella is opened:
		say "It was already open.[paragraph break]";
	else:
		now the umbrella is opened;
		say "I opened the umbrella.[paragraph break]";
	stop the action;

Before closing the umbrella:
	if the umbrella is not opened:
		say "It was already closed.[paragraph break]";
	else:
		now the umbrella is not opened;
		say "I closed the umbrella.[paragraph break]";
	stop the action;

[A bottle is a kind of watertight thing. The description of a bottle is usually "An empty glass bottle with a threaded neck.".
Understand "flask" as a bottle.
A bottle cap is  a kind of watertight thing. The description of a bottle cap is usually "A screw-on bottle cap made of sheet metal .".
Understand "lid" as a bottle cap.]

Some Styrofoam is a thing. The description of the Styrofoam is "A large piece of Styrofoam stuffing".
Understand "foam/stuffing/piece/packaging/Polystyrene" as the Styrofoam.
The Styrofoam is nowhere.

Section - Waste Dump 1

_waste_dump_1 is a privately-named pier in the bay. The printed name of _waste_dump_1 is "At a waste dump in the bay". The description of _waste_dump_1 is "A refuse heap, stretching of few hundred meters towards the [bold type]south[roman type], rose from the shoals below. This part of the dump seemed more organised than the rest."

_waste_dump_1 is south of _bay.

To say refuse:
	if the location is _waste_dump_1:
		say "Objects of some remaining value had been sorted and stacked more or less neatly here[run paragraph on]";
	else:
		say "This was the endpoint of the value chain[run paragraph on]"

The waste dump is backdrop in _waste_dump_1 and in _waste_dump_2. The description of the waste dump is "[refuse].[line break]".
Understand "refuse", "rubbish", "garbage", "trash", "discarded goods", "discarded", "goods", "refuse dump", "garbage dump", "garbage heap", "refuse heap", "trash heap" and "pile/piles/heap/heaps" as the waste dump.

The worthy objects are a plural-named thing in _waste_dump_1. The worthy objects are scenery. The printed name of the worthy objects is "objects of some remaining value". The description of the worthy objects is "With some of these, it was readily apparent why they'd be salvaged. With many others, not so much.".
Understand "salvage", "valuable" and "valuable objects" as the worthy objects when the location is _waste_dump_1.

The apparatus is scenery in _waste_dump_1. The description of the apparatus is "Some kind of contraption. Its purpose was difficult to guess."
Understand "machine/machinery/contraption" as the apparatus when the location is _waste_dump_1.

Section - Waste Dump 2

_waste_dump_2 is a privately-named pier in the bay. The printed name of _waste_dump_2 is "On a waste dump in the bay". The description of _waste_dump_2 is "All kinds of discarded goods were piled up around me. The refuse dump stretched towards the [bold type]north[roman type].".
_waste_dump_2 is south of _waste_dump_1.

The bath tub is a fluid container in _waste_dump_2. The description of the bath tub is "An old bath tub." The bath tub is fixed in place. The initial appearance of the bath tub is "[if the bath tub is jellied]The old bath tub lying around here was filled with napalm jelly.[else if the bath tub is full]The old bath tub lying around here was filled with petrol.[else]An old bath tub had been discarded amongst the refuse."
The bath tub can be jellied. The bath tub is not jellied.
Understand "bathtub" and "napalm" as the bath tub.

Instead of taking, pulling or pushing the bath tub:
	say "It was too heavy to move."
 
Check inserting something into the bath tub:
	if the noun is not the Styrofoam:
		if the noun is the bottle of cut brandy:
			say "No. But I might be able to fill the bottle from the bath tub." ;
		else if the noun is a jerrycan:
			say "No. But I might be able to pour out the jerrycan into the bath tub." ;
		else:
			say "What good would that have served?";
		stop the action;
		
Carry out inserting the Styrofoam into the bath tub:
	if the bath tub is full:
		now the Styrofoam is nowhere;
		now the bath tub is jellied;

Report inserting the Styrofoam into the bath tub:
	if the bath tub is full:
		say "I dissolved Styrofoam in the bath tub until the petrol had been sufficiently jellied." instead.

Check pouring the bath tub into something:
	if the bath tub is jellied and the second noun is not the bottle of cut brandy:
		say "Filling [the second noun] with napalm would have achieved little. I needed to fill something else.";
		stop the action.

Carry out pouring a full fluid container into the bath tub:
	if the Styrofoam is in the bath tub:
		now the Styrofoam is nowhere;
		now the bath tub is jellied;

Report pouring a fluid container into the bath tub: 
	if the bath tub is jellied:
		say "I poured the contents of [the noun] into [the second noun]. The Styrofoam was quickly dissolved and the petrol turned into napalm." instead;
	else:
		say "I poured the contents of [the noun] into [the second noun]." instead;

Report pouring the bath tub into something:
	say "I filled [the second noun] from [the noun]." instead.

Instead of entering the bath tub:
	say "My name is Ayako, not Asuka.";
	stop the action.

Check examining the waste dump when the location is _waste_dump_2:
	try searching the noun instead;

Instead of searching the waste dump when the location is _waste_dump_2:
	let X be a random valuable thing in _dump_stash;
	if X is nothing:
		say "I saw nothing but refuse around me: there were heaps of smelly trash bags, broken glass, Styrofoam packaging, and so on.";
	else:
		say "I saw nothing but refuse around me: there were heaps of smelly trash bags, broken glass, Styrofoam packaging, [a X] and so on.";
		move X to the location.

After going from _waste_dump_2:
	repeat with X running through valuable things in _waste_dump_2:
		unless X is nothing:
			move X to _dump_stash;
	continue the action.
	
The smelly trash bags are plural-named scenery in _waste_dump_2. The description of the smelly trash bags is "Yuk. Better not touch these."
The broken glass is scenery in _waste_dump_2. The description of the broken glass is "Sharp shards. Better not touch these."
Understand "sharp shards", "sharp shard" and "sharp/shards/shard" as the broken glass.

The _styrofoam is scenery in _waste_dump_2. The _styrofoam is privately-named. The printed name of the _styrofoam is "heaps of styrofoam". The description of the _styrofoam is "This was used as packaging material for all kinds of things. It ended up in heaps and piles in places like this."
Understand "styrofoam", "packaging", "packaging material" and "stuffing" as the _styrofoam.
Understand "stuffing/piece/packaging/Polystyrene/foam" as the _styrofoam.
Does the player mean doing anything with the _styrofoam: it is unlikely.
Does the player mean doing anything with the Styrofoam when the location is _waste_dump_2: it is likely.

Instead of taking the _styrofoam:
	if the player carries the Styrofoam:
		say "I already had enough Styrofoam.";
	else:
		say "I picked up some Styrofoam.";
	now the player carries the Styrofoam.

Book - The laid up vessel

The laid up vessel is a privately-named pier in the bay. The printed name of the laid up vessel is "By the laid-up vessel". The description of the laid up vessel is "The rusty hulk of what had once been a cruise ship lay deep in the water before us. It had once been called 'Havana Sunrise' but that had been sloppily painted over with the word 'Mahagonny'. A [bold type]gangway[roman type] had been lowered to the water line."
The laid up vessel is north of the _bay.

The rusty hulk is scenery in the laid up vessel. The description of the rusty hulk is "A hideous mountain of steel, slowly oxidising away."
Understand "cruise ship", "Havana sunrise", "Mahagonny" and "ship" as the rusty hulk.

The gangway is a staircase. The gangway is above the laid up vessel.

Check going up in the laid up vessel when the third act is happening:
	if the player wears yofuku:
		say "I wasn't going to go to that place at this time in the evening wearing a day dress.";
		now the previous hint is the current hint;
		now the current hint is "clothes";
		stop the action;
	else if the player is invited and Ayako is not warned:
		deliver the Vanya_warning quip;
		run a Conversation on the Table of Vanya conversation instead;		
		
Book - The cruise ship

The cruise ship is a region.

Chapter - The bookies

The bookies is a privately-named room in the cruise ship. The printed name of the bookies is "On the laid-up vessel, by the entrance". The description of the bookies is "This was a kind of reception area for what lay further to the [bold type]north[roman type]. An opening in the hull allowed access to the [bold type]gangway[roman type]."
The bookies is above the gangway.

The guichet is scenery in the bookies. The description of the guichet is "One of these little counter windows."
Understand "counter", "window" and "counter window" as the guichet.

Check going north in the bookies when Ayako is not exchanged:
	say "'Excuse me, Miss, but tonight is by invitation only,' the woman behind the [italic type]guichet[roman type] stopped me.";
	stop the action;

Chapter - The bar room

The bar room is a privately-named room in the cruise ship. The printed name of the bar room is "On the laid-up vessel, in the bar room". The description of the bar room is "A watering hole with an enormous collection of alcohols on the shelves behind the bar. The game table was to the [bold type]west[roman type], the exit to the [bold type]south[roman type]. There was also a door marked 'private' to the [bold type]north[roman type]."
The bar room is north of the bookies.

The enormous collection of alcohols is scenery in the bar room. The description of the enormous collection of alcohols is "Liquors, spirits, reinforced wines: they were all there in seemingly infinite variation."
Understand "shelves/shelf/wine/wines/liquor/liquors/spirit/spirits" and "reinforced wine/wines" as the enormous collection of alcohols.
 
The counter is a supporter in the bar room. The counter is scenery. The description of the counter is "A counter-top that ran the length of the room."
Understand "bar" and "counter top" and "countertop/counter-top" as the bar.

The bar door is a door. The bar door is scenery. The description of the bar door is "The word 'private' had been stencilled onto it."
The bar door is north of the bar room.

Check entering the bar door during gambling:
	deliver the barman_no_way quip;
	stop the action.

Check going north in the bar room during gambling:
	deliver the barman_no_way quip;
	stop the action.

Chapter - The casino

The casino is a privately-named room in the cruise ship. The printed name of the casino is "On the laid-up vessel, by the game table". The description of the casino is "This was were one engaged in games of chance. [italic type]Trente et Quarante[roman type] was being dealt on the green table. The bar was to the [bold type]east[roman type]."
The casino is west of the bar room.

The game table is a supporter in the casino. The game table is scenery. The description of the game table is "The table was covered in a [italic type]tapis[roman type], on which the four available chances had been printed: [italic type]rouge, noir, couleur, [roman type]and [italic type]inverse[roman type]. One laid chips on them to place bets."
Understand "green table", "tapis", "tableau", "trente et quarante", "trente", "quarante", "grand tableau" and "petit tableau" as the game table.

A bet is a kind of supporter. Understand "chance" as a bet. A bet is usually scenery. Understand "bet" as a bet. The plural of bet is bets.
A part of the game table is a bet called rouge. The printed name of rouge is "[italic type]rouge[roman type]".
A part of the game table is a bet called noir. The printed name of noir is "[italic type]noir[roman type]".
A part of the game table is a bet called couleur. The printed name of couleur is "[italic type]couleur[roman type]".
A part of the game table is a bet called inverse. The printed name of inverse is "[italic type]inverse[roman type]".
Play state is a kind of value. The play states are betting, set, scored.
The game table has play state. The play state of the game table is scored.

Check putting something on a bet:
	unless the noun is a chip:
		say "I didn't think the [italic type]croupier[roman type] would approve of that.";
		stop the action;

Check putting something on the game table:
	unless the noun is a chip:
		say "I didn't think the [italic type]croupier[roman type] would approve of that.";
		stop the action;
	else:
		try putting the noun on a random bet that is part of the game table instead;

The _cards are scenery in the casino. Understand "card/cards" and "playing cards" as the _cards. The description of the _cards is "The standard French playing cards."
Does the player mean doing anything with the _cards: it is very unlikely.

Chapter - Ring

The ring is a privately-named room in the cruise ship. The printed name of the ring is "On the laid-up vessel, in the ring." The description of the ring is "This was a sports venue of sorts, big enough to hold the kind of events places like this made their money with." 
The ring is north of the bar door.

Book - Subsurface

The water is backdrop in subsurface. The description of the water is "It was all around me."
The darkness is backdrop in subsurface. The description of the darkness is "The deeper down in the ocean, the less light will reach."

Chapter - _bay_surface

_bay_surface is a privately-named room in subsurface. The printed name of _bay_surface is "In the bay, near the surface". The description of _bay_surface is "Light shone through the water[']s surface [bold type]above[roman type] me. The outlines of something large loomed from the darkness [bold type]below[roman type]."

_bay_surface is below _bay.

The outlines are plural-named backdrop in _bay_surface. The description of the outlines is "It was difficult to make out from up here what it was."
Understand "something", "large thing", "large" and "something large" as the outlines.

Chapter _bay_wreck

_bay_wreck is a privately-named room in subsurface. The printed name of _bay_wreck is "In the bay, above a wreck.". The description of _bay_wreck is "A bit further [bold type]down[roman type], a freighter had come to rest on the seabed. [bold type]Above[roman type] me, darkness gave way to light."

_bay_wreck is below _bay_surface.

Chapter _wreck_deck

The wreck is backdrop in _bay_wreck and in _wreck_deck. The description of the wreck is "A capsized cargo ship, quite well preserved. Its sinking couldn't have happened more than two weeks earlier.".
Understand "shipwreck", "vessel", "seagoing vessel", "seagoing", "ship", "freighter", "hull", "superstructure", "deck" and "cargo ship" as the wreck.

_wreck_deck is a privately-named room in subsurface. The printed name of _wreck_deck is "By the wreck." The description of _wreck_deck is "The vessel's hull lay on its side, balanced on the superstructure. A cargo hatch to the [bold type]north[roman type] allowed access to the ship's insides. [bold type]Above[roman type] me, the water was warmer. ".
_wreck_deck is below _bay_wreck.

The cargo hatch is a scenery door. The cargo hatch is lockable and locked. The description of the cargo hatch is "A sliding hatch, split down the beam of the ship[if the locking clamp is locked], fastened shut by a locking clamp[end if]."
Understand "loading hatch", "sliding hatch", "sliding" and "loading" as the cargo hatch.
The locking clamp is a part of the cargo hatch. The description of the locking clamp is "A sturdy clamp for keeping the cargo hatch shut, even in high seas. [If the locking clamp is locked]It was currently engaged."

Check going inside in _wreck_deck:
	try going north instead.

The cargo hatch is north of _wreck_deck and south of the cargo hold.

Understand "disengage [the locking clamp]" as unlocking keylessly.
Understand "engage [the locking clamp]" as locking keylessly. 
Understand "unfasten [the locking clamp]" as unlocking keylessly.
Understand "fasten [the locking clamp]" as locking keylessly.

Check unlocking keylessly the cargo hatch:
	if the cargo hatch is unlocked:
		 say "The hatch was already unlocked.";
		stop the action;
	else:
		try pulling the locking clamp instead.

Check opening the cargo hatch:
	if the locking clamp is locked:
		say "The locking clamp was still engaged.";
		stop the action;

Check locking keylessly the cargo hatch:
	if the cargo hatch is locked:
		say "The hatch was already secured with the locking clamp.";
		stop the action;
	else:
		try pushing the locking clamp instead.

Check locking the cargo hatch with something:
	say "The hatch locked with a locking clamp, not with a key.";
	stop the action.
Check unlocking the cargo hatch with something:
	say "The hatch locked with a locking clamp, not with a key.";
	stop the action.

Check pushing the locking clamp:
	if the cargo hatch is locked:
		say "The hatch was already securely locked.";
		stop the action;
	else:
		continue the action.

Carry out pushing the locking clamp:
	now the cargo hatch is locked.

Report pushing the locking clamp:
	say "I pushed the locking clamp, and the hatch was locked." instead.

Check pulling the locking clamp:
	if the cargo hatch is unlocked:
		say "The hatch was already unlocked.";
		stop the action;
	else:
		continue the action.

Carry out pulling the locking clamp:
	now the cargo hatch is unlocked.

Report pulling the locking clamp: 
		say "I pulled the locking clamp, and the hatch was unlocked." instead.

Report opening the cargo hatch:
	say "One half of the hatch slid open towards the seabed and gave way to a gaping darkness." instead.

Check closing the cargo hatch:
	say "There was no way I could close the hatch with gravity against me.";
	stop the action.

Chapter - Shipwreck

The shipwreck is in subsurface.

Understand "teak/wood/deck" as the floor when the location is in the shipwreck.
Understand "steel/grey" as the walls when the location is in the shipwreck.
Understand "steel/grey/deckhead" as the ceiling when the location is in the shipwreck.

Section - Cargo Hold

The cargo hold is a privately-named dark room in the shipwreck. The printed name of the cargo hold is "Within the wreck, in the cargo hold". The description of the cargo hold is "[If the location encloses the lit torch]I was floating in the middle of an empty cargo space, about the size of a cathedral's choir. The light of my torch penetrated only as far as the second deck down the loading shaft, towards the [bold type]north[roman type]. The hatch onto the main deck was to the [bold type]south[roman type] and there was a bulkhead to the [bold type]west[roman type][else]It was pitch black in there and I couldn't see a thing[end if].".

Section - Cargo Bottom

The cargo bottom is a privately-named dark room in the shipwreck. The printed name of the cargo bottom is "Within the wreck, at the bottom of the cargo hold". The description of the cargo bottom is "[If the location encloses the lit torch]Before me lay the floor of the cargo hold, now a wall as high as the ship was wide. The loading shaft to the [bold type]south[roman type] led further up the empty cargo hold. There was a bulkhead to the [bold type]east[roman type][else]It was pitch black in there and I couldn't see a thing[end if].".
The cargo bottom is north of the cargo hold.

[Section - Cylinder Room

The cylinder room is a privately-named dark room in the shipwreck. The printed name of the cylinder room is "Within the wreck, on the upper engine deck". The description of the cylinder room is "[If the location encloses the lit torch]A row of cylinder heads was visible in the light beam of my torch. There were bulkheads to the [bold type]east[roman type] and [bold type]west[roman type], as well as a narrow ladder that led [bold type]north[roman type].".

A bulkhead called the cylinder-hold bulkhead is east of cargo hold and west of the cylinder room.

The cylinder heads are plural-named scenery in the cylinder room. The description of the cylinder heads is "Eight cast-iron lids, about two meters in diameter, one for each of the engine's cylinders.".
Understand "machine/machines/machinery", "cylinder/cylinders", "cylinder head", "lid/lids", "cast-iron", "iron" and  "engine/engines" as the cylinder heads when the location is the cylinder room.

The access ladder is a staircase. The access ladder is north of the cylinder room and south of the engine room.]

Section - Engine Room

The engine room is a privately-named dark room in the shipwreck. The printed name of the engine room is "Within the wreck, in the engine room". The description of the engine room is "[If the location encloses the lit torch]The ship's four-cylinder diesel engine occupied this space, which also held some other machinery. There were bulkheads to the [bold type]east[roman type] and [bold type]west[roman type], as well as a small hatch to the [bold type]north[roman type][else]It was pitch black in there and I couldn't see a thing[end if]."

A bulkhead called the engine-hold bulkhead  is east of cargo bottom and west of the engine room.

The diesel engine is backdrop in the engine room and in the shaft tunnel. The description of the diesel engine is "An immensely powerful piece of machinery."
Understand "motor/cylinder" and "cylinders" as the diesel engine when the location is the engine room.

The seacocks are plural-named scenery in the engine room. The description of the seacocks is "These were used to regulate the amount of ballast water in the bilge by opening or closing the kingston valves. All of them were in the fully open position.".
 
Check turning the seacocks:
	say "A useless exercise in the current state of the vessel.";
	stop the action;

Check closing the seacocks:
	say "A useless exercise in the current state of the vessel.";
	stop the action;

Understand "valves/valve/seacock/machine/machines/machinery/kingston" and "kingston valve" as the seacocks.

The shaft hatch is a staircase. The shaft hatch is north of the engine room and south of shaft_alley_east. The description of the shaft hatch is "Really just a manhole in the deck."
Understand "trap door" and "deck hatch" as the shaft hatch.

Section - Auxiliary Fuel storage

The Auxiliary Fuel Storage is a privately-named dark room in the shipwreck. The printed name of the Auxiliary Fuel Storage is "Within the wreck, in the auxiliary fuel storage." The description of the Auxiliary Fuel Storage is "[If the location encloses the lit torch]Fuel for a number of small combustion engines throughout the ship was stored in this compartment. The exit was to the [bold type]west[roman type][else]It was pitch black in there and I couldn't see a thing[end if]." 

A bulkhead called the fuel-engine bulkhead is east of the engine room and west of the Auxiliary Fuel Storage. The fuel-engine bulkhead is locked.

One full jerrycan is in the Auxiliary Fuel Storage.

Section - Shaft alley

shaft_alley_east is a privately-named dark room in the shipwreck. The printed name of shaft_alley_east is "Within the wreck, in the shaft alley, by the engine". The description of shaft_alley_east is "[If the location encloses the lit torch]The propeller shaft extended from the engine towards the stern of the ship to the [bold type]west[roman type], where it disappeared into the darkness. A hatch to the [bold type]south[roman type] led to the engine room[else]It was pitch black in there and I couldn't see a thing[end if]."

The propeller shaft is backdrop in shaft_alley_east and in shaft_alley_west. The description of the propeller shaft is "A solid steel tube with a diameter of about 60cm that connected the ship's propeller to the engine.".
Understand "propulsion shaft" as the propeller shaft.

shaft_alley_west is a privately-named dark air bubble in the shipwreck. The printed name of shaft_alley_west is "Within the wreck, in a pocket of air at the stuffing box." The description of shaft_alley_west is "[If the location encloses the lit torch]At the aft end of the propeller shaft, where it entered the stuffing box, was a pocket of trapped air, perhaps 30 or so cubic meters in volume. The propeller shaft continued to the [bold type]east[roman type] and there was an escape tunnel to the [bold type]south[roman type][else]It was pitch black in there and I couldn't see a thing[end if]."

shaft_alley_west is west of shaft_alley_east.

The air is backdrop in shaft_alley_west. The description of the air is "A scarce amenity in this place."

The stuffing box is scenery in shaft_alley_west. The description of the stuffing box is "A kind of seal that is watertight but does not impede the rotary movement of the propeller shaft."

Section - Escape tunnel

The escape tunnel is a privately-named dark room in the shipwreck. The printed name of the escape tunnel is "Within the wreck, in the rear escape shaft.". The description of the escape tunnel is "[If the location encloses the lit torch]This narrow shaft served as an emergency escape from the most inaccessible parts of the ship. It contained a ladder, as would normally be needed to traverse the vertical shaft - but now it went from [bold type]north[roman type] to [bold type]south[roman type], of course[else]It was pitch black in there and I couldn't see a thing[end if]."

The escape tunnel is south of shaft_alley_west.

The escape hatch is a staircase. The escape hatch is north of the steering gear compartment and south of the escape tunnel. The description of the escape hatch is "Really just a manhole in the deck."
Understand "trap door" and "deck hatch" as the escape hatch.

The escape ladder is scenery in the escape tunnel.

Section - Steering gear compartment

The steering gear compartment is a privately-named dark room in the shipwreck. The printed name of the steering gear compartment is "Within the wreck, in the steering gear compartment". The description of the steering gear compartment is "[If the location encloses the lit torch]This compartment contained the ship's steering engine. There was a staircase to the deck above, now to the [bold type]south[roman type], as well as a small hatch to the [bold type]north[roman type][else]It was pitch black in there and I couldn't see a thing[end if]."

The lower deck stairs are a staircase. The lower deck stairs are south of the steering gear compartment and north of the galley.

[A bulkhead called the steering-hold bulkhead is west of cargo bottom and east of the steering gear compartment.]

The rudder machine is scenery in the steering gear compartment. The description of the rudder machine is "A machine to amplify the movement of the ship's wheel in order to exact enough force on the rudder to change the direction of movement."
Understand " machine/machinery", "steering engine" and "steering gear" as the rudder machine.

Section - Galley

The galley is a privately-named dark room in the shipwreck. The printed name of the galley is "Within the wreck, in the galley". The description of the galley is "[If the location encloses the lit torch]This was where the meals had been prepared prior to the sinking of the vessel. All the china had fallen from the cabinets and was strewn across the floor. There were bulkheads to the [bold type]east[roman type] and [bold type]west[roman type], as well as a staircase, that now led [bold type]north[roman type][else]It was pitch black in there and I couldn't see a thing[end if].".

A bulkhead called the galley-hold bulkhead is west of cargo hold and east of the galley.

The broken porcelain is privately-named scenery in the galley. The description of the broken porcelain is "The innards of the cabinets had fallen to the floor plate, cup and saucer ,when the ship hit the seabed.".
Understand "plate/cup/saucer/china" and "broken china" as the broken porcelain.

Check taking the broken porcelain:
	say "I had no need for broken china. Besides, I might have cut myself trying to pick it up.";
	stop the action.

The galley cabinets are a plural-named closet in the galley. The galley cabinets are open. The initial appearance of the galley cabinets is "Galley cabinets lined the walls.". The description of the Galley cabinets is "These would have held all the china that was lying on the floor. One of them contained a stack of three drawers."
A part of the galley cabinets is a drawer called the top drawer. 
A part of the galley cabinets is a drawer called the middle drawer.
A part of the galley cabinets is a drawer called the bottom drawer.

Section - Pantry

The pantry is a privately-named dark room in the shipwreck. The printed name of the pantry is "In the pantry of the shipwreck." The description of the pantry is "[If the location encloses the lit torch]The food supplies of the ship lay strewn across the pantry. The exit was to the [bold type]east[roman type][else]It was pitch black in there and I couldn't see a thing[end if]."

A bulkhead called the pantry-galley bulkhead is east of the pantry and west of the galley. The pantry-galley bulkhead is locked.

The food is scenery in the pantry. The description of the food is "All that was needed to feed a hungry crew."
Instead of doing anything other than examining with the food:
	say "I wasn't interested in the [italic type]food[roman type]."	
Understand "canned/food/supplies" and "food supplies" as the food.

A bottle of cut brandy is a closed, watertight, openable, portable, transparent fluid container in the pantry. The description of the bottle of cut brandy is "Mostly rectified spirit."
A part of the bottle of cut brandy is a screw cap. The description of the bottle cap is "The bottle cap protected the contents against the elements."
Understand "bottle cap" as the screw cap.
The bottle of cut brandy can be alcoholic. The bottle of cut brandy is alcoholic.
The bottle of cut brandy can be armed. The bottle of cut brandy is not armed.
Does the player mean doing anything with the screw cap: it is unlikely. 
Understand "brandy bottle" and "cut bottle" as the bottle of cut brandy.
Understand "molotov", "cocktail" and "molotov cocktail" as the bottle of cut brandy.

Understand "unscrew [bottle of cut brandy]" as opening.
Understand "unscrew [screw cap]" as opening.

Instead of opening the screw cap:
	try opening the bottle of cut brandy;
	
Instead of closing the screw cap:
	try closing the bottle of cut brandy;

Check opening the bottle of cut brandy:
	if the location is in subsurface and the location is not an air bubble:
		say "Opening the bottle under water would have spoiled the contents.";
		stop the action;

Check swimming when the player carries the bottle of cut brandy:
	if the bottle of cut brandy is open:
		say "(first closing the bottle)";
		try silently closing the bottle of cut brandy;
		if the bottle of cut brandy is open:
			say "I wasn't going to spoil the contents of the bottle with sea water.";
			stop the action;
		else:
			continue the action.

Check going to a room in subsurface when the player carries the bottle of cut brandy:
	if the bottle of cut brandy is open:
		say "(first closing the bottle)";
		try silently closing the bottle of cut brandy;
		if the bottle of cut brandy is open:
			say "I wasn't going to spoil the contents of the bottle with sea water.";
			stop the action;
		else:
			continue the action.

Understand "drink from [bottle of cut brandy]" as drinking.

Instead of drinking the bottle of cut brandy:
	say "No thank you. I'd have wanted to avoid that as far as possible.";

Check inserting something into the bottle of cut brandy:
	if the noun are not the tickets or the bottle of cut brandy is full:
		say "Few things would fit inside this bottle and fewer still would be easily retrieved. [The noun] was not one of them.";
		stop the action;

Check inserting the tickets into the bottle of cut brandy:
	if the bottle of cut brandy is closed:
		say "(first opening the bottle)";
		try opening the bottle of cut brandy;
		if the bottle of cut brandy is closed:	
			say "I would have to open the bottle first.";
			stop the action;	

Carry out inserting the tickets into the bottle of cut brandy:
	now the current hint is "mix_molotov".

Check taking something from the bottle of cut brandy:
	if the bottle of cut brandy is closed:
		say "(first opening the bottle)";
		try opening the bottle of cut brandy;
		if the bottle of cut brandy is closed:	
			say "I would have to open the bottle first.";
			stop the action;

Check pouring something into the bottle of cut brandy:
	if the bottle of cut brandy is closed:
		say "(first opening the bottle)";
		try opening the bottle of cut brandy;
		if the bottle of cut brandy is closed:	
			say "I would have to open the bottle first.";
			stop the action;

Check pouring the bottle of cut brandy into something:
	if the bottle of cut brandy is alcoholic or the bottle of cut brandy is armed:
		say "Better to keep it bottled up.";
	else if the bottle of cut brandy is closed:
		say "(first opening the bottle)";
		try opening the bottle of cut brandy;
		if the bottle of cut brandy is closed:	
			say "I would have to open the bottle first.";
			stop the action;

Check pouring something into the bottle of cut brandy:
	let x be a random thing in the second noun;
	unless x is nothing:
		say "Better not. I didn't want to spoil the contents of the bottle.";
		stop the action;
		
Carry out pouring the bath tub into the bottle of cut brandy:
	if the bath tub is jellied:
		now the printed name of the bottle of cut brandy is "molovtov cocktail";
		now the description of the bottle of cut brandy is "That should provide for an interesting evening.";
		now the bottle of cut brandy is armed;
		now the current hint is "back_to_revolutionaries".

Book - Streets

The sky is backdrop in the streets and in the bay. Understand "clouds/cloud/sun/blue/summer/dark/night" as the sky. The Description of the sky is "[if the location is detailed][ceilingdetail for the location][else if the third act is happening]A picture-perfect Tokyo sunset.[else if the location is in the streets]The sun shone on the city mercilessly, its reflection in the washed-out concrete almost white.[else if the location is in the bay]The perfectly blue sky spanned from one end of the bay to the other.[else if the location is the river shore]Dark clouds hung low in the black sky."
The sky is in the river shore. 
The buildings are plural-named backdrop in the streets. Understand "house/building/houses/buildings/wall/walls" as the buildings. "[if the location is detailed][walldetail for the location][else]Whatever their colour once had been, the walls of the buildings around me had been bleached white by the sun."
The ground is backdrop in the streets. Understand "street/streets/pavement/concrete/floor/surface" as the ground. "[If the location is detailed][floordetail for location][else]Just above the ground was a layer of air so hot, the pavement seemed to move beneath my feet."

Chapter - The Docklands

Docklands are a plural-named room in the streets. The printed name is "On the docklands promenade". The description is "This artificial island had been build as an extension to Gotomomi's harbour, but the bridge that usually connected it to the rest of the city was currently undergoing repair. The docklands were thus, for all intends and purposes, cut off. To the [bold type]east[roman type] the 'Seng Heng fish packing co. ltd.' occupied the ground floors of several adjacent buildings. A ladder of rusty rungs cemented into the quay wall [bold type]descended[roman type] to the pier below. A little passage disappeared between the buildings to the [bold type]south[roman type]. Someone had forgotten to remove the old [bold type]telephone booth[roman type] on the promenade."
Docklands are inspiring.

The artificial island is backdrop in the Docklands and in Boatpier. The description is "I was standing right on it."
Understand "docklands" as the artificial island.
Gotomomi is backdrop. It is everywhere. The description is "[if the third act is happening]A vast [italic type]brick-a-brack[roman type] of glass and concrete, currently glittering like gold and shining in bright purple, respectively.[else]The city ate up everything, and not at all slowly. Physical, moral, aspirational: everything. It was all around and inside of me."
Understand "city" and "tokyo" as Gotomomi. 
[The booths are plural-named backdrop. The description of the booths is "The booths on the quay had all been razed by the department of public health."
Understand "booth/cabin/cabins/shack/shacks/hut/huts" as the booths.]

The telephone booth is an enterable, transparent container in the docklands. The telephone booth is scenery. The description of the telephone booth is "A NTT public phone in a man-sized box with long-smashed windows."

Understand "phone booth" and "phone box" as the telephone booth.

A slot is a kind of container. 

The pay phone is a supporter in the telephone booth. The pay phone is scenery. The pay phone is not enterable. The description of the pay phone is "A  PT-92 payphone, painted in a faded lime green that told of its [italic type]enko[roman type] days. Amazingly, it was still a complete set of receiver, dialling pad, display and money slot."
Understand "telephone", "payphone", "lime green", "lime/green", "PT-92", "PT-92B" and "public phone" as the pay phone.
The dialling pad is part of the pay phone. The description of the dialling pad is "This was where one dialled the phone number one wished to ring up."
Understand "key pad" as the dialling pad.
The display is part of the pay phone. The description of the display is "One of those old greenish displays that you can't read unless you're standing in just the right place. It showed: [the output  of the pay phone ]."
A slot called the money slot is part of the pay phone. The description of the money slot is "This was where the money went in."
[The coin return box is part of the pay phone. The coin return box is an open container. The description of the coin return box is "This was where the money came out, if any was left."]
The receiver is part of the pay phone. The description of the receiver is "This contraption combined mouth- and earpiece in one. [if raised]I was holding it to my ear[else if lowered]It was hung up, right now[end if]."
The receiver can be raised or lowered. The receiver is lowered.
An operation mode is a kind of value. The operation modes are off, standby, ready, online, connecting, connected, disconnected, programming.
The pay phone has an operation mode. The operation mode of the pay phone is usually standby.
The pay phone has a number called the endpoint. The endpoint is 0000.
The pay phone has a text called the output. The output is "----".


Before doing anything with the pay phone when the player is not in the telephone booth:
	say "I needed to be inside the telephone booth before I could reach the phone.";
	stop the action.

Before doing anything with something that is part of the pay phone when the player is not in the telephone booth:
	say "I needed to be inside the telephone booth before I could reach the phone.";
	stop the action.

Instead of taking the receiver:
	if the receiver is lowered:
		now the receiver is raised;
		unless the operation mode of the pay phone is programming:
			now the operation mode of the pay phone is ready;
			now the output of the pay phone is "COIN";
		say "I picked up the receiver.";
	else:
		say "I was already holding the receiver to my ear."; 
		stop the action;
		
Understand "lift [receiver]" and "pick up [receiver]" as taking.

Instead of dropping the receiver:
	if the receiver is raised:
		now the receiver is lowered;
		now the output of the pay phone is "----";
		say "I hung up the receiver.";
		if the operation mode of the pay phone is connecting or the operation mode of the pay phone is online:
			now the operation mode of the pay phone is standby;
			Let X be a random thing in the money slot;
			unless X is nothing:
				now the player carries X;
				say "I took out [the X].";
		else if the operation mode of the pay phone is disconnected:
			now the operation mode of the pay phone is standby;
			say "The telephone rattled down the contents of the coin register.";
		else:
			now the operation mode of the pay phone is standby;
	else:
		say "The receiver had already been replaced.";
		stop the action.
 
Understand "replace [receiver]", "hang up [receiver]" and "return [receiver]" as dropping.

Check exiting from the telephone booth:
	if the receiver is raised:
		say "(first hanging up the receiver)[line break]";
		try silently dropping the receiver;
		continue the action.
		
Check inserting something into the money slot:
	if the receiver is lowered:
		say "(first picking up the receiver)[line break]";
		try silently taking the receiver;
		continue the action;

Check inserting something into the pay phone:
	try inserting the noun into the money slot;
	stop the action;

Check inserting something into the money slot:
	if the noun is not the jeton and the noun is not the coin:
		say "That would probably have stopped the phone from working.";
		stop the action;
	else if the operation mode of the pay phone is not ready:
		say "[The noun] came right back out of the phone.";
		stop the action;

Carry out inserting something into the money slot:
	now the operation mode of the pay phone is online;

Report inserting something into the money slot:
	say "I inserted [the noun] into the slot and a moment later I heard the dial tone." instead;

Check taking something from the money slot:
	say "Once it was in, it wouldn't come out again.";
	stop the action.

Dialling is an action applying to one number.
Understand "push [number]", "type [number]", "select [number]", "dial [number]", "ring [number]", "ring up [number]" and "press [number]" as dialling.

Check dialling:
	if the player is not in the telephone booth:
		say "I couldn't use the telephone unless I was inside the booth.";
		stop the action;
	if the number understood < 0:
		say "There was no minus-sign on the dialling pad.";
		stop the action.

Check dialling when the receiver is lowered:
	Let N be the number understood;
	if the operation mode of the pay phone is standby and N is 4711:
		now the operation mode of the pay phone is programming;
		now the output of the pay phone is "PROG";
		say "The display switched to [output of the pay phone][paragraph break]";
		stop the action;
	else:
		say "Nothing obvious happened. I would have to pick up the receiver first.";
		stop the action;

Check dialling when the receiver is raised:
	if the operation mode of the pay phone is online or the operation mode of the pay phone is programming:
		continue the action;
	else if the operation mode of the pay phone is ready:
		now the output of the pay phone is "COIN";
		say "I dialled the combination, and the display flashed: [output of the pay phone][paragraph break]";
		stop the action;
	else:
		say "Nothing obvious happened. I would have to replace the receiver first.";
		stop the action;

Carry out dialling:
	let N be the number understood;
	now the endpoint of the pay phone is N;
	now the output of the pay phone is "[endpoint of the pay phone]";
	now the operation mode of the pay phone is connecting;

Report dialling:
	say "I pushed the combination and the display changed to: [output of the pay phone]".

[Does the player mean doing something other than examining or entering or exiting with the telephone booth: it is unlikely.]

The bridge is backdrop in the Docklands and in Boatpier. The description is "The old iron railway bridge to the north connected the island to the rest of the city. It was currently undergoing repair, or rather, the surface had been removed a while ago and it had remained impassable ever since."
Understand "railway bridge", "railway", "old bridge", "old railway", "old railway bridge", "iron bridge", "iron" and "repairs" as the bridge.
Check going north in the Docklands:
	say "The bridge was currently impassable and would, by the looks of it, remain so for years to come .";
	stop the action.

Check going west in the Docklands:
	try going down instead.

Instead of going inside in the Docklands:
	try entering the telephone booth.

The fish factory is backdrop in the Docklands. The description of the fish factory is "This business had apparently bought up many of the storefronts around here and boarded them up to keep out curious eyes. It made for a rather hap-hazard setup."
Understand "seng heng", "storefront", "storefronts", "boards", "packing", "ground floors", and "ground floor" as the fish factory when the location is Docklands.

The alleyway is backdrop in the Docklands and in the dark alley. The description of the alleyway is "A little passage, its darkness all the more pronounced when seen from the sunlit promenade." Understand "alley", "alleyway", "darkness", "narrow", "narrow alley", "passage", "little passage", "dark passage" and "narrow passage" as the alleyway when the location is the Docklands or the location is the dark alley.

Chapter - The fish yard

The fish yard is a room in the streets. The printed name of the fish yard is "In the yard of the fish factory". The description of the fish yard is "This yard, hemmed in between tall buildings, was were the catch was unloaded directly into a large chute that fed into the underground fish tank. A tall gate to the [bold type]west[roman type] closed off the property."
The fish yard is south of the back window.
The fish yard is detailed.
The ceilingtext of the dark alley is "High above me, a small piece of sky remained visible."
The walltext of the dark alley is "Tall buildings surrounded the yard, their walls blackened through time by the unwavering shadows."
The floortext of the dark alley is "The yards concrete surface had seen better days."

The chute is a scenery container in the fish yard. It is open and not enterable. The description of the chute is "A funnel, large enough to empty a dumping lorry into. It led directly into the underground fish tank from which the automated processes of the factory were fed. There was a sign on it that said: 'Stay away. Danger to life!'"
Understand "funnel" and "sign" as the chute.
Check entering the chute:
	say "That would have been suicide.";
	stop the action.
Check inserting something into the chute:
	if the noun is not the mess:
		say "It I'd dropped [the noun] down the chute, it would have become subject to the dreadful efficiency of the factory's machines, never to be seen again.";
		stop the action.
Check inserting the mess into the chute:
	if the mess is not stripped:
		say "Better not. She was still wearing her clothes. The factory's machinery might have choked on that.";
		stop the action. 
Report inserting something into the chute:
	say "I dropped [the noun] down the chute and watched it sink, until it had disappeared completely into the darkness." instead.
After inserting the mess into the chute:
	now the mess is nowhere;
	continue the action.
	
The tall gate is a scenery door. The tall gate is lockable and locked. The description of the tall gate is "A rusty metal gate, too tall to climb."
The tall gate is west of the fish yard and east of the dark alley.
Check unlocking keylessly the tall gate:
	if the tall gate is unlocked:
		 say "The gate was already unlocked.";
		stop the action;
	else:
		try pulling the latch instead.
Check locking keylessly the tall gate:
	if the tall gate is locked:
		say "The gate was already securely locked.";
		stop the action;
	else:
		try pushing the latch instead.
Check locking the tall gate with something:
	say "The gate locked with a latch, not with a key.";
	stop the action.
Check unlocking the tall gate with something:
	say "The gate locked with a latch, not with a key.";
	stop the action.
The latch is part of the tall gate. "A latch that locked the gate."
Understand "knob" as the latch.
Check pushing the latch:
	if the tall gate is locked:
		say "The gate was already locked.";
		stop the action;
	else if the location is not the fish yard:
		say "The latch was on the other side." instead;
	else:
		continue the action.
Carry out pushing the latch:
	now the tall gate is locked.
Report pushing the latch:
	say "I pushed the latch, and the gate was locked." instead.
Check pulling the latch:
	if the tall gate is unlocked:
		say "The gate was already unlocked.";
		stop the action;
	else if the location is not the fish yard:
		say "The latch was on the other side." instead;
	else:
		continue the action.
Carry out pulling the latch:
		now the tall gate is unlocked.
Report pulling the latch: 
		say "I pulled the latch, and the gate was unlocked." instead.

Chapter - The dark alley

The dark alley is a room in the streets. The printed name of the dark alley is "In a dark alley". The description of the dark alley is "Almost all sunlight was blocked out of this little alleyway by the tenement building to the [bold type]west[roman type]. A tall gate guarded the property to the [bold type]east[roman type]. The Docklands were to the [bold type]north[roman type]."
The dark alley is south of the Docklands.
The dark alley is detailed.
The ceilingtext of the fish yard is "High above me, a small piece of sky remained visible."
The walltext of the fish yard is "Tall buildings surrounded the alley, their walls blackened through time by the unwavering shadows."
The floortext of the fish yard is "The street's concrete surface had seen better days."

The apartment building is backdrop in the dark alley. The description of the apartment building is "This building had been around for about a hundred years. In any other place in this country, it would have been a museum. Not here though, as was immediately apparent from the state it was in." Understand "tenement", "residential building", "tenement house", "apartment house" and "boarding house" as the apartment building when the location is the dark alley. 

Check the player going north in the dark alley:
	if the player carries the mess:
		say "I'd rather not be seen on the promenade. I much preferred the shadowy alleys, given my luggage.";
		stop the action.
	
After going to the dark alley during waste disposal:
	if the room gone from is not the fish yard:
		now the previous hint is the current hint;
		now the current hint is "gate_closed";
	continue the action;

After going from the dark alley during waste disposal:
	now the current hint is the previous hint;
	continue the action;

Book - Factory

Understand "tiles" as the walls when the location is in the factory.
Understand "skylight/skylights" as the ceiling when the location is in the factory.
Understand "concrete" as the floor when the location is in the factory.

Chapter - The packing room

The entrance door is a door. The entrance door is east of Docklands. The entrance door is scenery.

Report an actor opening the entrance door:
	if the actor is not the player:
		do nothing instead.

The packing room is a room in the factory. The printed name of the packing room is "In the packing room of 'Seng Heng fish packing co. ltd.'". The description of the packing room is "This hall seemed to be the end of the production line of the factory. A steady flow of tin cans came down a conveyor belt that entered the room from the [bold type]east[roman type]. The room to the [bold type]south[roman type] was the factory office and the exit to the promenade was to the [bold type]west[roman type].".
The packing room is inspiring.

The packing room is east of the entrance door .The packing room is in the factory.

Check going east in the packing room when Out of tape is not happening:
	deliver the Packers_no_way quip;
	stop the action.

Check going west in the packing room when the player is hired:
	deliver the Packers_no_escape quip;
	stop the action.

Check going west in the packing room when the player carries tape:
	deliver the Packers_no_stealing quip;
	stop the action.

There are 5 unfilled unsealed cardboard boxes in the packing room.

Chapter - The office

The factory office is a room in the factory. The printed name is "In the office of the fish factory". The description of the factory office is "The office hadn't changed since the last time I'd seen it: the furniture was still the same, and so was the manager. To the [bold type]north[roman type] was the rest of the factory."
The factory office is south of the packing room. The factory office is in the factory.

The furniture is plural-named scenery in the factory office. The description of the furniture is "The desk was an abomination of plywood and chrome-coloured plastic, the swivel chair tried in vain to look respectable."
Understand "desk/plastic/plywood/chrome/plastic/chair/seat", "swivel chair" and "writing desk" as the furniture when the location is the factory office.

Chapter - Hall

The hall is a region. The hall is in the factory.
The maintenance tunnel is backdrop. It is in Filleting_space, Chilling_space, Filleting_tunnel and Chilling_tunnel. The description of the maintenance tunnel is "This crawlspace afforded access to parts of the machinery otherwise unreachable."
Understand "service tunnel", "crawlspace" and "crawl space" as the maintenance tunnel.
The catwalk is backdrop. It is in Washing_space, Washing_walk, Heading_walk and Heading_space. The description of the catwalk is "This elevated walkway afforded access to parts of the machinery otherwise unreachable."

A gallery is a kind of room.
A crawlspace is a kind of room.

The conveyor belt is backdrop. The description of the conveyor belt is "[if the location is the packing room]A steady procession of tin cans came down the conveyor belt."
The conveyor belt is in the packing room and the hall.

The tins are plural-named backdrop. The description is "'Sardines in olive oil', said the label in Vietnamese." The tins are in the packing room and the hall.
Understand "tin can/cans/sardine" and "can/cans/sardines" as the tins.

Check taking the tins:
	say "I had no need for tin cans.";
	stop the action.

Check putting something on the conveyor belt:
	say "That would have been a sure way to loose [the noun].";
	stop the action.

Check entering the conveyor belt:
	say "The work safety authority prohibited stepping onto industrial conveyor belts.";
	stop the action.

Section - Soldering space

Soldering_space is a privately-named room in the hall. The printed name of Soldering_space is "In the machinery space, by the soldering machine". The description of Soldering_space is "The production floor was filled from one end to the other with fish-processing machinery. The apparatus beside me was for soldering the tin cans shut. More machinery was to the [bold type]east[roman type] and [bold type]south[roman type]. The packing room was to the [bold type]west[roman type]."
Soldering_space is east of the packing room.
The soldering machine is a machine in Soldering_space. The description of the soldering machine is "The machine soldered the tin cans shut."
Understand "tin can/cans", "tin/tins" and "can/cans" as the soldering machine when the location is Soldering_space. 

Section - Tinning space

Tinning_space is a privately-named room in the hall. The printed name of Tinning_space is "In the machinery space, by the tin filler". The description of Tinning_space is "I was standing beside the machine that filled the tin cans with the processed fish. There was more machinery to the [bold type]west[roman type] and [bold type]south[roman type]."
Tinning_space is east of Soldering_space.
The tin filler is a machine in Tinning_space. The description of the tin filler is "This was were the tin cans were filled with the processed fish."
Understand "tin can/cans", "tin/tins" and "can/cans" as the tin filler when the location is Soldering_space.

Section - Washing space

Washing_space is a privately-named room in the hall. The printed name of Washing_space is "In the machinery space, by the fish washer". The description of Washing_space is "This was were the fillets were washed for shipment. There was more machinery to the [bold type]north[roman type] and [bold type]south[roman type]. A ladder led [bold type]up[roman type] to the catwalks."
Washing_space is south of Tinning_space.
The fish washer is a machine in Washing_space. The description of the fish washer is "Designed for effective washing and drying of fillets, the machine consisted of a spooling and blower tunnel. The spooling and blower tunnel had a conveyor with adjustable speed to carry the fish."
Understand "blower tunnel", "spooling tunnel", "tunnel", "blower", "spooling" and "conveyor" as the fish washer when the location is Washing_space.

Section - Skinning space

Skinning_space is a privately-named room in the hall. The printed name of Skinning_space is "In the machinery space, by the skinning machine". The description of Skinning_space is "Here, the skin was peeled off the fish in a large machine. Further machinery was to the [bold type]north[roman type] and [bold type]south[roman type]."
Skinning_space is south of Soldering_space.
The skinning machine is a machine in Skinning_space. The description of the skinning machine is "Build for skinning large fish fillets. The fillets were fed onto the drum from the top where the surface of the skin froze to the cold drum. A rotating band knife cut the fillets away from the skin and the skin was then scraped off the drum. The depth of the cut could be adjusted."
Understand "drum/large" as the skinning machine.

Section - Filleting space

Filleting_space is a privately-named room in the hall. The printed name of Filleting_space is "In the machinery space, by the filleting machine". The description of the Filleting_space is "I was standing beside the factory's filleting apparatus. More machinery was to the [bold type]north[roman type] and [bold type]east[roman type]. A ladder went [bold type]down[roman type] into a maintenance tunnel."
Filleting_space is south of Skinning_space.
The filleting machine is a machine in Filleting_space. The description of the filleting machine is "An advanced filleting machine. It was designed with respect to yield, hygiene, performance and fillet quality."
Understand "filleting apparatus" as the filleting machine when the location is Filleting_space.

Section - Pinbone space

Pinbone_space is a privately-named room in the hall. The printed name of Pinbone_space is "In the machinery space, by the pinbone remover". The description of Pinbone_space is "Beside me stood a device to pull the pinbones out of the fish. There was more machinery to the [bold type]north[roman type] and [bold type]west[roman type]."
Pinbone_space is south of Washing_space and east of Filleting_space.
The pinbone remover is a machine in Pinbone_space. The description of the pinbone remover is "This Pinbone Remover had better grip than other pinboning machines due to patented double grip rollers. A better grip meant better yield as there was no need for aggressive machine settings."
Understand "patented/rollers", "patented rollers" and "double grip rollers" as the pinbone remover.

Section - Washing walk

Washing_walk is a privately-named gallery in the hall. The printed name of Washing_walk is "On the catwalk, above the fish washer". The description of Washing_walk is "This catwalk allowed monitoring and maintenance of machinery. A ladder went [bold type]down[roman type] to the fish washer. The catwalk continued towards the [bold type]south[roman type]."
The fish_washer is privately-named backdrop in the Washing_walk. The printed name of the fish_washer is "fish washer". The description of the fish_washer is "Designed for effective washing and drying of fillets, the machine consisted of a spooling and blower tunnel. The spooling and blower tunnel had a conveyor with adjustable speed to carry the fish."
Instead of doing anything other than examining with the fish_washer, say "I couldn't reach it from here."

Understand "blower tunnel", "spooling tunnel", "tunnel", "blower", "spooling", "washer", "fish washer", "apparatus", "machine" and "conveyor" as the fish_washer when the location is Washing_walk.
A privately-named staircase called washing_ladder is above Washing_space and below Washing_walk. The printed name of washing_ladder is "ladder".

Section - Heading walk

Heading_walk is a privately-named gallery in the hall. The printed name of Heading_walk is "On the catwalk, above the heading machine". The description of Heading_walk is "This catwalk allowed monitoring and maintenance of machinery. A ladder went [bold type]down[roman type] to the heading machine. The catwalk continued towards the [bold type]north[roman type].".
Heading_walk is south of Washing_walk.
The heading_machine is privately-named backdrop in Heading_walk. The printed name of the heading_machine is "heading machine". The description of the heading_machine is "The result of this machine's operation was a perfect U-cut which left the neck flesh on the trunk, increasing yield to the maximum. The cutting result was independent of the skill of the operator as the fish was automatically positioned in the proper position, and because the fish was transported in fish trays through the machine."
Understand "heading machine", "machine", "apparatus", "fish tray/trays" and "tray/trays" as the heading_machine when the location is heading_walk.
A privately-named staircase called heading_ladder is above Heading_space and below Heading_walk. The printed name of heading_ladder is "ladder".
Instead of doing anything other than examining with the heading_machine, say "I couldn't reach it from here."

Section - Heading space

Heading_space is a privately-named room in the hall. The printed name of Heading_space is "In the machinery space, by the heading machine". The description of Heading_space is "In this machine, the heads of the fish were separated from their bodies. There was more machinery to the [bold type]west[roman type] and a ladder led [bold type]up[roman type] onto the catwalk above."
The heading machine is a machine in Heading_space. The description of the heading machine is "The result of this machine's operation was a perfect U-cut which left the neck flesh on the trunk, increasing yield to the maximum. The cutting result was independent of the skill of the operator as the fish was automatically positioned in the proper position, and because the fish was transported in fish trays through the machine."
Understand "fish tray/trays" and "tray/trays" as the heading machine when the location is heading_space.

Section - Princess space

Princess_space is a privately-named room in the hall. The printed name of Princess_space is "In the machinery space, by the princess cutter". The description of Princess_space is "I was standing next to the fish-gutting apparatus. There was more machinery to the [bold type]east[roman type] and [bold type]south[roman type]."
Princess_space is west of Heading_space.
The princess cutter is a machine in Princess_space. The description of the princess cutter is "A gutting machine adjustable for fish size. Quick change-over between different species and sizes was done automatically."
Understand "gutting machine" and "gutter" as the princess cutter when the location is Princess_space.

Section - Chilling space

Chilling_space is a privately-named room in the hall. The printed name of Chilling_space is "In the machinery space, by the fish chiller". The description of Chilling_space is "Here I was at the chilling unit, which was used to stun the fish before they were transported to the bleeder unit. A ladder went [bold type]down[roman type] into a service tunnel. There was also a door to the [bold type]east[roman type] and to the [bold type]north[roman type] was some further machinery."
Chilling_space is south of the Princess_space.
The fish chiller is a machine in Chilling_space. The description of the fish chiller is "The system consisted of a chilling unit where the fish were stunned and gradually cooled down. From the chilling unit the fish were pushed onto an automated workbench for bleed cutting. The bleeding took place in a bleeder unit. The system was configured to suit various capacities automatically."
Understand "bleeder ", "bleeder unit", "chilling unit", "automated workbench", "automated" and "workbench" as the fish chiller when the location is Chilling_space.

Section - Chilling tunnel

Chilling_tunnel is a privately-named crawlspace in the hall. The printed name of Chilling_tunnel is "In the maintenance tunnel, below the fish chiller". The description of the Chilling_tunnel is "This tunnel lay along the underground fish tank that fed into the fish chiller, [bold type]up[roman type] from here. The tunnel continued to the [bold type]north[roman type]."
The fish_chiller is privately-named backdrop in Chilling_tunnel. The description of the fish_chiller is "The system consisted of a chilling unit where the fish were stunned and gradually cooled down. From the chilling unit the fish were pushed onto an automated workbench for bleed cutting. The bleeding took place in a bleeder unit. The system was configured to suit various capacities automatically."
Understand "bleeder ", "bleeder unit", "chilling unit", "automated workbench", "automated", "fish chiller", "chiller", "apparatus", "machine" and "workbench" as the fish_chiller when the location is Chilling_tunnel.
Instead of doing anything other than examining with the fish_chiller, say "I couldn't reach it from here."
The fish tank is scenery in Chilling_tunnel. The description of the fish tank is "This tank was fed from outside the factory."
A privately-named staircase called chilling_ladder is above Chilling_tunnel and below Chilling_space. The printed name of chilling_ladder is "ladder".

Section - Filleting tunnel

Filleting_tunnel is a privately-named crawlspace in the hall. The printed name of Filleting_tunnel is "In the maintenance tunnel, below the filleting machine". The description of Filleting_tunnel is "This tunnel allowed access to the bottom of the filleting machine [bold type]above[roman type]. The tunnel continued to the [bold type]south[roman type]."
Filleting_tunnel is north of Chilling_tunnel.
The filleting_machine is privately-named backdrop in Filleting_tunnel. The description of the filleting_machine is "An advanced filleting machine. It was designed with respect to yield, hygiene, performance and fillet quality."
Understand "filleting apparatus", "filleting", "apparatus" and "machine" as the filleting_machine when the location is Filleting_tunnel.
Instead of doing anything other than examining with the filleting_machine, say "I couldn't reach it from here."
A privately-named staircase called filleting_ladder is above Filleting_tunnel and below Filleting_space. The printed name of filleting_ladder is "ladder".

Section - Back room

The back room is a room in the hall. The printed name of the back room is "In the back room of the factory". The description of the back room is "A little room with a table pushed to one wall. There was a small [bold type]window[roman type] in the southern wall, high up, near the ceiling. A door to the [bold type]west[roman type] led to the machinery space."

Table of Cleaning Objects
topic		title
"bucket"	"a bucket"
"mop"		"a mop"
"sponge"	"a sponge"
"brush"	"a brush"
"boom"	"a broom"

Examining as a cleaning supply is an action applying to one topic.
Understand "examine [text]", "search [text]" and "look at [text]" as examining as a cleaning supply when the location is the back room.

Carry out examining as a cleaning supply:
	try examining the noun. 

Check examining as a cleaning supply a topic listed in the Table of Cleaning Objects when the location is the back room:
	say "It really was [title entry].";
	stop the action.

To say list the supplies:
	sort the Table of Cleaning Objects in random order;
	choose row 1 in the Table of Cleaning Objects;
	say "[title entry], ";
	choose row 2 in the Table of Cleaning Objects;
	say "[title entry] and ";
	choose row 3 in the Table of Cleaning Objects;
	say "[title entry]". 

The cleaning supplies are plural-named scenery in the back room. The description of the cleaning supplies is "There were various cleaning supplies here, such as [list the supplies]. But none of all that seemed worthy of further investigation to me at the time."
Understand "cleaning supply/item/object", "item/items/object/objects" as the cleaning supplies when the location is the back room.

The back door is a scenery door. It is west of the Back room and east of Chilling_space. The description of the back door is "A pretty normal door, really."
Understand "normal" and "normal door" as the back door.

The old table is a scenery supporter in the back room. The old table is enterable. The description of the old table is "A sturdy piece of furniture."
Understand "sturdy", "sturdy piece", "sturdy furniture" and "furniture" as the old table.

The back window is a scenery window. It is south of the Back room. The description of the back window is "A window, too high up to reach."
The back window can be hung onto. The back window is not hung onto.
Understand "southern wall" as the back window.

Carry out jumping when the location is the back room:
	now the back window is hung onto.
Report jumping when the location is the back room:
	say "I jumped up and hung on to the windowsill." instead.

Proximity relates things to each other. The verb to be near implies the proximity relation.
Putting it beneath is an action applying to two things and requiring light.
Understand "put [something] underneath/beneath/under/near [something]", "push [something] underneath/beneath/under/near/to [something]", "pull [something] underneath/beneath/under/near/to [something]", "place [something] underneath/beneath/under/near/to [something]", "set [something] underneath/beneath/under/near/to [something]", "place [something] next to [something]", "position [something] next to [something]", and "position [something] underneath/beneath/under/near/to [something]" as putting it beneath.

Before doing anything with something that is not the back window when the back window is hung onto:
	say "(first letting go of the windowsill)[line break]";
	now the back window is not hung onto.

Report putting it beneath:
	say "There was no need to do that."
Carry out putting the old table beneath the back window:
	now the noun is in the location;
	now the noun is near the second noun.
Report putting the old table beneath the back window:
	say "I pushed [the noun] underneath [the second noun]." instead.
Check pulling the old table:
	try putting the noun beneath the back window instead.
Check pushing the old table:
	try putting the noun beneath the back window instead.

Check going through the back window:
	if the back window is hung onto:
		continue the action;
	else if the player is not on the old table:
		say "I couldn't reach that high.";
		stop the action;
	else if the old table is not near the back window :
		say "I couldn't reach the window from where I was. Maybe I could have, if I placed the table closer to the window.";
		stop the action;
	else:
		continue the action.

Carry out going through the back window:
	now the back window is not hung onto.

Check opening the back window:
	if the back window is hung onto:
		continue the action;
	else if the player is not on the old table:
		say "I couldn't reach that high.";
		stop the action;
	else if the old table is not near the back window:
		say "I couldn't reach the window from where I was. Maybe I could have, if I placed the table closer to the window.";
		stop the action;
	else:
		continue the action.
		
Check closing the back window:
	if the back window is hung onto:
		continue the action;
	else if the player is not on the old table:
		say "I couldn't reach that high.";
		stop the action;
	else if the old table is not near the back window:
		say "I couldn't reach the window from where I was. Maybe I could have, if I placed the table closer to the window.";
		stop the action;
	else:
		continue the action.
		
Check hinting when the location is the back room:
	now the current hint is "climb_window";

After going from the back room to the fish yard:
	now the current hint is the previous hint;
	continue the action.

Book - Tenement

The walls are backdrop in the tenement, in the school, in the shipwreck, in the cruise ship and in the factory. Understand "wall" as the walls. The description of the walls is "[if the location is detailed][walldetail for the location][else if the location is in the tenement]The walls had once been plastered white, but had darkened considerably over the years. The plaster was coming off in some places.[else if the location is in the factory]The walls were tiled all over.[else if the location is in the shipwreck]Steel, painted grey.[else if the location is in the school]The walls of St. Agatha's catholic school for daughters had witnessed many generations of students.[else if the location is in the cruise ship]Fake wood panelling."
The ceiling is backdrop in the tenement, in the school, in the shipwreck, in the cruise ship, and in the factory. The description of the ceiling is "[if the location is detailed][ceilingdetail for the location][else if the location is in the tenement]The ceiling was home to a number of spiders.[else if the location is in the factory]There were many skylights in the ceiling.[else if the location is in the shipwreck]Steel, painted grey.[else if the location is in the school]High above me, the space between the ceiling and the next floor was probably home to many forgotten secrets.[else if the location is in the cruise ship]Fake wood panelling."
The floor is backdrop in the tenement, in the school, in the shipwreck, in the cruise ship and in the factory. The description of the floor is "[if the location is detailed][walldetail for the location][else if the location is in the tenement]The cedar floorboards had once been bright red. Now, they were almost black.[else if the location is in the factory]A reasonably clean concrete floor.[else if the location is in the shipwreck]Teak.[else if the location is in the school]How many girls had walked it before me?[else if the location is in the cruise ship]A worn carpet.".
The wood is backdrop in the tenement. Understand "black wood", "post/posts", "beam/beams" as the wood. The description of the wood is "The posts and beams, the floor boards, the ceiling: everything was made of wood."
Understand "interior" as the walls.
Understand "plank/planks/board/boards" as the floor when the location is in the tenement.
Understand "plaster" as the walls when the location is in the tenement.
Understand "beam/beams/spider/spiders" as the ceiling when the location is in the tenement.
Understand "hull" as the walls when the location is in the shipwreck or the location is in the cruise ship.
Understand "carpet/carpets/worn" and "worn carpet" as the floor when the location is in the cruise ship.
Understand "fake/wood/panelling/paneling", "fake wood paneling", "fake paneling", "fake panelling", "wood panelling", "wood paneling", "fake wood" and "fake wood panelling" as the ceiling when the location is in the cruise ship;

The tatami are backdrop. The description of the tatami is "The usual floor mats, made of bamboo-straw."
Understand "mats", "bamboo", "bamboo mats", "floor mats", "straw" and "bamboo straw" as the tatami.
The tatami are in the neighbourhood office and the 4-and-a-half.

Section - The ground floor

The ground floor is a room. The printed name of the ground floor is "Inside the tenement". The description of the ground floor is "Little light made it into the tenement's front porch, which opened to the street towards the [bold type]east[roman type]. Black wood dominated the interior. A flight of stairs went [bold type]up[roman type], another one [bold type]down[roman type], and there was a door to the [bold type]south[roman type], with a sign on it. [if last straw has happened]The place no longer reminded me much of school. [else]The place reminded me a bit of school."
The ground floor is west of the dark alley. The ground floor is in the tenement.

The office door is a door and scenery. It is south of the ground floor. The description of the office door is "A large paper sign had been attached to the door. It said 'Knock and wait for the answer!'"
Understand "sign" as the office door when the location is the ground floor.

The bottom stairs are a staircase. They are above the ground floor. The description of the lower stairs is "The staircase was practically unlit. It connected the ground floor to the first." 

Check going up in the ground floor when the Caretaker is not bribed:
		say "As I set foot on the staircase, I heard a voice from the door to the south: [One of]'Call in at the office before you head upstairs!'[or]'I heard you! Don't try to slip past me.'[or]'Are you a burglar? You won't get in unnoticed, you know. '[or]'I know you are there and I won't let you get upstairs before you've shown your face to me.'[stopping]";
		stop the action.
		
Check going down in the ground floor when the Caretaker is not bribed:
		say "As I set foot on the staircase, I heard a voice from the door to the south: [One of]'Call in at the office before you head downstairs!'[or]'I heard you! Don't try to slip past me.'[or]'Are you a burglar? You won't get in unnoticed, you know. '[or]'I know you are there and I won't let you get downstairs before you've shown your face to me.'[stopping]";
		stop the action.

The front porch is scenery in the ground floor. The description of the front porch is "I was standing right in in it."

The street is scenery in the ground floor. The description of the street is "Just a dirty back alley, really".
Understand "back alley" and "alley" as the street. 

Section - The neighbourhood office

The neighbourhood office is a room. The printed name of the neighbourhood office is "Inside the tenement, in the neighbourhood association's office". The description of the neighbourhood office is "This room was dominated by a massive writing desk, weighting down mercilessly on the [italic type]tatami[roman type]. If there was any other furniture, it had long been lost underneath the heaps of papers of all kinds, that covered every surface. The exit was to the [bold type]north[roman type]."

The neighbourhood office is south of the office door. The neighbourhood office is in the tenement. 

The writing desk is a supporter in the neighbourhood office. It is scenery. The description of the writing desk is "A hefty cypress wood writing desk, in need of polishing."
Understand "cypress" and "furniture" as the writing desk.

The papers are scenery in the neighbourhood office. The description of the papers is "They were literally everywhere. Who knows what these were all about?"
Understand "paper/stack/stacks/heap/heaps" as the papers.

Check pushing the papers:
	try taking the noun instead.
	
Check pulling the papers:
	try taking the noun instead. 

Check taking the papers:
	say "Better not touch these.";
	stop the action.

Chapter - The first floor

Section - Landing

The first floor is a room. The printed name of the first floor is "Inside the tenement, on the first floor landing." The description of the first floor is "There was not much to see in the dim light: A room to the [bold type]east[roman type], one flight of stairs going [bold type]up[roman type], and one going [bold type]down[roman type]."
The first floor is above the bottom stairs. The first floor is in the tenement.

The middle stairs are a staircase. They are above the first floor. The description of the middle stairs is "The staircase was practically unlit. It connected the first floor to the second." 

Check going up in the first floor during the first act:
	say "[one of]'I said it's on the first floor!'[or]'The first floor! It's not so difficult now, is it?'[stopping] I heard the caretaker shout from below, as I set foot on the stairs.";
	stop the action.

Section - 4-and-a-half

The 4-and-a-half is a dark changing room. The printed name of the 4-and-a-half is "Inside the tenement, in a four-and-a-half-tatami room." The description of the 4-and-a-half is "[If the window to the street is open or the 4-and-a-half encloses the lit torch]This was the smallest flat imaginable. Little more than its occupant would have fit inside. The window stood open, letting in some light.[else]The room was pitch black. Someone had closed the shutters in front of the window and the landing to the [bold type]west[roman type] couldn't spare any light itself."
The 4-and-a-half is east of the first floor. The 4-and-a-half is in the tenement.

A closet called the wall closet is in the 4-and-a-half. The description of the wall closet is "This would usually hold the [italic type]futon[roman type] during the day, plus anything else one would want to keep out of sight." The initial appearance of the wall closet is "There was also the usual wall closet, of course." The wall closet is not scenery. The wall closet is fixed in place.

Some Sandals called the geta are in the wall closet. The printed name of the geta is "[italic type]geta[roman type]". The description of the geta is "A type of sandal worn with traditional Japanese clothing."

Instead of going inside in the 4-and-a-half:
	try entering the wall closet.
	
A scenery window called the window to the street is east of the 4-and-a-half. The window to the street can be open or closed. It is closed. The window to the street is openable. The description of the window to the street is "There was nothing to see outside but the dark alley in front of the house."
Understand "shutters/shutter" as the window to the street when the location is the 4-and-a-half.
Understand "street/alley" and "dark alley" as the window to the street when the window to the street is open.
The fake street is east of the window to the street. 
Carry out opening the window to the street:
	Now the current hint is the previous hint;
	Now the 4-and-a-half is lighted;
	continue the action.
Carry out opening the window to the street for the first time:
	Now the mess is in the 4-and-a-half;
	continue the action.
Carry out closing the window to the street:
	Now the previous hint is the current hint;
	Now the 4-and-a-half is dark;
	continue the action.
Report opening the window to the street:
	say "I opened the shutters, and the darkness gave way to light." instead.

Check hinting when the location is the 4-and-a-half and the window to the street is closed:
	now the previous hint is the current hint;
	now the current hint is "open_window".

A mess is a corpse. The printed name of a mess is "[if kneeling]woman, lying very still[else if sprawled]girl's body[else if stripped]girl's naked body". The initial appearance of the mess is "[if the mess is kneeling]Someone was kneeling, slumped over forward, in the middle of the room.[else if the mess is sprawled and the location is the 4-and-a-half]The dead girl lay in the middle of the room.[else if the mess is sprawled]The girl was lying where I'd left her.[else if the mess is stripped and the location is the 4-and-a-half]The dead girl's naked body lay in the middle of the room.[else if the mess is stripped]The girl's naked body was lying where I'd left it."
The description of the mess is "[If kneeling]A girl, sunk forward, but still in a kneeling position, her arms tucked in. She was wearing what would have been quite a nice [italic type]chirimen furisode[roman type]. It was soiled now, of course.[else if sprawled]A girl, a little younger than myself, in her [italic type]furisode[roman type]. [else if stripped]Her skin was immaculate, and very pale.[end if][if the chuya obi is part of the mess] Her knees were tied together with her [italic type]obi[roman type], to preserve her kneeling posture in death.[end if][if the kaiken is part of the mess] Her hands were still clutching the [italic type]kaiken[roman type] she had presumably used to slit her throat.".
The mess can be kneeling or sprawled or stripped. The mess is kneeling.
Understand "her/person/someone/woman/girl/dead" as the mess. 
Understand "naked/skin" as the mess when the mess is stripped.

A furisode called the chirimen is part of the mess. The printed name of the chirimen is "[italic type]chirimen furisode[roman type]". The description of the chirimen is "A long-sleeved [italic type]kimono[roman type] made of Crêpe silk, with a pattern of white [italic type]ayame[roman type] on an [italic type]edo-murazaki-edo[roman type]-coloured background. [if soiled]It had been thoroughly soiled in the course of its owner's demise.[else if wet]It was still wet from getting laundered.[else if dry]It was dry now and ready to be worn."
The chirimen is soiled.

Check the player taking off the chirimen:
	if the chirimen is not worn by the player:
		try taking the noun instead.

Check taking the chirimen:
	if the chirimen is part of the mess:
		if the mess is kneeling:
			say "I would have had to turn her over first.";
			stop the action;
		else if the chuya obi is part of the mess:
			say "I would have had to take off the obi first.";
			stop the action;
		else if the mess is sprawled:
			now the chirimen is in the location;
			continue the action.

Carry out taking the chirimen:
	if the mess is sprawled:
		now the mess is stripped;
	now the previous hint is the current hint;
	now the current hint is "wash_clothes";
	continue the action.

Report taking the chirimen for the first time:
	say "I took off her kimono." instead;

A sash called a chuya obi is part of the mess. The printed name of the chuya obi is "[italic type]chuya obi[roman type]". The description of the chuya obi is "An reversible sash, of indigo colour. [if soiled]It had been thoroughly soiled in the course of its owner's demise.[else if wet]It was still wet from getting laundered.[else if dry]It was dry now and ready to be worn."
The chuya obi has cleanliness. The chuya obi is soiled.

Check the player taking off the chuya obi:
	if the chuya obi is not worn by the player:
		try taking the noun instead.

Check taking the chuya obi:
	if the chuya obi is part of the mess:
		if the mess is kneeling:
			say "I would have had to turn her over first.";
			stop the action;
		else if the mess is sprawled:
			now the chuya obi is in the location;
			continue the action.

Report taking the chuya obi:
	if the mess is sprawled:
		say "I took off her sash." instead;

A leg called the girl's left leg is part of the mess. A leg called the girl's right leg is part of the mess. An arm called the girl's left arm is part of the mess. An arm called the girl's right arm is part of the mess. A head called the girl's head is part of the mess. A torso called the girl's torso is part of the mess.
The description of the girl's left leg is "Her legs had been tied together at the knees with her sash. That way no muscle spasms could blemish her appearance in death."
The description of the girl's right leg is "Her legs had been tied together at the knees with her sash. That way no muscle spasms could blemish her appearance in death."
The description of the girl's left arm is "[if the kaiken is part of the mess]Her hands were still clutching the [italic type]kaiken[roman type].[else]Small and delicate. These hands had never done any manual work."
The description of the girl's right arm is "[if the kaiken is part of the mess]Her hands were still clutching the [italic type]kaiken[roman type].[else]Small and delicate. These hands had never done any manual work."
The description of the girl's torso is "She had been of small stature."
The description of the girl's head is "Her small face appeared as though asleep. Her throat, on the other hand, looked less attractive. The cartoid artery had been stabbed and the blade pulled across, through the trachea."
Understand "maw/trachea/cartoid/artery", "cartoid artery" and "gaping maw" as the girl's head.

Blood is part of the mess. The description of the blood is "There was a lot of blood. An artery must have been cut."

A knife called a kaiken is part of the mess. The printed name of the kaiken is "[italic type]kaiken[roman type]". The description of the kaiken is "A handy little single-edged dagger, well kept and as sharp as a straight razor."

Check taking the kaiken:
	if the kaiken is part of the mess:
		now the kaiken is in the location. 

Cutting it with is an action applying to two visible things.
Understand the command "cut" as something new. Understand the command "slice" as something new.
Understand "cut [something] with [something]" and "slice [something] with [something]" as cutting it with.

Check cutting it with:
	if the second noun is not a knife:
		say "That would hardly cut [the noun].";
		stop the action.

Check cutting it with:
	if the noun is the smiling face:
		try grappling the noun instead;		
	else if the noun is not sliceable:
		say "I had no desire to cut [the noun].";
		stop the action. 

Report cutting it with:
	say "[The second noun] went through [the noun] without any effort on my part.";

Check pulling the mess:
	try searching the noun instead.

Check pushing the mess:
	try searching the noun instead.

Check searching the mess when the mess is not kneeling:
	say "I had already turned her over once, that would have to be enough.";
	stop the action.

Carry out searching the mess:
	now the mess is sprawled.

Report searching the mess:
	say "I turned her over, laying her down on the side. I noticed how young she had been." instead.
		
Understand "shake [mess]", "roll [mess]", "roll over [mess]", "turn over [mess]", "turn [mess]", "search [mess]", "lay [mess] down" and "lay down [mess]" and "roll [mess] over" and "turn [mess] over" as searching. 

Check talking to the mess:
	say "There was no answer.";
	stop the action.

Check entering the mess:
	say "I was not going step on her.";
	stop the action.

Carry out taking the mess:
	if the kaiken is part of the mess:
		now the kaiken is in the location;
		say "As I lifted the girl up, the knife she had been holding clattered to the ground.";
	if the mess is kneeling: 
		now the mess is sprawled.

Report taking the mess from the location:
	say "I lifted the body without much effort." instead.
	
Does the player mean examining a random arm that is part of the mess: it is likely.
Does the player mean examining a random leg that is part of the mess: it is likely.
Does the player mean examining a random head that is part of the mess: it is likely.
Does the player mean examining a random torso that is part of the mess: it is likely.

Chapter - The basement

The basement is a changing room. The printed name of the basement is "Inside the tenement, in a basement."The description of the basement is "This basement served as the tenement's laundromat. Clothes lines criss-crossed the room at eye level[if at least one wearable thing is on the clothes lines], on which hung [the list of wearable things on the clothes lines][end if] and there was a washing machine in one corner. A notice had been stuck to the wall. The staircase went [bold type]up[roman type] from here."
The basement is in the tenement.

Check hinting during waste disposal:
	if the location is the basement:
		now the previous hint is the current hint;
		now the current hint is "need_jeton";

Check going from the basement:
	if the player carries wet clothing:
		say "No, no. The [random wet clothing carried by the player] still needed to be hung up to dry.";
		stop the action;
	else:
		continue the action.

Check going from the basement:
	if the player carries the chuya obi and the chuya obi is wet:
		say "No, no. The [italic type]obi[roman type] still needed to be hung up to dry.";
		stop the action;
	else:
		continue the action.

After going from the basement during waste disposal:
	now the current hint is the previous hint;
	continue the action.

The cellar stairs are a plural-named staircase. The cellar stairs are below the ground floor and above the basement.

The notice is scenery in the basement. The description of the notice is "'[italic type]Jetons[roman type] can be bought from the neighbourhood association.'"
Carry out examining the notice:
	enable the Caretaker_jeton quip for the Caretaker.

The washing machine is a scenery supporter in the basement. The description of the washing machine is "Like many washing machines, this one sported a drum, where the laundry went in, a drawer to fill in the washing powder, a slot to insert a [italic type]jeton[roman type], and a button that said 'start'."
A part of the washing machine is the drum. The drum is an openable, transparent container. The drum is open. Understand "door" as the drum. The description of the drum is "The drum had a door one had to close before the machine could be started."
A part of the washing machine is an open drawer called the washer drawer. The washer drawer is open. The description of the washer drawer is "This was where the washing powder was meant to be filled in."
A part of the washing machine is the button. The button can be switched on. The button is switched off. The description of the button is "Someone had given a lot of thought to this man-machine interface."
Understand "man-machine interface", "start button" and "start" as the button.
A part of the washing machine is a slot called the washer slot. The description of the washer slot is "Before one could use the washing machine, a [italic type]jeton[roman type] had to be inserted here."
The washing machine can be running or finished. The washing machine is finished.
Does the player mean closing the drum: it is very likely.
Does the player mean inserting something into the drum: it is very likely.

Check inserting something into the washer slot:
	if the noun is not the jeton:
		say "That would probably have stopped the machine from working.";
		stop the action.
Check taking something from the washer slot:
	say "Once it was in, it wouldn't come out again.";
	stop the action.
Check inserting something into the washer drawer:
	if the noun is not a powder tab:
		say "That might have stopped the machine from working.";
		stop the action.
Check inserting a powder tab into the washer drawer:
	if at least one powder tab is in the washer drawer:
		say "One would suffice.";
		stop the action.
Check inserting something into the drum:
	if the noun is not wearable:
		say "That didn't belong in there.";
		stop the action;
	if the noun is a hat:
		say "That certainly didn't belong in there.";
		stop the action.
		
On the washing machine is a container called the powder box. The description of the powder box is "[if empty]Now an empty box.[else]A box of powder tabs, mostly empty."
Check taking the powder box:
	say "Why should I have denied other people their fair share of the washing powder?";
	stop the action.
Check inserting something into the powder box:
	if the noun is not a powder tab:
		say "That didn't belong in there.";
		stop the action.

Check opening the washer drawer:
	if the washing machine is running:
		say "Not while the machine ran.";
		stop the action.

Does the player mean doing anything with the powder box: it is unlikely.

A powder tab is a kind of thing. The description of a powder tab is "A block of compacted washing powder, enough for one drum."
In the powder box are two powder tabs.

Check inserting something into the washing machine:
	if the noun is a powder tab:
		try inserting the noun into the washer drawer instead;
	else if the noun is the jeton:
		try inserting the noun into the washer slot instead;
	else:
		try inserting the noun into the drum instead.
Check opening the washing machine:
	try opening the drum instead.
Check opening the drum:
	if the washing machine is running:
		say "The door wouldn't open while the machine ran.";
		stop the action.
Check closing the washing machine:
	try closing the drum instead.
Check switching on the washing machine:
	try switching on the button instead.
Check pushing the button:
	try switching on the noun instead.
Check switching on the button:
	if the washer drawer is not closed:
		say "(closing the drawer first)";
		try silently closing the washer drawer;
		continue the action;
Check switching on the button:
	if the drum is not closed:
		say "(closing the drum first)";
		try silently closing the drum;
		continue the action;
Check switching on the button:
	if the washer slot is empty:
		say "Nothing happened when I pushed the button, as I had not inserted a [italic type]jeton[roman type] into the slot.";
		stop the action.
Check switching on the button:
	if the drum is empty:
		say "But why? There was no laundry in the drum.";
		stop the action.
Check switching on the button:
	if the washer drawer is empty:
		say "I needed to fill in the washing powder first.";
		stop the action.
Check switching off the washing machine:
	try switching off the button instead.
Check switching off the button:
	if the washing machine is running:
		say "Pushing buttons while the machine was still running would achieve nothing.";
		stop the action.
Carry out switching on the button:
	now the washing machine is running;
	now the Caretaker carries the jeton;
	repeat with x running through wearable things in the drum:
		now x is wet;
	The washer beeps in 25 turns from now.
Carry out opening the drum:
	let x be a random powder tab in the washer drawer;
	unless x is nothing:
		now x is in the powder box;
	now the button is switched off;
	now the current hint is the previous hint;
Report switching on the button:
	say "The door locked audibly and the machine started to pump in water." instead.

After inserting the chirimen into the drum:
	if the chuya obi is not in the drum:
		say "(first putting the chuya obi into the drum)";
		now the chuya obi is in the drum;
	continue the action.
		
After inserting the chuya obi into the drum:
	if the chirimen is not in the drum:
		say "(first putting the chirimen furisode into the drum)";
		now the chirimen is in the drum;
	continue the action.
		
At the time when the washer beeps:
	now the washing machine is finished;
	if the player is in the basement:
		say "The washing machine started beeping.";
	else if the player is in the tenement:
		say "I could hear a faint, repeated, beeping noise.";
	the washer beeps again in five turns from now;

At the time when the washer beeps again:
	if the button is switched on:
		if the player is in the basement:
			say "The washing machine started beeping again.";
		else if the player is in the tenement:
			say "There it was again! The beeping noise came from downstairs.";
		the washer beeps again in four turns from now.

The clothes lines are a plural-named supporter in the basement. The clothes lines are scenery. The description of the clothes lines is "These were the kind you use to hang clothes on in order to dry them."
Understand "clothes line" and "line" as the clothes lines when the location is the basement.
 
Hanging it onto is an action applying to two things.

Understand "hang [something wearable] on/onto/from/off [something]" and "hang up [something wearable] on/onto/from/off [something]" as putting it on.

Check putting something on the clothes lines:
	if the noun is not wearable:
		say "The clothes lines were for drying clothes, only.";
		stop the action;

Check putting something wearable on the clothes lines:
	if the noun is soiled:
		say "Useless. [The noun] needed to be washed first.";
		stop the action.

Check putting something wearable on the clothes lines:
	if the noun is dry:
		say "No need. [The noun] was already dry.";
		stop the action.

Report putting something wearable on the clothes lines:
	say "I hung [the noun] up to dry on the clothes line." instead.

A chip is a kind of thing. The description of the chips is "These looked for all the world like laundry [italic type]jetons[roman type] to my eye."
Before listing contents: group chips together.

The jeton is a chip. The printed name of the jeton is "[italic type]jeton[roman type]". The description of the jeton is "A chip coin for the washing machine."
The jeton is nowhere.

Chapter - The second floor

Section - Landing

The second floor is a room in the tenement. The printed name of the second floor is "Inside the tenement, on the second floor landing." The description of the second floor is "There was a little more light in here than in the first floor landing. I could see a door to the [bold type]west[roman type], as well as the stairs going [bold type]up[roman type] and [bold type]down[roman type]. It was about as inviting as the forbidden staircase back at the boarding house."
The second floor is above the middle stairs. The first floor is in the tenement.
The apartment door is a scenery door. It is west of the second floor.

The top stairs are a plural-named staircase. The top stairs are above the second floor. 

Check going up in the second floor during the second act:
	say "[one of]'I said it's on the second floor!'[or]'The second floor! It's not so difficult now, is it?'[stopping] I heard the caretaker shout from below, as I set foot on the stairs.";
	stop the action.

Section - flat

The flat is a changing room in the tenement. The printed name of the flat is "Inside the tenement, within a 3-LDK." The description of the flat is "I was standing in the living-dining-kitchen area of what I presume people mean when they talk about a [italic type]3-LDK[roman type]. It had the usual conveniences and there was a window to the bay[if the window to the bay is closed], currently closed[end if]. The door to the [bold type]east[roman type] led to the second-floor landing."
The flat is west of the apartment door.

Check taking off something when the location is the flat:
	if the revolutionaries are in the flat:
		say "I was not going to undress in front of these guys.";
		stop the action;

The window to the bay is a window. It is scenery and west of the flat. The window to the bay can be open or closed. It is closed. The window to the bay is openable. The description of the window to the bay is "[if open][Description of the sea][else]The screens were closed."
Understand "shutters/shutter/screen/screens" as the window to the bay when the location is the flat.
Understand "bay" and "sea" and "water" as the window to the bay when the window to the bay is open.
The fake bay is west of the window to the bay.

The television set is a device in the flat. It is undescribed. The description of the television set is "A regular flat screen[if switched off], currently switched off[end if]."
Understand "tv" and "telly" as the television set.
The television set is switched on.
A cable is part of the television set. The cable is scenery. The cable can be plugged in. The cable is plugged in. The cable can be sliced. The cable is not sliced. The cable is sliceable. The description of the cable is "The cable was [if plugged in]plugged into a wall socket.[else]plugged out.[end if][if sliced] It had also been cut clean through.".

Understand "cord", "tv cable", "power cord" and "power cable" as the cable.

A wall socket is scenery in the flat. The description of the wall socket is "An electric wall socket.[if the cable is plugged in] The television cable was plugged into it."

Check taking the television set:
	if watching telly is not happening and Recoverable break is not happening:
		say "There was no need for me to lift the tv set.";
		stop the action.
		
Carry out taking the television set:
	now the television set is switched off;
	now the cable is not plugged in.

Report taking the television set from the flat:
	if the cable is not sliced:
		say "I picked up the television set, ripping the plug out of the socket in the process." instead;
	else:
		say "I picked up the television set." instead.
		
Check going in the flat when the television set is carried:
	if Recoverable break is happening: 
		say "I didn't get to carry the tv out of the flat.";
	else:
		say "I wasn't going to haul the tv out of the flat.";
		try silently dropping the television set;
	stop the action.

Understand "throw [something] out of [a window]" and "toss [something] at [a window]" and "toss [something] out of [a window]" and "drop [something] out of [a window]" and "drop [something] through [a window]" and "throw [something] through [a window]" and "Toss [something] through [a window]" as throwing it at.

Instead of throwing the television set at the window to the bay:
	if the window to the bay is closed:
		say "Futile. While the shutters were closed, that is.";
	else:
		now the television set is nowhere;
		say "I threw [the noun] out of the window."

Rule for implicitly taking the television:
	say "I would have to pick it up first" instead;
		
Check throwing it at:
	if the noun is a person:
		try grappling the noun instead.		

Check dropping a person:
	if the noun is in the location:
		try grappling the noun instead.
				
Check cutting the cable with a knife:
	if the cable is sliced:
		say "The cable had been cut already.";
		stop the action.

Carry out cutting the cable with a knife:
	now the cable is sliced;
	now the television set is switched off.

Report cutting the cable with a knife:
	if the cable is plugged in:
		say "230V jolted through me, massaging my heart at 50hz, before the breaker tripped at 20A. The television screen went dark." instead;

Check switching on the television set:
	if the cable is sliced:
		say "It would have required a bit more work to get the television set back into working condition.";
		stop the action.

Check switching on the television set:
	if the cable is not plugged in:
		say "Useless. I would have had to plug it in first.";
		stop the action.

Unplugging is an action applying to one visible thing.
Understand "unplug [something]", "detach [something]", "plug [something] out", "plug out [something]" and "pull out [something]" as unplugging.

Check pulling the cable:
	if the cable is plugged in:
		try unplugging the noun;
		stop the action.

Check unplugging the television set:
	try unplugging the cable;
	stop the action.

Check unplugging:
	if the noun is not the cable:
		say "That was not something I could unplug.";
		stop the action.
		
Check unplugging the cable:
	if the noun is not plugged in:
		say "The [noun] had already been unplugged.";
	else:
		continue the action.
		
Carry out unplugging the cable:
	now the cable is not plugged in;
	now the television set is switched off.
	 
Report unplugging the cable:
	say "I unplugged the television cable."
	
Plugging it into is an action applying to two visible things.
Understand "plug [something] into [something]" as plugging it into.

Check an actor plugging the television set into the wall socket:
	try the actor plugging the cable into the wall socket;
	stop the action.

Check an actor plugging something into something:
	if the noun is not the cable:
		if the actor is the player:
			say "That could not be plugged into [the second noun]";
		stop the action.
		
Check an actor plugging something into something:
	if the second noun is not the wall socket:
		if the actor is the player:
			say "The [noun] could not be plugged into [the second noun]";
		stop the action.

Check an actor plugging the cable into the wall socket:
	if the cable is plugged in:
		if the actor is the player:
			say "The cable was already plugged in.";
		stop the action.

Carry out an actor plugging the cable into the wall socket:
	now the cable is plugged in.
	
Report an actor plugging the cable into the wall socket:
	if the actor is the player:
		say "I plugged the cable into the wall socket."

The usual conveniences are scenery in the flat. The description of the usual conveniences is "I had no interest in the furniture of the place."
The 3-LDK is scenery in the flat. The description of the 3-LDK is "Three Rooms, and a Living-Dining-Kitchen-Area." Understand "3LDK" as the 3-LDK when the location is the flat.
The LDK is scenery in the flat. The description of the LDK is "The LDK consisted of the kitchen, the dinner table and a television screen." Understand "kitchen", "table" and "dinner table" as the LDK.

Chapter - The Third Floor

The glass house is a changing room in the tenement. The printed name of the glass house is "Within the tenement, in the winter garden". The description of the glass house is "I was standing in a glassed rooftop garden. Its dome protected the lush tropical flora from the outside world, which nonetheless invaded the scene with the colours of the sunset that reflected off the bay into the city."
The glass house is detailed.
Understand "apex/dome" and "glass dome" as the ceiling when the location is the glass house. 
The ceilingtext of the glass house is "High above me, the glass dome reached its apex and above it still a few clouds made their way slowly though the lit-up evening sky."
Understand "sky/sun/evening/cloud/clouds" as the ceiling when the location is glass house.
The walltext of the glass house is "The walls were made almost entirely of glass and allowed a splendid view of the surrounding cityscape and bay."
Understand "cityscape/purple/gold/concrete/bric-a-brac/outside" and "outside world" as Gotomomi when the location is the glass house.
Understand "sunset/dusk/colours/red/blue" as the sea when the location is the glass house.
Understand "window/windows/glass" as the walls when the location is the glass house.
The floortext of the glass house is "Little footpaths of bark mulch had been left between the patches."
Understand "bark mulch/rooftop" and "footpath/footpaths" as the floor when the location is the glass house.
The glass house is above the top stairs.

The lush tropical flora is scenery in the glass house. The description of the lush tropical flora is "A veritable jungle of palms, ferns and flowers in vibrant colours."
Understand "palm/palms/fern/ferns/flowers/garden/plants/jungle" as the lush tropical flora.

The Coquettii are plural-named scenery in the glass house. The description of the Coquettii is "A man-high, gorgeous specimen of C. japonica."
Understand "camellia/flower/plant" and "camellia japonica" as the Coquettii.

Before going to the glass house:
	move the smiling face to the glass house.

Check taking off something when the location is the glass house:
	if the smiling face is in the glass house:
		say "I was not going to undress in front of her.";
		stop the action;

Book - School

The dusk is backdrop in the school. The description of the dusk is "In my memories of school, it's always twilight."

Chapter - School Lockers

School_lockers is a room in the school. The printed name of school_lockers is "At school, by the getabako". The description of school_lockers is "Dusk shone in through the front porch. A few leaves had been blown into the [italic type]genkan[roman type]. Lessons had long since ended for the day. I was standing by the [italic type]getabako[roman type]."
The genkan is scenery in School_lockers. The description of the genkan is "This was where you'd take off your shoes as you entered the building. You then put them into your compartment in the [italic type]getabako[roman type]. A few leaves had been blown into the porch by the wind."
Understand "porch" and "front porch" as the genkan.
The leaves are plural-named scenery in School_lockers. The description of the leaves is "[italic type]akikaze ni[line break]aezu chirinuru[line break]momijiba no[line break]yukue sadamenu[line break]ware zo kanashiki[roman type][line break]- Kokinshû No. 286".
Understand "leaf" as the leaves.
The getabako is a scenery container in School_lockers. The description of the getabako is "A cupboard to put your shoes in when you didn't wear them."
Understand "shoe board", "shelf", "shoe shelf" and "cupboard" as the getabako.
Some footwear called the lacquered shoes is in the getabako. The description of the lacquered shoes is "A pair of shoes for going out. I didn't get to wear it too often since I was mostly walking either barefoot or in slippers."
Does the player mean examining or taking or dropping the slippers: it is unlikely.
Does the player mean examining or taking or dropping the lacquered shoes: it is likely.
The letter is in the getabako. The description of the letter is "A sealed envelope. No sender, no addressee. But it was on my shelf."
Understand "envelope" as the letter.

Instead of doing anything except examining with the letter:
	say "As I took the letter from the [italic type]getabako[roman type], a slender, pale hand reached out from behind me and snatched it away. I turned around and saw a pretty face with an unwavering smile.";
	move the letter to the smiling face.

Check going east in School_lockers:
	if last straw is not happening:
		say "I couldn't leave this place yet.";
		stop the action;
	else if the girls are not surrendered:
		say "The girls were blocking the way.";
		stop the action.

Chapter - Main corridor
	
Main_Corridor is a room in the school. The printed name of Main_Corridor is "At school, in a corridor." The description of Main_Corridor is "This corridor connected the rooms on the ground floor of the main building. The science room was to the [bold type]north[roman type], the humanities room to the [bold type]south[roman type]. The greenhouses lay [bold type]east[roman type]. She was not here."
Main_Corridor is east of School_lockers.

Chapter - Science Room

Science_Room is a room in the school. The printed name of Science_Room is "At school, in a science room." The description of Science_Room is "This was one of the school's science rooms. It was used mostly for junior biology classes. The corridor was to the [bold type]south[roman type]. She was not in here, either."
Science_Room is north of Main_Corridor.

Chapter - Humanities Room

Humanities_Room is a room in the school. The printed name of Humanities_Room is "At school, in a humanities room." The description of Humanities_Room is "This was one of the school's humanities rooms. This particular one was used for geography lessons. The exit was to the [bold type]north[roman type]. She was not in here, either."
Humanities_Room is south of Main_Corridor.

Check going east in Main_Corridor:
	clear the screen;
	say "Behind this door lay the greenhouses. A labyrinth of greenery and glass.[line break]I laid my hand on the doorknob.[paragraph break]I didn't want to remember what came next.[line break]";
	Repeat with x running through things worn by the player:
		now x is nowhere;
	Repeat with x running through things carried by the player:
		now x is nowhere;
	Repeat with x running through things in _wornRoom:
		now Ayako wears x;
	Repeat with x running through things in _carriedRoom:
		now Ayako carries x;
	now Ayako is in the return room;
	now the current hint is the previous hint;
	now the age of Ayako is 18;
	now the scar is a part of Ayako;
	stop the action.

Chapter - Boarding House

Section - Servants Stairs

Servants_Stairs is a room in the school. The printed name of Servants_Stairs is "At school, on a spiral staircase." The description of Servants_stairs is "I was not supposed to be up and about this late in the evening, of course, and in any case, the old servant's staircase was out of bounds. They said it was too dark and too steep and that it could be dangerous. On the other hand, it led to where I was heading. Behind the door to the [bold type]east[roman type] was a loo, and the stairs continued [bold type]upwards[roman type]."

Down from the Servants_Stairs is the dorm.

The loo door is a scenery door. The loo door is east of Servants_Stairs. The description of the loo door is "A solid oak door. It didn't say were it led to, you had to know it."
Understand "oak door", "toilet door", "lavatory door", "restroom door" and "oaken door" as the loo door when the location is Servants_Stairs. 

East of the loo door is the lavatory.

The  forbidden staircase is a staircase. It is  scenery. The forbidden staircase is above Servants_Stairs.

Check going east in Servants_Stairs:
	if the player is not carrying the tampon:
		say "Not yet. That came later.";
		stop the action.

Check going east in Servants_Stairs:
	clear the screen;
	say "I laid my hand on the doorknob.[paragraph break]I didn't want to remember what came next.[line break]";
	Repeat with x running through things worn by the player:
		now x is nowhere;
	Repeat with x running through things carried by the player:
		now x is nowhere;
	Repeat with x running through things in _wornRoom:
		now Ayako wears x;
	Repeat with x running through things in _carriedRoom:
		now Ayako carries x;
	now Ayako is in the return room;
	now the current hint is the previous hint;
	now the age of Ayako is 18;
	now the scar is a part of Ayako;
	stop the action.

Check going down in Servants_Stairs:
	say "If only I'd been smart enough to do that.";
	stop the action.

Section - Balcony Room

Balcony_Room is a room in the school. The printed name of Balcony_Room is "At school, in a bedroom." The description of the Balcony_Room is "We had decided to meet in the twins['] room that night. They had a balcony and someone had suggested we do some stargazing while everyone was away for the summer holidays. It was still too early for that, though. The room lay at the end of the staircase I had come up and which I would go [bold type]down[roman type] again."

Balcony_Room is above the forbidden staircase.

The balcony is scenery in Balcony_Room. The description of the balcony is "This was where we wanted to sit and watch the stars, that night. Or so I had been told."

The _balcony is a privately-named room in the School. The _balcony is east of Balcony_Room.
Check going east in Balcony_Room:
	say "We'd have to wait a little longer for the sun to fully set."


Book - Afterlife

The river shore is a room. The printed name of the river shore is "At the river shore". The description of the river shore is "Now and then, the water glittered in the darkness, but the river was so foggy, it was impossible to tell whether the opposite shore was near or far."

The styx is backdrop in the river shore. The description of the styx is "It was barely visible through the reeds." Understand "river/water" as the styx.
The beach is backdrop in the river shore. The description of the beach is "A pebbled beach." Understand "pebble/pebbles/shore" as the shore.
The reeds are plural-named scenery in the river shore. The description of the reeds is "Slowly waving in the wind, they all but hid the barge." Understand "reed", "grass", "grasses", "reed grass", and "reed grasses" as the reeds.
The fog is backdrop in the river shore. The description of the fog is "The river was covered in it."

The barge is a an enterable, open container in the river shore. The description of the barge is "A flat-bottom boat, punted through the water." The initial appearance of the barge is "The ferryman was waiting on the barge that lay between the reeds." Understand "boat/ferry" as the barge.

Check going inside in the river shore:
	try entering the barge instead;

Instead of entering the barge:
	deliver the Charon_payment quip;
	run a conversation on the Table of Charon Conversation;

Volume - Scenes

Book - The first act

The first act is a scene. The first act begins when play begins. The first act ends when Ayako is undercover.

When the first act begins:	
	[say "'To walk is to lack a place. It is the indefinite process of being absent and in search of a proper. The moving about that the city multiplies and concentrates makes the city itself an immense social experience of lacking a place - an experience that is, to be sure, broken up into countless tiny deportations (displacements and walks), compensated for by the relationships and intersections of these exoduses that intertwine and create an urban fabric, and placed under the sign of what ought to be, ultimately, the place but is only a name: the city. The identity furnished by this place is all the more symbolic, because - in spite of the inequality of its citizens['] positions and profits - there is only a pollulation of passers-bye, a network of residences temporarily appropriated by pedestrian traffic, a shuffling among pretences of the proper, a universe of rented spaces haunted by a nowhere or by dreamed-of places.'[paragraph break][italic type]Michel de Certeau - The Practice of Everyday Life[roman type]";
		pause the game;]
	say "The tugboat was in no hurry to get me across the anchorage. It had nothing better to do. Hulks of all sizes and in various states of disrepair had been laid up in the bay; none of them needed to be moved. We left them to sleep, port and starboard, and kept between the remnants of the two lines of buoys that had once marked the fairway. I was standing at the bow, one foot on the railing, looking towards the city rising out of the glimmering sea, small at first, then bigger, then enormous.[paragraph break]I was a fool to return. Then again, after that unfortunate business in Manila, I really needed to lie low for a while. I had learned of the old bridge undergoing repairs and all of a sudden, the Gotomomi docklands, cut-off as they had to be, seemed like the best of places. I would need to find somewhere to stay, of course, but that shouldn't be too difficult.[paragraph break]We'd arrived at the pier now, and the gangway was lowered. A couple of steps, a slight hop, and I was back.[line break]";
	[pause the game;]
	now the current hint is "initial_goal";
	now the previous hint is "initial_goal".
	
Book - The second act

The second act is a scene. The second act begins when the first act ends. The second act ends when Ayako is tracked.
When the second act begins:
	now the current hint is "get_to_leave".

Book - The third act

The third act is a scene. The third act begins when the second act ends.


Book - Caught red-handed

Caught red-handed is a scene. Caught red-handed begins when the window to the street is open. Caught red-handed ends when the Caretaker is blackmailing.
Check going west during Caught red-handed:
	disable the Caretaker_return_cleanup quip for the Caretaker;
	enable the Caretaker_sure quip for the Caretaker;
	move the caretaker to the 4-and-a-half;
	say "The caretaker was standing in the door frame, looking at the scene.";
	deliver the Caretaker_you_did_it quip;
	disable the Caretaker_jeton quip for the Caretaker;
	run a conversation on the Table of Caretaker Conversation;
	stop the action.

Book - Waste disposal

Waste disposal is a scene. Waste disposal begins when Caught red-handed ends. Waste disposal ends when the mess is nowhere and the chirimen is not soiled and the chuya obi is not soiled.
When Waste disposal begins:
	now the current hint is "hide_body";
Every turn during Waste disposal:
	if the location of the Caretaker is not the neighbourhood office:
 		let the way be the best route from the location of the Caretaker to the neighbourhood office, using doors;
		try the caretaker going the way.
When Waste disposal ends:
	if the chirimen is soiled or the chuya obi is soiled:
		now the current hint is "wash_clothes";
	else: 
		now the current hint is "body_disposed".

Book - Filling

The fillee is a cardboard box that varies.

Filling is a recurring scene.
Filling begins when first act begins.
Filling begins when Glueing ends successfully.
Filling begins when Out of tape ends successfully.
Filling ends successfully when the fillee is filled. 
Filling ends in failure when boating begins.

When Filling begins:
	Now the fillee is a random unfilled cardboard box in the packing room;
	unless the fillee is nothing:
		now the fillee is somewhat filled;
		if the location is the packing room:
			say "The girls began to fill an empty box with tin cans.";
		the almosttimer fires in 0 turns from now;
At the time when the almosttimer fires:
	unless the fillee is nothing:
		now the fillee is almost filled;
		the filledtimer fires in 1 turns from now;
At the time when the filledtimer fires:
	unless the fillee is nothing:
		now the fillee is filled;
		if the location is the packing room:
			say "The girls had finished filling a box with tin cans.";
		
Book - Glueing 

Glueing is a recurring scene.
Glueing begins when Filling ends.
Glueing ends in failure when Out of tape is happening.
Glueing ends successfully when the fillee is sealed.
Glueing ends in failure when Boating begins.

When glueing begins:
	If the number of (unfilled cardboard boxes in the packing room) is less than 4:
		Let Y be a random filled sealed cardboard box in the packing room;
		unless Y is nothing:
			now Y is unfilled;
			now Y is unsealed;
	Now the fillee is a random filled unsealed cardboard box in the packing room;
	the gluetimer fires in 0 turns from now;
	if the packers are carrying some tape:
		try the packers tearing a random tape carried by the packers;
At the time when the gluetimer fires:
	if the packers are carrying a strip (called X):
		unless the fillee is nothing:
			try the packers sticking X onto the fillee;
	else:
		the dawdletimer fires in 1 turns from now;
At the time when the dawdletimer fires:
	if the number of filled unsealed cardboard boxes in the location is greater than 0 and Out of tape is not happening:	
		if the location is the packing room:
			deliver the Packers_no_dawdling quip.

Book - Out of tape

Out of tape is a recurring scene.
Out of tape begins when the length of the packing tape is 0 and the player carries no strips.
Out of tape ends successfully when the Packers carry the packing tape.
Out of tape ends in failure when Boating begins.

When Out of tape begins:
	now the current hint is "find_tape";
	now the packing tape is in the back room;
	now the length of the packing tape is 3;
	now the thickness of the packing tape is thick;
	say "I said 'I am out of tape' to the others.[paragraph break]";
	deliver the Packers_get_tape quip;
	run a conversation on the Table of Packers Conversation.

After looking in the packing room during Out of tape:
	if the player carries the packing tape:
		deliver the Packers_there_you_are quip;
	now the current hint is "find_tape";
	continue the action.

Book - Job complete

Job complete is a recurring scene.
Job complete begins when Out of tape ends successfully.
Job complete ends successfully when the player is paid.
Job complete ends in failure when Boating begins.

When Job complete begins:
	now the current hint is "get_paid";
	now the player is not hired.
	
When Job complete ends:
	now the current hint is the previous hint.

Book - Evasive

Evasive is a recurring scene.
Evasive begins when the player is in Soldering_space and Evasive is not happening and Thrown out is not happening.
Evasive ends successfully when the player is not in the hall.
Evasive ends in failure when the location of the mechanic is the location of the player.

When evasive begins:
	now the mechanic is not fixing;
	now the mechanic is in Chilling_space;
	Repeat with Z running through machines in the hall:
		now Z is switched on;
	let X be a random room within the hall;
	unless X is the location of the player:
		if X is not Tinning_space and X is not Skinning_space:
			now the mechanic is in X;
	now the current hint is "escape_mechanic";
	deliver the Mechanic_who_there quip.
		
Every turn during Evasive:
	let X be a random switched off machine in the location of the mechanic;
	if X is not nothing:
		now the Mechanic is fixing;
		now X is switched on;
		deliver the Mechanic_switched_off quip;
	else if the mechanic is not fixing and location of the mechanic is not the location of the player:
		let the way be the best route from the location of the mechanic to the location of the player, using doors; 
		try mechanic going the way;
	else if the mechanic is fixing:
		now the mechanic is not fixing;
	let Y be the location of the mechanic;
	Repeat with d running through the viable room directions list:
		if the room d from Y is a room:
			if the player is enclosed by the room d from Y:
				if d is down:
					say "Upstairs from here, I could see a mechanic[run paragraph on]";
				else if d is up:
					say "Downstairs from here, I could see a mechanic[run paragraph on]";
				else if d is north:
					say "To the south, I could see a mechanic[run paragraph on]";
				else if d is east:
					say "To the west, I could see a mechanic[run paragraph on]";
				else if d is south:
					say "To the north, I could see a mechanic[run paragraph on]";
				else:
					say "To the east, I could see a mechanic[run paragraph on]";
				if the mechanic is fixing:
					say " fixing [the random machine in the location of the mechanic].";
				else:
					say ".".

Book - Thrown out

Thrown out is a recurring scene.
Thrown out begins when Evasive ends in failure.
Thrown out ends when the player is in the packing room. 

When Thrown out begins:
	now _mechanic is nowhere;
	deliver the Mechanic_found quip.
Instead of doing something other than looking or examining or smelling or listening or talking to during Thrown out:
	if the current action is QBC responding with or the current action is QBC recap:
		continue the action;
	else:
		say "The mechanic wouldn't let me do that.";
Every turn during Thrown out:
	let the way be the best route from the location to the packing room, using doors;
	try silently the mechanic going the way;
	say "The mechanic dragged me along.";
	move the player to the location of the mechanic.
When Thrown out ends:
	now the current hint is "find_tape";
	say "The mechanic threw me out of the machinery hall.";
	try the mechanic going east;
	now the mechanic is nowhere;
	now the packing tape is in the back room.

Book - Returning

Returning is a recurring scene.
Returning begins when the first act begins.
Returning begins when Loading ends successfully.
Returning ends successfully when Vanya is in the packing room.
Returning ends in failure when Boating begins.

When Returning begins:
	now Vanya is wandering;
Every turn during Returning:
	if not QBC is active:
 		let the way be the best route from the location of Vanya to the packing room, using doors;
		let Y be the room the way from the location of Vanya;
		if Y is the Docklands:
			now the waypoint of Vanya is "promenade";
		else:
			now the waypoint of Vanya is "'Seng Heng' factory";
		try Vanya going the way;

Book - Dawdling

Dawdling is a recurring scene.
Dawdling begins when Returning ends successfully.
Dawdling ends successfully when at least one filled sealed cardboard box is in the packing room.
Dawdling ends in failure when Boating begins.

Book - Pickup

Pickup is a recurring scene.
Pickup begins when Dawdling ends successfully.
Pickup ends successfully when Vanya carries a cardboard box.
Pickup ends in failure when Boating begins.

When Pickup begins:	
	let X be a random filled sealed cardboard box in the packing room;
	try Vanya taking X;
	now Vanya is wandering;
	
Book - Hauling

Hauling is a recurring scene.
Hauling begins when Pickup ends successfully.
Hauling ends successfully when Vanya is in Boatpier.
Hauling ends in failure when Boating begins.

When Hauling begins:
	now Vanya is wandering;
Every turn during Hauling:
	if not QBC is active:
 		let the way be the best route from the location of Vanya to the Boatpier, using doors;
		let Y be the room the way from the location of Vanya;
		if Y is the Docklands:
			now the waypoint of Vanya is "promenade";
		else:
			now the waypoint of Vanya is "pier";
		try Vanya going the way;

Book - Loading

Loading is a recurring scene.
Loading begins when Hauling ends successfully.
Loading ends successfully when Vanya is not carrying a cardboard box.
Loading ends in failure when Boating begins.

When Loading begins:
	now Vanya is not wandering;
	the droptimer fires in 0 turns from now;

At the time when the droptimer fires:
	let X be a random cardboard box carried by Vanya; 
	unless X is nothing:
		try Vanya inserting X into the motor boat;
	Let Y be a random cardboard box in the motor boat;
	unless Y is nothing:
		now Y is unfilled;
		now Y is unsealed;
		now Y is in the packing room;

Book - watching telly

Watching telly is a recurring scene. Watching telly begins when the second act begins. Watching telly begins when the television set is switched on. Watching telly ends in failure when the television set is switched off and the cable is not sliced. Watching telly ends in success when the cable is sliced.

Table of Advertising
 blurt
"'Ponky Wonky walks on its own! Yeah! It sings a song for you! All your friends have Ponky Wonky already and they love it! Get your own Ponky Wonky, today!'"
"'Don't let your boss decide on your spending power. With Shark's PayDayPlus you can treat yourself to what YOU want now!'"
"'The new [one of]Aggresso[or]Curviac[or]Clockton[at random]. Because [one of]taste makes the difference in automobiles[or]distinction comes with the car[or]the dynamic deserve mobility[at random]. From ¥[a random number between 2500000 and 3500000] (without optional extras). Contact your dealer now.'"
"'Until recently I felt hemmed in by choices I had made earlier in life. I thought nothing could be done about it. But then I heard about Skinsizzle and now I am getting wherever I want. Skinsizzle can remove your tattoos in just five sittings. Book your free trial session in a Skinsizzle studio near you.'"
"'A woman's private parts are her most well-guarded treasure. Make yours a treasure worth guarding with minimal surgical intervention. Medica Aesthetica offers you all the practical advantages of plastic surgery without any of the financial strain.'"
"'Go out with your head held up high, today! Try Yamamoto's new [one of]skin bleaching formula[or]lid former[at random] and let your beauty shine like never before!'"
"'Get ahead of the pack with BetterChild. Use promo-code 'BetterChild' today and find out what we can do for your offspring. At BetterChild we've turned genetics from chance to opportunity.'"
"'With Horimiya's patented 'Catchemyoung'-method, you can be an influencer, too, in six easy steps.'"
"'Educating a child should be a joy, not a chore. Ask your pharmacist for Concentrate Forte and watch your child's progress with pride!'"

Table of Car Racing
blurt
"'[One of]Gonzales[or]Rough[or]Petermann[cycling] finishes his [one of]pit stop[or]lap slower than the last[or]lap faster than the last[at random].'"
"'Do you think he can make good the time lost with [one of]the broken fuel line?[or]the bent rear axle[cycling]'"
"'Hard to say, it might have cost him the lead. We will see when his lap time comes in.'"
"'With just [one of]23[or]19[or]14[or]10[or]7[or]4[cycling] laps to go and now on fresh tyres, he might still make it.'"
" 'Let's not forget [one of]Rough[or]Petermann[or]Gonzales[cycling] still has one pit stop to go.'"
"'That's right, do you think a four-stop-strategy is better than the traditional three-stop?'"
"'I wouldn't say it's necessarily better, Hanazono-san, but it gives a range of options.'"
"'If the weather turns for the worse, [One of]Rough[or]Petermann[or]Gonzales[cycling] can still put on the slicks. [One of]Gonzales[or]Rough[or]Petermann[cycling] can't.'"
"'Four stops keep the car lighter, because it carries less fuel. And with the shorter refuelling time at each stop, who knows.'"

Table of Home Improvement
blurt
"'Meanwhile [One of]Rocco[or]Ed[or]Ted[cycling] has [one of]been polishing[or]finished[or]run into problems with[at random] [one of]the deckchairs[or]the garden shed[or]the fence posts[or]the new floor[or]the door frame[at random]. He goes to tell [one of]Sheila[or]Brittany[or]Susan[cycling].'"
"'She asks him to help her [one of]choose the colours for the wallpapers[or]decide on the curtains[or]rearrange the furniture[at random] in the [one of]living room[or]bedroom[or]hall[at random].'"
"'This work has to be done using the [one of]power drill[or]angle grinder[or]hot glue gun[cycling], which the [one of]Gockers[or]Hardows[or]Longmans[cycling] need to borrow from one of their neighbours.'"
"'[One of]Rocco[or]Ed[or]Ted[cycling] gets in the car and drives over to his friend's house.'"
"'Hello , [one of]Tom[or]Trevor[or]Bill[cycling], what are you up to?'"
"'Oh, hi there, how's the family?'"
"'Great, thanks. We're finally redoing the house now and we were wondering whether we could borrow your [one of]power drill[or]angle grinder[or]hot glue gun[cycling].'"

The telly table is a table name that varies. The telly table is Table of Car Racing.
Currow is a number that varies. Currow is 1.
	
To change channels:
	if the telly table is the Table of Car Racing:
		now the the telly table is Table of Home Improvement;
	else:
		now the the telly table is Table of Car Racing;
	Now Currow is (the number of rows in the telly table) - 2;
	Now Currow is a random number from 1 to Currow.
	
Every turn during Watching telly:
	If Currow > the number of filled rows in telly table or a random chance of 2 in 9 succeeds:
		Choose a random row in the Table of Advertising;
		if the player is in the flat:
			say "[italic type][blurt entry][roman type] the television [one of]screamed[or]blurted out[or]insinuated[or]pitched[or]had to say[or]reminded us[at random].";
		the zap timer fires in 0 turns from now;
	else:
		Choose row Currow in the telly table;
		if the player is in the flat:
			say "[italic type][blurt entry][roman type] [one of]commented[or]remarked[or]continued[at random] the television.";
		Increase Currow by 1.
		
At the time when the zap timer fires:
	if the player is in the flat: 
		say "[One of]'Oi, Yamada, it's commercials again. Can you change the channel?'[or]'Oh, advertising. Now where's the remote?'[at random]  one of the guys said.";
	change channels.

Book - Recoverable break

Recoverable break is a recurring scene. Recoverable break begins when watching telly ends in failure. Recoverable break ends in failure when watching telly begins. Recoverable break ends in success when the television set is nowhere or the cable is sliced.

When Recoverable break begins:
	if the player carries the television set:
		Deliver the Revolutionaries_why_do_that quip;
		the guys gain control in 1 turns from now;
	else if the cable is plugged in:
		Deliver the Revolutionaries_why_do_that quip;
		enable the Revolutionaries_wont_listen quip for the Revolutionaries;
		run a conversation on the Table of Revolutionaries Conversation;
		the telly flickers in 1 turns from now;
	else if the cable is not plugged in:
		Deliver the Revolutionaries_why_do_that quip;
		enable the Revolutionaries_wont_listen quip for the Revolutionaries;
		run a conversation on the Table of Revolutionaries Conversation;	
		the power is restored in 1 turns from now.

Check taking the television set during Recoverable break:
	say "I couldn't get to it while one of the guys was attending to it.";
	stop the action.

Report dropping the television set during Recoverable break:
	say "I dropped the television set, but it didn't break." instead.
	
At the time when the telly flickers:
	try silently the revolutionaries switching on the television set;
	say "He switched the television back on."

At the time when the power is restored:
	try the revolutionaries plugging the cable into the wall socket;
	say "He plugged the cable back in.";
	the telly flickers in 0 turns from now.

At the time when the guys gain control:
	if the player carries the television and the cable is not sliced: 
		now the television set is in the flat;
		now the television set is undescribed;
		say "He grabbed the television set from my hands and put it back where it had been.";
		the power is restored in 0 turns from now;
	else if the television set is in the flat and the cable is not sliced:
		now the television set is undescribed;
		say "He picked up the television set and put it back where it had been.";
		the power is restored in 0 turns from now.

Book - Assault

Assault is a scene.
Assault begins when Watching telly ends in success.
Assault begins when Recoverable break ends in success.
Assault ends in failure when the player is slapped.
Assault ends successfully when the Revolutionaries are controlled.
Range is a kind of value. The ranges are far, reach and clench.
Assault has Range. The Range of Assault is far.

When Assault begins:
	Deliver the Revolutionaries_crazy quip;
	the pc gets threatened in 0 turns from now;
	set pronouns from the _revolutionary.
	
At the time when the pc gets threatened:
	say "[one of]One of them[or]He[stopping] took a step towards me.";
	now the Range of Assault is reach; 
	the pc gets punched in 0 turns from now.

At the time when the pc gets punched:
	if the player is defensive:
		say "His slap missed me by inches.";
		now the Range of Assault is clench;
		the attacker steps out in 0 turns from now;
	else if the player is offensive:
		say "I ran into his slap and got hit in the nose instead.";
		now the player is slapped;
	else if the player is retreating:
		now the Range of Assault is far;
		the pc gets threatened in 0 turns from now;
	else:
		say "He slapped me in the face.";
		now the player is slapped.

At the time when the attacker steps out:
	if the player is offensive:
		say "and took him down with a reasonably well-executed [italic type][throw][roman type].";
		now the revolutionaries are controlled;
	else:
		say "He retreated a step.";
		now the Range of Assault is reach;
		now the stance of Ayako is neutral;
		the pc gets threatened in 0 turns from now.

Book - Waterworks

Waterworks is a scene. Waterworks begins when Assault ends in failure. Waterworks ends when the revolutionaries are acquainted.

When Waterworks begins:
	Deliver the Revolutionaries_hit_girl quip;
	say "I switched on the waterworks.";
	Deliver the Revolutionaries_sorry quip;
	enable the Revolutionaries_caretakers_fault quip for the Revolutionaries;
	run a conversation on the Table of Revolutionaries Conversation; 
	set pronouns from the _revolutionary.

Book - Domination

Domination is a scene. Domination begins when Assault ends successfully. Domination ends when the revolutionaries are acquainted.

When Domination begins:
	say "Then I twisted his arm out of the joint just enough to make him scream in agony.[paragraph break]";
	Deliver the Revolutionaries_easy quip;
	enable the Revolutionaries_listen_now quip for the Revolutionaries;
	run a conversation on the Table of Revolutionaries Conversation; 
	set pronouns from the _revolutionary.

When Domination ends:
	now the stance of Ayako is neutral.
	
Book - Boating

Boating is a scene. Boating begins when the revolutionaries are acquainted.

When Boating begins:
	now Vanya is in the motor boat;
	now the entrance door is closed;
	now the entrance door is locked;
	Now the description of the entrance door is "A notice on the door said 'Sealed by the public health department'.";
	Now the previous hint is the current hint;
	Now the current hint is "equip_revolutionaries";
	Repeat with X running through cardboard boxes carried by Vanya:
		Unless X is nothing:
			now X is in the motor boat.

Book - Rescue

Rescue is a scene. Rescue begins when the chief engineer is acquainted. Rescue ends when the player carries the master key.
When Rescue begins:
	now the drum is open;
	now the button is switched off;
	now the chuya obi is on the clothes lines;
	now the chirimen is on the clothes lines;

Book - Terrorism

Terrorism is a scene. Terrorism begins when the Revolutionaries are convinced. Terrorism ends when the Revolutionaries are nowhere.
When Terrorism begins:
	now the current hint is "back_to_caretaker";
Every turn during Terrorism:
	if the location of the revolutionaries is not the dark alley :
 		let the way be the best route from the location of the revolutionaries to the dark alley, using doors;
		try the revolutionaries going the way;
	else:
		now the revolutionaries are nowhere;

Book - last straw

Last straw is a scene. Last straw begins when the smiling face carries the letter. Last straw ends when the player is in the ground floor.
When last straw begins:
	deliver the Smiling_letter quip;
	enable the Smiling_catch_me quip for the Smiling face;
	run a conversation on the Table of Smiling conversation;
	
Book - pyjama party

Pyjama party is a scene. Pyjama party begins when the player is in Servants_Stairs. Pyjama party ends when the player is in the first floor.
When pyjama party begins:
	move the girls to Balcony_Room;
	move the smiling face to Balcony_Room.

Book - Ringing

Ringing is a recurring scene. Ringing begins when the operation mode of the pay phone is connecting. Ringing ends when the operation mode of the pay phone is connected.

When Ringing begins:
	say "[italic type]rin-rin[roman type] went the telephone.";
	it rings again  in 1 turn from now.

At the time when it rings again:
	if the endpoint of the pay phone is a telnumber listed in the Table of Telephone Numbers:
		now the operation mode of the pay phone is connected;
	else:
		say "[italic type]rin-rin[roman type] went the telephone.";
		if a random chance of 1 in 2 succeeds:
			it rings again  in 1 turn from now;
		else:
			now the operation mode of the pay phone is connected.

Book - Calling

Table of Telephone Numbers 
telnumber	callee							greeting  
911  	Table of Emergency Conversation   	Emergency_Greeting
112		Table of Emergency Conversation		Emergency_Greeting
110   	Table of Emergency Conversation		Emergency_Greeting

The fire brigade is a thing. The fire brigade can be pranked. The fire brigade is not pranked.
The doom count is a number that varies. The doom count is initially 0;

Calling is a recurring scene. Calling begins when the operation mode of the pay phone is connected. Calling ends when the operation mode of the pay phone is disconnected.
When Calling begins:
	if the endpoint of the pay phone is a telnumber listed in the Table of Telephone Numbers:
		choose a row with telnumber of the endpoint of the pay phone in the Table of Telephone Numbers;
		deliver the greeting entry quip;
		run a conversation on the callee entry;
	else:
		deliver the Prank_Greeting quip; 
		run a conversation on the table of Prank Conversation.

Table of Quip Texts (continued)
quip						quiptext
Prank_Greeting		"[one of][italic type]'Mushi, mushi. Honda desu.'[roman type][or][italic type]'Mushi, mushi. Tanaka desu.'[roman type][or][italic type]'Mushi, mushi. Matsushima desu.'[roman type][or]'Ashinoshita excavation and construction. How can I help you?'[or]'Mie prefecture cultural affairs office.'[at random]"
Prank_Number		"[one of]'Kids, these days.'[or]'Yeah, right.'[or]'I don't have time for such nonsense.'[at random]"
Prank_Telephone	"[one of]'I do...or I should have. It was here, just a moment ago. Mind if I call you back in a couple of minutes once I've found my phone?'[or]'Everyone carries a phone, these days.'[or]'That depends on your definition of a phone. This one won't dial out. You call that a phone?'[at random]"
Prank_Dont			"'Fine then. Goodbye.'"
Prank_Papageno	"[one of]'What?'[or]'Excuse me?'[or]'Already? It was not supposed to happen until next week!'[or]'I knew it would happen, eventually.'[or]'You guys are late! You were supposed to be in position two hours ago.'[or]'I have no idea what you're talking about.'[at random]"
Prank_Encrypted		"[one of]'Not encrypted? Are you crazy?'[or]'Flapping around? I'm not flapping around.'[or]'I'm sorry, Miss. You must have the wrong number. I have no Idea what you're talking about.'[at random]"
Prank_Sing			"[one of]'Parrots are songbirds, everyone knows that.'[or]'Well, I guess It'll be his swansong.'[or]'Would you please tell me what all this is about? I really don't see how it might relate to me, personally.'[or]'Shut up, for Christ's sake! They're recording everything, and the AI will zero in on this call!'[at random]"
Prank_Birds			"'Enough, already. I'm going to hang up the phone now.'"

Table of Prank Conversation
prompt																				response							enabled	
"'I'm sorry, I think I had the wrong number.'"										Prank_Number						1
"'Do you have a telephone on you?'"												Prank_Telephone					1
"'This is the raven. Papageno has caught the parrot in his net.'"						Prank_Papageno						1
"'I don't.'"																			Prank_Dont							0
"'Quit flapping around, this call isn't encrypted.'"									Prank_Encrypted						0
"'Don't you understand? He's going to sing like a bird.'"								Prank_Sing							0
"'Anyway, It's all for the birds now.'"												Prank_Birds							0

After quipping when the current quip is Prank_Number:
	enable the Prank_Number quip;
	enable the Prank_Telephone quip;
	enable the Prank_Papageno quip;
	terminate the conversation;
	now the operation mode of the pay phone is disconnected.

After quipping when the current quip is Prank_Telephone:
	disable the Prank_Number quip;
	disable the Prank_Telephone quip;
	disable the Prank_Papageno quip;
	enable the Prank_Dont quip;

After quipping when the current quip is Prank_Dont:
	enable the Prank_Number quip;
	enable the Prank_Telephone quip;
	enable the Prank_Papageno quip;
	terminate the conversation;
	now the operation mode of the pay phone is disconnected.

After quipping when the current quip is Prank_Papageno:
	disable the Prank_Number quip;
	disable the Prank_Telephone quip;
	disable the Prank_Papageno quip;
	enable the Prank_Encrypted quip;
	enable the Prank_Sing quip;

After quipping when the current quip is Prank_Encrypted:
	disable the Prank_Encrypted quip;
	disable the Prank_Sing quip;
	enable the Prank_Birds quip;

After quipping when the current quip is Prank_Sing:
	disable the Prank_Encrypted quip;
	disable the Prank_Sing quip;
	enable the Prank_Birds quip;

After quipping when the current quip is Prank_Birds:
	disable the Prank_Birds quip;
	enable the Prank_Number quip;
	enable the Prank_Telephone quip;
	enable the Prank_Papageno quip;
	terminate the conversation;
	now the operation mode of the pay phone is disconnected.
	
Table of Quip Texts (continued)
quip						quiptext
Emergency_Greeting			"'Thank you for calling emergency services. If you need emergency rescue, please press 1. If you are calling because of a health emergency, please press 2. For the police, press 3.'"
Emergency_Rescue			"'You have requested help regarding an emergency rescue. Please select the nature of the emergency. For the fire brigade, press 1, for the mountain rescue service, press 2, and for water rescue, press 3.'"
Emergency_Fire_Brigade		"'Fire rescue services, where is the fire?'"
Emergency_Never_Mind		"'Please keep the line free for actual emergencies, thank you.'"
Emergency_Something_Else	"'No problem, I'm forwarding you to the general emergency help line.'"
Emergency_Mountain_Rescue	"'This is the mountain rescue service line. Please enter your health insurance number.'"
Emergency_Water_Rescue	"'This is the water rescue service line. Please enter your health insurance number.'"
Emergency_Health_Emergency	"'This is the national health emergency help line. Please enter your health insurance number."
Emergency_Wrong_Number	"'The number you entered could not be recognised. Your call can only be forwarded if you enter your national health insurance number correctly. Thank you for calling emergency services, good bye.'" 
Emergency_Call_Police		"'EnforcementSolutions 24-hour helpdesk. How can I be of service?'"
Emergency_Shallow_Water	"'Oh, you'll want the rescue services hotline for that, I'll forward you.'"
Emergency_Denunciation	"'Certainly. Who do you want to report? '"
Emergency_Names			"'That's a problem. You see, we always ask for names first.'"
Emergency_Why_Names		"'That's because names are the most important information. When we have one name, we can easily find out more.'"
Emergency_Perpetrator		"'Of course we are. We'd like to talk to you in person, though. You'll remember names better then.'"
Emergency_Pick_Up			"'That's not a problem. We'll come for you.'"
Emergency_No_Bother		"'It's no bother. By the way, could you tell me your name again?'"
Emergency_Public_Health	"'We are at your service. What should we do?'"
Emergency_Quarantine		"'We will get right at it. OVID-19, you say?'"
Emergency_Mahagonny		"'It will be our pleasure to carry out this duty.'"

Table of Emergency Conversation
prompt											response							enabled	
"1"												Emergency_Rescue					1
"2"												Emergency_Health_Emergency		1
"3"												Emergency_Call_Police				1
"1"												Emergency_Fire_Brigade				0
"2"												Emergency_Mountain_Rescue		0
"3"												Emergency_Water_Rescue			0
"'I'm not calling because of a fire'"				Emergency_Something_Else			0
"'Actually, never mind.'"						Emergency_Never_Mind				0
"'Thank you very much.'"						Emergency_Greeting					0
"'No, please don't!'"								Emergency_Greeting					0
"'I don't know the number.'"					Emergency_Wrong_Number			0
"'This is an emergency! Help!"					Emergency_Wrong_Number			0
"'I need a shallow-water rescue recovery."		Emergency_Shallow_Water			0
"'I would like to make a denunciation.'"				Emergency_Denunciation		0
"'I'm not sure, I don't ask for names.'"			Emergency_Names					0
"'Why do you ask for the names first?'"			Emergency_Why_Names				0
"'Aren't you interested in the crime, even if I don't know the name?'"			Emergency_Perpetrator		0
"'I'm afraid I can't come to the police station.'"	Emergency_Pick_Up					0
"'Don't bother.'"								Emergency_No_Bother				0
"'This is Dr. Utsunomiya from the Department of Public Health speaking. We would like to request your assistance.'"		Emergency_Public_Health	0
"'We have a case of OVID-19 on a ship in the harbour. It needs to be quarantined.'"		Emergency_Quarantine		0
"'Yes, a bad case of [italic type]Epistulae ex Ponto[roman type]. The vessel's name is 'Mahagonny'. Wear level-3 protective equipment and make sure you collect a stool sample from all passengers and crew.'"		Emergency_Mahagonny		0

After quipping when the current quip is Emergency_Rescue:
	disable the Emergency_Rescue quip;
	disable the Emergency_Health_Emergency quip;
	disable the Emergency_Call_Police quip;
	enable the Emergency_Fire_Brigade quip;
	enable the Emergency_Mountain_Rescue quip;
	enable the Emergency_Water_Rescue quip;

After quipping when the current quip is Emergency_Health_Emergency:
	disable the Emergency_Rescue quip;
	disable the Emergency_Health_Emergency quip;
	disable the Emergency_Call_Police quip;
	enable the Emergency_Wrong_Number quip;

After quipping when the current quip is Emergency_Mountain_Rescue:
	disable the Emergency_Fire_Brigade quip;
	disable the Emergency_Mountain_Rescue quip;
	disable the Emergency_Water_Rescue quip;
	enable the Emergency_Wrong_Number quip;
	
After quipping when the current quip is Emergency_Water_Rescue:
	disable the Emergency_Fire_Brigade quip;
	disable the Emergency_Mountain_Rescue quip;
	disable the Emergency_Water_Rescue quip;
	enable the Emergency_Wrong_Number quip;
	now the chief engineer is doomed;
	now the current hint is "no_insurance".
	
After quipping when the current quip is Emergency_Wrong_Number:
	disable the Emergency_Wrong_Number quip;
	enable the Emergency_Rescue quip;
	enable the Emergency_Health_Emergency quip;
	enable the Emergency_Call_Police quip;
	terminate the conversation;	
	if the chief engineer is doomed and the doom count is 3:
		say "Were those tears welling up in my eyes?";
	increase the doom count by 1;
	now the operation mode of the pay phone is disconnected.

After quipping when the current quip is Emergency_Fire_Brigade:
	disable the Emergency_Fire_Brigade quip;
	disable the Emergency_Mountain_Rescue quip;
	disable the Emergency_Water_Rescue quip;
	enable the Emergency_Something_Else quip;
	enable the Emergency_Never_Mind quip;

After quipping when the current quip is Emergency_Never_Mind:
	disable the Emergency_Something_Else quip;
	disable the Emergency_Never_Mind quip;
	enable the Emergency_Rescue quip;
	enable the Emergency_Health_Emergency quip;
	enable the Emergency_Call_Police quip;
	terminate the conversation;
	now the operation mode of the pay phone is disconnected.

After quipping when the current quip is Emergency_Something_Else:
	disable the Emergency_Something_Else quip;
	disable the Emergency_Never_Mind quip;
	enable the Emergency_Greeting quip;
	if the chief engineer is doomed and the doom count is 3:
		say "Were those a tears welling up in my eyes?";
	increase the doom count by 1;
	
After quipping when the current quip is Emergency_Greeting:
	disable the Emergency_Greeting quip;
	enable the Emergency_Rescue quip;
	enable the Emergency_Health_Emergency quip;
	enable the Emergency_Call_Police quip;
	
After quipping when the current quip is Emergency_Call_police:
	disable the Emergency_Rescue quip;
	disable the Emergency_Health_Emergency quip;
	disable the Emergency_Call_Police quip;
	if rescue is happening:
		enable the Emergency_Shallow_Water quip;
	if Ayako is invited and Ayako is not fleeing:
		enable the Emergency_Public_Health quip;
	enable the Emergency_Denunciation quip;
	
After quipping when the current quip is Emergency_Public_Health:
	disable the Emergency_Public_Health quip;
	disable the Emergency_Shallow_Water quip;
	disable the Emergency_Denunciation quip;
	enable the Emergency_Quarantine quip;
	
After quipping when the current quip is Emergency_Quarantine:
	disable the Emergency_Quarantine quip;
	enable the Emergency_Mahagonny quip;

After quipping when the current quip is Emergency_Mahagonny:
	disable the Emergency_Mahagonny quip;
	now Ayako is fleeing;
	terminate the conversation.
	
After quipping when the current quip is Emergency_Shallow_Water:
	disable the Emergency_Public_Health quip;
	disable the Emergency_Shallow_Water quip;
	disable the Emergency_Denunciation quip;
	enable the Emergency_Greeting quip;
	if the chief engineer is doomed and the doom count is 3:
		say "Were those tears welling up in my eyes?";
	increase the doom count by 1;
	
After quipping when the current quip is Emergency_Denunciation:
	disable the Emergency_Public_Health quip;
	disable the Emergency_Shallow_Water quip;
	disable the Emergency_Denunciation quip;
	enable the Emergency_Names quip;	

After quipping when the current quip is Emergency_Names:
	disable the Emergency_Names quip;
	enable the Emergency_Why_Names quip;
	enable the Emergency_Perpetrator quip;

After quipping when the current quip is Emergency_Why_Names:
	disable the Emergency_Why_Names quip;

After quipping when the current quip is Emergency_Perpetrator:
	disable the Emergency_Why_Names quip;
	disable the Emergency_Perpetrator quip;
	enable the Emergency_Pick_Up quip;
	
After quipping when the current quip is Emergency_Pick_Up:
	disable the Emergency_Pick_Up quip;
	enable the Emergency_No_Bother quip;

After quipping when the current quip is Emergency_No_Bother:
	enable the Emergency_Rescue quip;
	enable the Emergency_Health_Emergency quip;
	enable the Emergency_Call_Police quip;
	terminate the conversation;
	say "I pushed down on the cradle.";	
	now the operation mode of the pay phone is disconnected.

Book - Gaining Access

Gaining Access is a scene. Gaining Access begins when Ayako is invited. Gaining Access ends when Gambling begins.
When Gaining Access begins:
	now the caretaker is nowhere;
	now the chirimen is dry;
	now the chuya obi is dry;
	
Book - Gambling

Gambling is a scene. Gambling begins when Ayako is exchanged. Gambling ends when Frogmarch begins.

Suit is a kind of value. The suits are hearts, clubs, diamonds, and spades. Understand "heart" as hearts. Understand "club" as clubs. Understand "diamond" as diamonds. Understand "spade" as spades.
A card is a kind of thing. A card has a suit. A card has a number called rank. Understand the suit property as describing a card. Understand the rank property as describing a card. A card has a number called worth.
Understand "playing card" as a card.

To say (count - a number) as a card value:
	choose row count in the Table of Value Names; 
	say "[term entry]".

Rule for printing the name of a card (called target): 
	say "[rank of the target as a card value] of [suit of the target]"

Table of Value Names 
term			value	topic
"ace"			"1"		"ace/A/one"
"deuce"		"2"		"deuce/two"
"three"			"3"		"three"
"four"			"4"		"four"
"five"			"5"		"five"
"six"			"6"		"six"
"seven"		"7"		"seven"
"eight"			"8"		"eight"
"nine"			"9"		"nine"
"ten"			"10"	"ten"
"jack"			"11"	"jack/knave/J"
"queen"		"12"	"queen/Q"
"king"			"13"	"king/K"

After reading a command:
	if the player's command includes "of [suit]": 
		while the player's command includes "of": 
			cut the matched text; 
	repeat through the Table of Value Names: 
		while the player's command includes topic entry:
			replace the matched text with value entry.

There are 16 cards.

The upperRow is a list of cards that varies.
The lowerRow is a list of cards that varies.
The currentCard is a card that varies.
upperSum is a number that varies.
lowerSum is a number that varies.

When Gambling begins:
	now the play state of the game table is betting;
	now the previous hint is the current hint;
	now the current hint is "bet";

Understand "stake" as the plural of chip when the location is the casino.

Understand "withdraw [things]" as taking when the location is the casino.

Book - Forging out

Forging out is a recurring scene. Forging out begins when the play state of the game table is betting. Forging out ends when the play state of the game table is set.
When Forging out begins:
	if the location is the casino:
		say "The croupier collected the cards from the table and put them away.";
	now the upperRow is {};
	now the lowerRow is {};
	now all cards are nowhere;
	the betting timer fires in one turn from now.

At the time when the betting timer fires:
	now the play state of the game table is set;
	
Check putting a chip on a bet while Forging out is not happening:
	say "The game was currently in play, I would have to wait until it was scored before I could place my bet.";
	stop the action;

Check taking a chip from a bet while Forging out is not happening:
	say "The game was currently in play, I would have to wait until it was scored before I could withdraw my stake.";
	stop the action;

Book - Laying out

To create a card for (cardList - a list of cards):
	let x be a random card; 
	while x is listed in cardList:
		now x is a random card;
	now the suit of x is a random suit;
	now the rank of x is a random number between 1 and 13;
	if the rank of x > 9:
		now the worth of x is 10; 
	else:
		now the worth of x is the rank of x;
	now the currentCard is x;


Laying out is a recurring scene. Laying out begins when Forging out ends. Laying out ends when the play state of the game table is scored.

When Laying out begins:
	if the location is the casino:
		say "The croupier picked up some cards from the talon and announced [italic type]'Le jeu est fait!'[roman type]";
	the upper layout timer fires in 0 turns from now;

At the time when the upper layout timer fires:
	now upperSum is 0;	
	while upperSum < 31:
		create a card for the upperRow;
		let n be 0;
		repeat with x running through the upperRow:
			if the rank of currentCard is the rank of x and the suit of currentCard is the suit of x:
				increase n by 1;
		if n < 2:
			increase upperSum by the worth of currentCard;
			add the currentCard to the upperRow;
	if the location is the casino:
		say "Starting with [a entry 1 of upperRow], the croupier laid out the first row and said '[upperSum]'.";
		repeat with x running through the upperRow:
			now x is on the game table;
	the lower layout timer fires in 0 turns from now;

At the time when the lower layout timer fires:
	now lowerSum is 0;	
	while lowerSum < 31:
		create a card for the lowerRow;
		let n be 0;
		repeat with x running through the upperRow:
			if the rank of currentCard is the rank of x and the suit of currentCard is the suit of x:
				increase n by 1;
		repeat with y running through the lowerRow:
			if the rank of currentCard is the rank of y and the suit of currentCard is the suit of y:
				increase n by 1;
		if (1 is 1):
			if the lowerSum + the worth of currentCard < 31:
				increase lowerSum by the worth of currentCard;
				add the currentCard to the lowerRow;	
			else:
				let the loosingBets be {noir, rouge};
				let placer be false;
				if the lowerSum + the worth of the currentCard > upperSum:
					if the suit of entry 1 in the upperRow is hearts or the suit of entry 1 in upperRow is diamonds:
						now placer is true;
						now loosingBets is {noir, inverse};
					else if the suit of entry 1 in the upperRow is clubs or the suit of entry 1 in upperRow is spades:
						now placer is true;
						now loosingBets is {noir, couleur};
				else if the lowerSum + the worth of the currentCard < upperSum:
					if the suit of entry 1 in the lowerRow is clubs or the suit of entry 1 in lowerRow is spades:
						now placer is true;
						now loosingBets is {rouge, inverse};	
					else if the suit of entry 1 in the lowerRow is hearts or the suit of entry 1 in lowerRow is diamonds:
						now placer is true;
						now loosingBets is {rouge, couleur};
				else:
					now placer is true;
					now loosingBets is {};
				if placer is true:
					let loss be 0;
					let win be 0;
					repeat with x running through bets:
						if x is listed in loosingBets:				
							increase loss by the number of chips on x;
						else:
							increase win by the number of chips on x;
					if (the player is not protected and (win + (the number of chips that are carried by the player) - loss < 17 )) or (the player is protected and (win - loss >= 0)):
						increase lowerSum by the worth of currentCard;
						add the currentCard to the lowerRow;
	if the location is the casino:
		say "Starting with [a entry 1 of lowerRow], the croupier laid out the second row and said '[lowerSum]'.";
		repeat with x running through the lowerRow:
			now x is on the game table;
	now the play state of the game table is scored.

Book - Paying out

Paying out is a recurring scene. Paying out begins when Laying out ends. Paying out ends successfully when Forging out begins. Paying out ends in failure when Ayako is broke.

When Paying out begins:
	if the location is the casino:
		let stalemate be false;
		if the lowerSum is 31 and the upperSum is 31:
			say "[italic type]'Refait de trente-un'[roman type] announced the croupier and collected half of every stake.";
			repeat with x running through bets:
				let n be the number of chips on x;
				if n > 0:
					let m be n / 2;
					if n is an odd number:
						now m is n / 2 + 1;
					while m > 0:
						now a random chip on x is nowhere;
						decrease m by 1;
			now the stalemate is true;
		else if the lowerSum is the upperSum:
			say "[italic type]'Après'[roman type] announced the croupier.";
			let the stalemate be true;
		else if the lowerSum > the upperSum:
			if the suit of entry 1 in the upperRow is hearts or the suit of entry 1 in the upperRow is diamonds:
				say "[italic type]'Rouge gagne et couleur'[roman type] announced the croupier and collected the stakes from [italic type]noir[roman type] and [italic type]inverse[roman type].";
				repeat with x running through chips on noir:
					now x is nowhere;
				repeat with x running through chips on inverse:
					now x is nowhere;
				let n be the number of chips on rouge;
				if n > 0:	
					say "The croupier added [n in words] chip[s] to my stake on [italic type]rouge[roman type].";
					while n > 0:
						move (a random chip that is nowhere) to rouge;
						decrease n by 1; 
				let m be the number of chips on couleur;
				if m > 0:	
					say "The croupier added [m in words] chip[s] to my stake on [italic type]couleur[roman type].";
					while m > 0:
						move (a random chip that is nowhere) to couleur;
						decrease m by 1; 
			else:
				say "[italic type]'Rouge gagne et couleur perd'[roman type] announced the croupier and collected the stakes from [italic type]noir[roman type] and [italic type]couleur[roman type].";
				repeat with x running through chips on noir:
					now x is nowhere;
				repeat with x running through chips on couleur:
					now x is nowhere;
				let n be the number of chips on rouge;
				if n > 0:	
					say "The croupier added [n in words] chip[s] to my stake on [italic type]rouge[roman type].";
					while n > 0:
						move (a random chip that is nowhere) to rouge;
						decrease n by 1; 
				let m be the number of chips on inverse;
				if m > 0:	
					say "The croupier added [m in words] chip[s] to my stake on [italic type]inverse[roman type].";
					while m > 0:
						move (a random chip that is nowhere) to inverse;
						decrease m by 1; 
		else:
			if the suit of entry 1 in the lowerRow is clubs or the suit of entry 1 in the lowerRow is spades:
				say "[italic type]'Rouge perd et couleur'[roman type] announced the croupier and collected the stakes from [italic type]rouge[roman type] and [italic type]inverse[roman type].";
				repeat with x running through chips on rouge:
					now x is nowhere;
				repeat with x running through chips on inverse:
					now x is nowhere;
				let n be the number of chips on noir;
				if n > 0:	
					say "The croupier added [n in words] chip[s] to my stake on [italic type]noir[roman type].";
					while n > 0:
						move (a random chip that is nowhere) to noir;
						decrease n by 1; 
				let m be the number of chips on couleur;
				if m > 0:	
					say "The croupier added [m in words] chip[s] to my stake on [italic type]couleur[roman type].";
					while m > 0:
						move (a random chip that is nowhere) to couleur;
						decrease m by 1; 
			else:
				say "[italic type]'Rouge perd et couleur perd'[roman type] announced the croupier and collected the stakes from [italic type]rouge[roman type] and [italic type]couleur[roman type].";
				repeat with x running through chips on rouge:
					now x is nowhere;
				repeat with x running through chips on couleur:
					now x is nowhere;
				let n be the number of chips on noir;
				if n > 0:	
					say "The croupier added [n in words] chip[s] to my stake on [italic type]noir[roman type].";
					while n > 0:
						move (a random chip that is nowhere) to noir;
						decrease n by 1; 
				let m be the number of chips on inverse;
				if m > 0:	
					say "The croupier added [m in words] chip[s] to my stake on [italic type]inverse[roman type].";
					while m > 0:
						move (a random chip that is nowhere) to inverse;
						decrease m by 1;
		if stalemate is false:
			if  a random chance of 1 in 3 succeeds:
				say "[line break][one of]One of the [italic type]pointiers[roman type] withdrew half of his now very substantial stake.[or]A player on the opposite side of the table had just lost a large sum.[or]The [italic type]pointier[roman type] who had been doing so well until now finally lost his stake.[or]One player seemed very pleased with his winnings.[at random]";
		else if a random chance of 1 in 2 succeeds:
			say "[line break][One of]One could feel the tension rising.[or]Some of the [italic type]pointiers[roman type] would surely have wanted to withdraw their stakes at this point.[or]This development was met by indifference from the players.[at random]";
	the payout timer fires in 0 turns from now;
	
At the time when the payout timer fires:	
	if the location is the casino:
		let account be 0;
		repeat with x running through chips:
			if x is on a bet or x is carried by Ayako:
				increase account by 1;
		unless account < 16:
			now Ayako is not protected;
			now the previous hint is the current hint;
			now the current hint is "exchange";
		if account < 1:
			now Ayako is broke;
	unless Ayako is broke:
		now the play state of the game table is betting;

Check dropping a chip during Gambling:
	say "I needed to hold onto that for the moment.";
	stop the action;

Check inserting a chip into something during Gambling:
	say "I needed to hold onto that for the moment.";
	stop the action;

Check going in the casino:
	let x be a random chip that is on a bet;
	unless x is nothing:
		say "I still had a stake in the game. I would have needed to withdraw it before I left the table.";
		stop the action;		

Book - Drunkyard

Drunkyard is a recurring  scene.
Drunkyard begins when the promille of the player > 0.5 pm. Drunkyard ends when the promille of the player < 0.2 pm.
	
When Drunkyard begins:
	intoxication starts in 10 turns from now;
	
At the time when intoxication starts:
	if Drunkyard is happening:
		decrease the promille of the player by 0.05 pm;
		if a random chance of 2 in 3 succeeds:
			say "[one of]Suddently I felt like giggling.[or]I felt a little tipsy.[or]Was I getting tired?[or]Maybe I did have a little too much alcohol that night.[or]The noises of my surroundings seemed to come from afar and were barely registering with me.[or]My face felt terribly hot.[cycling]";
		intoxication starts in 3 turn from now.

Book - Frogmarch

Frogmarch is a scene.
Frogmarch begins when Ayako is challenged or Ayako is cashed or Ayako is broke. Frogmarch ends when the player is in the ring. 

When Frogmarch begins:
	say "Suddenly, there was a hand on my shoulder.";
	move the smiling face to the location of the player;
	set pronouns from the smiling face;
	deliver the Smiling_challenge quip;

Instead of doing something other than looking or examining or smelling or listening or talking to during Frogmarch:
	say "For the moment. I'd just follow her";

Check talking to someone during Frogmarch:
	say "For the moment. I'd just follow her";
	stop the action;

Every turn during Frogmarch:
	let the way be the best route from the location to the ring, using doors;
	try silently the smiling face going the way;
	say "I followed her.";
	move the player to the location of the smiling face.

Book - Announcement

Announcement is a scene. Announcement begins when Frogmarch ends. Announcement ends when the announcer is nowhere.
When announcement begins:
	deliver the Announcer_holder quip;
	the challenger is called in 0 turns from now;

at the time when the challenger is called:
	deliver the Announcer_challenger quip;
	say "His announcement was met with roaring applause.";
	the fight commences in 0 turns from now.
	
at the time when the fight commences:
	deliver the Announcer_begin quip;
	say "And with that, he vanished into the crowd.";
	the contest starts in 0 turns from now.

at the time when the contest starts:
	now the announcer is nowhere;
	
Check talking to during announcement:
	say "It was too loud to talk to anyone.";
	stop the action;
	
Check going during announcement:
	say "I was not going to chicken out now.";
	stop the action;

Book - Duel

The dagger is a knife. The description of the dagger is "A fine blade."
Does the player mean doing anything with the dagger: it is unlikely.

Duel is a scene. Duel begins when Announcement ends.

When Duel begins:
	now the tampon is nowhere;
	now the description of the smiling face is "She stood crouched, on her toes, knife in hand.";
	unless the player carries the kaiken:
		say "She threw the [italic type]kaiken[roman type] on the floor in front of me.";
		now the kaiken is in the ring;
		deliver the Smiling_pick_up quip;
	say "'Let's settle the score, Ayako-hime. [italic type]En garde![roman type]' she called out.";
	set pronouns from the smiling face;
	now Ayako is not slashed;
	now the smiling face is not slashed;
	now the smiling face carries the dagger;
	now the previous hint is the current hint;
	now the current hint is "duel";
	now the player is not arrested.

A wound is a kind of thing. The plural of wound is wounds. The description of a wound is usually "A deep gash, blood was spurting out of it with every heart beat."
Understand "elbow/injury/cut/hand/arm/gash" and "elbow bend" as a wound.
Does the player mean examining a wound: it is likely.

There are three wounds.

The _blood is scenery. Understand "blood/red", "lifeblood/arterial" and "blot" as the _blood. The description of the _blood is "Bright, red, arterial lifeblood."



Book - Confrontation

Confrontation is a recurring scene. Confrontation begins when Ayako is not arrested . Confrontation ends successfully when the smiling face is slashed. Confrontation ends in failure when the player is slashed. Confrontation ends fatally when the player is necked.

Confrontation has Range. The Range of Confrontation is far.

When Confrontation begins:
	the antagonist advances in 0 turns from now;

At the time when the antagonist advances:
	unless the stance of Ayako is offensive:
		say "She quickly took a step towards me.";
		if a random chance of 1 in 2 succeeds:
			say "[one of]'Butcher her!' [or]'Go for it!' [or]'Murder her!' [or]'Do it!' [or]'Go, girl!' [at random]the audience hollered.";
		now the Range of Confrontation is reach; 
		the antagonist lashes in 0 turns from now.

At the time when the antagonist lashes:
	if the stance of the player is defensive:
		now the Range of Confrontation is clench;
		the antagonist steps out in 0 turns from now;
	else if the stance of the player is offensive:
		if at least one wound is part of the player:
			say "She slashed my wrist and cut my throat in a single motion.";
			say "The crowed roared with cries of triumph.";
			now the _blood is in the ring;
			now the stance of Ayako is neutral;
			now the player is arrested;
			now the player is necked;	
		else if the player carries a knife:
			say "As I tried to slash her, she quickly cut my knife hand.";
			say "'Yeah, that'll teach her!' the crowd spurned her on." ;
		else:
			say "I tried to block her attack with my bare hands, but she just cut my arm.";
			say "'That's the stuff!' could be heard from the audience.";
		let x be a random wound that is nowhere;
		now x is part of Ayako;
		now the _blood is in the ring;
		now the player is arrested;
		now the player is slashed;
		the antagonist steps out in 0 turns from now;
	else if the stance of the player is retreating:
		now the Range of Confrontation is far;
		the antagonist advances in 0 turns from now;
	else:
		say "Her knife was quick, I barely noticed it entering my throat.";
		say "The crowed roared with cries of triumph.";
		let x be a random wound that is nowhere;
		now x is part of Ayako;
		now the _blood is in the ring;
		now the stance of Ayako is neutral;
		now the player is arrested;
		now the player is necked.
				
At the time when the antagonist steps out:
	if the stance of the player is offensive and the Range of Confrontation is clench:
		say "At the precise moment when her attack reached its maximum extension, I opened the artery in her elbow bend with a slash from the kaiken.";
		say "[one of]The audience stood aghast. Then they exploded with cheers.[or]The audience sounded very pleased.[cycling]";
		let x be a random wound that is nowhere;
		now x is part of the smiling face;
		now the _blood is in the ring;
		now the player is arrested;
		now the smiling face is slashed;
	if Confrontation is happening or Defanged is happening or Bleeding is happening:
		say "[if the smiling face is slashed]Leaving a trail of blood drops on the floor, she retreated a step.[else]Fast like a cat, she stepped out of range.";
	now the Range of Confrontation is far;
	now the stance of Ayako is neutral;
	unless the player is arrested:
		the antagonist advances in 0 turns from now.

To say throw:
	choose a random row in the Table of Judo Throws;
	say "[throw entry]".

Stepping back is an action applying to nothing.
Understand "step back", "retreat" and "back up" as stepping back.

Check stepping back:
	Unless Assault is happening or Confrontation is happening:
		say "Retreat from what? I was not under attack.";
		stop the action.

Carry out stepping back:
	now the stance of Ayako is retreating.

Report stepping back:
	say "I took a quick step back to get out of range."

Dodging is an action applying to nothing.
Understand "dodge", "evade", "block", "sidestep", "step aside" and "parry" as dodging.

Check dodging:
	Unless Assault is happening or Confrontation is happening:
		say "Dodge what? I was not under attack.";
		stop the action.

Carry out dodging:
	now the stance of Ayako is defensive.

Report dodging:
	say "I sidestepped the attack."

Check going when Assault is happening:
	say "There was no running away from this now.";
	stop the action.

Check going when Duel is happening:
	say "There was no running away from this now.";
	stop the action.

Grappling is an action applying to one visible thing.
Understand "grapple with [someone]", "grapple [someone]", "grab [someone]", "throw [someone]", "trip [someone]" and "take down [someone]" as grappling.

Rule for supplying a missing noun while grappling:
	if the smiling face is in the location:
		now the noun is the smiling face;
	else:
		now the noun is a random person in the location that is not the player.

Check grappling:
	if Assault is not happening and Duel is not happening:
		say "Why do that? I wouldn't get violent unless I needed to.";
		stop the action.

Check grappling:
	If the noun is the player:
		say "Impossible.";
		stop the action.
		
Check grappling while Assault is happening:
	if the Range of Assault is not clench:
		say "I tried grabbing him, but he was really too far away for that.";
		now the stance of Ayako is offensive;
		stop the action.

Check grappling while Duel is happening:
	if Disarmed is happening:
		say "What a thing to suggest! I dropped the murder tool I was still holding in my hand.";
		now the kaiken is in the location;
		stop the action;
	if the Range of Confrontation is not clench:
		if the Range of Confrontation is reach:
			now the stance of Ayako is offensive;
			stop the action;
		else:
			say "I closed in to attack her.";
			now the stance of Ayako is offensive;
			if the player is not carrying the kaiken or a random chance of 1 in 3 succeeds:
				say "She counterattacked.";
				the antagonist lashes in 0 turns from now;
			else:
				the antagonist steps out in 0 turns from now;
			
Carry out grappling:
	now the stance of Ayako is offensive.

Report grappling during Assault:
	say "I grabbed firmly at the lapel and wrist [run paragraph on]";

Table of Judo Throws
throw
"ouchigari"
"kosotogari"
"deashibarai"
"kouchigari"
"haraigoshi"

Instead of attacking someone during assault:
	try grappling the noun;

Instead of attacking someone during Duel:
	try cutting the noun;

Instead of cutting the smiling face during Duel:
	try grappling the noun;

Check talking to someone during Confrontation:
	say "This was not a good moment to talk!";
	stop the action;

Book - Defanged

Defanged is a recurring scene. Defanged begins when Confrontation ends successfully. Defanged ends when Confrontation begins. Defanged ends when the player is killing.

When Defanged begins:
	if the number of wounds that are part of the smiling face < 2:
		say "She changed the knife to her left hand and pressed her fist into her elbow bend. That didn't do much to stop the blot from spreading.";
		say "'No slacking off now, finish the job!' someone in the audience called out.";
		deliver the Smiling_enough quip;
		run a conversation on the Table of Smiling conversation;
	else:
		now Ayako is killing.

At the time when the struggle resumes:
	say "She was no longer smiling.";
	now the description of the smiling face is "Her look was now more akin to an injured animal's.";
	now the initial appearance of the smiling face is "She was here, but her smile was gone.";
	now Ayako is not slashed;
	now the smiling face is not slashed;
	now the player is not arrested.

Book - Disarmed

Disarmed is a scene. Disarmed begins when the player is killing.

When Disarmed begins:	
	say "The dagger slipped from her hand as she lowered her arm and sank to her knees.";
	now the initial appearance of the smiling face is "She sat on the floor in [italic type]seiza[roman type], her blood pumping our of her cut arteries. ";
	now the description of the smiling face is "She was white as a sheet now, and her breathing very shallow.";
	if at least one wound is part of the player:
		say "My legs were about to give in, so I tried to sit down on the floor, too. I felt sleepy.";
		say "'Kill her!' demanded the crowd, but I was already falling.";
		Death comes in 0 turns from now;
	else:
		Weakness comes in 0 turns from now;
		
At the time when Weakness comes:
	say "Her sleeves had turned a vibrant shade of scarlet by now.";
	unless at least one wound is part of the player:
		Vanquished comes in 0 turns from now.

At the time when Vanquished comes:
	say "She slumped over, into the puddle of blood that had formed underneath her.";
	if the player is holdered:
		end the story finally saying "Maybe it hadn't been such a good idea to put my money on the title holder, after all.";
	else if the player is cashed:
		end the story finally saying "I would go on to cash my chips. Maybe I would even get the top floor. I could finally feel the winner and be proud of myself.";
	else if the player is challenged:
		end the story finally saying "I had won the house bet. Maybe I would even get the top floor. I could finally feel the winner and be proud of myself.";
	else:
		end the story finally saying "So I won. And what worth did it have? Maybe I shouldn't have squandered my winnings, after all. Maybe I should have done it all differently.";
		
Book - Bleeding

Bleeding is a scene. Bleeding begins when Confrontation ends in failure. Bleeding ends when Confrontation begins.
When Bleeding begins:
	if the player carries the kaiken:
		say "The kaiken fell out of my limb hand.";
		now the kaiken is in the ring;
	say "'Hurt her plenty!' cheered the crowd.";		
	deliver the Smiling_does_hurt quip;
	run a conversation on the Table of Smiling Conversation;

Every turn during Confrontation:
	if at least one wound is part of the player:
		if a random chance of 1 in 3 succeeds:
		 	say "[one of]Blood was flowing from my wound[or]The blood from the cut wouldn't stop flowing.[or]I was getting weaker.[or]I was breathing too much.[or]I wouldn't be able to go on much longer.[or]This wasn't the time to faint, yet. Composure now.[cycling]";

Book - Dying

Dying is a scene. Dying begins when Confrontation ends fatally. Dying ends when the player is in river shore.

When Dying begins:
	say "I sat down in [italic type]seiza[roman type][if the number of wounds that are part of the player > 1] and sheathed the [italic type]kaiken[roman type][end if].";
	deliverance comes in 0 turns from now;

At the time when deliverance comes:
	say "My [italic type]furisode[roman type] felt so heavy.";
	deliver the Smiling_dont_fight quip;
	say "Were those tears rolling down her cheeks?";
	Death comes in 0 turns from now;
	
At the time when Death comes:
	kill the player;

Instead of doing anything except looking, examining, talking to or waiting during Dying:
	say "I found myself incapable of that.";

Volume - Characters

A person can be acquainted. A person is usually not acquainted.
A person can be interrogated. A person is usually not interrogated.
A person can be vulnerable. A person is usually not vulnerable.

Understand "man/bloke/guy" as a man.
Understand "woman/girl" as a woman.

Book - The Player Character

Chapter - Person

The player is Ayako.
Understand "ayako" and "freckles" as Ayako.
Ayako is a woman. The Description is "[If the age of Ayako is 18]Still the same girl, freckled as ever. I'd been 16 for a couple of years now.[else if the age of Ayako is 13]In this memory, I am 13 years old. I'm short and skinny, my knees are bruised and my face is that of a child. I am freckled all over.[else if the age of Ayako is 15]In this memory, I am 15 years old. I'm no longer short and I like to see myself as a grown-up. I am, of course, still freckled all over."

[Ayako is in the casino.
Ayako carries a chip.]
Ayako is in Boatpier.
[Ayako is in the flat.]
[Ayako is in _waste_dump_1.]

The greeting of Ayako is selftalk.
Ayako can be hired. Ayako is not hired.
Ayako can be paid. Ayako is paid.
Ayako can be defrauded. Ayako is not defrauded.
Ayako can be slapped. Ayako is not slapped.
Ayako can be undercover. Ayako is not undercover.[ Ayako is undercover.]
Ayako can be tracked. Ayako is not tracked. [ Ayako is tracked.]
Ayako can be invited. Ayako is not invited.
Ayako can be warned. Ayako is not warned.
Ayako can be exchanged. Ayako is not exchanged. [Ayako is exchanged.]
Ayako can be protected. Ayako is protected.
Ayako can be broke. Ayako is not broke.
Ayako can be fleeing. Ayako is not fleeing.
Ayako can be challenged. Ayako is not challenged.
Ayako can be holdered. Ayako is not holdered.
Ayako can be cashed. Ayako is not cashed.
Ayako can be drunk. Ayako is not drunk.
Ayako can be slashed. Ayako is not slashed.
Ayako can be necked. Ayako is not necked.
Ayako can be arrested. Ayako is arrested.
Ayako can be killing. Ayako is not killing.

A part of Ayako is the scar. The description of the scar is "Right across."
Understand "wound/injury/stitches" as the scar.

Check examining the scar:
	if the player wears clothing:
		say "Best to keep it hidden from sight.";
		stop the action.

A promille is a kind of value. 1.0 pm specifies a promille.
Ayako has promille. The promille of Ayako is usually 0.0 pm.
A stance is a kind of value. The stances are neutral, retreating, offensive and defensive.
Ayako has stance.
Ayako has a number called age. The age of Ayako is 18.

Chapter - Possessions

Ayako wears yofuku called a grege dress. The printed name of the grege dress is "grège dress". The description of the grege dress is "A canary summer dress of Echigo silk. Practically the only thing one could wear at these temperatures." Understand "summer dress", "echigo silk", "echigo", "echigo dress", "echigo silk", "silk", "silk dress", "grège", "grège silk", "grège dress", "canary dress", "canary silk" and "canary" as the grege dress.
Ayako wears footwear called some top-siders. The printed name of the top-siders is "canvas top-siders". The Description of the top-siders is "A pair of navy deck shoes.". Understand "navy top-siders", "navy top-sider", "topsiders", "topsider", "top-sider", "navy topsiders", "navy topsider", "boat shoe", "boat shoes", "Sperry top-siders", "Sperry topsiders", "Sperry top-sider", "Sperry topsider", "deck shoe", "deck shoes", "canvas", "canvas shoes", "canvas top-siders", "canvas top-sider", "canvas topsiders", "canvas topsider", "canvas shoe", "navy shoe", "navy shoes", "top sider", "top-siders" and "navy canvas" as the top-siders.
Ayako wears a hat called a jipijapa. The printed name of the jipijapa is "[italic type]Jipijapa[roman type]". The description of the jipijapa is "A 15-carerra Panama hat, inherited from my great-aunt." 
Understand "panama", "panama hat", "15-carerra" and "15-carerra hat" as the jipijapa. The jipijapa is valuable.
Ayako carries a fan called a sensu. The printed name of the sensu is "[italic type]sensu[roman type]". The description of the sensu is "A folding fan, decorated with a painting of [italic type]ominaeshi[roman type] and [italic type]kasasagi[roman type].". The sensu is valuable.
Understand "painting" as the sensu.
The ominaeshi is part of the sensu. The description of the ominaeshi is "A valerian flower. Seasonally appropriate, if for no other reason than it being included in [italic type]Man'yôshû[roman type] No. 1538." Understand "valerian", "valerian flower", "flower" and "yellow valerian" as the ominaeshi.
The kasasagi is part of the sensu. The description of the kasasagi is "A magpie. Specifically, one of those that heard [italic type]Orihime[roman type] crying." Understand "magpie" as the kasasagi.

The school uniform is yofuku. The description of the school uniform is "An outfit consisting of a pleated skirt and a middy blouse. Navy, supposedly, but in reality almost black, with crimson piping. Long sleeved, as this was the Michaelmas term."
Understand "skirt/blouse/sailor/collar/seifuku/navy/black/crimson/piping/uniforms" and "middy blouse" as the school uniform. 
The handkerchief is a thing. The description of the handkerchief is "A regulation handkerchief, grey with navy rim stripes. Every St. Agatha's girl had to carry a clean, ironed one at all times."
Understand "rim stripes", "stripe/stripes", "rim stripe" and "grey/hanky/ironed/clean" as the handkerchief.
The badge is a thing. The badge is wearable. The description of the badge is "A small chevron, It looked similar to a prefect badge, which was far more common. But it was not."
Understand "emblem/insignia/needle/chevron" as the badge.
The slippers are footwear. The description of the slippers is "Whereas any other school might have you wear those abominable [italic type]uwabaki[roman type], a St.Agatha's girl had a pair of slippers, matching the uniform in colour, embroidered with her [italic type]kamon[roman type]."
A part of the slippers is the kamon. The description of the kamon is "My family's arms. I could feel the totemic value just by looking at it."
Understand "coat of arms", "arms/crest/totem" as the kamon.

Ayako carries the coin.

Chapter - Conversation

Table of Quip Texts (continued)
quip		quiptext
selftalk		"When living alone, talking to oneself can become a habit. I tried to fight the urge."

Book - The caretakers

Chapter - Person

The caretaker is a man. The Description is "Everything about his appearance inspired the impression of a mouse." The initial appearance is "[if the location is the neighbourhood office]A man in a grey apron sat at the desk, [one of]manicuring his fingernails.[or]dozing, with his feet on the table.[or]staring holes into the wall.[at random][else]The caretaker was here."
The caretaker can be bribed. The caretaker is not bribed.
The caretaker can be blackmailing. The caretaker is not blackmailing.
The caretaker can be selling. The caretaker is not selling.
The caretaker is in the neighbourhood office.

Understand "janitor", "manager" and "custodian" as the caretaker. 

Chapter - Possessions

The caretaker wears clothing called an apron. The description of the apron is "A common canvas apron, that seemed to have been in use for a long time, already."

Chapter - Conversation

The litany of the caretaker is the Table of Caretaker Conversation.
The Greeting of the caretaker is Caretaker_Greeting.

Table of Quip Texts (continued)
quip						quiptext
Caretaker_Greeting			"'Can't you read? It says 'wait for the answer' on the door.'"
Caretaker_no_answer_came	"'You should have waited some more then.'"
Caretaker_wrong_door		"'Seems like it. Goodbye.'"
Caretaker_apply_with_na		"'To get on the housing list, you'll have to apply with the neighbourhood association'."
Caretaker_na_office			"'It is. I'm the building manager.'"
Caretaker_long_wait			"'Of course. There is a very straightforward process to this. You can file your application right here and that will place you at the back of the housing queue. It's first come, first served, so it's just a matter of waiting until you get your apartment. Last time I checked, the average waiting time was 15 years.'"
Caretaker_bribe				"'There is the possibility to slip in through compatibility with the other residents. If you were to serve the community in some serious way, I am sure something could be arranged. '"
Caretaker_money			"'Maybe. How much can you spare?'"
Caretaker_take_all			"'I'll take it, as your apology for offering so little. But there is something else you could do for the neighbourhood association.'"
Caretaker_nothing			"'Are you trying to take the mickey? If you really want to help, there is something you could do for the neighbourhood association."
Caretaker_help				"'You could assist the neighbourhood association in many ways.'"
Caretaker_cleanup			"'One of our residents has recently left us, and some of hers remains in the apartment. If you could clean up a bit, I am sure that would be appreciated.'"
Caretaker_do_cleanup		"'Excellent! It's on the first floor. Tell me when you're done.'"
Caretaker_no_cleanup		"'OK, fine. You know where to find me if you ever change your mind.'"
Caretaker_return_cleanup	"'Sure. All you need to do is to throw out the previous occupant's stuff.'"
Caretaker_you_did_it			"'Why did you kill her?"
Caretaker_sure				"'Oh, yes, sure! No-one's going to believe that story if it's my word against yours.'"
Caretaker_no_frame			"'Don't worry. I'm just making sure you know where your own interest is in this matter.'"
Caretaker_interest			"'You see, the poor girl's rent is paid for by the social services. If it just so happened they didn't know about her untimely death, they could continue to do that for a while. That would lower the financial burden on you - unless, of course, you don't want her apartment.'"
Caretaker_disposal			"'Well...like I said, all you need to do is clean up this place. Now, if you could find a way to do that without raising suspicion, that would be great.'"
Caretaker_no_disposal		"'So you don't mind if I report you to the police for murder then?'"
Caretaker_do_disposal		"'That's what I wanted to hear. Tell me when you're done.'"
Caretaker_return_disposal	"'If I knew that, I would have done it myself. Just make sure it won't be found.'"
Caretaker_what_body		"'What body?'"
Caretaker_crime				"'I don't even want to know about your crimes! Did you do something about her clothes?'"
Caretaker_clothes			"'Better get to it, quickly then. There is a washing machine in the basement.'"
Caretaker_cleaned_up		"'Very good! The neighbourhood association will be pleased.'"
Caretaker_one_question		"'Just another one who came here only to find herself under the spell. Now don't you get sentimental on me! It was her own choice.'"
Caretaker_what_spell		"'The less you know about it, the better for you. Trust me.'"
Caretaker_jeton				"'OK. How much money have you got?'"
Caretaker_no_money		"'No [italic type]jeton[roman type] for you then.'"
Caretaker_pay				"'It'll have to do. Here you are,'"
Caretaker_room				"'Sure, sure. It's yours - it's not even expensive. By the way: are you sure you're fine with that small room?'"
Caretaker_will_do			"'If that's what you really want...'"
Caretaker_come_again		"'What?'"
Caretaker_wont_do			"'I thought so. You see, I'd really like to give you a better apartment. There is just one little problem: there are still people living in it.'"
Caretaker_throw_them_out	"'I know what you mean: Just wait until they're out, change the locks on their door, burn their contract. No big deal, you'd think. But it's not so easy. There's three of them. They never leave the house at the same time. Anyway, they won't talk to the neighbourhood association. Maybe they'll talk to you?'"
Caretaker_dirty_deed		"'You will? Great! It's on the second floor. I think you'll find it a much better apartment than the 4-and-a-half you have now.'"
Caretaker_dirty_deed_return	"'Let's see, it would have to be something irresistible to them, I think.'" 
Caretaker_tenants_left		"'Good work! I honestly didn't expect you to succeed. How did you get them to go?"
Caretaker_bakunin			"'They read what?'"
Caretaker_gone				"'Sure, sure. If you can afford the rent, that is.'"
Caretaker_rent				"'The rent is...let's see...you know what, I think I've got a better idea, after all. Don't you think you deserve an even better apartment?'"
Caretaker_do_fine			"'If that's what you really want...'"
Caretaker_deserve_better	"'What was that again?'"
Caretaker_no_good			"'I knew it. There is a very nice penthouse on the top floor. It could be yours, if you can do away with the current occupant. That would be very helpful. How about it?'"
Caretaker_futile				"'Alright then.'"

Table of Caretaker Conversation
prompt																							response					enabled
"'I waited and waited, but no answer was forthcoming.'"										Caretaker_no_answer_came	1
"'Oh, I'm sorry, I think I've got the wrong door.'"												Caretaker_wrong_door		1
"'I'm looking for a flat. There wouldn't happen to be any vacancies here, would there?'"			Caretaker_apply_with_na		1
"'Isn't this the office of the neighbourhood association?'"										Caretaker_na_office			0
"'Is there a form I have to fill in?'"																Caretaker_long_wait			0
"'Do I give the application to you?'"																Caretaker_long_wait			0
"'Will the application process take long?'"														Caretaker_long_wait			0
"'I can't wait that long!'"																		Caretaker_bribe				0
"'That seems an awfully long time.'"															Caretaker_bribe				0
"'Is there no other way?'"																		Caretaker_bribe				0
"'I would like to help the community.'"															Caretaker_help				0
"'Would money help?'"																			Caretaker_money			0
"'I've got exactly 100 yen	.'"																	Caretaker_take_all			0
"'I haven't got a single penny.'"																	Caretaker_nothing			0
"'What do I have to do?'"																		Caretaker_cleanup			0
"'Alright, I'll do it.'"																				Caretaker_do_cleanup		0
"'No, thank you, I'll pass.'"																		Caretaker_no_cleanup		0 
"'Could you tell me again about the work you wanted me to do?'"								Caretaker_return_cleanup	0
"'I didn't do it. '"																				Caretaker_sure				0
"'It was a suicide.'"																				Caretaker_sure				0
"'It was an accident.'"																			Caretaker_sure				0
"'Just take a look at her! She put on her best clothes and tied up her legs.'"						Caretaker_no_frame			0
"'If you want to play it this way: for all I know, you could have killed her!'"						Caretaker_no_frame			0
"'I guess you could frame me if you really wanted.'"												Caretaker_no_frame			0
"'OK, what is [italic type]your[roman type] interest in this matter.'"									Caretaker_interest			0
"'Do go on, I am listening.'"																		Caretaker_disposal			0
"'I will have no part in this.'"																	Caretaker_no_disposal		0
"'I guess there is no other choice: I'll dispose of her body.'"										Caretaker_do_disposal		0
"'Do you have any suggestions on how to get rid of the body?'"									Caretaker_return_disposal	0
"'I disposed of the body.'"																		Caretaker_what_body		0
"'The one I got tinned at the fish factory.'"														Caretaker_crime				0
"'The girl is being filleted by now, you know.'"													Caretaker_crime				0
"'She's pretty no more, that much I can tell you.'"												Caretaker_crime				0
"'Not yet.'"																						Caretaker_clothes			0
"'I cleaned up the room and took care of everything.'"											Caretaker_cleaned_up		0
"'Who was she?'"																				Caretaker_one_question		0	
"'Under what spell?'"																			Caretaker_what_spell		0
"'Can I have the room now?'"																	Caretaker_room				0
"'I've got exactly 100 yen.'"																		Caretaker_pay				0
"'I haven't got a single penny.'"																	Caretaker_no_money		0
"'It'll do.'"																						Caretaker_will_do			0
"[line break][italic type]Flounder, flounder in the sea,[line break]Come, I pray thee, here to me;[line break]For my wife, good Ilsabil,[line break] Wills not as I'd have her will.[roman type]"	Caretaker_come_again	0
"'Never mind. The room won't do.'"																Caretaker_wont_do			0
"'I would like to buy a [italic type]jeton[roman type] for the washing machine.'"					Caretaker_jeton				0
"'Have you asked them to leave?'"																Caretaker_throw_them_out	0
"'Why don't you kick them out, if you don't want them here?'"									Caretaker_throw_them_out	0
"'I'll talk to them. Maybe there's a way to make them leave.'"									Caretaker_dirty_deed		0
"'I'll do what it takes to get my foot on the housing ladder.'"										Caretaker_dirty_deed		0
"'Can you think of anything that would get those guys out of their flat?'"						Caretaker_dirty_deed_return	0
"'The tenants on the second floor have left.'"													Caretaker_tenants_left		0
"'It was easy. None of them had read Bakunin.'"													Caretaker_bakunin			0
"'Never mind. They're gone. Can I have their room now?'"										Caretaker_gone				0	
"'I surely will.'"																					Caretaker_rent				0
"'I don't know. How much is the rent.'"															Caretaker_rent				0													
"'No, that one will do fine.'"																		Caretaker_do_fine			0
"[line break][italic type]Flounder, flounder in the sea,[line break]Come, I pray thee, here to me;[line break]For my wife, good Ilsabil,[line break] Wills not as I'd have her will.[roman type]"	Caretaker_deserve_better	0
"'Never mind, the flat won't do'"																Caretaker_no_good			0
"'It seems futile to decline now.'"																Caretaker_futile				0

Before quipping when the current quip is Caretaker_Greeting:
	if waste disposal is happening and the mess is nowhere and the chirimen is soiled:
		enable the Caretaker_what_body quip for the caretaker;
	else if waste disposal has ended and the first act is happening:
		enable the Caretaker_cleaned_up quip for the caretaker;
	else if the revolutionaries are convinced and Ayako is not tracked:
		disable the Caretaker_dirty_deed_return quip for the caretaker;
		enable the Caretaker_tenants_left quip for the caretaker;
	if the Caretaker carries the jeton and the basement is visited:
		enable the Caretaker_jeton quip for the caretaker;
	say "I said [italic type]'konnichiha'[roman type] to the man.[paragraph break]".

After quipping when the current quip is Caretaker_tenants_left:
	disable the Caretaker_jeton quip;
	enable the Caretaker_bakunin quip;

After quipping when the current quip is Caretaker_bakunin:
	disable the Caretaker_bakunin quip;
	enable the Caretaker_gone quip;
	
After quipping when the current quip is Caretaker_gone:
	disable the Caretaker_gone quip;
	enable the Caretaker_rent quip;

After quipping when the current quip is Caretaker_rent:
	disable the Caretaker_rent quip;
	enable the Caretaker_do_fine quip;
	enable the Caretaker_deserve_better quip;

After quipping when the current quip is Caretaker_do_fine:
	disable the Caretaker_do_fine quip;
	disable the Caretaker_deserve_better quip;
	end the story saying "I endured living in that flat for the next three weeks before I gave up and went back home. And that is where I spend my days, mostly in the garden. Or rather the two hours a day the pills allow me before I have to go back to sleep."

After quipping when the current quip is Caretaker_deserve_better:
	disable the Caretaker_do_fine quip;
	disable the Caretaker_deserve_better quip;
	enable the Caretaker_no_good quip;

After quipping when the current quip is Caretaker_no_good:
	disable the Caretaker_no_good quip;
	enable the Caretaker_futile quip;

After quipping when the current quip is Caretaker_futile:
	disable the Caretaker_futile quip;
	now Ayako is tracked;
	now the previous hint is the current hint;
	now the current hint is "third_floor";
	terminate the conversation;

After quipping when the current quip is Caretaker_no_answer_came:
	disable the Caretaker_jeton quip;
	
After quipping when the current quip is Caretaker_wrong_door:
	enable the Caretaker_no_answer_came quip;
	enable the Caretaker_wrong_door quip;
	enable the Caretaker_apply_with_na quip;
	terminate the conversation.

After quipping when the current quip is Caretaker_apply_with_na:
	disable the Caretaker_no_answer_came quip;
	disable the Caretaker_wrong_door quip;
	disable the Caretaker_jeton quip;
	enable the Caretaker_na_office quip.

After quipping when the current quip is Caretaker_na_office:
	enable the Caretaker_long_wait quip.
	
After quipping when the current quip is Caretaker_long_wait:
	disable the Caretaker_long_wait quip;
	enable the Caretaker_bribe quip.

After quipping when the current quip is Caretaker_bribe:
	disable the Caretaker_bribe quip;
	enable the Caretaker_help quip;
	enable the Caretaker_money quip.

After quipping when the current quip is Caretaker_help:
	enable the Caretaker_cleanup quip.
	
After quipping when the current quip is Caretaker_money:	
	disable the Caretaker_help quip;
	disable the Caretaker_cleanup quip;
	if the player carries the coin:
		enable the Caretaker_take_all quip;
	else:
		enable the Caretaker_nothing quip;

After quipping when the current quip is Caretaker_take_all:
	now the Caretaker carries the coin;
	enable the Caretaker_cleanup quip.

After quipping when the current quip is Caretaker_nothing:
	enable the Caretaker_cleanup quip.

After quipping when the current quip is Caretaker_cleanup:
	disable the Caretaker_money quip;
	disable the Caretaker_help quip;
	enable the Caretaker_do_cleanup quip;
	enable the Caretaker_no_cleanup quip.

After quipping when the current quip is Caretaker_return_cleanup:
	disable the Caretaker_jeton quip;
	enable the Caretaker_do_cleanup quip;
	
After quipping when the current quip is Caretaker_no_cleanup:
	disable the Caretaker_do_cleanup quip;
	enable the Caretaker_return_cleanup quip;
	terminate the conversation.
	
After quipping when the current quip is Caretaker_do_cleanup:
	disable the Caretaker_no_cleanup quip;
	enable the Caretaker_return_cleanup quip;
	now the Caretaker is bribed;
	now the Caretaker carries the jeton;
	now the current hint is "clean_room";
	terminate the conversation.

After quipping when the current quip is Caretaker_you_did_it:
	disable the Caretaker_return_cleanup quip;
	disable the Caretaker_jeton quip;
	enable the Caretaker_sure quip.

After quipping when the current quip is Caretaker_sure:
	disable the Caretaker_sure quip;
	enable the Caretaker_no_frame quip.

After quipping when the current quip is Caretaker_no_frame:
	disable the Caretaker_no_frame quip;
	enable the Caretaker_interest quip.
	
After quipping when the current quip is Caretaker_interest:
	enable the Caretaker_disposal quip.
	
After quipping when the current quip is Caretaker_disposal:
	enable the Caretaker_no_disposal quip;
	enable the Caretaker_do_disposal quip.

After quipping when the current quip is Caretaker_do_disposal:
	disable the Caretaker_no_disposal quip;
	now the Caretaker is blackmailing;
	enable the Caretaker_return_disposal quip;
	terminate the conversation.

After quipping when the current quip is Caretaker_return_disposal:
	enable the Caretaker_return_disposal quip;
	terminate the conversation.
	
After quipping when the current quip is Caretaker_what_body:
	disable the Caretaker_return_disposal quip;
	disable the Caretaker_jeton quip;
	enable the Caretaker_crime quip;

After quipping when the current quip is Caretaker_crime:
	disable the Caretaker_crime quip;
	enable the Caretaker_clothes quip.

After quipping when the current quip is Caretaker_clothes:
	enable the Caretaker_greeting quip;
	terminate the conversation;
	
After quipping when the current quip is Caretaker_cleaned_up:
	enable the Caretaker_room quip;
	disable the Caretaker_jeton quip;
	disable the Caretaker_return_disposal quip;
	enable the Caretaker_one_question quip.

After quipping when the current quip is Caretaker_one_question:
	disable the Caretaker_room quip;
	enable the Caretaker_what_spell quip;

After quipping when the current quip is Caretaker_what_spell:
	enable the Caretaker_room quip;
	now the Caretaker is interrogated;

After quipping when the current quip is Caretaker_room:
	disable the Caretaker_one_question quip;
	enable the Caretaker_will_do quip;
	enable the Caretaker_come_again quip.

After quipping when the current quip is Caretaker_jeton:
	disable the Caretaker_cleaned_up quip;
	disable the Caretaker_clothes quip;
	disable the Caretaker_return_disposal quip;
	disable the Caretaker_what_body quip;
	disable the Caretaker_return_cleanup quip;
	disable the Caretaker_no_answer_came quip;
	disable the Caretaker_apply_with_na quip;
	disable the Caretaker_wrong_door quip;
	disable the Caretaker_cleaned_up quip;
	disable the Caretaker_dirty_deed_return quip;
	if the player carries the coin:
		enable the Caretaker_pay quip;
	else:
		enable the Caretaker_no_money quip;

After quipping when the current quip is Caretaker_no_money:
	enable the Caretaker_jeton quip;
	if the second act is happening:
		enable the Caretaker_dirty_deed_return quip;
	terminate the conversation;
	
After quipping when the current quip is Caretaker_pay:
	now the caretaker carries the coin;
	say "I handed him all the money I had.";
	if the second act is happening:
		enable the Caretaker_dirty_deed_return quip;
	now the player carries the jeton;
	say "He gave me a [italic type]jeton[roman type].";

After quipping when the current quip is Caretaker_will_do:
	disable the Caretaker_come_again quip;
	end the story saying "I spent all of three days hiding in the four-and-a-half-tatami room. Then my liver gave in and I ended up back home. And that is where I spend my days, mostly in the garden. Or rather the two hours a day the pills allow me before I have to go back to sleep."

After quipping when the current quip is Caretaker_come_again:
	disable the Caretaker_will_do quip;
	enable the Caretaker_wont_do quip.

After quipping when the current quip is Caretaker_wont_do:
	enable the Caretaker_throw_them_out quip;

After quipping when the current quip is Caretaker_throw_them_out:
	disable the Caretaker_throw_them_out quip;
	enable the Caretaker_dirty_deed quip;
	
After quipping when the current quip is Caretaker_dirty_deed:
	disable the Caretaker_dirty_deed quip;
	now Ayako is undercover;
	enable the Caretaker_dirty_deed_return quip;
	terminate the conversation;

After quipping when the current quip is Caretaker_dirty_deed_return:
	enable the Caretaker_jeton quip;
	enable the Caretaker_dirty_deed_return quip;
	terminate the conversation.

Book - The packers

Chapter - Person

The packers are a plural-named woman in the packing room. The printed name is "girls". The initial appearance of the packers is "A few girls in neatly kept smocks were packing cardboard boxes with tin cans." The description of the packers is "They looked straight out of some 1980s employer advertising brochure."
The packers can be needy. The packers are not needy.
Understand "workers/worker/girl/woman/people/women/girls" as the packers when the location is the packing room.

Does the player mean talking to the packers when the location is the packing room: it is very likely.

Check giving the packing tape to the packers:
	deliver the Packers_dont_want quip instead.

To decide whether the packers require the tape:
	if out of tape is happening, decide yes;
	decide no.

Chapter - Possessions

The packers are wearing some smocks. The description of the smocks is "Light blue, without pockets."
Understand "smock" as the smocks.
The packers carry some tape called the packing tape. 

Chapter - Conversation

The greeting of the packers is Packers_greeting.
The litany of the Packers is the Table of Packers Conversation.

Table of Quip Texts (continued)
quip			quiptext
Packers_greeting	"[if Out of tape is happening]'Like we said, it's in the back room.' They pointed towards the east.[else if the player is hired][one of]'That's great. Just take this roll of tape and tape these boxes shut when they're full.'[or]'Just do your job and tape these boxes shut.'[or]'Are you deaf? It's not so difficult to tape these boxes shut, is it now?'[stopping][else]'[italic type]Konnichiha[roman type]. If you have any questions, please talk to the management. The office is over there.' She pointed to the south.[end if]"
Packers_no_way	"[if the player is hired]'Where are you going? You've go a job to do.'[else]'Excuse me, I'm afraid that door is out of bounds for visitors.'[end if] said one of the girls, stopping me."
Packers_no_escape	"'You can't just leave on your shift. I'll tell the manager if you do.' said one of the girls at the conveyor belt as I tried to leave the factory."
Packers_no_stealing	"'I can see you. Don't try to steal factory property.' I heard one of the girls say as I made my way for the door."
Packers_put_down	"'Put that box down, it's going to get picked up in a moment anyway.' said one of the girls, stopping me."
Packers_no_dawdling	"[One of]'Hey, don't fall asleep on us. Tape this box shut.' One of the girls reminded me of my job.[or]'Quit the dawdling now and tape those boxes shut. We want to finish this shipment today.' she scolded me.[stopping]"
Packers_get_tape	"'Why did you squander the tape! We only had this roll. If the manager finds out, we're done for.'"
Packers_mechanic	"'You'll have to go to the back room to get another roll. Just make sure the mechanic doesn't catch you. We're not allowed into the machinery hall and he doesn't like us nicking his stuff, either.'"
Packers_pick_up_tape	"'Oh [italic type]come on[roman type]. Pick up the tape and get working.' said the girls in unison."
Packers_tell_before	"'You looked as if you could figure as much.'"
Packers_dont_want	"'Don't want it. Taping the boxes shut is your job' said the girl."
Packers_there_you_are	"'Took you long enough!' said one of the girls. 'Thanks, anyway. Oh, and your shift is over. Go talk to the manager for your payment.'"

Table of Packers Conversation
prompt									response				enabled
"'Why didn't you tell me before?'"		Packers_tell_before		0
"'Sorry, but how could I know that?'"	Packers_tell_before		0
"'Great. Now what do we do?'"			Packers_mechanic		0

Before quipping when the current quip is Packers_greeting:
	say "[if Out of tape is happening]'Could you tell me again where I can get more tape?' I asked the girls.[else if the packing tape is not carried by someone]I wanted to say something, but they cut me off immediately.[else if the player is hired][One of]I said 'I've been hired. The manager told me to help you.' to the girls.[or]'Could you tell me again what I have to do?' I asked the girls.[stopping][else if Out of tape is happening and the player carries the packing tape]I said 'I'm back, and here's the tape' to the girls.[else][italic type]'Konnichiha'[roman type] I greeted the girls.[end if][paragraph break]".
	
After quipping when the current quip is Packers_greeting:
	if the player is hired and the player is not carrying tape:
		let X be a random tape carried by the packers; 
		if X is nothing and the packing tape is not in the back room:
			deliver the Packers_pick_up_tape quip;
		else if Out of tape is not happening:
			now the player carries X;
			say "They shoved the tape into my hands.";
	terminate the conversation.

After quipping when the current quip is Packers_there_you_are:
	let X be a random tape carried by the player;
	now the packers carry X;
	say "I handed them the roll of tape.";

After quipping when the current quip is Packers_get_tape:
	enable the Packers_tell_before quip for the Packers;
	enable the Packers_mechanic quip for the Packers.

After quipping when the current quip is Packers_tell_before:
	disable the Packers_tell_before quip.

After quipping when the current quip is Packers_mechanic:
	disable the Packers_tell_before quip;
	disable the Packers_mechanic quip;
	terminate the conversation.

After quipping when the current quip is Packers_pick_up_tape:
	terminate the conversation.

Book - The Boss

Chapter - Person

The boss is a man in the factory office. The initial appearance of the boss is "[if the boss is not acquainted]The manager was still the same man since I last came here.[else]Only the manager was in here right now." The description of the boss is "A Middle-aged Vietnamese man in a tasteless shirt."
Understand "man/person/vietnamese/manager" as the boss.
The boss can be rejected. The boss is not rejected.
The boss can be duped. The boss is not duped.

Chapter - Possessions

The boss wears a tasteless shirt. The description of the tasteless shirt is "A Hawaiian-type shirt, not exactly genuine."
Understand "hawaii shirt", "fake", "fake shirt", "hawaii", "hawaiian-type" and "hawaiian shirt" as the tasteless shirt.

Chapter - Conversation

The litany of the boss is the Table of Boss Conversation.

The greeting of the boss is Boss_greeting.

Table of Quip Texts (continued)
quip			quiptext
Boss_greeting		"[If the boss is rejected]'Hello there. Changed your mind?'[else if the player is hired]'Better stop the small talk now. Get to work.'[else if the player is defrauded]'I don't think we've got anything else to talk about, or do we?'[else if the Boss is not acquainted]'Hello there. Say, haven't we met before?'[else]'Hello there. Anything you want?'[end if]"
Boss_just_looking	"'Please do not disturb the workers.'"
Boss_never_met		"'Really? I had the wrong girl then, sorry. Anyway, is there anything you want from me?'"
Boss_worked_before	"'Yes, I remember you now! Been a few years, hasn't it? Anyway, is there anything you want from me?'"
Boss_any_work		"The man seemed to think about my question for a moment."
Boss_what_kind		"'No, no, nothing like that. You see, the factory was modernised last year and is now fully automatised. No more manual gutting, tinning or hauling. It's all done by machines now, on the conveyor belt.[if the boss is duped]..are you sure we haven't met?'"
Boss_how_much		"'2000 yen for one shift. Are you in?'"
Boss_no			"'Your loss. There is easy money to be made here.'"
Boss_yes			"'Great. Help the girls at the packing station. Ask them what they'd like you to do exactly.'"
Boss_pay			"'Ah, yes. Of course. Thank you for helping out. Here's your 100 yen.'"
Boss_thanks 		"'Don't mention it. It's important that there are small jobs available to students and pensioners.'"
Boss_fraud			"'Now that you mention it, you never actually signed any paper work. Take the money and get lost now.'"

Table of Boss Conversation
prompt																						response				enabled
"'No. Not really.'"																			Boss_just_looking		0
"'I don't think so.'"																			Boss_never_met			1
"'I used to work in this factory.'"															Boss_worked_before		1
"'I was wondering if there was any work for me in this factory.'"								Boss_any_work			0
"'Please don't tell me it involves carrying buckets of dead fish from one room to another.'"	Boss_what_kind			0
"'How much will you pay me?'"																Boss_how_much			0
"'Yes.'"																						Boss_yes				0
"'No.'"																						Boss_no				0
"'I've come to get my payment.'"															Boss_pay				0
"'I won't argue with that.'"																	Boss_thanks				0
"'We had agreed on 2000.'"																	Boss_fraud				0

Before quipping when the current quip is Boss_greeting:
	if the boss is rejected:
		disable the Boss_just_looking quip for the boss;
		enable the Boss_yes quip for the boss;
		enable the Boss_no quip for the boss;
	else if the player is hired:
		disable the Boss_just_looking quip for the boss;
	else if the player is not paid:
		disable the Boss_just_looking quip for the boss;
		enable the Boss_pay quip for the boss;
	else if the boss is not acquainted:
		enable the Boss_never_met quip for the boss;
		enable the Boss_worked_before quip for the boss;
	else:
		enable the Boss_any_work quip for the boss;
	say "I said [italic type]'Chào buổi tối'[roman type] to the [if the boss is acquainted]boss.[else]man.[end if][paragraph break]".
	
After quipping when the current quip is Boss_never_met:
	disable the Boss_never_met quip;
	disable the Boss_worked_before quip;
	now the Boss is acquainted;
	now the Boss is duped;
	enable the Boss_just_looking quip;
	enable the Boss_any_work quip.

After quipping when the current quip is Boss_worked_before:
	disable the Boss_never_met quip;
	disable the Boss_worked_before quip;
	now the Boss is acquainted;
	now the Boss is not duped;
	enable the Boss_just_looking quip;
	enable the Boss_any_work quip.

After quipping when the current quip is Boss_just_looking:
	enable the Boss_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Boss_any_work:
	disable the Boss_just_looking quip;
	unless the player carries the coin :
		say "'You're in luck. I think the girls could use some help with the current delivery.'[paragraph break]";
		enable the Boss_what_kind quip;
	else:
		say "'Look, why don't you spend your money first before you come back? It's the things you can buy that make you happy, not the money you keep.'[paragraph break]";
		enable the Boss_just_looking quip;
		terminate the conversation.

After quipping when the current quip is Boss_what_kind:
	enable the Boss_how_much quip;

After quipping when the current quip is Boss_how_much:
	enable the Boss_yes quip;
	enable the Boss_no quip;
	
After quipping when the current quip is Boss_no:
	now the boss is rejected;
	disable the Boss_yes quip;
	terminate the conversation.
	
After quipping when the current quip is Boss_yes:
	now the boss is not rejected;
	now the player is hired;
	now the player is not paid;
	disable the Boss_no quip;
	enable the boss_just_looking quip;
	now the current hint is "tape_boxes";
	terminate the conversation.

After quipping when the current quip is Boss_pay:
	enable the Boss_thanks quip;
	enable the Boss_fraud quip;

After quipping when the current quip is Boss_thanks:
	say "He handed me 100 yen.";
	now the player carries the coin;
	disable the Boss_fraud quip;
	enable the Boss_just_looking quip;
	now the player is not defrauded;
	now the player is paid;
	terminate the conversation.

After quipping when the current quip is Boss_fraud:
	say "He handed me 100 yen.";
	now the player carries the coin;
	disable the Boss_thanks quip;
	disable the Boss_fraud quip;
	enable the Boss_just_looking quip;
	now the player is paid;
	now the player is defrauded;
	terminate the conversation.
	
Book - Vanya

Chapter - Person

Vanya is a man. Vanya is in the the docklands. The printed name of Vanya is "[if acquainted]Vanya[else]lanky guy".
Vanya is improper-named. The indefinite article of Vanya is "a".

Rule for printing a locale paragraph about Vanya:
	if the location is the packing room and Dawdling is happening:
		say "[If Vanya is seen][The Vanya][else][A Vanya][end if] was waiting for a box to carry off.";
		now Vanya is mentioned;
	else if the location is Boatpier and Loading is happening:
		say "[If Vanya is seen][The Vanya][else][A Vanya][end if] was busy loading the motor boat with cardboard boxes.";
		now Vanya is mentioned;
	else if Vanya is not spotted and the location is Docklands:
		say "A lanky guy was working on the sunlit promenade.";
		now Vanya is mentioned;
	else if Boating is happening:
		say "[If Vanya is acquainted]Vanya[else]The lanky guy[end if] was standing at the helm of the motor boat.";
		now Vanya is mentioned;
		now the motor boat is mentioned;

The description of Vanya is "[if acquainted]Vanya, in the flesh.[else]A Russian, by he looks of it. Just where had I seen him, before?"
Understand "guy/russian/slav/slavic/ivan/lanky/wanja/iwan" and "lanky guy" as Vanya.
Vanya has a text called the waypoint. The waypoint of Vanya is usually "'Seng Heng' factory".
Vanya can be wandering. Vanya is wandering.
Vanya can be spotted. Vanya is not spotted.
Vanya can be informed. Vanya is not informed.
Vanya can be dived. Vanya is not dived.

After entering the motor boat:
	if Vanya is in the location:
		set pronouns from Vanya;
	continue the action;

After printing the name of Vanya:
	now Vanya is spotted;
	continue the action;

The describe room gone into rule response (A) is "[if the actor is seen][The actor][else][An actor][end if][If the actor is Vanya] climbed up the ladder to the promenade[else] went up"

The describe room gone into rule response (B) is "[if the actor is seen][The actor][else][An actor][end if][If the actor is Vanya and Vanya carries a cardboard box] climbed down the ladder to the pier, carrying a cardboard box[else] went down"

The describe room gone into rule response (C) is "[if the actor is seen][The actor][else][An actor][end if][If the actor is Vanya and Vanya carries a cardboard box] walked off towards the [waypoint of Vanya], carrying a cardboard box[else if the actor is Vanya] walked off towards the [waypoint of Vanya][else] went [noun]"

The describe room gone into rule response (D) is "[if the actor is seen][The actor][else][An actor][end if][If the actor is Vanya and Vanya carries a cardboard box] came climbing down the ladder from the promenade, carrying a cardboard box[else] arrived from above"

The describe room gone into rule response (E) is "[if the actor is seen][The actor][else][An actor][end if][If the actor is Vanya] came climbing up the ladder from the pier[else] arrived from below"

The describe room gone into rule response (F) is "[if the actor is seen][The actor][else][An actor][end if][If the actor is Vanya and Vanya carries a cardboard box] arrived from [the back way], carrying a cardboard box[else] arrived from [the back way]"

Chapter - Possessions

Vanya carries the boat key. The description of the boat key is "A common ignition key."

Check taking the boat key:
	say "It wasn't mine.";
	stop the action.

Chapter - Conversation

The litany of Vanya is the Table of Vanya Conversation.

The greeting of Vanya is Vanya_greeting.

Table of Quip Texts (continued)
quip				quiptext
Vanya_greeting		"[If Vanya is not acquainted]'Oh, hello Ayako! [italic type]ohisashiburi[roman type]', he responded, a bit startled.[else if Vanya is not interrogated]'Hello there, Ayako, good to see you. I've been meaning to ask you, what have you been up to while you were gone?'[else if Boating is happening]'What now, Ayako?'[else]'Hello Ayako, what is it this time?'"
Vanya_just_looking	"[If Boating is happening]'OK.'[else]'That's nice of you, see you!'"
Vanya_been_while	"'I have to say, you look great! What brings you here?'"
Vanya_back			"'Well, I've been doing the same old stuff. But, as you can see, the place has changed quite a bit.'"
Vanya_job			"'I'm still doing that, but not until nine o'clock. This is my day job.'"
Vanya_living			"'Let's just say being poor in Gotomomi doesn't come cheap. Plus, there are things happening here that defy common sense and decency in how they make you waste your money.'"
Vanya_change		"'Yes and no. Some things start out small, and before you know it, they hold more power over you than you would like.'"
Vanya_thrall			"'Trust me, Ayako: you don't want to know anything about it.'"
Vanya_place			"'Ah, well, it's tough around here, you know. Let's see...I guess there's always...but no. I can't help you, sorry.'"
Vanya_tenement		"'You're going to find it out anyway, sooner or later, so here goes: there's a boarding house, you'll find it if you walk down the promenade towards the south.'"
Vanya_thanks		"'Just don't complain to me I didn't warn you.'"
Vanya_watched		"Having watched my performance, [Vanya] applauded. 'That was simply, outrageously, fantastic, Ayako. [italic type][Solo][roman type], right?'"
Vanya_ballet		"'I'm from Petersburg, you know. Just to let you in on something: I think your talent is lost on this place.'"
Vanya_mistake		"'I barely even noticed it. Had your performance been any more perfect, it would have looked photoshoped, anyway.'"
Vanya_no_audience	"'And why not? It's a shame this art is not more appreciated.'"
Vanya_russian		"'It sure is a leftover from my days in Petersburg. But I like to see myself as a cosmopolitan now.'"
Vanya_rootless		"'You aren't a glass-half-empty kind of person, by any chance, are you?'"
Vanya_Petersburg	"'Believe it or not, I've heard that before. It always comes up in conversation with people who haven't ever lived under any kind of authoritarian regime.'"
Vanya_Lermontov	"'Yes. I don't think I make as good a Byronic hero, but I feel his sentinent in this particular instance.'"
Vanya_glass_too_big	"'As any engineer will tell you, the glass has twice the interior volume it ought to have.'"
Vanya_Kitsch		"'Why would you say so?'"
Vanya_sum_of_parts	"'So you prefer American popular culture?'"
Vanya_pop_culture	"'I guess that settles the argument.'"
Vanya_away			"'[If the player wears clothing]Why not, these deliveries can wait for a while. Where would you like to go?[else]Aren't you going to get dressed first?'"
Vanya_bay			"'Sure thing, Ayako'"
Vanya_pier			"'OK, Ayako.'"
Vanya_casino		"'We'll get there in no time.'"
Vanya_garbage		"'OK, if you insist.'"
Vanya_birthday_suit	"'Aren't you going to get dressed first?'"
Vanya_wound		"'Bloody hell, Ayako! What happened to you? How can you even live with such an injury?' He burst out as he saw the scar."
Vanya_manila		"'I can't even look at it, it gives me the creeps. Sixteen...seventeen...eighteen stitches! And it's recent, too. You ought to take better care of yourself, sister!'"
Vanya_rescue		"[one of]'You could try calling emergency services, but I wouldn't expect too much of them.'[or]'Like I said, call the emergency number. It's your best bet.'[or]'What else do you want me to say? It's impossible without specialist equipment.'[cycling]"
Vanya_warning		"'You know you don't have to do this, Ayako.' said Vanya."
Vanya_understand	"'I guess then it's time to part. [italic type]Sayônara[roman type], Ayako, it was a pleasure to get to know you.'"
Vanya_sayounara	"He steered the boat away."
Vanya_save			"'If you really think you should go diving here, fine. But remember, I can't [bold type]save[roman type] you. You are going to have to do that yourself.'"
Vanya_dive			"'I'll be waiting here.'"
Vanya_far_away		"'The sea is calm today. I guess there should be enough fuel left to get to the other side of the bay. If not, we can always row for the last leg.'"
Vanya_get_back		"'I'll figure something out.'"


Table of Vanya Conversation
prompt													response			enabled
"'[if Boating is happening]Never mind'[else]Just came to say hello, and I'm already gone again.'"	Vanya_just_looking	0
"'Indeed. It's been a while, Vanya, hasn't it?'"			Vanya_been_while	1
"'A lot happened and now I'm back. How do you do?'"	Vanya_back			0
"'What about your job at Yano & Chou's?'"				Vanya_job			0
"'That sounds tough. Can you making a living, at least?'"	Vanya_living		0
"'Why do you need that much money?'"					Vanya_living			0
"'Surely, any changes in Gotomomi are just on the surface?'"	Vanya_change	0
"'Like what?'"											Vanya_thrall			0
"'By the way, you wouldn't happen to know a place for me to stay in the docklands, would you?'"		Vanya_place		0
"'Don't sweat it.  I'll just have to look for myself then.'"	Vanya_tenement		0
"'Spill it, Vanya.'"										Vanya_tenement		0 
"'Thanks, Vanya.'"										Vanya_thanks		0
"'How do you know?'"									Vanya_ballet		0
"'Why am I not surprised you'd know this?'"				Vanya_ballet		0
"'I'm sorry for the mistake in the [one of]sixth [italic type]fouetté[roman type][or][italic type]entrechat quatre[roman type][or]second [italic type]jeté[roman type][at random].'"	Vanya_mistake	0
"'I wasn't asking for an audience, anyway.'"				Vanya_no_audience	0
"'I'll take that as a compliment.'"						Vanya_no_audience	0
"'A sensibility befitting a Russian.'"						Vanya_russian		0
"'To avoid seeing yourself as rootless?'"					Vanya_rootless		0
"'Why didn't you stay in Petersburg? It would seem preferable to this place. Aesthetically, that is.'"	Vanya_Petersburg	0
"[line break][italic type]Proshchay, nemytaya Rossiya,[line break]Strana rabov, strana gospod,[line break]I vy, mundiry golubyye,[line break]I ty, im predannyy narod.[roman type]"	Vanya_Lermontov	0
"'You aren't a glass-half-empty kind of person, by any chance, are you?'"		Vanya_glass_too_big	0
"'It is challenging for me to appreciate [italic type]Kitsch[roman type].'"			Vanya_Kitsch		0
"'The music of most ballets won't hold up to any reasonable standard.'"		Vanya_sum_of_parts	0
"'The routines are an ossification of the 19th century interpretation of 17th century pomp.'"	Vanya_sum_of_parts	0 
"'The sujets are ridiculous, at best, and reach into the deepest depths of orientalism.'"	Vanya_sum_of_parts	0
"'I didn't hear that. Go and wash out your mouth with soap, right now.'"		Vanya_pop_culture	0
"Would you take me away from here?"					Vanya_away			0
"'Out into the bay.'"									Vanya_bay			0	
"'Back to the pier'"										Vanya_pier			0
"'Closer to that laid-up vessel over there.'"				Vanya_casino		0
"'Towards that refuse dump in the distance.'"			Vanya_garbage		0
"'I might need a transplant, eventually.'"				Vanya_manila		0
"'What happens in Manila stays in Manila.'"				Vanya_manila		0
"'You should see the other girl.'"						Vanya_manila		0
"'How would you go about rescuing someone from a sunken ship?'"		Vanya_rescue	0
"'You are not expected to understand this.'"				Vanya_understand	0
"'Thank you for the warning, but a girl's gotta do what a girl's gotta do'"		Vanya_understand		0
"'[italic type]Proshchay[roman type], Vanya.'"				Vanya_sayounara		0
"'If I'm not back in ten minutes, you can call it a day.'"	Vanya_dive			0
"'Far away.'"											Vanya_far_away		0
"'How will you get back?'"								Vanya_get_back		0

After taking off clothing when the location of Vanya is the location of the player:
	Unless Vanya is informed:
		disable the Vanya_just_looking quip for Vanya;
		enable the Vanya_manila quip for Vanya;
		deliver the Vanya_wound quip;
		now Vanya is informed;
		run a conversation on the table of Vanya conversation.

Check swimming when the location is the _bay:
	if Vanya is not dived:
		deliver the Vanya_save quip;
		disable the Vanya_just_looking quip for Vanya;
		enable the Vanya_dive quip for Vanya;
		now Vanya is dived;
		run a conversation on the table of Vanya conversation instead;

Check exiting when the location is the _bay:
	if Vanya is not dived:
		deliver the Vanya_save quip;
		disable the Vanya_just_looking quip for Vanya;
		enable the Vanya_dive quip for Vanya;
		now Vanya is dived;
		run a conversation on the table of Vanya conversation instead;

Check going down when the location is the _bay:
	if Vanya is not dived:
		deliver the Vanya_save quip;
		disable the Vanya_just_looking quip for Vanya;
		enable the Vanya_dive quip for Vanya;
		now Vanya is dived;
		run a conversation on the table of Vanya conversation instead;

After quipping when the current quip is Vanya_dive:
	terminate the conversation; 

After quipping when the current quip is Vanya_warning:
	disable the Vanya_just_looking quip for Vanya;
	disable the Vanya_bay quip for Vanya;
	disable the Vanya_garbage quip for Vanya;
	disable the Vanya_pier quip for Vanya;
	disable the Vanya_casino quip for Vanya;
	enable the Vanya_understand quip for Vanya.

After quipping when the current quip is Vanya_understand:
	disable the Vanya_understand quip;
	enable the Vanya_sayounara quip;

After quipping when the current quip is Vanya_sayounara:
	disable the Vanya_sayounara quip;
	now Ayako is warned;
	terminate the conversation;
	now the motor boat is in the _bay;
	try going up;

Before quipping when the current quip is Vanya_greeting:
	say "[if Boating is happening and Vanya is acquainted]'Say, Vanya...' I asked[else]I said [italic type]'Privet'[roman type] to[end if] [if Vanya is acquainted] Vanya[else]the lanky guy[end if].[paragraph break]".

After quipping when the current quip is Vanya_greeting:
	if Vanya is not acquainted:
		disable the Vanya_just_looking quip;
		enable the Vanya_been_while quip;
	else if Vanya is not interrogated:
		enable the Vanya_back quip;
		enable the Vanya_just_looking quip;
		disable the Vanya_been_while quip;
	else if Boating is happening:
		enable the Vanya_just_looking quip;
		enable the Vanya_away quip for Vanya;
		if Rescue is happening and the chief engineer is not doomed:
			enable the Vanya_rescue quip for Vanya;
	else:
		enable the Vanya_just_looking quip;
		disable the Vanya_been_while quip;
		
After quipping when the current quip is Vanya_been_while:
	now Vanya is acquainted;
	now Vanya is proper-named;
	disable the Vanya_been_while quip;
	enable the Vanya_back quip;
	enable the Vanya_just_looking quip.
	
After quipping when the current quip is Vanya_back:
	disable the Vanya_back quip;
	disable the Vanya_just_looking quip;
	enable the Vanya_job quip;
	enable the Vanya_change quip.

After quipping when the current quip is Vanya_job:
	disable the Vanya_job quip;
	disable the Vanya_change quip;
	enable the Vanya_living quip.

After quipping when the current quip is Vanya_change:
	disable the Vanya_change quip;
	disable the Vanya_job quip;
	enable the Vanya_thrall quip.

After quipping when the current quip is Vanya_living:
	disable the Vanya_living quip;
	enable the Vanya_thrall quip.

After quipping when the current quip is Vanya_thrall:
	now Vanya is interrogated;
	disable the Vanya_thrall quip;
	if the neighbourhood office is not visited:
		enable the Vanya_place quip;
	else if Boating is happening:
		enable the Vanya_away quip;
	else:
		enable the Vanya_just_looking quip;
		terminate the conversation.

After quipping when the current quip is Vanya_place:
	enable the Vanya_tenement quip;
	
After quipping when the current quip is Vanya_tenement:
	disable the Vanya_tenement quip;
	enable the Vanya_thanks quip;
	
After quipping when the current quip is Vanya_thanks:	
	disable the Vanya_thanks quip;
	enable the Vanya_just_looking quip;
	terminate the conversation;

After quipping when the current quip is Vanya_just_looking:
	enable the Vanya_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Vanya_watched:
	disable the Vanya_watched quip;
	enable the Vanya_ballet quip;
	enable the Vanya_mistake quip.

After quipping when the current quip is Vanya_ballet:
	disable the Vanya_ballet quip;
	disable the Vanya_mistake quip;
	enable the Vanya_no_audience quip;
	enable the Vanya_russian quip.

After quipping when the current quip is Vanya_mistake:
	disable the Vanya_mistake quip;
	disable the Vanya_ballet quip;
	enable the Vanya_no_audience quip;
	enable the Vanya_russian quip.

After quipping when the current quip is Vanya_no_audience:
	disable the Vanya_no_audience quip;
	enable the Vanya_russian quip;
	enable the Vanya_Kitsch quip.
	
After quipping when the current quip is Vanya_russian:
	disable the Vanya_russian quip;
	disable the Vanya_no_audience quip;
	disable the Vanya_Kitsch quip;
	enable the Vanya_rootless quip;
	enable the Vanya_Petersburg quip.

After quipping when the current quip is Vanya_Kitsch:
	disable the Vanya_Kitsch quip;
	disable the Vanya_russian quip;
	enable the Vanya_sum_of_parts quip.
	
After quipping when the current quip is Vanya_rootless:
	disable the Vanya_rootless quip;
	disable the Vanya_Petersburg quip;
	disable the Vanya_glass_too_big quip;
	If Vanya is not acquainted:
		enable the Vanya_been_while quip;
	else:
		enable the Vanya_just_looking quip;
		terminate the conversation.

After quipping when the current quip is Vanya_Petersburg:
	disable the Vanya_Petersburg quip;
	disable the Vanya_rootless quip;
	enable the Vanya_Lermontov quip;
	enable the Vanya_glass_too_big quip.

After quipping when the current quip is Vanya_sum_of_parts:
	disable the Vanya_sum_of_parts quip;
	enable the Vanya_pop_culture quip.

After quipping when the current quip is Vanya_pop_culture:
	disable the Vanya_pop_culture quip;
	disable the Vanya_glass_too_big quip;
	If Vanya is not acquainted:
		enable the Vanya_been_while quip;
	else:
		enable the Vanya_just_looking quip;
		terminate the conversation.

After quipping when the current quip is Vanya_Lermontov:
	disable the Vanya_glass_too_big quip;
	disable the Vanya_Lermontov quip;
	If Vanya is not acquainted:
		enable the Vanya_been_while quip;
	else:
		enable the Vanya_just_looking quip;
		terminate the conversation.
	
After quipping when the current quip is Vanya_glass_too_big:
	disable the Vanya_glass_too_big quip;
	disable the Vanya_Lermontov quip;
	If Vanya is not acquainted:
		enable the Vanya_been_while quip;
	else:
		enable the Vanya_just_looking quip;
		terminate the conversation.

After quipping when the current quip is Vanya_manila:
	disable the Vanya_manila quip;
	enable the Vanya_just_looking quip;
	terminate the conversation.

After quipping when the current quip is Vanya_away:
	disable the Vanya_away quip;
	disable the Vanya_just_looking quip;
	disable the Vanya_rescue quip;
	if Ayako is not contained by the motor boat:
		say "I climbed aboard.";
		move the player to the motor boat;
	if Ayako is not wearing clothing:
		enable the Vanya_just_looking quip;
		terminate the conversation;
	else if the location is Boatpier and Ayako is not fleeing:
		disable the Vanya_pier quip;
		enable the Vanya_bay quip;
		enable the Vanya_garbage quip;
		enable the Vanya_casino quip;
	else if Ayako is fleeing:
		enable the Vanya_far_away quip;
	else if the location is _waste_dump_1:
		enable the Vanya_pier quip;
		enable the Vanya_bay quip;
		disable the Vanya_garbage quip;
		enable the Vanya_casino quip;
	else if the location is _bay:
		enable the Vanya_pier quip;
		disable the Vanya_bay quip;
		enable the Vanya_garbage quip;
		enable the Vanya_casino quip;
	else if the location is the laid up vessel:
		enable the Vanya_pier quip;
		enable the Vanya_bay quip;
		enable the Vanya_garbage quip;
		disable the Vanya_casino quip;

After quipping when the current quip is Vanya_far_away:
	disable the Vanya_far_away quip;
	enable the Vanya_get_back quip;

After quipping when the current quip is Vanya_get_back:
	disable the Vanya_get_back quip;
	terminate the conversation;
	end the story saying "And so I left Gotomomi the very same day I had arrived. Maybe it was best that way."

After quipping when the current quip is Vanya_pier:
	disable the Vanya_pier quip;
	disable the Vanya_bay quip;
	disable the Vanya_garbage quip;
	disable the Vanya_casino quip;
	if the outboard engine is switched off:
		try Vanya inserting the boat key into the ignition;
		try Vanya turning the boat key;
	say "Vanya turned the boat towards the city again."; 
	terminate the conversation;
	move the motor boat to Boatpier;
	try looking;

After quipping when the current quip is Vanya_garbage:
	disable the Vanya_pier quip;
	disable the Vanya_bay quip;
	disable the Vanya_garbage quip;
	disable the Vanya_casino quip;
	if the outboard engine is switched off:
		try Vanya inserting the boat key into the ignition;
		try Vanya turning the boat key;
	say "Vanya turned the boat towards the shoals."; 
	terminate the conversation;
	move the motor boat to _waste_dump_1;
	try looking;

After quipping when the current quip is Vanya_casino:
	disable the Vanya_pier quip;
	disable the Vanya_bay quip;
	disable the Vanya_garbage quip;
	disable the Vanya_casino quip;
	if the outboard engine is switched off:
		try Vanya inserting the boat key into the ignition;
		try Vanya turning the boat key;
	say "Vanya turned the boat towards the laid up vessel."; 
	terminate the conversation;
	move the motor boat to the laid up vessel;
	try looking;

After quipping when the current quip is Vanya_bay:
	disable the Vanya_pier quip;
	disable the Vanya_bay quip;
	disable the Vanya_garbage quip;
	disable the Vanya_casino quip;
	say "The motor boat chugged along until it came to a halt a mile or two from the shore."; 
	terminate the conversation;
	if the outboard engine is switched off:
		try Vanya inserting the boat key into the ignition;
		try Vanya turning the boat key;
	terminate the conversation;
	move the motor boat to _bay;
	try looking;

Book - The mechanic

Chapter - Person

The mechanic is a man in Chilling_space. The description of the mechanic is "An oil-smeared technician in a well-worn boiler suit."
Understand "technician" and "oil-smeared" as the mechanic.
The mechanic can be fixing. The mechanic is not fixing.

_mechanic is a privately-named, undescribed man. He is improper-named. The printed name of _mechanic is "mechanic". The indefinite article of _mechanic is "a". The description of _mechanic is "An oil-smeared technician in a boiler suit."
Understand "mechanic", "technician", "boiler suit", "suit" and "oil-smeared" as _mechanic.

Instead of doing anything other than examining with _mechanic, say "He was too far away for that.".
	
After deciding the scope of the player while the player is in the hall:
	Repeat with d running through the viable room directions list:
		if the room d from the location is a room:
			if the mechanic is enclosed by the room d from the location:
				now _mechanic is in the location of the player.

Chapter - Possessions

The mechanic wears a boiler suit. The description of the boiler suit is "An orange cover-all. Was it just me or had I seen this particular one before?"
Understand "well-worn", "cover all" and "cover-all" as the boiler suit.

Chapter - Conversation

The greeting of the mechanic is Mechanic_greeting.

Table of Quip Texts (continued)
quip					quiptext
Mechanic_greeting		"'Stop it! You're not going to talk your way out of this,' said the mechanic."
Mechanic_who_there		"'Who's that in here? You know you're not supposed to be in here. Come out or I'll come and get you!' Someone hollered from across the hall."
Mechanic_switched_off	"[One of]'Who switched off [the random machine in the location of the mechanic]? Now I have to reconfigure it all from scratch!'[or]'It was you who switched off [the random machine in the location of the mechanic], wasn't it? Do you even know what you've done?'[or]'Again switching off machinery, are we? Just you wait until I find you.'[or]'And [the random machine in the location of the mechanic] has been switched off, too. That does it! You are done for.'[stopping] The mechanic called out."
Mechanic_found			"[if the player carries the packing tape]'Stealing from my stores, are we? How often do I have to tell you guys you're not allowed in the machinery space? Off you go. That is mine, and it will stay in the back room', said the mechanic, taking the tape from me.[else]'How often do I have to tell you guys you're not allowed in the machinery space? Off you go,' said the mechanic."

After quipping when the current quip is Mechanic_found:
	if the player carries the packing tape:
		now the mechanic carries the packing tape;
	say "He grabbed me by the arm and shoved me towards the exit."

Book - The revolutionaries

Chapter - Person

The revolutionaries are a plural-named man in the flat. The printed name of the revolutionaries is "guys". the initial appearance of the revolutionaries is "[If the television is switched on]Three guys were lounging around, their eyes glued to the television set.[Else if the location is the flat]Three guys were lounging around, with nothing to do.[else]The revolutionaries were there." The description of the revolutionaries is "They were in their early twenties and otherwise unremarkable."
Understand "guys/blokes/men/boys/yamada/guy" as the revolutionaries when the location of the revolutionaries is the location of the player.

The revolutionaries can be controlled. The revolutionaries are not controlled.
The revolutionaries can be convinced. The revolutionaries are not convinced.
A vacation is a kind of value. The vacations are America, Britain, China.
The revolutionaries have a vacation.
The _revolutionary is a privately-named man in the flat. The _revolutionary is undescribed. The printed name of the _revolutionary is "guy".
Before doing anything with the _revolutionary:
	now the noun are the revolutionaries;
	continue the action.

Chapter - Conversation

The litany of the Revolutionaries is the Table of Revolutionaries Conversation.
The greeting of the revolutionaries is Revolutionaries_greeting.

Table of Quip Texts (continued)
quip							quiptext
Revolutionaries_greeting			"[if the revolutionaries are acquainted]'Welcome back. Anything new?'[else if Assault is happening]'Shut up, bitch! You get what you deserve.'[else]'Shhh! We wanna watch this.'"
Revolutionaries_just_looking		"'We'll be waiting for you.'"
Revolutionaries_why_do_that		"'What did you do that for?' asked one of the blokes."
Revolutionaries_wont_listen		"'Perhaps. But I guess we'll just continue watching TV, anyway.'"
Revolutionaries_crazy			"'Are you crazy? What the hell was that for? the guys called out in unison.'" 
Revolutionaries_hit_girl			"'Look now, Yamada, you made a girl cry. Apologise to her,' he was chided by the others." 
Revolutionaries_sorry			"'Alright, I'm sorry. But I didn't actually hit you that hard, and you deserved it. What are you doing here, anyway?'"
Revolutionaries_easy				"The others watched on stupidly.[line break]'Easy, there. No need to hurt anyone.' one of them said, finally."
Revolutionaries_caretakers_fault	"'That bastard! He wants us out of here by any means. He is the arch-capitalist, the enemy of all tenants!'"
Revolutionaries_kill_caretaker		"'That guy has it coming! I really feel like busting his face.'"
Revolutionaries_little_man		"'Yes! He's exactly that kind of guy. He probably never knew anything but his petty crime schemes. Day after day of his life, he's been at it."
Revolutionaries_symptom		"'Sure, that's true. He didn't start out like this. He has been driven to this behaviour by the relentless class war they're waging on the working man."
Revolutionaries_oppression		"'Sure, that's true. He didn't start out like this. He has been driven to this behaviour by the relentless class war they're waging on the working man."
Revolutionaries_America			"'If you know how to get at these people, why don't you tell us? We'd be dying to know."
Revolutionaries_Britain			"'If you know how to get at these people, why don't you tell us? We'd be dying to know."
Revolutionaries_China			"'If you know how to get at these people, why don't you tell us? We'd be dying to know."
Revolutionaries_who_is_behind	"'I wish I knew whom to thank for this, [']cause we'd really like them to receive our heartfelt gratitude, if you get my meaning.'"
Revolutionaries_hit_something	"'You're right! That would teach those bastards in [vacation of the Revolutionaries]. Change is possible! If only someone had the courage to act.'"
Revolutionaries_group			"They started talking over each other.[paragraph break]'It can't be that difficult. I mean, we could do it, couldn't we, guys?'[paragraph break]'Sure we could, Yamada, but how are we going to get to [vacation of the revolutionaries]?'[paragraph break]'That's right. And what are we going to do to them bastards, anyway, with our bare hands?'"
Revolutionaries_means			"'Alright, you get us to [vacation of the revolutionaries] and something to raise hell over there. We'll wait here until you get back with both.'"
Revolutionaries_listen_now		"'We'll listen! We'll listen, OK? What do you want?"
Revolutionaries_warn_you		"'Gee, thanks, but we knew that already. The man's been trying his dirty little tricks on us for a while now. He's really the enemy of all tenants, I tell you.'"
Revolutionaries_tickets			"'Perfect. That'll get us closer to our target.'"
Revolutionaries_molotov			"'That's the stuff. We can raise hell with this!'"
Revolutionaries_action			"'Yeah, about that plan of yours. You know,  we're not so sure anymore. Don't you think we should just play a prank on the building manager or something?'"
Revolutionaries_look				"'But we're going to miss tonight's fight.' said the one called Yamada.[paragraph break]'Is that really the only thing on your mind? You're a sick man, you know.' One of the others chastised him, as they made for the door."

Table of Revolutionaries Conversation
prompt															response						enabled
"'I'm afraid I've got nothing, yet.'"								Revolutionaries_just_looking		0
"'Sorry, but you wouldn't listen, otherwise.'"					Revolutionaries_wont_listen		0
"'It's an emergency! You need to listen to me.'"					Revolutionaries_wont_listen		0
"'It waaasn't my Ideaaa! The Caaaretaker made me dooowiiit!'"	Revolutionaries_caretakers_fault	0
"'Because of his influence, we're fighting each other here.'"		Revolutionaries_kill_caretaker		0
"'Just of all tenants? I'd say he is the enemy of all people!"		Revolutionaries_kill_caretaker		0
"'That little man is the epitome of the unwashed upstart! Nothing but malice is running through his veins.'"	Revolutionaries_little_man	0 
"'That's what oppression does to you. It's exactly the kind of socialisation they want for us, so that we'll end up like him!'"	Revolutionaries_oppression	0 
"'It's the ugly backside of cultural capital. Dirty little people who've been learning nothing but the secret syllabus.'"		Revolutionaries_oppression	0
"'Then again, In the end,  isn't he just a symptom of the disease our whole society is affected with?'"		Revolutionaries_symptom	0
"'Exactly. This is nothing but the outcome the powers that be have had in store for us little people all the time.'"		Revolutionaries_who_is_behind	0
"'OK, I'll let you in on it. It's entirely the fault of the awful American agencies. They're pulling the strings - for perverse reasons, of course. But there are ways to wrest ourselves from their grasp.'"	Revolutionaries_America	0
"'The bloody British banksters are behind all this, of course! They're hiding from our prying eyes, because they are afraid of the just ire of the people. But I happen to know some of their soft spots.'"	Revolutionaries_Britain	0
"'Oh, come on! There's nobody so blind as not to see who are the puppet masters behind our consumer society. It's the Chinese corporate con men! But they're not as secure as they'd like to be.'"	Revolutionaries_China	0
"'We have to hit them where it hurts them the most: their purse. If we take out their tax collectors, that'll do the trick.'"	Revolutionaries_hit_something	0
"'First off, police station after police station will have to be targeted. Once we've inspired fear in the security apparatus, who else would want to risk their skin for them?'"	Revolutionaries_hit_something	0
"'A public landmark will have to be sacrificed! We have to set a symbol, to light a beacon of hope for the people! Once we've shown them the way, they'll follow.'"	Revolutionaries_hit_something	0
"'An individual can't do much, it's true. But a small group of determined people would suffice.'"	Revolutionaries_group	0
"'Isn't it practically imperative to act, once one has realised the problem and the solution?'"	Revolutionaries_group	0
"'You're [italic type]so[roman type] right. Where are the real men, these days?'"	Revolutionaries_group	0
"'Don't worry about the small stuff. I will take care of that.'"	Revolutionaries_means	0
"'Tell it to mister hothead on the floor right here. Will you listen to me now, or do I have to hurt anyone else first?'"	Revolutionaries_listen_now	0
"'In fact, I've come here to warn you: the caretaker downstairs is trying to drive you out of this flat. '"		Revolutionaries_warn_you	0
"'I've got three tickets for you to get you to [vacation of the Revolutionaries]'"		Revolutionaries_tickets	0
"'Here's a little cocktail I've mixed for you guys.'"		Revolutionaries_molotov	0
"'The time for words has ended. With this, you can carry out the plan.'"		Revolutionaries_action	0
"'I've done my part, now you do yours.'"		Revolutionaries_action	0
"Give them the look."	Revolutionaries_look		0

Before quipping when the current quip is Revolutionaries_greeting:
	if the Revolutionaries are acquainted:
		say "I said [italic type]'konnichi ha'[roman type] to the guys.[paragraph break]";
		enable the Revolutionaries_just_looking quip for the revolutionaries;
	if the player carries the tickets:
		enable the Revolutionaries_tickets quip for the revolutionaries;
	if the player carries the bottle of cut brandy:
		if the bottle of cut brandy is armed:
			enable the Revolutionaries_molotov quip for the revolutionaries;

After quipping when the current quip is Revolutionaries_just_looking:
	enable the Revolutionaries_just_looking quip;
	terminate the conversation.
	
After quipping when the current quip is Revolutionaries_tickets:
	disable the Revolutionaries_just_looking quip;
	disable the Revolutionaries_molotov quip;
	say "I gave them the tickets.";
	now the revolutionaries carry the tickets;
	if the player carries the bottle of cut brandy:
		if the bottle of cut brandy is armed:
			enable the Revolutionaries_molotov quip;
	else if the Revolutionaries carry the bottle of cut brandy:
		enable the Revolutionaries_action quip;
	else:
		terminate the conversation.

After quipping when the current quip is Revolutionaries_molotov:
	disable the Revolutionaries_just_looking quip;
	disable the Revolutionaries_tickets quip;
	say "I gave them the molotov cocktail.";
	now the revolutionaries carry the bottle of cut brandy;
	if the player carries the tickets:
		enable the Revolutionaries_tickets quip;
	else if the Revolutionaries carry the tickets:
		enable the Revolutionaries_action quip;
	else:
		terminate the conversation.

After quipping when the current quip is Revolutionaries_action:
	disable the Revolutionaries_action quip;
	enable the Revolutionaries_look quip;
	
After quipping when the current quip is Revolutionaries_look:
	now the revolutionaries are convinced;
	now the current hint is "back_to_caretaker";
	terminate the conversation.

After quipping when the current quip is Revolutionaries_why_do_that:
	enable the Revolutionaries_wont_listen quip;

After quipping when the current quip is Revolutionaries_wont_listen:
	disable the Revolutionaries_wont_listen quip;
	terminate the conversation.
	
After quipping when the current quip is Revolutionaries_hit_girl:
	disable the Revolutionaries_hit_girl quip;
	enable the Revolutionaries_caretakers_fault quip;

After quipping when the current quip is Revolutionaries_caretakers_fault:
	disable the Revolutionaries_caretakers_fault quip;
	disable the Revolutionaries_wont_listen quip;
	disable the Revolutionaries_just_looking quip;
	enable the Revolutionaries_kill_caretaker quip.

After quipping when the current quip is Revolutionaries_easy:
	disable the Revolutionaries_easy quip;
	enable the Revolutionaries_listen_now quip;

After quipping when the current quip is Revolutionaries_listen_now:
	disable the Revolutionaries_listen_now quip;
	enable the Revolutionaries_warn_you quip;

After quipping when the current quip is Revolutionaries_warn_you:
	say "I let go of the poor sod.";
	disable the Revolutionaries_warn_you quip;
	enable the Revolutionaries_kill_caretaker quip;

After quipping when the current quip is Revolutionaries_kill_caretaker:
	disable the Revolutionaries_kill_caretaker quip;
	enable the Revolutionaries_little_man quip;
	enable the Revolutionaries_symptom quip.

After quipping when the current quip is Revolutionaries_symptom:
	disable the Revolutionaries_little_man quip;
	disable the Revolutionaries_symptom quip;
	enable the Revolutionaries_who_is_behind quip.

After quipping when the current quip is Revolutionaries_little_man:
	disable the Revolutionaries_little_man quip;
	disable the Revolutionaries_symptom quip;
	enable the Revolutionaries_oppression quip.

After quipping when the current quip is Revolutionaries_oppression:
	disable the Revolutionaries_oppression quip;
	enable the Revolutionaries_who_is_behind quip.

After quipping when the current quip is Revolutionaries_who_is_behind:
	disable the Revolutionaries_who_is_behind quip;
	enable the Revolutionaries_America quip;
	enable the Revolutionaries_Britain quip;
	enable the Revolutionaries_China quip;
	
After quipping when the current quip is Revolutionaries_America:
	disable the Revolutionaries_America quip;
	disable the Revolutionaries_Britain quip;
	disable the Revolutionaries_China quip;
	enable the Revolutionaries_hit_something quip;
	now the vacation of the Revolutionaries is America.

After quipping when the current quip is Revolutionaries_Britain:
	disable the Revolutionaries_America quip;
	disable the Revolutionaries_Britain quip;
	disable the Revolutionaries_China quip;
	enable the Revolutionaries_hit_something quip;
	now the vacation of the Revolutionaries is Britain.
	
After quipping when the current quip is Revolutionaries_China:
	disable the Revolutionaries_America quip;
	disable the Revolutionaries_Britain quip;
	disable the Revolutionaries_China quip;
	enable the Revolutionaries_hit_something quip;
	now the vacation of the Revolutionaries is China.

After quipping when the current quip is Revolutionaries_hit_something:
	disable the Revolutionaries_hit_something quip;
	enable the Revolutionaries_group quip.
	
After quipping when the current quip is Revolutionaries_group:
	disable the Revolutionaries_group quip;
	enable the Revolutionaries_means quip;

After quipping when the current quip is Revolutionaries_means:
	disable the Revolutionaries_means quip;
	enable the Revolutionaries_just_looking quip;
	now the revolutionaries are acquainted;
	terminate the conversation.

Book - The smiling face

Chapter - Character

The smiling face is a woman. The description of the smiling face is "[if the age of Ayako is 18]The same face, forever beautiful, always smiling. The same hands, fair and slender.[else]A face befitting a princess. She had a smile for everyone. You could see her veins through the thin, almost entirely white skin at her wrists." The initial appearance of the smiling face is "[if the location is the glass house]She was standing in front of the Coquettii, wearing her second-favourite [italic type]meisen[roman type], if I remembered correctly.[else if the smiling face is dangling and the smiling face is carrying the tampon]She was standing there, dangling the tampon from her thin, pale hand.[else if the location is Balcony_room]She was there, as well.[else]She was here, smiling as always."
Understand "white-handed maiden", "maiden", "white hand/hands", "slender hand/hands" and "girl/senpai/rival/bully/smile" as the smiling face.
The smiling face can be dangling. The smiling face is not dangling.
The smiling face can be slashed. The smiling face is not slashed.

Chapter - Possessions

The smiling face wears wafuku called the meisen. The description of the meisen is "A textile woven from warp-printed silk. This particular kimono had a pattern of multicoloured [italic type]yabame[roman type] on a black surface."
Understand "yabame", "silk" and "warp-printed" as the meisen.
The smiling face wears a sash called the ikat obi. The description of the ikat obi is "A chequered red and white design in tie-dye technique."
Understand "tie-dye" as the ikat obi.
The smiling face carries the tampon. The description of the tampon is "A regular hygiene product, now soaked in 70% denatured alcohol."
Understand "denatured alcohol", "denatured", "hygiene product", "hygiene" and "soaked" as the tampon.

Check dropping the tampon:
	say "No way. Not that it would have mattered much, hygiene-wise,  but I was trying hard to a maintain a minimum of dignity.";
	stop the action.

Check inserting the tampon into something:
	say "No way. Not that it would have mattered much, hygiene-wise,  but I was trying hard to a maintain a minimum of dignity.";
	stop the action.

Check putting the tampon on something:
	say "No way. Not that it would have mattered much, hygiene-wise,  but I was trying hard to a maintain a minimum of dignity.";
	stop the action.

Instead of taking the tampon:
	if the smiling face is dangling:
		say "I snatched the tampon from her.[paragraph break]";
		move the tampon to the player;
		deliver the Smiling_lavatory quip;
		enable the Smiling_doubt quip for the smiling face;
		run a conversation on the Table of Smiling Conversation;

An invitation is a thing. The description of the invitation is "An invitation for tonight, to a place called 'Mahagonny'."
Understand "card" as the invitation.

Chapter - Conversation

The litany of the Smiling face is the Table of Smiling Conversation.
The greeting of the Smiling face is Smiling_greeting.

Table of Quip Texts (continued)
quip						quiptext
Smiling_greeting				"[if Pyjama party is happening]'How nice of you to come, too, Ayako-hime,'[else if the smiling face is dangling]'Oh, no, Ayako-hime. In fact, it's only just started getting enjoyable.'[else if Dying is happening]'Don't talk, Ayako. It'll be easier if you stay silent.'[else if Disarmed is happening][italic type]'Sayônara[roman type], Ayako. Don't cry for me.' she said and managed to show me one last smile.[else if Ayako is invited]'I think there is nothing left to say.'[else if the location is the glass house]'[italic type]Gokigenyô[roman type], Ayako. [italic type]Ohisashiburi[roman type]."
Smiling_letter				"'A letter for Ayako-hime? Let [italic type]senpai[roman type] just check quickly whether it breaks any of the school rules.'"
Smiling_catch_me			"'Would you be so kind, [italic type]senpai[roman type], to hand it back to me, please, is what you wanted to say. Why, you could just as well take it from me, could you not?'"
Smiling_no_honorifics		"'Please, do drop the honorifics,[italic type]senpai[roman type],' is what you wanted to say. But I don't think I can do that. It wouldn't be proper.'"
Smiling_what_to_do			"'Truth or dare, of course. Would you like to join in?'"
Smiling_pass				"'What a pity. I think you should join in. Who else thinks it's Ayako-hime's turn?'"
Smiling_join					"'There we go! It's your turn. Now what should she do if she won't tell the truth?'"
Smiling_no_game			"'Let's see. What else is a game but a voluntary challenge to overcome unnecessary obstacles. You didn't volunteer, so yes, I guess it's not. Now, girls, what is Ayako-hime going to do if she won't tell the truth?'"
Smiling_refuse				"'I wouldn't want to force you to [italic type]drink[roman type] this skin disinfectant anyway. It tastes horrible. Instead, we are going to dip this into it and you'll put it in.'"
Smiling_bring_it_on			"'Are you sure? This skin disinfectant might not be to your liking. Tell you what: We'll dip this into it instead and you'll just put it in.'"
Smiling_cognac				"'You wish. I'm not going to squander half the bottle on interrogating you if I can have the same effect with just this.'"
Smiling_disgusting			"'Right? It's also pretty dangerous, to be honest. You can't stop it from intoxicating you ever more without taking it out again, and we won't allow that before you're entirely wasted.'"
Smiling_try_kill				"'Oh, come on now! You're not afraid of dying, I can see it in your eyes. Besides, all you need to do to avoid the disinfectant, is answer a single question.'"
Smiling_question			"'With whom did you meet so clandestinely last leave weekend?'"
Smiling_dare				"'That's no good! You didn't even hear the question.'"
Smiling_hand_me			"'As you wish, I will let you have your little triumph. Let's see how well you can hold your tongue in 20 minutes.'"
Smiling_nice_to_come		"'How nice of you to come, too, Ayako-hime,' she answered for them."
Smiling_lavatory				"'There's a lavatory down the stairs. Have you used these before, or does [italic type]senpai[roman type] have to show you?'"
Smiling_doubt				"'I somehow doubt that. Anyway, we wouldn't want to have to do it for you, if we can help it. So I trust you'll keep your word.'"
Smiling_surprise				"'I agree, it's a rarity, and rather to my taste. But I trust it wasn't too difficult to get here, was it?'"
Smiling_laeken				"'It's not exactly an easy place to see. To be honest I kind of dread it. It might just stir my envy. And that's just one reason.'"
Smiling_envy				"'Don't be so sure about that. I admire the idea of bringing exotic things from exotic places. Capture the far away by making things take long voyages. It seems a little naive nowadays, but you have to admit the audacity - Palm trees, wrapped in damp cloth, travelling all the way from Africa to a glass house build just for them.'"
Smiling_vacation				"'Sure. Though it doesn't bring them any closer to what their trying to find. I am firmly convinced that banishing all mystery from your own life will make you forever wander the world in search of it.'"
Smiling_leopold				"'Of course. It's a shame they were unable to keep the public out of the place after his death.'"
Smiling_birdcage			"'Perhaps. No matter. It's all going to come to an end, soon enough.'"
Smiling_coffin				"'I might have to accept that, academically speaking, but it doesn't matter anymore. It's all going to come to an end, soon enough.'"
Smiling_other_reason		"'They are said to be so beautiful, they give many a visitor a guilty conscience.'"
Smiling_beauty				"'True beauty need not apologise.'"
Smiling_conscience			"'It would be a little late for that in my case. Some things you just have to live with, and with others, all you can do is to try to apologise.'"
Smiling_teardown		"'Yes. The anomaly of this place has not gone unnoticed by the authorities. There is an ordinance that says it's going to be torn down two months from now.'"
Smiling_boeotia				"'There can be no doubt about that. Take a look at the rest of the city. What do you see?'"
Smiling_corbusier			"'That's right. Those over there I happen to know are by one of Maekawa Kunio's students. But that's detail. It was obviously necessary to fill all of Kanto with brutalism, when a single one will suffice to destroy a town grown over centuries.'"
Smiling_vers_une_architecture	"'[italic type]The plan must rule, the street must disappear.[roman type] We've come a long way towards his misanthropic Utopia, haven't we?'"
Smiling_rebuild_quickly		"'Which he and his like had been hoping for since the early 30s. To reduce the old world to ashes and to rebuild it in the image of their own intellectual enormity. No, Ayako, they weren't acting out of kindness.'"
Smiling_misanthropy		"'How very unfair. I will freely admit my cruel streak gets the better of me sometimes, but I've always preferred to just live with my plants and not make all of mankind miserable.'"
Smiling_bully			"'I didn't know you believed in apologising. Wouldn't it be best to just let bygones be bygones?'"
Smiling_unforgivable		"'The letter?'"
Smiling_cod				"'No. And neither are you. I take it this is about the letter?'"
Smiling_theletter		"'There was no way for me to know what would happen.'"
Smiling_family			"'True. But you knew [italic type]me[roman type], as well. You practically forced my hand, after all that had happened. How could I not take it after that girl had seen it lying around, already?'"
Smiling_death			"'I tried to warn you, you know, but you'd already run away. Why, Ayako? Just why did you have to keep such a secret from me so stubbornly all those years?'"
Smiling_principles		"'I kind of expected you to say that. Fine then, I guess there's no way around it. Here's your invitation. It's totally [italic type]black tie[roman type], but those people will let you in, as you are.'"
Smiling_difficult			"'You never were very good with names. But her problem was not to get here, it was to get away again.'"
Smiling_it_will			"'Now, wait a moment. Wouldn't it be better to part amicably? How about giving me a chance to apologise?'"
Smiling_attire			"'I know. I was just teasing you.'"
Smiling_sleep			"'I take barbiturates. And benzodiazepines. And if that doesn't help, there's always Cognac. But who am I fooling here? What about those guys from downstairs?'"
Smiling_television		"[italic type]'A pastime for helots...'[roman type]"
Smiling_distraction		"[italic type]'...A spectacle that demands no concentration whatsoever, doesn't require any faculty of thought...'[roman type]"
Smiling_remember		"'So you finished reading Duhamel after you ran away. I always knew you were a diligent student.'"
Smiling_history			"'Here's one you don't know yet: [italic type]Discuss the difference between replacement and counter public using historical examples of both.[roman type]'"
Smiling_common		"'To be honest, we missed you.'"
Smiling_ocean			"'On evenings like today's, I feel it looks just like the sea, back at school.'"
Smiling_sea				"'Well, that didn't stop. Incessantly you'd hear it. Did you know no one ever dared dive in from the cliffs except you? You had a lot of admirers, believe it or not.'"
Smiling_ended			"'Regrettably, yes. But don't you still dream of those days, at night? I do it all the time. Beautiful dreams, exciting dreams, sometimes even sad dreams. As long as we have them, nothing's ever really gone, Ayako.'"
Smiling_nightmares		"'I'm sorry to hear that. Can't we put this behind us somehow? You will have to admit I never had the chance to apologise.'"
Smiling_sparta			"'To fulfil its destiny? That's the kind of thing I could see you writing in a history assignment. But you don't have to pretend to rationalise for me.'"
Smiling_rationalising		"'So you believe in class war from below for the multitude while you see your own role as waging it from above. Strange position to take.'"
Smiling_defenceless		"'Sometimes I wonder. I do recall one victim of mine whom I wrong footed. She gave up the fight.'"
Smiling_here_now		"'Thank you for taking that weight of my conscience. What can I say? I didn't intend the whole business about the letter to turn out like it did. But you know that already.'"
Smiling_favour			"'Don't tell me it was a sexual favour, Ayako?'"
Smiling_sex				"'Forget I asked. You wouldn't know. To satisfy your curiosity: it's a bit like masturbation, but with two people.'"
Smiling_liberty			"'I can see where you're coming from. I just thought I'd mention they were entirely peaceful, sitting in front of their TV.'"
Smiling_freedom		"'Did it ever cross your mind that your kind of freedom might not be for everyone?'"
Smiling_greenhouse		"'Thank you, but it hardly matters, anymore. It's all coming to an end, anyway.'"
Smiling_existence		"'So here we are. Yes, Ayako, I, too, remember that letter well, every day and - would you believe it? - every night. You might not know it, but I tried to apologise. Then again, what amendments could I have possibly made?'"
Smiling_challenge 		"[if Ayako is challenged]'I see you have made your bet. Shall we go then?'[else if Ayako is cashed]'Before you leave, I believe there is still some unfinished business. Shall we go then?'[else if Ayako is broke]'And that was the last one. Shall we go then?'[end if] she said, smiling."
Smiling_pick_up			"'Go on, pick it up.' she commanded.'"
Smiling_enough			"'Isn't this enough?' she asked.'"
Smiling_does_hurt		"'It hurts, doesn't it? Why don't you call it quits now? she asked."
Smiling_dont_fight		"'Don't fight it, Ayako. It'll be easier that way.'"
Smiling_breathe_last		"'Do you seriously think that will bring back your happiness?'"
Smiling_not_sure		"'You're a little late with that insight.'"
Smiling_matter			"'You're right, it doesn't.'"

Table of Smiling Conversation
prompt												response					enabled
"'Give that back!'"									Smiling_catch_me			0
"'I wish you wouldn't call me that.'"					Smiling_no_honorifics		0
"'Whatever. What do we do until the moon rises?'"	Smiling_what_to_do			0
"'Thanks, but I'll pass.'"								Smiling_pass				0
"'OK, I'll join.'"										Smiling_join					0
"'This is not really a game, is it?'"					Smiling_no_game			0
"'I refuse to take part in this.'"						Smiling_refuse				0
"'OK, bring it on. Alcohol won't scare me.'"			Smiling_bring_it_on			0 
"'Thank you, but I'd prefer the [italic type]Fontaine de la Pouyade[roman type] in your cabinet.'"			Smiling_cognac			0
"'How original. It sounds absolutely disgusting.'"	Smiling_disgusting			0
"'It's appropriately horrible. I should have seen this coming.'"		Smiling_disgusting			0
"'The agony phase could be difficult to watch for some of you.'"		Smiling_try_kill				0
"'Will you put fresh flowers on my grave once in a while, please?'"		Smiling_try_kill				0
"'Go ahead, ask.'"									Smiling_question			0
"'It's dare for me.'"									Smiling_dare				0
"'Hand me the tampon.'"							Smiling_hand_me			0
"'I'll be fine.'"										Smiling_doubt				0
"'[italic type]Ohisashiburi desu ne[roman type]. I have to admit, this place is a bit of a surprise.'"	Smiling_surprise				0
"'It's lovely. Did you get a chance to visit the Laeken greenhouses, yet?'"	Smiling_laeken		0	
"'If it were me, I'd try to just admire the project, instead. Though that may well be impossible for you.'"		Smiling_envy				0
"'I guess. But these days, people can just go to those far-away places themselves.'"	Smiling_vacation		0
"'So disappointment is inevitable, but you prefer not to find fulfilment by staying in this bird cage?'"	Smiling_birdcage	0
"'That last part is debatable. I'd argue Laeken was build for Leopold II, not for the trees.'"		Smiling_leopold		0
"'And that way of looking at the rest of the world is one trait you share with him, amongst others.'"		Smiling_misanthropy		0
"'He preferred to die in his green house, which, by extension, makes this place a glass coffin, too.'"		Smiling_coffin	0
"'And what's the other reason?'"					Smiling_other_reason		0
"'Let's see. What could possibly justify the slaughter of so many people far away in Africa for the sake of the personal enjoyment of an old lecher who only became King because they needed a figurehead for an non-nation, which - although few who lived there identified with it - was deemed necessary to uphold the balance of interest between the neighbouring countries?'"		Smiling_beauty		0
"'Don't tell me you're afraid of a guilty conscience?'"			Smiling_conscience			0
"'Come to an end?'"									Smiling_teardown			0
"'They'll replace it with something more appealing to their Boeotian sensibilities.'"		Smiling_boeotia		0
"'A collection of monstrosities by the heirs of Le Corbusier's acolytes?'"		Smiling_corbusier	0
"'I prefer not to look at it too closely. But on the other side you have a splendid view of the ocean.'"		Smiling_ocean	0
"'Which was the whole point of [italic type]Vers une architecture[roman type].'"		Smiling_vers_une_architecture	0
"'To be fair, they had to rebuild quickly, after the war.'"		Smiling_rebuild_quickly		0
"'Not all of mankind.'"								Smiling_bully		0
"'Oh, yes. It certainly will.'"		Smiling_it_will	0
"'Nothing wrong with apologies. But some things are unforgivable.'"		Smiling_unforgivable		0
"'[italic type]Cod's trouble, when ended, is soon mended.[roman type] Are you a cod?'"	Smiling_cod		0
"'The letter was important.'"						Smiling_theletter		0
"'What did you expect to happen? You knew my family.'"	Smiling_family		0
"'As you will learn one day, too, death does not stop for anyones vain little schemes.'"	Smiling_death	0
"'It seems there remain some things that you still don't understand. But I'll gladly teach them to you, just once more.'"	Smiling_principles	0
"'It hardly matters anymore. There are questions of principle to be answered now.'"		Smiling_principles	0
"'As if I'd let that happen. If I go there, I'll wear appropriate attire. I won't disappoint your sensibilities.'"		Smiling_attire	0
"'It wasn't difficult for me. It seemed to be much more difficult for...what was her name again?'"		Smiling_difficult		0
"'I wonder how you can sleep at night.'"		Smiling_sleep		0
"'They were watching television. Entirely different story.'"		Smiling_television		0
"[italic type]'...A distraction for illiterate, miserable, worn-out creatures, eaten by their troubles...'[roman type]"		Smiling_distraction		0
"[italic type]'...that sparks no light in the heart, and raises no hope except the ridiculous one to become a star in Los Angeles one day.'[roman type]"	Smiling_remember		0
"'I remember the sound of the waves crashing into the cliffs at night.'"		Smiling_sea		0
"'Fantastic. I can see us sitting in the common room trying to make something of it.'"	Smiling_common	0
"'I hear it wasn't long before they ended it all.'"				Smiling_ended		0
"'As you know, all my dreams have turned into nightmares. I try to avoid sleeping altogether.'"	Smiling_nightmares		0
"'Shouldn't Sparta better live in perpetual fear of a helot uprising?'"		Smiling_sparta		0
"'I remember those essay questions. They were your favourite subject, not mine.'"		Smiling_history	0
"'No rationalising on my part. A lady should always mean what she says.'"	Smiling_rationalising		0
"'Not so strange, after all. You never preyed on the defenceless, either.'"	Smiling_defenceless		0
"'I wouldn't crucify myself because of that, if I were you. After all, I am here now.'"		Smiling_here_now		0
"'I did them a favour.'"		Smiling_favour		0
"'I beg your pardon?'"		Smiling_sex			0
"'I'll make a note of it. The favour I was talking about was to liberate them from their meaningless existence.'"	Smiling_liberty	0
"'They turned violent the moment I switched it off. That is their true calling. I gave purpose to their lives. I gave them freedom from the machine that kept them in thrall.'"	Smiling_freedom	0
"'Ah, but you misunderstand. I'm not doing this by choice. There were some circumstances that forced me into this existence. But what am I telling you here, when you know all about it.'"		Smiling_existence		0
"'You wouldn't understand. I've told you before, you are best at maintaining your own garden. It's wonderful, by the way'"		Smiling_greenhouse		0
"A dreadful sound came out of my slit throat."		Smiling_dont_fight		0 
"'I will call it quits when you breathe your last.'"		Smiling_breathe_last		0
"'Does it matter, anymore?'"						Smiling_matter			0	
"'I used to think so, but I am not so sure, anymore.'"	Smiling_not_sure		0

Before quipping when the current quip is Smiling_greeting:
	if Pyjama party is happening:
		unless the smiling face is dangling:
			say "I said '[italic type]gokigenyô[roman type]' to her.[paragraph break]";
		else:
			say "'I think the joke has gone far enough now.' I said.[paragraph break]";
	else if the location is the glass house and Ayako is not invited:
		say "I said '[italic type]gokigenyô[roman type]' to her.[paragraph break]";
		enable the Smiling_surprise quip for the smiling face;
	else if the location is the ring:
		if Dying is happening:
			say "A dreadful sound came out of my slit throat.[paragraph break]";
		else if Disarmed is happening:
			say "I meant to say [italic type]'Shinde kudasai'[roman type] to her, but the words wouldn't come out. I was welling up. It's not true. I was crying.[paragraph break]"

After quipping when the current quip is Smiling_does_hurt:
	enable the Smiling_breathe_last quip for the smiling face;

After quipping when the current quip is Smiling_breathe_last:
	enable the Smiling_matter quip for the smiling face;
	enable the Smiling_not_sure quip for the smiling face.
	
After quipping when the current quip is Smiling_matter:
	disable the Smiling_not_sure quip;
	terminate the conversation;
	the struggle resumes in 0 turns from now.

After quipping when the current quip is Smiling_enough:
	enable the Smiling_breathe_last quip for the smiling face;

After quipping when the current quip is Smiling_favour:
	disable the Smiling_favour quip;
	disable the Smiling_television quip;
	enable the Smiling_sex quip;
	
After quipping when the current quip is Smiling_sex:
	disable the Smiling_sex quip;
	enable the Smiling_liberty quip;

After quipping when the current quip is Smiling_liberty:
	disable the Smiling_liberty quip;
	enable the Smiling_freedom quip;

After quipping when the current quip is Smiling_freedom:
	disable the Smiling_freedom quip;
	enable the Smiling_existence quip;
	enable the Smiling_greenhouse quip;

After quipping when the current quip is Smiling_surprise:
	disable the Smiling_surprise quip;
	enable the Smiling_laeken quip;
	enable the Smiling_difficult quip;

After quipping when the current quip is Smiling_difficult:
	disable the Smiling_laeken quip;
	disable the Smiling_difficult quip;
	enable the Smiling_sleep quip;

After quipping when the current quip is Smiling_sleep:
	disable the Smiling_sleep quip;
	enable the Smiling_television quip;
	enable the Smiling_favour quip;

After quipping when the current quip is Smiling_television:
	disable the Smiling_television quip;
	disable the Smiling_favour quip;
	enable the Smiling_distraction quip;
	enable the Smiling_sparta quip;

After quipping when the current quip is Smiling_sparta:
	disable the Smiling_distraction quip;
	disable the Smiling_sparta quip;
	enable the Smiling_history quip;
	enable the Smiling_rationalising quip;

After quipping when the current quip is Smiling_rationalising:
	disable the Smiling_history quip;
	disable the Smiling_rationalising quip;
	enable the Smiling_defenceless quip;

After quipping when the current quip is Smiling_defenceless:
	disable the Smiling_defenceless quip;
	enable the Smiling_here_now quip;
	
After quipping when the current quip is Smiling_here_now:
	disable the Smiling_here_now quip;
	enable the Smiling_family quip;

After quipping when the current quip is Smiling_distraction:
	disable the Smiling_distraction quip;
	disable the Smiling_sparta quip;
	enable the Smiling_remember quip;

After quipping when the current quip is Smiling_remember:
	disable the Smiling_remember quip;
	enable the Smiling_history quip;
	enable the Smiling_sea quip;

After quipping when the current quip is Smiling_history:
	disable the Smiling_history quip;
	disable the Smiling_rationalising quip;
	disable the Smiling_sea quip;
	enable the Smiling_common quip;

After quipping when the current quip is Smiling_common:
	disable the Smiling_common quip;
	enable the Smiling_ended quip;

After quipping when the current quip is Smiling_ended:
	disable the Smiling_ended quip;
	enable the Smiling_nightmares quip;

After quipping when the current quip is Smiling_nightmares:
	disable the Smiling_nightmares quip;
	enable the Smiling_unforgivable quip;
	enable the Smiling_cod quip;

After quipping when the current quip is Smiling_ocean:
	disable the smiling_ocean quip;
	disable the smiling_corbusier quip;
	enable the Smiling_sea quip;

After quipping when the current quip is Smiling_sea:
	disable the Smiling_history quip;
	disable the Smiling_sea quip;
	enable the Smiling_ended quip;

After quipping when the current quip is Smiling_laeken:
	disable the Smiling_laeken quip;
	disable the Smiling_difficult quip;
	enable the Smiling_envy quip;
	enable the Smiling_other_reason quip;

After quipping when the current quip is Smiling_envy:
	disable the Smiling_envy quip;
	disable the Smiling_other_reason quip;
	enable the Smiling_vacation quip;
	enable the Smiling_leopold quip;
	
After quipping when the current quip is Smiling_other_reason:
	disable the Smiling_envy quip;
	disable the Smiling_other_reason quip;
	enable the Smiling_beauty quip;
	enable the Smiling_conscience quip;

After quipping when the current quip is Smiling_beauty:
	disable the Smiling_beauty quip;
	disable the Smiling_conscience quip;
	enable the Smiling_misanthropy quip;

After quipping when the current quip is Smiling_conscience:
	disable the Smiling_beauty quip;
	disable the Smiling_conscience quip;
	enable the Smiling_unforgivable quip;
	enable the Smiling_cod quip;

After quipping when the current quip is Smiling_misanthropy:
	disable the Smiling_misanthropy quip;
	disable the Smiling_coffin quip;
	enable the Smiling_bully quip;

After quipping when the current quip is Smiling_bully:
	disable the Smiling_bully quip;
	enable the Smiling_unforgivable quip;
	enable the Smiling_cod quip;
	
After quipping when the current quip is Smiling_vacation:
	disable the Smiling_vacation quip;
	disable the Smiling_leopold quip;
	enable the Smiling_birdcage quip;

After quipping when the current quip is Smiling_birdcage:
	disable the Smiling_birdcage quip;
	enable the Smiling_teardown quip;
	enable the Smiling_it_will quip;
	
After quipping when the current quip is Smiling_greenhouse:
	disable the Smiling_greenhouse quip;
	disable the Smiling_existence quip;
	enable the Smiling_teardown quip;
	enable the Smiling_it_will quip;

After quipping when the current quip is Smiling_existence:
	disable the Smiling_greenhouse quip;
	disable the Smiling_existence quip;
	enable the Smiling_unforgivable quip;
	enable the Smiling_cod quip;

After quipping when the current quip is Smiling_leopold:
	disable the Smiling_vacation quip;
	disable the Smiling_leopold quip;
	enable the Smiling_coffin quip;
	enable the Smiling_misanthropy quip;

After quipping when the current quip is Smiling_coffin:
	disable the Smiling_coffin quip;
	enable the Smiling_teardown quip;
	enable the Smiling_it_will quip;

After quipping when the current quip is Smiling_it_will:
	disable the Smiling_teardown quip;
	disable the Smiling_it_will quip;
	enable the Smiling_unforgivable quip;
	enable the Smiling_cod quip;
	
After quipping when the current quip is Smiling_unforgivable:
	disable the Smiling_unforgivable quip;
	disable the Smiling_cod quip;
	enable the Smiling_theletter quip;

After quipping when the current quip is Smiling_cod:
	disable the Smiling_unforgivable quip;
	disable the Smiling_cod quip;
	enable the Smiling_theletter quip;

After quipping when the current quip is Smiling_theletter:
	disable the Smiling_theletter quip;
	enable the Smiling_family quip;
	
After quipping when the current quip is Smiling_family:
	disable the Smiling_family quip;
	enable the Smiling_death quip;
	
After quipping when the current quip is Smiling_death:
	disable the Smiling_death quip;
	enable the Smiling_principles quip;

After quipping when the current quip is Smiling_principles:
	disable the Smiling_principles quip;
	enable the Smiling_attire quip;
	
After quipping when the current quip is Smiling_attire:
	disable the Smiling_attire quip;
	now Ayako is invited;
	say "She gave me a card.";
	now Ayako carries the invitation;
	now the previous hint is the current hint;
	now the current hint is "invited";
	terminate the conversation;

After quipping when the current quip is Smiling_teardown:
	disable the Smiling_teardown quip;
	disable the Smiling_it_will quip;
	enable the Smiling_boeotia quip;

After quipping when the current quip is Smiling_boeotia:
	disable the Smiling_boeotia quip;
	enable the Smiling_corbusier quip;
	enable the Smiling_ocean quip;

After quipping when the current quip is Smiling_corbusier:
	disable the Smiling_corbusier quip;
	disable the Smiling_ocean quip;
	enable the Smiling_vers_une_architecture quip;
	enable the Smiling_rebuild_quickly quip;

After quipping when the current quip is Smiling_vers_une_architecture:
	disable the Smiling_vers_une_architecture quip;
	disable the Smiling_rebuild_quickly quip;
	enable the Smiling_misanthropy quip;
 
After quipping when the current quip is Smiling_rebuild_quickly:
	disable the Smiling_vers_une_architecture quip;
	disable the Smiling_rebuild_quickly quip;
	enable the Smiling_misanthropy quip;
	
After quipping when the current quip is Smiling_catch_me:
	say "And with that, she escaped to the east while two other girls covered her retreat.[paragraph break]";
	now the smiling face is in the Balcony_Room;
	now the girls are in School_lockers;
	terminate the conversation.

After quipping when the current quip is Smiling_nice_to_come:
	enable the Smiling_no_honorifics quip for the Smiling face;

After quipping when the current quip is Smiling_greeting:
	if Pyjama party is happening and the smiling face is not dangling:
		enable the Smiling_no_honorifics quip for the Smiling face;
	else:
		terminate the conversation.

After quipping when the current quip is Smiling_no_honorifics:
	enable the Smiling_what_to_do quip;

After quipping when the current quip is Smiling_what_to_do:
	enable the Smiling_pass quip;
	enable the Smiling_join quip;
	
After quipping when the current quip is Smiling_pass:
	disable the Smiling_pass quip;
	disable the Smiling_join quip;
	enable the Smiling_no_game quip;
	say "'We all do!' They answered in unison.[paragraph break]"

After quipping when the current quip is Smiling_no_game:
	enable the Smiling_refuse quip;
	enable the Smiling_bring_it_on quip;
	say "'She's going to have to drink, of course,' giggled the others.[paragraph break]"

After quipping when the current quip is Smiling_join:
	disable the Smiling_pass quip;
	disable the Smiling_join quip;
	enable the Smiling_refuse quip;
	enable the Smiling_bring_it_on quip;
	say "'She's going to have to drink, of course,' giggled the others.[paragraph break]"

After quipping when the current quip is Smiling_refuse:
	disable the Smiling_refuse quip;
	disable the Smiling_bring_it_on quip;
	enable the Smiling_cognac quip;
	enable the Smiling_disgusting quip;
	say "She dangled a tampon in front of me.[paragraph break]";

After quipping when the current quip is Smiling_bring_it_on:
	disable the Smiling_refuse quip;
	disable the Smiling_bring_it_on quip;
	enable the Smiling_cognac quip;
	enable the Smiling_disgusting quip;
	say "She dangled a tampon in front of me.[paragraph break]";

After quipping when the current quip is Smiling_cognac:
	disable the Smiling_cognac quip;
	disable the Smiling_disgusting quip;
	enable the Smiling_try_kill quip;	

After quipping when the current quip is Smiling_disgusting:
	disable the Smiling_cognac quip;
	disable the Smiling_disgusting quip;
	enable the Smiling_try_kill quip;

After quipping when the current quip is Smiling_try_kill:
	disable the Smiling_try_kill quip;
	enable the Smiling_question quip;
	enable the Smiling_dare quip;	

After quipping when the current quip is Smiling_question:
	disable the Smiling_question quip;
	disable the Smiling_dare quip;
	enable the smiling_hand_me quip;

After quipping when the current quip is Smiling_dare:
	disable the Smiling_dare quip;
	enable the Smiling_question quip;
	enable the Smiling_hand_me quip;
	
After quipping when the current quip is Smiling_hand_me:
	disable the Smiling_hand_me quip;
	disable the Smiling_dare quip;
	disable the Smiling_question quip;
	now the smiling face is dangling;
	terminate the conversation.

After quipping when the current quip is Smiling_doubt:
	disable the Smiling_doubt quip;
	terminate the conversation;

Book - The girls

Chapter - Characters

The girls are a plural-named woman. The description of the girls is "In my memories, all girls look the same in their uniforms. Almost all."
The initial appearance of the girls is "[If the location is Balcony_Room]The others were all there.[else if the girls are surrendered]The two girls had stepped aside and the way to the [bold type]east[roman type] was open. [else]Two girls were blocking the way to the [bold type]east[roman type]."
Understand "girl/others/twins" as the girls.

The girls can be surrendered. The girls are not surrendered.

Chapter - Conversation

The litany of the girls is the Table of Girls Conversation.
The greeting of the girls is Girls_greeting.

Table of Quip Texts (continued)
quip						quiptext
Girls_greeting				"[If Last straw is happening]'We don't know, she didn't tell us.'[else if Pyjama Party is happening]'You should talk to [italic type]senpai[roman type].'"
Girls_make_way				"'We don't want any trouble with you, anyway.'"

Table of Girls Conversation
prompt											response					enabled
"'Get out of my way.'"							Girls_make_way				0

Before quipping when the current quip is Girls_greeting:
	if Last straw is happening:
		say "'Where is she going?' I asked them.[paragraph break]";
		enable the Girls_make_way quip for the girls;
	else if the smiling face is dangling:
		say "'And you guys are OK with this?'[paragraph break]";
	else if Pyjama party is happening:
		say "I said '[italic type]gokigenyô[roman type]' to the others.[paragraph break] ";
		
After quipping when the current quip is Girls_greeting:
	if Last straw is happening:
		terminate the conversation;
	else:
		terminate the conversation;
		
After quipping when the current quip is Girls_make_way:
	say "They raised their hands as if I was armed.";
	now the girls are surrendered;
	terminate the conversation.

Book - The refuse collector

Chapter - Character

Hanazono  is a woman  in _waste_dump_1. The printed name of Hanazono is "[if Hanazono is acquainted]Hanazono-san[else]woman".
The description of Hanazono is "She must have been in her late 20s."
The initial appearance of Hanazono is "[if acquainted]Hanazono-san[else]A woman[end if] was going about her business of [one of]fixing[or]refitting[or]painting[or]cleaning[or]oiling[at random] some part of a machine."
Hanazono is improper-named.
Hanazono can be interrogated. Hanazono is not interrogated.

Chapter - Possessions

Hanazono carries a torch. The torch is a valuable, watertight device. The torch is not lit. The description of the torch is "A battery-powered light source.".
Understand "torch/light/flashlight/source/illuminator" and "light source" as the torch.

[A tyre is a valuable heavy watertight undescribed thing. The description of the tyre is "A worn-out lorry tyre, rather heavy.".
Understand "worn-out", "tire" and "lorry tyre" as the tyre.
Hanazono carries the tyre.]

A steel girder is a valuable heavy watertight undescribed thing. The description of the steel girder is "A heavy, rusty piece of metal.".
Understand "metal/rusty" as the steel girder.
Hanazono carries the steel girder.

A part of the torch is a container called the battery compartment. The description of the battery compartment is "'This small box-like compartment was where the battery went in."
The battery compartment is closed and openable.

The _battery is a privately-named thing in the battery compartment. The description of the _battery is "A standard battery."
Understand "battery" as the battery.

Check opening the battery compartment:
	if the location is in subsurface and the location is not an air bubble:
		say "Opening the battery compartment here might have damaged what was inside. Better not.";

Check swimming:
	if the player carries the torch and the battery compartment is open:
		say "(first closing the battery compartment)";
		try closing the battery compartment;
		if the battery compartment is open:
			say "I didn't want to risk damaging the torch by swimming with the battery compartment open.";
			stop the action;

Check going to a room in subsurface:
	if the player carries the torch and the battery compartment is open:
		say "(first closing the battery compartment)";
		try closing the battery compartment;
		if the battery compartment is open:
			say "I didn't want to risk damaging the torch by swimming with the battery compartment open.";
			stop the action;

Does the player mean doing something with the _battery: it is likely.
Does the player mean doing something with the battery compartment: it is unlikely.

Carry out taking the _battery from the battery compartment:
	now the torch is unlit;
	continue the action;
	
Carry out inserting the _battery into the battery compartment:
	if the torch is switched on:
		now the torch is lit;
	
Check inserting something into the battery compartment:
	if the noun are not the tickets and the noun is not the _battery:
		say "That didn't belong in there.";
		stop the action;

Check opening the torch:
	try opening the battery compartment instead;

Check closing the torch:
	try closing the battery compartment instead;

Carry out switching on the torch:
	now the torch is lit;
	continue the action.
	
Carry out switching off the torch:
	now the torch is unlit;
	continue the action.

Check burning the torch:
	try switching on the torch instead;

The trade item is a thing that varies.
The return item is a thing that varies. The return item is the torch.

Chapter - Conversation

The litany of Hanazono is the Table of Hanazono Conversation.
The greeting of Hanazono is Hanazono_greeting.

Table of Quip Texts (continued)
quip						quiptext
Hanazono_greeting			"'[italic type]Konnichi ha[roman type]. What can I do for you?'"
Hanazono_just_looking		"'Look all you want, It's free.'"
Hanazono_what_place		"'What do you mean: This junkyard in the bay or this junkyard of a bay?'"
Hanazono_junkyard			"'It all started out five years ago when Tachibana's electric minibus flopped. The backlog in the distribution chain led to a couple of ships dumping their cargo while they were at anchor here. Didn't know how shallow the shoals are, I guess. The rest caught on.'"
Hanazono_perpetrators		"'Didn't have any consequences for them, what so ever. They got away clean, and that's certainly more than can be said about any of the other ships in this bay."
Hanazono_bay				"'It's a junkyard for ships. They're empty shells now. Stripped them of everything useful.'"
Hanazono_ships				"'They're no better than the junk you're standing on. Last week, when they tried to move one to a different anchorage, it sank in the middle of the bay.'"
Hanazono_wreck			"'Yes, seriously. Not like anyone seemed to care much. I wish It happened to that tub everyone feels the need to visit so often.'" 
Hanazono_tub				"'Forget about it. Best not to bother. Anything else I can help you with?'" 
Hanazono_find				"'It's not impossible to find things here, but they[']re not always what you were looking for.'"
Hanazono_not_sure			"'Tell you what: You help me sort though this pile of garbage around us for a while and maybe we can find what you need in the process.'"
Hanazono_what_do			"'Here's what we'll do: Each time you bring me something of use to me, I'll give you something in return, which looks as though it might be of use to you."
Hanazono_fair_enough		"'Great. Name's Hanazono, by the way.'"
Hanazono_Ayako			"But she was already back at her work."
Hanazono_trade				"'Alright. Let me see what you've got, there...[no line break][run paragraph on]"
Hanazono_yes				"'Thanks. What would you like to have in return?."
Hanazono_no				"'That's too bad. Come back when you really want to trade with me.'"
Hanazono_item				"'Alright. I guess you could use this [return item].'"
Hanazono_will_do			"'Great! It's a deal.'"
Hanazono_wont_do			"'Aw, such a shame. I think it would have been a great deal.'"
Hanazono_money			"[unless the player carries the coin]'If you must have money: Here you go.'[else]'But you have money already. You don't need any more.'"

Table of Hanazono Conversation
prompt											response					enabled
"'I don't know, maybe I'm just looking.'"		Hanazono_just_looking		0
"'What is this place?'"							Hanazono_what_place		0
"'This junkyard.'"								Hanazono_junkyard			0
"'Surely the perpetrators were punished severely.'"	Hanazono_perpetrators	0
"'Seriously? It sank?'"							Hanazono_wreck			0
"'What tub? Why do they go there?'"			Hanazono_tub				0
"'This bay.'"									Hanazono_bay				0
"'You mean they've been laid up. They're not wrecks, are they?'"	Hanazono_ships		0
"'Do you think I might find what I'm looking for, here?'"		Hanazono_find	0
"'I'm not entirely sure what I'm looking for.'"	Hanazono_not_sure			0
"'OK, what do I have to do, exactly?'"			Hanazono_what_do			0
"'Alright, fair enough.'"							Hanazono_fair_enough		0
"'I'm Ayako.'"									Hanazono_Ayako			0								
"'I'd like to trade with you'"						Hanazono_trade				0
"'Yes."											Hanazono_yes				0
"'No.'"											Hanazono_no				0
"'I'd like you to give me something you believe I might need."	Hanazono_item	0
"'[The return item] might do.'"						Hanazono_will_do			0
"'[The return item] won't do.'"						Hanazono_wont_do			0
"'How about you pay me in cash?'"				Hanazono_money			0

Before quipping when the current quip is Hanazono_greeting:
	say "I said '[italic type]konnichi ha[roman type]' to [if Hanazono is acquainted]Hanazono[else]the woman.[paragraph break]";
		
After quipping when the current quip is Hanazono_greeting:
	if Hanazono is not interrogated:
		enable the Hanazono_what_place quip for Hanazono;
	else if Hanazono is not acquainted:
		enable the Hanazono_find quip for Hanazono;
	else if Hanazono is acquainted:
		enable the Hanazono_trade quip for Hanazono;
	enable the Hanazono_just_looking quip for Hanazono.

After quipping when the current quip is Hanazono_just_looking:
	terminate the conversation.

After quipping when the current quip is Hanazono_what_place:
	disable the Hanazono_just_looking quip;
	disable the Hanazono_what_place quip;
	enable the Hanazono_junkyard quip;
	enable the Hanazono_bay quip.

After quipping when the current quip is Hanazono_junkyard:
	disable the Hanazono_junkyard quip;
	disable the Hanazono_bay quip;
	enable the Hanazono_perpetrators quip.
	
After quipping when the current quip is Hanazono_bay:
	disable the Hanazono_junkyard quip;
	disable the Hanazono_bay quip;
	enable the Hanazono_ships quip.

After quipping when the current quip is Hanazono_perpetrators:
	disable the Hanazono_perpetrators quip;
	enable the Hanazono_ships quip.

After quipping when the current quip is Hanazono_ships:
	disable the Hanazono_ships quip;
	enable the Hanazono_wreck quip.

After quipping when the current quip is Hanazono_wreck:
	disable the Hanazono_wreck quip;
	now the previous hint is the current hint;
	now the current hint is "sunk_ship"; 
	enable the Hanazono_tub quip.
	
After quipping when the current quip is Hanazono_tub:
	disable the Hanazono_tub quip;
	enable the Hanazono_just_looking quip;
	now Hanazono is interrogated;
	enable the Hanazono_find quip.

After quipping when the current quip is Hanazono_find:
	disable the Hanazono_just_looking quip;
	disable the Hanazono_find quip;
	enable the Hanazono_not_sure quip;

After quipping when the current quip is Hanazono_not_sure:
	disable the Hanazono_not_sure quip;
	enable the Hanazono_what_do quip;
	
After quipping when the current quip is Hanazono_what_do:
	disable the Hanazono_what_do quip;
	enable the Hanazono_fair_enough quip;

After quipping when the current quip is Hanazono_fair_enough:
	disable the Hanazono_fair_enough quip;
	enable the Hanazono_Ayako quip;
	
After quipping when the current quip is Hanazono_Ayako:
	disable the Hanazono_Ayako quip;
	now Hanazono is acquainted;
	now Hanazono is proper-named;
	terminate the conversation.

After quipping when the current quip is Hanazono_trade:
	disable the Hanazono_just_looking quip;
	disable the Hanazono_trade quip;
	let X be a random valuable thing carried by the player;
	if X is the trade item:
		let X be a random valuable thing carried by the player;
	if X is nothing:
		say "sorry, but I don't think you've got anything I could use on you.'";
		terminate the conversation;
	else:
		now the trade item is X;
		if X is the umbrella:
			say "how about you give me the umbrella. Maybe it can be repaired, and umbrellas always sell when it rains.'";
		else:
			say "how about you give me [the X]?'[paragraph break]";
		enable the Hanazono_yes quip;
		enable the Hanazono_no quip;

After quipping when the current quip is Hanazono_no:
	disable the Hanazono_no quip;
	disable the Hanazono_yes quip;
	terminate the conversation.

After quipping when the current quip is Hanazono_yes:
	disable the Hanazono_no quip;
	disable the Hanazono_yes quip;
	let Y be a random valuable thing carried by Hanazono;
	if Y is the return item:
		let Y be a random valuable thing carried by Hanazono;
	now the return item is Y;
	enable the Hanazono_item quip;
	enable the Hanazono_money quip;
	
After quipping when the current quip is Hanazono_item:
	disable the Hanazono_item quip;
	disable the Hanazono_money quip;
	enable the Hanazono_will_do quip;
	enable the Hanazono_wont_do quip;

After quipping when the current quip is Hanazono_will_do:
	disable the Hanazono_will_do quip;
	disable the Hanazono_wont_do quip;
	say "We exchanged what we had agreed on.";
	now the player carries the return item;
	now Hanazono carries the trade item;
	terminate the conversation;

After quipping when the current quip is Hanazono_wont_do:
	disable the Hanazono_will_do quip;
	disable the Hanazono_wont_do quip;
	terminate the conversation.

After quipping when the current quip is Hanazono_money:
	disable the Hanazono_money quip;
	disable the Hanazono_item quip;
	unless the player carries the coin:
		say "She gave me a 100 yen coin.";
		now the player carries the coin;
	terminate the conversation.
	
Book - The chief engineer

Chapter - Character

The chief engineer is a man in shaft_alley_west. The printed name of the chief engineer is "[if the chief engineer is acquainted]chief engineer[else]man".
The description of the chief engineer is "[if asleep]He was fast asleep.[else]He didn't look his best that day."
The initial appearance of the chief engineer is "[if acquainted]The chief engineer[else]A man[end if] was [if asleep]sleeping[else]sitting[end if] in there."
The chief engineer is improper-named.
The chief engineer can be interrogated. The chief engineer is not interrogated.
The chief engineer can be doomed. The chief engineer is not doomed.
The chief engineer can be asleep. The chief engineer is not asleep.

Check examining the chief engineer:
	if the chief engineer is asleep and the chief engineer carries the tickets:
		say "I quickly found the tickets.";
		now the player carries the tickets;
		now the current hint is "transport_tickets";
		stop the action;

Chapter - Possessions

The chief engineer carries the tickets. The tickets are plural-named. The description of the tickets is "Three tickets for an aeroplane to [vacation of the Revolutionaries], valid today." 
The chief engineer carries the master key. The description of the master key is "A perfectly normal-looking key." The master key unlocks the pantry-galley bulkhead. The master key unlocks the fuel-engine bulkhead. The master key is watertight.

Chapter - Conversation

The litany of the chief engineer is the Table of Chief Conversation.
The greeting of The chief engineer is Chief_greeting.

Table of Quip Texts (continued)
quip						quiptext
Chief_greeting			"[if the chief engineer is acquainted]'Welcome back.'[else if the chief engineer is doomed]'Hello there. Did you manage to get help?'[else if the chief engineer is asleep]There was no response.[else]'Am I dreaming? Are you a mermaid.'"
Chief_just_looking		"'That's all right. Come back any time!'"
Chief_mermaid			"'So you're not denying it.'"
Chief_who_are_you		"'I'm the chief engineer of this vessel. I'm sorry for the state she's in, right now.''"
Chief_better_living		"'I'm afraid I'll have to stay with her for the rest of my career. Unless, of course, you know a way for me to escape.'"
Chief_breath			"'A minute or so when I was a little boy, perhaps a little less nowadays.'"
Chief_chamber			"'Would you mind asking for one, topside?'"
Chief_help				"'Thanks a lot. I'll wait here.'"
Chief_insurance			"'Look, I'm an American. Americans don't do health insurance. You might not know this, [']cause it's not very well understood outside the US, but health insurance is a socialist concept, and therefore totally counter to the American way of life.'"
Chief_hold				"'Please don't joke about this. There wouldn't be enough air in here to train that kind of skill anyway. It's not a realistic option.'"
Chief_problem			"'Oh, you mean the rescue is going to be expensive? Never mind, I'll sue the ship's owners for the money.'"
Chief_option				"'What so you mean? I thought you called rescue services?'"
Chief_fear				"'They'd better. My lawyer is going to rake them over the coals.'"
Chief_no_rescue			"'I know. I knew when she went down there would be no rescue. It's just that when you turned up, there appeared to be this glimmer of hope. I'm sorry to have dragged you into this.'"
Chief_free				"'That's some freedom you have, young lady. You know what? A man in my situation is entitled to some freedom as well. How about you get me a bottle of brandy from the pantry? In case it's locked: Here's the ship's master key,'"
Chief_brandy			"'That's the first good news today!'"
Chief_sinking			"'Well, it sure wasn't an accident, I can tell you that much.'"
Chief_seacocks			"'That's what you do when the ship's deep in the red and the insured sum is higher than the vessel's worth: you open the sea cocks. A bit rare to do it in the harbour, but I suppose they were in a hurry. Could have let me in on it, too. I'd have kept my mouth shut.'"
Chief_worth_it			"'I certainly saw the world. And in a way it's a fitting end to my journeys, don't you think?'"
Chief_predicament		"'It would be easier to bear if it wasn't for my wife and kid. You know, I booked a holiday for us.'"		
Chief_yourself			"'I went to college and learned it. But that's not what your getting at. A love of the sea, perhaps? Really, it was an opportunity to escape small-town life.'"
Chief_holiday			"'It was supposed to be a surprise. We were going to [vacation of the revolutionaries], but it doesn't matter any more. Let's drop it. There's something else I meant to ask you all the time.'"
Chief_question			"'Is that a fishhook injury you've got there?'"
Chief_injury				"'So you're not denying it.'"

Table of Chief Conversation
prompt											response					enabled
"[italic type]'The Christian or civilized part of the crew said it was mermaids, and shuddered; but the pagan harpooneers remained unappalled.'[roman type]"		Chief_mermaid	1
"[italic type]'We have no immortal souls; we have no future life; we are just like the green sea-weed, which, once cut down, can never revive again! Men, on the other hand, have a soul which lives for ever, lives after the body has become dust; it rises through the clear air, up to the shining stars!'[roman type]"		Chief_mermaid	1
"'I was just taking a look around. Sorry to breathe your air.'"			Chief_just_looking			0
"'Let's not dwell on it. But tell me, who are you?'"							Chief_who_are_you			0
"'If you don't mind me telling you, there is a better life to be had elsewhere.'"		Chief_better_living		0
"'Don't worry about it, I've seen worse wrecks.'"		Chief_better_living	0
"'How long can you hold your breath?'"		Chief_breath	0
"'There's always the rescue chamber.'"	Chief_chamber	0
"'I'll get help.'"		Chief_help	0
"'I called emergency services. Say, you wouldn't happen to have health insurance, would you?'"	Chief_insurance	0
"'That's right. There is a different understanding on this in other places. On a totally unrelated note, did you get a chance to work on your breath hold?'"	Chief_hold	0
"'It'll be your only option."	Chief_option		0
"'I'm pretty sure they need not fear that.'"		Chief_fear		0
"'I'm going to cut this short to save air: those without health insurance won't be saved.'"	Chief_no_rescue		0
"'I see. That might turn out to be a problem, down the line.'"	Chief_problem	0
"'That's all right. I came here of my own free will.'"	Chief_free	0
"'Here's what I found in the pantry.'"	Chief_brandy	0
"'What can you tell me about the sinking?'"	Chief_sinking		0
"'How did you become a marine engineer?'"	Chief_yourself		0
"'You mean sabotage? Why would they do that?'"	Chief_seacocks	0
"'Well, it's not altogether unheard of for a man in your position to end up like this.'"	Chief_predicament	0
"'I see. And was it worth it, after all?'"	Chief_worth_it		0
"'Just for the three of you?"		Chief_holiday		0
"'Really, where to?."		Chief_holiday		0
"'I guess that's going to fall through. I'm sorry.'"	Chief_holiday	0
"Sure, fire away."	Chief_question	0
"'You wouldn't believe what nasty murder tools those people are using.'"	Chief_injury		0

Before quipping when the current quip is Chief_greeting:
	say "I said 'Ahoy' to [if the chief engineer is acquainted]the Chief Engineer[else]the seaman.[end if][paragraph break] ";
	if the chief engineer is acquainted and the chief engineer is not asleep:
		enable the Chief_just_looking quip for the chief engineer;
	if the chief engineer is doomed and rescue is happening:
		enable the Chief_insurance quip for the chief engineer;
	if the player carries the bottle of cut brandy and the chief engineer is not asleep:
		enable the Chief_brandy quip for the chief engineer;

After quipping when the current quip is Chief_just_looking:
	terminate the conversation.

After quipping when the current quip is Chief_mermaid:
	disable the Chief_mermaid quip;
	enable the Chief_who_are_you quip.
	
After quipping when the current quip is Chief_who_are_you:
	disable the Chief_who_are_you quip;
	enable the Chief_better_living quip.
	
After quipping when the current quip is Chief_better_living:
	disable the Chief_better_living quip;
	enable the Chief_breath quip;
	enable the Chief_chamber quip.
	
After quipping when the current quip is Chief_breath:
	disable the Chief_breath quip.

After quipping when the current quip is Chief_chamber:
	disable the Chief_breath quip;
	disable the Chief_chamber quip;
	enable the Chief_help quip.
	
After quipping when the current quip is Chief_help:
	disable the Chief_help quip;
	now the chief engineer is acquainted;
	now the current hint is "call_help";
	terminate the conversation.

After quipping when the current quip is Chief_insurance:
	disable the Chief_just_looking quip;
	disable the Chief_insurance quip;
	enable the Chief_hold quip;
	enable the Chief_problem quip;

After quipping when the current quip is Chief_hold:
	disable the Chief_hold quip;
	disable the Chief_problem quip;
	enable the Chief_option quip;

After quipping when the current quip is Chief_option:
	disable the Chief_option quip;
	enable the Chief_no_rescue quip;

After quipping when the current quip is Chief_problem:
	disable the Chief_hold quip;
	disable the Chief_problem quip;
	enable the Chief_fear quip;

After quipping when the current quip is Chief_fear:
	disable the Chief_fear quip;
	enable the Chief_no_rescue quip;

After quipping when the current quip is Chief_no_rescue:
	disable the Chief_no_rescue quip;
	enable the Chief_free quip;

After quipping when the current quip is Chief_free:
	disable the Chief_free quip;
	say "He tossed a key over to me.";
	now the player carries the master key;
	now the current hint is "get_bottle";
	terminate the conversation;

After quipping when the current quip is Chief_brandy:
	disable the Chief_just_looking quip;
	disable the Chief_brandy quip;
	now the chief carries the bottle of cut brandy;
	say "I gave him the bottle.";
	if the bottle of cut brandy is closed:
		try the chief engineer opening the bottle of cut brandy;
	say "He took a gulp of brandy and passed the bottle back to me.";
	enable the Chief_sinking quip;
	enable the Chief_yourself quip;

After quipping when the current quip is Chief_sinking:
	disable the Chief_sinking quip;
	disable the Chief_yourself quip;
	say "He drank a sip from the brandy bottle and passed it back to me.";
	enable the Chief_seacocks quip;
	
After quipping when the current quip is Chief_seacocks:
	disable the Chief_seacocks quip;
	say "He drew a long draught from the bottle and passed it back to me.";
	enable the Chief_predicament quip;

After quipping when the current quip is Chief_yourself:
	disable the Chief_sinking quip;
	disable the Chief_yourself quip;
	say "He drank a sip from the brandy bottle and passed it back to me.";
	enable the Chief_worth_it quip;
	
After quipping when the current quip is Chief_worth_it:
	disable the Chief_worth_it quip;
	say "He drew a long draught from the bottle and passed it back to me.";
	enable the Chief_predicament quip;
	
After quipping when the current quip is Chief_predicament:
	disable the Chief_predicament quip;
	say "He drank a few more sips of brandy and passed the bottle back to me.";
	enable the Chief_question quip;
	
After quipping when the current quip is Chief_question:
	disable the Chief_question quip;
	say "He drank the remaining brandy from the bottle.";
	enable the Chief_injury quip;

After quipping when the current quip is Chief_injury:
	disable the Chief_injury quip;
	say "But he was already falling asleep, the bottle slipping from his hands.";
	now the bottle of cut brandy is in shaft_alley_west;
	now the chief engineer is asleep;
	now the bottle of cut brandy is not alcoholic;
	now the bottle of cut brandy is not full;
	now the current hint is "find_tickets";
	terminate the conversation;

Book - Charon

Chapter - Character

Charon is a man in the barge. The initial appearance of Charon is "The ferryman was waiting silently." The description of Charon is "The face was difficult to ascertain underneath the cloak."
Understand "ferryman/punter/kharon/psychopomp" as Charon. 

Chapter - Possessions

Charon wears the cloak. The description of the cloak is "It clothed the ferryman."
Charon carries the punt. The description of the punt is "A kind of staff to propel the bark forward."
Understand "staff" as the punt.

Chapter - Conversation

The litany of Charon is the Table of Charon Conversation.
The greeting of Charon is Charon_payment.

Table of Quip Texts (continued)
quip						quiptext
Charon_payment			"'Have you brought the payment?'"
Charon_obol				"'Good. This barge will take you to the place you belong.'"
Charon_no_obol				"'Then your place is here.'"

Table of Charon Conversation
prompt								response		enabled
"'I've got exactly 100 yen.'"			Charon_obol	0
"'I haven't got a single penny.'"		Charon_no_obol	0

After quipping when the current quip is Charon_payment:
	if the player carries the coin:
		enable the Charon_obol quip for Charon;
	else:
		enable the Charon_no_obol quip for Charon.

After quipping when the current quip is Charon_obol:
	end the story.

After quipping when the current quip is Charon_no_obol:
	terminate the conversation;
	
Book - The Cashier

Chapter - Character

The cashier is a woman in the bookies. The initial appearance of the cashier is "A woman was manning a [italic type]guichet[roman type]." The description of the cashier is "A woman in her forties, with a stern look about her."
Understand "changeur" as the cashier.

Chapter - Possessions

There are 32 Chips.

Chapter - Conversation

The litany of the cashier is the Table of Cashier Conversation.
The greeting of the cashier is Cashier_greeting.

Table of Quip Texts (continued)
quip						quiptext
Cashier_greeting			"'[if the player is invited][italic type]Yoku Irasshaimashita[roman type].[else]I'm sorry, tonight is by invitation only.[end if]'"
Cashier_invited				"'Yes, you're on the list. Since tonight is your first visit, you get one free chip. Would you like to acquire more chips?'" 
Cashier_buy					"'What amount would you like to change into chips?'"
Cashier_no_buy				"'Very well. Enjoy your time.'"
Cashier_welcome			"'I'm sorry, but the lowest denomination chip is 10.000 yen. But do enjoy your evening.'"
Cashier_exchange			"'Certainly. But before you do, I think you would probably want to place a bet in the house game tonight.'"
Cashier_house				"'Yes. Would you like to place a bet on the holder or on the challenger?'"
Cashier_holder				"'Very well, your bet has been booked. '"
Cashier_challenger			"'Very well, your bet has been booked. '"
Cashier_chips				"'Sure. Just a moment, please.'"

Table of Cashier Conversation
prompt								response				enabled
"'I've been invited.'"				Cashier_invited			0
"'Yes, please.'"						Cashier_buy				0
"'No, thanks.'"						Cashier_no_buy			0
"[if the player carries the coin]'I've got exactly 100 yen.'[else]'I haven't got a single penny.'"			Cashier_welcome		0
"'I would like to cash some chips'"	Cashier_exchange		0
"'House game?'"					Cashier_house			0
"'I would like to place [the number of chips carried by the player * 10000] yen on the holder.'"	Cashier_holder		0
"'I would like to place [the number of chips carried by the player * 10000] yen on the challenger.'"	Cashier_challenger		0
"'I would just like to exchange [the number of chips carried by the player] chips.'"	Cashier_chips	0

Before quipping when the current quip is Cashier_greeting:
	say "[if the third act is happening]I said [italic type]'konban ha'[roman type] to the woman.[else]I said [italic type]'konnichi ha'[roman type] to the woman.[paragraph break]";

After quipping when the current quip is Cashier_greeting:
	if the player is invited and gambling has not happened:
		enable the Cashier_invited quip for the cashier;
	else if the player carries at least 2 chip:
		enable the Cashier_exchange quip for the cashier.

After quipping when the current quip is Cashier_exchange:
	enable the Cashier_house quip;

After quipping when the current quip is Cashier_house:
	enable the Cashier_holder quip;
	enable the Cashier_challenger quip;
	enable the Cashier_chips quip;

After quipping when the current quip is Cashier_holder:
	disable the Cashier_holder quip;
	disable the Cashier_challenger quip;
	disable the Cashier_chips quip;
	terminate the conversation;
	now Ayako is holdered;
	now Ayako is challenged.

After quipping when the current quip is Cashier_challenger:
	disable the Cashier_holder quip;
	disable the Cashier_challenger quip;
	disable the Cashier_chips quip;
	terminate the conversation;
	now Ayako is challenged.

After quipping when the current quip is Cashier_chips:
	disable the Cashier_holder quip;
	disable the Cashier_challenger quip;
	disable the Cashier_chips quip;
	terminate the conversation;
	now Ayako is challenged.

After quipping when the current quip is Cashier_invited:
	disable the Cashier_invited quip;
	enable the Cashier_buy quip;
	enable the Cashier_no_buy quip;
	let x be a random chip that is nowhere;
	now the player carries x;
	say "She handed me a [italic type]chip[roman type]."

After quipping when the current quip is Cashier_buy:
	disable the Cashier_buy quip;
	disable the Cashier_no_buy quip;
	enable the Cashier_welcome quip;
	
After quipping when the current quip is Cashier_no_buy:
	disable the Cashier_buy quip;
	disable the Cashier_no_buy quip;
	now Ayako is exchanged;
	terminate the conversation;

After quipping when the current quip is Cashier_welcome:
	disable the Cashier_welcome quip;
	now Ayako is exchanged;
	terminate the conversation;

Book - The Croupier

Chapter - Character

The croupier is a man in the casino. The croupier is undescribed. The description of the croupier is "His dress and manners were mostly as one would expect in such a place."

Chapter - Possessions

The croupier wears a waistcoat.
The croupier wears a bowtie.

Chapter - Conversation

The greeting of the croupier is Croupier_greeting.

Table of Quip Texts (continued)
quip						quiptext
Croupier_greeting			"The croupier wouldn't answer."

Book - The players

Chapter - Character

The players are a plural-named person in the casino. The initial appearance of the players is "A small crowd had gathered around the [italic type]pointiers[roman type] to watch the game." The description of the players is "Players and spectators alike were dressed smartly, which somehow wouldn't fit the impression they gave me in any other regard."
Understand "pointier/player" and "players/pointiers/crowd/people/faces" and "common faces" as the players.

The players wear smart dress. Understand "evening wear", "dinner jackets", "synthetic fibres" and "dinner jacket" as the smart dress. The description of the smart dress is "Most of these dinner jackets were actually made of synthetic fibres."
	
Chapter - Conversation

The greeting of the players is Players_greeting.

Table of Quip Texts (continued)
quip						quiptext
Players_greeting			"I didn't want to disturb the others."

Book - Barman

Chapter 1 - Character

The barman is a man in the bar room. The description of the barman is "A South-East-Asian in his early 30s, I'd have guessed. I had seen him before when he was working at a different place." The initial appearance of the barman is "The barman tended to his bar."

Understand "bartender/barkeeper" as the barman.

The barman can be interrogated. The barman is not interrogated.

Chapter 2 - Possessions

The barman carries the cocktail. The printed name of the cocktail is "bloody mary".
The description of the cocktail is "A very alcoholic long drink."
Understand "drink/alcohol" and "long drink" as the cocktail.
The cocktail can be drunk. The cocktail is not drunk.

Rule for supplying a missing noun while drinking:
	if the cocktail is contained by the location:
		now the noun is the cocktail;

Instead of drinking a cocktail:
	try silently taking the cocktail;
	if the player carries the cocktail:
		if the cocktail is not drunk:
			increase the promille of the player by 0.3 pm;
			now the cocktail is drunk;
			say "I emptied my drink.";
		else:
			say "The drink was already finished.";
	else:
		say "What drink?"

Check putting the cocktail on the counter:
	if the cocktail is drunk:
		say "I placed the empty glass back onto the counter.";
		say "The barman took the empty glass from the counter.";
		now the cocktail is not drunk;
		move the cocktail to the barman instead.

Check putting the cocktail on the counter:
	if the cocktail is not drunk:
		say "I put the cocktail back onto the counter.";
		now the cocktail is not drunk;
		move the cocktail to the counter instead.

Chapter 3 - The Conversation

Table of Decadent Drinks
title											clarification	known
"A [italic type]Wet Wipe[roman type]"			""			1
"An [italic type]Ashtray[roman type]"			""			1
"A [italic type]Singapore Noose[roman type]"	""			1
"A [italic type]Texas Burial[roman type]"		""			1
"A [italic type]Discovery Channel[roman type]"	""			1
"A [italic type]Cherry Popper[roman type]"		""			1
"A [italic type]Robber Baron[roman type]"		""			1
"A [italic type]Barbary Pirate[roman type]"		"It's similar to a 'Triangle Trader', but with white rum instead of chocolate liqueur."	0
"An [italic type]Emperor Maximilian[roman type]"	"It's a 'Firing Squad' with tequila added."						0
"A [italic type]Vicomte de Valmont[roman type]"	"It's basically a 'Maiden's Menace' with citrus liquor."				0
"A [italic type]Countess Cosel[roman type]"		"That's the same as a 'Pompadour', but with Pilsener instead of champagne."	0
"A [italic type]Piet Hein[roman type]"			"If you add some Antigua rum, you get a 'Bankrupt King', if that helps."	0

to say drink1:
	choose row 1 in the Table of Decadent Drinks;
	say "[title entry]".

to say drink2:
	choose row 2 in the Table of Decadent Drinks;
	say "[title entry]".

to say drink3:
	choose row 3 in the Table of Decadent Drinks;
	say "[title entry]". 

to say clarification:
	choose a row with title of the printed name of the cocktail in the Table of Decadent Drinks;
	say "[clarification entry]".

The litany of the barman is the Table of barman Conversation.

The greeting of the barman is barman_greeting.

Table of Quip Texts (continued)
quip					quiptext
barman_greeting		"[unless the barman is acquainted]The barman smiled as he recognised my face.'[italic type]Chào buổi tối[roman type]. [end if]What can I do for you, young lady?'"
barman_just_looking		"' I can't imagine you weren't warned of this place, but now that you're here, I don't think your curiosity is misplaced. Do take a look around.'"
barman_no_way			"'Sorry, but I don't think I can let you wander around back there.' said the barman behind me."
barman_drink			"[if the promille of the player > 0.8 pm]'I think you've had quite enough for tonight.'[else if the barman carries the cocktail]'What exactly can I offer you?'[else]'Why don't you finish the one you have first?'"
barman_cocktail1		"The barman raised an eyebrow."
barman_cocktail2		"The barman raised an eyebrow."
barman_cocktail3		"The barman raised an eyebrow."
barman_clarify			"'Here you go. It's on the house.'"
barman_ice				"'Here you go. It's on the house.'"
barman_back			"'Thank you for bringing it back. Can I do anything for you?'"
barman_fraud			"'A good observation. It may have something to do with the kimono you're wearing.'"

Table of barman Conversation
prompt					response				enabled
"'Nothing, really, I'm just curious about this place.'"	barman_just_looking	1
"'I'd like a drink.'"		barman_drink	1
"'[drink1], please.'"	barman_cocktail1		0
"'[drink2], please.'"	barman_cocktail2		0
"'[drink3], please'"	barman_cocktail3		0
"'[clarification]'"	barman_clarify	0
"'Just with crushed ice, please.'"	barman_ice	0
"'Here's your glass back, I finished it.'"		barman_back	0
"'Interesting place, this is. They give me a chip for free, all the drinks are on the house and I just keep on winning at the green table.'"		barman_fraud	0
	
Before quipping when the current quip is barman_greeting:
	if the player carries a drunk cocktail:
		enable the barman_back quip for the barman;
	else if the barman carries the cocktail:
		enable the barman_drink quip for the barman;
	else if the player carries more than 8 chips and the barman is not interrogated:
		enable the barman_fraud quip for the barman;
	enable the barman_just_looking quip for the barman;
	say "I said [italic type]'Chào buổi tối'[roman type] to the barman.[paragraph break]".

After quipping when the current quip is barman_greeting:
	now the barman is acquainted;

After quipping when the current quip is barman_fraud:
	now the barman is interrogated;
	terminate the conversation.
		
After quipping when the current quip is barman_just_looking:
	terminate the conversation.
	
After quipping when the current quip is barman_drink:	
	if the promille of the player > 0.8 pm:
		terminate the conversation;
	else if the barman carries the cocktail:
		disable the barman_just_looking quip;
		sort the Table of Decadent Drinks in random order;	
		enable the barman_cocktail1 quip;
		enable the barman_cocktail2 quip;
		enable the barman_cocktail3 quip;
	else:
		terminate the conversation.		
		
After quipping when the current quip is barman_cocktail1:
	disable the barman_cocktail2 quip;
	disable the barman_cocktail3 quip;
	choose row 1 in the Table of Decadent Drinks;
	now the printed name of the cocktail is the title entry;
	if the known entry is 0:
		say "'I think I've heard that name somewhere. Could you perhaps tell me how it's made?'[paragraph break]";
		enable the barman_clarify quip;
	else:
		say "'Would you like it with [one of]lemon[or]orange[or]lime[or]papaya[or]ground cherry[at random] or [one of ]chocolate beans[or]coffee beans[or]honeycomb[or]kiwi[or]rhubarb[at random]?'[paragraph break]";
		enable  the barman_ice quip;
		
After quipping when the current quip is barman_cocktail2:
	disable the barman_cocktail1 quip;
	disable the barman_cocktail3 quip;
	choose row 2 in the Table of Decadent Drinks;
	now the printed name of the cocktail is the title entry;
	if the known entry is 0:
		say "I think I've heard that name somewhere.  Could you perhaps tell me how it's made?'[paragraph break]";
		enable the barman_clarify quip;
	else:
		say "'Would you like it with [one of]lemon[or]orange[or]lime[or]papaya[or]ground cherry[at random] or [one of ]chocolate beans[or]coffee beans[or]honeycomb[or]kiwi[or]rhubarb[at random]?'[paragraph break]";
		enable  the barman_ice quip;
	
After quipping when the current quip is barman_cocktail3:
	disable the barman_cocktail1 quip;
	disable the barman_cocktail2 quip;
	choose row 3 in the Table of Decadent Drinks;
	now the printed name of the cocktail is the title entry;
	if the known entry is 0:
		say "'I think I've heard that name somewhere.  Could you perhaps tell me how it's made?'[paragraph break]";
		enable the barman_clarify quip;
	else:
		say "'Would you like it with [one of]lemon[or]orange[or]lime[or]papaya[or]ground cherry[at random] or [one of ]chocolate beans[or]coffee beans[or]honeycomb[or]kiwi[or]rhubarb[at random]?'[paragraph break]";
		enable  the barman_ice quip;

After quipping when the current quip is barman_clarify:
	choose row with a title of the printed name of the cocktail in the Table of Decadent Drinks; 
	now the known entry is 1;
	say "He placed the cocktail in front of me.";
	now the printed name of the cocktail is "cocktail";
	move the cocktail to the counter;
	terminate the conversation.

After quipping when the current quip is barman_ice:
	say "He placed the cocktail in front of me.";
	now the printed name of the cocktail is "cocktail";
	move the cocktail to the counter;
	terminate the conversation.
	
After quipping when the current quip is barman_back:
	say "I handed him the empty glass.[paragraph break]";
	move the cocktail to the barman;
	now the cocktail is not drunk;
	enable the barman_drink quip;

Book - The Crowd

Chapter - The Character

The crowd is a plural-named person in the ring.

The initial appearance of the crowd is "The audience was in high spirits." The description of the crowd is "The factory manager, the caretaker, the three guys from the second floor: they were all there.".
Understand "caretaker/janitor/boss", "factory manager", "three guys" and "guys/audience/people" as the crowd.

Chapter - Conversation

The greeting of the crowd is crowd_greeting.

Table of Quip Texts (continued)
quip					quiptext
crowd_greeting		"[one of]'Die for us, girl!'[or]'Get on with it, we haven't got all night!'[or]'We aren't here to hear you talk!'[or]'I wanna see something for my money!'[at random] someone called and the others laughed."


Book - The scavengers

Chapter - The Character

The scavengers are a plural-named person. The initial appearance of the scavengers is "A number of people were ruffling through the refuse in search of anything that might still be of some use." The description of the scavengers is "Tattered figures that made their living scavenging from the leftovers of others."
Understand "people/scavenger/tattered/figures/figure/persons/homeless/bum/bums", "very dirty person", "dirty person", "very dirty" and "tattered figures" as the scavengers.

The scavengers are in _waste_dump_2.

Chapter - Conversation

The greeting of the scavengers is scavengers_greeting.

Table of Quip Texts (continued)
quip					quiptext
scavengers_greeting		"They just looked at me [one of]with frightful eyes.[or]from below.[or]with blatant curiosity.[at random]"

Every turn when the location is _waste_dump_2:
	if a random chance of 1 in 3 succeeds:
		say "[one of]One of the tattered scavengers examined a piece of Styrofoam but put it back down.[or]Two people started arguing over something they had found.[or]A very dirty person walked off to the north with something he had found amongst the garbage.[or]A scavenger poured out the remnants of some beverage container and carried it off to the north.[or]There was a constant coming and going of people in search of valuable scraps.[or]The scavengers went through the refuse slowly and methodically.[at random]"
 
Chapter - Announcer

The announcer is a man in the ring. The initial appearance of the announcer is "The announcer stood in the middle of the ring, microphone in hand." The description of the announcer is "A dodgy figure."
Understand "dodge figure" as the announcer.

The announcer carries the microphone

Table of Quip Texts (continued)
quip					quiptext
Announcer_holder		"'To my right we have the title holder, champion of many fights, favourite of town, winner of the hearts!' The announcer screamed into the microphone."
Announcer_challenger	"'To my left is the challenger! Will she be able to hold her own or will she be vanquished, like all those who came before her? the announcer asked.'"
Announcer_begin		"'We can't wait to find out. Let the fight begin!'"