! tutorobj.h, In-Game Suggestions extension
!             (object oriented implementation)
!             Paolo Lucchesi, 2003
!
! ----------------------------------------------------------------------------
!
! To use the tutor:
!   - Put the < Include "tutor"; > command just after < Include "verblib"; >
!
!   - After < Include "grammar.h"; > add the following line
!         Verb meta 'tutor' * -> Tutor;
!
!   - In every interested object define the tutor property, that will be a
!     suggestions string or an embedded routine. If the routine returns true
!     or the property is a string, the tutor won't be called anymore for that
!     object.
!
!   - Call the DoTutor(<object>) function to print the suggestions related
!     to the <object>.
!
!   - Otherwise, call the function DoTutor(<object>, <string>) to print the
!     suggestion string <string>, without defining the tutor propery.
!     Further calls related to the same object will be ignored.
!
! ------------------------------------------------------------------------------
!
! This file is free software, it can be freely used, copied, distributed and
! modified. Every source distribution of this file, modified or not, should
! acknoledge the original author, and should be as free as the original.
! There's no such condition for compiled games using this library.
! This file is distributed AS IS, without warranty of any kind. The author 
! isn't liable for any direct or indirect damage due to the proper or improper 
! use of this software. 
!
! ------------------------------------------------------------------------------

Attribute tutored;
Global tutorflag=true;

[ DoTutor id str;
    if (~~tutorflag) rfalse;
    if (id has tutored) rfalse;
    if (str<=0 && (~~(id provides tutor))) rfalse;
    style underline;
    ! print "^[", (string) id.tutor, "]^^";
    print "^";
    if (str>0)   { 
        print (string) str; 
        give id tutored;
    }
    else        
        if (id.tutor()) give id tutored;
    print "^";
    style roman;
    rtrue;
];
    
[TutorSub;
    if (tutorflag) {
        tutorflag = false;
        "[Tutor is now turned off.]";
    }
    tutorflag = true;
    "[Tutor is now turned on.]";
];

Object tutorobjdummy
    with tutor "Tutor dummy";
