/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import org.zmpp.base.MemoryReadAccess;
import org.zmpp.encoding.AlphabetTable;

public class CustomAlphabetTable
implements AlphabetTable {
    private static final int ALPHABET_SIZE = 26;
    private MemoryReadAccess memaccess;
    private int tableAddress;

    public CustomAlphabetTable(MemoryReadAccess memoryReadAccess, int n) {
        this.memaccess = memoryReadAccess;
        this.tableAddress = n;
    }

    public short getA0Char(byte by) {
        if (by == 0) {
            return 32;
        }
        return this.memaccess.readUnsignedByte(this.tableAddress + (by - 6));
    }

    public short getA1Char(byte by) {
        if (by == 0) {
            return 32;
        }
        return this.memaccess.readUnsignedByte(this.tableAddress + 26 + (by - 6));
    }

    public short getA2Char(byte by) {
        if (by == 0) {
            return 32;
        }
        if (by == 7) {
            return 10;
        }
        return this.memaccess.readUnsignedByte(this.tableAddress + 52 + (by - 6));
    }

    public final byte getA0CharCode(short s) {
        for (int i = 6; i < 32; ++i) {
            if (this.getA0Char((byte)i) != s) continue;
            return (byte)i;
        }
        return -1;
    }

    public final byte getA1CharCode(short s) {
        for (int i = 6; i < 32; ++i) {
            if (this.getA1Char((byte)i) != s) continue;
            return (byte)i;
        }
        return -1;
    }

    public byte getA2CharCode(short s) {
        for (int i = 6; i < 32; ++i) {
            if (this.getA2Char((byte)i) != s) continue;
            return (byte)i;
        }
        return -1;
    }

    public boolean isAbbreviation(short s) {
        return 1 <= s && s <= 3;
    }

    public boolean isShift1(short s) {
        return s == 4;
    }

    public boolean isShift2(short s) {
        return s == 5;
    }

    public boolean isShiftLock(short s) {
        return false;
    }

    public boolean isShift(short s) {
        return this.isShift1(s) || this.isShift2(s);
    }
}

