/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import org.zmpp.base.DefaultMemoryAccess;
import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.AccentTable;
import org.zmpp.encoding.AlphabetTable;
import org.zmpp.encoding.AlphabetTableV1;
import org.zmpp.encoding.AlphabetTableV2;
import org.zmpp.encoding.CustomAccentTable;
import org.zmpp.encoding.CustomAlphabetTable;
import org.zmpp.encoding.DefaultAccentTable;
import org.zmpp.encoding.DefaultAlphabetTable;
import org.zmpp.encoding.DefaultZCharDecoder;
import org.zmpp.encoding.DefaultZCharTranslator;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.encoding.ZCharEncoder;
import org.zmpp.encoding.ZsciiEncoding;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.media.Resources;
import org.zmpp.vm.Abbreviations;
import org.zmpp.vm.ClassicObjectTree;
import org.zmpp.vm.DefaultDictionary;
import org.zmpp.vm.DefaultStoryFileHeader;
import org.zmpp.vm.Dictionary;
import org.zmpp.vm.DictionarySizes;
import org.zmpp.vm.DictionarySizesV1ToV3;
import org.zmpp.vm.DictionarySizesV4ToV8;
import org.zmpp.vm.GameData;
import org.zmpp.vm.ModernObjectTree;
import org.zmpp.vm.ObjectTree;
import org.zmpp.vm.StoryFileHeader;

public class GameDataImpl
implements GameData {
    private StoryFileHeader fileheader;
    private MemoryAccess memaccess;
    private Dictionary dictionary;
    private ObjectTree objectTree;
    private ZsciiEncoding encoding;
    private ZCharDecoder decoder;
    private ZCharEncoder encoder;
    private AlphabetTable alphabetTable;
    private Resources resources;
    private byte[] storyfileData;
    private int checksum;

    public GameDataImpl(byte[] byArray, Resources resources) {
        this.storyfileData = byArray;
        this.resources = resources;
        this.reset();
    }

    public final void reset() {
        byte[] byArray = new byte[this.storyfileData.length];
        System.arraycopy(this.storyfileData, 0, byArray, 0, this.storyfileData.length);
        this.memaccess = new DefaultMemoryAccess(byArray);
        this.fileheader = new DefaultStoryFileHeader(this.memaccess);
        this.checksum = this.calculateChecksum();
        this.initEncodingSystem();
        this.objectTree = this.fileheader.getVersion() <= 3 ? new ClassicObjectTree(this.memaccess, this.fileheader.getObjectTableAddress(), this.decoder) : new ModernObjectTree(this.memaccess, this.fileheader.getObjectTableAddress(), this.decoder);
        DictionarySizes dictionarySizes = this.fileheader.getVersion() <= 3 ? new DictionarySizesV1ToV3() : new DictionarySizesV4ToV8();
        this.dictionary = new DefaultDictionary(this.memaccess, this.fileheader.getDictionaryAddress(), this.decoder, dictionarySizes);
    }

    private void initEncodingSystem() {
        AccentTable accentTable = this.fileheader.getCustomAccentTable() == 0 ? new DefaultAccentTable() : new CustomAccentTable(this.memaccess, this.fileheader.getCustomAccentTable());
        this.encoding = new ZsciiEncoding(accentTable);
        this.alphabetTable = this.fileheader.getCustomAlphabetTable() == 0 ? (this.fileheader.getVersion() == 1 ? new AlphabetTableV1() : (this.fileheader.getVersion() == 2 ? new AlphabetTableV2() : new DefaultAlphabetTable())) : new CustomAlphabetTable(this.memaccess, this.fileheader.getCustomAlphabetTable());
        DefaultZCharTranslator defaultZCharTranslator = new DefaultZCharTranslator(this.alphabetTable);
        Abbreviations abbreviations = new Abbreviations(this.memaccess, this.fileheader.getAbbreviationsAddress());
        this.decoder = new DefaultZCharDecoder(this.encoding, defaultZCharTranslator, abbreviations);
        this.encoder = new ZCharEncoder(defaultZCharTranslator);
        ZsciiString.initialize(this.encoding);
    }

    public MemoryAccess getMemoryAccess() {
        return this.memaccess;
    }

    public StoryFileHeader getStoryFileHeader() {
        return this.fileheader;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public ObjectTree getObjectTree() {
        return this.objectTree;
    }

    public AlphabetTable getAlphabetTable() {
        return this.alphabetTable;
    }

    public ZCharDecoder getZCharDecoder() {
        return this.decoder;
    }

    public ZCharEncoder getZCharEncoder() {
        return this.encoder;
    }

    public ZsciiEncoding getZsciiEncoding() {
        return this.encoding;
    }

    public Resources getResources() {
        return this.resources;
    }

    private int calculateChecksum() {
        int n = this.fileheader.getFileLength();
        int n2 = 0;
        for (int i = 64; i < n; ++i) {
            n2 += this.getMemoryAccess().readUnsignedByte(i);
        }
        return n2 & 0xFFFF;
    }

    public int getCalculatedChecksum() {
        return this.checksum;
    }

    public boolean hasValidChecksum() {
        return this.getStoryFileHeader().getChecksum() == this.checksum;
    }
}

