
Object sc_4
  class Scene,
  with
	number 4,
	init_scene [;
		SetQuestion(q4_1);
	],
	begin_scene [ rock;
		bigguards.startup();
		give LabJunction ~general;
		switch (rock) {
			1: ! first time in
				move activeplayer to OutsideLab; 
				SaveToolPositions();
			2, -1, -2: ! all subsequent times (including boom/splat)
				move activeplayer to OutsideLab; 
				RestoreToolPositions();
				give labdoorstruts ~general;
		}
	],
	end_scene [ rock subrock;
		bigguards.shutdown();
		switch (rock) {
			-1:
				SetAcidQuestions(subrock);
			-2:
				SetBlastQuestions(subrock);
			-3: ! security door open
				"The door opens, only it's ajar. Ha! Ha! Ha! [BUG]";
			1:
				if (q4_d1 hasnt general) {
					give q4_d1 general;
					SetQuestion(q4_d1);
				}
				else if (q4_d1r hasnt general) {
					give q4_d1r general;
					SetQuestion(q4_d1r);
				}
				else {
					SetQuestion(q4_d1rr);
				}
			2: ! left tools behind
				SetQuestion(q4_d2, subrock);
			20: ! success
				SetScene(sc_5);
		}
	];


! Emotional status to date: (absolute strained maximums)
! Minimum: 6 helpful, 2 cosmos, nothing else.
! Maximum: 3 blatant lies, 4 sneaky lies, 8 stubborns, 5 angries, 2 stupid,
!   2 jingos.
! (That's not counting acid/blast queries, which are 1 sneaky, 3 blatant,
! 3 stubborn, 1 angry; or 1 helpful.)
! During startup: +1 helpfuls, +2 cosmos; or else +1 blatant, +3 jingos;
!   or else +1 blatant, +2 stupids.

Object q4_1
  class Question,
  with
	query "^~Very neat. Behind the backs of the guards, and leave them
		to mumble over the lockpick -- not that they knew what it was
		at the time, of course. And you slip north into the core areas.~",
	time_limit 5,
	daemon [;
		if (self.number == 4) {
			print "^~There's only one place here you're truly interested
				in.~^";
		}
	],
	answer_yes [;
		num_helpfuls++;
		print "~I assume you went straight to the lab, then?~^";
		SetQuestion(q4_21);
	],
	answer_no [;
		num_blatant_lies++;
		print "~There's nowhere else,";
		if (num_sneaky_lies >= 3)
			print "~ the man tosses back sharply.";
		else
			print "~ says the man, almost patiently.";
		print " ~I assumed Security was later, because the lab is your
			primary objective. Was, to say.~ His voice slows, again
			contemplative, unsettling to you. ~Your story is ",
			(emphstring) "predictable.", " Did you expect that?~^";
		SetQuestion(q4_22);
	],
	answer_wait [;
		num_stubborns++;
		print "The man watches you carefully, as though you would ever
			give anything away. ~I will assume that you went straight
			to the lab, and Security not until later.~^";
		SetQuestion(q4_21);
	];
	
Object q4_21
  class Question,
  with
	query [; rtrue; ],
	time_limit 3,
	answer_yes [;
		print "~Straight for your goal.";
		SetQuestion(q4_3);
	],
	answer_no [;
		print "~That makes no sense. We both know your goal.";
		SetQuestion(q4_3);
	],
	answer_wait [;
		print "~Certainly you did. We both know your goal.";
		SetQuestion(q4_3);
	];

Object q4_22
  class Question,
  with
	query [; rtrue; ],
	time_limit 1,
	answer_yes [;
		num_cosmos++;
		print "~There is tension, but the flow is clear. The hero will
			extract the secret plans and escape; I wouldn't believe you
			if you said anything else. Except, of course, you didn't
			escape.~^^He is still seated, but his eyes are the eyes
			of a man pacing. ~This isn't a story.";
		SetQuestion(q4_3);
	],
	answer_no [;
		print "~There is tension, but the flow is clear. The hero will
			extract the secret plans and escape; I wouldn't believe you
			if you said anything else. Except, of course, you didn't
			escape.~^^He is still seated, but his eyes are the eyes
			of a man pacing. ~This isn't a story.";
		SetQuestion(q4_3);
	],
	answer_wait [;
		print "He muses,
			~There is tension, but the flow is clear. The hero will
			extract the secret plans and escape; I wouldn't believe you
			if you said anything else. Except, of course, you didn't
			escape.~^^He is still seated, but his eyes are the eyes
			of a man pacing. ~This isn't a story.";
		SetQuestion(q4_3);
	];

Object q4_3
  class Question,
  with
	query [;
		print " Do you have any ", (emphstring) "imagination?", " Do
			you realize what this technology will be used for?~ He seems
			as astonished at the outburst as you.^";
		rtrue;
	],
	time_limit 3,
	number2 0,
	answer_yes [;
		num_jingos++;
		self.number2 = 'yes';
		print "~You ", (emphstring) "do,", " and still you are here for it.";
		SetQuestion(q4_4);
	],
	answer_no [;
		num_stupids++;
		self.number2 = 'no';
		print "~Naturally. You were sent for, and so you came.~ That must be
			a quote. ~Implications are someone else's job.";
		SetQuestion(q4_4);
	],
	answer_wait [;
		num_stupids++;
		self.number2 = 'wait';
		print "~Oh, ", (emphstring) "think", " about it. A fine time to
			be starting...";
		SetQuestion(q4_4);
	];

Object q4_4
  class Question,
  with
	query [;
		print " 'Clean War.' No troops, no civilian blood. One man at a
			time, slipped into an office or a palace, beyond any hope of
			wall or guard. Or not even a man -- a grenade, a canister of
			gas. The end,~ wryly -- ~of security. I'd be out of a job.~
			His eyes are distant, and again you feel that you are the
			least important thing in the room.^^~Bad enough if we get it
			first. We'll take you apart, or just threaten to. Harsh but
			quick. It would be over, we'd have won. But if your people
			get it too, if you'd gotten out with the data, do you
			realize...?~^";
		rtrue;
	],
	time_limit 2,
	answer_yes [;
		num_jingos++;
		if (q4_3.number2 == 'yes')
			print "~Yes, you said. And you don't --~ He stops. ~";
		else
			print "~Yes, suddenly the light shines on you. ";
		SetQuestion(q4_5);
	],
	answer_no [;
		num_stupids++;
		if (q4_3.number2 == 'no')
			print "~Of course you don't. You just march. But see... ";
		else
			print "~Look, then! Both sides! I know you can... ";
		SetQuestion(q4_5);
	],
	answer_wait [;
		if (q4_3.number2 == 'wait')
			print "~Then ", (emphstring) "listen.", " ";
		else
			print "He is very still, watching you think. ~";
		SetQuestion(q4_5);
	];

Object q4_5
  class Question,
  with
	query [;
		print "Knives at each other's throats. How long could ", 
			(emphstring) "that", " last? Two years, five. Eventually it
			would be too tempting, some premier or on-commander who
			poses too much immediate threat.~ Somehow his eyes are
			holding yours. ~Then it ", 
			(emphstring) "would", " be literal knives at each
			other's literal cursed throats. Whole governments beheaded
			overnight. Same for anyone who tries to move up, take charge.
			It wouldn't end. Could you swear, honestly, that anyone
			left on your side wouldn't keep using it on anyone left on
			our side? Senate-men? Troops? Farmers?~^";
		rtrue;
	],
	time_limit 6,
	answer_yes [;
		num_jingos++;
		print "The man seems to -- not sag, but sink down from somewhere 
			briefly above. ~If you think that, there's nothing I can
			say to you. Let's continue. The lab.~^";
		BeginScene(1);
	],
	answer_no [;
		num_cosmos++;
		print "There is a long pause; and then the man smiles... not
			at you. ~And in spite of that, or anything --
			I march too. Let's get back to that. The lab.~^";
		BeginScene(1);
	],
	answer_wait [;
		num_helpfuls++;
		print "~Well, truly, think on that. If you can.~
			The man seems to put something aside. ~Let's continue.
			The lab.~^";
		BeginScene(1);
	];

Object q4_d1
  class Question,
  with
	query [;
		if (num_got_angry <= 1 && num_stubborns <= 3) { 
			self.variant = 1;
			print "^There is regret in the man's eyes. ~Lies again --
				in such a small thing?
				I thought we knew each other better than that, in this
				room.~^";
			rtrue;
		}
		else if (num_got_angry <= 2 && num_stubborns > 3) {
			self.variant = 2;
			print "^The man sighs. ~No. No guards. Save your";
			if (num_blatant_lies + num_sneaky_lies <= num_helpfuls)
				print " inventiveness";
			else
				print " lies";
			print " for a more interesting part of the story.~^";
			BeginScene(2);
			rtrue;
		}
		else if (num_got_angry <= 3 || num_stubborns > 5) {
			self.variant = 3;
			print "^~This is not a victory for you, you must see. You
				know I am not a fool";
			if (num_blatant_lies > 1) {
				print ", and yet you spin these absurdities for me";
			}
			else {
				print ", and I thought you had learned not to spin these
					absurdities for me";
			}
			". The guards did not see you, not yet. Can we continue
				without more such obstacles?~";
		}
		else { ! num_got_angry > 3
			self.variant = 3;
			"^~Enough! You are making this intolerable. You will
				continue without being seen, and without other fabrication,
				do you understand?~";
		}
	],
	time_limit 2,
	answer_yes [;
		switch (self.variant) {
			1: 
				num_cosmos++;
				print "~Then I will not repeat the obvious.~^";
			3:
				print "~I hope that is sincere.~^";
		}
		BeginScene(2);
	],
	answer_no [;
		switch (self.variant) {
			1: 
				num_jingos++;
				print "The emotion drops behind a visible wall, and his eyes are
					as you first saw them. ~No matter. The guards did not see you
					in that corridor, either. Please refrain from having them
					do so.~^";
			3:
				num_got_angry++;
				print "His head comes up sharply. ~Then I will not waste
					further time.~ He touches a sequence of controls.^";
				BrainDrain();
				rtrue;
		}
		BeginScene(2);
	],
	answer_wait [;
		switch (self.variant) {
			1: 
				num_cosmos++;
				print "He nods slowly. ~We do, and I see it unsettles
					you. And so you try to push me away with an
					obvious lie.~ A frown. ~I know you have never feared
					me; but you need not fear yourself, either. Anything
					you learn about me will also be the truth. You may
					still want to lie to me -- about meeting those guards,
					thus -- but I don't need to lie to you.~^";
			3:
				num_got_angry++;
				print "His jaw tightens. ~This is not a game you I will let
					you play much longer. But there is more I need.~^";
		}
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q4_d1r
  class Question,
  with
	query [;
		if (num_stupids <= 2) {
			print "^~The guards from Station Two did not know you
				were there. None of the guards did, not until the end.~^";
		}
		else {
			print "^~You ", (emphstring) "do", " understand, do you not?
				The guards from Station Two did not see you. Not once!
				Now, again.~^";
		}
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q4_d1rr
  class Question,
  with
	query [;
		print "^~Ah, the guards again";
		self.number2++;
		switch (self.number2) {
			1: print ". I might think you would weary of that scene";
			2: print ". They still don't recognize you";
			4: print ". Move on, please";
			5: self.number2 = 0;
		}
		print ".~^";
		BeginScene(2);
	],
	number2 0;

Object q4_d2
  class Question,
  with
	query [;
		print "^~Now, I know you're not that careless.";
		if (self.variant == 1)
			print " We didn't find anything";
		else
			print " We didn't find ", (the) self.variant, " or anything else";
		print " left behind";
		print ". It's a small matter but I can't let it slip.~^";
		BeginScene(2);
	];

Object q4_db1
  class Question,
  with
	query "^~The happy ending, of course. You blow the lock and walk inside,
		and the plans are free to your hand.~ The man pauses. ~Indeed, I
		wonder why you didn't do that, when you were actually there. 
		I don't doubt your gel tab was powerful
		enough to do what you claim. It wasn't that -- you didn't simply
		fail to think of it, did you?~ The man half-laughs in surprise.",
	time_limit 4,
	answer_general [;
		print " So fixated on your lockpick
			to open your way, that you didn't think to use force. Until I
			gave you another chance.~ He is laughing, now, softly.";
		if (num_stupids >= 2) {
			print " ~I should have known. I wonder that your people 
				sent you at all;
				they must have had sharper tools. Well. Your loss; our...
				victory.~^";
		}
		else if (num_cosmos >= 2) {
			print " ~I know what that is like; everyone must, I suppose.
				You took advantage of enough lapses in ",
				(emphstring) "our", " attention,
				to get as far as you did. We shall call it even.~^";
		}
		else {
			print " ~You must feel embarrassed. No matter. It did not happen,
				and there's an end of it.~^";
		}
	],
	answer_yes [;
		num_dumb_recall++;
		print "~You ", (emphstring) "did?";
		self.answer_general();
		BeginScene(2);
	],
	answer_no [;
		print "~Then why didn't you?~ He considers. ~I suppose you were told
			not to leave footprints. But surely the lab had priority? The
			information, getting it out, had to be more important than whether
			we knew you'd been there.~^";
		SetQuestion(q4_db11);
	],
	answer_wait [;
		num_dumb_recall++;
		print "~Ah. You need not hesitate...";
		self.answer_general();
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q4_db11
  class Question,
  with
	query [; rtrue; ],
	time_limit 2,
	answer_yes [;
		print "~Then...~ He is staring past you. ~You would have blasted
			the door if you could have... so you didn't have the tab 
			anymore--~
			His fingers are moving before his words are finished.
			~You've been--~^";
		BrainDrain();
	],
	answer_no [;
		print "The man is shaking his head. ~I hope, one day, to have
			one of your superiors in that chair. I would truly like
			to understand how they set their priorities.~^";
		BeginScene(2);
	],
	answer_wait [;
		print "~The information was ", (emphstring) "less", " important?~
			The man is shaking his head. ~I hope, one day, to have
			one of your superiors in that chair. I would truly like
			to understand how they set their priorities.~^";
		BeginScene(2);
	];
	
Object q4_db1r
  class Question,
  with
	query [; 
		print "^~As I said -- an obvious move, and it would have worked. But
			there is no hole in our door.~^";
		BeginScene(2);
	];

Object q4_da1
  class Question,
  with
	query [;
		print "^~Worth the attempt. But our doors were all replaced last year;
			the power of
			your chemical agents is no secret to our... chemical agents.~
			His face is still deadly serious, but an eyebrow quirks for a
			moment.
			~Even the common doors cannot be penetrated by your catalytic
			acid";
		if (SeenDoorsPitted)
			print " -- as you have already admitted";
		print ". The lab door, of course, is more carefully protected than
			that.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q4_da1r
  class Question,
  with
	query [;
		num_stubborns++;
		print "^~Even if you could have cut that door with your acid,
			you did not try.";
		if (qn_a1 has general) {
			print " I have already said: our forensics people found
				no sign that the stuff has been used within the building.";
		}
		else {
			print " Our forensic chemists have checked the building;
				there is no sign that the stuff has been used on the
				lab door, or anywhere else.";
		}
		print "~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q4_da1rr
  class Question,
  with
	query [;
		print "^~Do we need to keep dwelling on that acid?~^";
		BeginScene(2);
	];
	
! ------------- The scene at the lab door

Object OutsideLab "Outside Laboratory"
  with
	description [;
		print "The corridor from the east ends here, and a single
			door looms to the west. It's no larger than the doors you've
			seen elsewhere; but it somehow looks... heavy. Unyielding.
			Reinforcing struts cross the door's face, and the surface is
			sheathed with some black coating.^";
		if (child(labdoorstruts)) {
			new_line;
			<Search labdoorstruts>;
		}
		if (labdoor has open) {
			print "^The laboratory door";
			if (labdoorguards.number2 == 1)
				print " is swinging ponderously shut.^";
			else
				print " stands open.^";
		}
		if (powercut) {
			print "^The end of the hallway is still well-lit.^";
		}
		rtrue;
	],
	se_to [; <<Go e_obj>>; ],
	e_to [;
		print "You follow the corridor's curve to the southeast.^";
		return LabJunction;
	],
	w_to labdoor,
	cant_go "The corridor runs only southeast from here, and the lab
		door is west.";

Object -> labdoor "laboratory door"
  with
	name 'w//' 'west' 'western' 'heavy' 'lab' 'laboratory' 'door',
	description [;
		print "The door is no larger than the doors you've
			seen elsewhere; but it somehow looks... heavy. Unyielding.
			Reinforcing struts cross the door's face, and the surface is
			sheathed with some black coating. However, the black plate
			beside the door is quite standard.^";
		if (child(labdoorstruts)) {
			new_line;
			<Search labdoorstruts>;
		}
		rtrue;
	],
	door_to Laboratory, 
	door_dir w_to,
	door_try [;
		if (self has open) {
			if (labdoorguards.number2 == 1)
				print "You duck through the closing door, keeping the lockpick
					firmly in hand.^";
			rfalse;
		}
		PronounNotice(self);
		print_ret (The) self, " is very definitely closed."; 
	],
	before [;
		Open: 
			if (self has open)
				"It's already open.";
			"It doesn't open by itself.";
		Close:
			if (self hasnt open)
				"It's already closed.";
		Push, Turn: 
			"The door is immobile.";
		Touch, Rub: 
			<<Touch labdoorcoating>>;
		Receive:
			<<Insert noun labdoorstruts>>;
		TouchFrom:
			if (noun == lockpick)
				rfalse;
			<<Insert noun labdoorstruts>>;
		ActivateTool:
			if (~~escaping)
				"^The door opens, revealing a closet full of monsters. [BUG]";
			if (self has open) {
				"^There is a clank somewhere, but the door does not move.";
			}
			give self open;
			labdoorguards.number2 = 2;
			print "^There is a hollow ", (emphstring) "clunk", " somewhere.
				A moment later, the door swings towards you. The scent of
				ozone brushes through the doorway.^";
			rtrue;
	],
  has scenery door ~open;

Object -> labdoorplate
  class InteriorPlate,
  with
	work_target labdoor,
	shortout [;
		give labdoor locked;
	];

Object -> labdoorstruts "struts"
  with
	name 'strut' 'struts' 'bar' 'bars' 'grid',
	description [;
		print "The door is reinforced with thick square bars, which run
			down and along its entire front. The struts are
			coated with the same black material as the rest of the door.";
		if (child(self)) {
			print " ";
			<Search self>;
		}
		else {
			new_line;
		}
		rtrue;
	],
	before [;
		Search:
			if (child(self) == nothing) 
				"You find nothing of interest.";
			print "Resting on the bars, against the door,";
			WriteListFrom(child(self),
				ISARE_BIT + TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		Receive:
			if (receive_action == ##PutOn)
				<<Insert noun self>>;
		Touch, Rub: 
			<<Touch labdoorcoating>>;
		Attack, Push, Pull, Turn:
			"The bars are as rigid as the steel they certainly are.";
		Climb:
			"You could easily climb the bars, but it would gain you
				little. There is nothing above within reach of the door.";
	],
	after [ ix;
		Receive:
			if (self hasnt general) {
				give self general;
				print_ret "You carefully balance ", (the) noun, " on top
					of one of the struts. It remains there, leaning against
					the surface of the door.";
			}
			ix = child(self);
			if (ix == noun)
				ix = sibling(ix);
			print "You place ", (the) noun, " on one of the struts";
			if (ix == nothing)
				".";
			if (sibling(ix))
				", next to the things already there.";
			print_ret ", next to ", (the) ix, ".";
	],
  has scenery open container pluralname; ! general means you've put stuff there.

Object -> labdoorcoating "black coating"
  with
	name 'black' 'dead' 'dead-black' 'coat' 'coating' 'sheath'
		'material' 'surface',
	description "The door and its struts are coated with some dead-black
		material. You do not recognize it.",
	before [;
		Touch, Rub:
			"The black surface gives very slightly to your touch -- soft,
				but thin, over steel.";
		Push, Pull:
			"The black coating does not slide over the structure beneath.";
		Attack:
			"You cannot mark the black coating.";
		Take:
			"The black coating is fixed in place.";
	],
  has scenery;

Object -> labdoorcorridor "corridor"
  with
	name 'corridor' 'e//' 'east' 'eastern',
	description "The corridor heads east from here, but quickly curves
		out of sight to the southeast.",
	before [;
		Enter:
			<<Go e_obj>>;
		ThrownAt, Receive:
			verb_word = 'throw';
			<<ThrowDir noun e_obj>>;
	],
  has scenery;
	
Object LabJunction "Lab Junction"
  with
	description [;
		print "The white corridor runs south and east from here, with
			a wide branch curving northwest towards the laboratory.";
		if (bigguards in self) {
			if (self hasnt general) {
				give self general;
				print "^^You jerk back from the intersection, a reflexive
					startled leap; there are six guards down the hall to
					the south. They do not seem to have seen you.";
			}
			else {
				print " You are standing just inside the northwest branch,
					out of sight of the guards to the south.";
			}
		}
		new_line;
		if (powercut) {
			print "^You can see brighter light shining around the curve
				to the northwest.^";
		}
		rtrue;
	],
	nw_to [;
		print "The hallway curves west until it reaches the black door.^";
		if (escaping && powercut) {
			ReachLabDoor();
		}
		return OutsideLab;
	],
	e_to [;
		if (bigguards in self) {
			if (bigguards.number == 4 or 5 or 6 or 24) {
				print "You duck across the intersection. The guards to the
					south, distracted by their own business, do not notice
					you; so you continue unchallenged to the east.^";
				TryPassBigGuards();
				rtrue;
			}
			print "You leap across the intersection. To the south, the
				guards begin to shout.^";
			EndScene(1);
			rtrue;
		}
		! escaping
		return NortheastCorner;
	], 
	s_to [;
		if (bigguards in self) {
			print "You step out into the intersection, and begin walking
				towards the guards. They in turn begin running towards you --
				weapons drawn.^";
			EndScene(1);
			rtrue;
		}
		! escaping
		return SharpCorner;
	],
  has ~general; ! general means you walked in on the guards
 
Object bigguards "guards"
  with
	name 'guard' 'guards' 'footstep' 'footsteps' 'step' 'steps'
		'voice' 'voices'
		's//' 'southern' 'south',
	description [;
		print "You peer carefully around the corner. The corridor to the south
			ends at a door, and angles sharply to the northwest from
			there. The guards are clustered around the door.";
		switch (self.number) {
			3, 23: " One is holding some instrument to his ear, occasionally
					speaking to it. But the other five are still watching the
					hallways; you quickly pull back out of their
					view.";
			4, 24: " They are looking at each other, gesturing quickly.";
			5: " You catch three of the guards disappearing around the corner,
					northwest from the others. The other three watch them
					go.";
			25: " You see three of the guards moving towards you. 
					You quickly pull back out of their view.";
			6, 7, 8:
				" There are now only three of them, but they are watching
					both the north and northwest corridors with added vigilance.
					You quickly pull back out of their view.";
			26:
				print " Three of the guards are coming up the corridor.
					You quickly pull back, but they are too close for
					quickness; they have seen you.^";
				EndScene(1);
				rtrue;
			27: "You see a self-guided banjo. [BUG]";
			9, 29: " The six are arranging themselves to watch both north and
					northwest, three and three. 
					You quickly pull back out of their view.";
			default:
				" They are watching both north and northwest, three
					and three, and you quickly pull back out of their
					view.";
		}
	],
	react_before [;
		Listen:
			if (noun == 0) {
				print "(to ", (the) self, ")^";
				<<Listen self>>;	
			}
		ThrowDir:
			if (second == s_obj)
				<<ThrowAt noun self>>;
			!### east, they don't notice. Or only three notice?
			!### except then we need an 'east' object.
		Hide:
			return L__M(##Hide, 2);
	],
	before [;
		Examine:
			rfalse;
		Listen:
			switch (self.number) {
				3, 23: "One of the guards is talking quietly. The words,
						of course, are drowned out by the ever-present
						ventilation.";
				4, 24: "The guard is no longer speaking.";
				5: "You hear footsteps receding slowly.";
				25: "You hear footsteps approaching slowly.";
				26: "You hear footsteps to the south, very near.";
				27: "You hear a lone banjo. [BUG]";
				default:
					"The guards make no sound.";
			}
		Enter:
			<<Go s_obj>>;
		ThrownAt:
			print (The) noun, " clatters down the hall towards the guards.
				You duck back behind the corridor's corner as footsteps
				approach. When the guards do see you, they are not pleased.^";
			EndScene(1);
			rtrue;
		Receive:
			<<ThrowAt noun self>>;
		default:
			"The guards are off to the south.";
	],
	life [;
		<<Touch self>>;
	],
	number 0, ! used for daemon timer
	daemon [;
		if (self.number == 0 && location ~= parent(self)) {
			return; ! don't start the countdown until the player walks in
		}
		
		self.number++;
		if (location == parent(self)) {
			switch (self.number) {
				3: print "^You hear voices among the guards to the south.^";
				4: print "^One of the guards says ~Yes, with'.~^";
				5: print "^You hear footsteps from the south -- moving
						away from you, fortunately.^";
				9: print "^To the south, you hear a door slide open, then
						closed.^";
				23: print "^You hear voices among the guards to the south.^";
				24: print "^One of the guards says ~Yes, with'.~^";
				25: print "^You hear footsteps from the south -- moving
						towards you.^";
				26: print "^Footsteps to the south are getting closer.^";
				27: 
					print "^Three guards come around the corner. You are
						left in plain view,
						flattened against the wall, smiling at them
						apologetically.^";
					EndScene(1);
					rtrue;
				29: print "^To the south, you hear a door slide open, then
						closed.^";
			}
		}
		
		switch (self.number) {
			7: 
				if (random(11) < 6)
					self.number++;
			11:
				self.number = 21;
			26:
				if (location == OutsideLab)
					self.number++; ! safety feature
			31:
				self.number = 1;
		}
	],
	startup [;
		move self to LabJunction;
		self.number = 0;
		StartDaemon(self);
	],
	shutdown [;
		StopDaemon(self);
		remove self;
	],
  has scenery animate pluralname; 

[ TryPassBigGuards   ix;

	ix = LeftToolsBehind(4);
	if (ix) {
		EndScene(2, ix);
		rtrue;
	}

	EndScene(20);
	rtrue;
];
