! Gstatus.h -- Status window module for GWindows
!
! GStatusWin is a class which emulates the standard inform statusline.
! Simply insert a GStatusWin object into your tree with the size and position
! desired, and it will fill itself with a normal inform statusline.
! The window is created with its text in reverse, by default, emulating
! Z-code inform rather than Glulx Inform.
! Also, this version uses different screen metrics to determine how to draw
! the statusline; a default statusline is drawn if the window is over 56
! characters in width, and reduced statuslines are drawn down to 35
! characters (The library draws the default status line down to 66 characters,
! and the reduced one down to 53 characters)
!
! Inherits from: TextGrid 
!
Class GStatusWin
 class TextGrid,
 with update [ posa posb;
    if (location == 0 || player==0 || parent(player) == 0)
      return;
    glk_set_window(self.winid);
    posa=self.width-26;
    posb=self.width-13;
    glk_window_clear(self.winid);
    glk_window_move_cursor(self.winid,1,0);
    if (location == thedark) {
        print (name) location;
    }
    else {
        FindVisibilityLevels();
        if (visibility_ceiling == location)
            print (name) location;
        else 
            print (The) visibility_ceiling;
    }
    if (self.width > 56) {
        glk($002B, self.winid, posa-1, 0); ! window_move_cursor
        print (string) SCORE__TX, sline1;
        glk($002B, self.winid, posb-1, 0); ! window_move_cursor
        print (string) MOVES__TX, sline2;
    }
    else if (self.width > 43) {
        glk($002B, self.winid, posb-1, 0); ! window_move_cursor
        print sline1, "/", sline2;
    }
   else if (self.width > 35)
   {
    glk_window_move_cursor(self.winid,self.width-10,0);
    print (char) ' ', sline1, (char) '/', sline2;
   }
    
],
 split 1,
 split_dir winmethod_Above,
 stylehints
  style_Normal stylehint_Reversecolor 1,
 has abssplit;

