!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.07.13 ORNPC_interact	[Z, GLULX]
! A base class for NPC objects to derive from.  Add support for interacting with other
! NPCs of the PC.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	none
!--------------------------------------------------------------------------------------
! NPComPri: 10 (NPC Componant Priority) 
! The lower the number, the further down the "class" line.  The greater the number, 
! the earlier it needs to come on the class line. Modules with the same priority can
! effectively be exchanged in order without effect.
!--------------------------------------------------------------------------------------
! This is the base class, used by other modules to add support to an NPC to interact 
! with other characters.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORNPC_interact";					!Constant USE_ORNPC_interact; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORNPC_interact; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.01.20	Initial Creation (not really, but this was the earliest date I could 
!				find without searching my code archive.
! 2002.02.26	Fit to new framework.
! 2002.03.28	Modified interacted routines to differentiate between response to other
!				npcs (when moving the following turn should be allowed) and response to 
!				player actions (when the npc should wait and let the player drive)
! 2002.07.13	Addessed code that prevented the "interacting_with" property from being 
!				handled programatically.
!--------------------------------------------------------------------------------------
#ifdef USE_ORNPC_interact;message "          Processing library extension ORNPC_interact...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
#ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORNPC_interact_DONEREPLACE; constant ORNPC_interact_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORNPC_interact_DONEMESSAGE; constant ORNPC_interact_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORNPC_interact requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORNPC_interact_DONECODE;constant ORNPC_interact_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	class ORNPC_interact
		with	interacting_with 0
		,		will_engage_player true
		,		last_move_interacted 0
		,		interacted[marker; 
					marker=turns;
					if(ORNPCControl.npcs_acting==false) marker++; !--if reacting to a player action then skip next turn
					if(self.last_move_interacted<marker) self.last_move_interacted=marker;
				]
		,		has_already_interacted[; if(self.last_move_interacted<turns) rfalse; rtrue;]
		,		engage_person[count o;
					npctemparray-->0=0;
					objectloop(o has talkable or animate && o~=self or player && testscope(o,self)) {!for each person in same room, excluding self
						if((o provides interacting_with && valueorrun(o,interacting_with)==0 or self)){
							npctemparray-->0=(npctemparray-->0)+1;
							npctemparray-->((npctemparray-->0))=o;
						}
					}
 					if(testscope(player,self) && valueorrun(self,will_engage_player)==true) {!---if the player is here, then add him/her to the list too
						npctemparray-->0=(npctemparray-->0)+1;
						npctemparray-->((npctemparray-->0))=player;
					}
					if(count==true) return npctemparray-->0;
					self.interacting_with=npctemparray-->(random(npctemparray-->0));
					return self.interacting_with;
				]
		,	disengage[;
				self.interacting_with=0;
		]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORNPC_interact_DONEGRAMMAR; constant ORNPC_interact_DONEGRAMMAR; #ifdef ORNPC_interact_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;