! 3Who.h (release 2)
!
! Include this file once before and once after "3grammar.h". Inclusion will allow the following
! types of questions:
!
! WHAT IS A MAGAZINE
! WHAT IS THE MAGAZINE
! WHAT HAPPENED TO THE ROPE
! WHAT TIME IS IT
! WHO IS COLONEL MUSTARD
! WHERE IS THE CANDLESTICK HOLDER
!
! The actions WhoIs, WhatIs, WhereIs, and WhatHappened should be used
! in a Before routine. WHAT HAPPENED defaults to WHERE IS unless
! interrupted by the results of a Before or React_Before routine.
! WHAT IS THE and WHO IS default to producing Examine actions.
! WHAT IS A defaults to saying "That doesn't require explanation."
! HOW defaults to saying "That's what you'll have to figure out."
! To distinguish between WHAT IS A and WHAT IS THE, check whether
! indef_mode is false or true.
!
! By making use of the VagueQuestion action you can code responses for
! non-standard questions such as WHO KILLED THE CHEF, WHERE DID THIS
! MAGICAL AMULET COME FROM, HOW DO I DEFEAT THE WIZARD, or WHY IS PAUL
! MAD AT ME, on an ad hoc basis. Otherwise, the standard response is
! "I'm not sure how to answer that."
!
! None of these actions consult Middle, After, or Final routines.
!
!
! To do: Have the WhereIs message distinguish between live and dead Actors.
!        Adjust AppendPreps to account for the possibility of Containers
!		moving around. This should allow WHERE IS THE COIN THAT WAS IN THE CHEST
!		and WHERE IS THE COIN THAT I SAW IN THE OBSERVATORY/CHEST. This also
!		prevents savvy players from asking a series of questions to figure out
!		the new location of a missing item or person.
!	   Allow the question WHERE DID PAUL TAKE THE COIN.
!	   WHERE AM I does not work.

message " Processing library extension 3Who...";

#IFNDEF BeforeParsing;
[ BeforeParsing   ix;
    #ifdef TARGET_ZCODE;
    for (ix=0 : ix<buffer->1 : ix++)
        if (buffer->(WORDSIZE+ix) == '?' or '!')
            buffer->(WORDSIZE+ix) = ' ';
    #ifnot;
    for (ix=0 : ix<buffer-->0 : ix++)
        if (buffer->(WORDSIZE+ix) == '?' or '!')
            buffer->(WORDSIZE+ix) = ' ';
    #endif;

    Tokenise__(buffer, parse);
];
#IFNOT;

[ Is;
	if (NextWord() == 'is' or 'am' or 'are' or 'was' or 'were')
		return GPR_PREPOSITION;
	return GPR_FAIL;
];

[ TimeIsIt wd flag;
	wd = NextWord();
	if (wd == 'time') {
		if (NextWord() == 'is' or 'was')
			if (NextWord() == 'it') {
				flag++;
				if (NextWord() == 'right') ;
					else wn--;
				if (NextWord() == 'now' or 'then' or 'currently' or 'presently') ;
			}
	}
	if (wd == 'is' or 'was') {
			if (NextWord() == 'the')
				if (NextWord() == 'time') flag++;
	}
	if (flag) return GPR_PREPOSITION;
	return GPR_FAIL;
];

[ HappenedTo;
	if (NextWord() == 'happened')
		if (NextWord() == 'to')
			return GPR_PREPOSITION;
	return GPR_FAIL;
];

[ VagueQuestionSub;
  if (BeforeRoutines()) return;
  if (verb_word == 'how' or 'why')
	"That's what you'll have to figure out.";
  "I don't know how to answer that.";
];

[ WhatIsSub;
	if (BeforeRoutines()) return;
	if (noun hasnt topic) "Good question.";
	if (IsVisible(noun) && indef_mode == 0) <<Examine noun>>;
	"That hardly requires explanation.";
	
];

[ WhatHappenedSub;
	if (BeforeRoutines()) return;
	WhereIsSub();
];

[ WhatTimeSub;
	if (the_time) { LanguageTimeOfDay(the_time/60, the_time%60); "."; }
	"This game does not keep track of time.";
];

[ WhoIsSub;
	if (BeforeRoutines()) return;
	if (~~noun ofclass Person) "That's not a ~who~, that's a ~what~!";
	if (noun hasnt topic) "Good question.";
	if (IsVisible(noun)) <<Examine noun>>;
	"That hardly requires explanation.";
];

[ WhereIsSub i j;
	if (BeforeRoutines()) return;

	if (actor == player) {
		if (IndirectlyContains(player, noun)) {
			print "You're carrying ", (ItorThem) noun;
			if (parent(noun) == player) ".";
			print_ret " in ", (the) parent(noun), ".";
		}
		if (IsVisible(noun)) print_ret (CTheyreorThats) noun, " still here.";

		#IFDEF TRACK_LOCATIONS;
		L__M(##Examine, 5, noun);
		#IFNOT;
		"Not here.";
		#ENDIF;
	}

	else {
		if (IsVisible(noun)) print_ret "~Right here.~";

		#IFDEF TRACK_LOCATIONS;
		i = noun.&last_seen_npc-->(actor.npc_number);

		if (i == 0) {
			print "~I haven't seen ", (ItorThem) noun;
			jump ButMaybe;
		}

		if (i ofclass Room) {
			print "~I last saw ", (ItorThem) noun, " in the ";
			if (PrintorRun(i, travel_name, true) == false) print (the) i;
		}

		if (i ofclass Container) {
			print "~I last saw ", (ItorThem) noun, " in ", (the) i, " in the ";
			j = i.&last_seen-->0;
			if (j ofclass Room)
				if (PrintorRun(i, travel_name, true) == false) print (the) i;
			else {
				j = j.location;
				if (PrintorRun(i, travel_name, true) == false) print (the) i;
			}
		}

		if (i ofclass Person) {
			print "~I last saw ", (ItorThem) noun, " being carried by ", (the) i, " in ";
			i = i.&last_seen_npc-->(actor.npc_number);
			if (PrintorRun(i, travel_name, true) == false) print (the) i;
		}

		.ButMaybe;

		j = noun.&last_known_npc-->(actor.npc_number);
		if (i ~= j) {
			print ", but ", (ItorThem) noun, " might be in ";
			if (PrintorRun(j, travel_name, true) == false) print (the) j;
			print " now";
		}

		".~";

		#IFNOT;
		"~Well, I can't see ", (ItorThem) noun, " now, that's for sure.~";
		#ENDIF;
	}
];

[ isMeta; if (actor == player) meta = true; return GPR_PREPOSITION; ];

Verb 'who'
  * isMeta Is scope=Topics		-> WhoIs
  * isMeta topic			-> VagueQuestion;

Verb 'what'
  * isMeta TimeIsIt			-> WhatTime
  * isMeta Is scope=Topics		-> WhatIs
  * isMeta HappenedTo scope=Topics	-> WhatHappened
  * isMeta topic			-> VagueQuestion;

Verb 'where'
  * isMeta Is scope=Topics		-> WhereIs
  * isMeta 'did' noun 'go'		-> WhereIs
  * isMeta 'has' noun 'gone'		-> WhereIs
  * isMeta topic			-> VagueQuestion;

Verb 'how' 'why'
  * isMeta topic			-> VagueQuestion;
#ENDIF;
