/* PILAS DEL SISTEMA NMESIS */

#include <stdlib.h>
#include <string.h>
#include "pilas.h"

#define DEBUG 0
#define MAXCAD 5000


char *strp; /* pila de caracteres */
int *intp; /* pila de enteros */
int scima,icima; /* cimas de las pilas */

void inipilas()
{
intp=malloc(PILTAM*sizeof(int));
strp=malloc(PILTAM);

if (intp==NULL || strp==NULL)
	{
	printf("El SO no permite la asignacin de memoria para las pilas.\n");
	exit(1);
	}
scima=icima=-1;
}

void matapilas()
{
free(intp);
free(strp);
}

/* RUTINAS PARA LA PILA DE ENTEROS */

void ckint()
{
if (icima<0)
	{
	printf("ERROR FATAL, NO HAY DATOS EN LA PILA DE ENTEROS\n");
	exit(1);
	}
}


intp_cima()
{
ckint();
	
return intp[icima];
}

void intp_not()
{
ckint();
intp[icima]=!(intp[icima]);
}
void intp_push(int v)
{
intp[++icima]=v;
}
void intp_pop()
{
ckint();
--icima;
}

intp_cimapop()
{
ckint();
return intp[icima--];
}

char* intp_itoa() /* convierte la cima a cadena y la devuelve */

/* OJO: la cadena es siempre la misma as que el llamador tiene la responsabilidad de
copirsela */
{
static char cad[MAXCAD]; /* static para que no se pierda el puntero */
ckint();
sprintf(cad,"%d",intp[icima]);
return cad;
}

int intp_igual()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
return (a1==a2);
}

int intp_mayor()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
return (a2>a1);
}

int intp_menor()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
return (a2<a1);
}

void intp_suma()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
intp_push(a1+a2);
}

void intp_resta()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
intp_push(a2-a1);
}

void intp_mult()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
intp_push(a2*a1);
}

void intp_div()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
intp_push(a2/a1);
}



void intp_and()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
intp_push(a1&&a2);
}

void intp_or()
{
int a1,a2;
a1=intp_cimapop();
a2=intp_cimapop();
intp_push(a1||a2);
}



/* RUTINAS PARA LA PILA DE TIRAS DE CARACTERES */

/* La pila almacena cadenas de caracteres terminadas en NULL */

void strp_push(char *cad)
{

int i=strlen(cad);

if (DEBUG)
	printf(" --> Apilado %s\n",cad);
	
while (i>=0) strp[++scima]=cad[i--]; /* lo primero que se apila es el NULL,claro */
}

void strp_pop()
{
/* retirar caracteres hasta encontrar el NULL */
while (strp[scima]!='\0') --scima;
--scima; /* quita el NULL */
}

char* strp_cima()
/* Ojo: el llamador deber copiarse la cadena pues es una variable esttica de esta fun.*/
{
static char ca[MAXCAD];
int i=0;
int j=scima;

while (strp[j]!='\0')
	ca[i++]=strp[j--];
ca[i++]=strp[j]; /* pon el NULL */
return ca;
}

int strp_igual()
{
static char ca1[MAXCAD];
static char ca2[MAXCAD];
strcpy(ca1,strp_cima());
strp_pop();
strcpy(ca2,strp_cima());
strp_pop();
return ((strcmp(ca1,ca2)==0));
}

int strp_mayor()
{
static char ca1[MAXCAD];
static char ca2[MAXCAD];
strcpy(ca1,strp_cima());
strp_pop();
strcpy(ca2,strp_cima());
strp_pop();
return ((strcmp(ca2,ca1)>0));
}

int strp_menor()
{
static char ca1[MAXCAD];
static char ca2[MAXCAD];
strcpy(ca1,strp_cima());
strp_pop();
strcpy(ca2,strp_cima());
strp_pop();
return ((strcmp(ca2,ca1)<0));
}

void strp_suma()
{
static char ca1[MAXCAD];
static char ca2[MAXCAD];
static char ca3[MAXCAD];
strcpy(ca1,strp_cima());
strp_pop();
strcpy(ca2,strp_cima());
strp_pop();
if (strlen(ca1)+strlen(ca2)>MAXCAD)
	{
	printf("ERROR EN TIEMPO DE EJECUCIN: Concatenacin de cadenas demasiado grandes - ignorando.\n");
	return;
	}
ca3[0]='\0';
strcat(ca3,ca2);
strcat(ca3,ca1);
if (DEBUG)
	printf(" -->CONCATENADO %s y %s en %s\n",ca1,ca2,ca3);	
strp_push(ca3);
}

	
void strp_xchg()
{
char *ss=strp_cima();
char aux1[MAXCAD];

strcpy(aux1,ss);

strp_pop();
ss=strp_cima();
strp_pop();
strp_push(aux1);
strp_push(ss);
}


int strp_cadenacont()
{

static char ca1[MAXCAD];
static char ca2[MAXCAD];
strcpy(ca1,strp_cima());
strp_pop();
strcpy(ca2,strp_cima());
strp_pop();
return ((strstr(ca2,ca1)!=NULL));

}
