;TICKET source file						13/11/87
/CTL	;Control Section
_	;Null word character is an underline
;	-	-	-	-	-	-	-	-	-
/VOC	;Vocabulary
;			Movements ie verbs and nouns < 14
N	2	noun
NORTH	2	noun
S	3	noun
SOUTH	3	noun
E	4	noun
EAST	4	noun
W	5	noun
WEST	5	noun
NE	6	noun
NW	7	noun
SE	8	noun
SW	9	noun
U	10	noun
UP	10	noun
ASCEN	10	verb
CLIMB   10      verb
D	11	noun
DOWN	11	noun
DESCE	11	verb
;			Nouns	<20 means can be used as verbs
I	14	noun
INVEN	14	noun
ALL	20	noun
LOT	20	noun
EVERY	20	noun
DOG	21	noun
BIRD	22	noun
HERE	37	noun
;				<50 means a proper noun ie not an 'IT'
TORCH	50	noun
BAG	51	noun
SANDWIC	52	noun
APPLE	53	noun
BUS	54	noun
TICKET	54	noun
LEAD	55	noun		;NB value 55 used in Process table 0
ANORAK	56	noun
GATE	57	noun
RAILING	58	noun
GRASS	59	noun
PATH	60	noun
BENCH	61	noun
POND	62	noun
BANDSTA	63	noun
IRON	63	noun
TREE	64	noun
BRANCH	64	noun
LEAF	64	noun
;			Verbs
GET	20	verb
TAKE	20	verb
DROP	21	verb
PUT	21	verb
REMOVE	22	verb
WEAR	23	verb
R	24	verb
REDESC	24	verb
QUIT	25	verb
STOP	25	verb
SAVE	26	verb
LOAD	27	verb
RAMSAVE	28	verb
RAMLOAD	29	verb
LOOK	30	verb
EXAMINE	30	verb
SAY	31	verb
ASK	31	verb
TALK	31	verb
SPEAK	31	verb
TIE	34	verb
UNTIE	35	verb
SIT	36	verb
STAY	36	verb
COME	37	verb
TURN    38      verb
SWITCH  38      verb
;				Adjectives
SMALL	2	adjective
BIG	3	adjective
LARGE	3	adjective
OLD	4	adjective
NEW	5	adjective
HARD	6	adjective
SOFT	7	adjective
SHORT	8	adjective
LONG	9	adjective
LIT	10	adjective
UNLIT	11	adjective
;				Adverbs
QUICKLY	2	adverb
SLOWLY	3	adverb
QUIETLY	4	adverb
LOUDLY	5	adverb
CAREFUL	6	adverb
SOFTLY	6	adverb
GENTLY	6	adverb
;				Prepositions
TO	2	preposition
FROM	3	preposition
IN	4	preposition
OUT	5	preposition
THROUGH	6	preposition
OVER	7	preposition
UNDER	8	preposition
BY	9	preposition
ON	10	preposition
OFF	11	preposition
AT	12	preposition
EXCEPT	13	preposition
;				Pronouns
IT	2	pronoun
THEM	2	pronoun
;				Conjunctions
AND	2	conjunction
THEN	2	conjunction
;	-	-	-	-	-	-	-	-	-
/STX	;System Message Texts
/0
It's too dark to see anything.
/1
I can also see: 
/2

What now?

/3

What next?

/4

What should I do now?

/5

What should I do next?

/6
I was not able to understand any of that.  Please try again.

/7
I can't go in that direction.

/8
I can't do that.

/9
I have with me:
/10
 (worn)
/11
nothing at all.

/12
Are you sure? 
/13
Would you like another go? 
/14
Goodbye...
/15
OK.

/16
Press any key to continue.

/17
You have taken 
/18
 turn
/19
s
/20
.

/21
You have scored 
/22
%

/23
I'm not wearing one of those.

/24
I can't.  I'm wearing the _.

/25
I already have the _.

/26
There isn't one of those here.

/27
I can't carry any more things.

/28
I don't have one of those.

/29
I'm already wearing the _.

/30	;One upper case character only
Y
/31	;One upper case character only
N
/32
More...
/33
>
/34	;Spare
/35

Time passes...

/36
I now have the _.

/37
I'm now wearing the _.

/38
I've removed the _.

/39
I've dropped the _.

/40
I can't wear the _.

/41
I can't remove the _.

/42
I can't remove the _.  My hands are full.

/43
The _ weighs too much for me.

/44
The _ is in the 
/45
The _ isn't in the 
/46
, 
/47
 and 
/48
.

/49
I don't have the _.

/50
I'm not wearing the _.

/51
.

/52
There isn't one of those in the 
/53
nothing.

/54
File not found.
/55
File corrupt.
/56
I/O Error!  File not Saved!
/57
Directory full.
/58
Disk full.
/59
File name error.
/60
Type in name of file. 
;	-	-	-	-	-	-	-	-	-
/MTX	;Message Texts
/0
The apple is crisp and green.
/1
It's a cheese and pickle sandwich.
/2
The ticket has "City Bus Company" printed on it.
/3
The bench is firmly screwed to a concrete base.
/4
The bus arrives.  I hand the ticket to the driver who
smiles and says "Sorry I'm late, hope you haven't been
standing too long?".
/5
In the bag is:
/6
The bird drops the ticket to peck at the sandwich.
/7
The bird snatches the ticket.
/8
The bird ignores me.
/9
A small bird is here.
/10
The bird has a ticket in its beak.
/11
A small bird settles on the ground.
/12
A small bird lands on the branch.
/13
The bird sees the dog and flutters away quickly.
/14
The bird flies away.
/15
The _ falls to the ground at the foot of the tree.
/16
The dog's bright eyes stare at me with mindless love.
/17
A dog is here.
/18
The dog follows me wagging his tail.
/19
A lead trails behind the dog.
/20
The dog is tied to the bench by a lead.
/21
Trustingly the dog lets me put the lead around its neck.
/22
I've tied the lead to the bench.
/23
Who should I say it to?
/24
The dog is sitting quietly.
/25
I've untied the dog from the bench.
/26
Tie what to what?
;	-	-	-	-	-	-	-	-	-
/OTX	;Object Texts
/0
A lit torch.
/1
A bag.
/2
A sandwich.
/3
An apple.
/4
A ticket.
/5
A lead.
/6
An anorak.
/7
An unlit torch.
;	-	-	-	-	-	-	-	-	-
/LTX	;Location Texts
/0	;Intro
The Ticket


This mini adventure was originally built as part of the tutorial for the
Professional Adventure Writing System (PAW) in 1986.


The Interpreter understands Verbs, Nouns, Adjectives, Adverbs, Pronouns,
Prepositions and Conjunctions.

It understands containers eg PUT X IN Y.  LOOK IN Y.

It understands ALL.  eg GET ALL EXCEPT Z.  TAKE ALL OUT OF Y.

It allows
you to talk to things eg SAY "HELLO" to FRED or SAY TO HARRY "DROP Y". 

It understands IT.  eg GET THE SMALL SWORD QUICKLY AND KILL THE ORC WITH IT
THEN GO SOUTH.


While standing on the bus stop my bus ticket has been blown away,
can you help me to find it?


/1
I'm inside the bag!
/2
I'm standing by a bus stop, on a road which runs North to South.  To the
West a park gate set in iron railings stands open.
/3
The grass on which I stand is neatly trimmed.  To the North is a path
and bench while to the West is an ornamental pond.
/4
I am on a gravel path running East to West, by a park bench, to
the South is a grassy area while to the North I can see a bandstand.
/5
I am standing on the bandstand which appears
to be made of ornate cast iron painted white.  To the South is a path.
/6
The sun glitters on the surface of the ornamental pond, whose waters ripple
in the gentle breeze.  A path runs North towards a large tree,
while to the East is a grassy area.
/7
The path curves South and East here beside a large tree.
/8
I am sitting on a branch in a broad leaved tree, the park is spread out before
me, to the East I can see the bus stop through the gate in the railings.
;	-	-	-	-	-	-	-	-	-
/CON	;Connections
/0			;Start of game
/1			;In bag
/2			;Bus stop
	W	4
/3			;By bench
	N	4
	W	6
	NW	7
/4			;Path
	N	5
	E	2
	S	3
	SW	6
	W	7
/5			;Bandstand
	S	4
	SW	7
/6			;Pond
	N	7
	NE	4
	E	3
/7			;By tree
	U	8
	NE	5
	E	4
	SE	3
	S	6
/8			;Up the tree
	D	7
;	-	-	-	-	-	-	-	-	-
/OBJ	;Object Definitions
;obj  starts  weight  cont-   wear/	noun   adjective
;num	at	      ainer   remove
/0	_	1	_	_	TORCH	LIT
/1	2	3	Y	_	BAG	_
/2	CARRIED	1	_	_	SANDWIC	_
/3	CARRIED	1	_	_	APPLE	_
/4	_	1	_	_	TICKET	_
/5	3	1	_	_	LEAD	_
/6	WORN	3	_	Y	ANORAK	_
/7	CARRIED	1	_	_	TORCH	UNLIT
;	-	-	-	-	-	-	-	-	-
/PRO	0	;ie Response Table

I	_	INVEN

GET	I	INVEN

GET	TICKET	SAME	12	38	;Bird at same location?
		ISAT	4	252	;With ticket in beak?
		CLEAR	5		;Force it to fly away
		NOTDONE			;"I can't do that"

GET	ALL	PREP	OUT		;Get all out of bag
		NOUN2	BAG
		DOALL	1

GET	ALL	DOALL	HERE

GET	_	PREP	OUT		;Get something out of bag
		NOUN2	BAG
		PRESENT	1		;Bag here?
		AUTOT	1
		DONE

GET	_	AUTOG
		DONE

DROP	ALL	DOALL	CARRIED

DROP	LEAD	PREP	ON		;Ensure not just a DROP LEAD
		NOUN2	DOG
		CARRIED	5		;Player has the lead
		SAME	13	38	;is at same location as dog
		LET	14	1	;Dog now has lead on
		DESTROY	5		;So player hasn't
		MESSAGE	21		;Tell them so.
		DONE

DROP	_	PREP	IN		;Put something in bag
		NOUN2	BAG
		PRESENT	1		;Bag here?
		AUTOP	1
		DONE

DROP	_	AT	8		;Player on branch?
		WHATO			;I say old boy!
		LT	51	255	;Valid object?
		EQ	54	254	;Object carried?
		MESSAGE	15		;Its now bottom of tree.
		PUTO	7		;Put it there
		DONE

DROP	_	AUTOD
		DONE

REMOVE	ALL	DOALL	WORN
REMOVE	_	AUTOR
		DONE

WEAR	ALL	DOALL	CARRIED
WEAR	_	AUTOW
		DONE

R	_	DESC

QUIT	_	QUIT
		TURNS
		END

SAVE	_	SAVE

LOAD	_	LOAD

RAMSAVE	_	RAMSAVE
		DESC

RAMLOAD	_	RAMLOAD	255		;Reload all flags
		DESC

LOOK	APPLE	PRESENT	3		;Apple here?
		MESSAGE	0		;Describe it
		DONE

LOOK	SANDW	PRESENT	2		;The sandwich is here
		MESSAGE	1		;Describe it
		DONE

LOOK	TICKET	PRESENT	4		;The ticket is here
		MESSAGE	2
		DONE

LOOK	BENCH	AT	4		;The bench isn't an object
		MESSAGE	3		;so check location
		DONE

LOOK	BAG	PREP	IN		;Look in bag
		MESSAGE	5
		LISTAT	1
		DONE

LOOK	_	DESC

TIE	DOG	LET	34	55	;Convert DOG to LEAD

TIE	LEAD	PREP	TO
		NOUN2	BENCH
		AT	4		;Where bench is.
		SAME	13	38	;dog is here
		EQ	14	1	;with lead on
		PLUS	14	1	;now tied to bench
		MESSAGE	22		;tell player about it
		DONE

TIE     _       MESSAGE 26

UNTIE	DOG	LET	34	55	;Convert DOG to LEAD

UNTIE	LEAD	AT	4		;Where bench is
		EQ	14	2	;dog tied to it
		CLEAR	14		;Now free
		MESSAGE	25		;Tell player
		CREATE	5		;Recreate lead
		GET	5		;Try and get it.
		DONE

UNTIE   _       MESSAGE 26

SAY	DOG	SAME	13	38	;It's here
		PROCESS	5		;Someone else to do the work
		DONE

SAY	BIRD	SAME	12	38	;Bird here?
		MESSAGE	8
		DONE

SAY	_	MESSAGE	23		;Who
		DONE

TURN    TORCH   PREP    ON
                CARRIED 7
                SWAP    7       0
                OK

TURN    TORCH   PREP    OFF
                CARRIED 0
                SWAP    7       0
                OK

;	-	-	-	-	-	-	-	-	-

/PRO	1	;Used after a location has been described

_	_	AT	0		;Start of game
		ANYKEY
		LET	12	8	;Bird is on branch (locno. 8)
		LET	13	2	;Dog starts at bus stop
		GOTO	2
		DESC

_	_	NEWLINE
		ZERO	0		;If it is light...
		ABSENT	0		;and the light source is absent...
		LISTOBJ			;List the objects

_	_	PRESENT 0		;If the light source is present...
		LISTOBJ			;List the objects

_	_	SAME	13	38	;Dog at same location?
		MESSAGE	17		;Tell player
		EQ	14	1	;With lead?
		MESSAGE	19		;Yes so tell player

_	_	SAME	13	38
		EQ	14	2	;Dog tied to bench?
		MESSAGE	20

_	_	SAME	13	38
		GT	14	2	;255 is greater than 2 so
		MESSAGE	24

_	_	SAME	12	38	;Bird at same location?
		MESSAGE	9		;Tell player
		ISAT	4	252	;Ticket in beak?
		MESSAGE	10		;Tell player

;	-	-	-	-	-	-	-	-	-

/PRO	2	;PAW's turn at the game

_	_	PROCESS	4		;Dog

_	_	PROCESS	3		;Bird

_	_	AT	2		;At bus stop
		CARRIED	4		;with ticket
		MESSAGE	4		;finished
		TURNS
		END

;	-	-	-	-	-	-	-	-	-

/PRO	3	;Bird

_	_	COPYOF	4	11	;Copy loc'n of obj4 (ticket) to flag 11
		SAME	11	12	;Ticket at same loc'n as the bird?
		ZERO	5		;Bird going to fly?
		DESTROY	4		;Bird 'GETS' the ticket
		SAME	12	38	;Bird at same loc'n as player?
		MESSAGE	7		;Tell player about it

_	_	EQ	12	8	;Bird on branch?
		ZERO	5		;Time to fly?
		LET	12	5	;Move bird to bandstand
		LET	5	3	;Three phrases 'till move
		AT	8		;Player here as well?
		MESSAGE	14		;Tell them bird has flown

_	_	EQ	12	5	;Bird on bandstand?
		ZERO	5		;Time to fly?
		LET	12	8	;Move to branch
		LET	5	3	;Three phrases 'till move
		AT	5		;Player here as well?
		MESSAGE	14		;Tell them...

_	_	EQ	5	3	;Bird just flown?
		SAME	12	38	;Now at players location?
		AT	5		;On bandstand?
		MESSAGE	11		;Landed on ground

_	_	EQ	5	3	;Bird just flown?
		SAME	12	38	;Now at players location?
		AT	8		;On branch?
		MESSAGE	12		;Landed on branch

_	_	EQ	5	3
		SAME	12	38
		ISAT	4	252	;Ticket not created?
		MESSAGE	10		;Has a ticket in beak.

_	_	SAME	12	13	;Bird and dog at same location?
		LET	12	8	;Only ever on bandstand so
		LET	5	3	;move to branch, three phrases
		AT	5		;Player on bandstand?
		MESSAGE	13		;Tell them bird is gone..

_	_	COPYOF	2	11	;Sandwich
		SAME	11	12	;at same location as bird?
		ISAT	4	252	;Ticket in beak?
		COPYFO	12	4	;Put ticket down
		SAME	12	38	;Player here as well?
		MESSAGE	6		;Tell them...

;	-	-	-	-	-	-	-	-	-

/PRO	4	;Dog

_	_	NOTSAME	13	38	;Dog not where player is?
		LT	14	2	;Still able to move?
		NOTAT	8		;Player isn't up the tree?
		COPYFF	38	13	;Move dog to players locno.
		MESSAGE	18		;Tell them its followed...

;	-	-	-	-	-	-	-	-	-

/PRO	5	;Speak to dog

_	_	PARSE			;Convert string to LS
		MESSAGE	16		;Not valid phrase so
		DONE			;dog does not understand

SIT	_	ZERO	14		;Dog not partially tied up
		SET	14		;Now sitting quietly
		MESSAGE	24		;Tell player (always at same
		DONE			;place as dog) then DONE

COME	_	EQ	14	255	;Dog must be sitting?
		CLEAR	14		;Now normal
		MESSAGE	18		;Dog follows
		DONE

_	HERE	EQ	14	255	;Dog sitting?
		CLEAR	14		;Now normal
		MESSAGE	18		;Dog follows
		DONE

_	_	MESSAGE	16		;Anything else

;Flag usage
;
;Flag  5 is used to determine when the bird flies
;Flag 11 is used as a 'work' flag
;Flag 12 holds current location of Bird
;Flag 13 holds current location of Dog
;Flag 14 holds the status of the dog ie   0=free to roam
;					  1=has lead around neck
;					  2=tied to bench
;					255=sitting quietly

