/**************************************
	Fichero de cabecera de las
	definiciones de caracteres
	para las rutinas de IMPCHR.C
**************************************/

#if !defined (DEFCHR_H)
#define DEFCHR_H

/* altura de las definiciones de caracteres para modo de 16 colores */
#define CHR_ALT   16

/* tabla con las definiciones de los caracteres de 8xCHR_ALT */
unsigned char _defchr_sys[256][CHR_ALT]={
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd,
	 0x99, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3,
	 0xe7, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe,
	 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe,
	 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0xe7, 0xe7,
	 0xe7, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff,
	 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c,
	 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3,
	 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42,
	 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xbd, 0xbd,
	 0xbd, 0xbd, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff},
	{0x00, 0x00, 0x1e, 0x0e, 0x1a, 0x32, 0x78, 0xcc,
	 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c,
	 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x3f, 0x33, 0x3f, 0x30, 0x30, 0x30,
	 0x30, 0x70, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7f, 0x63, 0x7f, 0x63, 0x63, 0x63,
	 0x63, 0x67, 0xe7, 0xe6, 0xc0, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x18, 0x18, 0xdb, 0x3c, 0xe7,
	 0x3c, 0xdb, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfe, 0xf8,
	 0xf0, 0xe0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x02, 0x06, 0x0e, 0x1e, 0x3e, 0xfe, 0x3e,
	 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,
	 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
	 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x1b,
	 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x7c, 0xc6, 0x60, 0x38, 0x6c, 0xc6, 0xc6,
	 0x6c, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,
	 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0xfe,
	 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xfe,
	 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x6c, 0xfe,
	 0x6c, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x7c,
	 0x7c, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x7c, 0x7c,
	 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.   */
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. ! */
	{0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. " */
	{0x00, 0x00, 0x00, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c,
	 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},       /* car. # */
	{0x18, 0x18, 0x7c, 0xc6, 0xc2, 0xc0, 0x7c, 0x06,
	 0x06, 0x86, 0xc6, 0x7c, 0x18, 0x18, 0x00, 0x00},       /* car. $ */
	{0x00, 0x00, 0x00, 0x00, 0xc2, 0xc6, 0x0c, 0x18,
	 0x30, 0x60, 0xc6, 0x86, 0x00, 0x00, 0x00, 0x00},       /* car. % */
	{0x00, 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x76, 0xdc,
	 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car. & */
	{0x00, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. ' */
	{0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30,
	 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00},       /* car. ( */
	{0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c,
	 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00},       /* car. ) */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0xff,
	 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. * */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e,
	 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. + */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00},       /* car. , */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. - */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. . */
	{0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18,
	 0x30, 0x60, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00},       /* car. / */
	{0x00, 0x00, 0x7c, 0xc6, 0xce, 0xce, 0xd6, 0xd6,
	 0xe6, 0xe6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. 0 */
	{0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. 1 */
	{0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x0c, 0x18,
	 0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car. 2 */
	{0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06,
	 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. 3 */
	{0x00, 0x00, 0x0c, 0x1c, 0x3c, 0x6c, 0xcc, 0xfe,
	 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00},       /* car. 4 */
	{0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xfc, 0x06,
	 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. 5 */
	{0x00, 0x00, 0x18, 0x30, 0x60, 0xc0, 0xfc, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. 6 */
	{0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x0c, 0x18,
	 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00},       /* car. 7 */
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. 8 */
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7e, 0x06,
	 0x06, 0x0c, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00},       /* car. 9 */
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. : */
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00},       /* car. ; */
	{0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60,
	 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00},       /* car. < */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00,
	 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. = */
	{0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06,
	 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00},       /* car. > */
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x0c, 0x18, 0x18,
	 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. ? */
	{0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xde, 0xde,
	 0xde, 0xdc, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. @ */
	{0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. A */
	{0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00},       /* car. B */
	{0x00, 0x00, 0x3c, 0x66, 0xc0, 0xc0, 0xc0, 0xc0,
	 0xc0, 0xc0, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},       /* car. C */
	{0x00, 0x00, 0xf8, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xcc, 0xf8, 0x00, 0x00, 0x00, 0x00},       /* car. D */
	{0x00, 0x00, 0xfe, 0xc6, 0xc0, 0xc0, 0xf8, 0xc0,
	 0xc0, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car. E */
	{0x00, 0x00, 0xfe, 0xc6, 0xc0, 0xc0, 0xf8, 0xc0,
	 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},       /* car. F */
	{0x00, 0x00, 0x3c, 0x66, 0xc0, 0xc0, 0xc0, 0xde,
	 0xc6, 0xc6, 0x66, 0x3e, 0x00, 0x00, 0x00, 0x00},       /* car. G */
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. H */
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. I */
	{0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. J */
	{0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0,
	 0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. K */
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	 0xc0, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car. L */
	{0x00, 0x00, 0xc6, 0xee, 0xfe, 0xfe, 0xd6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. M */
	{0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. N */
	{0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},       /* car. O */
	{0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc,
	 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},       /* car. P */
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xd6, 0xde, 0x7c, 0x0c, 0x06, 0x00, 0x00},       /* car. Q */
	{0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc, 0xf0,
	 0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. R */
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0x7c, 0x06,
	 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. S */
	{0x00, 0x00, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. T */
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. U */
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	 0xc6, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00},       /* car. V */
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6,
	 0xd6, 0xfe, 0x6c, 0x28, 0x00, 0x00, 0x00, 0x00},       /* car. W */
	{0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x7c, 0x38, 0x38,
	 0x7c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. X */
	{0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. Y */
	{0x00, 0x00, 0xfe, 0xc6, 0x06, 0x0c, 0x18, 0x30,
	 0x60, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car. Z */
	{0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30,
	 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00},       /* car. [ */
	{0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0x70, 0x38,
	 0x1c, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00},       /* car. \ */
	{0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00},       /* car. ] */
	{0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. ^ */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00},       /* car. _ */
	{0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. ` */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c,
	 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car. a */
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xf8, 0xcc, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00},       /* car. b */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0,
	 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car. c */
	{0x00, 0x00, 0x06, 0x06, 0x06, 0x3e, 0x66, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car. d */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. e */
	{0x00, 0x00, 0x38, 0x6c, 0x60, 0x60, 0x60, 0x60,
	 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00},       /* car. f */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00},       /* car. g */
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xdc, 0xe6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. h */
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. i */
	{0x00, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x06,
	 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00},       /* car. j */
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc6, 0xcc, 0xf8,
	 0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. k */
	{0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. l */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xd6,
	 0xd6, 0xd6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. m */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. n */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car. o */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00},       /* car. p */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00},       /* car. q */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},       /* car. r */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0,
	 0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00},       /* car. s */
	{0x00, 0x00, 0x60, 0x60, 0x60, 0xf8, 0x60, 0x60,
	 0x60, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},       /* car. t */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car. u */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},       /* car. v */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	 0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00},       /* car. w */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x6c, 0x38,
	 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. x */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x38, 0x00},       /* car. y */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0c, 0x18,
	 0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car. z */
	{0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 0x18,
	 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00},       /* car. { */
	{0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car. | */
	{0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18,
	 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00},       /* car. } */
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. ~ */
	{0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6,
	 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0,
	 0xc2, 0x66, 0x3c, 0x0c, 0x06, 0x7c, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xc6, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6,
	 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x78, 0x0c, 0x7c,
	 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xcc, 0x00, 0x00, 0x78, 0x0c, 0x7c,
	 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x60, 0x30, 0x18, 0x00, 0x78, 0x0c, 0x7c,
	 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x38, 0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c,
	 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x60, 0x60,
	 0x66, 0x3c, 0x0c, 0x06, 0x3c, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6,
	 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xcc, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6,
	 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x66, 0x00, 0x00, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x60, 0x30, 0x18, 0x00, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0xc6, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6,
	 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x38, 0x6c, 0x38, 0x00, 0x38, 0x6c, 0xc6, 0xc6,
	 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x30, 0x60, 0x00, 0xfe, 0xc6, 0xc0, 0xfc,
	 0xc0, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x76, 0x36,
	 0x7e, 0xd8, 0xd8, 0x6e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x3e, 0x6c, 0xcc, 0xcc, 0xfe, 0xcc,
	 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xc6, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x10, 0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x60, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xc6, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x38, 0x00},       /* car.  */
	{0x00, 0xc6, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x18, 0x18, 0x3c, 0x66, 0x60, 0x60, 0x60,
	 0x66, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60,
	 0x60, 0x60, 0xe6, 0xfc, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18,
	 0x7e, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0xf8, 0xcc, 0xcc, 0xf8, 0xc4, 0xcc, 0xde,
	 0xcc, 0xcc, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x0e, 0x1b, 0x18, 0x18, 0x18, 0x7e, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0xd8, 0x70, 0x00, 0x00},       /* car.  */
	{0x00, 0x0c, 0x18, 0x30, 0x00, 0x78, 0x0c, 0x7c,
	 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x06, 0x0c, 0x18, 0x00, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x18, 0x30, 0x60, 0x00, 0x7c, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x06, 0x0c, 0x18, 0x00, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x76, 0xdc, 0x00, 0xfc, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x76, 0xdc, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde,
	 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x60,
	 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0,
	 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06,
	 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30,
	 0x60, 0xdc, 0x86, 0x0c, 0x18, 0x3e, 0x00, 0x00},       /* car.  */
	{0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30,
	 0x66, 0xce, 0x9e, 0x3e, 0x06, 0x06, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0xd8,
	 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36,
	 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44,
	 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44},       /* car.  */
	{0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
	 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa},       /* car.  */
	{0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77,
	 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0xf8,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xf6,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0xf6,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xfe,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xfe,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3f,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x30, 0x37,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xff,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xf7,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xf7,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3f,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1f,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff,
	 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0xff,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},       /* car.  */
	{0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0},       /* car.  */
	{0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},       /* car.  */
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0xd8,
	 0xd8, 0xd8, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0xd8, 0xcc,
	 0xc6, 0xc6, 0xc6, 0xcc, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0,
	 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x6c, 0x6c, 0x6c,
	 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0xfe, 0xc6, 0x60, 0x30, 0x18,
	 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xd8,
	 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66,
	 0x66, 0x7c, 0x60, 0x60, 0xc0, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x7e, 0x18, 0x3c, 0x66, 0x66,
	 0x66, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xfe,
	 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c,
	 0x6c, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x1e, 0x30, 0x18, 0x0c, 0x3e, 0x66,
	 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb,
	 0xdb, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x03, 0x06, 0x7e, 0xdb, 0xdb,
	 0xf3, 0x7e, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x1c, 0x30, 0x60, 0x60, 0x7c, 0x60,
	 0x60, 0x60, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6,
	 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe,
	 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18,
	 0x18, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c,
	 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30,
	 0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18,
	 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e,
	 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00,
	 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
	 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xec,
	 0x6c, 0x6c, 0x3c, 0x1c, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0xd8, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x70, 0xd8, 0x30, 0x60, 0xc8, 0xf8, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c,
	 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}        /* car.  */
};

/* tabla con las definiciones de los caracteres de 8x8 */
unsigned char _defchr8x8_sys[256][8]={
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x7e, 0x81, 0xa5, 0x81, 0xbd, 0x81, 0x81, 0x7e},
	{0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3, 0xff, 0x7e},
	{0x6c, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10},
	{0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00},
	{0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0x18, 0x18, 0x3c},
	{0x18, 0x3c, 0x7e, 0xff, 0x7e, 0x18, 0x18, 0x3c},
	{0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00},
	{0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff},
	{0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00},
	{0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff},
	{0x3c, 0x1c, 0x34, 0x78, 0xcc, 0xcc, 0xcc, 0x78},
	{0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18},
	{0x3f, 0x33, 0x3f, 0x30, 0x30, 0x70, 0xf0, 0xe0},
	{0x7f, 0x63, 0x7f, 0x63, 0x67, 0xe7, 0xe6, 0xc0},
	{0x18, 0xdb, 0x3c, 0xe7, 0x3c, 0xdb, 0x18, 0x00},
	{0xc0, 0xe0, 0xf8, 0xfe, 0xf8, 0xe0, 0xc0, 0x00},
	{0x06, 0x0e, 0x3e, 0xfe, 0x3e, 0x0e, 0x06, 0x00},
	{0x18, 0x3c, 0x7e, 0x18, 0x18, 0x7e, 0x3c, 0x18},
	{0x00, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66},
	{0x7f, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x00},
	{0x3c, 0x66, 0x38, 0x6c, 0x6c, 0x38, 0xcc, 0x78},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe},
	{0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0x7e},
	{0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18},
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18},
	{0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00},
	{0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00},
	{0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00},
	{0x00, 0x28, 0x6c, 0xfe, 0x6c, 0x28, 0x00, 0x00},
	{0x10, 0x38, 0x38, 0x7c, 0x7c, 0xfe, 0xfe, 0x00},
	{0xfe, 0xfe, 0x7c, 0x7c, 0x38, 0x38, 0x10, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car.   */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x00},       /* car. ! */
	{0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. " */
	{0x6c, 0xfe, 0x6c, 0x6c, 0x6c, 0xfe, 0x6c, 0x00},       /* car. # */
	{0x18, 0x7e, 0xc0, 0x7c, 0x06, 0xc6, 0x7c, 0x18},       /* car. $ */
	{0xc2, 0xc6, 0x0c, 0x18, 0x30, 0x66, 0xc6, 0x00},       /* car. % */
	{0x38, 0x6c, 0x38, 0x76, 0xdc, 0xcc, 0x76, 0x00},       /* car. & */
	{0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. ' */
	{0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c},       /* car. ( */
	{0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x30},       /* car. ) */
	{0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00},       /* car. * */
	{0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00},       /* car. + */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30},       /* car. , */
	{0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00},       /* car. - */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00},       /* car. . */
	{0x02, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80},       /* car. / */
	{0x7c, 0xc6, 0xce, 0xd6, 0xe6, 0xc6, 0x7c, 0x00},       /* car. 0 */
	{0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car. 1 */
	{0x7c, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xfe, 0x00},       /* car. 2 */
	{0xfe, 0x06, 0x0c, 0x3c, 0x06, 0xc6, 0x7c, 0x00},       /* car. 3 */
	{0x0c, 0x1c, 0x3c, 0x6c, 0xfe, 0x0c, 0x0c, 0x00},       /* car. 4 */
	{0xfe, 0xc0, 0xc0, 0xfc, 0x06, 0xc6, 0x7c, 0x00},       /* car. 5 */
	{0x30, 0x60, 0xc0, 0xfc, 0xc6, 0xc6, 0x7c, 0x00},       /* car. 6 */
	{0xfe, 0x06, 0x06, 0x0c, 0x18, 0x30, 0x30, 0x00},       /* car. 7 */
	{0x7c, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0x7c, 0x00},       /* car. 8 */
	{0x7c, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x38, 0x00},       /* car. 9 */
	{0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00},       /* car. : */
	{0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30},       /* car. ; */
	{0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00},       /* car. < */
	{0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00},       /* car. = */
	{0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00},       /* car. > */
	{0x7c, 0xc6, 0xc6, 0x0c, 0x18, 0x18, 0x00, 0x18},       /* car. ? */
	{0x7c, 0xc6, 0xc6, 0xde, 0xdc, 0xc0, 0x7c, 0x00},       /* car. @ */
	{0x10, 0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0xc6, 0x00},       /* car. A */
	{0xfc, 0xc6, 0xc6, 0xfc, 0xc6, 0xc6, 0xfc, 0x00},       /* car. B */
	{0x3c, 0x66, 0xc0, 0xc0, 0xc0, 0x66, 0x3c, 0x00},       /* car. C */
	{0xf8, 0xcc, 0xc6, 0xc6, 0xc6, 0xcc, 0xf8, 0x00},       /* car. D */
	{0xfe, 0xc6, 0xc0, 0xf0, 0xc0, 0xc6, 0xfe, 0x00},       /* car. E */
	{0xfe, 0xc6, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0x00},       /* car. F */
	{0x3c, 0x66, 0xc0, 0xce, 0xc6, 0xc6, 0x7e, 0x00},       /* car. G */
	{0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00},       /* car. H */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car. I */
	{0x06, 0x06, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00},       /* car. J */
	{0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0x00},       /* car. K */
	{0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0xfe, 0x00},       /* car. L */
	{0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0x00},       /* car. M */
	{0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0x00},       /* car. N */
	{0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00},       /* car. O */
	{0xfc, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x00},       /* car. P */
	{0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xde, 0x7c, 0x06},       /* car. Q */
	{0xfc, 0xc6, 0xc6, 0xfc, 0xd8, 0xcc, 0xc6, 0x00},       /* car. R */
	{0x7c, 0xc6, 0xc0, 0x7c, 0x06, 0xc6, 0x7c, 0x00},       /* car. S */
	{0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car. T */
	{0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00},       /* car. U */
	{0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00},       /* car. V */
	{0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0x7c, 0x28, 0x00},       /* car. W */
	{0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00},       /* car. X */
	{0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x00},       /* car. Y */
	{0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00},       /* car. Z */
	{0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c},       /* car. [ */
	{0x80, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x02},       /* car. \ */
	{0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c},       /* car. ] */
	{0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00},       /* car. ^ */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff},       /* car. _ */
	{0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. ` */
	{0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00},       /* car. a */
	{0xc0, 0xc0, 0xf8, 0xcc, 0xc6, 0xc6, 0xfc, 0x00},       /* car. b */
	{0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7e, 0x00},       /* car. c */
	{0x06, 0x06, 0x3e, 0x66, 0xc6, 0xc6, 0x7e, 0x00},       /* car. d */
	{0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00},       /* car. e */
	{0x38, 0x6c, 0x60, 0x60, 0xf0, 0x60, 0x60, 0x60},       /* car. f */
	{0x00, 0x00, 0x7e, 0xc6, 0xc6, 0x7e, 0x06, 0x7c},       /* car. g */
	{0xc0, 0xc0, 0xdc, 0xe6, 0xc6, 0xc6, 0xc6, 0x00},       /* car. h */
	{0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car. i */
	{0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x66, 0x3c},       /* car. j */
	{0xc0, 0xc0, 0xc6, 0xcc, 0xf8, 0xcc, 0xc6, 0x00},       /* car. k */
	{0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car. l */
	{0x00, 0x00, 0x6c, 0xfe, 0xd6, 0xc6, 0xc6, 0x00},       /* car. m */
	{0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0x00},       /* car. n */
	{0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00},       /* car. o */
	{0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0},       /* car. p */
	{0x00, 0x00, 0x7e, 0xc6, 0xc6, 0x7e, 0x06, 0x06},       /* car. q */
	{0x00, 0x00, 0xfc, 0xc6, 0xc0, 0xc0, 0xc0, 0x00},       /* car. r */
	{0x00, 0x00, 0x7c, 0xc0, 0x7c, 0x06, 0xfc, 0x00},       /* car. s */
	{0x60, 0x60, 0xf8, 0x60, 0x60, 0x66, 0x3c, 0x00},       /* car. t */
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00},       /* car. u */
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x00},       /* car. v */
	{0x00, 0x00, 0xc6, 0xc6, 0xd6, 0xfe, 0x6c, 0x00},       /* car. w */
	{0x00, 0x00, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0x00},       /* car. x */
	{0x00, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x0c, 0x38},       /* car. y */
	{0x00, 0x00, 0xfe, 0x0c, 0x38, 0x60, 0xfe, 0x00},       /* car. z */
	{0x0e, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x0e},       /* car. { */
	{0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18},       /* car. | */
	{0x70, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x18, 0x70},       /* car. } */
	{0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00},       /* car. ~ */
	{0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0x00},       /* car.  */
	{0x3c, 0x66, 0xc0, 0xc0, 0x66, 0x3c, 0x0c, 0x7e},       /* car.  */
	{0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00},       /* car.  */
	{0x70, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00},       /* car.  */
	{0x38, 0x44, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00},       /* car.  */
	{0xcc, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00},       /* car.  */
	{0x70, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00},       /* car.  */
	{0x30, 0x30, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00},       /* car.  */
	{0x00, 0x00, 0x7c, 0xc6, 0xc0, 0x7e, 0x0c, 0x7e},       /* car.  */
	{0x38, 0x44, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00},       /* car.  */
	{0xcc, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00},       /* car.  */
	{0x70, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00},       /* car.  */
	{0x66, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car.  */
	{0x18, 0x24, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car.  */
	{0x38, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car.  */
	{0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0x00},       /* car.  */
	{0x10, 0x28, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0x00},       /* car.  */
	{0x18, 0x00, 0xfe, 0xc0, 0xf0, 0xc0, 0xfe, 0x00},       /* car.  */
	{0xcc, 0x76, 0x36, 0x7e, 0xd8, 0xd8, 0x6e, 0x00},       /* car.  */
	{0x3e, 0x6c, 0xcc, 0xfe, 0xcc, 0xcc, 0xce, 0x00},       /* car.  */
	{0x38, 0x44, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00},       /* car.  */
	{0xcc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00},       /* car.  */
	{0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00},       /* car.  */
	{0x38, 0x44, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00},       /* car.  */
	{0x70, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00},       /* car.  */
	{0xc6, 0x00, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x38},       /* car.  */
	{0xc6, 0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x38, 0x00},       /* car.  */
	{0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00},       /* car.  */
	{0x18, 0x3c, 0x66, 0x60, 0x66, 0x3c, 0x18, 0x00},       /* car.  */
	{0x38, 0x6c, 0x60, 0xf0, 0x60, 0x60, 0xfe, 0x00},       /* car.  */
	{0x66, 0x3c, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x00},       /* car.  */
	{0xf8, 0xcc, 0xf8, 0xc4, 0xde, 0xcc, 0xc6, 0x00},       /* car.  */
	{0x0e, 0x1b, 0x18, 0x7e, 0x18, 0xd8, 0x70, 0x00},       /* car.  */
	{0x1c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x76, 0x00},       /* car.  */
	{0x1c, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car.  */
	{0x1c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00},       /* car.  */
	{0x1c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00},       /* car.  */
	{0x7c, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0x00},       /* car.  */
	{0x7c, 0x00, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0x00},       /* car.  */
	{0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00},       /* car.  */
	{0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00, 0x00},       /* car.  */
	{0x30, 0x00, 0x30, 0x30, 0x60, 0xc6, 0xc6, 0x7c},       /* car.  */
	{0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0xfe, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00},       /* car.  */
	{0xc3, 0xc6, 0xcc, 0xde, 0x33, 0x66, 0xcc, 0x0f},       /* car.  */
	{0xc3, 0xc6, 0xcc, 0xdb, 0x37, 0x6f, 0xcf, 0x03},       /* car.  */
	{0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car.  */
	{0x00, 0x00, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x00},       /* car.  */
	{0x00, 0x00, 0xd8, 0x6c, 0x36, 0x6c, 0xd8, 0x00},       /* car.  */
	{0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88},       /* car.  */
	{0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa},       /* car.  */
	{0xdb, 0x77, 0xdb, 0xee, 0xdb, 0x77, 0xdb, 0xee},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18},       /* car.  */
	{0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36},       /* car.  */
	{0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00},       /* car.  */
	{0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36},       /* car.  */
	{0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00},       /* car.  */
	{0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36},       /* car.  */
	{0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36},       /* car.  */
	{0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18},       /* car.  */
	{0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},       /* car.  */
	{0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0},       /* car.  */
	{0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f},       /* car.  */
	{0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x76, 0xdc, 0xc8, 0xdc, 0x76, 0x00},       /* car.  */
	{0x00, 0x78, 0xcc, 0xf8, 0xcc, 0xf8, 0xc0, 0xc0},       /* car.  */
	{0x00, 0xfc, 0xcc, 0xc0, 0xc0, 0xc0, 0xc0, 0x00},       /* car.  */
	{0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00},       /* car.  */
	{0xfc, 0xcc, 0x60, 0x30, 0x60, 0xcc, 0xfc, 0x00},       /* car.  */
	{0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0x70, 0x00},       /* car.  */
	{0x00, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0xc0},       /* car.  */
	{0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x18, 0x00},       /* car.  */
	{0xfc, 0x30, 0x78, 0xcc, 0xcc, 0x78, 0x30, 0xfc},       /* car.  */
	{0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0x6c, 0x38, 0x00},       /* car.  */
	{0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x6c, 0xee, 0x00},       /* car.  */
	{0x1c, 0x30, 0x18, 0x7c, 0xcc, 0xcc, 0x78, 0x00},       /* car.  */
	{0x00, 0x00, 0x7e, 0xdb, 0xdb, 0x7e, 0x00, 0x00},       /* car.  */
	{0x06, 0x0c, 0x7e, 0xdb, 0xdb, 0x7e, 0x60, 0xc0},       /* car.  */
	{0x38, 0x60, 0xc0, 0xf8, 0xc0, 0x60, 0x38, 0x00},       /* car.  */
	{0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x00},       /* car.  */
	{0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x00},       /* car.  */
	{0x30, 0x30, 0xfc, 0x30, 0x30, 0x00, 0xfc, 0x00},       /* car.  */
	{0x60, 0x30, 0x18, 0x30, 0x60, 0x00, 0xfc, 0x00},       /* car.  */
	{0x18, 0x30, 0x60, 0x30, 0x18, 0x00, 0xfc, 0x00},       /* car.  */
	{0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18},       /* car.  */
	{0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0x70},       /* car.  */
	{0x30, 0x30, 0x00, 0xfc, 0x00, 0x30, 0x30, 0x00},       /* car.  */
	{0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00},       /* car.  */
	{0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00},       /* car.  */
	{0x0f, 0x0c, 0x0c, 0x0c, 0xec, 0x6c, 0x3c, 0x1c},       /* car.  */
	{0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00},       /* car.  */
	{0x70, 0x18, 0x30, 0x60, 0x78, 0x00, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00},       /* car.  */
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}        /* car.  */
};

/* tabla con las anchuras de los caracteres de 8xCHR_ALT */
unsigned char _anchchr_sys[256]={
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
};

/* tabla con las anchuras de los caracteres de 8x8 */
unsigned char _anchchr8x8_sys[256]={
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
};

#endif  /* DEFCHR_H */

