/**************************************
	Fichero de cabecera de
	las funciones de manejo
	del ratn de RATONG.C
**************************************/

#if !defined (RATONG_H)
#define RATONG_H

/*** Constantes ***/
#define RG_NOVAL	9999	/* valor para ratn no inicializado */
#define RG_MUESTRA      1       /* para mostrar puntero de ratn */
#define RG_OCULTA      	2       /* para ocultar puntero de ratn */

/*** Tipos de datos y estructuras ***/
typedef struct {
	int boton1, boton2;     /* estado de los botones del ratn */
				/* 1 pulsado, 0 suelto */
	int xv, yv;           	/* coordenadas virtuales del ratn */
	int x, y;		/* coordenadas reales del ratn */
	int fil, col;         	/* fila y columna del ratn */
} STC_RATONG;

/*** Prototipos ***/
int rg_inicializa(void);
int rg_puntero(int modo);
int rg_estado(STC_RATONG *raton);
int rg_pon_puntero(int x, int y);
void rg_desconecta(void);

#endif  /* RATONG_H */
