#pragma C+

/*
** Actdemo.t -- a tiny example game demonstrating the module actor.t
** Copyright (c) 1995, 1996 Stephen Granade
** You are permitted to distribute this module freely, as long as 1) my name
** is left on it, and 2) you keep all files together.  You may also use
** this module in any game you like in any form you like.  Hack away at
** it, if you so desire.
** I would welcome any comments on or suggestions for this module.  I can be
** reached at:
**  1615 #1 Forest Rd.
**  Durham, NC  27705
**  U.S.A.
**  sgranade@phy.duke.edu
**
** Version history:
**  18 Oct 95 -- Initial release
**  23 Aug 96 -- Made this example compatible with actor.t changes
**  13 Jan 97 -- Updated the demo to use the newer functions
*/

#include "adv.t"
#include "std.t"
#include "actor.t"

// First, four rooms
startroom : room
    sdesc = "Room One"
    ldesc = "Room one is a featureless cubicle with a doorway leading north.  "
    north = roomtwo
;

roomtwo : room
    sdesc = "Room Two"
    ldesc = "Room two is another featureless cubicle.  To the south and east,
            doorways.  Beside the east doorway, a window.  "
    south = startroom
    east = roomthree
    firstseen = { sam.firstMove; }
;

// The window is a demonstration of actorin and actorlist.  Notice how I
//  used actorin to see if there were any actors inside the room, then
//  actorlist to list all of them.
mywindow : fixeditem, seethruItem
    noun = 'window'
    sdesc = "window"
    location = roomtwo
    ldesc = "The window affords you a glimpse into the next room.  You could
        look through it.  "
    thrudesc = {
        "You can dimly see a featureless cubicle with a door to the north.  ";
        if (actorin(roomthree))
            "You can also just make out <<actorlist(roomthree)>> inside.  ";
    }
;

roomthree : room
    sdesc = "Room Three"
    ldesc = {
        "Room three is another of the featureless cubicles.  A western
            doorway is flanked by a window, and to the north is
            a<<mydoor.isopen ? "n open" : " closed">> door.  Against the
            east wall is an easy chair.  ";
    }
    west = roomtwo
    north = mydoor
;

// The mate to mywindow
myotherwindow : fixeditem, seethruItem
    noun = 'window'
    sdesc = "window"
    location = roomthree
    ldesc = "The window looks into room two.  "
    thrudesc = {
        "You can dimly see a featureless cubicle with a doorway to the south.  ";
        if (actorin(roomtwo))
            "You can also just make out <<actorlist(roomtwo)>> inside.  ";
    }
;

mydoor : lockableDoorway
    islocked = nil
    otherside = myotherdoor
    doordest = roomfour
    location = roomthree
    noun = 'door'
    sdesc = "door"
;

//  Notice the use of samdesc; see Sam's definition below
chair : chairitem
    noun = 'chair'
    adjective = 'easy'
    location = roomthree
    sdesc = "easy chair"
    ldesc = "The easy chair is battered, indicating the heavy use it has
        seen over the years.  "
    verDoSiton(actor) = {
        if (sam.location == self)
            "Not while Sam's in it!  ";
        else pass verDoSit;
    }
    leaveRoom(actor) = {
        if (actor == Me && sam.location == self.location &&
            !sam.isMoving) {
            "As you stand, Sam sinks into the chair with a grateful
                sigh to you.  ";
            sam.location = self;
        }
        pass leaveRoom;
    }
    samdesc = 'Hey, this job\'s tiring.  I have to have somewhere to rest.'
;

roomfour : room
    sdesc = "Room Four"
    ldesc = {
        "Room four is a slightly smaller cubicle.  It is more featureless than
            rooms one through three, if possible.  To the south is
            a<<myotherdoor.isopen ? "n open" : "closed">> door.  ";
    }
    south = myotherdoor
;

myotherdoor : lockableDoorway
    islocked = nil
    otherside = mydoor
    doordest = roomthree
    location = roomfour
    noun = 'door'
    sdesc = "door"
;

// An object to demonstrate the owned class.
nightstick : owned
    owner = "Sam"
    noun = 'nightstick' 'stick'
    sdesc = "nightstick"
    ldesc = "Sam often carries the nightstick with him when he's making his
        rounds.  Apparently he's left it here for now.  "
    location = roomthree
    samdesc = "Sam grins.  \"My nightstick's great.\"  Then he frowns
        slightly. \"I used to carry it all the time, but I got tired of
        that, so I stopped.\" "
;

thingy : item
    noun = 'thingy'
    sdesc = "thingy"
    thedesc = "a thingy"
    ldesc = "God only knows what this thingy is.  It looks like it has
        been well chewed on.  "
    location = roomtwo
    samdesc = "\"That belongs to Crazy Harry.  Thing is, he keeps forgetting
        about it.  If you'd go ask him about it, he'd jump up and go looking
        for it.\" "

;

// Two actors
sam : trackActor
// Here's where Sam's wandering pattern is set.  Notice that the list is
//  only one list long.  The blank directions make the actor pause
    motionList = [['w' '' '' 's' '' '' 'n' '' '' 'e' '' '' 'n' '' ''
        's']]
    askme = &samdesc        // Notice the '&' in front of samdesc!

    noun = 'sam'
    sdesc = "Sam"
    thedesc = "Sam"
    adesc = "Sam"
    ldesc = "Sam guards these four cubicles, though from what, no one knows.
        He spends his time wandering back and forth, back and forth.  "
    actorDesc = {
        if (self.location == chair)
            "Sam is resting here in the easy chair.  ";
        else "Sam stands here, watching alertly for suspicious behavior.  ";
    }

// Here is an example of a changed leavedesc and arrivedesc
    leavedesc(dirStr) = {
        "\bSam lopes off to the <<dirStr>>. ";
    }
    arrivedesc(dirStr) = {
        "\bSam arrives from the <<dirStr>>. ";
    }

    location = roomthree
    myfollower = samfollower
    actorAction(v, d, p, i) = {
        if (v == helloVerb) {
            "Sam nods at you.  \"Hello,\" he replies.  ";
            exit;
        }
        else pass actorAction;
    }
    disavow = "Sam scratches his head.  \"I don't know much about that.\"  "

// alreadyTold is printed whenever you ask Sam about something twice
    alreadyTold = "Sam sighs.  \"I told you everything I knew already.\"  "

// arriveDaemon is called every time the actor 'arrives', that is, reaches
//  the end of one of the lists in motionList.  Since Sam only has one
//  list, this is called every time he loops back around to roomthree.
    arriveDaemon = {

// Prepare to loop again by resetting motionListNum, setting up an action,
//  and making Sam move again right after he performs the action.
        self.motionListNum = 1;
        self.actionTurn = global.turnsofar + 5 + rand(5);
        self.moveTurn = self.actionTurn + 1;
        if (uberloc(Me) != uberloc(self))
            self.location = chair;
        else {
            "\bSam sighs heavily to himself.  ";
            if (Me.location == chair)
                "He eyes the chair longingly, but doesn't say anything.  ";
            else {
                "He then lowers himself none too gently into the chair.  ";
                self.location = chair;
            }
        }
    }

// Prepare Sam for his rounds.  This is called just before he starts
//  wandering again.
    actionDaemon = {
        if (self.location == chair) {
            if (uberloc(Me) == uberloc(self))
                "\bSam stands up, preparing for his rounds.  ";
            self.location = chair.location;
        }
    }

// Called whenever an actor runs into a locked door.  Notice that the player
//  can keep locking the door again, and Sam will patiently keep unlocking
//  it.  Also, notice that every time an actor can't get through a locked
//  door, they'll try it again next turn.
    doorLocked(dest) = {
        mydoor.islocked = nil;
        myotherdoor.islocked = nil;
        if (uberloc(Me) == dest.location)
            "\bSam tries the door, finds it locked, and unlocks it.  ";
        else if (uberloc(Me) == dest.otherside.location)
            "\bYou hear the door unlocking.  ";
    }
;

harry : trackActor
// Harry's motionList consists of six lists.
    motionList = [['s' 'w'] ['e'] ['w' 'e' 'w' 's'] ['n'] ['e'] ['n']]
    noun = 'harry'
    adjective = 'crazy'
    thedesc = "Crazy Harry"
    adesc = "Crazy Harry"
    sdesc = "Crazy Harry"
    ldesc = "Crazy Harry has eyes that dart about the room, looking here
        and there without ever settling on anything.  His white hair stands
        straight out from his head.  "

// This is a good example of how to use code in your askme routines
    samdesc = {
// Notice my use of uberloc() in the next line.  This way, if Sam is in
//  his easy chair and Harry's in roomthree, uberloc() still shows them
//  as both being in roomthree.
        if (uberloc(sam) == uberloc(self))
            "Sam glances at Harry, then whispers, \"Shh, not now!\"  ";
        else "\"He's crazy, all right.  Been here for as long as I
            can remember.  I used to try to run him out of here, but
            he never stayed away.  The owners don't mind too much, so
            I don't bother any more.\"  ";
    }
    actorDesc = {

// Harry has a different description when he's moving than when he's standing
//  still
        if (self.isMoving)
            "Crazy Harry is dashing through the room, looking for
                something.  ";
        else "Crazy Harry leans against one of the walls, muttering to
            himself.  ";
    }
    location = roomfour
    actorAction(v, d, p, i) = {
        if (v == helloVerb) {
            "Harry giggles maniacally in return.  ";
            exit;
        }
        else pass actorAction;
    }
    disavow = "\"Don't know about that!  Hee-hee-hee-heeeee!\"  "
    alreadyTold = "\"Already told you about that!  Nobody home!  Nobody
        home!\"  Harry covers his face with his hands, giggling to
        himself.  "
    // Notice I used the if/else if style to handle "ask about" for Harry
    doAskAbout(actor, io) = {
// Notice I had to add back in the line which adds this object to factTold
//  whenever Harry is asked about something
        io.factTold += self;
        if (io == sam) {
            "\"Oh, Sam nice, Sam nice.  Nice to poor Smeagol, yess,
                yess...\"  ";
            if (uberloc(self) == uberloc(sam))
                "Sam grins sadly at Harry.  ";
        }
        else if (io == thingy) {
            thingy.factTold -= self;
            "\"My thingy!  My thingy!\" he screams.  ";
            if (thingy.location == self.location)
                "Harry glances about, sees his thingy, and calms down
                    once more.  ";
            else { self.firstMove; }
        }
        else self.disavow;
    }
    arriveDaemon = {
        local togetherflag;     // True if the player's in the same room
                                //  as Harry

// If we're at the end of motionList (i.e. motionListNum is one greater
//  than the actual number of lists in motionList), see if we found
//  the thingy.  If so, drop it.  If not, start all over again.
        if (self.motionListNum == 7) {
            self.motionListNum = 1;     // Reset his moves
            if (thingy.location == self) {
                thingy.moveInto(self.location);
                if (uberloc(Me) == uberloc(self))
                    "\bCrazy Harry drops his thingy to the floor and
                        begins crooning softly to himself.  ";
            }
            else self.firstMove;
        }

// If we've just paused & we already have the thingy, keep moving by
//  setting isMoving to true again.
        else if (thingy.location == self)
            self.isMoving = true;

// Otherwise, look for the thingy
        else {
            if (uberloc(Me) == uberloc(self))
                togetherflag = true;
            else togetherflag = nil;
            if (togetherflag)
                "\bHarry suddenly stops dashing about.  \"Thingy!\" he
                    shouts.  \"Thingy!\"  ";
            else "\bFrom somewhere nearby, you hear Harry shouting,
                \"Thingy!  Thingy!\"  ";
            if (uberloc(thingy) == uberloc(self)) {
                if (thingy.location == Me)
                    "He glances at what you're holding in your hands.  His
                        eyes widen.  \"THIIIIINNNNNGGGGGGYYYYYYY!\" he
                        shrills, grabbing it from you.  ";
                else if (togetherflag)
                    "His eyes happen to fall on the thingy.  \"Thingy!
                        My thingy!\" he cries joyfully as he grabs it.  ";
                else "You then hear him crying out joyfully, \"Thingy!
                    My thingy!\"  ";
                thingy.moveInto(self);
                if (self.location == startroom)
                    self.motionListNum = 4;
                else if (self.location == roomtwo)
                    self.motionListNum = 5;
                else if (self.location == roomthree)
                    self.motionListNum = 6;
                else {
                    self.motionListNum = 7;
                    self.hasArrived = true;
                    return;
                }
            }
            self.isMoving = true;
        }
    }
    doorLocked(dest) = {
        if (uberloc(Me) == uberloc(self))
            "\bHarry beats on the locked door, apparently not realizing that
                he could unlock it himself.  \"Open door!  Open door!\" he
                howls.  ";
        else "\bFrom somewhere nearby, you hear Harry beating on something
            and screaming, \"Open door!  Open door!\"  ";
        if (uberloc(sam) == uberloc(self)) {
            mydoor.islocked = nil;
            myotherdoor.islocked = nil;
            if (uberloc(Me) == uberloc(sam))
                "Sam unlocks the door for Harry, sighing heavily.
                    Evidently, he's done this before.  ";
            else if (uberloc(Me) == dest.otherside.location)
                "You hear the door unlocking.  ";
        }
    }
;


// Add a Sam follower
samfollower : follower
    noun = 'sam'
    myactor = sam
;
