#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

/* 
 *   Topic objects used in various other files. We collect them here since 
 *   they might be referred to in several source files, and it's easier to 
 *   keep track of them if they're all in the same place
 *
 *   Note that I adopt the convention of starting all topic object names with t.
 */
 
tAcademics: Topic 'academics/academia/scholars';
tActsOfJesus: Topic 'five acts/(jesus)/(gospels)';
tAngel: Topic 'angel*angels';
tAnnihilation: Topic 'total annihilation';
tAphrodite: Topic 'aphrodite';
tArcosolium: Topic 'arcosolium';
tAuthenticity : Topic 'authenticity/methodology';
tBeads: Topic 'coloured colored beads';
tBooks: Topic '(his) (professor) {prof.) (wortschlachter\'s) books';
tBooze: Topic 'booze/alcohol/drink/wine/beer/gin/whisky/whiskey/vodka/
    cider/lager/ale/rum/brandy';
tBreakfast: Topic 'breakfast';
tBultmann: Topic 'rudolph bultmannian bultmann';
tCaiaphas: Topic '(joseph) (jewish) high (priest)/caiaphas';
tCambridge: Topic 'cambridge';
tChessGame: Topic 'chess game/chess';
tChest: Topic '(my) (your) chest';
tCoherence: Topic '(criterion)/coherence';
tCorporalPunishment: Topic 'corporal punishment';
tCourage: Topic 'courage/bravery';
tCriminals: Topic 'criminals';
tCriteria: Topic 'criteria/criterion';
tDamnation: Topic '(eternal) damnation';
tDamned: Topic 'damned';
tDeath: Topic 'death/dying';
tDeceit: Topic 'deceit/falsehood/deception';
tDemythologization: Topic 'demythologization';
tDiss: Topic 'diss';
tDoor: Topic 'door/gate';
tDoubleDissimilarity: Topic 'double (criterion)/dissimilarity';
tE: Topic '(final) e';
tEscape: Topic 'way escape/out/exit';
tEternity: Topic 'eternity';
tExit: Topic 'unobvious way out/exit';
tExodus: Topic '(4) exodus';
tFaith: Topic 'faith';
tFame: Topic 'fame';
tFirstTemptation: Topic 'first temptation';
tFreedom: Topic 'freedom/liberty';
tFood: Topic 'food/feast/banquet';
tGame: Topic 'game/chess';
tGlory: Topic '(great) glory';
tGod: Topic 'god';
tGospels: Topic 'canonical non-canonical (synoptic) 
            gospels/matthew/luke/john/thomas/peter/evangelists';
tHanina: Topic 'hanina ben dosa';
tHeaven: Topic 'heaven';
tHeidegger: Topic 'martin heidegger/existentialism';
tHell: Topic 'hell';
tHerName: Topic 'her name';
tHistoricalJesus: Topic 'historical jesus research/jesus/christ';
tHome: Topic 'home';
tHope: Topic 'hope';
tIntegrity: Topic 'integrity';
tJesusSeminar: Topic 'jesus seminar';
tJesusWalking: Topic 'jesus walking (on) (the) sea/water/jesus';
tJosephus: Topic '(flavius) josephus';
tJoy: Topic 'joy/happiness';
tJustice: Topic 'justice';
tKiss: Topic 'kiss';
tKnowledge: Topic 'knowledge';
tLanguage: Topic 'language/words/phrases';
tLiberals: Topic 'bleeding heart liberals';
tLife: Topic 'life';
tLove: Topic 'love';
tLuck: Topic '(good) luck';
tMark: Topic 'mark\'s empty tomb gospel/mark/tomb/(story)';
tMarkQOverlaps: Topic '(mark) (q) mark-q overlaps';
tMates: Topic 'his demon\'s best mate/mates';
tMeddlers: Topic '(diabolical) (satanic) meddlers/bureaucrats';
tMidrash: Topic 'midrashic midrash/(exegesis)';
tMinorAgreements: Topic 'minor agreements';
tMultipleAttestation: Topic 'multiple (criterion)/attestation';
tMyth: Topic 'myth/myths/mythology';
tMoney: Topic 'money/wealth/riches';
tMovie: Topic '(old) (silent) movie/film';
tNewTestament: Topic 'new testament nt testament/scholarship';
tNetherworld : Topic 'netherworld';
tNothing: Topic 'nothing';
tOmnipotence: Topic '(total) (absolute) omnipotence';
tPain: Topic 'pain/agony/discomfort';
tPants: Topic 'pants pan-atlantic pan atlantic new testament society conference';
tPatch: Topic 'coloured patch/patches';
tPerdition: Topic 'perdition\'s flames';
tPericope: Topic 'pericope/pericopai/pericopae/periscope';
tPilate: Topic 'pontius roman pilate/governor';
tPhilo: Topic 'philonic allegorical philo/(alexandria)/(exegesis)/allegory';
tPower: Topic '(total) (absolute) (great) power';
tPrivyCouncil : Topic 'privy council';
tQ: Topic 'sayings (gospel) q';
tQParallel: Topic 'q parallels';
tQuestions: Topic 'exam examination questions';
tReality: Topic 'real reality/world';
tReligionsGeschichte: Topic 'religionsgeschichtlichen';
tRope: Topic 'rope';
tSatan: Topic '(old) satan/devil/nick/lucifer';
tScroll: Topic 'scroll';
tSitzImLeben: Topic 'sitz im leben';
tSex: Topic 'sex/lust/women/woman';
tSleep : Topic 'eternal long sleep/rest/oblivion';
tSomething: Topic 'something';
tStrauss: Topic 'david friedrich strauss/waltz/lebenjesuwalzer';
tSuccess: Topic 'success';
tSynopticProblem: Topic 'synoptic problem';
tTargum: Topic 'proto-rabbinic targum*targumim';
tTheology: Topic 'theologically correct correctness/theology';
tTorment: Topic '(eternal) torment/torture';
tTruth: Topic 'truth';
tTwinge: Topic 'twinge';
tTwoSourceHypothesis: Topic 'two source document two-source hypothesis';
tWar: Topic 'war';
tWirrstadt: Topic 'university/wirrstadt';
tWeather : Topic 'weather';
tWork: Topic 'work/toil/labour/labor';

/* 
 *   The SemiDefaultAskTopic was my first attempt to deal with the issue of 
 *   providing DefaultTopics that appear to reflect what the player typed 
 *   without producing obviously silly output. For example, this is 
 *   acceptable:
 *
 *     >ASK BOB ABOUT LOVE 
 *     "What do you think about love?" you ask. "Ask me 
 *      about it some other time," he replies.
 *
 *   While this is not:
 *
 *     >ASK BOB ABOUT HIS MOTHER 
 *     "What do you think about his mother?" you ask.
 *     "Ask me about it some other time," he replies.
 *
 *   SemiDefaultAskTopic offers a partial solution to this problem by 
 *   containing a list of topics where a response of this type is reasonably 
 *   okay. This allows wider range of semi-customized Default responses than 
 *   would otherwise be possible without the risk of getting ones that are 
 *   completely daft; an added advantage is that the matchObj of 
 *   SemiDefaultAskTopic contains a list of topics that are directly 
 *   relevant to the game, so they represent things that players are more 
 *   likely to ask about.
 *
 *   Note, however, that in more recent work I've tackled this problem in a 
 *   slightly different way.
 */
     


class SemiDefaultAskTopic : AskTopic
  matchScore = 10
  matchObj = [tAuthenticity, tBooze, tBreakfast, tChessGame,
   tCourage, tCorporalPunishment, tCriminals, tDeath, tDeceit,
   tFaith, tFame, tFreedom, tFood, tGame, tGlory, tGod, tHeaven,
   tHell, tHope, tIntegrity, tJoy, tJustice, tKnowledge, tLanguage, tLife,
   tLove, tLove, tLuck, tMinorAgreements, tMultipleAttestation,
   tMyth, tMoney, tPower, tOmnipotence, tSex, tSleep, tSomething, tSuccess, 
   tTruth, tTorment, tMeddlers, tHome, tPain, tEternity, tWork, tWar,
   tAcademics, tAnnihilation]

;

