#charset "us-ascii"
#include <advlite.h>

// -----------------------------------------------------------------------------
// The Hint Menu System
// -----------------------------------------------------------------------------

TopHintMenu 'Hints';

+ HintMenu 'General Observations';

++ Goal 'What am I doing here?'
    [
        'Did you read the intro carefully? ',
        
        '\bYour goal is to get the prom dress from the fashion boutique. ',
        
        '\bYou&rsquo;ll find the boutique downstairs, in the lower concourse. ',
        
        '\bAs the intro implies, the boutique is now closed. You&rsquo;ll need to figure
        out how to get the door unlocked. ',
        
        '\bBut that&rsquo;s only the first of the difficulties you&rsquo;ll encounter. ',
        
        '\bMost of the people you&rsquo;ll meet in Stufftown will either be able to help you,
        or be determined to hinder you. Along the way, you&rsquo;ll find that you need to gain access to every shop
        in the shopping center, as well as other locations. ',
        
        '\bHow to go about this is explained in other sets of hints. '
    ]
    openWhenSeen = parkingLot
    topicOrder = 500
;

++ Goal 'Is it possible to get stuck, so that I can&rsquo;t win the game?'
    [
        'Yes. There are a few ways you can get stuck or
        fail in your quest. Most of these pitfalls are explained in the remainder of this set of
        hints. The explanations require spoilers, so don&rsquo;t keep reading unless you want
        to hit a few spoilers. ',
        
        '\bIf you haven\'t found all of the uses of the little red wagon, do not pull it into
        the stairwell! You\'ll never be able to get it out of the stairwell. ',
        
        '\bThere is one underground location where there&rsquo;s no light. Things are moving
        around in the dark, and when one bumps into you, you&rsquo;ll drop a random item that
        you&rsquo;re carrying. The flashlight is a reliable source of light, but if you
        should happen to go into that location without turning on the flashlight and then
        randomly drop the flashlight, anything else that you drop will be lost forever. ',
        
        '\bIn the Security Office are some video monitors with which the guards keep an
        eye on what&rsquo;s happening. It&rsquo;s possible to sabotage the monitors --- but if you
        fail to do this, whenever you enter an area that is visible on one of the monitors,
        there&rsquo;s some chance the guards will see you and arrest you for breaking and entering.
        Learning how to control the monitors will go a long way toward insuring your success. At
        the start of the game you can safely enter the pub, the security office, the art gallery,
        Stuff World Headquarters, the beauty parlor, and the fortune teller\'s room, none of which
        is very useful, and also the outdoor locations and the public areas of Stufftown.
        Once you have the master key,
        you\'ll find it safe to enter the pottery store, the snack bar, and the leather goods shop,
        as they are not under video surveillance. But if you go into any of the other
        shops, you\'ll be arrested and your quest will end in failure. ',
        
        '\bThe mynah bird won&rsquo;t let you take anything from its cage unless it&rsquo;s
        distracted --- and the device used to distract it will operate for only a few turns before
        stopping. The device can be reactivated if need be, but if you put the small object
        that&rsquo;s used for activating the device into the mynah&rsquo;s
        cage, once the distraction ceases, if you haven&rsquo;t done what you needed to do
        while the mynah was distracted, you&rsquo;re doomed. Moral: Don&rsquo;t put anything in
        the mynah&rsquo;s cage. ',
        
        '\bThere\'s a wild animal in the game that needs to be dealt with, and the object you
        need in order to deal with it has to be employed properly. There are a couple of ways to fail to
        do this --- and in each case the object you\'re trying to use will be lost forever. ',
        
        '\bIf you should happen to fall through a hatch into the subterranean area while carrying the coil of rope, and
        if you haven\'t opened up the primary route into this area, you\'re doomed. ',
        
        '\bAlso, it&rsquo;s advisable not to drop anything while you&rsquo;re in the Lamborghini.
        At a certain point the Lamborghini will no longer be enterable, so anything you accidentally
        left there will no longer be retrievable. If it&rsquo;s something you still need, the
        precious prom dress will remain forever unattainable. '
    ]
    openWhenSeen = parkingLot
    topicOrder = 515
;

++ Goal 'I hate mazes.'
    [
        'Some people feel that way. But don\'t worry.... ',
        
        '\bBoth of the mazes in this game are strictly optional. Okay, the Octagonal Room is
        sort of a maze, but not exactly.
        You\'ll definitely need to understand how to reach a few destinations by operating
        the Octagonal Room\'s controls. Also, the Virtual Capsule is arguably a maze. So
        maybe there are mazes. But the classic mazes are optional. ',
        
        '\bHowever, you can map both of them if you want to. ',
        
        '\bIf you don\'t want a couple of minor spoilers, stop here. ',
        
        '\bThe maze off of the fashion boutique can be mapped (mostly) by the canonical
        method of dropping objects. The objects will remain where dropped. A couple of the
        room exits are randomized, but most of them are reliable. ',
        
        '\bThere\'s not much point in doing that, however. You won\'t be able to find
        what you\'re seeking in the mirror maze without
        the help of an ally. ',
        
        '\bThe maze in the plant store can\'t be mapped by dropping things. There\'s another
        method that works perfectly, however. ',
        
        '\bStand still and take a close look at the plants. Look repeatedly. ',
        
        '\bThe flowers change color. ',
        
        '\bEach location in the plant maze has a different combination of flower and color
        sequence. You can map it (laboriously) by noting the combination in your current
        room, then going in some direction or other, noting the combination in the next
        room, and so on. There are nine rooms in the plant maze.
        But there\'s also an alternate route to the place in the maze
        that you need to reach, so you don\'t need to map the maze unless you want to. ',
        
        '\bIf you\'re tangled up in the plant maze and not sure how to get out, try
        CRAWL UNDER PLANTS. '
    ]
    openWhenSeen = parkingLot
    topicOrder = 520
;

// In the beginning ----------------------------------------------------------

+ HintMenu 'In the Beginning';

++ Goal 'How can I get into the shops?'
    [
        'The usual method for getting through locked doors is to use a key. ',
        
        '\bIf you look around carefully in the nearby locations to which you have immediate
        access, you should be able to spot the key. It\'s in plain sight, but you have
        to look for it. ',
        
        '\bHave you looked around in the Security Office? ',
        
        '\bThe key is hanging on a hook by the corkboard. If you examine the corkboard,
        you&rsquo;ll discover the key. ',
        
        '\bThis is the master key to all of the doors in Stufftown. (Well, to most of them.)
        Naturally, the guards are not about to let just anyone waltz off with the key. ',
        
        '\bIn order to get your hands on the key, you&rsquo;ll have to figure out how to get the
        guards to leave their office. ',
        
        '\bIf there were an emergency, they would have to respond. ',
        
        '\bTo create a suitable emergency, you&rsquo;ll need an ally. ',
        
        '\bPossibly the hairdresser could help. If you haven&rsquo;t met her yet, try knocking on 
        the door or the window of the beauty parlor. ',
        
        '\bWhen the hairdresser follows you into the location where you can make a distraction,
        she will comment on something. Her comment is a clue. ',
        
        '\bHave you looked around downstairs? ',
        
        '\bShe feels sorry for the poor octopus. She thinks it&rsquo;s imprisoned in its
        tank. ',
        
        '\bYou can&rsquo;t lift the lid of the tank by yourself, but she will be happy to
        help you. ',
        
        '\bOnce the octopus is free, you&rsquo;ve created the necessary emergency. ',
        
        '\bAfter freeing the octopus, tell the guards about the octopus. They will rush off to try to capture it,
        leaving the key unguarded. They won&rsquo;t return to their office until you
        have left it carrying the key. '
    ]
    openWhenSeen = parkingLot
    topicOrder = 510
;

++ Goal 'I have the key, but the hairdresser won\'t let me use it!'
    [
        'Annoying, isn\'t she? ',
        
        '\bYou\'ll need to get rid of her. That should be obvious. ',
        
        '\bShe has a conspicuous weakness. ',
        
        '\bShe claims she has quit smoking, but she\'s dying for a cigarette. ',
        
        '\bShe will let you unlock the smoke shop and go inside. ',
        
        '\bShe will resist the temptation to take a pack of cigarettes, but you can
        grab some cigarettes and some matches. ',
        
        '\bYou can\'t give them to her, not directly --- but you can put them in
        a place where she sometimes sneaks a smoke, and then tell her. ',
        
        '\bHave you noticed that the coat closet in the beauty parlor reeks of
        tobacco smoke? ',
        
        '\bPut the cigarettes and matches in the closet and tell her about it. When
        she goes into the closet, lock the closet door. ',
        
        '\bThis may seem cruel, but after all, she did steal your grandmother\'s ring.
        So it\'s not <i>too</i> cruel. Anyway, her boyfriend will arrive before long
        and release her. She will be gone. '
    ]
    openWhenMoved = masterKey
    topicOrder = 512
;

++ Goal 'What do I do with the box mounted on the outside rear wall of Stufftown?'
    [
        'This is the third of the perplexities you\'ll need to deal with at the start
        of the story. First the key, then the ally who helped you secure the key, and then.... ',
        
        '\bInside the box is a panel with eight switches and a couple of jacks. ',
        
        '\bAs you look around Stufftown, you&rsquo;ll soon find a cable that might
        be inserted into the jacks. ',
        
        '\bBy looking at the monitor screens in the Security Office, you can determine
        which stores are safe to enter. ',
        
        '\bHave you looked in the lamp store? ',
        
        '\bYes, the cable with the square connector and the round connector is
        perfectly suited to connecting the jacks on the
        panel. ',
        
        '\bUnfortunately, the square jack has been damaged. You\'ll need to repair it. ',
        
        '\bThere\'s a screwdriver in the broom closet in the stairwell. Handy things,
        screwdrivers. ',
        
        '\bWhen you first encountered the guards, they were discussing a shop that\'s not
        under surveillance. ',
        
        '\bThe leather goods shop downstairs is safe. You can go through it to the stairwell. ',
        
        '\bOnce you\'ve used the screwdriver to fix the square connector, the cable will plug in. Now you need
        to set the switches properly. ',
        
        '\bThere\'s a hint on a crumpled-up piece of paper in the shopping bag. (You did find
        the shopping bag, didn\'t you? It\'s in the trash can by the main entrance.) ',
        
        '\bThe note says B6 is the clue for the top row, and 9D is for the bottom row. ',
        
        '\bThe note also mentions computers. Do you suppose these bits of information might
        be in a computer programming language? ',
        
        '\bYes, they\'re hexadecimal numbers. ',
        
        '\bAnd there are eight switches in each row. ',
        
        '\bWhat would B6 or 9D be in binary (base 2) arithmetic? ',
        
        '\bThe correct settings for the switches are 1011 0110 for the top row and
        1001 1101 for the bottom row. Here, the value <q>1</q> means the switch is
        on, and <q>0</q> means it\'s off. '
    ]
    openWhenSeen = connectorPanel
    closeWhenTrue = (junctionBox.isPowered)
    topicOrder = 514
;

++ Goal 'How can I fix the monitor screen so the guards won\'t be able to see me?'
    [
        'You\'ll need to get them out of their office (again). ',
        
        '\bUntil you\'ve restored power to the major devices in Stufftown, you won\'t
        be able to do this. ',
        
        '\bMaybe it\'s time for the guards\' afternoon break. ',
        
        '\bDo you suppose they might like some beer and pizza? ',
        
        '\bThere\'s beer and pizza in the cooler in the snack bar. ',
        
        '\bBut they\'re not reachable. You\'ll need something long to reach back in there. ',
        
        '\bThere\'s a snooker bridge in the billiard room off of the pub. ',
        
        '\bBut the bartender won\'t let you into the billiard room. ',
        
        '\bNothing you can say or do will change his mind about this. ',
        
        '\bMaybe there\'s another route. ',
        
        '\bThe travel agency is near the pub, but it\'s not safe to go prowling around
        in the travel agency. The guards will be keeping an eye on it. ',
        
        '\bThe pottery store is nearby. ',
        
        '\bBut your route inward from the pottery store is likely to be blocked. The way to
        get past that blockage is explained in a different set of hints. ',
        
        '\bOnce you get the snooker bridge, you\'ll be able to get the beer and pizza and
        give them to the guards. Now you can go to work on the monitor screens. ',
        
        '\bEach of the buttons does something different. If your experiments are getting you
        nowhere, you can press the white button and then the gray button. This combination will
        return you to the starting configuration. ',
        
        '\bIn the next hint you\'ll be given a step by step explanation of what buttons to
        push. ',
        
        '\bThe solution is blue, green, red, blue, green, blue, red, blue. Set up the
        starting configuration (white and then gray) and then press the buttons in this
        order. But be warned: That\'s not the complete solution! ',
        
        '\bThe guards may come out of the break room from time to time (not while you\'re
        there) to check the monitors. If they see nothing but reruns of <i>Law & Order,</i>
        they\'ll use the buttons themselves. ',
        
        '\bOnce you\'ve set the screens the way you want them, you\'ll need to sabotage
        the buttons. ',
        
        '\bHitting them won\'t work. Maybe pouring something sticky on them? ',
        
        '\bHow about that bottle of fast-drying nail polish in the beauty salon? Pour
        it onto the buttons after setting the screens so they all show the reruns, and
        your troubles are over. '
    ]
    openWhenSeen = securityOffice
    topicOrder = 516
;

++ Goal 'How can I get into the room that\'s either stuffy or a blizzard of flying paper?'
    [
        'The ventilation system in Stufftown leaves something to be desired. ',
        
        '\bThere\'s a big HVAC machine downstairs in the utility room. ',
        
        '\bBefore you\'ve restored the power, the room beyond the pottery store will
        be unbearably stuffy (and thus not enterable). ',
        
        '\bAnd once the power is restored, if the HVAC machine is switched on (which it
        is to start with, unless you\'ve been messing with the switch), the HVAC machine will stir up a maelstrom of
        flying paper in that room. ',
        
        '\bHave you tried switching off the HVAC? ',
        
        '\bYes, the switch is stuck. But if you\'ve been careful about picking up things
        that might be useful, you already have what you need. ',
        
        '\bThere was (or still is) an oil can in the broom closet in the stairwell. Oil
        the HVAC switch and then switch it on and then off. Now you can go through the file room. '
    ]
    openWhenSeen = goingToPot
    closeWhenSeen = billiardRoom
    topicOrder = 518
;


++ Goal 'How do I escape from the wardrobe closet?'
    [
        'This closet is not a dead-end trap. ',
        
        '\bThe thing you need in order to pick the lock on the door is already in the closet. ',
        
        '\bHave you taken a close look at the amazing hat? ',
        
        '\bThe hatpin will unlock the closet door. '
    ]
    openWhenSeen = wardrobeCloset
    closeWhenTrue = (wardrobeClosetDoorInside.hasBeenUnlocked)
    topicOrder = 520
;

++ Goal 'What&rsquo;s all this nonsense on the marquee?'
    [
        '\bWhat sort of information would you expect to see on a display in this location? ',
        
        '\bIt really ought to be a list of the shops in the shopping center. ',
        
        '\bAnd perhaps it is. Apparently, digital gremlins have conspired to scramble it. ',
        
        '\bYour first impulse might be to look around for a control panel. ',
        
        '\bYou won&rsquo;t find one, however. You&rsquo;ll need to unscramble the information yourself. ',
        
        '\bPossibly the signs above the entrances of the shops will give you some useful information. ',
        
        '\bThe digital gremlins have made the process more difficult by combining, in one case, of the
        shop names with one another. ',
        
        '\bWhen you&rsquo;ve succeeded in unscrambling everything, you&rsquo;ll find that some letters are
        missing. ',
        
        '\bThe missing letters reveal a secret. ',
        
        '\bBut you&rsquo;ll need to unscramble them too --- and without a corresponding shop sign to
        provide a template. Oh, dear. ',
        
        '\bThere is, however, an obscure in-game clue that will reveal the correct order. You might
        try asking one of the people you\'ll meet about the marquee. ',
        
        'In the next set of hints, you&rsquo;ll be given specific information about
        what the missing letters are, and then on how to unscramble them. ',
        
        '\bWe\'ll start with the main level. From THE GROANING SANDWICH BOARD, an R is missing.
        From PUFF THE MAGIC STOGIE, a C is missing. From THE FINEST IN TASTE, an E
        is missing. From INKWELL FINE PRINT, an L is missing. From MADAME BLOVIATSKY
        SEERESS, a K is missing. From SCOOTERS IRISH PUB, a B is missing ',
        
        '\bFrom PLAY TOES REPUBLIC, a P is missing. From STUFF WORLD HEADQUARTERS, an S
        is missing. From MY GREEN FRIENDS, an E is missing. RACQUET SCIENCE has been jumbled
        up with FILLING STATION, and a C is missing. From HERE\'S LOOKING AT YOU, an O is
        missing. From SOMETIMES A GRAPE NOTION, an A is missing. ',
        
        '\bFrom CHARTREUSE CABOOSE, an O is missing. From FEATHERS FINS AND FUR, a U is missing.
        From HOT RAGS HANG RIGHT, the N is missing. From THE LIGHT FANTASTIC, an A is missing. From
        ASTEROID BELT, a T is missing. And from GRANDMA&rsquo;S DRAWERS, an S is missing. ',
        
        '\bPut them all together and you have RCELKB PSECOA OUNATS. ',
        
        '\bSomewhere not too far from the marquee you might find a clue that will help you put
        the letters in a different order. But if you don\'t happen to spot the clue.... ',
        
        '\bAs you try unscrambling the letters, you may find that one of the words is a type of
        object sold in one of the shops. ',
        
        '\bA seemingly useless object in that very shop will provide a further clue. ',
        
        '\bHave you tried fiddling with the bust of Shakespeare in the bookstore? ',
        
        '\bTake a close look at that leather-bound book. ',
        
        '\bIt has a clasp. ',
        
        '\bTry removing the letters for <q>clasp</q> and <q>book</q> from the jumble and
        see what you have left. ',
        
        '\bThe letters spell out the phrase <q>unclasp
        a secret book</q>. ',
        
        '\bWhat to do with that phrase is revealed in a different set of hints. '
    ]
    openWhenExamined = marquee
    topicOrder = 550
;

++ Goal 'Is the Easter egg good for anything?'
    [
        'Definitely. ',
        
        '\bTake a close look at it. ',
        
        '\bIt looks as if the top might open up. ',
        
        '\bBut trying to open it by hand won&rsquo;t work. ',
        
        '\bPossibly those colored nubs might be useful. ',
        
        '\bHave you tried pushing them? ',
        
        '\bIf you push them in a certain order, the egg might open up. ',
        
        '\bBut what order? Keep your eyes open as you wander around Stufftown. You may spot some clues. ',
        
        '\bThere are at least six places where you\'ll see patterns of these colors in 
        some combination. ',
        
        '\bBut not all of the patterns will match one another! ',
        
        '\bIn fact, there are three patterns, but on some of the objects it may not be
        clear which color comes first. ',
        
        '\bAll of the color patterns can be found in at least one place before you get
        too far along in your quest. In the next set of clues, you&rsquo;ll be told where to
        look. ',
        
        '\bFrom the parking lot, you can see four colored pennants on the roof of Stufftown. ',
        
        '\bIn the diorama in the center of the arcade, take a close look at the struts where
        the train track passes over the riverbed. ',
        
        '\bIn the wardrobe closet backstage in the amphitheater, there&rsquo;s a scarf on the
        shelf, with colored stripes. ',
        
        '\bThe color combinations can also be found on Eustace Grabby&rsquo;s necktie, the Elvis portrait,
        and the eyes of the dragon on the roof (if the building\'s power is on so that the dragon\'s eyes flash). ',
        
        '\bThe three color combinations for opening the egg are: (1) pink, yellow, green, blue;
        (2) orange, green, red, violet; (3) green, pink, blue, violet. Each combination opens
        the egg to reveal a different small object. All of these objects are useful. '
        
    ]
    openWhenSeen = easterEgg
    topicOrder = 555
;

++ Goal 'What can I do with the diorama?'
    [
        'Take a look at the layout of the track. You could also try playing with the controls. ',
        
        '\bAlso, there\'s something in the diorama that doesn\'t belong there. ',
        
        '\bThe diorama itself doesn\'t do anything useful, but it will give you some information
        that you may find useful in another location. ',
        
        '\bThere\'s no way to open or remove the clear plastic cover. ',
        
        '\bIf you want to get at the gold coin, you\'ll need to find another method. ',
        
        '\bYou can crawl under the diorama. ',
        
        '\bTo open the little hatch, you\'ll need a screwdriver. ',
        
        '\bThe screwdriver is in the broom closet in the stairwell. '
    ]
    openWhenSeen = diorama
    topicOrder = 560
;

++ Goal 'What about all this other stuff that I can pick up and carry around even though I
    still can\'t get into the shops?'
    [
        'You can do several things while you\'re still locked out of the shops. ',
        
        '\bBut most of the things you\'ll find will help you deal with perplexities
        that arise later in the story,
        so they will be explained in other sets of hints. ',
        
        '\bYou can do something right now with the Lamborghini, for instance, but until
        you\'ve gotten into the shops you can\'t do anything with the box on the rear
        of the building. ',
        
        '\bMost of the characters you can encounter early on (the bartender, the fortune teller,
        the homeless man, and so on) will be useful to you later in the story. But
        not until you have access to the shops. You can get the homeless man to help
        you with one bit even before you\'ve gained access to the shops, but there\'s
        no harm in deferring that action for a while. ',
        
        '\bYour first goal must be to get the master key. The way to do that is explained
        in a different set of hints. '
    ]
    openWhenSeen = parkingLot
    topicOrder = 565
;

// -----------------------------------------------------
// In the Shops, Part 1
// -----------------------------------------------------

+ HintMenu 'In the Shops, Part 1'
;

++ Goal 'What\'s all this about an Easter egg? Where is the Easter egg???'
    [
        'It\'s quite close to the main entrance. ',
        
        '\bBut it\'s hidden. And no, it\'s not in the trash can. ',
        
        '\bNor is it hanging out with the potted palm. ',
        
        '\bAnd it\'s not in the patio. ',
        
        '\bEggs are often found in birds\' nests. ',
        
        '\bAnd birds\' nests are often found in bushes. ',
        
        '\bHave you tried searching the hedge in the hedge-bordered path? '
    ]
    openWhenSeen = scrumptiousScrimshaw
    closeWhenMoved = easterEgg
;

++ Goal 'That mannequin stole the prom dress!'
    [
        'There\'s no way to prevent her from doing that. ',
        
        '\bYou\'ll have to find her and convince her to give it back to you. ',
        
        '\bTo find her, you\'ll need an ally. ',
        
        '\bWhen you\'ve found her, she\'ll tell you what she expects you to do
        in exchange for the dress. ',
        
        '\bThat will require another ally, who will give you a long list of
        the things he will need. ',
        
        '\bIn the next set of hints you\'ll be given some direction, though not
        a complete solution. ',
        
        '\bThe homeless guy behind the building will tell you that he\'s good at
        finding things, but he\'s not going to be able to help with this particular
        perplexity until you\'ve gotten rid of the pixies. ',
        
        '\bAt a certain point, a wizard will show up. Tell him about the
        mannequin. He is capable of stage-managing the ultimate solution that will
        convince the mannequin to return the dress to you. '
    ]
    openWhenTrue = (spilledCombs.isIn(hotRags))
;

++ Goal 'What can I do with the wheel in the pottery shop?'
    [
        'You can\'t use it to throw a new pot, but it\'s important. ',
        
        '\bHave you noticed that it\'s not working? ',
        
        '\bThere\'s a motor underneath it, and also some gears. ',
        
        '\bThere\'s a fuel cap on the motor, which can be unscrewed. ',
        
        '\bYou won\'t find any gasoline in Stufftown. ',
        
        '\bBut you might find a fluid that smells like gasoline. ',
        
        '\bThe box of cheap wine in the wine shop can be used for fueling the motor.
        You can pour the wine box into the motor. But
        that\'s only half of the challenge. ',
        
        '\bThe gears are not connected to one another. ',
        
        '\bThey\'re not movable, so you\'ll need a separate object to connect them. ',
        
        '\bMaybe something like a belt? ',
        
        '\bThere\'s a belt in the leather goods shop. ',
        
        '\bAttach the belt to the gears and then switch the motor on. ',
        
        '\bThe reason why this is important will not be apparent in the room itself.
        The wheel causes something else to spin. ',
        
        '\bAfter putting this mechanism in order, head downstairs and take a look at
        the mirror ball in the nightclub. '
    ]
    openWhenSeen = goingToPot
    closeWhenTrue = (mirrorBall.spinning)
;

++ Goal 'Where can I find a screwdriver?'
    [
        'It\'s in the broom closet. ',
        
        '\bSo what you really need to know is how to find
        the broom closet. ',
        
        '\bIt\'s not in any of the shops, nor is it in any of the easy-to-reach locations
        on any of Stufftown\'s several levels. ',
        
        '\bThere\'s an interior stairwell, which you can get to from several of the shops. ',
        
        '\bThe difficulty is, if you go into a shop that the guards can see in their surveillance
        monitor, they\'ll come and arrest you. ',
        
        '\bWhen you first entered the Security Office, the guards were discussing a limitation
        of their video apparatus. ',
        
        '\bIt doesn\'t provide coverage of the leather goods shop. ',
        
        '\bOne of them mentioned belts. ',
        
        '\bThe shop is called the Asteroid Belt. Once you have the master key to the shops,
        you can safely enter the Asteroid Belt. From there, you can reach the stairwell. ',
        
        '\bThe broom closet is up one level from the Asteroid Belt. ',
        
        '\bYou will only be able to exit the stairwell at the top, where you\'ll arrive
        on the roof. '
    ]
    openWhenTrue = (masterKey.isIn(gPlayerChar))
;

++ Goal 'The switch on the HVAC machine isn\'t working properly.'
    [
        'Initially, the switch is stuck. ',
        
        '\bLike many mechanical things of a certain age (including the author of this
        game), it needs to be lubricated. ',
        
        '\bThere\'s an oil can in the broom closet. The broom closet is in the stairwell. ',
        
        '\bOiling the switch won\'t accomplish anything, however, until power is restored
        to the large mechanical devices in Stufftown. ',
        
        '\bRestoring the power is explained in a different set of hints. But even then.... ',
        
        '\bEven then, it may not be obvious what the HVAC machine is doing. ',
        
        '\bIt sends air up through the ducts. The air current (or its
        absence) will do something somewhere else. '
    ]
    openWhenSeen = utilityRoom
    closeWhenSeen = longBalcony
;

++ Goal 'How does the Octagonal Room work?'
    [
        'Several devices in Stufftown require electrical power. This is one of them. ',
        
        '\bRestoring the power is explained in a different set of hints. Once you\'ve
        done that, the controls on the pedestal will be active. ',
        
        '\bIn this room your sense of direction is confused. To depart, you\'ll need to
        use either the rose door or the ivy door. ',
        
        '\bThey won\'t always be open, however. Each time you use the controls, the room moves. ',
        
        '\bSometimes the exits will lead to other locations. You may be able to work out what
        the controls do by observing where you end up. ',
        
        '\bYou may find it helpful to look closely at the exterior entrances to the Octagonal
        Room. ',
        
        '\bEach of the stone arches has a decorative symbol on it. ',
        
        '\bBut in case this proves too much of a
        challenge, here are some specifics. Each time you pull one of the levers, the room moves. ',
        
        '\bIt moves either up or down, unless it\'s already as high or as low as it can go. ',
        
        '\bThere are five levels, from the roof level down to a subterranean level. ',
        
        '\bThe buttons choose whether the room will rotate 1/8 turn clockwise or 1/4 turn counter-clockwise
        each time a lever is pulled, and the rotation occurs whether or not the room is able
        to continue moving up or down. ',
        
        '\bFor this reason, you can reliably get to either the top or the bottom and then press
        the red button to rotate 1/8 turn. This will allow you to ascertain exactly what the
        rotation of the room is. From there, you can make a sort of map. ',
        
        '\bThere are nine exits in all from the Octagonal Room -- three each on the main level
        and upper level of Stufftown, and one on each of the other levels. Three of the
        nine cannot be reached via any other route. ',
        
        '\bThe white lever moves the room up, and the black lever moves it down. The red button
        sets the next rotation to be clockwise by 1/8 turn, and the green button sets the
        next rotation to be counter-clockwise by 1/4 turn. ',
        
        '\bIn the next hint, the nine exits will be listed by compass direction. While you can\'t
        use compass directions in the room, this information should allow you to plan an itinerary
        from any point to any other. ',
        
        '\bThe jewel-encrusted grotto lies to the northwest in the subterranean level. The cloak
        room lies to the southeast on the lower floor. On the main level, the file room is south
        of the Octagonal Room, the untended garden is east, and the area behind the stairs is
        west. On the upper level, the balcony is to the north, the east end of the promenade
        (through which you first enter the room) is southwest, and there\'s a secluded corner
        of the plant store to the southeast. On the roof, the narrow ledge is to the southeast. ',
        
        '\bTo return the room to the orientation that it had when you first entered it, pull
        the black lever four times, so that you\'re at the subterranean level. Press the red
        button, and then continue working the black lever until the rose door (not the ivy door!)
        is open on the jewel-encrusted grotto. Leaving the red button active, pull the white
        lever three times. Each time, the ivy door will be open, and the
        third time you pull the white lever you\'ll be back where you started. In the next few hints
        you\'ll learn how to move from the starting orientation to each of the other exits
        from the room. ',
        
        '\bTo get to the jewel-encrusted grotto from the room\'s starting position, press the
        green button, then pull the black lever twice. Press the red button, and pull the black
        lever one more time. The rose door is now open on the grotto. ',
        
        '\bTo get to the balcony and the secluded lair of the gerbils and marionettes,
        from the starting position, press the red button and pull
        the black lever twice, then press the green button and pull the white lever twice. ',
        
        '\bTo get to the roof level from the room\'s starting position, press the green button
        and pull the white lever once. ',
        
        '\bTo get to the garden from the starting position, press the green button and pull the
        black lever once. Press red and pull the black lever again, then
        pull the white lever. ',
        
        '\bThe other exits from the Octagonal Room are less interesting. '
    ]
    openWhenSeen = octagonalRoom
;

++ Goal 'I\'m stuck in the stock room with the ghost!'
    [
        'No matter what you have or haven\'t brought into the room with you, there\'s
        a way to escape. ',
        
        '\bHe\'s quite convinced of his own importance, isn\'t he? ',
        
        '\bHave a look around the room. There\'s not a lot to see. ',
        
        '\bI wonder what\'s under the sheets. ',
        
        '\bTake the sheet from the tall thing. Ah, it\'s a mirror! ',
        
        '\bShow the mirror to the ghost. He will become so absorbed by his own
        reflection that you\'ll be able to grab the book and leave. '
    ]
    openWhenSeen = ralph
    closeWhenTrue = (ralph.curState == ralphPreening)
;

++ Goal 'How can I get down to the base of the cliff?'
    [
        'You\'ll need some simple climbing gear. ',
        
        '\bMaybe a coil of rope. ',
        
        '\bThere\'s a coil of rope tucked away behind the stairs on the
        hedge-bordered path. ',
        
        '\bLook behind the stairs, then go east. ',
        
        '\bTie the rope to the pole and then lower it over the cliff. '
    ]
    openWhenSeen = footOfPole
    closeWhenSeen = footOfCliff
;

++ Goal 'I think I need a rope. Where\'s the rope?'
    [
        'It\'s not far from the main entrance. ',
        
        '\bMost of the little environmental details that pop up from time to time
        in that area are just for atmosphere, but one or two of them are meaningful. ',
        
        '\bDid you notice a cat? ',
        
        '\bIn the hedge-bordered path, the cat ducks out of sight behind the stairs. ',
        
        '\bIf you look behind the stairs, a new travel direction (east) becomes available. ',
        
        '\bNow you can go directly east from the hedge-bordered path. That\'s where you\'ll
        find the rope. '
    ]
    openWhenSeen = footOfPole
    closeWhenSeen = behindStairs
;

// -----------------------------------------------------
// In the Shops, Part 2
// -----------------------------------------------------

+ HintMenu 'In the Shops, Part 2'
;

++ Goal 'What\'s going on in the bookstore?'
    [
        'Have you noticed anything unusual? ',
        
        '\bThere are some markings on the floor. ',
        
        '\bDo you suppose one of the shelf units might be a secret door? ',
        
        '\bTry fiddling around with the bust of Shakespeare. ',
        
        '\bA book will fall out of the bookcase. ',
        
        '\bExamine the book and then open it. ',
        
        '\bTo open the secret door, you\'ll need to enter a secret code. ',
        
        '\bThe code is a phrase, and a phrase is built out of letters. ',
        
        '\bWhere have you seen a possible source of letters? ',
        
        '\bHave you tried reading the marquee at the entrance of Stufftown? ',
        
        '\bThe method for unscrambling the marquee is revealed in a different
        set of hints. ',
        
        '\bThere\'s also a clue in the snack bar. ',
        
        '\bWhen you\'ve worked out the correct phrase, enter it in the tablet
        in the book. The answer is revealed in the next hint. ',
        
        '\bThe phrase (borrowed from a Shakespeare play) is UNCLASP A SECRET BOOK. '
    ]
    openWhenSeen = rareBookShop
    closeWhenSeen = printery
;

++ Goal 'How do I get the gold coin out of the mynah bird\'s cage?'
    [
        'You\'ll need a way to distract the bird. ',
        
        '\bBirds often pay special attention to other birds. ',
        
        '\bHave you looked around in the shipping department? ',
        
        '\bIn the crate in the shipping department is a mechanical nightingale. ',
        
        '\bIt\'s a wind-up nightingale. You\'ll need a suitable key. ',
        
        '\bThe key is hidden in the Easter egg. ',
        
        '\bWind up the nightingale. While it\'s singing, the mynah will be
        entranced. You can reach into the cage and take the coin. How to open
        the Easter egg is explained in a separate set of hints. '
    ]
    openWhenSeen = petShop
    closeWhenTrue = (coin4.isIn(gPlayerChar))
;

++Goal 'How can I get the putter?'
    [
        'The gap is too narrow for you to reach through it. ',
        
        '\bIf you slide something long and slim into the gap, you\'ll soon have
        the putter. ',
        
        '\bThere are two items that will do the job. ',
        
        '\bOne is the knitting needle the fortune teller will give you when you\'ve
        returned her missing cards. ',
        
        '\bThe other is the bamboo pole from the plant store. '
    ]
    openWhenExamined = kiosk
    closeWhenMoved = putter
;

++ Goal 'How can I get what the bartender wants?'
    [
        'If you asked him about himself (always a smart move), he told you he
        collects scrimshaw. He even mentioned the scrimshaw shop upstairs. ',
        
        '\bBut not just any scrimshaw. It has to have the right carving. ',
        
        '\bUntil you\'ve restored the power to the
        powered devices in Stufftown, you won\'t be able to move forward with the
        bartender\'s desire for scrimshaw. ',
        
        '\bEven after the scrimshaw machine is powered, you\'ll need to feed it five gold coins. Also, you\'ll
        need to put a large tooth into the hopper. And then you\'ll have to choose the
        right carving from a long menu. ',
        
        '\bThe tooth is up on the roof. ',
        
        '\bOnce the dragon is powered, its mouth will open and shut. ',
        
        '\bBut you can\'t grab the tooth, not while the dragon has it. You\'ll need to
        knock it loose somehow. ',
        
        '\bThis is on a miniature golf course, right? ',
        
        '\bThere\'s a putter nearby. The golf ball is further away. ',
        
        '\bBefore reading any further, you may want to get the putter and the golf ball. How
        to do that is explained in the next few hints. ',
        
        '\bThe putter is in the kiosk. You can retrieve it from the gap under the grille using
        the knitting needle. ',
        
        '\bThe golf ball is hidden in the long grass east of Stufftown. (Not the long grass
        on the grassy slope. Go north from there.) ',
        
        '\bDrop the ball on the tee and then hit it with the putter. Now you have the tooth. ',
        
        '\bYou also have the coins by now, don\'t you? If not, you\'ll need to consult a
        different set of hints. ',
        
        '\bThe final challenge is figuring out which carving to choose. Someone else can tell
        you what the bartender likes. ',
        
        '\bThere\'s a wide variety of visual imagery in the art gallery. ',
        
        '\bBut the gallery owner is too depressed to answer questions. ',
        
        '\bCheering up the art dealer is a separate challenge. ',
        
        '\bOnce you\'ve done that, he\'ll happily tell you all about his paintings, and he\'ll
        mention the one that the bartender especially likes. '
    ]
    openWhenSeen = scootersPub
    closeWhenMoved = (goodallPhoto)
;

++ Goal 'Where are the gold coins?'
    [
        'There are five of them in all. Three are visible; the other two are well hidden. In this
        set of hints you\'ll be told how to collect them all. ',
        
        '\bThe easiest one is in the niche with the palm tree, in the arched passage near the main
        entrance. Just search the urn. ',
        
        '\bThere\'s one in the diorama in the center of the arcade, but there\'s no way to open the
        top of the diorama. ',
        
        '\bTo get this coin you have to crawl under the diorama and use the screwdriver to loosen the
        metal plate. Then reach through the hole. ',
        
        '\bYou\'ll need the screwdriver for the next one as well. The screwdriver is in the stairwell.
        Once you have the shop key, you can get to the stairwell safely by entering it through the
        leather goods shop. ',
        
        '\bTo get the coin in the mynah bird\'s cage, you\'ll need to distract the mynah. You need
        two related objects to do that. ',
        
        '\bUse the screwdriver to pry open the crate in the shipping department. There\'s a mechanical
        nightingale in the crate. ',
        
        '\bThe key with which to wind up the nightingale is hidden in the Easter egg. ',
        
        '\bTo get the key out of the egg, press the orange, green, red, and violet nubs in that order. ',
        
        '\bWind up the nightingale. It will sing. The mynah will be captivated. Now you can open the
        cage and grab the coin. ',
        
        '\bThe fourth coin is in the Easter egg. Press the green, pink, blue, and violet nubs. ',
        
        '\bTo find the fifth coin, you\'ll need the U-shaped piece of metal from the safe in Flogg
        and Grabby\'s office. How you open the safe is discussed in a different set of hints. ',
        
        '\bThe U-shaped piece of metal is a money magnet. ',
        
        '\bDid you try opening the rolltop desk in the furniture store? ',
        
        '\bPoint the money magnet at the cubbyholes in the rolltop desk. The coin will drop out onto
        the desk. '
    ]
;

++ Goal 'I fell into the crypt through the hatch, and now I can\'t get out!'
    [
        'There are two other ways to get into the crypt. If you entered through
        one of these, you can exit the same way. But you say you fell in through
        the hatch in the mirror maze? ',
        
        '\bThere\'s a way to escape. ',
        
        '\bIn the mineshaft there\'s a mallet. ',
        
        '\bThe mallet has two uses. One of them is explained in a different set
        of hints. But the mallet can also be used to escape from the crypt if
        you\'ve fallen in. ',
        
        '\bTry banging on the rusty door. ',
        
        '\bThis will let you escape to the foot of the cliff. But that may seem
        to be another trap. ',
        
        '\bYou can climb the cliff, but not while carrying anything. ',
        
        '\bIf you\'ve been forced to drop your possessions at the foot of the
        cliff, you\'ll have to find another way to get back down in order to
        retrieve them. ',
        
        '\bPossibly there\'s a rope somewhere. ',
        
        '\bThe rope is behind the stairs on the hedge-bordered path. ',
        
        '\bFirst look behind the stairs, then go east. ',
        
        '\bAfter tying the rope to the pole, you can drop it over the cliff. ',
        
        '\bYou can climb up the rope while carrying a single item (which could
        be a shopping bag full of stuff). '
    ]
    openWhenSeen = ancientCrypt
;

++ Goal 'How can I get into the toy store?'
    [
        'The door is blocked from the inside. Perhaps there\'s another route. ',
        
        '\bTake a look around the west side of the upper concourse. ',
        
        '\bThe damaged hallway seems to lead in the right direction. ',
        
        '\bBut there\'s no way to get across the hole. ',
        
        '\bWhat do you suppose is under the hole? ',
        
        '\bThe restroom on the main level is directly under the hole. ',
        
        '\bOnce you have a key that unlocks the shops, you\'ll soon find a stepladder. ',
        
        '\bDrop the stepladder in the restroom, unfold it, and go up. ',
        
        '\bNow you\'ll need to unlock the door you\'ve discovered. Because you\'re
        reading these hints, you already know it\'s the back door of the toy store. ',
        
        '\bThere are actually four code combinations that will open the door. ',
        
        '\bThe name of the store is Play Toes Republic. And this is the back door. ',
        
        '\b<q>Play Toes</q> backwards ia SE OT YA LP. '
    ]
    openWhenSeen = upperPromenadeWest
    closeWhenSeen = toyShop
;

++ Goal 'What does the dinosaur want?'
    [
        'He\'s rather childlike, isn\'t he? ',
        
        '\bHave you asked him about himself? ',
        
        '\bWhat do kids like? ',
        
        '\bMaybe some candy? ',
        
        '\bOh, I know! Jellybeans! ',
        
        '\bThe jellybeans are in the Easter egg. Give them to him. (Opening the
        Easter egg is explained in a different set of hints.) '
    ]
    openWhenSeen = toyShop
    closeWhenTrue = (purpleDinosaur.friendly)
;

++ Goal 'Where can I find some jellybeans?'
    [
        'There\'s a very good chance you\'ve been carrying them around for a while
        now, without knowing it. ',
        
        '\bDid you find anything on the hedge-bordered path? If not, go have a
        careful look around. ',
        
        '\bThe jellybeans are in the Easter egg. There are three different things in
        the Easter egg. Each of the interior compartments is accessed using a different
        combination of colored buttons. ',
        
        '\bColor combinations are scattered around Stufftown. You\'ll find each combination
        listed at least twice, but you\'ll have to keep your eyes open. ',
        
        '\bThe color combination for the jellybeans can be found on the pennants flying
        from the roof of Stufftown (visible from the parking lot) and on Eustace Grabby\'s
        tie. ',
        
        '\bThe combination for the jellybeans is pink, yellow, green, blue. '
    ]
    openWhenSeen = toyShop
    closeWhenTrue = (purpleDinosaur.friendly)
;

++ Goal 'The machine in the printery needs a secret code.'
    [
        'Until you\'ve visited the toy store, you won\'t have access to the clues
        that will reveal the code. ',
        
        '\bThere\'s another room west of the toy store. ',
        
        '\bTo learn the code, you\'ll need to take a ride in the virtual capsule. ',
        
        '\bWhile riding in the capsule, keep an eye on the scenery. ',
        
        '\bThe trick is to make sure you\'ve traveled the entire route. ',
        
        '\bIn both directions. ',
        
        '\bThere are branches in the track layout. ',
        
        '\bThe lever determines whether you\'ll go left or right at a branch. ',
        
        '\bTo make it less confusing, you can play around with the diorama in the center
        of the arcade. The tracks
        in the diorama have the same layout, and the lever works the same way. ',
        
        '\bThe track is in the form of a figure 8 with outer straight tracks on both sides
        connecting the upper and lower parts of the 8. The clues you need are on the sections
        of track that cross the center of the 8. ',
        
        '\bThere are two signs with brief verses on each of the four traverses of the crisscrossing
        track segments. If you ever saw Burma-Shave signs along a rural road, the idea will be familiar. ',
        
        '\bThe next hint gives the precise set of commands you need in order to read the signs. You
        need to be careful to type Z exactly the right number of times. ',
        
        '\bpush button, move lever right, z, z, z, z, move lever left,
        z, z, z, z, z, z, z, move lever right, z, z, z, z,
        move lever left, z, z, z, z, z, out ',
        
        '\bThe trick is to assemble the verses on the signs in the right order. What rhymes with
        what? ',
        
        '\bIf you\'ve done the run correctly and kept your eyes open, you\'ll have the following four verses:
        <q>Time to kick off who you\'ll be, Get a fresh start by choosing
        three,</q> <q>A second do not hesitate, What you
        need next must be an eight,</q> <q>Continuing will be such fun,
        You\'re almost done when you choose one,</q> and
        <q>At last your new life will arrive, If you have used a final five.</q> ',
        
        '\bThe code for using the machine in the printery is 3815. '
    ]
    openWhenSeen = printery
;

// -----------------------------------------------------
// In the shops, part 3
// -----------------------------------------------------

+ HintMenu 'In the Shops, Part 3'
;

++ Goal 'How do I open the shipping crate?'
    [
        'The lid is attached pretty firmly, but not perfectly. ',
        
        '\bPossibly you might be able to pry it open. ',
        
        '\bDo you have a tool with a slim blade? ',
        
        '\bNot the saw. Its blade would be too floppy. And most of the rest
        of the things you may have will be too thick to slip into a narrow
        gap. ',
        
        '\bHow about the screwdriver? That\'s the ticket. You can pry up
        the lid with the screwdriver. '
    ]
    openWhenSeen = shippingDepartment
    closeWhenMoved = nightingale
;

++ Goal 'I\'m wandering around in the plant store maze. Help!'
    [
        'This maze is lawful, not random. ',
        
        '\bHowever, it can\'t be mapped using the canonical method of dropping
        things, as you\'ll discover if you try it. ',
        
        '\bInstead, you need to take a close look at your surroundings. ',
        
        '\bDon\'t want to fuss with all that? Then go down (D). This will take you
        reliably back to the plant store from any location in the maze. ',
        
        '\bIf you\'re keen to make a map, though, you can do it.
        Stand still and observe the flowers. Each time you look at them, they\'ll
        change color. And each room has a unique combination of flower type and color
        sequence. ',
        
        '\bThere are nine rooms in the maze, and it would take you a while to develop
        a map. So.... ',
        
        '\bFrom the location where you enter the maze from the plant store, go
        northwest twice, and then east. That will take you to the secluded lair. ',
        
        '\bTo return from the secluded lair to the plant store, go north, then east,
        then northeast. '
    ]
    openWhenSeen = PM1
;

++ Goal 'How can I get into the safe in Stuff World Headquarters?'
    [
        'First, you\'ll need to get rid of Flogg and Grabby. They\'re
        not going to let you anywhere near the safe while they\'re there. ',
        
        '\bTake a look at the cars in the employee parking lot. ',
        
        '\bOne of them has a license plate that will suggest the name of the owner. ',
        
        '\bIt\'s a cinch Eustace Grabby is proud of his new Lamborghini. ',
        
        '\bIt would be a shame if something happened to it. ',
        
        '\bLike, if it happened to roll down the slope of the parking lot into the creek. ',
        
        '\bHave you tried getting in the Lamborghini? ',
        
        '\bYou can release the brake lever. Then get out of the car quickly! ',
        
        '\bOnce the car is wrecked, you can tell Grabby about it. ',
        
        '\bYou can even do this before you have the master key to the shops. But when they
        leave the office they will lock the door. You\'ll need the key to get back in. The
        business of acquiring the key is explained in a separate set of hints. ',
        
        '\bLook under their desks. ',
        
        '\bEach desk has a button. ',
        
        '\bIs it possible Flogg and Grabby don\'t trust one another? ',
        
        '\bMaybe both buttons need to be pressed at once for the safe door to open. ',
        
        '\bYou\'ll need an ally. ',
        
        '\bNo, the hairdresser won\'t help you with this one. ',
        
        '\bHow about the homeless guy? ',
        
        '\bBefriending him is explained in a different set of hints. Once he\'s on your side
        he will follow you to the World Headquarters office. ',
        
        '\bTell him to hold one of the buttons. Then press the other one yourself. '
    ]
    openWhenSeen = worldHeadquarters
    closeWhenTrue = (safeDoor.isOpen)
;

++ Goal 'How can I find the mannequin in the mirror maze?'
    [
        'You\'ll need an ally. ',
        
        '\bOnce you\'ve befriended the homeless man, he\'ll mention that he\'s
        good at finding things. ',
        
        '\bBut he\'s also being distracted by some invisible pixies. Dealing with
        the pixies is explained in a different set of hints. ',
        
        '\bIn the olden days, psychics were reputed to be able to find underground
        water using a dowsing rod. ',
        
        '\bA dowsing rod is basically just a forked stick. ',
        
        '\bThere\'s a forked stick not far from the foot of the cliff. How to climb down
        the cliff is explained in a different set of hints. ',
        
        '\bGive Joe (that\'s his name, Joe) the dowsing rod and tell him to follow you.
        He will follow you to the fashion boutique. When you get there, he will unerringly
        pilot you through the dressing room mirror maze to where the mannequin is hiding. '
    ]
    openWhenTrue = (spilledCombs.isIn(hotRags))
    closeWhenTrue = (bianca.isIn(behindCaboosePanel))
;

++ Goal 'How can I get at whatever is under the grate in the patio?'
    [
        'If you haven\'t yet found the screwdriver, look in the stairwell. If
        you haven\'t yet found the stairwell, don\'t worry about the grate quite yet. ',
        
        '\bYou can pry open the grate using the screwdriver. ',
        
        '\bAh, but the ooze is a different kettle of snot. ',
        
        '\bThe green color might suggest that it\'s alive and of the vegetative variety. ',
        
        '\bHave you seen any weed killer anywhere? ',
        
        '\bPour the BioBGone from the plant store on the ooze. It will die. ',
        
        '\bNow you can reach into the grate and find what\'s there. '
    ]
    openWhenSeen = patio
    closeWhenTrue = (signetRing.isIn(me))
;

// -----------------------------------------------------
// In the jungle, the mighty jungle...
// -----------------------------------------------------

+ HintMenu 'In the jungle'
;

++ Goal 'How can I get past the ocelot?'
    [
        'How about an animal tranquilizer? ',
        
        '\bUsually they\'re fired at the animal from a safe distance. ',
        
        '\bYou don\'t have a tranquilizer gun. You\'ll have to improvise one. ',
        
        '\bYou\'ll need a dart, some sort of tranquilizer, and a way to shoot
        the dart at the ocelot. ',
        
        '\bThere\'s a dart in the billiard room behind the pub. If you\'ve gotten
        this far, you\'ve been to the billiard room. ',
        
        '\bDentists often use a preparation to numb their patients\' gums. ',
        
        '\bYou can dip the point of the dart in the bottle of StunGums 
        from the dentist\'s office. ',
        
        '\bAnd how about a blowgun? ',
        
        '\bThe hollow bamboo tube in the plant store would seem nearly ideal. ',
        
        '\bBut first you\'ll have to clear it out. ',
        
        '\bWhen you give the seeress what she needs, she\'ll give you a knitting needle. You
        can clean out the tube with the knitting needle. ',
        
        '\bAfter that it\'s easy. Put the dart in the blowgun and blow. '
    ]
    openWhenSeen = jungleClearing
    closeWhenSeen = buddhaClearing
;

++ Goal 'Is the clearing by the Buddha statue a dead end?'
    [
        'Definitely not. ',
        
        '\bYou can\'t fight your way through the jungle yourself, however. You don\'t have
        a machete. ',
        
        '\bThe statue itself will help you. ',
        
        '\bThere are shafts of sunlight lancing down through the trees. ',
        
        '\bAnd the Buddha has a jewel in its forehead. ',
        
        '\bIf only you could aim one of the shafts of sunlight at the jewel.... ',
        
        '\bThat\'s what the makeup mirror in your purse is for. Hold the mirror in the
        sunlight, and then aim the beam of sunlight at the Buddha. The Buddha will react.
        Now you can go on and find what you\'re hoping to find in the jungle. '
    ]
    openWhenSeen = buddhaClearing
    closeWhenSeen = carpetOfSticks
;

++ Goal 'How can I get the monkeys to follow me?'
    [
        'The monkeys are amenable to persuasion, but convincing them will require a little effort. ',
        
        '\bFirst, you need to convince them that you\'re their friend. ',
        
        '\bThey don\'t understand human speech, but you might be able to show them something that
        would impress upon them your bona fides. ',
        
        '\bSuch as maybe a photo that they would recognize. ',
        
        '\bThe bartender has several photos in his collection. ',
        
        '\bOne of the photos is of famed primatologist Jane Goodall. That\'s the one you want.
        How you get him to give it to you is explained in a different set of hints. ',
        
        '\bOnce you\'ve shown the Goodall photo to the monkeys, you\'re halfway home. ',
        
        '\bSome researchers have had remarkable success teaching chimpanzees to use American
        Sign Language (ASL). ',
        
        '\bIf you\'ve looked around at all the shops in Stufftown, you will probably have found
        an unlikely but efficient way to learn ASL. ',
        
        '\bThere\'s a little white pill in the dentist\'s office. ',
        
        '\bOnce you TAKE PILL (twice, the first time to acquire it, the second time to eat it,
        but be aware that in some circumstances the game\'s software may misinterpret your
        second TAKE command),
        commands like SIGN FOLLOW and SIGN STAY will work very nicely with the monkeys. '
    ]
    openWhenSeen = carpetOfSticks
;

// -----------------------------------------------------
// The other characters
// -----------------------------------------------------

+ HintMenu 'Interacting with the people you meet'
;

++ Goal 'Am I going to have the hairdresser following me around
    all afternoon?'
    [
        'Annoying, isn&rsquo;t she? ',
        
        '\bIn the opening stage of your adventure, she will be an important ally. Without her, you
        wouldn&rsquo;t be able to solve an important problem. (The specifics are revealed in a different
        set of hints.) After that, she will become a serious hindrance. You&rsquo;ll
        need to figure out how to get rid of her. ',
        
        '\bUntil you&rsquo;ve acquired the master key to the shops, you shouldn&rsquo;t read any further. ',
        
        '\bHave you noticed that she claims to have stopped smoking? ',
        
        '\bVarious indications might suggest that she&rsquo;s not being honest about that. ',
        
        '\bTaking advantage of a smoker&rsquo;s weakness would, in most cases, be morally repugnant. But
        if you&rsquo;ve been paying close attention, you&rsquo;ll have a reason not to be <i>too</i> concerned
        about her well-being. ',
        
        '\bYes, she really did steal your grandmother&rsquo;s ring. So you needn&rsquo;t feel guilty about
        playing a dirty trick on her. ',
        
        '\bIf she had an opportunity to sneak a secret smoke, she would probably seize it. ',
        
        '\bIn fact, it&rsquo;s a good bet she does this even while she&rsquo;s at work. ',
        
        '\bShe would need a place close to her work station where she could light up unobserved. ',
        
        '\bThe closet in the beauty shop, for example. ',
        
        '\bHave you taken a close look at the door of the closet? ',
        
        '\bIt can be locked from the outside. ',
        
        '\bIf you had a pack of cigarettes and some matches, you could leave them in the closet for her to find.... ',
        
        '\b...and then tell her about them. ',
        
        '\bThe cigarettes and matches are in the smoke shop. ',
        
        '\bOnce she&rsquo;s in the closet, simply lock the door. Cruel, certainly -- but she did steal your grandmother&rsquo;s ring,
        so you needn&rsquo;t feel too guilty. '
    ]
    openWhenSeen = beautyParlor
    closeWhenTrue = (betsy.isIn(nil))
    topicOrder = 520
;

++ Goal 'How can the fortune teller help me?'
    [
        'She can do a couple of things for you. But first you\'ll need to do her
        a favor. ',
        
        '\bUntil you\'ve managed to operate the Octagonal Room, you won\'t have anything
        she wants or needs. ',
        
        '\bFortune tellers often make use of Tarot cards. Have you seen any cards
        anywhere in Stufftown? ',
        
        '\bThere are three card players in the garden east of the Octagonal Room. ',
        
        '\bThe way to get the cards away from them is explained in a different set of
        hints. ',
        
        '\bOnce you have the cards, give them to the fortune teller. ',
        
        '\bShe will give you a knitting needle, which you\'ll find very useful. ',
        
        '\bBut that\'s not all. The other service she\'ll provide is explained in a different
        set of hints. '
    ]
    openWhenSeen = seeressLair
;

++ Goal 'Are the card players important?'
    [
        'They are indeed. They have something you\'ll need. ',
        
        '\bBut getting it from them will be a little tricky. ',
        
        '\bYou need to know something about what\'s going on in that card game. And
        no matter how long you stand there watching, you\'ll never see it. ',
        
        '\bThe key phrase in that last hint is, <q>While you\'re standing there.</q> ',
        
        '\bIs there some other place from which you could observe them? ',
        
        '\bThere\'s a balcony on the north side of the octagonal tower. ',
        
        '\bAh, but they\'re too far away for you to make out any detail. ',
        
        '\bIf only there were a way to get a closer view without leaving the balcony. ',
        
        '\bIn the optician\'s office there\'s a telescope. ',
        
        '\bTake the telescope up to the balcony and look at the card players through it. ',
        
        '\bYou\'ll see that one of them is cheating! ',
        
        '\bOnce you\'ve observed the cheating, you can go down to the garden and mention
        cheating to them. (You can\'t do this until you\'ve actually observed it through
        the telescope. No shortcuts, sorry.) ',
        
        '\bThey\'ll start fighting and run off. But they\'ll leave the cards behind. '
    ]
    openWhenSeen = untendedGarden
    closeWhenTrue = (playingCards.isIn(gPlayerChar))
;

++ Goal 'How can I cheer up the art dealer?'
    [
        'He might respond well if you bring him something that\'s unexpectedly delightful. ',
        
        '\bHave you noticed the sculpture in the gallery? It looks like a weird birdbath. ',
        
        '\bPossibly it could contain a fluid. ',
        
        '\bThere are several sources of fluid in Stufftown, but a fluid by itself is
        not likely to do the trick. ',
        
        '\bMaybe if there was something delightful <i>in</i> the fluid. ',
        
        '\bHave you been downstairs to the pet shop? ',
        
        '\bThat fish is quite remarkable, isn\'t it? ',
        
        '\bIf only there were some way to bring the fish upstairs to the art gallery.... ',
        
        '\bA container that could carry a quantity of water, and the fish along with it.... ',
        
        '\bNo, the large pot from the pottery store won\'t do it. Have you been down
        to the amphitheater? ',
        
        '\bIn the wardrobe closet backstage is an old-fashioned metal army helmet. ',
        
        '\bYou can scoop the fish into the helmet, bring it up to the art gallery, and
        pour it into the birdbath. That will delight him. What you\'ll accomplish by
        cheering him up is mentioned in a different set of hints. '
    ]
    openWhenSeen = artGallery
    closeWhenTrue = (archibald.curState == archibaldCheerful)
;

++ Goal 'How can the homeless man help me?'
    [
        'He can do a couple of things for you. But before he will help you,
        you\'ll need to help him. ',
        
        '\bHave you taken a close look at him? ',
        
        '\bHe already has a hat, but he could probably use some shoes. ',
        
        '\bThere\'s a pair of boots backstage in the wardrobe closet. ',
        
        '\bOnce you\'ve given him the boots, he will happily follow you here 
        or there. ',
        
        '\bAt this point, there\'s a simple task he can help you with, but
        he can\'t yet undertake anything that\'s more challenging, because the
        pixies distract him. ',
        
        '\bIn order to get rid of the pixies, you\'ll need to be able to see them. ',
        
        '\bA telescope or microscope would be no use at all, but perhaps they
        would become visible in a cloud of smoke. ',
        
        '\bAt a certain point, the wooden Indian will give you a cigar. With the
        cigar and a matchbook (which you will quite likely have found by now), you can
        light the cigar and make a cloud of smoke. ',
        
        '\bBut the pixies will still be too fleet for you to grab them. ',
        
        '\bThere\'s no fine-meshed net to be found anywhere, but by now you have
        surely seen something you could use. ',
        
        '\bYou can catch the pixies in the scarf you found in the wardrobe closet. ',
        
        '\bBut they\'ll soon escape and go back to tormenting the poor guy. ',
        
        '\bHave you noticed anything that might cause them to become dazed or
        absent-minded? ',
        
        '\bUntil you\'ve found and then lost the prom dress, you won\'t have what
        you need. ',
        
        '\bAmong the combs that have spilled on the floor of the fashion boutique
        is a key that unlocks the display case there. ',
        
        '\bIn the display case is a bottle of really boring perfume. ',
        
        '\bAfter catching the pixies in the scarf, pour the boring perfume on them.
        They will fly away. And now the homeless man will be able to help you with
        a more complicated problem. The things he can do for you are explained in
        other sets of hints. '
    ]
    openWhenSeen = joe
;

++ Goal 'Is there something hidden in the rolltop desk?'
    [
        'If you open the desk, you\'ll spot the parchment. But there might be
        something else. ',
        
        '\bSearching the cubbyholes won\'t work. There are too many of them. ',
        
        '\bPlainly you\'re hoping to find something small in there. And (here\'s
        a hint) in the old days a rolltop desk might well have been used by
        an accountant. ',
        
        '\bThere\'s a gold coin in one of the cubbyholes. The trick is to get it
        to pop out where you can see it. ',
        
        '\bHave you ever wondered why Flogg and Grabby are such successful businessmen? ',
        
        '\bIt\'s almost as if they have a money magnet. ',
        
        '\bIf there is such a thing, it\'s bound to be kept in the safe in their
        office. ',
        
        '\bBut in spite of their bonhomie, they don\'t really trust one another. ',
        
        '\bThey have to work together to open the safe. ',
        
        '\bLook under their desks. ',
        
        '\bYou can\'t push both buttons at once. You\'ll need an ally. ',
        
        '\bIf the homeless man is kindly disposed toward you, he\'ll happily follow
        you to the office and hold one button while you press the other. ',
        
        '\bOnce you have the money magnet, you can wave it at the cubbyholes, or
        touch the cubbyholes with it, or point it at the cubbyholes. The gold coin
        will pop out. '
    ]
    openWhenSeen = grandmasDrawers
;

++ Goal 'How can I get the vine seeds to grow?'
    [
        'A bottle of MiraklGro would probably do the trick. ',
        
        '\bToo bad the rack is empty. But there may be a bottle of the stuff somewhere nearby. ',
        
        '\bThere\'s a way to make your way reliably through the nearby maze. That method is
        explained in a different set of hints. There\'s also an alternate route to the
        MiraklGro, via the Octagonal Room. ',
        
        '\bHowever, the marionettes won\'t want to give it to you. You\'ll need to appease
        them somehow. ',
        
        '\bHave you asked them about themselves? (You\'ll need to ask them more than once.) ',
        
        '\bThey wish they had better costumes. Colorful capes, specifically. ',
        
        '\bSomewhere downstairs is a big piece of cloth that\'s not good for much else. ',
        
        '\bYou might be able to cut apart the tattered cloak in the cloak room, if you had
        a pair of scissors. ',
        
        '\bThe scissors are in the gift shop. Cut the cloak apart and give the scraps to
        the marionettes. Now they\'ll be happy to let you take the MiraklGro. '
    ]
    openWhenSeen = greenFriends
    closeWhenTrue = (miraklGro.isIn(gPlayerChar))
;

++ Goal 'How can the bartender help me?'
    [
        'For the most part, the bartender is just a chatty source of information.
        But at a certain point you\'ll need to get something from him. ',
        
        '\bHave you noticed his fine collection of autographed photos? ',
        
        '\bMost of them are just scenery, but one of them is very useful indeed. ',
        
        '\bBut you won\'t need it until you\'ve learned to operate the TARZAN. ',
        
        '\bJane Goodall was (and may still be) a leading expert on chimpanzees. ',
        
        '\bShe would have made many friends among the chimpanzee population. ',
        
        '\bThat\'s the photo you want. But how to acquire it? What might the
        bartender want in exchange for it? ',
        
        '\bSomeone may have told you that he\'s a great admirer of scrimshaw. ',
        
        '\bIf you had a large tooth, you could surely carve an image onto it using the
        scrimshaw machine. ',
        
        '\bBut which image? There are so many to choose from! Another of the people you\'ll
        meet can tell you what the bartender likes in the way of imagery. ',
        
        '\bThe man in the art gallery has a lot of imagery. But he\'s too depressed to
        be very communicative. How you cheer him up is explained in another set of hints. ',
        
        '\bOnce he has cheered up, ask him about the paintings. ',
        
        '\bUsing his comment about the bartender, you\'ll know which carving to choose
        on the scrimshaw machine. Finding a suitable tooth is a separate problem, and
        is explained in a different set of hints. ',
        
        '\bGive the correctly carved tooth to the bartender and tell him you\'d like
        the Jane Goodall photo. '
    ]
    openWhenSeen = steve
;

++ Goal 'Where\'s the wizard?'
    [
        'The wizard will arrive in response to something you do on the roof. ',
        
        '\bUntil you\'ve restored electrical power to the powered devices in Stufftown, you
        won\'t be able to summon him. ',
        
        '\bThere are two areas on the roof. One area can be accessed only via
        the Octagonal Room. ',
        
        '\bFrom the Octagonal Room you can reach a ledge where there\'s an interesting-looking
        trough. ',
        
        '\bIt might even be a feeding trough for something large. ',
        
        '\bHave you looked around downstairs in the pet shop? ',
        
        '\bPterodactyls are extinct, or so one would assume, but they were flying reptiles.
        If there <i>were</i> a pterodactyl nearby, it might be used to dining from that trough. ',
        
        '\bGetting the pterodactyl chow up to the roof, however ... it\'s too heavy to carry
        very far. ',
        
        '\bIs there a convenient transportation device anywhere? ',
        
        '\bHow about the little red wagon in the toy store? ',
        
        '\bIf you pull the wagon downstairs to the pet shop, load the chow into the wagon,
        and then pull the wagon up to the roof, you\'ll be able to attract the pterodactyl.
        You\'ll find that the wizard is riding on the pterodactyl. ',
        
        '\bBut of course the wagon can\'t roll up or down the stairs. You can use the
        Octagonal Room to get it down from the upper level to the lower level, but there\'s
        another method that\'s easier. ',
        
        '\bYou can move the wagon from floor to floor (though not up to the roof) in
        the elevator. '
    ]
    openWhenTrue = (bianca.isIn(behindCaboosePanel) == true)
;

// -----------------------------------------------------
// The big stuff
// -----------------------------------------------------

+ HintMenu 'What the Wizard Wants'
;

++ Goal 'What does the wizard want?'
    [
        'The wizard will need some specific things in order to do the magic
        spell that will allow you to retrieve the prom dress. ',
        
        '\bIf you tell him about the mannequin, he will list the items
            <<zarbolphung.listingItems()>>for you. ',
        
        '\bHe will also mention a couple of conditions that need to be in
        place, that are not things you can hand to him. ',
        
        '\bAlso, of course, he needs to be kindly disposed toward you. There\'s
        something that will cheer him up. That\'s explained in a separate set
        of hints. ',
        
        '\bThe things he needs you to give him are: a child\'s toy top, a bottle
        of gold paint, a little paintbrush, some marigolds, the toe bone of a
        mummy, and proper (forged, but we won\'t quibble about that) identification
        papers for the mannequin and the wooden soldier. ',
        
        '\bIn addition, you\'ll need to bring the soldier and the mannequin to
        the Chartreuse Caboose, set the mirror ball in its ceiling spinning,
        and find a properly trained dance orchestra to play some music while the
        two of them dance. ',
        
        '\bShould be a piece of cake, right? Good luck! '
    ]
    openWhenTrue = (zarbolphung.seen)
;

++ Goal 'Where is the wizard\'s crystal ball?'
    [
        'It\'s hidden in plain sight. That is, it\'s invisible. ',
        
        '\bA crystal ball is clear. You can see right through it. ',
        
        '\bWhat else might you be able to see clear through without noticing
        a crystal ball? ',
        
        '\bPerhaps it has fallen into the water. ',
        
        '\bBut not the creek. And it\'s not in the restroom. ',
        
        '\bThere\'s a pool of water in the garden. ',
        
        '\bBut searching the pool won\'t reveal the crystal ball. ',
        
        '\bPossibly the angel could help. ',
        
        '\bWhat could you give to an angel? ',
        
        '\bThere\'s a harp in the music store. ',
        
        '\bGive the harp to the angel. As the angel plays the harp, the
        crystal ball will rise to the surface of the pond. '
    ]
    openWhenTrue = (zarbolphung.itemsListed == true)
    closeWhenTrue = (crystalBall.isIn(me) == true)
;

++ Goal 'How can I learn ASL?'
    [
        'When using ASL (American Sign Language) you won\'t use your mouth. ',
        
        '\bSomewhere in Stufftown you may have seen a shop where a poster of
        a mouth was displayed. ',
        
        '\bHave a look around the dentist\'s office (the Filling Station). ',
        
        '\bThere\'s a little box on the wall, and there\'s a pill in the
        box. ',
        
        '\bIf you take the pill (that is, pick it up) and then eat it, you\'ll
        instantly be able to use ASL. ',
        
        '\bOnce you\'ve made friends with the monkeys, you can give them
        orders using commands like SIGN FOLLOW and SIGN WAIT. ',
        
        '\bBut they won\'t obey until you\'ve done something to convince them
        you\'re a friend. The solution to that challenge is explained in a
        different set of hints. '
    ]
    openWhenSeen = carpetOfSticks
;

++ Goal 'Where are the marigolds?'
    [
        'Have you looked around in the garden? ',
        
        '\bThey\'re growing on the north side of the tower, beneath the balcony. ',
        
        '\bHow to reach the garden is explained in a different set of hints. (Hint: You
        get there from the Octagonal Room.) '
    ]
    openWhenTrue = (zarbolphung.itemsListed == true)
    closeWhenTrue = (bunchOfMarigolds.isIn(me) == true)
;
    
++ Goal 'Where will I find the mummy?'
    [
        'A mummy is usually to be found in a sarcophagus. Should I assume you
        haven\'t yet located the sarcophagus? Well, the wizard mentioned it\'s
        down on the lower level. ',
        
        '\bBut he may not have meant the lower level of the shopping center.
        Is it possible there\'s another level even lower down? ',
        
        '\bThere are three (or even four) ways to reach the ancient crypt below Stufftown. ',
        
        '\bUnfortunately, three of them won\'t be of much use to you, other than perhaps
        for purposes of exploration. ',
        
        '\bOnce you\'ve learned to operate the Octagonal Room, you can get to the crypt
        from the jewel-encrusted grotto. ',
        
        '\bBut that route takes you through the bat cave, and in the bat cave you\'ll
        tend to drop things. This route is not good. ',
        
        '\bThere\'s also a hatch in the mirror maze, but that route is not useful either. ',
        
        '\bWhat you need is to use the elevator. ',
        
        '\bThe elevator seems to have only three buttons, one for the upper level, one for
        the main level, and one for the lower level. ',
        
        '\bBut in fact there are four buttons. ',
        
        '\bHave you tried loosening the screws on the plate using the screwdriver? ',
        
        '\bOnce the screws are loosened, you\'ll be able to push the plate up or down. When
        it\'s in its down position, the bottom button will take you to the subterranean level. ',
        
        '\bYou\'ll need to use the elevator in order to solve the mummy problem, but the
        solution to that puzzle is in a different set of hints. '
        
    ]
    openWhenTrue = (zarbolphung.itemsListed == true)
;

++ Goal 'How can I get the mummy\'s toe bone?'
    [
        'This is one of the more fraught difficulties you\'ll encounter in your quest.
        You\'ll need items from several different locations. So buckle up --- this is going
        to be a long set of hints. ',
        
        '\bFor starters, you need to get the lid off of the sarcophagus. ',
        
        '\bIt\'s too heavy to lift, and this time the hairdresser won\'t be there to
        help you. ',
        
        '\bThe item you need is close at hand. ',
        
        '\bIn the mineshaft you\'ll find a mallet. ',
        
        '\bBang on the lid repeatedly until the mummy lifts it. ',
        
        '\bTo saw off the mummy\'s toe, you\'ll need a saw. ',
        
        '\bHave you noticed that one of the stores is under reconstruction? ',
        
        '\bThere\'s a saw in the store that used to be called Racquet Science. ',
        
        '\bHowever, the mummy is not going to passively let you saw off his toe. ',
        
        '\bYou\'ll need to restrain him somehow. ',
        
        '\bNo, the rope won\'t do the trick. This is not a rope trick. ',
        
        '\bHow about some vines? If only there were a way to grow vines down here in the
        crypt, and in a hurry.... ',
        
        '\bYou\'ll find an envelope full of vine seeds in the plant store. Now you need
        something to grow them in. ',
        
        '\bMaybe a large pot? There\'s a large pot in the pottery store. ',
        
        '\bBut of course you\'ll need to fill the pot with dirt. ',
        
        '\bAlso, when it\'s full of dirt, it will be too heavy to carry. ',
        
        '\bThere\'s a patch of bare dirt on the slope above the amphitheater. ',
        
        '\bYou\'ll need a way to scoop the dirt into the pot. ',
        
        '\bThere\'s no shovel in Stufftown, but there\'s something you can use. ',
        
        '\bThe army helmet from the wardrobe closet can be used to fill the pot with dirt. ',
        
        '\bTo transport it to the crypt ... hmm, what means of transport have you
        noticed? ',
        
        '\bThe little red wagon from the toy store can be used to transport the filled
        pot. Getting the wagon out of the toy store is pretty easy. That\'s explained
        in a different set of hints. ',
        
        '\bThere\'s only one way to get the wagon down to the crypt. You\'ll have to use
        the elevator. The use of the elevator is explained in a different set of hints. ',
        
        '\bThere\'s one more thing you\'ll need --- a bottle of MiraklGro. ',
        
        '\bThe MiraklGro rack in the plant store is empty, but there may be a bottle of
        the stuff nearby. ',
        
        '\bThere are two routes to the location of the MiraklGro. One is via the Octagonal
        Room; the other is through the plant store maze. ',
        
        '\bGetting your hands on the MiraklGro is explained in a different set of hints. ',
        
        '\bOnce you have the seeds, the pot filled with dirt in the wagon, and the MiraklGro,
        you can pull the wagon down to the crypt, release the mummy if you haven\'t done so
        already, and then put the seeds in the pot and pour MiraklGro into the pot. The
        vines will trap the mummy, and you can saw off his toe. See, wasn\'t that easy? '
        
    ]
    openWhenTrue = (zarbolphung.itemsListed && ancientCrypt.visited)
;

++ Goal 'The wizard says I have to have identity papers for the new humans!'
    [
        'I\'ll bet Pinocchio never needed any papers, but magic is harder
        to manage these days than it used to be.
        Since you\'re not an accomplished forger of legal documents, you\'ll need to find a
        way to supply the papers using resources that are available to you in Stufftown. ',
        
        '\bNone of the people here can help you. ',
        
        '\bAmazingly enough, there\'s a machine that can print up the papers while you wait. ',
        
        '\bHave you seen any indication that anything else can be printed up while you wait? ',
        
        '\bThere\'s a sign to that effect in the bookstore. ',
        
        '\bThe machine is in a secret room behind the bookstore. The method for
        getting into the secret room is tucked away in another set of hints. ',
        
        '\bIn order to operate the Identikit machine, you\'ll need to know the secret code. ',
        
        '\bTo learn the code, you\'ll need to ride around in the Virtual Capsule in the toy
        store, observe carefully, and make sure you haven\'t missed anything. ',
        
        '\bIn the next hint, the code is revealed. ',
        
        '\bThe code for operating the Identikit machine is 3815. However, there\'s still one other
        bit that you need to take care of. ',
        
        '\bThe machine needs to see photos. Can\'t print up a driver\'s license without a photo. ',
        
        '\bYou already have something that will work as a camera. ',
        
        '\bYou can take a photo of the soldier at any time. When you encounter Bianca.
        take a photo of her too. ',
        
        '\bYou can attach the camera to the Identikit machine using the data cable. '
    ]
    openWhenTrue = (zarbolphung.itemsListed)
;

++ Goal 'How do I get the mirror ball spinning?'
    [
        'It\'s attached to the ceiling. (And you can\'t reach it up there.) ',
        
        '\bPossibly something on the floor above could be set spinning. ',
        
        '\bThe night club is directly below the pottery shop. ',
        
        '\bTo get the mirror ball spinning, you need to get the potter\'s wheel
        spinning. The method for doing that is explained in a different set of hints. '
    ]
;

++ Goal 'Where can I find a dance orchestra, for Pete\'s sake???'
    [
        'This is going to take some explaining. To start with, you won\'t find
        a bunch of musicians anywhere. ',
        
        '\bNot <i>human</i> musicians, that is. And they won\'t initially be trained as
        musicians, so you\'ll have to deal with getting them trained too. ',
        
        '\bYour first challenge will be to learn to operate the T.A.R.Z.A.N. in the
        travel bureau. ',
        
        '\bThe code that will let you take the T.A.R.Z.A.N. to where you need to go is
        in the leather-bound book that Sir Ralph has. If you haven\'t met Sir Ralph
        yet, head down to the gift shop or the antique furniture store and have a look
        around. (Escaping from Sir Ralph is explained in a different set of hints.) ',
        
        '\bUnfortunately, the book is very large. You\'ll need some help finding the right
        page. ',
        
        '\bQuite likely, you\'ve already met someone who could help you communicate with
        a ghost. ',
        
        '\bMadame Bloviatsky would be happy to help, but she needs her Tarot cards. That
        challenge, too, is explained in a different set of hints. ',
        
        '\bOnce she has the cards, you can tell her to summon the ghost. In the next hint,
        you\'ll be given the code. ',
        
        '\bTo get to the remote location, enter 563912. To return to Stufftown, enter 100000. ',
        
        '\bOkay, now you know how to pilot the T.A.R.Z.A.N. You\'ll find yourself in a remote
        jungle location, where you\'ll be confronted by a hostile ocelot. ',
        
        '\bThe ocelot and the next challenge after that are explained in other sets of hints. ',
        
        '\bSo now you\'ve found the monkeys. To recruit them, you\'ll need two other tricks. ',
        
        '\bMonkeys are primates. ',
        
        '\bHave you noticed a photo of a famous primatologist anywhere? ',
        
        '\bThe monkeys will recognize the photo of Jane Goodall. You can get that from the
        bartender, if you\'re clever about it. (And you guessed it, that\'s explained in a
        different set of hints.) ',
        
        '\bBut the monkeys don\'t understand human language, so you can\'t exactly give them
        orders. ',
        
        '\bNot by speaking, anyway. ',
        
        '\bIn the dentist\'s office you may have noticed a box on the wall containing a little
        white pill. ',
        
        '\bIf you take the pill (after taking the pill, that is), you will instantly know
        American Sign Language. ',
        
        '\bA few chimpanzees in captivity have learned to communicate using ASL. ',
        
        '\bIf you\'ve taken the pill, you can use commands such as SIGN FOLLOW and
        SIGN WAIT with the monkeys. Take them
        back to Stufftown with you in the T.A.R.Z.A.N. ',
        
        '\bAnd then upstairs to the music store. ',
        
        '\bThey\'ll grab the instruments when you show them the instruments (or simply TAKE
        the instruments when they\'re in the shop), but they don\'t know how to <i>play</i>
        the instruments. ',
        
        '\bHave you looked behind the piano? ',
        
        '\bThe DVD looks like just the ticket. But you need a DVD player. ',
        
        '\bTake the instructional DVD from behind the piano and escort the monkeys downstairs to
        the office of the video psychiatrist. Play the DVD in the DVD player. As an added bonus,
        you\'ll learn to play the trumpet. ',
        
        '\bNow lead the monkeys to the Chartreuse Caboose, and you\'ve got a dance band! '
    ]
    openWhenTrue = (zarbolphung.itemsListed)
;

++ Goal 'How do I get the wooden soldier to cooperate?'
    [
        'Soldiers traditionally follow orders. ',
        
        '\bBut first they need a bugle call. ',
        
        '\bYou have surely found a trumpet by now. ',
        
        '\bIt\'s in the trash can by the main entrance. The difficulty is, you don\'t know how
        to play it. ',
        
        '\bYou need some quick music lessons. ',
        
        '\bThere are no teachers on call in the music shop, but there might be something else there
        that would serve the purpose. ',
        
        '\bLook behind the piano. An instructional DVD has fallen down there. ',
        
        '\bDown on the lower level somewhere, there\'s a DVD player. ',
        
        '\bPut the DVD in the player in the video psychiatrist\'s office and play it. Now you know
        how to play the trumpet. ',
        
        '\bAfter you play the trumpet, the soldier will respond to your commands, but he still won\'t
        follow your orders. He insists you\'re not his commanding officer. ',
        
        '\bThe parchment you\'ll find in the rolltop desk in the furniture store would seem to be
        almost ideal. ',
        
        '\bBut it\'s not quite enough. It\'s missing something. ',
        
        '\bIt needs an official seal. ',
        
        '\bA seal in red wax, into which has been pressed a signet ring. ',
        
        '\bThere\'s a candle stub in the jewel-encrusted grotto. You can get to the grotto using
        the Octagonal Room or venture through the bat cave off of the crypt. The bat cave is not
        a very reliable route, however. The Octagonal Room is safer. ',
        
        '\bAnd of course you will have found the matches in the smoke shop. Now about the signet ring.... ',
        
        '\bThe ring has fallen into the grate in the patio. Getting it out is explained in a different
        set of hints. ',
        
        'Drip a blob of wax onto the parchment, press the ring into the wax, and show the parchment to
        the soldier. Now he will follow your orders. You can lead him downstairs to the Chartreuse
        Caboose, which I certainly hope you will have figured out is where he needs to be. '
    ]
    openWhenSeen = marchingOff
    closeWhenTrue = (ajou.curState == ajouAmenable)
;
